prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "3",
        "sequence_name": "sp|P68206|YJBJ_ECOLI",
        "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
        "proteoform_id": "3",
        "prsm_number": "13",
        "prsm": [
            {
                "prsm_id": "69",
                "p_value": "2.61e-14",
                "e_value": "2.61e-14",
                "fdr": "0",
                "matched_fragment_number": "22",
                "matched_peak_number": "27",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "85",
                        "ms1_scans": "179",
                        "ids": "93",
                        "scans": "180",
                        "precursor_mono_mass": "8320.0672",
                        "precursor_charge": "12",
                        "precursor_mz": "694.3462",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "93",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3625",
                                "monoisotopic_mz": "791.2344",
                                "intensity": "52181.29",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "1",
                                "monoisotopic_mass": "4498.2314",
                                "monoisotopic_mz": "750.7125",
                                "intensity": "21800.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "2",
                                "monoisotopic_mass": "4610.2700",
                                "monoisotopic_mz": "769.3856",
                                "intensity": "26560.71",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "3",
                                "monoisotopic_mass": "4628.2788",
                                "monoisotopic_mz": "772.3871",
                                "intensity": "30515.44",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "4",
                                "monoisotopic_mass": "1338.6101",
                                "monoisotopic_mz": "670.3123",
                                "intensity": "23176.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "5",
                                "monoisotopic_mass": "1453.6372",
                                "monoisotopic_mz": "727.8259",
                                "intensity": "14748.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "6",
                                "monoisotopic_mass": "4854.4399",
                                "monoisotopic_mz": "810.0806",
                                "intensity": "22282.74",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4854.4478",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0079",
                                        "ppm": "-1.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "7",
                                "monoisotopic_mass": "4740.3598",
                                "monoisotopic_mz": "678.2015",
                                "intensity": "11886.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "8",
                                "monoisotopic_mass": "4499.2354",
                                "monoisotopic_mz": "643.7552",
                                "intensity": "9209.19",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "9",
                                "monoisotopic_mass": "4160.0413",
                                "monoisotopic_mz": "694.3475",
                                "intensity": "20697.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "10",
                                "monoisotopic_mass": "4723.3456",
                                "monoisotopic_mz": "788.2315",
                                "intensity": "6595.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "11",
                                "monoisotopic_mass": "4627.2765",
                                "monoisotopic_mz": "926.4626",
                                "intensity": "10270.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "12",
                                "monoisotopic_mass": "8303.0754",
                                "monoisotopic_mz": "692.9302",
                                "intensity": "15649.55",
                                "charge": "12"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "13",
                                "monoisotopic_mass": "4954.4762",
                                "monoisotopic_mz": "826.7533",
                                "intensity": "9228.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "14",
                                "monoisotopic_mass": "3233.5564",
                                "monoisotopic_mz": "809.3964",
                                "intensity": "6816.28",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "15",
                                "monoisotopic_mass": "1023.4879",
                                "monoisotopic_mz": "512.7512",
                                "intensity": "11995.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "16",
                                "monoisotopic_mass": "3233.5552",
                                "monoisotopic_mz": "647.7183",
                                "intensity": "10503.65",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "17",
                                "monoisotopic_mass": "4741.3631",
                                "monoisotopic_mz": "949.2799",
                                "intensity": "5472.08",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "18",
                                "monoisotopic_mass": "8188.0604",
                                "monoisotopic_mz": "745.3764",
                                "intensity": "12609.53",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "0.0109",
                                        "ppm": "1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "19",
                                "monoisotopic_mass": "4499.2365",
                                "monoisotopic_mz": "900.8546",
                                "intensity": "9620.88",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "20",
                                "monoisotopic_mass": "3448.6289",
                                "monoisotopic_mz": "863.1645",
                                "intensity": "4115.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "21",
                                "monoisotopic_mass": "1552.7049",
                                "monoisotopic_mz": "777.3597",
                                "intensity": "7333.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "22",
                                "monoisotopic_mass": "8172.0351",
                                "monoisotopic_mz": "743.9196",
                                "intensity": "11625.33",
                                "charge": "11"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "23",
                                "monoisotopic_mass": "6838.4496",
                                "monoisotopic_mz": "684.8522",
                                "intensity": "4582.25",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "24",
                                "monoisotopic_mass": "3316.5796",
                                "monoisotopic_mz": "830.1522",
                                "intensity": "4656.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "25",
                                "monoisotopic_mass": "7630.8075",
                                "monoisotopic_mz": "764.0880",
                                "intensity": "11844.62",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7631.8073",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0025",
                                        "ppm": "0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "26",
                                "monoisotopic_mass": "2278.1445",
                                "monoisotopic_mz": "760.3888",
                                "intensity": "3721.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "27",
                                "monoisotopic_mass": "2219.0322",
                                "monoisotopic_mz": "740.6847",
                                "intensity": "3586.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "28",
                                "monoisotopic_mass": "1651.7723",
                                "monoisotopic_mz": "826.8934",
                                "intensity": "4701.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1651.7743",
                                        "ion_position": "57",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "57",
                                        "mass_error": "-0.0020",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "29",
                                "monoisotopic_mass": "3465.6363",
                                "monoisotopic_mz": "867.4163",
                                "intensity": "4269.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3465.6446",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0083",
                                        "ppm": "-2.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "30",
                                "monoisotopic_mass": "1780.8164",
                                "monoisotopic_mz": "891.4155",
                                "intensity": "3377.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1780.8169",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "56",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "31",
                                "monoisotopic_mass": "3702.7785",
                                "monoisotopic_mz": "741.5630",
                                "intensity": "5828.87",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "32",
                                "monoisotopic_mass": "3447.6157",
                                "monoisotopic_mz": "690.5304",
                                "intensity": "6768.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "33",
                                "monoisotopic_mass": "523.2540",
                                "monoisotopic_mz": "524.2612",
                                "intensity": "4240.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "34",
                                "monoisotopic_mass": "3702.8072",
                                "monoisotopic_mz": "926.7091",
                                "intensity": "6786.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0257",
                                        "ppm": "6.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "35",
                                "monoisotopic_mass": "2237.0502",
                                "monoisotopic_mz": "746.6907",
                                "intensity": "3792.47",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2237.0502",
                                        "ion_position": "52",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "36",
                                "monoisotopic_mass": "2295.6173",
                                "monoisotopic_mz": "766.2131",
                                "intensity": "2983.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "37",
                                "monoisotopic_mass": "5545.7155",
                                "monoisotopic_mz": "694.2217",
                                "intensity": "20811.20",
                                "charge": "8"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "38",
                                "monoisotopic_mass": "3433.2209",
                                "monoisotopic_mz": "687.6515",
                                "intensity": "3920.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "39",
                                "monoisotopic_mass": "3335.6048",
                                "monoisotopic_mz": "834.9085",
                                "intensity": "3678.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "40",
                                "monoisotopic_mass": "3215.5262",
                                "monoisotopic_mz": "804.8888",
                                "intensity": "4644.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "41",
                                "monoisotopic_mass": "1152.5306",
                                "monoisotopic_mz": "577.2726",
                                "intensity": "5344.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "42",
                                "monoisotopic_mass": "3298.5649",
                                "monoisotopic_mz": "825.6485",
                                "intensity": "4367.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "43",
                                "monoisotopic_mass": "4479.2166",
                                "monoisotopic_mz": "747.5434",
                                "intensity": "1600.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "44",
                                "monoisotopic_mass": "2758.3660",
                                "monoisotopic_mz": "690.5988",
                                "intensity": "3601.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "45",
                                "monoisotopic_mass": "7030.6571",
                                "monoisotopic_mz": "879.8394",
                                "intensity": "2527.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "46",
                                "monoisotopic_mass": "3364.5919",
                                "monoisotopic_mz": "673.9257",
                                "intensity": "3890.08",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3364.5969",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0050",
                                        "ppm": "-1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "47",
                                "monoisotopic_mass": "2982.7316",
                                "monoisotopic_mz": "746.6902",
                                "intensity": "2414.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "48",
                                "monoisotopic_mass": "3801.8462",
                                "monoisotopic_mz": "951.4688",
                                "intensity": "3812.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3801.8500",
                                        "ion_position": "39",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "49",
                                "monoisotopic_mass": "1424.2312",
                                "monoisotopic_mz": "713.1229",
                                "intensity": "2049.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "50",
                                "monoisotopic_mass": "1578.7702",
                                "monoisotopic_mz": "790.3924",
                                "intensity": "2035.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "51",
                                "monoisotopic_mass": "3364.5964",
                                "monoisotopic_mz": "842.1564",
                                "intensity": "3548.40",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3364.5969",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "52",
                                "monoisotopic_mass": "768.3763",
                                "monoisotopic_mz": "769.3836",
                                "intensity": "2233.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "53",
                                "monoisotopic_mass": "8217.0591",
                                "monoisotopic_mz": "685.7622",
                                "intensity": "3313.59",
                                "charge": "12"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "54",
                                "monoisotopic_mass": "7898.8970",
                                "monoisotopic_mz": "719.0888",
                                "intensity": "1705.02",
                                "charge": "11"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "55",
                                "monoisotopic_mass": "8074.0114",
                                "monoisotopic_mz": "735.0083",
                                "intensity": "2041.78",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0048",
                                        "ppm": "0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "56",
                                "monoisotopic_mass": "4954.4908",
                                "monoisotopic_mz": "708.7917",
                                "intensity": "6936.01",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "57",
                                "monoisotopic_mass": "3468.7237",
                                "monoisotopic_mz": "694.7520",
                                "intensity": "18717.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "58",
                                "monoisotopic_mass": "2352.0778",
                                "monoisotopic_mz": "785.0332",
                                "intensity": "1567.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2352.0771",
                                        "ion_position": "51",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "51",
                                        "mass_error": "0.0006",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "59",
                                "monoisotopic_mass": "4681.2144",
                                "monoisotopic_mz": "669.7522",
                                "intensity": "1197.58",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "60",
                                "monoisotopic_mass": "4133.5174",
                                "monoisotopic_mz": "689.9268",
                                "intensity": "1113.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "61",
                                "monoisotopic_mass": "5149.0300",
                                "monoisotopic_mz": "736.5830",
                                "intensity": "1065.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "62",
                                "monoisotopic_mass": "816.8955",
                                "monoisotopic_mz": "817.9028",
                                "intensity": "1244.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "63",
                                "monoisotopic_mass": "3346.5841",
                                "monoisotopic_mz": "670.3241",
                                "intensity": "1013.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "64",
                                "monoisotopic_mass": "4784.8408",
                                "monoisotopic_mz": "684.5560",
                                "intensity": "1257.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "65",
                                "monoisotopic_mass": "3216.5356",
                                "monoisotopic_mz": "644.3144",
                                "intensity": "2018.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "66",
                                "monoisotopic_mass": "8143.7207",
                                "monoisotopic_mz": "741.3455",
                                "intensity": "1184.74",
                                "charge": "11"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "67",
                                "monoisotopic_mass": "4610.2664",
                                "monoisotopic_mz": "659.6168",
                                "intensity": "2316.84",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "68",
                                "monoisotopic_mass": "602.2427",
                                "monoisotopic_mz": "603.2500",
                                "intensity": "1132.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "69",
                                "monoisotopic_mass": "1355.8199",
                                "monoisotopic_mz": "678.9172",
                                "intensity": "3048.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "70",
                                "monoisotopic_mass": "5794.4571",
                                "monoisotopic_mz": "725.3144",
                                "intensity": "1137.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "71",
                                "monoisotopic_mass": "1759.3340",
                                "monoisotopic_mz": "880.6743",
                                "intensity": "1784.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "72",
                                "monoisotopic_mass": "3793.9856",
                                "monoisotopic_mz": "759.8044",
                                "intensity": "1209.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "73",
                                "monoisotopic_mass": "780.6427",
                                "monoisotopic_mz": "781.6500",
                                "intensity": "1225.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "74",
                                "monoisotopic_mass": "7868.1805",
                                "monoisotopic_mz": "787.8253",
                                "intensity": "1221.51",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "75",
                                "monoisotopic_mass": "5923.3891",
                                "monoisotopic_mz": "741.4309",
                                "intensity": "1539.27",
                                "charge": "8"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "76",
                                "monoisotopic_mass": "848.7576",
                                "monoisotopic_mz": "849.7649",
                                "intensity": "1236.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "77",
                                "monoisotopic_mass": "1234.5995",
                                "monoisotopic_mz": "618.3070",
                                "intensity": "711.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "78",
                                "monoisotopic_mass": "4462.0735",
                                "monoisotopic_mz": "744.6862",
                                "intensity": "3128.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "79",
                                "monoisotopic_mass": "1321.6579",
                                "monoisotopic_mz": "661.8362",
                                "intensity": "2088.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "80",
                                "monoisotopic_mass": "7033.4059",
                                "monoisotopic_mz": "704.3479",
                                "intensity": "943.09",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "81",
                                "monoisotopic_mass": "4936.4744",
                                "monoisotopic_mz": "823.7530",
                                "intensity": "1679.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "82",
                                "monoisotopic_mass": "8238.0363",
                                "monoisotopic_mz": "687.5103",
                                "intensity": "2065.02",
                                "charge": "12"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "83",
                                "monoisotopic_mass": "5776.6898",
                                "monoisotopic_mz": "826.2487",
                                "intensity": "804.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "84",
                                "monoisotopic_mass": "4261.1976",
                                "monoisotopic_mz": "711.2069",
                                "intensity": "1104.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "85",
                                "monoisotopic_mass": "7154.6757",
                                "monoisotopic_mz": "795.9712",
                                "intensity": "1069.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "86",
                                "monoisotopic_mass": "6822.4047",
                                "monoisotopic_mz": "683.2477",
                                "intensity": "4207.40",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "87",
                                "monoisotopic_mass": "4404.6475",
                                "monoisotopic_mz": "735.1152",
                                "intensity": "2144.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "88",
                                "monoisotopic_mass": "7658.8159",
                                "monoisotopic_mz": "851.9868",
                                "intensity": "1215.40",
                                "charge": "9"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "89",
                                "monoisotopic_mass": "5360.1160",
                                "monoisotopic_mz": "766.7381",
                                "intensity": "1286.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "90",
                                "monoisotopic_mass": "6694.4002",
                                "monoisotopic_mz": "744.8295",
                                "intensity": "839.06",
                                "charge": "9"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "91",
                                "monoisotopic_mass": "7701.6852",
                                "monoisotopic_mz": "701.1605",
                                "intensity": "8844.48",
                                "charge": "11"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "92",
                                "monoisotopic_mass": "3664.3171",
                                "monoisotopic_mz": "733.8707",
                                "intensity": "1196.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "93",
                                "monoisotopic_mass": "8239.4366",
                                "monoisotopic_mz": "824.9509",
                                "intensity": "882.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "94",
                                "monoisotopic_mass": "3907.4361",
                                "monoisotopic_mz": "782.4945",
                                "intensity": "2910.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "95",
                                "monoisotopic_mass": "3649.3708",
                                "monoisotopic_mz": "730.8814",
                                "intensity": "1702.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "96",
                                "monoisotopic_mass": "6169.5132",
                                "monoisotopic_mz": "617.9586",
                                "intensity": "1941.99",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "97",
                                "monoisotopic_mass": "6671.3074",
                                "monoisotopic_mz": "742.2637",
                                "intensity": "2296.35",
                                "charge": "9"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "98",
                                "monoisotopic_mass": "7446.8888",
                                "monoisotopic_mz": "745.6962",
                                "intensity": "3959.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "99",
                                "monoisotopic_mass": "2075.5144",
                                "monoisotopic_mz": "692.8454",
                                "intensity": "2585.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "100",
                                "monoisotopic_mass": "3851.9276",
                                "monoisotopic_mz": "771.3928",
                                "intensity": "8698.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "101",
                                "monoisotopic_mass": "4320.8625",
                                "monoisotopic_mz": "721.1510",
                                "intensity": "2143.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "102",
                                "monoisotopic_mass": "1406.7087",
                                "monoisotopic_mz": "704.3616",
                                "intensity": "1252.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "103",
                                "monoisotopic_mass": "6148.1940",
                                "monoisotopic_mz": "769.5315",
                                "intensity": "1795.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "104",
                                "monoisotopic_mass": "1442.6366",
                                "monoisotopic_mz": "722.3256",
                                "intensity": "817.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "105",
                                "monoisotopic_mass": "836.6666",
                                "monoisotopic_mz": "837.6739",
                                "intensity": "919.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "106",
                                "monoisotopic_mass": "3858.8402",
                                "monoisotopic_mz": "644.1473",
                                "intensity": "1477.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "107",
                                "monoisotopic_mass": "3397.3397",
                                "monoisotopic_mz": "680.4752",
                                "intensity": "1658.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "93",
                                "peak_id": "108",
                                "monoisotopic_mass": "2329.0251",
                                "monoisotopic_mz": "777.3490",
                                "intensity": "820.83",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "93",
                                        "peak_id": "18",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "spec_id": "93",
                                        "peak_id": "55",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "spec_id": "93",
                                        "peak_id": "25",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "93",
                                            "peak_id": "16",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "93",
                                            "peak_id": "14",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "93",
                                            "peak_id": "46",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "93",
                                            "peak_id": "51",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "93",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "39",
                                            "spec_id": "93",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "93",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "93",
                                            "peak_id": "17",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "93",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "93",
                                            "peak_id": "8",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "93",
                                            "peak_id": "19",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "39",
                                        "ion_display_position": "30",
                                        "spec_id": "93",
                                        "peak_id": "48",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "93",
                                            "peak_id": "31",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "93",
                                            "peak_id": "34",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "51",
                                        "ion_display_position": "18",
                                        "spec_id": "93",
                                        "peak_id": "58",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "52",
                                        "ion_display_position": "17",
                                        "spec_id": "93",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "spec_id": "93",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "57",
                                        "ion_display_position": "12",
                                        "spec_id": "93",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "93",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "93",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "93",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "93",
                                        "peak_id": "41",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "93",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "93",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "128",
                "p_value": "1.11e-12",
                "e_value": "1.11e-12",
                "fdr": "0",
                "matched_fragment_number": "19",
                "matched_peak_number": "22",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "113",
                        "ms1_scans": "291",
                        "ids": "177",
                        "scans": "292",
                        "precursor_mono_mass": "8320.0767",
                        "precursor_charge": "12",
                        "precursor_mz": "694.3470",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "177",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3629",
                                "monoisotopic_mz": "791.2344",
                                "intensity": "51213.46",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "1",
                                "monoisotopic_mass": "4628.2795",
                                "monoisotopic_mz": "772.3872",
                                "intensity": "20756.16",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "2",
                                "monoisotopic_mass": "4609.2661",
                                "monoisotopic_mz": "769.2183",
                                "intensity": "21806.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "3",
                                "monoisotopic_mass": "1338.6102",
                                "monoisotopic_mz": "670.3124",
                                "intensity": "22711.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "4",
                                "monoisotopic_mass": "1453.6388",
                                "monoisotopic_mz": "727.8267",
                                "intensity": "13071.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0013",
                                        "ppm": "0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "5",
                                "monoisotopic_mass": "4499.2378",
                                "monoisotopic_mz": "750.8802",
                                "intensity": "24440.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0007",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "6",
                                "monoisotopic_mass": "8188.0457",
                                "monoisotopic_mz": "745.3751",
                                "intensity": "17206.64",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "7",
                                "monoisotopic_mass": "8302.0650",
                                "monoisotopic_mz": "692.8460",
                                "intensity": "15910.63",
                                "charge": "12"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "8",
                                "monoisotopic_mass": "4853.4485",
                                "monoisotopic_mz": "809.9154",
                                "intensity": "12889.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "9",
                                "monoisotopic_mass": "1023.4881",
                                "monoisotopic_mz": "512.7513",
                                "intensity": "10570.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "10",
                                "monoisotopic_mass": "4954.4912",
                                "monoisotopic_mz": "826.7558",
                                "intensity": "11719.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "11",
                                "monoisotopic_mass": "4740.3615",
                                "monoisotopic_mz": "678.2018",
                                "intensity": "15748.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "12",
                                "monoisotopic_mass": "3234.5575",
                                "monoisotopic_mz": "647.9188",
                                "intensity": "7980.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "13",
                                "monoisotopic_mass": "2773.0282",
                                "monoisotopic_mz": "694.2643",
                                "intensity": "20555.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "14",
                                "monoisotopic_mass": "3448.6347",
                                "monoisotopic_mz": "863.1660",
                                "intensity": "7415.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "15",
                                "monoisotopic_mass": "7701.8387",
                                "monoisotopic_mz": "771.1911",
                                "intensity": "7850.75",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7702.8445",
                                        "ion_position": "5",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "16",
                                "monoisotopic_mass": "4499.2359",
                                "monoisotopic_mz": "643.7553",
                                "intensity": "7957.83",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "17",
                                "monoisotopic_mass": "1552.7065",
                                "monoisotopic_mz": "777.3605",
                                "intensity": "6596.00",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0006",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "18",
                                "monoisotopic_mass": "6241.5690",
                                "monoisotopic_mz": "694.5149",
                                "intensity": "7510.91",
                                "charge": "9"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "19",
                                "monoisotopic_mass": "4499.2440",
                                "monoisotopic_mz": "900.8561",
                                "intensity": "8220.52",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0069",
                                        "ppm": "1.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "20",
                                "monoisotopic_mass": "1780.8161",
                                "monoisotopic_mz": "891.4153",
                                "intensity": "4747.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1780.8169",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "56",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "21",
                                "monoisotopic_mass": "4628.2777",
                                "monoisotopic_mz": "926.6628",
                                "intensity": "8407.59",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "22",
                                "monoisotopic_mass": "3233.5576",
                                "monoisotopic_mz": "809.3967",
                                "intensity": "7990.47",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0012",
                                        "ppm": "0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "23",
                                "monoisotopic_mass": "3702.7845",
                                "monoisotopic_mz": "926.7034",
                                "intensity": "7490.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0029",
                                        "ppm": "0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "24",
                                "monoisotopic_mass": "3446.6240",
                                "monoisotopic_mz": "690.3321",
                                "intensity": "5962.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "25",
                                "monoisotopic_mass": "3465.6436",
                                "monoisotopic_mz": "867.4182",
                                "intensity": "4695.15",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3465.6446",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "26",
                                "monoisotopic_mass": "2362.1727",
                                "monoisotopic_mz": "788.3982",
                                "intensity": "4155.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "27",
                                "monoisotopic_mass": "8273.0523",
                                "monoisotopic_mz": "690.4283",
                                "intensity": "6154.10",
                                "charge": "12"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "28",
                                "monoisotopic_mass": "523.2541",
                                "monoisotopic_mz": "524.2614",
                                "intensity": "3592.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "29",
                                "monoisotopic_mass": "2079.7728",
                                "monoisotopic_mz": "694.2649",
                                "intensity": "5860.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "30",
                                "monoisotopic_mass": "3288.5884",
                                "monoisotopic_mz": "658.7250",
                                "intensity": "5228.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "31",
                                "monoisotopic_mass": "3364.5984",
                                "monoisotopic_mz": "842.1569",
                                "intensity": "2965.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3364.5969",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0015",
                                        "ppm": "0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "32",
                                "monoisotopic_mass": "2745.6814",
                                "monoisotopic_mz": "687.4276",
                                "intensity": "2751.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "33",
                                "monoisotopic_mass": "3816.4093",
                                "monoisotopic_mz": "764.2891",
                                "intensity": "8769.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "34",
                                "monoisotopic_mass": "1152.5313",
                                "monoisotopic_mz": "577.2730",
                                "intensity": "4486.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0001",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "35",
                                "monoisotopic_mass": "3101.5089",
                                "monoisotopic_mz": "621.3091",
                                "intensity": "3492.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "36",
                                "monoisotopic_mass": "3118.5302",
                                "monoisotopic_mz": "780.6398",
                                "intensity": "3689.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3118.5295",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0008",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "37",
                                "monoisotopic_mass": "690.9212",
                                "monoisotopic_mz": "691.9285",
                                "intensity": "1681.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "38",
                                "monoisotopic_mass": "3402.7495",
                                "monoisotopic_mz": "851.6947",
                                "intensity": "2876.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "39",
                                "monoisotopic_mass": "1481.9146",
                                "monoisotopic_mz": "741.9646",
                                "intensity": "2297.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "40",
                                "monoisotopic_mass": "1371.5090",
                                "monoisotopic_mz": "686.7618",
                                "intensity": "1711.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "41",
                                "monoisotopic_mass": "4937.4760",
                                "monoisotopic_mz": "823.9199",
                                "intensity": "1291.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "42",
                                "monoisotopic_mass": "3409.7124",
                                "monoisotopic_mz": "682.9498",
                                "intensity": "877.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "43",
                                "monoisotopic_mass": "4163.9620",
                                "monoisotopic_mz": "695.0009",
                                "intensity": "4146.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "44",
                                "monoisotopic_mass": "3974.9945",
                                "monoisotopic_mz": "796.0062",
                                "intensity": "1846.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "45",
                                "monoisotopic_mass": "6838.5282",
                                "monoisotopic_mz": "684.8601",
                                "intensity": "1444.24",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "46",
                                "monoisotopic_mass": "8237.0446",
                                "monoisotopic_mz": "687.4277",
                                "intensity": "1429.27",
                                "charge": "12"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "47",
                                "monoisotopic_mass": "4308.1762",
                                "monoisotopic_mz": "719.0366",
                                "intensity": "858.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "48",
                                "monoisotopic_mass": "784.0251",
                                "monoisotopic_mz": "785.0323",
                                "intensity": "1596.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "49",
                                "monoisotopic_mass": "3346.5792",
                                "monoisotopic_mz": "837.6521",
                                "intensity": "1092.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "50",
                                "monoisotopic_mass": "7503.7311",
                                "monoisotopic_mz": "751.3804",
                                "intensity": "2054.80",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "51",
                                "monoisotopic_mass": "7271.7552",
                                "monoisotopic_mz": "662.0759",
                                "intensity": "1283.59",
                                "charge": "11"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "52",
                                "monoisotopic_mass": "825.9131",
                                "monoisotopic_mz": "826.9203",
                                "intensity": "1127.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "53",
                                "monoisotopic_mass": "5519.0001",
                                "monoisotopic_mz": "690.8823",
                                "intensity": "677.37",
                                "charge": "8"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "54",
                                "monoisotopic_mass": "1388.8766",
                                "monoisotopic_mz": "695.4456",
                                "intensity": "2804.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "55",
                                "monoisotopic_mass": "7615.7822",
                                "monoisotopic_mz": "762.5855",
                                "intensity": "1208.70",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "56",
                                "monoisotopic_mass": "5188.1815",
                                "monoisotopic_mz": "742.1761",
                                "intensity": "1645.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "57",
                                "monoisotopic_mass": "4407.4224",
                                "monoisotopic_mz": "735.5777",
                                "intensity": "1248.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "58",
                                "monoisotopic_mass": "760.9708",
                                "monoisotopic_mz": "761.9781",
                                "intensity": "1071.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "59",
                                "monoisotopic_mass": "6771.3883",
                                "monoisotopic_mz": "753.3838",
                                "intensity": "1054.44",
                                "charge": "9"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "60",
                                "monoisotopic_mass": "6864.5186",
                                "monoisotopic_mz": "763.7316",
                                "intensity": "822.86",
                                "charge": "9"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "61",
                                "monoisotopic_mass": "5635.7217",
                                "monoisotopic_mz": "806.1104",
                                "intensity": "978.25",
                                "charge": "7"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "62",
                                "monoisotopic_mass": "737.8154",
                                "monoisotopic_mz": "738.8227",
                                "intensity": "1169.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "63",
                                "monoisotopic_mass": "6630.2563",
                                "monoisotopic_mz": "737.7024",
                                "intensity": "3269.56",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6629.3038",
                                        "ion_position": "15",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0499",
                                        "ppm": "-7.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "64",
                                "monoisotopic_mass": "2728.0023",
                                "monoisotopic_mz": "683.0078",
                                "intensity": "988.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "65",
                                "monoisotopic_mass": "2220.0316",
                                "monoisotopic_mz": "741.0178",
                                "intensity": "2401.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "66",
                                "monoisotopic_mass": "3334.5954",
                                "monoisotopic_mz": "834.6561",
                                "intensity": "1090.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "67",
                                "monoisotopic_mass": "3716.8641",
                                "monoisotopic_mz": "930.2233",
                                "intensity": "1512.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "68",
                                "monoisotopic_mass": "708.6443",
                                "monoisotopic_mz": "709.6515",
                                "intensity": "1141.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "69",
                                "monoisotopic_mass": "4435.7397",
                                "monoisotopic_mz": "740.2972",
                                "intensity": "1240.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "70",
                                "monoisotopic_mass": "7465.3085",
                                "monoisotopic_mz": "830.4860",
                                "intensity": "827.42",
                                "charge": "9"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "71",
                                "monoisotopic_mass": "2505.3198",
                                "monoisotopic_mz": "836.1139",
                                "intensity": "1634.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "72",
                                "monoisotopic_mass": "5508.8010",
                                "monoisotopic_mz": "787.9788",
                                "intensity": "1008.60",
                                "charge": "7"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "73",
                                "monoisotopic_mass": "3216.5378",
                                "monoisotopic_mz": "805.1417",
                                "intensity": "2915.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "74",
                                "monoisotopic_mass": "3365.5941",
                                "monoisotopic_mz": "674.1261",
                                "intensity": "1808.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "75",
                                "monoisotopic_mass": "2924.7738",
                                "monoisotopic_mz": "732.2007",
                                "intensity": "1809.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "76",
                                "monoisotopic_mass": "5809.0396",
                                "monoisotopic_mz": "830.8701",
                                "intensity": "741.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "77",
                                "monoisotopic_mass": "2960.0263",
                                "monoisotopic_mz": "741.0138",
                                "intensity": "1053.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "78",
                                "monoisotopic_mass": "5568.8727",
                                "monoisotopic_mz": "697.1164",
                                "intensity": "889.27",
                                "charge": "8"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "79",
                                "monoisotopic_mass": "1650.7901",
                                "monoisotopic_mz": "826.4023",
                                "intensity": "3147.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "80",
                                "monoisotopic_mass": "8294.9459",
                                "monoisotopic_mz": "830.5019",
                                "intensity": "665.41",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "81",
                                "monoisotopic_mass": "6872.3703",
                                "monoisotopic_mz": "688.2443",
                                "intensity": "881.45",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "82",
                                "monoisotopic_mass": "862.2331",
                                "monoisotopic_mz": "863.2404",
                                "intensity": "1333.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "83",
                                "monoisotopic_mass": "1436.0484",
                                "monoisotopic_mz": "719.0315",
                                "intensity": "1189.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "84",
                                "monoisotopic_mass": "3501.1121",
                                "monoisotopic_mz": "701.2297",
                                "intensity": "2314.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "85",
                                "monoisotopic_mass": "1468.3044",
                                "monoisotopic_mz": "735.1595",
                                "intensity": "641.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "86",
                                "monoisotopic_mass": "6170.9770",
                                "monoisotopic_mz": "772.3794",
                                "intensity": "2221.40",
                                "charge": "8"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "87",
                                "monoisotopic_mass": "5966.1357",
                                "monoisotopic_mz": "746.7742",
                                "intensity": "3068.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "88",
                                "monoisotopic_mass": "7297.6634",
                                "monoisotopic_mz": "730.7736",
                                "intensity": "2271.68",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7296.6037",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "B00062",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0573",
                                        "ppm": "7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "89",
                                "monoisotopic_mass": "8076.5364",
                                "monoisotopic_mz": "735.2379",
                                "intensity": "1145.66",
                                "charge": "11"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "90",
                                "monoisotopic_mass": "2271.1325",
                                "monoisotopic_mz": "758.0514",
                                "intensity": "1688.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "91",
                                "monoisotopic_mass": "805.8903",
                                "monoisotopic_mz": "806.8976",
                                "intensity": "820.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "92",
                                "monoisotopic_mass": "6004.8407",
                                "monoisotopic_mz": "668.2118",
                                "intensity": "2524.00",
                                "charge": "9"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "177",
                                        "peak_id": "6",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "5",
                                        "ion_display_position": "64",
                                        "spec_id": "177",
                                        "peak_id": "15",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "54",
                                        "spec_id": "177",
                                        "peak_id": "63",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "177",
                                        "peak_id": "36",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "177",
                                        "peak_id": "22",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "177",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "177",
                                        "peak_id": "25",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "177",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "37",
                                            "spec_id": "177",
                                            "peak_id": "21",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "37",
                                            "spec_id": "177",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "177",
                                            "peak_id": "16",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "177",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "177",
                                            "peak_id": "19",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "spec_id": "177",
                                        "peak_id": "23",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "spec_id": "177",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "177",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "177",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "177",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "177",
                                        "peak_id": "34",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "62",
                                            "ion_display_position": "7",
                                            "spec_id": "177",
                                            "peak_id": "9",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "62",
                                            "ion_display_position": "62",
                                            "spec_id": "177",
                                            "peak_id": "88",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "177",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "99",
                "p_value": "6.62e-11",
                "e_value": "6.62e-11",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "23",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "99",
                        "ms1_scans": "234",
                        "ids": "134",
                        "scans": "235",
                        "precursor_mono_mass": "8320.0745",
                        "precursor_charge": "12",
                        "precursor_mz": "694.3468",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "134",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3639",
                                "monoisotopic_mz": "791.2346",
                                "intensity": "49352.38",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "1",
                                "monoisotopic_mass": "4499.2363",
                                "monoisotopic_mz": "750.8800",
                                "intensity": "24093.49",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "2",
                                "monoisotopic_mass": "4610.2692",
                                "monoisotopic_mz": "769.3855",
                                "intensity": "31549.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "3",
                                "monoisotopic_mass": "1338.6104",
                                "monoisotopic_mz": "670.3125",
                                "intensity": "24319.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "4",
                                "monoisotopic_mass": "4627.2757",
                                "monoisotopic_mz": "772.2199",
                                "intensity": "23710.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "5",
                                "monoisotopic_mass": "1453.6369",
                                "monoisotopic_mz": "727.8257",
                                "intensity": "16065.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "6",
                                "monoisotopic_mass": "4854.4487",
                                "monoisotopic_mz": "810.0821",
                                "intensity": "17940.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4854.4478",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0008",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "7",
                                "monoisotopic_mass": "4954.4876",
                                "monoisotopic_mz": "826.7552",
                                "intensity": "11131.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "8",
                                "monoisotopic_mass": "1023.4880",
                                "monoisotopic_mz": "512.7513",
                                "intensity": "12778.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "9",
                                "monoisotopic_mass": "8302.0764",
                                "monoisotopic_mz": "692.8470",
                                "intensity": "12729.86",
                                "charge": "12"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "10",
                                "monoisotopic_mass": "3233.5581",
                                "monoisotopic_mz": "809.3968",
                                "intensity": "7810.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0017",
                                        "ppm": "0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "11",
                                "monoisotopic_mass": "4740.3577",
                                "monoisotopic_mz": "678.2012",
                                "intensity": "11928.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "12",
                                "monoisotopic_mass": "4160.5405",
                                "monoisotopic_mz": "694.4307",
                                "intensity": "14695.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "13",
                                "monoisotopic_mass": "8188.0370",
                                "monoisotopic_mz": "745.3743",
                                "intensity": "15011.81",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0126",
                                        "ppm": "-1.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "14",
                                "monoisotopic_mass": "4499.2378",
                                "monoisotopic_mz": "900.8548",
                                "intensity": "12129.35",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0007",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "15",
                                "monoisotopic_mass": "3702.7786",
                                "monoisotopic_mz": "741.5630",
                                "intensity": "6510.88",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "16",
                                "monoisotopic_mass": "4499.2346",
                                "monoisotopic_mz": "643.7551",
                                "intensity": "9605.47",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "17",
                                "monoisotopic_mass": "3806.8973",
                                "monoisotopic_mz": "762.3867",
                                "intensity": "8888.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "18",
                                "monoisotopic_mass": "3702.7837",
                                "monoisotopic_mz": "926.7032",
                                "intensity": "9049.53",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0022",
                                        "ppm": "0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "19",
                                "monoisotopic_mass": "1552.7064",
                                "monoisotopic_mz": "777.3605",
                                "intensity": "8375.46",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0005",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "20",
                                "monoisotopic_mass": "7631.8066",
                                "monoisotopic_mz": "764.1879",
                                "intensity": "10471.65",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7631.8073",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "21",
                                "monoisotopic_mass": "3316.5915",
                                "monoisotopic_mz": "830.1552",
                                "intensity": "6033.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "22",
                                "monoisotopic_mass": "523.2543",
                                "monoisotopic_mz": "524.2615",
                                "intensity": "5149.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "23",
                                "monoisotopic_mass": "2315.6427",
                                "monoisotopic_mz": "772.8882",
                                "intensity": "7763.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "24",
                                "monoisotopic_mass": "3288.5944",
                                "monoisotopic_mz": "658.7261",
                                "intensity": "4531.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "25",
                                "monoisotopic_mass": "2080.5261",
                                "monoisotopic_mz": "694.5160",
                                "intensity": "6020.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "26",
                                "monoisotopic_mass": "8173.0301",
                                "monoisotopic_mz": "744.0100",
                                "intensity": "8350.76",
                                "charge": "11"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "27",
                                "monoisotopic_mass": "3216.5473",
                                "monoisotopic_mz": "805.1441",
                                "intensity": "4451.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "28",
                                "monoisotopic_mass": "2987.4704",
                                "monoisotopic_mz": "747.8749",
                                "intensity": "3337.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "29",
                                "monoisotopic_mass": "2237.0489",
                                "monoisotopic_mz": "746.6902",
                                "intensity": "3832.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2237.0502",
                                        "ion_position": "52",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "30",
                                "monoisotopic_mass": "4725.3437",
                                "monoisotopic_mz": "788.5646",
                                "intensity": "6189.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "31",
                                "monoisotopic_mass": "4740.3672",
                                "monoisotopic_mz": "949.0807",
                                "intensity": "5124.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "32",
                                "monoisotopic_mass": "3233.5535",
                                "monoisotopic_mz": "647.7180",
                                "intensity": "9648.33",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "33",
                                "monoisotopic_mass": "3447.6346",
                                "monoisotopic_mz": "690.5342",
                                "intensity": "6942.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "34",
                                "monoisotopic_mass": "2219.0364",
                                "monoisotopic_mz": "740.6861",
                                "intensity": "3590.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "35",
                                "monoisotopic_mass": "1152.5304",
                                "monoisotopic_mz": "577.2725",
                                "intensity": "3591.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "36",
                                "monoisotopic_mass": "5087.5352",
                                "monoisotopic_mz": "727.7980",
                                "intensity": "2758.22",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5086.5360",
                                        "ion_position": "28",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "37",
                                "monoisotopic_mass": "3300.5750",
                                "monoisotopic_mz": "826.1510",
                                "intensity": "2922.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "38",
                                "monoisotopic_mass": "4440.3272",
                                "monoisotopic_mz": "741.0618",
                                "intensity": "2480.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "39",
                                "monoisotopic_mass": "7624.5698",
                                "monoisotopic_mz": "694.1500",
                                "intensity": "9196.13",
                                "charge": "11"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "40",
                                "monoisotopic_mass": "4854.4460",
                                "monoisotopic_mz": "694.4996",
                                "intensity": "8499.62",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4854.4478",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "41",
                                "monoisotopic_mass": "3102.5149",
                                "monoisotopic_mz": "776.6360",
                                "intensity": "3373.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "42",
                                "monoisotopic_mass": "1475.7320",
                                "monoisotopic_mz": "738.8733",
                                "intensity": "2538.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "43",
                                "monoisotopic_mass": "3103.5120",
                                "monoisotopic_mz": "621.7097",
                                "intensity": "2630.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "44",
                                "monoisotopic_mass": "8236.0383",
                                "monoisotopic_mz": "687.3438",
                                "intensity": "1381.76",
                                "charge": "12"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "45",
                                "monoisotopic_mass": "694.0938",
                                "monoisotopic_mz": "695.1011",
                                "intensity": "1363.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "46",
                                "monoisotopic_mass": "3272.5739",
                                "monoisotopic_mz": "655.5220",
                                "intensity": "1902.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "47",
                                "monoisotopic_mass": "3799.8431",
                                "monoisotopic_mz": "950.9681",
                                "intensity": "2091.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "48",
                                "monoisotopic_mass": "954.4575",
                                "monoisotopic_mz": "955.4648",
                                "intensity": "1196.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "49",
                                "monoisotopic_mass": "7370.6937",
                                "monoisotopic_mz": "738.0766",
                                "intensity": "1323.81",
                                "charge": "10"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "50",
                                "monoisotopic_mass": "8115.0064",
                                "monoisotopic_mz": "677.2578",
                                "intensity": "1392.84",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8116.0025",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0063",
                                        "ppm": "0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "51",
                                "monoisotopic_mass": "6982.4593",
                                "monoisotopic_mz": "699.2532",
                                "intensity": "963.52",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6981.4818",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "B00060",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0249",
                                        "ppm": "-3.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "52",
                                "monoisotopic_mass": "8156.0326",
                                "monoisotopic_mz": "742.4648",
                                "intensity": "1292.45",
                                "charge": "11"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "53",
                                "monoisotopic_mass": "4611.2760",
                                "monoisotopic_mz": "659.7610",
                                "intensity": "2457.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "54",
                                "monoisotopic_mass": "3400.6731",
                                "monoisotopic_mz": "681.1419",
                                "intensity": "2243.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "55",
                                "monoisotopic_mass": "826.3901",
                                "monoisotopic_mz": "827.3974",
                                "intensity": "2456.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "56",
                                "monoisotopic_mass": "862.1590",
                                "monoisotopic_mz": "863.1663",
                                "intensity": "4167.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "57",
                                "monoisotopic_mass": "4311.1546",
                                "monoisotopic_mz": "719.5330",
                                "intensity": "2593.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "58",
                                "monoisotopic_mass": "2391.2341",
                                "monoisotopic_mz": "798.0853",
                                "intensity": "1843.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "59",
                                "monoisotopic_mass": "5704.0418",
                                "monoisotopic_mz": "815.8704",
                                "intensity": "2254.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "60",
                                "monoisotopic_mass": "2847.4653",
                                "monoisotopic_mz": "712.8736",
                                "intensity": "2084.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "61",
                                "monoisotopic_mass": "890.4062",
                                "monoisotopic_mz": "891.4135",
                                "intensity": "2059.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "62",
                                "monoisotopic_mass": "1983.4066",
                                "monoisotopic_mz": "662.1428",
                                "intensity": "1569.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "63",
                                "monoisotopic_mass": "7133.1242",
                                "monoisotopic_mz": "714.3197",
                                "intensity": "1912.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "64",
                                "monoisotopic_mass": "2251.4595",
                                "monoisotopic_mz": "751.4938",
                                "intensity": "988.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "65",
                                "monoisotopic_mass": "1366.6854",
                                "monoisotopic_mz": "684.3500",
                                "intensity": "740.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "66",
                                "monoisotopic_mass": "4890.9162",
                                "monoisotopic_mz": "699.7096",
                                "intensity": "971.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "67",
                                "monoisotopic_mass": "2870.5937",
                                "monoisotopic_mz": "718.6557",
                                "intensity": "2435.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "68",
                                "monoisotopic_mass": "5026.1245",
                                "monoisotopic_mz": "719.0251",
                                "intensity": "1134.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "69",
                                "monoisotopic_mass": "3421.2444",
                                "monoisotopic_mz": "685.2562",
                                "intensity": "1110.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "70",
                                "monoisotopic_mass": "1416.4294",
                                "monoisotopic_mz": "709.2220",
                                "intensity": "4292.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "71",
                                "monoisotopic_mass": "7576.7798",
                                "monoisotopic_mz": "689.8054",
                                "intensity": "3411.12",
                                "charge": "11"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "72",
                                "monoisotopic_mass": "805.3953",
                                "monoisotopic_mz": "806.4025",
                                "intensity": "2143.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "73",
                                "monoisotopic_mass": "3215.5472",
                                "monoisotopic_mz": "644.1167",
                                "intensity": "2503.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "74",
                                "monoisotopic_mass": "7390.8963",
                                "monoisotopic_mz": "740.0969",
                                "intensity": "1359.30",
                                "charge": "10"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "75",
                                "monoisotopic_mass": "6075.0705",
                                "monoisotopic_mz": "676.0151",
                                "intensity": "2578.47",
                                "charge": "9"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "76",
                                "monoisotopic_mass": "3907.4348",
                                "monoisotopic_mz": "782.4942",
                                "intensity": "2701.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "77",
                                "monoisotopic_mass": "6169.0307",
                                "monoisotopic_mz": "772.1361",
                                "intensity": "1166.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "78",
                                "monoisotopic_mass": "5384.5538",
                                "monoisotopic_mz": "674.0765",
                                "intensity": "2563.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "79",
                                "monoisotopic_mass": "3367.8791",
                                "monoisotopic_mz": "674.5831",
                                "intensity": "3559.78",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "80",
                                "monoisotopic_mass": "1322.6511",
                                "monoisotopic_mz": "662.3328",
                                "intensity": "696.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "81",
                                "monoisotopic_mass": "725.7919",
                                "monoisotopic_mz": "726.7992",
                                "intensity": "1364.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "82",
                                "monoisotopic_mass": "3862.8019",
                                "monoisotopic_mz": "644.8076",
                                "intensity": "995.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "83",
                                "monoisotopic_mass": "3025.5461",
                                "monoisotopic_mz": "757.3938",
                                "intensity": "1914.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "84",
                                "monoisotopic_mass": "3755.8717",
                                "monoisotopic_mz": "752.1816",
                                "intensity": "974.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "85",
                                "monoisotopic_mass": "1400.2936",
                                "monoisotopic_mz": "701.1541",
                                "intensity": "1152.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "86",
                                "monoisotopic_mass": "5342.4657",
                                "monoisotopic_mz": "891.4182",
                                "intensity": "3039.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "87",
                                "monoisotopic_mass": "7295.6317",
                                "monoisotopic_mz": "664.2465",
                                "intensity": "3783.03",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7296.6037",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "B00062",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0304",
                                        "ppm": "4.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "88",
                                "monoisotopic_mass": "3385.4912",
                                "monoisotopic_mz": "678.1055",
                                "intensity": "882.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "89",
                                "monoisotopic_mass": "5199.3587",
                                "monoisotopic_mz": "743.7728",
                                "intensity": "3147.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "90",
                                "monoisotopic_mass": "710.4452",
                                "monoisotopic_mz": "711.4525",
                                "intensity": "1159.71",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "134",
                                        "peak_id": "13",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "spec_id": "134",
                                        "peak_id": "20",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "134",
                                            "peak_id": "32",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "134",
                                            "peak_id": "10",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "41",
                                            "spec_id": "134",
                                            "peak_id": "36",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "39",
                                            "spec_id": "134",
                                            "peak_id": "40",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "39",
                                            "spec_id": "134",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "134",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "134",
                                            "peak_id": "16",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "134",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "36",
                                            "spec_id": "134",
                                            "peak_id": "14",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "134",
                                            "peak_id": "15",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "134",
                                            "peak_id": "18",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "52",
                                        "ion_display_position": "17",
                                        "spec_id": "134",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "134",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "134",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "60",
                                            "ion_display_position": "9",
                                            "spec_id": "134",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "134",
                                            "peak_id": "51",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "134",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "62",
                                            "ion_display_position": "7",
                                            "spec_id": "134",
                                            "peak_id": "8",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "62",
                                            "ion_display_position": "62",
                                            "spec_id": "134",
                                            "peak_id": "87",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "134",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "134",
                                        "peak_id": "50",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "40",
                "p_value": "3.58e-10",
                "e_value": "3.58e-10",
                "fdr": "0",
                "matched_fragment_number": "16",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "72",
                        "ms1_scans": "125",
                        "ids": "52",
                        "scans": "126",
                        "precursor_mono_mass": "8320.0694",
                        "precursor_charge": "12",
                        "precursor_mz": "694.3464",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "52",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3629",
                                "monoisotopic_mz": "791.2344",
                                "intensity": "47076.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "1",
                                "monoisotopic_mass": "4610.2656",
                                "monoisotopic_mz": "769.3849",
                                "intensity": "20788.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "2",
                                "monoisotopic_mass": "4499.2374",
                                "monoisotopic_mz": "750.8802",
                                "intensity": "20024.12",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0003",
                                        "ppm": "0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "3",
                                "monoisotopic_mass": "1338.6102",
                                "monoisotopic_mz": "670.3124",
                                "intensity": "22222.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "4",
                                "monoisotopic_mass": "4628.2791",
                                "monoisotopic_mz": "772.3871",
                                "intensity": "22433.16",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "5",
                                "monoisotopic_mass": "4853.4438",
                                "monoisotopic_mz": "809.9146",
                                "intensity": "13762.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "6",
                                "monoisotopic_mass": "4741.3639",
                                "monoisotopic_mz": "678.3450",
                                "intensity": "13703.96",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0001",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "7",
                                "monoisotopic_mass": "8189.0501",
                                "monoisotopic_mz": "745.4664",
                                "intensity": "18930.75",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "8",
                                "monoisotopic_mass": "4160.5471",
                                "monoisotopic_mz": "694.4318",
                                "intensity": "9112.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "9",
                                "monoisotopic_mass": "1453.6373",
                                "monoisotopic_mz": "727.8259",
                                "intensity": "15696.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "10",
                                "monoisotopic_mass": "1023.4880",
                                "monoisotopic_mz": "512.7513",
                                "intensity": "10514.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "11",
                                "monoisotopic_mass": "8169.0260",
                                "monoisotopic_mz": "743.6460",
                                "intensity": "9933.81",
                                "charge": "11"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "12",
                                "monoisotopic_mass": "2774.0317",
                                "monoisotopic_mz": "694.5152",
                                "intensity": "11171.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "13",
                                "monoisotopic_mass": "4498.2285",
                                "monoisotopic_mz": "900.6530",
                                "intensity": "5904.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "14",
                                "monoisotopic_mass": "4955.4943",
                                "monoisotopic_mz": "708.9350",
                                "intensity": "5183.40",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "15",
                                "monoisotopic_mass": "8303.0746",
                                "monoisotopic_mz": "692.9302",
                                "intensity": "14328.02",
                                "charge": "12"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "16",
                                "monoisotopic_mass": "8254.0390",
                                "monoisotopic_mz": "688.8439",
                                "intensity": "5622.76",
                                "charge": "12"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "17",
                                "monoisotopic_mass": "3233.5548",
                                "monoisotopic_mz": "647.7182",
                                "intensity": "6202.04",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "18",
                                "monoisotopic_mass": "4955.4954",
                                "monoisotopic_mz": "826.9232",
                                "intensity": "12508.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "19",
                                "monoisotopic_mass": "3233.5554",
                                "monoisotopic_mz": "809.3961",
                                "intensity": "6967.71",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "20",
                                "monoisotopic_mass": "4627.2721",
                                "monoisotopic_mz": "926.4617",
                                "intensity": "7240.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "21",
                                "monoisotopic_mass": "1552.7069",
                                "monoisotopic_mz": "777.3607",
                                "intensity": "5571.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0010",
                                        "ppm": "0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "22",
                                "monoisotopic_mass": "4853.4548",
                                "monoisotopic_mz": "694.3580",
                                "intensity": "6377.33",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "23",
                                "monoisotopic_mass": "3448.6323",
                                "monoisotopic_mz": "863.1654",
                                "intensity": "5692.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "24",
                                "monoisotopic_mass": "3316.5881",
                                "monoisotopic_mz": "830.1543",
                                "intensity": "5752.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "25",
                                "monoisotopic_mass": "5546.7281",
                                "monoisotopic_mz": "694.3483",
                                "intensity": "7622.41",
                                "charge": "8"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "26",
                                "monoisotopic_mass": "3702.7798",
                                "monoisotopic_mz": "926.7022",
                                "intensity": "6333.88",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "27",
                                "monoisotopic_mass": "523.2540",
                                "monoisotopic_mz": "524.2613",
                                "intensity": "3835.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "28",
                                "monoisotopic_mass": "4498.2352",
                                "monoisotopic_mz": "643.6123",
                                "intensity": "8929.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "29",
                                "monoisotopic_mass": "7631.8076",
                                "monoisotopic_mz": "764.1880",
                                "intensity": "5514.47",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7631.8073",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0002",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "30",
                                "monoisotopic_mass": "1152.5306",
                                "monoisotopic_mz": "577.2726",
                                "intensity": "5277.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "31",
                                "monoisotopic_mass": "3447.6372",
                                "monoisotopic_mz": "690.5347",
                                "intensity": "5529.17",
                                "charge": "5"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "32",
                                "monoisotopic_mass": "2236.0495",
                                "monoisotopic_mz": "746.3571",
                                "intensity": "3283.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "33",
                                "monoisotopic_mass": "3288.5891",
                                "monoisotopic_mz": "823.1545",
                                "intensity": "2675.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "34",
                                "monoisotopic_mass": "745.2796",
                                "monoisotopic_mz": "746.2869",
                                "intensity": "3086.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "35",
                                "monoisotopic_mass": "4627.2790",
                                "monoisotopic_mz": "662.0471",
                                "intensity": "2441.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "36",
                                "monoisotopic_mass": "2296.6244",
                                "monoisotopic_mz": "766.5488",
                                "intensity": "3143.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "37",
                                "monoisotopic_mass": "4708.3433",
                                "monoisotopic_mz": "673.6278",
                                "intensity": "2416.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "38",
                                "monoisotopic_mass": "3002.4854",
                                "monoisotopic_mz": "751.6286",
                                "intensity": "1373.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "39",
                                "monoisotopic_mass": "2735.9831",
                                "monoisotopic_mz": "685.0031",
                                "intensity": "2216.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "40",
                                "monoisotopic_mass": "7380.5033",
                                "monoisotopic_mz": "671.9621",
                                "intensity": "1398.25",
                                "charge": "11"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "41",
                                "monoisotopic_mass": "732.8179",
                                "monoisotopic_mz": "733.8252",
                                "intensity": "1777.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "42",
                                "monoisotopic_mass": "1379.1798",
                                "monoisotopic_mz": "690.5972",
                                "intensity": "2252.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "43",
                                "monoisotopic_mass": "2069.0171",
                                "monoisotopic_mz": "690.6796",
                                "intensity": "5590.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "44",
                                "monoisotopic_mass": "781.8891",
                                "monoisotopic_mz": "782.8964",
                                "intensity": "1178.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "45",
                                "monoisotopic_mass": "6964.4636",
                                "monoisotopic_mz": "697.4536",
                                "intensity": "715.89",
                                "charge": "10"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "46",
                                "monoisotopic_mass": "5088.5806",
                                "monoisotopic_mz": "727.9474",
                                "intensity": "793.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "47",
                                "monoisotopic_mass": "6154.0603",
                                "monoisotopic_mz": "684.7918",
                                "intensity": "1416.84",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "48",
                                "monoisotopic_mass": "2963.8022",
                                "monoisotopic_mz": "741.9578",
                                "intensity": "1549.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "49",
                                "monoisotopic_mass": "7592.3822",
                                "monoisotopic_mz": "691.2238",
                                "intensity": "1370.84",
                                "charge": "11"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "50",
                                "monoisotopic_mass": "694.0928",
                                "monoisotopic_mz": "695.1001",
                                "intensity": "3864.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "51",
                                "monoisotopic_mass": "2217.7694",
                                "monoisotopic_mz": "740.2637",
                                "intensity": "2807.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "52",
                                "monoisotopic_mass": "5441.0637",
                                "monoisotopic_mz": "778.3021",
                                "intensity": "1012.29",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "53",
                                "monoisotopic_mass": "5784.9313",
                                "monoisotopic_mz": "643.7774",
                                "intensity": "1141.72",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "54",
                                "monoisotopic_mass": "2523.9395",
                                "monoisotopic_mz": "842.3204",
                                "intensity": "2437.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "55",
                                "monoisotopic_mass": "2847.4599",
                                "monoisotopic_mz": "712.8723",
                                "intensity": "2604.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "56",
                                "monoisotopic_mass": "6542.2942",
                                "monoisotopic_mz": "727.9289",
                                "intensity": "939.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "57",
                                "monoisotopic_mass": "5944.7511",
                                "monoisotopic_mz": "744.1012",
                                "intensity": "1228.71",
                                "charge": "8"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "58",
                                "monoisotopic_mass": "7554.7785",
                                "monoisotopic_mz": "687.8053",
                                "intensity": "1228.22",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7553.7525",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0236",
                                        "ppm": "3.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "59",
                                "monoisotopic_mass": "6779.4316",
                                "monoisotopic_mz": "678.9504",
                                "intensity": "1311.56",
                                "charge": "10"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "60",
                                "monoisotopic_mass": "8151.0141",
                                "monoisotopic_mz": "742.0086",
                                "intensity": "1124.61",
                                "charge": "11"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "61",
                                "monoisotopic_mass": "1393.0891",
                                "monoisotopic_mz": "697.5518",
                                "intensity": "607.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "62",
                                "monoisotopic_mass": "1468.5477",
                                "monoisotopic_mz": "735.2811",
                                "intensity": "712.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "63",
                                "monoisotopic_mass": "797.4037",
                                "monoisotopic_mz": "798.4109",
                                "intensity": "1079.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "64",
                                "monoisotopic_mass": "825.1426",
                                "monoisotopic_mz": "826.1499",
                                "intensity": "1554.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "65",
                                "monoisotopic_mass": "6663.7953",
                                "monoisotopic_mz": "741.4290",
                                "intensity": "3170.43",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "66",
                                "monoisotopic_mass": "6226.0530",
                                "monoisotopic_mz": "692.7909",
                                "intensity": "2490.21",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "67",
                                "monoisotopic_mass": "8271.0803",
                                "monoisotopic_mz": "690.2640",
                                "intensity": "2468.67",
                                "charge": "12"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "68",
                                "monoisotopic_mass": "6937.5335",
                                "monoisotopic_mz": "771.8443",
                                "intensity": "943.96",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "69",
                                "monoisotopic_mass": "1294.4257",
                                "monoisotopic_mz": "648.2201",
                                "intensity": "354.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "70",
                                "monoisotopic_mass": "5302.9899",
                                "monoisotopic_mz": "663.8810",
                                "intensity": "927.34",
                                "charge": "8"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "71",
                                "monoisotopic_mass": "4814.9297",
                                "monoisotopic_mz": "688.8544",
                                "intensity": "2520.26",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "72",
                                "monoisotopic_mass": "6733.7577",
                                "monoisotopic_mz": "842.7270",
                                "intensity": "2059.25",
                                "charge": "8"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "73",
                                "monoisotopic_mass": "3214.5430",
                                "monoisotopic_mz": "804.6430",
                                "intensity": "2234.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "74",
                                "monoisotopic_mass": "7342.9236",
                                "monoisotopic_mz": "735.2996",
                                "intensity": "2389.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "75",
                                "monoisotopic_mass": "5774.9175",
                                "monoisotopic_mz": "722.8720",
                                "intensity": "3247.57",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5773.8435",
                                        "ion_position": "22",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0716",
                                        "ppm": "12.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "76",
                                "monoisotopic_mass": "5019.1091",
                                "monoisotopic_mz": "718.0229",
                                "intensity": "745.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "77",
                                "monoisotopic_mass": "4441.7511",
                                "monoisotopic_mz": "741.2991",
                                "intensity": "2885.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "78",
                                "monoisotopic_mass": "7120.6614",
                                "monoisotopic_mz": "713.0734",
                                "intensity": "849.02",
                                "charge": "10"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "79",
                                "monoisotopic_mass": "2195.8333",
                                "monoisotopic_mz": "732.9517",
                                "intensity": "1530.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "80",
                                "monoisotopic_mass": "6368.1813",
                                "monoisotopic_mz": "708.5830",
                                "intensity": "2547.92",
                                "charge": "9"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "81",
                                "monoisotopic_mass": "2503.3081",
                                "monoisotopic_mz": "835.4433",
                                "intensity": "2481.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "82",
                                "monoisotopic_mass": "3334.6920",
                                "monoisotopic_mz": "667.9457",
                                "intensity": "918.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "83",
                                "monoisotopic_mass": "5897.7520",
                                "monoisotopic_mz": "738.2263",
                                "intensity": "990.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "84",
                                "monoisotopic_mass": "6726.1812",
                                "monoisotopic_mz": "673.6254",
                                "intensity": "1454.21",
                                "charge": "10"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "85",
                                "monoisotopic_mass": "2868.9847",
                                "monoisotopic_mz": "718.2534",
                                "intensity": "909.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "86",
                                "monoisotopic_mass": "2000.1503",
                                "monoisotopic_mz": "667.7240",
                                "intensity": "791.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "87",
                                "monoisotopic_mass": "4307.7654",
                                "monoisotopic_mz": "718.9682",
                                "intensity": "731.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "88",
                                "monoisotopic_mass": "859.8698",
                                "monoisotopic_mz": "860.8771",
                                "intensity": "775.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "89",
                                "monoisotopic_mass": "3850.3465",
                                "monoisotopic_mz": "771.0766",
                                "intensity": "3107.73",
                                "charge": "5"
                            },
                            {
                                "spec_id": "52",
                                "peak_id": "90",
                                "monoisotopic_mass": "657.1833",
                                "monoisotopic_mz": "658.1906",
                                "intensity": "931.38",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "52",
                                        "peak_id": "7",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "spec_id": "52",
                                        "peak_id": "29",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "22",
                                        "ion_display_position": "47",
                                        "spec_id": "52",
                                        "peak_id": "75",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "52",
                                            "peak_id": "17",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "52",
                                            "peak_id": "19",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "40",
                                            "spec_id": "52",
                                            "peak_id": "14",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "40",
                                            "spec_id": "52",
                                            "peak_id": "18",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "52",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "52",
                                            "peak_id": "6",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "52",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "52",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "spec_id": "52",
                                        "peak_id": "26",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "52",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "52",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "52",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "52",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "52",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "spec_id": "52",
                                        "peak_id": "58",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "52",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "37",
                "p_value": "4.52e-10",
                "e_value": "4.52e-10",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "70",
                        "ms1_scans": "116",
                        "ids": "46",
                        "scans": "118",
                        "precursor_mono_mass": "8320.0632",
                        "precursor_charge": "13",
                        "precursor_mz": "641.0121",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "46",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3680",
                                "monoisotopic_mz": "791.2353",
                                "intensity": "8064.52",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0043",
                                        "ppm": "0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "1",
                                "monoisotopic_mass": "1453.6373",
                                "monoisotopic_mz": "727.8259",
                                "intensity": "5380.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "2",
                                "monoisotopic_mass": "1338.6108",
                                "monoisotopic_mz": "670.3127",
                                "intensity": "4962.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "0.0002",
                                        "ppm": "0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "3",
                                "monoisotopic_mass": "4742.3696",
                                "monoisotopic_mz": "678.4887",
                                "intensity": "6583.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "4",
                                "monoisotopic_mass": "4628.2769",
                                "monoisotopic_mz": "772.3868",
                                "intensity": "6342.73",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "5",
                                "monoisotopic_mass": "1902.1750",
                                "monoisotopic_mz": "635.0656",
                                "intensity": "5078.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "6",
                                "monoisotopic_mass": "4854.4481",
                                "monoisotopic_mz": "694.4999",
                                "intensity": "3710.44",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4854.4478",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0003",
                                        "ppm": "0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "7",
                                "monoisotopic_mass": "1919.1816",
                                "monoisotopic_mz": "640.7345",
                                "intensity": "2745.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "8",
                                "monoisotopic_mass": "3850.0595",
                                "monoisotopic_mz": "642.6839",
                                "intensity": "2775.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "9",
                                "monoisotopic_mass": "2305.1348",
                                "monoisotopic_mz": "769.3856",
                                "intensity": "5045.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "10",
                                "monoisotopic_mass": "1264.7950",
                                "monoisotopic_mz": "633.4048",
                                "intensity": "1711.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "11",
                                "monoisotopic_mass": "1023.4892",
                                "monoisotopic_mz": "512.7519",
                                "intensity": "3483.78",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0006",
                                        "ppm": "0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "12",
                                "monoisotopic_mass": "2724.3472",
                                "monoisotopic_mz": "682.0941",
                                "intensity": "3301.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "13",
                                "monoisotopic_mass": "3233.5529",
                                "monoisotopic_mz": "647.7178",
                                "intensity": "3899.01",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "14",
                                "monoisotopic_mass": "2606.6015",
                                "monoisotopic_mz": "652.6576",
                                "intensity": "1714.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "15",
                                "monoisotopic_mass": "1152.5305",
                                "monoisotopic_mz": "577.2725",
                                "intensity": "1595.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "16",
                                "monoisotopic_mass": "677.3367",
                                "monoisotopic_mz": "678.3439",
                                "intensity": "1374.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "17",
                                "monoisotopic_mass": "1277.7102",
                                "monoisotopic_mz": "639.8624",
                                "intensity": "2267.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "18",
                                "monoisotopic_mass": "1361.5022",
                                "monoisotopic_mz": "681.7584",
                                "intensity": "1395.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "19",
                                "monoisotopic_mass": "2049.2658",
                                "monoisotopic_mz": "684.0959",
                                "intensity": "1332.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "20",
                                "monoisotopic_mass": "640.2766",
                                "monoisotopic_mz": "641.2839",
                                "intensity": "1118.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "21",
                                "monoisotopic_mass": "1780.8184",
                                "monoisotopic_mz": "891.4165",
                                "intensity": "930.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1780.8169",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "56",
                                        "mass_error": "0.0015",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "22",
                                "monoisotopic_mass": "1552.7053",
                                "monoisotopic_mz": "777.3599",
                                "intensity": "2223.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "23",
                                "monoisotopic_mass": "7677.8572",
                                "monoisotopic_mz": "640.8287",
                                "intensity": "820.35",
                                "charge": "12"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "24",
                                "monoisotopic_mass": "3233.5598",
                                "monoisotopic_mz": "809.3972",
                                "intensity": "4277.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0034",
                                        "ppm": "1.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "25",
                                "monoisotopic_mass": "598.3603",
                                "monoisotopic_mz": "599.3676",
                                "intensity": "1234.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "26",
                                "monoisotopic_mass": "3197.5647",
                                "monoisotopic_mz": "640.5202",
                                "intensity": "2277.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "27",
                                "monoisotopic_mass": "4486.6091",
                                "monoisotopic_mz": "641.9514",
                                "intensity": "1340.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "28",
                                "monoisotopic_mass": "4500.2419",
                                "monoisotopic_mz": "751.0476",
                                "intensity": "1188.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "29",
                                "monoisotopic_mass": "4629.2852",
                                "monoisotopic_mz": "926.8643",
                                "intensity": "2444.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "30",
                                "monoisotopic_mass": "1181.9851",
                                "monoisotopic_mz": "591.9998",
                                "intensity": "593.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "31",
                                "monoisotopic_mass": "1398.1556",
                                "monoisotopic_mz": "700.0851",
                                "intensity": "578.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "32",
                                "monoisotopic_mass": "1499.7453",
                                "monoisotopic_mz": "750.8799",
                                "intensity": "1263.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "33",
                                "monoisotopic_mass": "1476.1003",
                                "monoisotopic_mz": "739.0574",
                                "intensity": "498.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "34",
                                "monoisotopic_mass": "2241.6174",
                                "monoisotopic_mz": "748.2131",
                                "intensity": "1100.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "35",
                                "monoisotopic_mass": "708.3664",
                                "monoisotopic_mz": "709.3736",
                                "intensity": "906.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "36",
                                "monoisotopic_mass": "663.5369",
                                "monoisotopic_mz": "664.5442",
                                "intensity": "836.06",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "46",
                                            "peak_id": "13",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "46",
                                            "peak_id": "24",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "spec_id": "46",
                                        "peak_id": "6",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "46",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "46",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "spec_id": "46",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "46",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "46",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "46",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "46",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "46",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "85",
                "p_value": "1.75e-09",
                "e_value": "1.75e-09",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "93",
                        "ms1_scans": "212",
                        "ids": "119",
                        "scans": "214",
                        "precursor_mono_mass": "8320.0703",
                        "precursor_charge": "10",
                        "precursor_mz": "833.0143",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "119",
                                "peak_id": "0",
                                "monoisotopic_mass": "4160.5467",
                                "monoisotopic_mz": "833.1166",
                                "intensity": "67479.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "1",
                                "monoisotopic_mass": "8302.0831",
                                "monoisotopic_mz": "831.2156",
                                "intensity": "39229.98",
                                "charge": "10"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "2",
                                "monoisotopic_mass": "4628.2789",
                                "monoisotopic_mz": "926.6631",
                                "intensity": "22616.66",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "3",
                                "monoisotopic_mass": "4741.3636",
                                "monoisotopic_mz": "949.2800",
                                "intensity": "39010.92",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "4",
                                "monoisotopic_mass": "5942.0338",
                                "monoisotopic_mz": "991.3462",
                                "intensity": "19549.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "5",
                                "monoisotopic_mass": "4499.2359",
                                "monoisotopic_mz": "900.8545",
                                "intensity": "16704.82",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "6",
                                "monoisotopic_mass": "7478.8711",
                                "monoisotopic_mz": "831.9930",
                                "intensity": "19680.16",
                                "charge": "9"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "7",
                                "monoisotopic_mass": "4853.4414",
                                "monoisotopic_mz": "971.6956",
                                "intensity": "14493.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "8",
                                "monoisotopic_mass": "8189.0529",
                                "monoisotopic_mz": "910.9020",
                                "intensity": "16008.34",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "0.0010",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "9",
                                "monoisotopic_mass": "1338.6102",
                                "monoisotopic_mz": "670.3124",
                                "intensity": "12507.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "10",
                                "monoisotopic_mass": "7944.9081",
                                "monoisotopic_mz": "883.7748",
                                "intensity": "10876.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "11",
                                "monoisotopic_mass": "1664.2181",
                                "monoisotopic_mz": "833.1163",
                                "intensity": "45567.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "12",
                                "monoisotopic_mass": "8075.0059",
                                "monoisotopic_mz": "898.2302",
                                "intensity": "17079.62",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "13",
                                "monoisotopic_mass": "6981.4750",
                                "monoisotopic_mz": "873.6917",
                                "intensity": "17864.92",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6981.4818",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "B00060",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0068",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "14",
                                "monoisotopic_mass": "6083.0474",
                                "monoisotopic_mz": "870.0141",
                                "intensity": "7759.26",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6083.0422",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "0.0052",
                                        "ppm": "0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "15",
                                "monoisotopic_mass": "8285.0488",
                                "monoisotopic_mz": "829.5122",
                                "intensity": "15174.66",
                                "charge": "10"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "16",
                                "monoisotopic_mass": "4741.3657",
                                "monoisotopic_mz": "791.2349",
                                "intensity": "10742.00",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0020",
                                        "ppm": "0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "17",
                                "monoisotopic_mass": "3465.6448",
                                "monoisotopic_mz": "867.4185",
                                "intensity": "4964.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3465.6446",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0003",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "18",
                                "monoisotopic_mass": "4955.5044",
                                "monoisotopic_mz": "992.1082",
                                "intensity": "11303.44",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0089",
                                        "ppm": "1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "19",
                                "monoisotopic_mass": "3447.6319",
                                "monoisotopic_mz": "862.9153",
                                "intensity": "8151.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "20",
                                "monoisotopic_mass": "1023.4878",
                                "monoisotopic_mz": "512.7512",
                                "intensity": "5686.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "21",
                                "monoisotopic_mass": "4955.4852",
                                "monoisotopic_mz": "826.9215",
                                "intensity": "5219.12",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0103",
                                        "ppm": "-2.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "22",
                                "monoisotopic_mass": "2495.9271",
                                "monoisotopic_mz": "832.9830",
                                "intensity": "1785.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "23",
                                "monoisotopic_mass": "8074.0102",
                                "monoisotopic_mz": "808.4083",
                                "intensity": "5199.51",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0036",
                                        "ppm": "0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "24",
                                "monoisotopic_mass": "827.7074",
                                "monoisotopic_mz": "828.7147",
                                "intensity": "2786.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "25",
                                "monoisotopic_mass": "1780.8181",
                                "monoisotopic_mz": "891.4163",
                                "intensity": "2760.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1780.8169",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "56",
                                        "mass_error": "0.0012",
                                        "ppm": "0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "26",
                                "monoisotopic_mass": "7828.8823",
                                "monoisotopic_mz": "870.8831",
                                "intensity": "1688.03",
                                "charge": "9"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "27",
                                "monoisotopic_mass": "3516.5762",
                                "monoisotopic_mz": "880.1513",
                                "intensity": "2860.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "28",
                                "monoisotopic_mass": "4099.5102",
                                "monoisotopic_mz": "820.9093",
                                "intensity": "1068.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "29",
                                "monoisotopic_mass": "523.2538",
                                "monoisotopic_mz": "524.2611",
                                "intensity": "2261.14",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0005",
                                        "ppm": "-1.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "30",
                                "monoisotopic_mass": "3702.7761",
                                "monoisotopic_mz": "926.7013",
                                "intensity": "3076.23",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0055",
                                        "ppm": "-1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "31",
                                "monoisotopic_mass": "6040.0973",
                                "monoisotopic_mz": "1007.6902",
                                "intensity": "4160.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "32",
                                "monoisotopic_mass": "2427.2211",
                                "monoisotopic_mz": "810.0810",
                                "intensity": "4530.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "33",
                                "monoisotopic_mass": "4975.5953",
                                "monoisotopic_mz": "830.2732",
                                "intensity": "1386.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "34",
                                "monoisotopic_mass": "1804.9109",
                                "monoisotopic_mz": "903.4627",
                                "intensity": "2162.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "35",
                                "monoisotopic_mass": "1819.6820",
                                "monoisotopic_mz": "910.8483",
                                "intensity": "2533.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "36",
                                "monoisotopic_mass": "2823.8812",
                                "monoisotopic_mz": "942.3010",
                                "intensity": "4102.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "37",
                                "monoisotopic_mass": "4122.5273",
                                "monoisotopic_mz": "825.5127",
                                "intensity": "3176.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "38",
                                "monoisotopic_mass": "856.3160",
                                "monoisotopic_mz": "857.3232",
                                "intensity": "1343.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "39",
                                "monoisotopic_mass": "1610.3867",
                                "monoisotopic_mz": "806.2006",
                                "intensity": "1612.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "40",
                                "monoisotopic_mass": "7641.1851",
                                "monoisotopic_mz": "956.1554",
                                "intensity": "1234.34",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "41",
                                "monoisotopic_mass": "6171.4078",
                                "monoisotopic_mz": "1029.5752",
                                "intensity": "1239.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "42",
                                "monoisotopic_mass": "761.8541",
                                "monoisotopic_mz": "762.8614",
                                "intensity": "4115.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "43",
                                "monoisotopic_mass": "613.3146",
                                "monoisotopic_mz": "614.3219",
                                "intensity": "1460.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "44",
                                "monoisotopic_mass": "5926.0421",
                                "monoisotopic_mz": "988.6810",
                                "intensity": "2512.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "45",
                                "monoisotopic_mass": "5003.5774",
                                "monoisotopic_mz": "834.9368",
                                "intensity": "1164.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "46",
                                "monoisotopic_mass": "6944.4383",
                                "monoisotopic_mz": "869.0621",
                                "intensity": "976.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "47",
                                "monoisotopic_mass": "1872.9857",
                                "monoisotopic_mz": "937.5001",
                                "intensity": "1043.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "48",
                                "monoisotopic_mass": "911.4440",
                                "monoisotopic_mz": "912.4513",
                                "intensity": "1868.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "49",
                                "monoisotopic_mass": "5715.3518",
                                "monoisotopic_mz": "953.5659",
                                "intensity": "1134.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "50",
                                "monoisotopic_mass": "1844.5531",
                                "monoisotopic_mz": "923.2838",
                                "intensity": "1309.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "51",
                                "monoisotopic_mass": "977.0173",
                                "monoisotopic_mz": "978.0246",
                                "intensity": "1711.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "52",
                                "monoisotopic_mass": "5755.9573",
                                "monoisotopic_mz": "823.2869",
                                "intensity": "3367.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "53",
                                "monoisotopic_mass": "6375.9301",
                                "monoisotopic_mz": "911.8544",
                                "intensity": "1312.40",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "54",
                                "monoisotopic_mass": "4050.3897",
                                "monoisotopic_mz": "1013.6047",
                                "intensity": "1071.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "55",
                                "monoisotopic_mass": "3104.4057",
                                "monoisotopic_mz": "777.1087",
                                "intensity": "2853.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "56",
                                "monoisotopic_mass": "3581.3232",
                                "monoisotopic_mz": "896.3381",
                                "intensity": "2904.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "57",
                                "monoisotopic_mass": "7293.0178",
                                "monoisotopic_mz": "912.6345",
                                "intensity": "2325.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "58",
                                "monoisotopic_mass": "801.2804",
                                "monoisotopic_mz": "802.2877",
                                "intensity": "1227.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "59",
                                "monoisotopic_mass": "7928.9904",
                                "monoisotopic_mz": "882.0062",
                                "intensity": "1636.47",
                                "charge": "9"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "60",
                                "monoisotopic_mass": "1436.7662",
                                "monoisotopic_mz": "479.9294",
                                "intensity": "1383.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "61",
                                "monoisotopic_mass": "5706.9803",
                                "monoisotopic_mz": "816.2902",
                                "intensity": "1620.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "62",
                                "monoisotopic_mass": "7038.4438",
                                "monoisotopic_mz": "880.8127",
                                "intensity": "3022.27",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "63",
                                "monoisotopic_mass": "6229.9368",
                                "monoisotopic_mz": "890.9982",
                                "intensity": "1697.14",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "64",
                                "monoisotopic_mass": "6861.1601",
                                "monoisotopic_mz": "858.6523",
                                "intensity": "954.54",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "65",
                                "monoisotopic_mass": "7701.8549",
                                "monoisotopic_mz": "963.7391",
                                "intensity": "3212.42",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7702.8445",
                                        "ion_position": "5",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0128",
                                        "ppm": "1.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "66",
                                "monoisotopic_mass": "2809.5102",
                                "monoisotopic_mz": "937.5107",
                                "intensity": "1731.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "67",
                                "monoisotopic_mass": "6502.1556",
                                "monoisotopic_mz": "813.7767",
                                "intensity": "3381.12",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6501.2088",
                                        "ion_position": "16",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0556",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "68",
                                "monoisotopic_mass": "6343.7512",
                                "monoisotopic_mz": "907.2575",
                                "intensity": "1272.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "69",
                                "monoisotopic_mass": "6399.1420",
                                "monoisotopic_mz": "915.1704",
                                "intensity": "3385.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "70",
                                "monoisotopic_mass": "3197.1431",
                                "monoisotopic_mz": "800.2931",
                                "intensity": "2028.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "71",
                                "monoisotopic_mass": "6730.1899",
                                "monoisotopic_mz": "842.2810",
                                "intensity": "1347.59",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "72",
                                "monoisotopic_mass": "4007.1159",
                                "monoisotopic_mz": "802.4305",
                                "intensity": "961.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "73",
                                "monoisotopic_mass": "2599.6161",
                                "monoisotopic_mz": "867.5460",
                                "intensity": "2638.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "74",
                                "monoisotopic_mass": "6664.9663",
                                "monoisotopic_mz": "834.1281",
                                "intensity": "2378.16",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "75",
                                "monoisotopic_mass": "5409.9041",
                                "monoisotopic_mz": "902.6580",
                                "intensity": "960.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "76",
                                "monoisotopic_mass": "3965.5112",
                                "monoisotopic_mz": "794.1095",
                                "intensity": "936.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "77",
                                "monoisotopic_mass": "7422.8607",
                                "monoisotopic_mz": "825.7696",
                                "intensity": "1020.10",
                                "charge": "9"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "78",
                                "monoisotopic_mass": "4808.6962",
                                "monoisotopic_mz": "962.7465",
                                "intensity": "1342.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "79",
                                "monoisotopic_mass": "1908.9153",
                                "monoisotopic_mz": "955.4649",
                                "intensity": "1211.76",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1908.9119",
                                        "ion_position": "55",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0034",
                                        "ppm": "1.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "80",
                                "monoisotopic_mass": "3376.7747",
                                "monoisotopic_mz": "845.2010",
                                "intensity": "2101.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "81",
                                "monoisotopic_mass": "1022.0678",
                                "monoisotopic_mz": "1023.0751",
                                "intensity": "843.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "82",
                                "monoisotopic_mass": "2858.2589",
                                "monoisotopic_mz": "953.7602",
                                "intensity": "1162.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "83",
                                "monoisotopic_mass": "4937.7378",
                                "monoisotopic_mz": "823.9636",
                                "intensity": "1161.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "84",
                                "monoisotopic_mass": "3426.2730",
                                "monoisotopic_mz": "857.5755",
                                "intensity": "860.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "85",
                                "monoisotopic_mass": "1090.2946",
                                "monoisotopic_mz": "1091.3019",
                                "intensity": "834.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "86",
                                "monoisotopic_mass": "1441.9731",
                                "monoisotopic_mz": "721.9938",
                                "intensity": "794.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "87",
                                "monoisotopic_mass": "1480.3167",
                                "monoisotopic_mz": "741.1657",
                                "intensity": "891.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "88",
                                "monoisotopic_mass": "840.7956",
                                "monoisotopic_mz": "841.8029",
                                "intensity": "1263.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "89",
                                "monoisotopic_mass": "3290.8009",
                                "monoisotopic_mz": "823.7075",
                                "intensity": "1890.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "90",
                                "monoisotopic_mass": "1062.6390",
                                "monoisotopic_mz": "1063.6463",
                                "intensity": "1162.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "91",
                                "monoisotopic_mass": "4433.6718",
                                "monoisotopic_mz": "887.7416",
                                "intensity": "2247.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "92",
                                "monoisotopic_mass": "7198.6452",
                                "monoisotopic_mz": "900.8379",
                                "intensity": "2544.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "93",
                                "monoisotopic_mass": "990.4914",
                                "monoisotopic_mz": "991.4987",
                                "intensity": "3313.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "94",
                                "monoisotopic_mass": "4464.4407",
                                "monoisotopic_mz": "893.8954",
                                "intensity": "2672.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "95",
                                "monoisotopic_mass": "2776.7754",
                                "monoisotopic_mz": "926.5991",
                                "intensity": "1607.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "96",
                                "monoisotopic_mass": "1042.6632",
                                "monoisotopic_mz": "1043.6704",
                                "intensity": "913.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "119",
                                "peak_id": "97",
                                "monoisotopic_mass": "1006.3422",
                                "monoisotopic_mz": "1007.3495",
                                "intensity": "977.26",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "119",
                                        "peak_id": "8",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "67",
                                            "spec_id": "119",
                                            "peak_id": "12",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "67",
                                            "spec_id": "119",
                                            "peak_id": "23",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "5",
                                        "ion_display_position": "64",
                                        "spec_id": "119",
                                        "peak_id": "65",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "53",
                                        "spec_id": "119",
                                        "peak_id": "67",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "40",
                                            "spec_id": "119",
                                            "peak_id": "21",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "40",
                                            "spec_id": "119",
                                            "peak_id": "18",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "119",
                                        "peak_id": "17",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "119",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "119",
                                            "peak_id": "16",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "119",
                                        "peak_id": "2",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "119",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "spec_id": "119",
                                        "peak_id": "30",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "119",
                                        "peak_id": "14",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "14",
                                        "spec_id": "119",
                                        "peak_id": "79",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "spec_id": "119",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "60",
                                            "ion_display_position": "9",
                                            "spec_id": "119",
                                            "peak_id": "9",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "119",
                                            "peak_id": "13",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "119",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "119",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "97",
                "p_value": "1.23e-08",
                "e_value": "1.23e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "98",
                        "ms1_scans": "230",
                        "ids": "132",
                        "scans": "232",
                        "precursor_mono_mass": "8319.0809",
                        "precursor_charge": "13",
                        "precursor_mz": "640.9366",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "132",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3647",
                                "monoisotopic_mz": "791.2347",
                                "intensity": "8606.55",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0009",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "1",
                                "monoisotopic_mass": "4742.3683",
                                "monoisotopic_mz": "678.4885",
                                "intensity": "8491.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "2",
                                "monoisotopic_mass": "4628.2846",
                                "monoisotopic_mz": "772.3881",
                                "intensity": "6658.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0050",
                                        "ppm": "1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "3",
                                "monoisotopic_mass": "1453.6372",
                                "monoisotopic_mz": "727.8259",
                                "intensity": "4448.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "4",
                                "monoisotopic_mass": "4610.2754",
                                "monoisotopic_mz": "769.3865",
                                "intensity": "6322.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "5",
                                "monoisotopic_mass": "1338.6109",
                                "monoisotopic_mz": "670.3127",
                                "intensity": "6394.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "0.0004",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "6",
                                "monoisotopic_mass": "4499.2396",
                                "monoisotopic_mz": "750.8805",
                                "intensity": "6620.27",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0025",
                                        "ppm": "0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "7",
                                "monoisotopic_mass": "3233.5554",
                                "monoisotopic_mz": "647.7184",
                                "intensity": "4082.80",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "8",
                                "monoisotopic_mass": "4609.2688",
                                "monoisotopic_mz": "659.4742",
                                "intensity": "5834.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "9",
                                "monoisotopic_mass": "4854.4443",
                                "monoisotopic_mz": "694.4993",
                                "intensity": "5686.93",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4854.4478",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "10",
                                "monoisotopic_mass": "1282.8048",
                                "monoisotopic_mz": "642.4097",
                                "intensity": "3330.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "11",
                                "monoisotopic_mass": "1023.4878",
                                "monoisotopic_mz": "512.7512",
                                "intensity": "3563.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "12",
                                "monoisotopic_mass": "8169.0261",
                                "monoisotopic_mz": "681.7594",
                                "intensity": "1563.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "13",
                                "monoisotopic_mass": "1152.5316",
                                "monoisotopic_mz": "577.2731",
                                "intensity": "2057.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0003",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "14",
                                "monoisotopic_mass": "3318.5954",
                                "monoisotopic_mz": "664.7263",
                                "intensity": "1168.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "15",
                                "monoisotopic_mass": "776.3540",
                                "monoisotopic_mz": "777.3613",
                                "intensity": "1515.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "16",
                                "monoisotopic_mass": "639.3905",
                                "monoisotopic_mz": "640.3978",
                                "intensity": "1095.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "17",
                                "monoisotopic_mass": "3216.5381",
                                "monoisotopic_mz": "644.3149",
                                "intensity": "961.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "18",
                                "monoisotopic_mass": "6123.5194",
                                "monoisotopic_mz": "681.3983",
                                "intensity": "929.00",
                                "charge": "9"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "19",
                                "monoisotopic_mass": "1901.1794",
                                "monoisotopic_mz": "634.7337",
                                "intensity": "2070.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "20",
                                "monoisotopic_mass": "1263.7803",
                                "monoisotopic_mz": "632.8974",
                                "intensity": "3101.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "21",
                                "monoisotopic_mass": "3837.1055",
                                "monoisotopic_mz": "640.5249",
                                "intensity": "818.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "22",
                                "monoisotopic_mass": "8302.0594",
                                "monoisotopic_mz": "639.6272",
                                "intensity": "2205.95",
                                "charge": "13"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "23",
                                "monoisotopic_mass": "1363.5180",
                                "monoisotopic_mz": "682.7663",
                                "intensity": "389.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "24",
                                "monoisotopic_mass": "5758.7596",
                                "monoisotopic_mz": "640.8695",
                                "intensity": "910.79",
                                "charge": "9"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "25",
                                "monoisotopic_mass": "3341.1736",
                                "monoisotopic_mz": "669.2420",
                                "intensity": "713.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "26",
                                "monoisotopic_mass": "1486.2372",
                                "monoisotopic_mz": "496.4197",
                                "intensity": "403.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "27",
                                "monoisotopic_mass": "2220.6057",
                                "monoisotopic_mz": "741.2092",
                                "intensity": "510.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "28",
                                "monoisotopic_mass": "1240.6744",
                                "monoisotopic_mz": "621.3445",
                                "intensity": "489.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "29",
                                "monoisotopic_mass": "4500.2420",
                                "monoisotopic_mz": "643.8990",
                                "intensity": "3532.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "30",
                                "monoisotopic_mass": "3203.5588",
                                "monoisotopic_mz": "641.7190",
                                "intensity": "712.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "31",
                                "monoisotopic_mass": "1319.3663",
                                "monoisotopic_mz": "660.6904",
                                "intensity": "276.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "32",
                                "monoisotopic_mass": "1416.1415",
                                "monoisotopic_mz": "709.0780",
                                "intensity": "993.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "33",
                                "monoisotopic_mass": "1431.8065",
                                "monoisotopic_mz": "716.9105",
                                "intensity": "488.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "34",
                                "monoisotopic_mass": "741.4205",
                                "monoisotopic_mz": "742.4278",
                                "intensity": "583.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "35",
                                "monoisotopic_mass": "1379.6732",
                                "monoisotopic_mz": "690.8439",
                                "intensity": "460.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "36",
                                "monoisotopic_mass": "4309.7293",
                                "monoisotopic_mz": "719.2955",
                                "intensity": "997.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "37",
                                "monoisotopic_mass": "4443.0889",
                                "monoisotopic_mz": "635.7343",
                                "intensity": "847.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "38",
                                "monoisotopic_mass": "1480.7614",
                                "monoisotopic_mz": "741.3880",
                                "intensity": "363.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "39",
                                "monoisotopic_mass": "763.9834",
                                "monoisotopic_mz": "764.9907",
                                "intensity": "870.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "132",
                                "peak_id": "40",
                                "monoisotopic_mass": "620.6909",
                                "monoisotopic_mz": "621.6981",
                                "intensity": "971.63",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "132",
                                        "peak_id": "7",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "39",
                                        "spec_id": "132",
                                        "peak_id": "9",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "132",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "132",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "132",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "132",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "132",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "132",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "132",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "27",
                "p_value": "3.39e-08",
                "e_value": "3.39e-08",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "66",
                        "ms1_scans": "99",
                        "ids": "33",
                        "scans": "101",
                        "precursor_mono_mass": "8319.0486",
                        "precursor_charge": "10",
                        "precursor_mz": "832.9121",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "33",
                                "peak_id": "0",
                                "monoisotopic_mass": "4161.0432",
                                "monoisotopic_mz": "833.2159",
                                "intensity": "81554.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "1",
                                "monoisotopic_mass": "4741.3624",
                                "monoisotopic_mz": "949.2798",
                                "intensity": "25433.53",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "2",
                                "monoisotopic_mass": "8301.0713",
                                "monoisotopic_mz": "831.1144",
                                "intensity": "22428.46",
                                "charge": "10"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "3",
                                "monoisotopic_mass": "4628.2856",
                                "monoisotopic_mz": "926.6644",
                                "intensity": "13474.97",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0059",
                                        "ppm": "1.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "4",
                                "monoisotopic_mass": "5942.0382",
                                "monoisotopic_mz": "991.3470",
                                "intensity": "22033.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "5",
                                "monoisotopic_mass": "7476.8608",
                                "monoisotopic_mz": "831.7696",
                                "intensity": "14779.49",
                                "charge": "9"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "6",
                                "monoisotopic_mass": "1338.6097",
                                "monoisotopic_mz": "670.3121",
                                "intensity": "8740.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "7",
                                "monoisotopic_mass": "8075.0043",
                                "monoisotopic_mz": "898.2300",
                                "intensity": "12327.20",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0047",
                                        "ppm": "-0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "8",
                                "monoisotopic_mass": "1664.4207",
                                "monoisotopic_mz": "833.2177",
                                "intensity": "30689.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "9",
                                "monoisotopic_mass": "4499.2320",
                                "monoisotopic_mz": "900.8537",
                                "intensity": "11933.35",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0051",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "10",
                                "monoisotopic_mass": "3446.6366",
                                "monoisotopic_mz": "862.6664",
                                "intensity": "7676.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "11",
                                "monoisotopic_mass": "4853.4419",
                                "monoisotopic_mz": "971.6957",
                                "intensity": "8522.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "12",
                                "monoisotopic_mass": "4740.3572",
                                "monoisotopic_mz": "791.0668",
                                "intensity": "11256.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "13",
                                "monoisotopic_mass": "4954.5086",
                                "monoisotopic_mz": "991.9090",
                                "intensity": "13397.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "14",
                                "monoisotopic_mass": "7946.8961",
                                "monoisotopic_mz": "883.9957",
                                "intensity": "11987.24",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7946.9140",
                                        "ion_position": "3",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0179",
                                        "ppm": "-2.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "15",
                                "monoisotopic_mass": "832.9095",
                                "monoisotopic_mz": "833.9168",
                                "intensity": "3733.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "16",
                                "monoisotopic_mass": "4955.4984",
                                "monoisotopic_mz": "826.9237",
                                "intensity": "3764.08",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0029",
                                        "ppm": "0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "17",
                                "monoisotopic_mass": "6540.2705",
                                "monoisotopic_mz": "818.5411",
                                "intensity": "1996.52",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6539.2754",
                                        "ion_position": "56",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "B00056",
                                        "ion_left_position": "56",
                                        "mass_error": "-0.0073",
                                        "ppm": "-1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "18",
                                "monoisotopic_mass": "7491.8672",
                                "monoisotopic_mz": "833.4370",
                                "intensity": "1231.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "19",
                                "monoisotopic_mass": "8074.0132",
                                "monoisotopic_mz": "808.4086",
                                "intensity": "1501.79",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0066",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "20",
                                "monoisotopic_mass": "3465.6444",
                                "monoisotopic_mz": "867.4184",
                                "intensity": "3715.00",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3465.6446",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "21",
                                "monoisotopic_mass": "5160.5343",
                                "monoisotopic_mz": "861.0963",
                                "intensity": "931.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "22",
                                "monoisotopic_mass": "7700.8199",
                                "monoisotopic_mz": "963.6098",
                                "intensity": "1333.20",
                                "charge": "8"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "23",
                                "monoisotopic_mass": "1862.9530",
                                "monoisotopic_mz": "932.4838",
                                "intensity": "1991.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "24",
                                "monoisotopic_mass": "523.2540",
                                "monoisotopic_mz": "524.2613",
                                "intensity": "2350.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "25",
                                "monoisotopic_mass": "2824.8883",
                                "monoisotopic_mz": "942.6367",
                                "intensity": "1132.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "26",
                                "monoisotopic_mass": "6632.2734",
                                "monoisotopic_mz": "830.0415",
                                "intensity": "2564.92",
                                "charge": "8"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "27",
                                "monoisotopic_mass": "908.3381",
                                "monoisotopic_mz": "909.3454",
                                "intensity": "2651.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "28",
                                "monoisotopic_mass": "3817.8870",
                                "monoisotopic_mz": "955.4790",
                                "intensity": "1207.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "29",
                                "monoisotopic_mass": "3701.7835",
                                "monoisotopic_mz": "926.4531",
                                "intensity": "1614.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "30",
                                "monoisotopic_mass": "8262.0135",
                                "monoisotopic_mz": "827.2086",
                                "intensity": "2654.66",
                                "charge": "10"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "31",
                                "monoisotopic_mass": "864.2134",
                                "monoisotopic_mz": "865.2207",
                                "intensity": "1232.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "32",
                                "monoisotopic_mass": "4223.0688",
                                "monoisotopic_mz": "1056.7745",
                                "intensity": "942.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "33",
                                "monoisotopic_mass": "6687.3416",
                                "monoisotopic_mz": "836.9250",
                                "intensity": "1237.86",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6686.3253",
                                        "ion_position": "14",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0140",
                                        "ppm": "2.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "34",
                                "monoisotopic_mass": "5392.7116",
                                "monoisotopic_mz": "899.7925",
                                "intensity": "937.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "35",
                                "monoisotopic_mass": "5780.7183",
                                "monoisotopic_mz": "826.8242",
                                "intensity": "1564.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "36",
                                "monoisotopic_mass": "5827.0642",
                                "monoisotopic_mz": "833.4450",
                                "intensity": "5568.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "37",
                                "monoisotopic_mass": "4827.9236",
                                "monoisotopic_mz": "966.5920",
                                "intensity": "1534.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "38",
                                "monoisotopic_mass": "739.6642",
                                "monoisotopic_mz": "740.6714",
                                "intensity": "1144.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "39",
                                "monoisotopic_mass": "5037.7558",
                                "monoisotopic_mz": "1008.5584",
                                "intensity": "1078.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "40",
                                "monoisotopic_mass": "3594.5299",
                                "monoisotopic_mz": "899.6398",
                                "intensity": "936.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "41",
                                "monoisotopic_mass": "1497.2623",
                                "monoisotopic_mz": "749.6384",
                                "intensity": "755.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "42",
                                "monoisotopic_mass": "7074.5452",
                                "monoisotopic_mz": "885.3254",
                                "intensity": "3333.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "43",
                                "monoisotopic_mass": "4182.0536",
                                "monoisotopic_mz": "837.4180",
                                "intensity": "930.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "44",
                                "monoisotopic_mass": "1023.4879",
                                "monoisotopic_mz": "512.7512",
                                "intensity": "3821.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "45",
                                "monoisotopic_mass": "6455.0898",
                                "monoisotopic_mz": "923.1630",
                                "intensity": "1463.44",
                                "charge": "7"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "46",
                                "monoisotopic_mass": "1121.0831",
                                "monoisotopic_mz": "1122.0903",
                                "intensity": "1110.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "47",
                                "monoisotopic_mass": "2458.4970",
                                "monoisotopic_mz": "820.5063",
                                "intensity": "1986.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "48",
                                "monoisotopic_mass": "7421.7824",
                                "monoisotopic_mz": "825.6498",
                                "intensity": "2842.35",
                                "charge": "9"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "49",
                                "monoisotopic_mass": "8175.4307",
                                "monoisotopic_mz": "909.3885",
                                "intensity": "1231.64",
                                "charge": "9"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "50",
                                "monoisotopic_mass": "5830.4468",
                                "monoisotopic_mz": "972.7484",
                                "intensity": "961.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "51",
                                "monoisotopic_mass": "1912.1718",
                                "monoisotopic_mz": "957.0932",
                                "intensity": "1599.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "52",
                                "monoisotopic_mass": "806.0971",
                                "monoisotopic_mz": "807.1044",
                                "intensity": "1202.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "53",
                                "monoisotopic_mass": "8114.9213",
                                "monoisotopic_mz": "812.4994",
                                "intensity": "879.92",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8116.0025",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0789",
                                        "ppm": "-9.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "54",
                                "monoisotopic_mass": "2470.6345",
                                "monoisotopic_mz": "824.5521",
                                "intensity": "1724.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "55",
                                "monoisotopic_mass": "4753.3040",
                                "monoisotopic_mz": "951.6681",
                                "intensity": "1950.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "56",
                                "monoisotopic_mass": "4297.5334",
                                "monoisotopic_mz": "860.5140",
                                "intensity": "1057.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "57",
                                "monoisotopic_mass": "7142.7822",
                                "monoisotopic_mz": "893.8550",
                                "intensity": "1009.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "58",
                                "monoisotopic_mass": "5740.1184",
                                "monoisotopic_mz": "821.0242",
                                "intensity": "889.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "59",
                                "monoisotopic_mass": "5936.7622",
                                "monoisotopic_mz": "849.1162",
                                "intensity": "1351.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "60",
                                "monoisotopic_mass": "1706.9150",
                                "monoisotopic_mz": "854.4648",
                                "intensity": "2341.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "61",
                                "monoisotopic_mass": "7794.9403",
                                "monoisotopic_mz": "867.1118",
                                "intensity": "1068.52",
                                "charge": "9"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "62",
                                "monoisotopic_mass": "4872.3454",
                                "monoisotopic_mz": "813.0648",
                                "intensity": "1998.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "63",
                                "monoisotopic_mass": "4936.0688",
                                "monoisotopic_mz": "988.2210",
                                "intensity": "1039.17",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "64",
                                "monoisotopic_mass": "4096.4927",
                                "monoisotopic_mz": "820.3058",
                                "intensity": "1694.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "65",
                                "monoisotopic_mass": "4483.7297",
                                "monoisotopic_mz": "897.7532",
                                "intensity": "2900.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "66",
                                "monoisotopic_mass": "1027.9854",
                                "monoisotopic_mz": "1028.9927",
                                "intensity": "754.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "67",
                                "monoisotopic_mass": "6041.0986",
                                "monoisotopic_mz": "1007.8570",
                                "intensity": "7293.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "68",
                                "monoisotopic_mass": "3608.7987",
                                "monoisotopic_mz": "903.2070",
                                "intensity": "1701.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "69",
                                "monoisotopic_mass": "983.7927",
                                "monoisotopic_mz": "984.8000",
                                "intensity": "709.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "70",
                                "monoisotopic_mass": "882.9729",
                                "monoisotopic_mz": "883.9802",
                                "intensity": "670.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "33",
                                "peak_id": "71",
                                "monoisotopic_mass": "4028.6920",
                                "monoisotopic_mz": "1008.1803",
                                "intensity": "2551.27",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "67",
                                            "spec_id": "33",
                                            "peak_id": "7",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "67",
                                            "spec_id": "33",
                                            "peak_id": "19",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "66",
                                        "spec_id": "33",
                                        "peak_id": "14",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "55",
                                        "spec_id": "33",
                                        "peak_id": "33",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "spec_id": "33",
                                        "peak_id": "16",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "33",
                                        "peak_id": "20",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "33",
                                        "peak_id": "1",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "33",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "33",
                                        "peak_id": "9",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "56",
                                        "ion_display_position": "56",
                                        "spec_id": "33",
                                        "peak_id": "17",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "33",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "33",
                                        "peak_id": "44",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "33",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "33",
                                        "peak_id": "53",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "125",
                "p_value": "4.65e-08",
                "e_value": "4.65e-08",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "112",
                        "ms1_scans": "285",
                        "ids": "172",
                        "scans": "286",
                        "precursor_mono_mass": "8319.0729",
                        "precursor_charge": "13",
                        "precursor_mz": "640.9360",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "172",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3618",
                                "monoisotopic_mz": "791.2342",
                                "intensity": "9394.05",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "1",
                                "monoisotopic_mass": "4628.2810",
                                "monoisotopic_mz": "772.3874",
                                "intensity": "5758.38",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0013",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "2",
                                "monoisotopic_mass": "1453.6373",
                                "monoisotopic_mz": "727.8259",
                                "intensity": "5623.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "3",
                                "monoisotopic_mass": "1023.4880",
                                "monoisotopic_mz": "512.7513",
                                "intensity": "4540.73",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "4",
                                "monoisotopic_mass": "4499.2334",
                                "monoisotopic_mz": "750.8795",
                                "intensity": "3759.35",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0037",
                                        "ppm": "-0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "5",
                                "monoisotopic_mass": "4611.2785",
                                "monoisotopic_mz": "769.5537",
                                "intensity": "3294.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "6",
                                "monoisotopic_mass": "3234.5590",
                                "monoisotopic_mz": "647.9191",
                                "intensity": "5380.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "7",
                                "monoisotopic_mass": "1552.7036",
                                "monoisotopic_mz": "777.3591",
                                "intensity": "2697.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "-0.0023",
                                        "ppm": "-1.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "8",
                                "monoisotopic_mass": "1282.8051",
                                "monoisotopic_mz": "642.4099",
                                "intensity": "2185.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "9",
                                "monoisotopic_mass": "4853.4445",
                                "monoisotopic_mz": "694.3565",
                                "intensity": "3304.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "10",
                                "monoisotopic_mass": "1264.7929",
                                "monoisotopic_mz": "633.4037",
                                "intensity": "1482.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "11",
                                "monoisotopic_mass": "523.2536",
                                "monoisotopic_mz": "524.2609",
                                "intensity": "1341.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0007",
                                        "ppm": "-1.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "12",
                                "monoisotopic_mass": "2526.5257",
                                "monoisotopic_mz": "632.6387",
                                "intensity": "925.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "13",
                                "monoisotopic_mass": "1902.1768",
                                "monoisotopic_mz": "635.0662",
                                "intensity": "1791.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "14",
                                "monoisotopic_mass": "1918.1727",
                                "monoisotopic_mz": "640.3982",
                                "intensity": "850.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "15",
                                "monoisotopic_mass": "639.3198",
                                "monoisotopic_mz": "640.3271",
                                "intensity": "857.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "16",
                                "monoisotopic_mass": "1359.8391",
                                "monoisotopic_mz": "680.9268",
                                "intensity": "995.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "17",
                                "monoisotopic_mass": "2728.0106",
                                "monoisotopic_mz": "683.0099",
                                "intensity": "1117.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "18",
                                "monoisotopic_mass": "2304.6342",
                                "monoisotopic_mz": "769.2187",
                                "intensity": "3449.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "19",
                                "monoisotopic_mass": "1487.7400",
                                "monoisotopic_mz": "744.8773",
                                "intensity": "530.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "20",
                                "monoisotopic_mass": "679.7516",
                                "monoisotopic_mz": "680.7589",
                                "intensity": "1200.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "21",
                                "monoisotopic_mass": "1973.3576",
                                "monoisotopic_mz": "658.7931",
                                "intensity": "1348.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "22",
                                "monoisotopic_mass": "8011.7013",
                                "monoisotopic_mz": "729.3438",
                                "intensity": "994.73",
                                "charge": "11"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "23",
                                "monoisotopic_mass": "5760.1376",
                                "monoisotopic_mz": "641.0226",
                                "intensity": "2150.30",
                                "charge": "9"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "24",
                                "monoisotopic_mass": "3203.3050",
                                "monoisotopic_mz": "641.6683",
                                "intensity": "1037.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "25",
                                "monoisotopic_mass": "3700.6966",
                                "monoisotopic_mz": "741.1466",
                                "intensity": "864.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "26",
                                "monoisotopic_mass": "2428.2302",
                                "monoisotopic_mz": "810.4174",
                                "intensity": "928.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "27",
                                "monoisotopic_mass": "6399.7456",
                                "monoisotopic_mz": "640.9818",
                                "intensity": "894.43",
                                "charge": "10"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "28",
                                "monoisotopic_mass": "7507.2987",
                                "monoisotopic_mz": "683.4890",
                                "intensity": "1957.81",
                                "charge": "11"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "29",
                                "monoisotopic_mass": "3405.3587",
                                "monoisotopic_mz": "682.0790",
                                "intensity": "1627.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "30",
                                "monoisotopic_mass": "1396.7532",
                                "monoisotopic_mz": "699.3839",
                                "intensity": "586.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "31",
                                "monoisotopic_mass": "2566.3143",
                                "monoisotopic_mz": "642.5858",
                                "intensity": "1048.69",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "172",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "172",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "172",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "172",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "172",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "172",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "172",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "66",
                "p_value": "1.42e-07",
                "e_value": "1.42e-07",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "84",
                        "ms1_scans": "175",
                        "ids": "90",
                        "scans": "176",
                        "precursor_mono_mass": "8320.0783",
                        "precursor_charge": "13",
                        "precursor_mz": "641.0133",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "90",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3639",
                                "monoisotopic_mz": "678.3450",
                                "intensity": "8341.81",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0001",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "1",
                                "monoisotopic_mass": "1338.6095",
                                "monoisotopic_mz": "670.3120",
                                "intensity": "5828.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "2",
                                "monoisotopic_mass": "1453.6357",
                                "monoisotopic_mz": "727.8251",
                                "intensity": "5116.57",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "3",
                                "monoisotopic_mass": "1023.4878",
                                "monoisotopic_mz": "512.7512",
                                "intensity": "4157.65",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "4",
                                "monoisotopic_mass": "4741.3585",
                                "monoisotopic_mz": "791.2337",
                                "intensity": "7418.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0053",
                                        "ppm": "-1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "5",
                                "monoisotopic_mass": "2305.6357",
                                "monoisotopic_mz": "769.5525",
                                "intensity": "3545.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "6",
                                "monoisotopic_mass": "1281.7960",
                                "monoisotopic_mz": "641.9053",
                                "intensity": "5088.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "7",
                                "monoisotopic_mass": "1902.1735",
                                "monoisotopic_mz": "635.0651",
                                "intensity": "3539.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "8",
                                "monoisotopic_mass": "3233.5559",
                                "monoisotopic_mz": "647.7185",
                                "intensity": "5357.39",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "9",
                                "monoisotopic_mass": "750.3726",
                                "monoisotopic_mz": "751.3798",
                                "intensity": "1833.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "10",
                                "monoisotopic_mass": "1152.5311",
                                "monoisotopic_mz": "577.2728",
                                "intensity": "2473.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.5313",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "11",
                                "monoisotopic_mass": "4853.4420",
                                "monoisotopic_mz": "809.9143",
                                "intensity": "4398.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "12",
                                "monoisotopic_mass": "4670.1748",
                                "monoisotopic_mz": "668.1751",
                                "intensity": "877.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "13",
                                "monoisotopic_mass": "4955.4990",
                                "monoisotopic_mz": "708.9357",
                                "intensity": "1847.41",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0035",
                                        "ppm": "0.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "14",
                                "monoisotopic_mass": "632.3975",
                                "monoisotopic_mz": "633.4047",
                                "intensity": "1077.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "15",
                                "monoisotopic_mass": "4855.4479",
                                "monoisotopic_mz": "694.6427",
                                "intensity": "3685.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "16",
                                "monoisotopic_mass": "5396.6945",
                                "monoisotopic_mz": "675.5941",
                                "intensity": "707.04",
                                "charge": "8"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "17",
                                "monoisotopic_mass": "4084.5114",
                                "monoisotopic_mz": "681.7592",
                                "intensity": "1200.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "18",
                                "monoisotopic_mass": "1265.8000",
                                "monoisotopic_mz": "633.9073",
                                "intensity": "494.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "19",
                                "monoisotopic_mass": "1178.7095",
                                "monoisotopic_mz": "590.3620",
                                "intensity": "655.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "20",
                                "monoisotopic_mass": "8303.0747",
                                "monoisotopic_mz": "639.7053",
                                "intensity": "2303.63",
                                "charge": "13"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "21",
                                "monoisotopic_mass": "1365.2915",
                                "monoisotopic_mz": "683.6530",
                                "intensity": "511.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "22",
                                "monoisotopic_mass": "1401.2489",
                                "monoisotopic_mz": "701.6317",
                                "intensity": "583.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "23",
                                "monoisotopic_mass": "1434.7142",
                                "monoisotopic_mz": "718.3644",
                                "intensity": "474.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "24",
                                "monoisotopic_mass": "1301.6508",
                                "monoisotopic_mz": "651.8327",
                                "intensity": "494.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "25",
                                "monoisotopic_mass": "1920.2330",
                                "monoisotopic_mz": "641.0850",
                                "intensity": "805.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "26",
                                "monoisotopic_mass": "4613.3626",
                                "monoisotopic_mz": "769.9010",
                                "intensity": "977.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "27",
                                "monoisotopic_mass": "1316.2405",
                                "monoisotopic_mz": "659.1275",
                                "intensity": "473.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "28",
                                "monoisotopic_mass": "3000.1079",
                                "monoisotopic_mz": "751.0343",
                                "intensity": "1598.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "29",
                                "monoisotopic_mass": "1236.9979",
                                "monoisotopic_mz": "619.5062",
                                "intensity": "471.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "30",
                                "monoisotopic_mass": "3703.7216",
                                "monoisotopic_mz": "741.7516",
                                "intensity": "1407.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "90",
                                "peak_id": "31",
                                "monoisotopic_mass": "523.2700",
                                "monoisotopic_mz": "524.2773",
                                "intensity": "880.05",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "90",
                                        "peak_id": "8",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "spec_id": "90",
                                        "peak_id": "13",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "90",
                                            "peak_id": "4",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "90",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "90",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "90",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "8",
                                        "spec_id": "90",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "90",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "119",
                "p_value": "9.44e-07",
                "e_value": "9.44e-07",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "109",
                        "ms1_scans": "274",
                        "ids": "166",
                        "scans": "277",
                        "precursor_mono_mass": "8320.0825",
                        "precursor_charge": "10",
                        "precursor_mz": "833.0155",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "166",
                                "peak_id": "0",
                                "monoisotopic_mass": "4160.5442",
                                "monoisotopic_mz": "833.1161",
                                "intensity": "81392.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "1",
                                "monoisotopic_mass": "4741.3618",
                                "monoisotopic_mz": "949.2796",
                                "intensity": "34906.85",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "2",
                                "monoisotopic_mass": "5941.0329",
                                "monoisotopic_mz": "991.1794",
                                "intensity": "22765.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "3",
                                "monoisotopic_mass": "8301.0479",
                                "monoisotopic_mz": "831.1121",
                                "intensity": "35960.97",
                                "charge": "10"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "4",
                                "monoisotopic_mass": "4627.2756",
                                "monoisotopic_mz": "926.4624",
                                "intensity": "30261.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "5",
                                "monoisotopic_mass": "7476.8745",
                                "monoisotopic_mz": "831.7711",
                                "intensity": "20175.42",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "6",
                                "monoisotopic_mass": "4498.2333",
                                "monoisotopic_mz": "900.6539",
                                "intensity": "19922.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "7",
                                "monoisotopic_mass": "8074.0157",
                                "monoisotopic_mz": "898.1201",
                                "intensity": "18697.55",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0090",
                                        "ppm": "1.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "8",
                                "monoisotopic_mass": "8188.0570",
                                "monoisotopic_mz": "910.7914",
                                "intensity": "18233.66",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "0.0075",
                                        "ppm": "0.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "9",
                                "monoisotopic_mass": "6980.4745",
                                "monoisotopic_mz": "873.5666",
                                "intensity": "12981.04",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6981.4818",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "B00060",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0050",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "10",
                                "monoisotopic_mass": "8284.0524",
                                "monoisotopic_mz": "829.4125",
                                "intensity": "17791.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "11",
                                "monoisotopic_mass": "4853.4460",
                                "monoisotopic_mz": "971.6965",
                                "intensity": "13330.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "12",
                                "monoisotopic_mass": "3447.6304",
                                "monoisotopic_mz": "862.9149",
                                "intensity": "14199.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "13",
                                "monoisotopic_mass": "6082.0340",
                                "monoisotopic_mz": "869.8693",
                                "intensity": "6986.94",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6083.0422",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0059",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "14",
                                "monoisotopic_mass": "4955.4947",
                                "monoisotopic_mz": "992.1062",
                                "intensity": "11044.33",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4955.4955",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "15",
                                "monoisotopic_mass": "1338.6098",
                                "monoisotopic_mz": "670.3122",
                                "intensity": "14620.78",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "16",
                                "monoisotopic_mass": "6041.1012",
                                "monoisotopic_mz": "1007.8575",
                                "intensity": "6928.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "17",
                                "monoisotopic_mass": "832.9100",
                                "monoisotopic_mz": "833.9172",
                                "intensity": "6045.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "18",
                                "monoisotopic_mass": "2237.0493",
                                "monoisotopic_mz": "746.6904",
                                "intensity": "4455.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2237.0502",
                                        "ion_position": "52",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "19",
                                "monoisotopic_mass": "3465.6465",
                                "monoisotopic_mz": "867.4189",
                                "intensity": "6804.19",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3465.6446",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0020",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "20",
                                "monoisotopic_mass": "5229.7309",
                                "monoisotopic_mz": "1046.9535",
                                "intensity": "3636.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "21",
                                "monoisotopic_mass": "4740.3616",
                                "monoisotopic_mz": "791.0675",
                                "intensity": "9462.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "22",
                                "monoisotopic_mass": "2477.7472",
                                "monoisotopic_mz": "826.9230",
                                "intensity": "3764.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "23",
                                "monoisotopic_mass": "883.4367",
                                "monoisotopic_mz": "884.4440",
                                "intensity": "3871.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "24",
                                "monoisotopic_mass": "3329.0352",
                                "monoisotopic_mz": "833.2661",
                                "intensity": "38860.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "25",
                                "monoisotopic_mass": "2794.9337",
                                "monoisotopic_mz": "932.6518",
                                "intensity": "5046.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "26",
                                "monoisotopic_mass": "1023.4874",
                                "monoisotopic_mz": "512.7510",
                                "intensity": "3461.42",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "27",
                                "monoisotopic_mass": "4856.4460",
                                "monoisotopic_mz": "810.4149",
                                "intensity": "4615.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "28",
                                "monoisotopic_mass": "4095.0335",
                                "monoisotopic_mz": "820.0140",
                                "intensity": "5099.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "29",
                                "monoisotopic_mass": "3578.7253",
                                "monoisotopic_mz": "895.6886",
                                "intensity": "2985.81",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3578.7286",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "30",
                                "monoisotopic_mass": "970.8887",
                                "monoisotopic_mz": "971.8960",
                                "intensity": "1956.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "31",
                                "monoisotopic_mass": "1780.8170",
                                "monoisotopic_mz": "891.4158",
                                "intensity": "2651.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1780.8169",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "56",
                                        "mass_error": "0.0001",
                                        "ppm": "0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "32",
                                "monoisotopic_mass": "2649.9743",
                                "monoisotopic_mz": "884.3320",
                                "intensity": "2470.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "33",
                                "monoisotopic_mass": "8263.0502",
                                "monoisotopic_mz": "827.3123",
                                "intensity": "1400.44",
                                "charge": "10"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "34",
                                "monoisotopic_mass": "909.2023",
                                "monoisotopic_mz": "910.2095",
                                "intensity": "1386.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "35",
                                "monoisotopic_mass": "5267.2983",
                                "monoisotopic_mz": "878.8903",
                                "intensity": "1162.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "36",
                                "monoisotopic_mass": "4627.2724",
                                "monoisotopic_mz": "772.2193",
                                "intensity": "2962.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "37",
                                "monoisotopic_mass": "4547.0077",
                                "monoisotopic_mz": "910.4088",
                                "intensity": "1146.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "38",
                                "monoisotopic_mass": "750.0398",
                                "monoisotopic_mz": "751.0471",
                                "intensity": "1307.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "39",
                                "monoisotopic_mass": "2730.4800",
                                "monoisotopic_mz": "911.1673",
                                "intensity": "3455.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "40",
                                "monoisotopic_mass": "2979.8294",
                                "monoisotopic_mz": "994.2838",
                                "intensity": "2292.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "41",
                                "monoisotopic_mass": "613.3143",
                                "monoisotopic_mz": "614.3216",
                                "intensity": "2072.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "42",
                                "monoisotopic_mass": "2426.7196",
                                "monoisotopic_mz": "809.9138",
                                "intensity": "932.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "43",
                                "monoisotopic_mass": "5981.4043",
                                "monoisotopic_mz": "855.4936",
                                "intensity": "1310.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "44",
                                "monoisotopic_mass": "848.1709",
                                "monoisotopic_mz": "849.1782",
                                "intensity": "1652.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "45",
                                "monoisotopic_mass": "5001.0418",
                                "monoisotopic_mz": "834.5142",
                                "intensity": "14148.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "46",
                                "monoisotopic_mass": "4939.4863",
                                "monoisotopic_mz": "988.9045",
                                "intensity": "1335.65",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "47",
                                "monoisotopic_mass": "988.0057",
                                "monoisotopic_mz": "989.0129",
                                "intensity": "1450.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "48",
                                "monoisotopic_mass": "523.2537",
                                "monoisotopic_mz": "524.2610",
                                "intensity": "2729.79",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0006",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "49",
                                "monoisotopic_mass": "8104.1385",
                                "monoisotopic_mz": "1014.0246",
                                "intensity": "1443.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "50",
                                "monoisotopic_mass": "8057.9859",
                                "monoisotopic_mz": "896.3390",
                                "intensity": "6444.17",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "51",
                                "monoisotopic_mass": "4973.6474",
                                "monoisotopic_mz": "829.9485",
                                "intensity": "3928.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "52",
                                "monoisotopic_mass": "7070.5287",
                                "monoisotopic_mz": "884.8234",
                                "intensity": "1868.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "53",
                                "monoisotopic_mass": "8088.0713",
                                "monoisotopic_mz": "809.8144",
                                "intensity": "833.16",
                                "charge": "10"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "54",
                                "monoisotopic_mass": "5656.4636",
                                "monoisotopic_mz": "809.0735",
                                "intensity": "1405.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "55",
                                "monoisotopic_mass": "3464.6389",
                                "monoisotopic_mz": "693.9351",
                                "intensity": "3060.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "56",
                                "monoisotopic_mass": "3729.5927",
                                "monoisotopic_mz": "933.4055",
                                "intensity": "2766.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "57",
                                "monoisotopic_mass": "7369.8538",
                                "monoisotopic_mz": "819.8799",
                                "intensity": "1362.07",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "58",
                                "monoisotopic_mass": "1755.5327",
                                "monoisotopic_mz": "878.7736",
                                "intensity": "2841.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "59",
                                "monoisotopic_mass": "4985.2460",
                                "monoisotopic_mz": "831.8816",
                                "intensity": "5334.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "60",
                                "monoisotopic_mass": "2919.1578",
                                "monoisotopic_mz": "974.0599",
                                "intensity": "2875.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "61",
                                "monoisotopic_mass": "7736.9805",
                                "monoisotopic_mz": "968.1298",
                                "intensity": "1459.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "62",
                                "monoisotopic_mass": "944.4736",
                                "monoisotopic_mz": "945.4808",
                                "intensity": "1971.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "63",
                                "monoisotopic_mass": "1903.9833",
                                "monoisotopic_mz": "952.9989",
                                "intensity": "1795.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "64",
                                "monoisotopic_mass": "1000.7511",
                                "monoisotopic_mz": "1001.7584",
                                "intensity": "1196.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "65",
                                "monoisotopic_mass": "3805.8571",
                                "monoisotopic_mz": "952.4716",
                                "intensity": "809.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "66",
                                "monoisotopic_mass": "5924.0023",
                                "monoisotopic_mz": "988.3410",
                                "intensity": "2549.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "67",
                                "monoisotopic_mass": "5138.5971",
                                "monoisotopic_mz": "857.4401",
                                "intensity": "1045.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "68",
                                "monoisotopic_mass": "6995.4388",
                                "monoisotopic_mz": "875.4371",
                                "intensity": "1174.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "69",
                                "monoisotopic_mass": "7828.7436",
                                "monoisotopic_mz": "870.8677",
                                "intensity": "1307.74",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "70",
                                "monoisotopic_mass": "2766.3326",
                                "monoisotopic_mz": "923.1182",
                                "intensity": "3165.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "71",
                                "monoisotopic_mass": "7522.1432",
                                "monoisotopic_mz": "941.2752",
                                "intensity": "1416.78",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "72",
                                "monoisotopic_mass": "7572.7823",
                                "monoisotopic_mz": "947.6051",
                                "intensity": "1029.01",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "73",
                                "monoisotopic_mass": "6491.2749",
                                "monoisotopic_mz": "928.3323",
                                "intensity": "999.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "74",
                                "monoisotopic_mass": "4610.2700",
                                "monoisotopic_mz": "923.0613",
                                "intensity": "2976.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "75",
                                "monoisotopic_mass": "5050.5958",
                                "monoisotopic_mz": "1011.1264",
                                "intensity": "997.51",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "76",
                                "monoisotopic_mass": "4275.2522",
                                "monoisotopic_mz": "856.0577",
                                "intensity": "2670.17",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "77",
                                "monoisotopic_mass": "5814.4873",
                                "monoisotopic_mz": "970.0885",
                                "intensity": "1378.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "78",
                                "monoisotopic_mass": "6655.2886",
                                "monoisotopic_mz": "951.7628",
                                "intensity": "902.41",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "79",
                                "monoisotopic_mass": "1933.9940",
                                "monoisotopic_mz": "968.0043",
                                "intensity": "3133.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "80",
                                "monoisotopic_mass": "4643.4245",
                                "monoisotopic_mz": "929.6922",
                                "intensity": "2374.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "81",
                                "monoisotopic_mass": "1019.4791",
                                "monoisotopic_mz": "1020.4864",
                                "intensity": "1134.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "82",
                                "monoisotopic_mass": "4825.3966",
                                "monoisotopic_mz": "966.0866",
                                "intensity": "1378.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "83",
                                "monoisotopic_mass": "5788.5254",
                                "monoisotopic_mz": "827.9395",
                                "intensity": "877.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "84",
                                "monoisotopic_mass": "2617.6411",
                                "monoisotopic_mz": "873.5543",
                                "intensity": "3375.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "85",
                                "monoisotopic_mass": "8031.0220",
                                "monoisotopic_mz": "893.3431",
                                "intensity": "1350.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "86",
                                "monoisotopic_mass": "6521.5953",
                                "monoisotopic_mz": "932.6637",
                                "intensity": "1832.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "87",
                                "monoisotopic_mass": "1042.3760",
                                "monoisotopic_mz": "1043.3833",
                                "intensity": "1354.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "88",
                                "monoisotopic_mass": "1740.5851",
                                "monoisotopic_mz": "871.2998",
                                "intensity": "1483.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "89",
                                "monoisotopic_mass": "6624.3770",
                                "monoisotopic_mz": "947.3468",
                                "intensity": "1343.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "90",
                                "monoisotopic_mass": "4518.8735",
                                "monoisotopic_mz": "904.7820",
                                "intensity": "3075.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "91",
                                "monoisotopic_mass": "6009.2401",
                                "monoisotopic_mz": "1002.5473",
                                "intensity": "2017.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "92",
                                "monoisotopic_mass": "4352.3085",
                                "monoisotopic_mz": "871.4690",
                                "intensity": "2105.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "93",
                                "monoisotopic_mass": "1453.6364",
                                "monoisotopic_mz": "727.8255",
                                "intensity": "775.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "94",
                                "monoisotopic_mass": "6767.2500",
                                "monoisotopic_mz": "846.9135",
                                "intensity": "1044.10",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "95",
                                "monoisotopic_mass": "3288.5909",
                                "monoisotopic_mz": "823.1550",
                                "intensity": "1792.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "96",
                                "monoisotopic_mass": "6614.5687",
                                "monoisotopic_mz": "827.8284",
                                "intensity": "1488.66",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "97",
                                "monoisotopic_mass": "6635.0770",
                                "monoisotopic_mz": "830.3919",
                                "intensity": "3808.77",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "98",
                                "monoisotopic_mass": "6180.2450",
                                "monoisotopic_mz": "883.8994",
                                "intensity": "2404.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "99",
                                "monoisotopic_mass": "6930.1751",
                                "monoisotopic_mz": "867.2792",
                                "intensity": "3085.89",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "100",
                                "monoisotopic_mass": "5279.7209",
                                "monoisotopic_mz": "880.9608",
                                "intensity": "2596.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "101",
                                "monoisotopic_mass": "6457.5181",
                                "monoisotopic_mz": "923.5099",
                                "intensity": "2835.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "102",
                                "monoisotopic_mass": "5831.7805",
                                "monoisotopic_mz": "972.9707",
                                "intensity": "1769.89",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5830.8650",
                                        "ion_position": "21",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0869",
                                        "ppm": "-14.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "103",
                                "monoisotopic_mass": "3391.3555",
                                "monoisotopic_mz": "848.8461",
                                "intensity": "1650.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "104",
                                "monoisotopic_mass": "7780.4390",
                                "monoisotopic_mz": "973.5622",
                                "intensity": "1330.36",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "105",
                                "monoisotopic_mass": "6434.3659",
                                "monoisotopic_mz": "920.2024",
                                "intensity": "2088.48",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "106",
                                "monoisotopic_mass": "6388.0990",
                                "monoisotopic_mz": "799.5197",
                                "intensity": "2068.30",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "107",
                                "monoisotopic_mass": "1412.5440",
                                "monoisotopic_mz": "707.2793",
                                "intensity": "716.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "108",
                                "monoisotopic_mass": "4477.0043",
                                "monoisotopic_mz": "896.4081",
                                "intensity": "1119.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "109",
                                "monoisotopic_mass": "1133.8987",
                                "monoisotopic_mz": "1134.9060",
                                "intensity": "769.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "110",
                                "monoisotopic_mass": "7636.3632",
                                "monoisotopic_mz": "849.4921",
                                "intensity": "2620.68",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "111",
                                "monoisotopic_mass": "2095.2931",
                                "monoisotopic_mz": "1048.6538",
                                "intensity": "1299.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "112",
                                "monoisotopic_mass": "1119.2518",
                                "monoisotopic_mz": "1120.2590",
                                "intensity": "897.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "113",
                                "monoisotopic_mass": "3052.9980",
                                "monoisotopic_mz": "1018.6733",
                                "intensity": "2078.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "114",
                                "monoisotopic_mass": "5948.1761",
                                "monoisotopic_mz": "850.7467",
                                "intensity": "1087.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "115",
                                "monoisotopic_mass": "1071.5185",
                                "monoisotopic_mz": "1072.5258",
                                "intensity": "913.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "116",
                                "monoisotopic_mass": "3629.2187",
                                "monoisotopic_mz": "908.3120",
                                "intensity": "2043.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "117",
                                "monoisotopic_mass": "4096.7499",
                                "monoisotopic_mz": "1025.1947",
                                "intensity": "2614.43",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "166",
                                        "peak_id": "8",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "spec_id": "166",
                                        "peak_id": "7",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "48",
                                        "spec_id": "166",
                                        "peak_id": "102",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "spec_id": "166",
                                        "peak_id": "14",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "166",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "166",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "38",
                                            "spec_id": "166",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "17",
                                            "spec_id": "166",
                                            "peak_id": "18",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "52",
                                            "ion_display_position": "52",
                                            "spec_id": "166",
                                            "peak_id": "13",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "56",
                                        "ion_display_position": "13",
                                        "spec_id": "166",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "166",
                                        "peak_id": "93",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "60",
                                            "ion_display_position": "9",
                                            "spec_id": "166",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "166",
                                            "peak_id": "9",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "166",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "166",
                                        "peak_id": "48",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "12",
                "p_value": "1.70e-06",
                "e_value": "1.70e-06",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "58",
                        "ms1_scans": "73",
                        "ids": "15",
                        "scans": "75",
                        "precursor_mono_mass": "8320.0636",
                        "precursor_charge": "12",
                        "precursor_mz": "694.3459",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "15",
                                "peak_id": "0",
                                "monoisotopic_mass": "4741.3636",
                                "monoisotopic_mz": "791.2345",
                                "intensity": "22828.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "1",
                                "monoisotopic_mass": "4628.2792",
                                "monoisotopic_mz": "772.3871",
                                "intensity": "11147.99",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4628.2797",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "2",
                                "monoisotopic_mass": "1338.6104",
                                "monoisotopic_mz": "670.3125",
                                "intensity": "8196.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "3",
                                "monoisotopic_mass": "4610.2689",
                                "monoisotopic_mz": "769.3854",
                                "intensity": "13052.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "4",
                                "monoisotopic_mass": "8303.0633",
                                "monoisotopic_mz": "692.9292",
                                "intensity": "10314.21",
                                "charge": "12"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "5",
                                "monoisotopic_mass": "4160.5478",
                                "monoisotopic_mz": "694.4319",
                                "intensity": "9998.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "6",
                                "monoisotopic_mass": "8188.0504",
                                "monoisotopic_mz": "745.3755",
                                "intensity": "7387.10",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8189.0519",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "1",
                                        "mass_error": "0.0009",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "7",
                                "monoisotopic_mass": "1023.4886",
                                "monoisotopic_mz": "512.7516",
                                "intensity": "5094.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "8",
                                "monoisotopic_mass": "4853.4450",
                                "monoisotopic_mz": "694.3566",
                                "intensity": "3885.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "9",
                                "monoisotopic_mass": "2080.0218",
                                "monoisotopic_mz": "694.3479",
                                "intensity": "4421.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "10",
                                "monoisotopic_mass": "1453.6380",
                                "monoisotopic_mz": "727.8263",
                                "intensity": "7077.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1453.6375",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0005",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "11",
                                "monoisotopic_mass": "4954.4949",
                                "monoisotopic_mz": "826.7564",
                                "intensity": "6110.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "12",
                                "monoisotopic_mass": "3446.6292",
                                "monoisotopic_mz": "690.3331",
                                "intensity": "4043.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "13",
                                "monoisotopic_mass": "1552.7052",
                                "monoisotopic_mz": "777.3599",
                                "intensity": "1679.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1552.7059",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "58",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "14",
                                "monoisotopic_mass": "3702.7858",
                                "monoisotopic_mz": "741.5644",
                                "intensity": "5922.89",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0043",
                                        "ppm": "1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "15",
                                "monoisotopic_mass": "7630.8097",
                                "monoisotopic_mz": "694.7172",
                                "intensity": "864.45",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7631.8073",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0047",
                                        "ppm": "0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "16",
                                "monoisotopic_mass": "2758.0408",
                                "monoisotopic_mz": "690.5175",
                                "intensity": "2812.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "17",
                                "monoisotopic_mass": "763.3800",
                                "monoisotopic_mz": "764.3873",
                                "intensity": "1797.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "18",
                                "monoisotopic_mass": "1353.8782",
                                "monoisotopic_mz": "677.9464",
                                "intensity": "1707.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "19",
                                "monoisotopic_mass": "3467.1964",
                                "monoisotopic_mz": "694.4466",
                                "intensity": "3569.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "20",
                                "monoisotopic_mass": "2427.7282",
                                "monoisotopic_mz": "810.2500",
                                "intensity": "2525.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "21",
                                "monoisotopic_mass": "741.9126",
                                "monoisotopic_mz": "742.9199",
                                "intensity": "1262.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "22",
                                "monoisotopic_mass": "1781.8168",
                                "monoisotopic_mz": "891.9157",
                                "intensity": "1622.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "23",
                                "monoisotopic_mass": "6741.3918",
                                "monoisotopic_mz": "750.0508",
                                "intensity": "1022.35",
                                "charge": "9"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "24",
                                "monoisotopic_mass": "523.2547",
                                "monoisotopic_mz": "524.2620",
                                "intensity": "2099.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "0.0004",
                                        "ppm": "0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "25",
                                "monoisotopic_mass": "5126.7435",
                                "monoisotopic_mz": "733.3992",
                                "intensity": "782.31",
                                "charge": "7"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "26",
                                "monoisotopic_mass": "602.2435",
                                "monoisotopic_mz": "603.2507",
                                "intensity": "2398.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "27",
                                "monoisotopic_mass": "3702.7788",
                                "monoisotopic_mz": "926.7020",
                                "intensity": "1782.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3702.7816",
                                        "ion_position": "40",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "28",
                                "monoisotopic_mass": "8241.5718",
                                "monoisotopic_mz": "687.8049",
                                "intensity": "999.53",
                                "charge": "12"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "29",
                                "monoisotopic_mass": "2018.1210",
                                "monoisotopic_mz": "673.7143",
                                "intensity": "807.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "30",
                                "monoisotopic_mass": "4123.4411",
                                "monoisotopic_mz": "825.6955",
                                "intensity": "743.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "31",
                                "monoisotopic_mass": "1480.9748",
                                "monoisotopic_mz": "741.4947",
                                "intensity": "704.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "32",
                                "monoisotopic_mass": "7568.6783",
                                "monoisotopic_mz": "757.8751",
                                "intensity": "1011.58",
                                "charge": "10"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "33",
                                "monoisotopic_mass": "4131.9745",
                                "monoisotopic_mz": "689.6697",
                                "intensity": "749.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "34",
                                "monoisotopic_mass": "652.3481",
                                "monoisotopic_mz": "653.3553",
                                "intensity": "990.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "35",
                                "monoisotopic_mass": "800.2920",
                                "monoisotopic_mz": "801.2993",
                                "intensity": "1184.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "36",
                                "monoisotopic_mass": "787.2259",
                                "monoisotopic_mz": "788.2332",
                                "intensity": "1080.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "37",
                                "monoisotopic_mass": "6434.1261",
                                "monoisotopic_mz": "805.2730",
                                "intensity": "966.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "38",
                                "monoisotopic_mass": "5928.9551",
                                "monoisotopic_mz": "742.1267",
                                "intensity": "1006.99",
                                "charge": "8"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "39",
                                "monoisotopic_mass": "5183.4074",
                                "monoisotopic_mz": "741.4941",
                                "intensity": "938.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "40",
                                "monoisotopic_mass": "7843.2351",
                                "monoisotopic_mz": "785.3308",
                                "intensity": "990.85",
                                "charge": "10"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "41",
                                "monoisotopic_mass": "3287.5945",
                                "monoisotopic_mz": "658.5262",
                                "intensity": "2964.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "42",
                                "monoisotopic_mass": "4610.2707",
                                "monoisotopic_mz": "659.6174",
                                "intensity": "1879.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "43",
                                "monoisotopic_mass": "1494.7612",
                                "monoisotopic_mz": "748.3879",
                                "intensity": "661.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "44",
                                "monoisotopic_mass": "2927.1156",
                                "monoisotopic_mz": "732.7862",
                                "intensity": "1016.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "45",
                                "monoisotopic_mass": "1416.1427",
                                "monoisotopic_mz": "709.0786",
                                "intensity": "2361.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "46",
                                "monoisotopic_mass": "3844.0472",
                                "monoisotopic_mz": "769.8167",
                                "intensity": "806.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "47",
                                "monoisotopic_mass": "2897.1516",
                                "monoisotopic_mz": "725.2952",
                                "intensity": "1922.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "48",
                                "monoisotopic_mass": "2983.4010",
                                "monoisotopic_mz": "746.8575",
                                "intensity": "1077.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "49",
                                "monoisotopic_mass": "2033.2516",
                                "monoisotopic_mz": "678.7578",
                                "intensity": "1396.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "50",
                                "monoisotopic_mass": "4853.4434",
                                "monoisotopic_mz": "809.9145",
                                "intensity": "5542.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "51",
                                "monoisotopic_mass": "2692.5015",
                                "monoisotopic_mz": "674.1326",
                                "intensity": "1014.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "52",
                                "monoisotopic_mass": "6851.6957",
                                "monoisotopic_mz": "686.1768",
                                "intensity": "1716.73",
                                "charge": "10"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "53",
                                "monoisotopic_mass": "5912.0576",
                                "monoisotopic_mz": "740.0145",
                                "intensity": "2522.42",
                                "charge": "8"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "54",
                                "monoisotopic_mass": "2844.3867",
                                "monoisotopic_mz": "949.1362",
                                "intensity": "2926.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "55",
                                "monoisotopic_mass": "7320.1368",
                                "monoisotopic_mz": "733.0210",
                                "intensity": "1079.58",
                                "charge": "10"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "56",
                                "monoisotopic_mass": "4713.4258",
                                "monoisotopic_mz": "674.3538",
                                "intensity": "1024.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "57",
                                "monoisotopic_mass": "5445.1209",
                                "monoisotopic_mz": "681.6474",
                                "intensity": "856.95",
                                "charge": "8"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "58",
                                "monoisotopic_mass": "823.4137",
                                "monoisotopic_mz": "824.4210",
                                "intensity": "965.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "59",
                                "monoisotopic_mass": "723.8132",
                                "monoisotopic_mz": "724.8204",
                                "intensity": "802.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "15",
                                "peak_id": "60",
                                "monoisotopic_mass": "926.2099",
                                "monoisotopic_mz": "927.2172",
                                "intensity": "474.81",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "proteoform_mass": "8320.0923",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "0",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "D"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "K"
                            },
                            {
                                "position": "11",
                                "acid": "Q"
                            },
                            {
                                "position": "12",
                                "acid": "F"
                            },
                            {
                                "position": "13",
                                "acid": "K"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "E"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "W"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "L"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "D"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "I"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "D"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "Q"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "Q"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "E"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "V"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "W"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "T"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "Y"
                            },
                            {
                                "position": "67",
                                "acid": "R"
                            },
                            {
                                "position": "68",
                                "acid": "W"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "68",
                                        "spec_id": "15",
                                        "peak_id": "6",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "63",
                                        "spec_id": "15",
                                        "peak_id": "15",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "spec_id": "15",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "37",
                                        "spec_id": "15",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "15",
                                            "peak_id": "27",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "29",
                                            "spec_id": "15",
                                            "peak_id": "14",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "11",
                                        "spec_id": "15",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "10",
                                        "spec_id": "15",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "spec_id": "15",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "spec_id": "15",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "spec_id": "15",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "57",
                "p_value": "2.80e-05",
                "e_value": "2.80e-05",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "80",
                        "ms1_scans": "156",
                        "ids": "76",
                        "scans": "158",
                        "precursor_mono_mass": "8320.0703",
                        "precursor_charge": "10",
                        "precursor_mz": "833.0143",
                        "feature_inte": "1.2232e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "76",
                                "peak_id": "0",
                                "monoisotopic_mass": "4160.0454",
                                "monoisotopic_mz": "833.0164",
                                "intensity": "81735.65",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "1",
                                "monoisotopic_mass": "8302.0782",
                                "monoisotopic_mz": "831.2151",
                                "intensity": "33968.95",
                                "charge": "10"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "2",
                                "monoisotopic_mass": "4627.2773",
                                "monoisotopic_mz": "926.4627",
                                "intensity": "18961.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "3",
                                "monoisotopic_mass": "7477.8747",
                                "monoisotopic_mz": "831.8822",
                                "intensity": "27718.36",
                                "charge": "9"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "4",
                                "monoisotopic_mass": "5942.0349",
                                "monoisotopic_mz": "991.3464",
                                "intensity": "21752.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "5",
                                "monoisotopic_mass": "4741.3659",
                                "monoisotopic_mz": "949.2805",
                                "intensity": "27394.17",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4741.3637",
                                        "ion_position": "31",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0021",
                                        "ppm": "0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "6",
                                "monoisotopic_mass": "4499.2396",
                                "monoisotopic_mz": "900.8552",
                                "intensity": "14135.55",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4499.2371",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0025",
                                        "ppm": "0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "7",
                                "monoisotopic_mass": "4853.4520",
                                "monoisotopic_mz": "971.6977",
                                "intensity": "14835.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "8",
                                "monoisotopic_mass": "8074.0074",
                                "monoisotopic_mz": "898.1192",
                                "intensity": "13120.88",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8075.0090",
                                        "ion_position": "2",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0008",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "9",
                                "monoisotopic_mass": "832.1099",
                                "monoisotopic_mz": "833.1172",
                                "intensity": "11084.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "10",
                                "monoisotopic_mass": "6981.4863",
                                "monoisotopic_mz": "873.6931",
                                "intensity": "10561.71",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6981.4818",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "B00060",
                                        "ion_left_position": "60",
                                        "mass_error": "0.0045",
                                        "ppm": "0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "11",
                                "monoisotopic_mass": "7945.9117",
                                "monoisotopic_mz": "883.8864",
                                "intensity": "10848.78",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7946.9140",
                                        "ion_position": "3",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "3",
                                        "mass_error": "0.0000",
                                        "ppm": "0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "12",
                                "monoisotopic_mass": "1338.6098",
                                "monoisotopic_mz": "670.3122",
                                "intensity": "9724.08",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1338.6106",
                                        "ion_position": "60",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "13",
                                "monoisotopic_mass": "8284.0699",
                                "monoisotopic_mz": "829.4143",
                                "intensity": "12120.00",
                                "charge": "10"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "14",
                                "monoisotopic_mass": "3329.0376",
                                "monoisotopic_mz": "833.2667",
                                "intensity": "85892.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "15",
                                "monoisotopic_mass": "4139.0362",
                                "monoisotopic_mz": "828.8145",
                                "intensity": "6145.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "16",
                                "monoisotopic_mass": "5589.8660",
                                "monoisotopic_mz": "932.6516",
                                "intensity": "7206.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "17",
                                "monoisotopic_mass": "4740.3642",
                                "monoisotopic_mz": "791.0680",
                                "intensity": "6068.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "18",
                                "monoisotopic_mass": "1023.4881",
                                "monoisotopic_mz": "512.7513",
                                "intensity": "3608.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1023.4887",
                                        "ion_position": "62",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "19",
                                "monoisotopic_mass": "5128.6855",
                                "monoisotopic_mz": "1026.7444",
                                "intensity": "3074.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "20",
                                "monoisotopic_mass": "1618.8159",
                                "monoisotopic_mz": "810.4152",
                                "intensity": "3495.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "21",
                                "monoisotopic_mass": "1738.8724",
                                "monoisotopic_mz": "870.4435",
                                "intensity": "2406.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "22",
                                "monoisotopic_mass": "4066.5053",
                                "monoisotopic_mz": "814.3083",
                                "intensity": "3553.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "23",
                                "monoisotopic_mass": "5446.6955",
                                "monoisotopic_mz": "908.7899",
                                "intensity": "2213.04",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "24",
                                "monoisotopic_mass": "3446.6337",
                                "monoisotopic_mz": "862.6657",
                                "intensity": "4196.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "25",
                                "monoisotopic_mass": "2642.6255",
                                "monoisotopic_mz": "881.8824",
                                "intensity": "3801.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "26",
                                "monoisotopic_mass": "2707.7455",
                                "monoisotopic_mz": "903.5891",
                                "intensity": "2610.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "27",
                                "monoisotopic_mass": "2736.3512",
                                "monoisotopic_mz": "913.1243",
                                "intensity": "2654.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "28",
                                "monoisotopic_mass": "3233.5674",
                                "monoisotopic_mz": "809.3991",
                                "intensity": "5854.68",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3233.5564",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0110",
                                        "ppm": "3.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "29",
                                "monoisotopic_mass": "4475.1038",
                                "monoisotopic_mz": "746.8579",
                                "intensity": "2353.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "30",
                                "monoisotopic_mass": "3269.6386",
                                "monoisotopic_mz": "818.4169",
                                "intensity": "3777.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "31",
                                "monoisotopic_mass": "862.1600",
                                "monoisotopic_mz": "863.1672",
                                "intensity": "3249.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "32",
                                "monoisotopic_mass": "7069.5330",
                                "monoisotopic_mz": "884.6989",
                                "intensity": "1115.25",
                                "charge": "8"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "33",
                                "monoisotopic_mass": "7627.7975",
                                "monoisotopic_mz": "954.4820",
                                "intensity": "1304.60",
                                "charge": "8"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "34",
                                "monoisotopic_mass": "1987.7296",
                                "monoisotopic_mz": "994.8721",
                                "intensity": "2014.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "35",
                                "monoisotopic_mass": "4037.0157",
                                "monoisotopic_mz": "808.4104",
                                "intensity": "1388.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "36",
                                "monoisotopic_mass": "1801.6199",
                                "monoisotopic_mz": "901.8172",
                                "intensity": "1893.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "37",
                                "monoisotopic_mass": "1000.0091",
                                "monoisotopic_mz": "1001.0164",
                                "intensity": "1141.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "38",
                                "monoisotopic_mass": "1825.9505",
                                "monoisotopic_mz": "913.9825",
                                "intensity": "1980.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "39",
                                "monoisotopic_mass": "4293.3746",
                                "monoisotopic_mz": "859.6822",
                                "intensity": "1015.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "40",
                                "monoisotopic_mass": "885.6125",
                                "monoisotopic_mz": "886.6197",
                                "intensity": "1061.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "41",
                                "monoisotopic_mass": "6725.6201",
                                "monoisotopic_mz": "961.8102",
                                "intensity": "2215.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "42",
                                "monoisotopic_mass": "523.2540",
                                "monoisotopic_mz": "524.2612",
                                "intensity": "1902.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "523.2544",
                                        "ion_position": "66",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "43",
                                "monoisotopic_mass": "2654.7800",
                                "monoisotopic_mz": "885.9339",
                                "intensity": "2456.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "44",
                                "monoisotopic_mass": "693.3278",
                                "monoisotopic_mz": "694.3351",
                                "intensity": "1193.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "45",
                                "monoisotopic_mass": "6699.4598",
                                "monoisotopic_mz": "838.4397",
                                "intensity": "1041.99",
                                "charge": "8"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "46",
                                "monoisotopic_mass": "6587.2134",
                                "monoisotopic_mz": "942.0378",
                                "intensity": "1255.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "47",
                                "monoisotopic_mass": "5360.8993",
                                "monoisotopic_mz": "894.4905",
                                "intensity": "1267.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "48",
                                "monoisotopic_mass": "4375.1936",
                                "monoisotopic_mz": "876.0460",
                                "intensity": "1746.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "49",
                                "monoisotopic_mass": "6607.0918",
                                "monoisotopic_mz": "826.8938",
                                "intensity": "2025.10",
                                "charge": "8"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "50",
                                "monoisotopic_mass": "6103.9876",
                                "monoisotopic_mz": "1018.3385",
                                "intensity": "1281.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "51",
                                "monoisotopic_mass": "955.4741",
                                "monoisotopic_mz": "956.4814",
                                "intensity": "1124.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "52",
                                "monoisotopic_mass": "6679.4165",
                                "monoisotopic_mz": "955.2096",
                                "intensity": "967.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "53",
                                "monoisotopic_mass": "2470.2458",
                                "monoisotopic_mz": "824.4225",
                                "intensity": "1656.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "54",
                                "monoisotopic_mass": "1766.8722",
                                "monoisotopic_mz": "884.4434",
                                "intensity": "4022.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "55",
                                "monoisotopic_mass": "6814.5511",
                                "monoisotopic_mz": "852.8262",
                                "intensity": "1322.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "56",
                                "monoisotopic_mass": "1779.8156",
                                "monoisotopic_mz": "890.9151",
                                "intensity": "1900.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "57",
                                "monoisotopic_mass": "2572.9414",
                                "monoisotopic_mz": "858.6544",
                                "intensity": "1121.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "58",
                                "monoisotopic_mass": "3308.8185",
                                "monoisotopic_mz": "828.2119",
                                "intensity": "2267.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "59",
                                "monoisotopic_mass": "988.0035",
                                "monoisotopic_mz": "989.0108",
                                "intensity": "1043.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "60",
                                "monoisotopic_mass": "3656.9206",
                                "monoisotopic_mz": "915.2374",
                                "intensity": "929.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "61",
                                "monoisotopic_mass": "6538.2702",
                                "monoisotopic_mz": "935.0459",
                                "intensity": "2034.91",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6539.2754",
                                        "ion_position": "56",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "B00056",
                                        "ion_left_position": "56",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "62",
                                "monoisotopic_mass": "4098.1048",
                                "monoisotopic_mz": "820.6282",
                                "intensity": "1064.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "63",
                                "monoisotopic_mass": "806.3009",
                                "monoisotopic_mz": "807.3082",
                                "intensity": "1511.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "64",
                                "monoisotopic_mass": "1077.0993",
                                "monoisotopic_mz": "1078.1066",
                                "intensity": "877.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "65",
                                "monoisotopic_mass": "8223.3863",
                                "monoisotopic_mz": "914.7169",
                                "intensity": "908.11",
                                "charge": "9"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "66",
                                "monoisotopic_mass": "6233.2488",
                                "monoisotopic_mz": "891.4714",
                                "intensity": "2874.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "67",
                                "monoisotopic_mass": "3292.2036",
                                "monoisotopic_mz": "824.0582",
                                "intensity": "1686.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "68",
                                "monoisotopic_mass": "4658.4096",
                                "monoisotopic_mz": "932.6892",
                                "intensity": "1127.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "69",
                                "monoisotopic_mass": "4610.2578",
                                "monoisotopic_mz": "923.0588",
                                "intensity": "2907.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "70",
                                "monoisotopic_mass": "1897.5271",
                                "monoisotopic_mz": "949.7709",
                                "intensity": "2367.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "71",
                                "monoisotopic_mass": "7500.3706",
                                "monoisotopic_mz": "834.3818",
                                "intensity": "3582.10",
                                "charge": "9"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "72",
                                "monoisotopic_mass": "5716.0711",
                                "monoisotopic_mz": "953.6858",
                                "intensity": "2065.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "73",
                                "monoisotopic_mass": "6961.9350",
                                "monoisotopic_mz": "995.5694",
                                "intensity": "2224.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "76",
                    