prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "7",
        "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
        "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
        "proteoform_id": "17",
        "prsm_number": "4",
        "prsm": [
            {
                "prsm_id": "36",
                "p_value": "4.40e-04",
                "e_value": "4.40e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "70",
                        "ms1_scans": "116",
                        "ids": "45",
                        "scans": "117",
                        "precursor_mono_mass": "9236.9541",
                        "precursor_charge": "13",
                        "precursor_mz": "711.5422",
                        "feature_inte": "1.3509e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "45",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "29497.20",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6456",
                                "monoisotopic_mz": "800.7815",
                                "intensity": "11135.80",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "17.1194734787",
                                        "theoretical_mass": "4798.6468",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5251",
                                "monoisotopic_mz": "762.2615",
                                "intensity": "9868.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "3",
                                "monoisotopic_mass": "4681.5511",
                                "monoisotopic_mz": "781.2658",
                                "intensity": "7368.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "4",
                                "monoisotopic_mass": "4495.4885",
                                "monoisotopic_mz": "750.2554",
                                "intensity": "10856.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "5",
                                "monoisotopic_mass": "4699.5830",
                                "monoisotopic_mz": "672.3763",
                                "intensity": "15296.42",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0043",
                                        "ppm": "0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "6",
                                "monoisotopic_mass": "8504.1416",
                                "monoisotopic_mz": "709.6857",
                                "intensity": "5612.22",
                                "charge": "12"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "7",
                                "monoisotopic_mass": "2793.5161",
                                "monoisotopic_mz": "932.1793",
                                "intensity": "8161.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "8",
                                "monoisotopic_mass": "1472.8104",
                                "monoisotopic_mz": "737.4125",
                                "intensity": "7823.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "9",
                                "monoisotopic_mass": "4910.7342",
                                "monoisotopic_mz": "819.4630",
                                "intensity": "8265.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "10",
                                "monoisotopic_mass": "2680.4353",
                                "monoisotopic_mz": "894.4857",
                                "intensity": "3091.65",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0023",
                                        "ppm": "0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "11",
                                "monoisotopic_mass": "4798.6379",
                                "monoisotopic_mz": "686.5270",
                                "intensity": "3273.99",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "17.1194734787",
                                        "theoretical_mass": "4798.6468",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0089",
                                        "ppm": "-1.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "12",
                                "monoisotopic_mass": "1454.8099",
                                "monoisotopic_mz": "728.4122",
                                "intensity": "2654.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "13",
                                "monoisotopic_mass": "4682.5517",
                                "monoisotopic_mz": "669.9432",
                                "intensity": "5640.94",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "14",
                                "monoisotopic_mass": "4665.5912",
                                "monoisotopic_mz": "778.6058",
                                "intensity": "3939.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "15",
                                "monoisotopic_mass": "7194.9666",
                                "monoisotopic_mz": "800.4480",
                                "intensity": "3958.60",
                                "charge": "9"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "16",
                                "monoisotopic_mass": "2321.7839",
                                "monoisotopic_mz": "774.9352",
                                "intensity": "4711.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "17",
                                "monoisotopic_mass": "6061.2377",
                                "monoisotopic_mz": "758.6620",
                                "intensity": "1003.75",
                                "charge": "8"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "18",
                                "monoisotopic_mass": "974.4203",
                                "monoisotopic_mz": "975.4276",
                                "intensity": "2710.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "19",
                                "monoisotopic_mass": "2068.0761",
                                "monoisotopic_mz": "1035.0453",
                                "intensity": "2646.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "20",
                                "monoisotopic_mass": "4962.8323",
                                "monoisotopic_mz": "709.9833",
                                "intensity": "1734.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "21",
                                "monoisotopic_mass": "2792.4936",
                                "monoisotopic_mz": "699.1307",
                                "intensity": "3486.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "22",
                                "monoisotopic_mass": "4812.3162",
                                "monoisotopic_mz": "803.0600",
                                "intensity": "4258.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "23",
                                "monoisotopic_mass": "7172.4540",
                                "monoisotopic_mz": "797.9466",
                                "intensity": "2567.28",
                                "charge": "9"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "24",
                                "monoisotopic_mass": "5714.0119",
                                "monoisotopic_mz": "715.2588",
                                "intensity": "3196.26",
                                "charge": "8"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "25",
                                "monoisotopic_mass": "960.4647",
                                "monoisotopic_mz": "961.4720",
                                "intensity": "1250.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "26",
                                "monoisotopic_mass": "8371.0992",
                                "monoisotopic_mz": "762.0163",
                                "intensity": "1042.87",
                                "charge": "11"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "27",
                                "monoisotopic_mass": "708.9631",
                                "monoisotopic_mz": "709.9703",
                                "intensity": "905.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "28",
                                "monoisotopic_mass": "2906.5952",
                                "monoisotopic_mz": "727.6561",
                                "intensity": "2271.05",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2906.6012",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0060",
                                        "ppm": "-2.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "29",
                                "monoisotopic_mass": "9086.4385",
                                "monoisotopic_mz": "758.2105",
                                "intensity": "933.62",
                                "charge": "12"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "30",
                                "monoisotopic_mass": "4231.2558",
                                "monoisotopic_mz": "847.2584",
                                "intensity": "1041.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "31",
                                "monoisotopic_mass": "778.7689",
                                "monoisotopic_mz": "779.7762",
                                "intensity": "1012.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "32",
                                "monoisotopic_mass": "830.7785",
                                "monoisotopic_mz": "831.7858",
                                "intensity": "1104.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "33",
                                "monoisotopic_mass": "3094.0303",
                                "monoisotopic_mz": "774.5148",
                                "intensity": "2272.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "34",
                                "monoisotopic_mass": "4982.7822",
                                "monoisotopic_mz": "831.4710",
                                "intensity": "868.26",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0139",
                                        "ppm": "2.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "35",
                                "monoisotopic_mass": "2104.3013",
                                "monoisotopic_mz": "702.4410",
                                "intensity": "1455.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "36",
                                "monoisotopic_mass": "6007.2116",
                                "monoisotopic_mz": "1002.2092",
                                "intensity": "836.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "37",
                                "monoisotopic_mass": "6829.0247",
                                "monoisotopic_mz": "759.7878",
                                "intensity": "1140.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "38",
                                "monoisotopic_mass": "3448.6286",
                                "monoisotopic_mz": "690.7330",
                                "intensity": "904.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "39",
                                "monoisotopic_mass": "7890.0854",
                                "monoisotopic_mz": "790.0158",
                                "intensity": "1901.97",
                                "charge": "10"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "40",
                                "monoisotopic_mass": "4509.5041",
                                "monoisotopic_mz": "752.5913",
                                "intensity": "2792.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "41",
                                "monoisotopic_mass": "4935.4150",
                                "monoisotopic_mz": "706.0666",
                                "intensity": "2319.65",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "42",
                                "monoisotopic_mass": "1419.8814",
                                "monoisotopic_mz": "710.9480",
                                "intensity": "583.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "43",
                                "monoisotopic_mass": "894.9471",
                                "monoisotopic_mz": "895.9544",
                                "intensity": "1884.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "44",
                                "monoisotopic_mass": "1340.7567",
                                "monoisotopic_mz": "671.3856",
                                "intensity": "2737.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "45",
                                "monoisotopic_mass": "5357.8557",
                                "monoisotopic_mz": "670.7392",
                                "intensity": "3679.80",
                                "charge": "8"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "46",
                                "monoisotopic_mass": "4773.9072",
                                "monoisotopic_mz": "796.6585",
                                "intensity": "1037.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "47",
                                "monoisotopic_mass": "5818.6851",
                                "monoisotopic_mz": "832.2480",
                                "intensity": "1511.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "48",
                                "monoisotopic_mass": "6800.5172",
                                "monoisotopic_mz": "756.6203",
                                "intensity": "808.13",
                                "charge": "9"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "49",
                                "monoisotopic_mass": "850.1952",
                                "monoisotopic_mz": "851.2025",
                                "intensity": "995.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "50",
                                "monoisotopic_mass": "1493.4897",
                                "monoisotopic_mz": "747.7521",
                                "intensity": "2858.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "51",
                                "monoisotopic_mass": "1597.7679",
                                "monoisotopic_mz": "799.8912",
                                "intensity": "2025.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "52",
                                "monoisotopic_mass": "5446.7973",
                                "monoisotopic_mz": "779.1212",
                                "intensity": "2789.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "53",
                                "monoisotopic_mass": "793.4241",
                                "monoisotopic_mz": "794.4314",
                                "intensity": "974.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "54",
                                "monoisotopic_mass": "2743.3740",
                                "monoisotopic_mz": "686.8508",
                                "intensity": "1173.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "55",
                                "monoisotopic_mass": "2265.8583",
                                "monoisotopic_mz": "756.2934",
                                "intensity": "3267.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "56",
                                "monoisotopic_mass": "4154.9942",
                                "monoisotopic_mz": "832.0061",
                                "intensity": "2639.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "57",
                                "monoisotopic_mass": "1399.8959",
                                "monoisotopic_mz": "700.9552",
                                "intensity": "612.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "58",
                                "monoisotopic_mass": "3931.3283",
                                "monoisotopic_mz": "787.2729",
                                "intensity": "1632.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "59",
                                "monoisotopic_mass": "3598.1832",
                                "monoisotopic_mz": "720.6439",
                                "intensity": "1396.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "60",
                                "monoisotopic_mass": "6205.4503",
                                "monoisotopic_mz": "776.6886",
                                "intensity": "1284.35",
                                "charge": "8"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "61",
                                "monoisotopic_mass": "6307.9768",
                                "monoisotopic_mz": "701.8936",
                                "intensity": "2072.26",
                                "charge": "9"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "62",
                                "monoisotopic_mass": "5476.7166",
                                "monoisotopic_mz": "783.3954",
                                "intensity": "2116.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "45",
                                "peak_id": "63",
                                "monoisotopic_mass": "807.4391",
                                "monoisotopic_mz": "808.4464",
                                "intensity": "979.96",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "17",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9237.1141",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "45",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "45",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "45",
                                        "peak_id": "28",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "45",
                                        "peak_id": "34",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "45",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "45",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "45",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "45",
                                            "peak_id": "11",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "45",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "45",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "29",
                            "right_position": "42",
                            "anno": "17.1195",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "229",
                "p_value": "1.57e-03",
                "e_value": "1.57e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "504",
                        "ms1_scans": "823",
                        "ids": "318",
                        "scans": "824",
                        "precursor_mono_mass": "9235.9718",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4666",
                        "feature_inte": "1.3509e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "318",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5793",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "22364.19",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4929",
                                "monoisotopic_mz": "750.2561",
                                "intensity": "8038.04",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0040",
                                        "ppm": "0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5178",
                                "monoisotopic_mz": "762.2602",
                                "intensity": "7105.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "3",
                                "monoisotopic_mass": "4798.6481",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "10139.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "4",
                                "monoisotopic_mass": "4698.5679",
                                "monoisotopic_mz": "672.2313",
                                "intensity": "8884.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "5",
                                "monoisotopic_mass": "4682.5534",
                                "monoisotopic_mz": "781.4328",
                                "intensity": "4932.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "6",
                                "monoisotopic_mass": "4641.5525",
                                "monoisotopic_mz": "774.5994",
                                "intensity": "5093.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "7",
                                "monoisotopic_mass": "4155.1522",
                                "monoisotopic_mz": "1039.7953",
                                "intensity": "2889.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "8",
                                "monoisotopic_mass": "931.1686",
                                "monoisotopic_mz": "932.1759",
                                "intensity": "2440.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "9",
                                "monoisotopic_mass": "1472.8093",
                                "monoisotopic_mz": "737.4119",
                                "intensity": "4496.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "10",
                                "monoisotopic_mass": "5985.2584",
                                "monoisotopic_mz": "749.1646",
                                "intensity": "928.31",
                                "charge": "8"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "11",
                                "monoisotopic_mass": "974.4172",
                                "monoisotopic_mz": "975.4245",
                                "intensity": "1379.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "12",
                                "monoisotopic_mass": "2069.0778",
                                "monoisotopic_mz": "1035.5462",
                                "intensity": "782.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "13",
                                "monoisotopic_mass": "5622.8102",
                                "monoisotopic_mz": "703.8585",
                                "intensity": "888.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "14",
                                "monoisotopic_mass": "2697.4315",
                                "monoisotopic_mz": "900.1511",
                                "intensity": "842.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "15",
                                "monoisotopic_mass": "1449.2473",
                                "monoisotopic_mz": "725.6309",
                                "intensity": "712.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "16",
                                "monoisotopic_mass": "1417.8719",
                                "monoisotopic_mz": "709.9432",
                                "intensity": "561.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "17",
                                "monoisotopic_mass": "730.0504",
                                "monoisotopic_mz": "731.0577",
                                "intensity": "1009.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "18",
                                "monoisotopic_mass": "4517.4725",
                                "monoisotopic_mz": "753.9194",
                                "intensity": "955.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "19",
                                "monoisotopic_mass": "1339.7066",
                                "monoisotopic_mz": "670.8606",
                                "intensity": "475.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "20",
                                "monoisotopic_mass": "1498.5886",
                                "monoisotopic_mz": "750.3016",
                                "intensity": "426.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "21",
                                "monoisotopic_mass": "2111.3063",
                                "monoisotopic_mz": "704.7761",
                                "intensity": "1030.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "22",
                                "monoisotopic_mass": "3550.2569",
                                "monoisotopic_mz": "711.0586",
                                "intensity": "775.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "23",
                                "monoisotopic_mass": "5849.8653",
                                "monoisotopic_mz": "732.2404",
                                "intensity": "1092.95",
                                "charge": "8"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "24",
                                "monoisotopic_mass": "2977.6015",
                                "monoisotopic_mz": "745.4077",
                                "intensity": "2012.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2977.6383",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0367",
                                        "ppm": "-12.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "25",
                                "monoisotopic_mass": "709.7724",
                                "monoisotopic_mz": "710.7797",
                                "intensity": "1133.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "26",
                                "monoisotopic_mass": "758.0729",
                                "monoisotopic_mz": "759.0801",
                                "intensity": "590.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "27",
                                "monoisotopic_mass": "2891.7550",
                                "monoisotopic_mz": "723.9460",
                                "intensity": "1482.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "28",
                                "monoisotopic_mass": "831.2964",
                                "monoisotopic_mz": "832.3037",
                                "intensity": "657.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "29",
                                "monoisotopic_mass": "2192.4841",
                                "monoisotopic_mz": "731.8353",
                                "intensity": "1615.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "318",
                                "peak_id": "30",
                                "monoisotopic_mass": "685.8166",
                                "monoisotopic_mz": "686.8238",
                                "intensity": "980.25",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "17",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.2468",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "318",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "318",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "318",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "318",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "318",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "30",
                            "right_position": "44",
                            "anno": "16.2522",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "10",
                "p_value": "2.68e-03",
                "e_value": "2.68e-03",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "55",
                        "ms1_scans": "68",
                        "ids": "13",
                        "scans": "70",
                        "precursor_mono_mass": "9234.9562",
                        "precursor_charge": "13",
                        "precursor_mz": "711.3885",
                        "feature_inte": "1.3509e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "13",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5796",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "24282.48",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0009",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4852",
                                "monoisotopic_mz": "750.2548",
                                "intensity": "7567.89",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "2",
                                "monoisotopic_mass": "4797.6491",
                                "monoisotopic_mz": "800.6155",
                                "intensity": "11490.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5779",
                                "monoisotopic_mz": "672.3756",
                                "intensity": "9336.97",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8095",
                                "monoisotopic_mz": "737.4120",
                                "intensity": "5336.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "5",
                                "monoisotopic_mass": "2284.2640",
                                "monoisotopic_mz": "762.4286",
                                "intensity": "5273.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "6",
                                "monoisotopic_mass": "4797.6450",
                                "monoisotopic_mz": "686.3851",
                                "intensity": "4348.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "7",
                                "monoisotopic_mass": "4681.5496",
                                "monoisotopic_mz": "781.2655",
                                "intensity": "6609.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "8",
                                "monoisotopic_mass": "1417.8728",
                                "monoisotopic_mz": "709.9437",
                                "intensity": "3683.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "9",
                                "monoisotopic_mass": "4642.5566",
                                "monoisotopic_mz": "774.7667",
                                "intensity": "3855.20",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "10",
                                "monoisotopic_mass": "4911.7402",
                                "monoisotopic_mz": "819.6306",
                                "intensity": "4232.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0090",
                                        "ppm": "1.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "11",
                                "monoisotopic_mass": "4680.5667",
                                "monoisotopic_mz": "669.6597",
                                "intensity": "3505.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "12",
                                "monoisotopic_mass": "2793.5194",
                                "monoisotopic_mz": "932.1804",
                                "intensity": "4359.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "13",
                                "monoisotopic_mass": "3045.6854",
                                "monoisotopic_mz": "762.4286",
                                "intensity": "2826.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "14",
                                "monoisotopic_mass": "707.8403",
                                "monoisotopic_mz": "708.8476",
                                "intensity": "1552.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "15",
                                "monoisotopic_mass": "9147.3250",
                                "monoisotopic_mz": "704.6477",
                                "intensity": "961.40",
                                "charge": "13"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "16",
                                "monoisotopic_mass": "6367.9349",
                                "monoisotopic_mz": "708.5556",
                                "intensity": "1099.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "17",
                                "monoisotopic_mass": "4666.5837",
                                "monoisotopic_mz": "778.7712",
                                "intensity": "2032.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "18",
                                "monoisotopic_mass": "5615.3275",
                                "monoisotopic_mz": "803.1969",
                                "intensity": "771.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "19",
                                "monoisotopic_mass": "2976.6347",
                                "monoisotopic_mz": "993.2189",
                                "intensity": "1077.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "20",
                                "monoisotopic_mass": "2680.4268",
                                "monoisotopic_mz": "894.4829",
                                "intensity": "2334.85",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0062",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "21",
                                "monoisotopic_mass": "2267.7231",
                                "monoisotopic_mz": "756.9150",
                                "intensity": "1017.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "22",
                                "monoisotopic_mass": "2808.5115",
                                "monoisotopic_mz": "937.1778",
                                "intensity": "1648.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "23",
                                "monoisotopic_mass": "1039.0387",
                                "monoisotopic_mz": "1040.0460",
                                "intensity": "1045.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "24",
                                "monoisotopic_mass": "4074.2404",
                                "monoisotopic_mz": "815.8554",
                                "intensity": "803.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "25",
                                "monoisotopic_mass": "6387.5208",
                                "monoisotopic_mz": "710.7318",
                                "intensity": "2385.34",
                                "charge": "9"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "26",
                                "monoisotopic_mass": "5041.9664",
                                "monoisotopic_mz": "721.2882",
                                "intensity": "1933.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "27",
                                "monoisotopic_mass": "4217.6031",
                                "monoisotopic_mz": "703.9411",
                                "intensity": "1062.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "28",
                                "monoisotopic_mass": "727.8921",
                                "monoisotopic_mz": "728.8994",
                                "intensity": "926.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "29",
                                "monoisotopic_mass": "4961.6638",
                                "monoisotopic_mz": "709.8164",
                                "intensity": "1497.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "30",
                                "monoisotopic_mass": "1450.0865",
                                "monoisotopic_mz": "726.0505",
                                "intensity": "1376.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "31",
                                "monoisotopic_mass": "3983.4384",
                                "monoisotopic_mz": "797.6950",
                                "intensity": "919.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "32",
                                "monoisotopic_mass": "3538.8169",
                                "monoisotopic_mz": "708.7707",
                                "intensity": "7799.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "33",
                                "monoisotopic_mass": "5269.3091",
                                "monoisotopic_mz": "753.7657",
                                "intensity": "769.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "34",
                                "monoisotopic_mass": "1340.7219",
                                "monoisotopic_mz": "671.3682",
                                "intensity": "1588.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "35",
                                "monoisotopic_mass": "5216.1473",
                                "monoisotopic_mz": "746.1712",
                                "intensity": "759.26",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "36",
                                "monoisotopic_mass": "3635.0283",
                                "monoisotopic_mz": "728.0129",
                                "intensity": "524.17",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "37",
                                "monoisotopic_mass": "2838.0781",
                                "monoisotopic_mz": "710.5268",
                                "intensity": "2072.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "38",
                                "monoisotopic_mass": "3263.7800",
                                "monoisotopic_mz": "816.9523",
                                "intensity": "2029.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "39",
                                "monoisotopic_mass": "754.4101",
                                "monoisotopic_mz": "755.4174",
                                "intensity": "1012.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "40",
                                "monoisotopic_mass": "7684.4583",
                                "monoisotopic_mz": "769.4531",
                                "intensity": "1054.13",
                                "charge": "10"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "41",
                                "monoisotopic_mass": "856.7682",
                                "monoisotopic_mz": "857.7755",
                                "intensity": "1048.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "42",
                                "monoisotopic_mass": "1075.6460",
                                "monoisotopic_mz": "538.8303",
                                "intensity": "633.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "43",
                                "monoisotopic_mass": "4408.8646",
                                "monoisotopic_mz": "735.8180",
                                "intensity": "1851.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "44",
                                "monoisotopic_mass": "7419.3551",
                                "monoisotopic_mz": "675.4941",
                                "intensity": "1097.91",
                                "charge": "11"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "45",
                                "monoisotopic_mass": "2909.2425",
                                "monoisotopic_mz": "728.3179",
                                "intensity": "2432.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "46",
                                "monoisotopic_mass": "5641.3429",
                                "monoisotopic_mz": "706.1751",
                                "intensity": "658.94",
                                "charge": "8"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "47",
                                "monoisotopic_mass": "1378.5838",
                                "monoisotopic_mz": "690.2992",
                                "intensity": "937.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "48",
                                "monoisotopic_mass": "1492.8222",
                                "monoisotopic_mz": "747.4184",
                                "intensity": "1774.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "49",
                                "monoisotopic_mass": "893.1398",
                                "monoisotopic_mz": "894.1471",
                                "intensity": "405.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "50",
                                "monoisotopic_mass": "1523.1470",
                                "monoisotopic_mz": "762.5808",
                                "intensity": "1383.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "51",
                                "monoisotopic_mass": "4191.8786",
                                "monoisotopic_mz": "699.6537",
                                "intensity": "2875.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "52",
                                "monoisotopic_mass": "644.5131",
                                "monoisotopic_mz": "645.5204",
                                "intensity": "759.38",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "17",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.2312",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "13",
                                        "peak_id": "20",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "13",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "13",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "13",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "13",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "13",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "13",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "27",
                            "right_position": "43",
                            "anno": "15.2365",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "225",
                "p_value": "4.84e-03",
                "e_value": "4.85e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "484",
                        "ms1_scans": "799",
                        "ids": "314",
                        "scans": "800",
                        "precursor_mono_mass": "9235.9766",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4670",
                        "feature_inte": "1.3509e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "314",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "22996.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4878",
                                "monoisotopic_mz": "750.2552",
                                "intensity": "14017.29",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6481",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "10634.65",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5779",
                                "monoisotopic_mz": "672.3756",
                                "intensity": "6262.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5211",
                                "monoisotopic_mz": "762.2608",
                                "intensity": "8810.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "5",
                                "monoisotopic_mass": "4683.5608",
                                "monoisotopic_mz": "781.6007",
                                "intensity": "6024.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "6",
                                "monoisotopic_mass": "2792.5050",
                                "monoisotopic_mz": "931.8423",
                                "intensity": "2972.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "7",
                                "monoisotopic_mass": "4641.5619",
                                "monoisotopic_mz": "774.6009",
                                "intensity": "3690.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "8",
                                "monoisotopic_mass": "1472.8103",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "5420.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0003",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "9",
                                "monoisotopic_mass": "1613.8845",
                                "monoisotopic_mz": "807.9495",
                                "intensity": "1310.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "10",
                                "monoisotopic_mass": "4797.6326",
                                "monoisotopic_mz": "686.3834",
                                "intensity": "5398.60",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "16.1069334787",
                                        "theoretical_mass": "4797.6343",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "11",
                                "monoisotopic_mass": "3225.7697",
                                "monoisotopic_mz": "807.4497",
                                "intensity": "1826.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "12",
                                "monoisotopic_mass": "4509.4924",
                                "monoisotopic_mz": "752.5893",
                                "intensity": "3192.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "13",
                                "monoisotopic_mass": "2809.5068",
                                "monoisotopic_mz": "703.3840",
                                "intensity": "2373.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "14",
                                "monoisotopic_mass": "2180.7166",
                                "monoisotopic_mz": "727.9128",
                                "intensity": "1886.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "15",
                                "monoisotopic_mass": "1340.7561",
                                "monoisotopic_mz": "671.3853",
                                "intensity": "1697.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "16",
                                "monoisotopic_mass": "974.4194",
                                "monoisotopic_mz": "975.4266",
                                "intensity": "1227.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "17",
                                "monoisotopic_mass": "5396.8630",
                                "monoisotopic_mz": "675.6152",
                                "intensity": "686.62",
                                "charge": "8"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "18",
                                "monoisotopic_mass": "669.0811",
                                "monoisotopic_mz": "670.0884",
                                "intensity": "1361.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "19",
                                "monoisotopic_mass": "6657.7023",
                                "monoisotopic_mz": "740.7520",
                                "intensity": "921.24",
                                "charge": "9"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "20",
                                "monoisotopic_mass": "1038.7898",
                                "monoisotopic_mz": "1039.7971",
                                "intensity": "1649.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "21",
                                "monoisotopic_mass": "4263.6098",
                                "monoisotopic_mz": "711.6089",
                                "intensity": "2149.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "22",
                                "monoisotopic_mass": "7091.5474",
                                "monoisotopic_mz": "710.1620",
                                "intensity": "1273.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "23",
                                "monoisotopic_mass": "3012.2116",
                                "monoisotopic_mz": "754.0602",
                                "intensity": "1804.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "24",
                                "monoisotopic_mass": "1492.4942",
                                "monoisotopic_mz": "747.2544",
                                "intensity": "458.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "25",
                                "monoisotopic_mass": "1439.2903",
                                "monoisotopic_mz": "720.6524",
                                "intensity": "496.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "26",
                                "monoisotopic_mass": "1418.0902",
                                "monoisotopic_mz": "710.0524",
                                "intensity": "442.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "27",
                                "monoisotopic_mass": "2022.0582",
                                "monoisotopic_mz": "675.0267",
                                "intensity": "737.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "28",
                                "monoisotopic_mass": "1386.0952",
                                "monoisotopic_mz": "694.0549",
                                "intensity": "567.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "29",
                                "monoisotopic_mass": "4721.9383",
                                "monoisotopic_mz": "675.5699",
                                "intensity": "679.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "30",
                                "monoisotopic_mass": "1328.7173",
                                "monoisotopic_mz": "665.3659",
                                "intensity": "650.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "31",
                                "monoisotopic_mass": "1403.9321",
                                "monoisotopic_mz": "702.9733",
                                "intensity": "1020.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "32",
                                "monoisotopic_mass": "1372.5245",
                                "monoisotopic_mz": "687.2695",
                                "intensity": "497.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "33",
                                "monoisotopic_mass": "4671.5112",
                                "monoisotopic_mz": "668.3660",
                                "intensity": "1094.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "34",
                                "monoisotopic_mass": "830.9594",
                                "monoisotopic_mz": "831.9667",
                                "intensity": "507.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "35",
                                "monoisotopic_mass": "706.7666",
                                "monoisotopic_mz": "707.7738",
                                "intensity": "989.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "36",
                                "monoisotopic_mass": "2697.8363",
                                "monoisotopic_mz": "675.4663",
                                "intensity": "712.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "37",
                                "monoisotopic_mass": "728.4770",
                                "monoisotopic_mz": "729.4843",
                                "intensity": "570.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "38",
                                "monoisotopic_mass": "1311.6915",
                                "monoisotopic_mz": "656.8530",
                                "intensity": "2232.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "314",
                                "peak_id": "39",
                                "monoisotopic_mass": "887.1484",
                                "monoisotopic_mz": "888.1557",
                                "intensity": "802.33",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "17",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.1016",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "314",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "314",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "314",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "314",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "314",
                                        "peak_id": "10",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "314",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "16.1069",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
