prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "10",
        "sequence_name": "sp|P0AA04|PTHP_ECOLI",
        "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
        "proteoform_id": "13",
        "prsm_number": "4",
        "prsm": [
            {
                "prsm_id": "161",
                "p_value": "2.89e-06",
                "e_value": "2.89e-06",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "126",
                        "ms1_scans": "355",
                        "ids": "228",
                        "scans": "356",
                        "precursor_mono_mass": "9114.7210",
                        "precursor_charge": "11",
                        "precursor_mz": "829.6183",
                        "feature_inte": "4.5700e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "228",
                                "peak_id": "0",
                                "monoisotopic_mass": "2767.3958",
                                "monoisotopic_mz": "923.4725",
                                "intensity": "4850.18",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2767.3950",
                                        "ion_position": "60",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "60",
                                        "mass_error": "0.0007",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "1",
                                "monoisotopic_mass": "2667.3233",
                                "monoisotopic_mz": "890.1150",
                                "intensity": "4057.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "2",
                                "monoisotopic_mass": "2567.2783",
                                "monoisotopic_mz": "856.7667",
                                "intensity": "3289.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2567.2789",
                                        "ion_position": "62",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "3",
                                "monoisotopic_mass": "2454.1932",
                                "monoisotopic_mz": "819.0717",
                                "intensity": "3383.14",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2454.1949",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "4",
                                "monoisotopic_mass": "3521.8230",
                                "monoisotopic_mz": "881.4630",
                                "intensity": "3369.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "5",
                                "monoisotopic_mass": "2824.5089",
                                "monoisotopic_mz": "942.5102",
                                "intensity": "2718.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "6",
                                "monoisotopic_mass": "2650.0590",
                                "monoisotopic_mz": "884.3603",
                                "intensity": "2838.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "7",
                                "monoisotopic_mass": "890.4438",
                                "monoisotopic_mz": "891.4511",
                                "intensity": "1219.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "8",
                                "monoisotopic_mass": "5840.5022",
                                "monoisotopic_mz": "974.4243",
                                "intensity": "1083.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "9",
                                "monoisotopic_mass": "959.5179",
                                "monoisotopic_mz": "960.5252",
                                "intensity": "1109.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "10",
                                "monoisotopic_mass": "6029.3426",
                                "monoisotopic_mz": "862.3419",
                                "intensity": "977.31",
                                "charge": "7"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "11",
                                "monoisotopic_mass": "762.3369",
                                "monoisotopic_mz": "763.3442",
                                "intensity": "1588.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3371",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "12",
                                "monoisotopic_mass": "4693.5248",
                                "monoisotopic_mz": "939.7122",
                                "intensity": "2112.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "13",
                                "monoisotopic_mass": "7132.6312",
                                "monoisotopic_mz": "892.5862",
                                "intensity": "946.64",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7132.7183",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0872",
                                        "ppm": "-12.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "14",
                                "monoisotopic_mass": "663.2685",
                                "monoisotopic_mz": "664.2758",
                                "intensity": "1543.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "663.2686",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "15",
                                "monoisotopic_mass": "1821.6465",
                                "monoisotopic_mz": "911.8305",
                                "intensity": "1529.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "16",
                                "monoisotopic_mass": "7616.8354",
                                "monoisotopic_mz": "953.1117",
                                "intensity": "2230.31",
                                "charge": "8"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "17",
                                "monoisotopic_mass": "832.4370",
                                "monoisotopic_mz": "833.4443",
                                "intensity": "1057.91",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "832.4365",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0005",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "18",
                                "monoisotopic_mass": "4376.4145",
                                "monoisotopic_mz": "876.2902",
                                "intensity": "2378.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "19",
                                "monoisotopic_mass": "5700.9634",
                                "monoisotopic_mz": "951.1678",
                                "intensity": "2044.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "20",
                                "monoisotopic_mass": "996.2755",
                                "monoisotopic_mz": "997.2828",
                                "intensity": "1768.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "21",
                                "monoisotopic_mass": "1059.5055",
                                "monoisotopic_mz": "530.7600",
                                "intensity": "1239.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "22",
                                "monoisotopic_mass": "8255.5680",
                                "monoisotopic_mz": "918.2926",
                                "intensity": "2300.94",
                                "charge": "9"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "23",
                                "monoisotopic_mass": "4018.3816",
                                "monoisotopic_mz": "1005.6027",
                                "intensity": "1009.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "24",
                                "monoisotopic_mass": "1130.5420",
                                "monoisotopic_mz": "566.2783",
                                "intensity": "1281.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "25",
                                "monoisotopic_mass": "2479.3470",
                                "monoisotopic_mz": "827.4563",
                                "intensity": "1547.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "26",
                                "monoisotopic_mass": "818.9433",
                                "monoisotopic_mz": "819.9506",
                                "intensity": "1208.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "27",
                                "monoisotopic_mass": "4644.0472",
                                "monoisotopic_mz": "929.8167",
                                "intensity": "1952.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "28",
                                "monoisotopic_mass": "1011.4761",
                                "monoisotopic_mz": "1012.4834",
                                "intensity": "827.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "29",
                                "monoisotopic_mass": "710.3777",
                                "monoisotopic_mz": "711.3850",
                                "intensity": "827.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "228",
                                "peak_id": "30",
                                "monoisotopic_mass": "926.1746",
                                "monoisotopic_mz": "927.1819",
                                "intensity": "853.72",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "13",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9113.7374",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "228",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "228",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "25",
                                        "spec_id": "228",
                                        "peak_id": "0",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "23",
                                        "spec_id": "228",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "spec_id": "228",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "228",
                                        "peak_id": "13",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "spec_id": "228",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "153",
                "p_value": "9.48e-05",
                "e_value": "9.48e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "122",
                        "ms1_scans": "336",
                        "ids": "216",
                        "scans": "340",
                        "precursor_mono_mass": "9112.7111",
                        "precursor_charge": "10",
                        "precursor_mz": "912.2784",
                        "feature_inte": "4.5700e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "216",
                                "peak_id": "0",
                                "monoisotopic_mass": "7965.1666",
                                "monoisotopic_mz": "996.6531",
                                "intensity": "20717.24",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0212374125",
                                        "theoretical_mass": "7964.1626",
                                        "ion_position": "10",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "Y00075",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0017",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "1",
                                "monoisotopic_mass": "8180.2011",
                                "monoisotopic_mz": "1023.5324",
                                "intensity": "25973.26",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0212374125",
                                        "theoretical_mass": "8181.2113",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0078",
                                        "ppm": "-0.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "2",
                                "monoisotopic_mass": "7285.9510",
                                "monoisotopic_mz": "911.7511",
                                "intensity": "12396.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "3",
                                "monoisotopic_mass": "7950.1665",
                                "monoisotopic_mz": "994.7781",
                                "intensity": "8148.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "4",
                                "monoisotopic_mass": "993.7732",
                                "monoisotopic_mz": "994.7805",
                                "intensity": "2626.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "5",
                                "monoisotopic_mass": "1273.7342",
                                "monoisotopic_mz": "637.8744",
                                "intensity": "2312.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "6",
                                "monoisotopic_mass": "4018.0959",
                                "monoisotopic_mz": "1005.5313",
                                "intensity": "5954.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "7",
                                "monoisotopic_mass": "2167.0831",
                                "monoisotopic_mz": "1084.5488",
                                "intensity": "3515.71",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.0831",
                                        "ion_position": "66",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "66",
                                        "mass_error": "0.0000",
                                        "ppm": "0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "8",
                                "monoisotopic_mass": "1386.8184",
                                "monoisotopic_mz": "694.4165",
                                "intensity": "2247.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "9",
                                "monoisotopic_mass": "3701.8304",
                                "monoisotopic_mz": "926.4649",
                                "intensity": "4003.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "10",
                                "monoisotopic_mass": "2733.1177",
                                "monoisotopic_mz": "912.0465",
                                "intensity": "3117.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "11",
                                "monoisotopic_mass": "2667.3172",
                                "monoisotopic_mz": "890.1130",
                                "intensity": "2879.07",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0212374125",
                                        "theoretical_mass": "2667.3054",
                                        "ion_position": "61",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0119",
                                        "ppm": "4.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "12",
                                "monoisotopic_mass": "1234.2791",
                                "monoisotopic_mz": "1235.2864",
                                "intensity": "2529.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "13",
                                "monoisotopic_mass": "1023.9053",
                                "monoisotopic_mz": "1024.9126",
                                "intensity": "1975.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "14",
                                "monoisotopic_mass": "8799.5834",
                                "monoisotopic_mz": "978.7388",
                                "intensity": "1337.12",
                                "charge": "9"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "15",
                                "monoisotopic_mass": "8519.3246",
                                "monoisotopic_mz": "1065.9229",
                                "intensity": "2517.86",
                                "charge": "8"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "16",
                                "monoisotopic_mass": "4560.7453",
                                "monoisotopic_mz": "913.1563",
                                "intensity": "4147.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "17",
                                "monoisotopic_mass": "6804.6012",
                                "monoisotopic_mz": "973.0932",
                                "intensity": "2156.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "18",
                                "monoisotopic_mass": "4500.4156",
                                "monoisotopic_mz": "901.0904",
                                "intensity": "1817.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "19",
                                "monoisotopic_mass": "8164.1579",
                                "monoisotopic_mz": "908.1359",
                                "intensity": "2124.23",
                                "charge": "9"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "20",
                                "monoisotopic_mass": "7929.1674",
                                "monoisotopic_mz": "882.0259",
                                "intensity": "1312.20",
                                "charge": "9"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "21",
                                "monoisotopic_mass": "2645.8945",
                                "monoisotopic_mz": "882.9721",
                                "intensity": "1449.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "22",
                                "monoisotopic_mass": "7220.9749",
                                "monoisotopic_mz": "903.6291",
                                "intensity": "1012.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "23",
                                "monoisotopic_mass": "2454.1876",
                                "monoisotopic_mz": "1228.1011",
                                "intensity": "1601.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2454.1949",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0072",
                                        "ppm": "-2.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "24",
                                "monoisotopic_mass": "663.2682",
                                "monoisotopic_mz": "664.2755",
                                "intensity": "1532.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "663.2686",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "25",
                                "monoisotopic_mass": "770.3555",
                                "monoisotopic_mz": "771.3627",
                                "intensity": "1578.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "26",
                                "monoisotopic_mass": "6673.4183",
                                "monoisotopic_mz": "954.3528",
                                "intensity": "2312.63",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0212374125",
                                        "theoretical_mass": "6674.4997",
                                        "ion_position": "22",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0790",
                                        "ppm": "-11.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "27",
                                "monoisotopic_mass": "910.2039",
                                "monoisotopic_mz": "911.2112",
                                "intensity": "1448.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "28",
                                "monoisotopic_mass": "833.4428",
                                "monoisotopic_mz": "834.4501",
                                "intensity": "1999.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "29",
                                "monoisotopic_mass": "965.3789",
                                "monoisotopic_mz": "966.3862",
                                "intensity": "1089.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "30",
                                "monoisotopic_mass": "2021.0442",
                                "monoisotopic_mz": "1011.5294",
                                "intensity": "3109.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2021.0153",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0290",
                                        "ppm": "14.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "31",
                                "monoisotopic_mass": "1065.9202",
                                "monoisotopic_mz": "1066.9275",
                                "intensity": "928.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "32",
                                "monoisotopic_mass": "880.2015",
                                "monoisotopic_mz": "881.2087",
                                "intensity": "1682.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "33",
                                "monoisotopic_mass": "1153.5688",
                                "monoisotopic_mz": "1154.5760",
                                "intensity": "711.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "34",
                                "monoisotopic_mass": "2228.0132",
                                "monoisotopic_mz": "743.6783",
                                "intensity": "1416.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "35",
                                "monoisotopic_mass": "951.7228",
                                "monoisotopic_mz": "952.7300",
                                "intensity": "1611.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "36",
                                "monoisotopic_mass": "1115.9875",
                                "monoisotopic_mz": "1116.9947",
                                "intensity": "1553.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "37",
                                "monoisotopic_mass": "2088.5270",
                                "monoisotopic_mz": "1045.2708",
                                "intensity": "1145.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "38",
                                "monoisotopic_mass": "1059.5041",
                                "monoisotopic_mz": "530.7593",
                                "intensity": "1479.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "39",
                                "monoisotopic_mass": "1664.8753",
                                "monoisotopic_mz": "833.4449",
                                "intensity": "1544.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "40",
                                "monoisotopic_mass": "2053.0361",
                                "monoisotopic_mz": "1027.5253",
                                "intensity": "1549.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "41",
                                "monoisotopic_mass": "1821.2375",
                                "monoisotopic_mz": "911.6260",
                                "intensity": "1167.10",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "13",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9112.7161",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "216",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "75",
                                        "spec_id": "216",
                                        "peak_id": "0",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "216",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "22",
                                        "ion_display_position": "63",
                                        "spec_id": "216",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "24",
                                        "spec_id": "216",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "spec_id": "216",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "19",
                                        "spec_id": "216",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "216",
                                        "peak_id": "1",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "61",
                            "right_position": "63",
                            "anno": "-1.0212",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "31",
                "p_value": "1.90e-03",
                "e_value": "1.90e-03",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "68",
                        "ms1_scans": "106",
                        "ids": "39",
                        "scans": "109",
                        "precursor_mono_mass": "9114.7045",
                        "precursor_charge": "10",
                        "precursor_mz": "912.4777",
                        "feature_inte": "4.5700e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "39",
                                "peak_id": "0",
                                "monoisotopic_mass": "8180.1962",
                                "monoisotopic_mz": "1023.5318",
                                "intensity": "36142.73",
                                "charge": "8"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "1",
                                "monoisotopic_mass": "7284.9743",
                                "monoisotopic_mz": "911.6291",
                                "intensity": "14619.09",
                                "charge": "8"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "2",
                                "monoisotopic_mass": "7895.0703",
                                "monoisotopic_mz": "987.8911",
                                "intensity": "9280.29",
                                "charge": "8"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "3",
                                "monoisotopic_mass": "7298.9700",
                                "monoisotopic_mz": "913.3785",
                                "intensity": "7879.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "4",
                                "monoisotopic_mass": "7964.1386",
                                "monoisotopic_mz": "996.5246",
                                "intensity": "8411.57",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7965.1838",
                                        "ion_position": "10",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "Y00075",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0428",
                                        "ppm": "-5.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "5",
                                "monoisotopic_mass": "2045.3001",
                                "monoisotopic_mz": "1023.6573",
                                "intensity": "6022.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "6",
                                "monoisotopic_mass": "3976.5418",
                                "monoisotopic_mz": "995.1427",
                                "intensity": "3866.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "7",
                                "monoisotopic_mass": "2454.1951",
                                "monoisotopic_mz": "1228.1048",
                                "intensity": "2758.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2454.1949",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "63",
                                        "mass_error": "0.0003",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "8",
                                "monoisotopic_mass": "5466.9543",
                                "monoisotopic_mz": "912.1663",
                                "intensity": "11619.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "9",
                                "monoisotopic_mass": "2723.9618",
                                "monoisotopic_mz": "908.9945",
                                "intensity": "2765.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "10",
                                "monoisotopic_mass": "909.4660",
                                "monoisotopic_mz": "910.4733",
                                "intensity": "1883.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "11",
                                "monoisotopic_mass": "4082.0862",
                                "monoisotopic_mz": "1021.5288",
                                "intensity": "2332.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "12",
                                "monoisotopic_mass": "4755.5285",
                                "monoisotopic_mz": "952.1130",
                                "intensity": "4096.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "13",
                                "monoisotopic_mass": "8518.3315",
                                "monoisotopic_mz": "1065.7987",
                                "intensity": "7166.15",
                                "charge": "8"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "14",
                                "monoisotopic_mass": "1819.5942",
                                "monoisotopic_mz": "910.8044",
                                "intensity": "3777.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "15",
                                "monoisotopic_mass": "2767.4029",
                                "monoisotopic_mz": "923.4749",
                                "intensity": "2216.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2767.3950",
                                        "ion_position": "60",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "60",
                                        "mass_error": "0.0079",
                                        "ppm": "2.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "16",
                                "monoisotopic_mass": "4204.1456",
                                "monoisotopic_mz": "1052.0437",
                                "intensity": "1871.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "17",
                                "monoisotopic_mass": "4552.1278",
                                "monoisotopic_mz": "911.4328",
                                "intensity": "3404.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "18",
                                "monoisotopic_mass": "8138.2713",
                                "monoisotopic_mz": "1018.2912",
                                "intensity": "4156.39",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8137.2686",
                                        "ion_position": "8",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "Y00077",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0004",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "19",
                                "monoisotopic_mass": "3519.8020",
                                "monoisotopic_mz": "1174.2746",
                                "intensity": "5232.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "20",
                                "monoisotopic_mass": "8753.1419",
                                "monoisotopic_mz": "876.3215",
                                "intensity": "2432.37",
                                "charge": "10"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "21",
                                "monoisotopic_mass": "8520.3046",
                                "monoisotopic_mz": "947.7078",
                                "intensity": "5060.34",
                                "charge": "9"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "22",
                                "monoisotopic_mass": "923.0922",
                                "monoisotopic_mz": "924.0995",
                                "intensity": "1103.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "23",
                                "monoisotopic_mass": "7802.1338",
                                "monoisotopic_mz": "976.2740",
                                "intensity": "1307.14",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7803.0469",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "ion_sort_name": "B00074",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0892",
                                        "ppm": "11.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "24",
                                "monoisotopic_mass": "1136.7255",
                                "monoisotopic_mz": "1137.7328",
                                "intensity": "1102.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "25",
                                "monoisotopic_mass": "1065.1681",
                                "monoisotopic_mz": "1066.1754",
                                "intensity": "3594.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "26",
                                "monoisotopic_mass": "2167.0880",
                                "monoisotopic_mz": "1084.5513",
                                "intensity": "1656.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.0831",
                                        "ion_position": "66",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "66",
                                        "mass_error": "0.0049",
                                        "ppm": "2.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "27",
                                "monoisotopic_mass": "952.3701",
                                "monoisotopic_mz": "953.3774",
                                "intensity": "2136.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "28",
                                "monoisotopic_mass": "1018.2938",
                                "monoisotopic_mz": "1019.3010",
                                "intensity": "1112.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "29",
                                "monoisotopic_mass": "4679.4362",
                                "monoisotopic_mz": "936.8945",
                                "intensity": "1468.01",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "30",
                                "monoisotopic_mass": "9088.4559",
                                "monoisotopic_mz": "909.8529",
                                "intensity": "3605.11",
                                "charge": "10"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "31",
                                "monoisotopic_mass": "5483.8450",
                                "monoisotopic_mz": "914.9814",
                                "intensity": "1099.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "32",
                                "monoisotopic_mass": "880.2011",
                                "monoisotopic_mz": "881.2084",
                                "intensity": "1285.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "33",
                                "monoisotopic_mass": "5081.7184",
                                "monoisotopic_mz": "1017.3510",
                                "intensity": "2259.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "34",
                                "monoisotopic_mass": "980.2916",
                                "monoisotopic_mz": "981.2989",
                                "intensity": "1198.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "35",
                                "monoisotopic_mass": "964.9623",
                                "monoisotopic_mz": "965.9696",
                                "intensity": "1044.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "36",
                                "monoisotopic_mass": "4958.3066",
                                "monoisotopic_mz": "992.6686",
                                "intensity": "1203.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "37",
                                "monoisotopic_mass": "8480.6901",
                                "monoisotopic_mz": "943.3062",
                                "intensity": "2262.66",
                                "charge": "9"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "38",
                                "monoisotopic_mass": "3868.9855",
                                "monoisotopic_mz": "968.2536",
                                "intensity": "1739.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "39",
                                "monoisotopic_mass": "1174.9375",
                                "monoisotopic_mz": "1175.9447",
                                "intensity": "342.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "40",
                                "monoisotopic_mass": "2089.0690",
                                "monoisotopic_mz": "1045.5418",
                                "intensity": "1392.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "41",
                                "monoisotopic_mass": "1499.9027",
                                "monoisotopic_mz": "750.9586",
                                "intensity": "761.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "42",
                                "monoisotopic_mass": "6795.3219",
                                "monoisotopic_mz": "971.7675",
                                "intensity": "895.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "43",
                                "monoisotopic_mass": "3929.4412",
                                "monoisotopic_mz": "983.3676",
                                "intensity": "1056.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "44",
                                "monoisotopic_mass": "8021.2769",
                                "monoisotopic_mz": "892.2603",
                                "intensity": "1660.60",
                                "charge": "9"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "45",
                                "monoisotopic_mass": "867.4596",
                                "monoisotopic_mz": "868.4669",
                                "intensity": "1261.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "46",
                                "monoisotopic_mass": "3375.7681",
                                "monoisotopic_mz": "844.9493",
                                "intensity": "2486.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "47",
                                "monoisotopic_mass": "6427.5021",
                                "monoisotopic_mz": "919.2219",
                                "intensity": "2496.14",
                                "charge": "7"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "48",
                                "monoisotopic_mass": "6496.3831",
                                "monoisotopic_mz": "929.0620",
                                "intensity": "1130.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "49",
                                "monoisotopic_mass": "1273.7358",
                                "monoisotopic_mz": "637.8752",
                                "intensity": "1667.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "50",
                                "monoisotopic_mass": "1387.8227",
                                "monoisotopic_mz": "694.9186",
                                "intensity": "1474.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "51",
                                "monoisotopic_mass": "4838.3523",
                                "monoisotopic_mz": "968.6777",
                                "intensity": "1062.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "52",
                                "monoisotopic_mass": "1105.1573",
                                "monoisotopic_mz": "1106.1645",
                                "intensity": "1084.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "53",
                                "monoisotopic_mass": "4019.1015",
                                "monoisotopic_mz": "1005.7826",
                                "intensity": "3553.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "54",
                                "monoisotopic_mass": "5550.8539",
                                "monoisotopic_mz": "926.1496",
                                "intensity": "964.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "55",
                                "monoisotopic_mass": "3700.8204",
                                "monoisotopic_mz": "1234.6141",
                                "intensity": "1823.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "56",
                                "monoisotopic_mass": "1235.9543",
                                "monoisotopic_mz": "1236.9616",
                                "intensity": "516.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "57",
                                "monoisotopic_mass": "3050.4677",
                                "monoisotopic_mz": "1017.8298",
                                "intensity": "1087.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "58",
                                "monoisotopic_mass": "1855.2242",
                                "monoisotopic_mz": "928.6194",
                                "intensity": "1204.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "59",
                                "monoisotopic_mass": "3090.1182",
                                "monoisotopic_mz": "1031.0467",
                                "intensity": "1798.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "60",
                                "monoisotopic_mass": "3557.0570",
                                "monoisotopic_mz": "890.2715",
                                "intensity": "1435.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "61",
                                "monoisotopic_mass": "1031.6615",
                                "monoisotopic_mz": "1032.6687",
                                "intensity": "1271.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "62",
                                "monoisotopic_mass": "818.0700",
                                "monoisotopic_mz": "819.0773",
                                "intensity": "1107.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "63",
                                "monoisotopic_mass": "1268.6436",
                                "monoisotopic_mz": "1269.6509",
                                "intensity": "1095.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "39",
                                "peak_id": "64",
                                "monoisotopic_mass": "3023.9930",
                                "monoisotopic_mz": "1009.0049",
                                "intensity": "2567.51",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "13",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9113.7374",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "77",
                                        "spec_id": "39",
                                        "peak_id": "18",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "75",
                                        "spec_id": "39",
                                        "peak_id": "4",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "25",
                                        "spec_id": "39",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "spec_id": "39",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "19",
                                        "spec_id": "39",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "spec_id": "39",
                                        "peak_id": "23",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "14",
                "p_value": "0.08",
                "e_value": "0.09",
                "fdr": "4.35e-03",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "60",
                        "ms1_scans": "77",
                        "ids": "17",
                        "scans": "79",
                        "precursor_mono_mass": "9112.6907",
                        "precursor_charge": "11",
                        "precursor_mz": "829.4337",
                        "feature_inte": "4.5700e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "17",
                                "peak_id": "0",
                                "monoisotopic_mass": "2668.3286",
                                "monoisotopic_mz": "890.4501",
                                "intensity": "4260.33",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2668.3266",
                                        "ion_position": "61",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0020",
                                        "ppm": "0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "1",
                                "monoisotopic_mass": "2766.3938",
                                "monoisotopic_mz": "923.1385",
                                "intensity": "4428.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "2",
                                "monoisotopic_mass": "2454.1939",
                                "monoisotopic_mz": "819.0719",
                                "intensity": "5930.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2454.1949",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "3",
                                "monoisotopic_mass": "3566.7822",
                                "monoisotopic_mz": "892.7028",
                                "intensity": "3371.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "4",
                                "monoisotopic_mass": "5939.0433",
                                "monoisotopic_mz": "990.8478",
                                "intensity": "1421.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "5",
                                "monoisotopic_mass": "2025.8798",
                                "monoisotopic_mz": "1013.9472",
                                "intensity": "1917.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "6",
                                "monoisotopic_mass": "2367.1640",
                                "monoisotopic_mz": "790.0619",
                                "intensity": "984.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2367.1628",
                                        "ion_position": "64",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0012",
                                        "ppm": "0.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "7",
                                "monoisotopic_mass": "2941.5331",
                                "monoisotopic_mz": "981.5183",
                                "intensity": "2306.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "8",
                                "monoisotopic_mass": "4316.2924",
                                "monoisotopic_mz": "864.2658",
                                "intensity": "2403.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "9",
                                "monoisotopic_mass": "992.5264",
                                "monoisotopic_mz": "993.5337",
                                "intensity": "1248.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "10",
                                "monoisotopic_mass": "1059.5059",
                                "monoisotopic_mz": "530.7603",
                                "intensity": "1119.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "11",
                                "monoisotopic_mass": "777.4108",
                                "monoisotopic_mz": "778.4180",
                                "intensity": "1123.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "12",
                                "monoisotopic_mass": "2801.7276",
                                "monoisotopic_mz": "934.9165",
                                "intensity": "1973.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "13",
                                "monoisotopic_mass": "893.4762",
                                "monoisotopic_mz": "894.4835",
                                "intensity": "1064.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "14",
                                "monoisotopic_mass": "5254.7689",
                                "monoisotopic_mz": "1051.9611",
                                "intensity": "3086.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "15",
                                "monoisotopic_mass": "8022.7334",
                                "monoisotopic_mz": "892.4221",
                                "intensity": "1270.76",
                                "charge": "9"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "16",
                                "monoisotopic_mass": "978.2738",
                                "monoisotopic_mz": "979.2811",
                                "intensity": "1263.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "17",
                                "monoisotopic_mass": "2914.7136",
                                "monoisotopic_mz": "972.5785",
                                "intensity": "1635.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "18",
                                "monoisotopic_mass": "2716.9248",
                                "monoisotopic_mz": "906.6489",
                                "intensity": "2118.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "19",
                                "monoisotopic_mass": "5071.4480",
                                "monoisotopic_mz": "1015.2969",
                                "intensity": "1543.68",
                                "charge": "5"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "20",
                                "monoisotopic_mass": "7453.6606",
                                "monoisotopic_mz": "829.1918",
                                "intensity": "952.76",
                                "charge": "9"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "21",
                                "monoisotopic_mass": "8614.3966",
                                "monoisotopic_mz": "958.1625",
                                "intensity": "974.87",
                                "charge": "9"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "22",
                                "monoisotopic_mass": "2834.4608",
                                "monoisotopic_mz": "945.8276",
                                "intensity": "1686.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "23",
                                "monoisotopic_mass": "5121.6640",
                                "monoisotopic_mz": "854.6179",
                                "intensity": "974.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "24",
                                "monoisotopic_mass": "6894.6727",
                                "monoisotopic_mz": "862.8414",
                                "intensity": "1017.20",
                                "charge": "8"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "25",
                                "monoisotopic_mass": "911.1762",
                                "monoisotopic_mz": "912.1835",
                                "intensity": "1998.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "26",
                                "monoisotopic_mass": "943.1069",
                                "monoisotopic_mz": "944.1141",
                                "intensity": "1151.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "27",
                                "monoisotopic_mass": "859.1291",
                                "monoisotopic_mz": "860.1364",
                                "intensity": "978.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "28",
                                "monoisotopic_mass": "4397.7226",
                                "monoisotopic_mz": "880.5518",
                                "intensity": "1963.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "29",
                                "monoisotopic_mass": "8943.9118",
                                "monoisotopic_mz": "994.7753",
                                "intensity": "1265.28",
                                "charge": "9"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "30",
                                "monoisotopic_mass": "8909.1851",
                                "monoisotopic_mz": "990.9167",
                                "intensity": "849.26",
                                "charge": "9"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "31",
                                "monoisotopic_mass": "5659.5281",
                                "monoisotopic_mz": "944.2620",
                                "intensity": "1028.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "32",
                                "monoisotopic_mass": "2071.0194",
                                "monoisotopic_mz": "1036.5170",
                                "intensity": "1546.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "33",
                                "monoisotopic_mass": "8135.3520",
                                "monoisotopic_mz": "1017.9263",
                                "intensity": "963.70",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.1663741250e-01",
                                        "theoretical_mass": "8136.3520",
                                        "ion_position": "8",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "Y00077",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0024",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "34",
                                "monoisotopic_mass": "1147.5694",
                                "monoisotopic_mz": "1148.5767",
                                "intensity": "707.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "35",
                                "monoisotopic_mass": "5635.6310",
                                "monoisotopic_mz": "940.2791",
                                "intensity": "1039.21",
                                "charge": "6"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "36",
                                "monoisotopic_mass": "1029.7420",
                                "monoisotopic_mz": "1030.7493",
                                "intensity": "753.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "37",
                                "monoisotopic_mass": "706.1150",
                                "monoisotopic_mz": "707.1223",
                                "intensity": "998.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "38",
                                "monoisotopic_mass": "2498.5402",
                                "monoisotopic_mz": "833.8540",
                                "intensity": "951.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "39",
                                "monoisotopic_mass": "5962.4726",
                                "monoisotopic_mz": "746.3164",
                                "intensity": "3586.62",
                                "charge": "8"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "40",
                                "monoisotopic_mass": "1053.5613",
                                "monoisotopic_mz": "1054.5686",
                                "intensity": "884.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "41",
                                "monoisotopic_mass": "847.1208",
                                "monoisotopic_mz": "848.1281",
                                "intensity": "690.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "42",
                                "monoisotopic_mass": "1835.4218",
                                "monoisotopic_mz": "918.7182",
                                "intensity": "2455.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "43",
                                "monoisotopic_mass": "762.3462",
                                "monoisotopic_mz": "763.3535",
                                "intensity": "1305.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3371",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0091",
                                        "ppm": "12.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "17",
                                "peak_id": "44",
                                "monoisotopic_mass": "4345.3146",
                                "monoisotopic_mz": "870.0702",
                                "intensity": "2400.65",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "13",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9112.8207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "17",
                                        "peak_id": "43",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "77",
                                        "spec_id": "17",
                                        "peak_id": "33",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "24",
                                        "spec_id": "17",
                                        "peak_id": "0",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "spec_id": "17",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "64",
                                        "ion_display_position": "21",
                                        "spec_id": "17",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "8",
                            "right_position": "61",
                            "anno": "-0.9166",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
