prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "9",
        "sequence_name": "sp|P0ACF8|HNS_ECOLI",
        "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
        "proteoform_id": "12",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "130",
                "p_value": "6.99e-07",
                "e_value": "6.99e-07",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "114",
                        "ms1_scans": "295",
                        "ids": "181",
                        "scans": "297",
                        "precursor_mono_mass": "5453.7626",
                        "precursor_charge": "9",
                        "precursor_mz": "606.9809",
                        "feature_inte": "1.3892e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "181",
                                "peak_id": "0",
                                "monoisotopic_mass": "4806.3781",
                                "monoisotopic_mz": "802.0703",
                                "intensity": "7029.50",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "1",
                                "monoisotopic_mass": "606.3121",
                                "monoisotopic_mz": "607.3194",
                                "intensity": "5906.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "2",
                                "monoisotopic_mass": "1291.7137",
                                "monoisotopic_mz": "431.5785",
                                "intensity": "4530.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "3",
                                "monoisotopic_mass": "4787.3693",
                                "monoisotopic_mz": "684.9172",
                                "intensity": "4500.44",
                                "charge": "7"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "4",
                                "monoisotopic_mass": "387.2476",
                                "monoisotopic_mz": "388.2549",
                                "intensity": "4536.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0006",
                                        "ppm": "-1.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "5",
                                "monoisotopic_mass": "500.3317",
                                "monoisotopic_mz": "501.3390",
                                "intensity": "3180.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "500.3323",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0006",
                                        "ppm": "-1.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "6",
                                "monoisotopic_mass": "2345.6704",
                                "monoisotopic_mz": "782.8974",
                                "intensity": "1904.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "7",
                                "monoisotopic_mass": "4063.0255",
                                "monoisotopic_mz": "813.6124",
                                "intensity": "744.64",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0079",
                                        "ppm": "-1.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "8",
                                "monoisotopic_mass": "1220.6406",
                                "monoisotopic_mz": "611.3276",
                                "intensity": "1405.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "9",
                                "monoisotopic_mass": "684.9093",
                                "monoisotopic_mz": "685.9166",
                                "intensity": "652.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "10",
                                "monoisotopic_mass": "1434.7370",
                                "monoisotopic_mz": "718.3758",
                                "intensity": "2621.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0002",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "11",
                                "monoisotopic_mass": "4808.3535",
                                "monoisotopic_mz": "687.9149",
                                "intensity": "2533.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "12",
                                "monoisotopic_mass": "1482.4116",
                                "monoisotopic_mz": "742.2131",
                                "intensity": "531.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "13",
                                "monoisotopic_mass": "849.6241",
                                "monoisotopic_mz": "850.6313",
                                "intensity": "1204.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "14",
                                "monoisotopic_mass": "3883.5832",
                                "monoisotopic_mz": "777.7239",
                                "intensity": "751.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "15",
                                "monoisotopic_mass": "2002.7525",
                                "monoisotopic_mz": "668.5914",
                                "intensity": "1328.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "16",
                                "monoisotopic_mass": "717.3499",
                                "monoisotopic_mz": "718.3572",
                                "intensity": "716.26",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "181",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "181",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "181",
                                        "peak_id": "7",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "181",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "spec_id": "181",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "spec_id": "181",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "72",
                "p_value": "6.38e-06",
                "e_value": "6.38e-06",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "86",
                        "ms1_scans": "184",
                        "ids": "100",
                        "scans": "188",
                        "precursor_mono_mass": "5453.7686",
                        "precursor_charge": "9",
                        "precursor_mz": "606.9816",
                        "feature_inte": "1.3892e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "100",
                                "peak_id": "0",
                                "monoisotopic_mass": "606.3121",
                                "monoisotopic_mz": "607.3193",
                                "intensity": "6529.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "1",
                                "monoisotopic_mass": "1291.7140",
                                "monoisotopic_mz": "431.5786",
                                "intensity": "3255.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "2",
                                "monoisotopic_mass": "387.2475",
                                "monoisotopic_mz": "388.2548",
                                "intensity": "2199.27",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0007",
                                        "ppm": "-1.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "3",
                                "monoisotopic_mass": "500.3318",
                                "monoisotopic_mz": "501.3391",
                                "intensity": "2217.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "500.3323",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "4",
                                "monoisotopic_mass": "1434.7352",
                                "monoisotopic_mz": "718.3749",
                                "intensity": "1835.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "5",
                                "monoisotopic_mass": "1563.7835",
                                "monoisotopic_mz": "782.8990",
                                "intensity": "2175.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0042",
                                        "ppm": "2.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "6",
                                "monoisotopic_mass": "4807.3884",
                                "monoisotopic_mz": "687.7770",
                                "intensity": "1014.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "7",
                                "monoisotopic_mass": "2345.6748",
                                "monoisotopic_mz": "782.8989",
                                "intensity": "972.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "8",
                                "monoisotopic_mass": "2403.1810",
                                "monoisotopic_mz": "802.0676",
                                "intensity": "2170.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "9",
                                "monoisotopic_mass": "4890.4120",
                                "monoisotopic_mz": "699.6376",
                                "intensity": "603.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "10",
                                "monoisotopic_mass": "3933.9951",
                                "monoisotopic_mz": "656.6731",
                                "intensity": "900.19",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0043",
                                        "ppm": "1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "11",
                                "monoisotopic_mass": "1434.7348",
                                "monoisotopic_mz": "479.2522",
                                "intensity": "1065.04",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0020",
                                        "ppm": "-1.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "12",
                                "monoisotopic_mass": "1191.7417",
                                "monoisotopic_mz": "596.8781",
                                "intensity": "990.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "13",
                                "monoisotopic_mass": "1355.0177",
                                "monoisotopic_mz": "678.5161",
                                "intensity": "454.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "14",
                                "monoisotopic_mass": "1209.7516",
                                "monoisotopic_mz": "605.8831",
                                "intensity": "1451.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "15",
                                "monoisotopic_mass": "1818.6712",
                                "monoisotopic_mz": "607.2310",
                                "intensity": "1354.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "16",
                                "monoisotopic_mass": "748.8729",
                                "monoisotopic_mz": "749.8802",
                                "intensity": "553.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "17",
                                "monoisotopic_mass": "1310.9998",
                                "monoisotopic_mz": "656.5072",
                                "intensity": "462.74",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "100",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "100",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "100",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "100",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "spec_id": "100",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "spec_id": "100",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "101",
                "p_value": "1.99e-04",
                "e_value": "1.99e-04",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "100",
                        "ms1_scans": "239",
                        "ids": "139",
                        "scans": "241",
                        "precursor_mono_mass": "5452.7639",
                        "precursor_charge": "9",
                        "precursor_mz": "606.8699",
                        "feature_inte": "1.3892e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "139",
                                "peak_id": "0",
                                "monoisotopic_mass": "606.3126",
                                "monoisotopic_mz": "607.3199",
                                "intensity": "6105.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "1",
                                "monoisotopic_mass": "1291.7146",
                                "monoisotopic_mz": "431.5788",
                                "intensity": "4978.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "2",
                                "monoisotopic_mass": "500.3318",
                                "monoisotopic_mz": "501.3391",
                                "intensity": "2647.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "500.3323",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "3",
                                "monoisotopic_mass": "4789.3573",
                                "monoisotopic_mz": "685.2012",
                                "intensity": "4251.37",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "4",
                                "monoisotopic_mass": "1434.7370",
                                "monoisotopic_mz": "718.3758",
                                "intensity": "2072.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0002",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "5",
                                "monoisotopic_mass": "3127.5476",
                                "monoisotopic_mz": "782.8942",
                                "intensity": "3639.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "6",
                                "monoisotopic_mass": "387.2478",
                                "monoisotopic_mz": "388.2550",
                                "intensity": "4127.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0004",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "7",
                                "monoisotopic_mass": "2345.6680",
                                "monoisotopic_mz": "782.8966",
                                "intensity": "2200.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "8",
                                "monoisotopic_mass": "1602.4590",
                                "monoisotopic_mz": "802.2368",
                                "intensity": "2262.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "9",
                                "monoisotopic_mass": "4191.0994",
                                "monoisotopic_mz": "839.2271",
                                "intensity": "1573.44",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0074",
                                        "ppm": "1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "10",
                                "monoisotopic_mass": "478.2455",
                                "monoisotopic_mz": "479.2527",
                                "intensity": "848.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "11",
                                "monoisotopic_mass": "1192.6462",
                                "monoisotopic_mz": "398.5560",
                                "intensity": "1596.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "12",
                                "monoisotopic_mass": "2454.7271",
                                "monoisotopic_mz": "614.6891",
                                "intensity": "595.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "13",
                                "monoisotopic_mass": "3591.2232",
                                "monoisotopic_mz": "599.5445",
                                "intensity": "680.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "14",
                                "monoisotopic_mass": "4936.4349",
                                "monoisotopic_mz": "706.2123",
                                "intensity": "803.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "15",
                                "monoisotopic_mass": "1201.0729",
                                "monoisotopic_mz": "601.5437",
                                "intensity": "543.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "16",
                                "monoisotopic_mass": "1319.7081",
                                "monoisotopic_mz": "660.8613",
                                "intensity": "601.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "17",
                                "monoisotopic_mass": "4790.3765",
                                "monoisotopic_mz": "799.4034",
                                "intensity": "940.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "18",
                                "monoisotopic_mass": "1397.2608",
                                "monoisotopic_mz": "699.6377",
                                "intensity": "504.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "19",
                                "monoisotopic_mass": "1227.3641",
                                "monoisotopic_mz": "614.6893",
                                "intensity": "884.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "20",
                                "monoisotopic_mass": "888.4432",
                                "monoisotopic_mz": "889.4504",
                                "intensity": "540.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "21",
                                "monoisotopic_mass": "3567.1857",
                                "monoisotopic_mz": "714.4444",
                                "intensity": "664.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "22",
                                "monoisotopic_mass": "1291.7138",
                                "monoisotopic_mz": "646.8642",
                                "intensity": "532.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "23",
                                "monoisotopic_mass": "1305.3056",
                                "monoisotopic_mz": "653.6601",
                                "intensity": "444.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "24",
                                "monoisotopic_mass": "1482.7433",
                                "monoisotopic_mz": "742.3789",
                                "intensity": "394.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "25",
                                "monoisotopic_mass": "1353.5412",
                                "monoisotopic_mz": "677.7779",
                                "intensity": "547.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "26",
                                "monoisotopic_mass": "807.4033",
                                "monoisotopic_mz": "808.4106",
                                "intensity": "811.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "27",
                                "monoisotopic_mass": "1113.4451",
                                "monoisotopic_mz": "557.7298",
                                "intensity": "633.18",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "139",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "139",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "139",
                                        "peak_id": "9",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "4",
                                        "spec_id": "139",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "spec_id": "139",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
