prsm_data =
{
    "protein": {
        "sequence_id": "5",
        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "5",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_id": "7",
            "prsm_number": "19",
            "prsm": [
                {
                    "prsm_id": "176",
                    "p_value": "3.01e-10",
                    "e_value": "3.01e-10",
                    "fdr": "0",
                    "matched_fragment_number": "19",
                    "matched_peak_number": "21",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "134",
                            "ms1_scans": "388",
                            "ids": "254",
                            "scans": "390",
                            "precursor_mono_mass": "9173.4138",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2755",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "254",
                                            "peak_id": "77",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "254",
                                            "peak_id": "35",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "254",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "254",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "15",
                                                "ion_display_position": "64",
                                                "spec_id": "254",
                                                "peak_id": "16",
                                                "peak_charge": "6"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "254",
                                            "peak_id": "55",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "254",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "254",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "254",
                                            "peak_id": "15",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "42",
                                            "ion_display_position": "42",
                                            "spec_id": "254",
                                            "peak_id": "31",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "254",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "254",
                                            "peak_id": "24",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "254",
                                            "peak_id": "70",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "69",
                                            "ion_display_position": "69",
                                            "spec_id": "254",
                                            "peak_id": "47",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "254",
                                            "peak_id": "40",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "254",
                                            "peak_id": "33",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "75",
                                                "ion_display_position": "75",
                                                "spec_id": "254",
                                                "peak_id": "63",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "75",
                                                "ion_display_position": "75",
                                                "spec_id": "254",
                                                "peak_id": "66",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "254",
                                                "peak_id": "0",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "254",
                                                "peak_id": "1",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "254",
                                            "peak_id": "5",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "116",
                    "p_value": "2.45e-09",
                    "e_value": "2.45e-09",
                    "fdr": "0",
                    "matched_fragment_number": "20",
                    "matched_peak_number": "22",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "108",
                            "ms1_scans": "270",
                            "ids": "162",
                            "scans": "272",
                            "precursor_mono_mass": "9173.4067",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2747",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "162",
                                            "peak_id": "79",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "162",
                                            "peak_id": "65",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "162",
                                                "peak_id": "42",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "162",
                                                "peak_id": "70",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "spec_id": "162",
                                            "peak_id": "23",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "162",
                                            "peak_id": "95",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "162",
                                            "peak_id": "60",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "162",
                                            "peak_id": "41",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "162",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "162",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "162",
                                            "peak_id": "27",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "162",
                                                "peak_id": "63",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "162",
                                                "peak_id": "28",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "162",
                                            "peak_id": "12",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "162",
                                            "peak_id": "29",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "spec_id": "162",
                                            "peak_id": "23",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "68",
                                            "ion_display_position": "68",
                                            "spec_id": "162",
                                            "peak_id": "22",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "69",
                                            "ion_display_position": "69",
                                            "spec_id": "162",
                                            "peak_id": "40",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "71",
                                            "ion_display_position": "71",
                                            "spec_id": "162",
                                            "peak_id": "91",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "162",
                                            "peak_id": "36",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "162",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "162",
                                                "peak_id": "1",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "162",
                                            "peak_id": "7",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "136",
                    "p_value": "1.36e-08",
                    "e_value": "1.36e-08",
                    "fdr": "0",
                    "matched_fragment_number": "17",
                    "matched_peak_number": "19",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "117",
                            "ms1_scans": "310",
                            "ids": "193",
                            "scans": "312",
                            "precursor_mono_mass": "9172.4050",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.5579",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "193",
                                                "peak_id": "67",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "193",
                                                "peak_id": "86",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "193",
                                            "peak_id": "30",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "193",
                                            "peak_id": "28",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "193",
                                            "peak_id": "36",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "193",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "193",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "39",
                                                "ion_display_position": "39",
                                                "spec_id": "193",
                                                "peak_id": "6",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "40",
                                                "spec_id": "193",
                                                "peak_id": "16",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "193",
                                                "peak_id": "74",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "193",
                                                "peak_id": "43",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "193",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "193",
                                            "peak_id": "68",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "193",
                                            "peak_id": "24",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "68",
                                            "ion_display_position": "68",
                                            "spec_id": "193",
                                            "peak_id": "61",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "193",
                                            "peak_id": "7",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "193",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "193",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "78",
                                            "ion_display_position": "78",
                                            "spec_id": "193",
                                            "peak_id": "20",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "60",
                    "p_value": "1.37e-08",
                    "e_value": "1.37e-08",
                    "fdr": "0",
                    "matched_fragment_number": "24",
                    "matched_peak_number": "22",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "81",
                            "ms1_scans": "161",
                            "ids": "81",
                            "scans": "164",
                            "precursor_mono_mass": "9173.4012",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2741",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4312",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "25",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "79",
                                            "spec_id": "81",
                                            "peak_id": "1",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "5",
                                            "ion_display_position": "78",
                                            "spec_id": "81",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "6",
                                            "ion_display_position": "77",
                                            "spec_id": "81",
                                            "peak_id": "64",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "76",
                                            "spec_id": "81",
                                            "peak_id": "41",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "81",
                                            "peak_id": "92",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "81",
                                            "peak_id": "40",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "81",
                                            "peak_id": "46",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "66",
                                            "spec_id": "81",
                                            "peak_id": "21",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "81",
                                            "peak_id": "91",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "19",
                                                "ion_display_position": "19",
                                                "spec_id": "81",
                                                "peak_id": "63",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "19",
                                                "ion_display_position": "64",
                                                "spec_id": "81",
                                                "peak_id": "27",
                                                "peak_charge": "6"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "20",
                                            "ion_display_position": "63",
                                            "spec_id": "81",
                                            "peak_id": "24",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "81",
                                            "peak_id": "112",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "38",
                                            "ion_display_position": "38",
                                            "spec_id": "81",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "81",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "81",
                                            "peak_id": "19",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "46",
                                            "ion_display_position": "46",
                                            "spec_id": "81",
                                            "peak_id": "45",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "81",
                                            "peak_id": "17",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "53",
                                            "ion_display_position": "53",
                                            "spec_id": "81",
                                            "peak_id": "47",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "54",
                                            "ion_display_position": "29",
                                            "spec_id": "81",
                                            "peak_id": "16",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "70",
                                            "ion_display_position": "70",
                                            "spec_id": "81",
                                            "peak_id": "21",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "81",
                                            "peak_id": "41",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "80",
                                                "ion_display_position": "80",
                                                "spec_id": "81",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "80",
                                                "ion_display_position": "80",
                                                "spec_id": "81",
                                                "peak_id": "1",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "81",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "32",
                                "right_position": "37",
                                "anno": "-342.1926",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "108",
                    "p_value": "1.56e-08",
                    "e_value": "1.56e-08",
                    "fdr": "0",
                    "matched_fragment_number": "16",
                    "matched_peak_number": "15",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "103",
                            "ms1_scans": "254",
                            "ids": "151",
                            "scans": "256",
                            "precursor_mono_mass": "9174.4099",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.8085",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "spec_id": "151",
                                            "peak_id": "63",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "151",
                                            "peak_id": "36",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "151",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "151",
                                            "peak_id": "15",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "151",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "151",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "151",
                                            "peak_id": "10",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "151",
                                            "peak_id": "31",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "151",
                                            "peak_id": "25",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "151",
                                            "peak_id": "55",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "spec_id": "151",
                                            "peak_id": "63",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "151",
                                            "peak_id": "26",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "151",
                                            "peak_id": "18",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "74",
                                            "ion_display_position": "74",
                                            "spec_id": "151",
                                            "peak_id": "34",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "151",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "151",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "148",
                    "p_value": "1.70e-08",
                    "e_value": "1.70e-08",
                    "fdr": "0",
                    "matched_fragment_number": "20",
                    "matched_peak_number": "21",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "121",
                            "ms1_scans": "331",
                            "ids": "210",
                            "scans": "333",
                            "precursor_mono_mass": "9173.4111",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2752",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "210",
                                            "peak_id": "49",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "210",
                                            "peak_id": "41",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "210",
                                            "peak_id": "70",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "210",
                                                "peak_id": "42",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "15",
                                                "ion_display_position": "64",
                                                "spec_id": "210",
                                                "peak_id": "6",
                                                "peak_charge": "6"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "16",
                                            "ion_display_position": "63",
                                            "spec_id": "210",
                                            "peak_id": "25",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "62",
                                            "spec_id": "210",
                                            "peak_id": "32",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "210",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "210",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "210",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "210",
                                            "peak_id": "18",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "210",
                                            "peak_id": "30",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "210",
                                            "peak_id": "22",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "210",
                                            "peak_id": "26",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "69",
                                            "ion_display_position": "69",
                                            "spec_id": "210",
                                            "peak_id": "51",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "210",
                                            "peak_id": "20",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "210",
                                            "peak_id": "27",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "210",
                                            "peak_id": "31",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "210",
                                                "peak_id": "1",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "210",
                                                "peak_id": "0",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "210",
                                            "peak_id": "13",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "88",
                    "p_value": "4.50e-08",
                    "e_value": "4.50e-08",
                    "fdr": "0",
                    "matched_fragment_number": "18",
                    "matched_peak_number": "19",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "94",
                            "ms1_scans": "217",
                            "ids": "123",
                            "scans": "219",
                            "precursor_mono_mass": "9173.4023",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2742",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "123",
                                            "peak_id": "79",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "123",
                                            "peak_id": "33",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "123",
                                            "peak_id": "70",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "123",
                                            "peak_id": "38",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "123",
                                                "peak_id": "49",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "15",
                                                "ion_display_position": "64",
                                                "spec_id": "123",
                                                "peak_id": "22",
                                                "peak_charge": "6"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "123",
                                            "peak_id": "31",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "123",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "123",
                                            "peak_id": "14",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "123",
                                            "peak_id": "64",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "123",
                                            "peak_id": "40",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "123",
                                            "peak_id": "37",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "123",
                                            "peak_id": "19",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "123",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "51",
                                            "ion_display_position": "28",
                                            "spec_id": "123",
                                            "peak_id": "45",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "123",
                                            "peak_id": "9",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "123",
                                                "peak_id": "1",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "123",
                                                "peak_id": "0",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "123",
                                            "peak_id": "4",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "166",
                    "p_value": "1.12e-07",
                    "e_value": "1.12e-07",
                    "fdr": "0",
                    "matched_fragment_number": "12",
                    "matched_peak_number": "12",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "130",
                            "ms1_scans": "369",
                            "ids": "238",
                            "scans": "370",
                            "precursor_mono_mass": "9173.4079",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.6833",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "spec_id": "238",
                                            "peak_id": "34",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "238",
                                            "peak_id": "51",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "238",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "238",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "238",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "39",
                                                "ion_display_position": "39",
                                                "spec_id": "238",
                                                "peak_id": "15",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "40",
                                                "spec_id": "238",
                                                "peak_id": "19",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "238",
                                            "peak_id": "20",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "238",
                                            "peak_id": "18",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "spec_id": "238",
                                            "peak_id": "34",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "238",
                                                "peak_id": "5",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "238",
                                                "peak_id": "3",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "238",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "29",
                    "p_value": "2.54e-06",
                    "e_value": "2.54e-06",
                    "fdr": "0",
                    "matched_fragment_number": "15",
                    "matched_peak_number": "16",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "68",
                            "ms1_scans": "106",
                            "ids": "37",
                            "scans": "107",
                            "precursor_mono_mass": "9173.3946",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2733",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "37",
                                            "peak_id": "73",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "37",
                                            "peak_id": "45",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "37",
                                            "peak_id": "30",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "spec_id": "37",
                                            "peak_id": "24",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "37",
                                            "peak_id": "81",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "37",
                                            "peak_id": "53",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "37",
                                            "peak_id": "35",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "37",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "37",
                                                "peak_id": "71",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "37",
                                                "peak_id": "16",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "37",
                                            "peak_id": "17",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "37",
                                            "peak_id": "37",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "spec_id": "37",
                                            "peak_id": "24",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "69",
                                            "ion_display_position": "69",
                                            "spec_id": "37",
                                            "peak_id": "50",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "37",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "37",
                                                "peak_id": "1",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "37",
                                            "peak_id": "7",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "48",
                    "p_value": "3.49e-06",
                    "e_value": "3.49e-06",
                    "fdr": "0",
                    "matched_fragment_number": "11",
                    "matched_peak_number": "12",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "76",
                            "ms1_scans": "138",
                            "ids": "62",
                            "scans": "140",
                            "precursor_mono_mass": "9173.3981",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.6820",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "62",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "62",
                                            "spec_id": "62",
                                            "peak_id": "10",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "62",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "62",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "62",
                                            "peak_id": "8",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "62",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "70",
                                            "ion_display_position": "70",
                                            "spec_id": "62",
                                            "peak_id": "19",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "62",
                                            "peak_id": "11",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "62",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "62",
                                                "peak_id": "14",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "62",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "78",
                                            "ion_display_position": "78",
                                            "spec_id": "62",
                                            "peak_id": "36",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "77",
                    "p_value": "5.62e-06",
                    "e_value": "5.62e-06",
                    "fdr": "0",
                    "matched_fragment_number": "13",
                    "matched_peak_number": "15",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "89",
                            "ms1_scans": "197",
                            "ids": "107",
                            "scans": "198",
                            "precursor_mono_mass": "9173.4147",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.6841",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "107",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "107",
                                            "peak_id": "82",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "107",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "107",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "107",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "107",
                                            "peak_id": "75",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "107",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "70",
                                            "ion_display_position": "70",
                                            "spec_id": "107",
                                            "peak_id": "32",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "107",
                                            "peak_id": "19",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "107",
                                            "peak_id": "8",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "107",
                                                "peak_id": "16",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "107",
                                                "peak_id": "2",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "107",
                                                "peak_id": "12",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "107",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "78",
                                            "ion_display_position": "78",
                                            "spec_id": "107",
                                            "peak_id": "60",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "19",
                    "p_value": "3.77e-05",
                    "e_value": "3.77e-05",
                    "fdr": "0",
                    "matched_fragment_number": "9",
                    "matched_peak_number": "11",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "62",
                            "ms1_scans": "83",
                            "ids": "23",
                            "scans": "87",
                            "precursor_mono_mass": "9173.3825",
                            "precursor_charge": "8",
                            "precursor_mz": "1147.6801",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "76",
                                            "spec_id": "23",
                                            "peak_id": "37",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "23",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "23",
                                            "peak_id": "7",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "23",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "23",
                                            "peak_id": "9",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "23",
                                            "peak_id": "18",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "23",
                                            "peak_id": "22",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "23",
                                                "peak_id": "11",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "23",
                                                "peak_id": "3",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "23",
                                                "peak_id": "24",
                                                "peak_charge": "8"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "77",
                                                "ion_display_position": "77",
                                                "spec_id": "23",
                                                "peak_id": "0",
                                                "peak_charge": "7"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "8",
                    "p_value": "1.46e-04",
                    "e_value": "1.46e-04",
                    "fdr": "0",
                    "matched_fragment_number": "10",
                    "matched_peak_number": "11",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "53",
                            "ms1_scans": "63",
                            "ids": "9",
                            "scans": "64",
                            "precursor_mono_mass": "9173.4050",
                            "precursor_charge": "9",
                            "precursor_mz": "1020.2745",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "9",
                                            "peak_id": "35",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "9",
                                            "peak_id": "46",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "9",
                                            "peak_id": "58",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "64",
                                            "spec_id": "9",
                                            "peak_id": "13",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "9",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "9",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "spec_id": "9",
                                            "peak_id": "43",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "9",
                                            "peak_id": "16",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "68",
                                            "ion_display_position": "68",
                                            "spec_id": "9",
                                            "peak_id": "20",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "9",
                                                "peak_id": "1",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "76",
                                                "ion_display_position": "76",
                                                "spec_id": "9",
                                                "peak_id": "0",
                                                "peak_charge": "8"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "59",
                    "p_value": "5.74e-04",
                    "e_value": "5.75e-04",
                    "fdr": "0",
                    "matched_fragment_number": "9",
                    "matched_peak_number": "11",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "81",
                            "ms1_scans": "161",
                            "ids": "80",
                            "scans": "163",
                            "precursor_mono_mass": "9173.4057",
                            "precursor_charge": "10",
                            "precursor_mz": "918.3478",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "80",
                                            "peak_id": "17",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "80",
                                            "peak_id": "13",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "80",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "65",
                                            "spec_id": "80",
                                            "peak_id": "50",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "16",
                                                "ion_display_position": "63",
                                                "spec_id": "80",
                                                "peak_id": "8",
                                                "peak_charge": "7"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "16",
                                                "ion_display_position": "63",
                                                "spec_id": "80",
                                                "peak_id": "7",
                                                "peak_charge": "6"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "80",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "80",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "50",
                                                "ion_display_position": "29",
                                                "spec_id": "80",
                                                "peak_id": "20",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "50",
                                                "ion_display_position": "29",
                                                "spec_id": "80",
                                                "peak_id": "23",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "80",
                                            "peak_id": "4",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "150",
                    "p_value": "3.73e-03",
                    "e_value": "3.74e-03",
                    "fdr": "0",
                    "matched_fragment_number": "10",
                    "matched_peak_number": "11",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "122",
                            "ms1_scans": "336",
                            "ids": "213",
                            "scans": "337",
                            "precursor_mono_mass": "9173.4112",
                            "precursor_charge": "10",
                            "precursor_mz": "918.3484",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4312",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "25",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "76",
                                            "spec_id": "213",
                                            "peak_id": "27",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "18",
                                            "ion_display_position": "65",
                                            "spec_id": "213",
                                            "peak_id": "41",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "19",
                                            "ion_display_position": "64",
                                            "spec_id": "213",
                                            "peak_id": "15",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "26",
                                            "ion_display_position": "57",
                                            "spec_id": "213",
                                            "peak_id": "31",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "36",
                                            "spec_id": "213",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "49",
                                            "ion_display_position": "34",
                                            "spec_id": "213",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "51",
                                            "ion_display_position": "32",
                                            "spec_id": "213",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "54",
                                                "ion_display_position": "29",
                                                "spec_id": "213",
                                                "peak_id": "12",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "54",
                                                "ion_display_position": "29",
                                                "spec_id": "213",
                                                "peak_id": "10",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "55",
                                                "ion_display_position": "28",
                                                "spec_id": "213",
                                                "peak_id": "17",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "55",
                                                "ion_display_position": "28",
                                                "spec_id": "213",
                                                "peak_id": "5",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "spec_id": "213",
                                            "peak_id": "27",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "80",
                                "right_position": "102",
                                "anno": "-342.1926",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "89",
                    "p_value": "0.04",
                    "e_value": "0.04",
                    "fdr": "4.41e-03",
                    "matched_fragment_number": "9",
                    "matched_peak_number": "9",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "95",
                            "ms1_scans": "220",
                            "ids": "124",
                            "scans": "221",
                            "precursor_mono_mass": "9173.4087",
                            "precursor_charge": "10",
                            "precursor_mz": "918.3481",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "124",
                                            "peak_id": "76",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "124",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "124",
                                            "peak_id": "29",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "124",
                                            "peak_id": "93",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "124",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "124",
                                            "peak_id": "32",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "29",
                                            "spec_id": "124",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "124",
                                            "peak_id": "30",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "124",
                                            "peak_id": "9",
                                            "peak_charge": "8"
                                        }
                                    }
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "178",
                    "p_value": "0.08",
                    "e_value": "0.08",
                    "fdr": "4.37e-03",
                    "matched_fragment_number": "6",
                    "matched_peak_number": "6",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "135",
                            "ms1_scans": "393",
                            "ids": "257",
                            "scans": "394",
                            "precursor_mono_mass": "9173.4197",
                            "precursor_charge": "10",
                            "precursor_mz": "918.3492",
                            "feature_inte": "3.1002e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "5",
                        "proteoform_id": "7",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9173.4334",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                       