prsm_data =
{
    "protein": {
        "sequence_id": "11",
        "sequence_name": "sp|P0AAV6|YBGS_ECOLI",
        "sequence_description": "Uncharacterized protein YbgS OS=Escherichia coli (strain K12) OX=83333 GN=ybgS PE=3 SV=1",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "11",
            "sequence_name": "sp|P0AAV6|YBGS_ECOLI",
            "sequence_description": "Uncharacterized protein YbgS OS=Escherichia coli (strain K12) OX=83333 GN=ybgS PE=3 SV=1",
            "proteoform_id": "14",
            "prsm_number": "2",
            "prsm": [
                {
                    "prsm_id": "146",
                    "p_value": "2.55e-05",
                    "e_value": "2.55e-05",
                    "fdr": "0",
                    "matched_fragment_number": "6",
                    "matched_peak_number": "6",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "120",
                            "ms1_scans": "327",
                            "ids": "207",
                            "scans": "329",
                            "precursor_mono_mass": "10573.6241",
                            "precursor_charge": "9",
                            "precursor_mz": "1175.8544",
                            "feature_inte": "5.7215e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "14",
                        "sequence_name": "sp|P0AAV6|YBGS_ECOLI",
                        "sequence_description": "Uncharacterized protein YbgS OS=Escherichia coli (strain K12) OX=83333 GN=ybgS PE=3 SV=1",
                        "proteoform_mass": "10572.6465",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "126",
                            "first_residue_position": "24",
                            "last_residue_position": "125",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "K"
                                },
                                {
                                    "position": "2",
                                    "acid": "M"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "A"
                                },
                                {
                                    "position": "7",
                                    "acid": "T"
                                },
                                {
                                    "position": "8",
                                    "acid": "L"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "L"
                                },
                                {
                                    "position": "11",
                                    "acid": "T"
                                },
                                {
                                    "position": "12",
                                    "acid": "A"
                                },
                                {
                                    "position": "13",
                                    "acid": "T"
                                },
                                {
                                    "position": "14",
                                    "acid": "L"
                                },
                                {
                                    "position": "15",
                                    "acid": "S"
                                },
                                {
                                    "position": "16",
                                    "acid": "L"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "S"
                                },
                                {
                                    "position": "19",
                                    "acid": "G"
                                },
                                {
                                    "position": "20",
                                    "acid": "A"
                                },
                                {
                                    "position": "21",
                                    "acid": "A"
                                },
                                {
                                    "position": "22",
                                    "acid": "L"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "A"
                                },
                                {
                                    "position": "25",
                                    "acid": "D"
                                },
                                {
                                    "position": "26",
                                    "acid": "S"
                                },
                                {
                                    "position": "27",
                                    "acid": "G"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "Q"
                                },
                                {
                                    "position": "30",
                                    "acid": "T"
                                },
                                {
                                    "position": "31",
                                    "acid": "N"
                                },
                                {
                                    "position": "32",
                                    "acid": "N"
                                },
                                {
                                    "position": "33",
                                    "acid": "G"
                                },
                                {
                                    "position": "34",
                                    "acid": "Q"
                                },
                                {
                                    "position": "35",
                                    "acid": "A"
                                },
                                {
                                    "position": "36",
                                    "acid": "N"
                                },
                                {
                                    "position": "37",
                                    "acid": "A"
                                },
                                {
                                    "position": "38",
                                    "acid": "A"
                                },
                                {
                                    "position": "39",
                                    "acid": "A"
                                },
                                {
                                    "position": "40",
                                    "acid": "D"
                                },
                                {
                                    "position": "41",
                                    "acid": "A"
                                },
                                {
                                    "position": "42",
                                    "acid": "G"
                                },
                                {
                                    "position": "43",
                                    "acid": "Q"
                                },
                                {
                                    "position": "44",
                                    "acid": "V"
                                },
                                {
                                    "position": "45",
                                    "acid": "A"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "D"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "R"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "N"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "P"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "N"
                                },
                                {
                                    "position": "57",
                                    "acid": "V"
                                },
                                {
                                    "position": "58",
                                    "acid": "D"
                                },
                                {
                                    "position": "59",
                                    "acid": "N"
                                },
                                {
                                    "position": "60",
                                    "acid": "N"
                                },
                                {
                                    "position": "61",
                                    "acid": "G"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "N"
                                },
                                {
                                    "position": "64",
                                    "acid": "T"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "S"
                                },
                                {
                                    "position": "67",
                                    "acid": "G"
                                },
                                {
                                    "position": "68",
                                    "acid": "G"
                                },
                                {
                                    "position": "69",
                                    "acid": "T"
                                },
                                {
                                    "position": "70",
                                    "acid": "M"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "H"
                                },
                                {
                                    "position": "73",
                                    "acid": "S"
                                },
                                {
                                    "position": "74",
                                    "acid": "D"
                                },
                                {
                                    "position": "75",
                                    "acid": "G"
                                },
                                {
                                    "position": "76",
                                    "acid": "S"
                                },
                                {
                                    "position": "77",
                                    "acid": "S"
                                },
                                {
                                    "position": "78",
                                    "acid": "M"
                                },
                                {
                                    "position": "79",
                                    "acid": "N"
                                },
                                {
                                    "position": "80",
                                    "acid": "N"
                                },
                                {
                                    "position": "81",
                                    "acid": "D"
                                },
                                {
                                    "position": "82",
                                    "acid": "G"
                                },
                                {
                                    "position": "83",
                                    "acid": "M"
                                },
                                {
                                    "position": "84",
                                    "acid": "T"
                                },
                                {
                                    "position": "85",
                                    "acid": "K"
                                },
                                {
                                    "position": "86",
                                    "acid": "D"
                                },
                                {
                                    "position": "87",
                                    "acid": "E"
                                },
                                {
                                    "position": "88",
                                    "acid": "E"
                                },
                                {
                                    "position": "89",
                                    "acid": "H"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                },
                                {
                                    "position": "91",
                                    "acid": "N"
                                },
                                {
                                    "position": "92",
                                    "acid": "T"
                                },
                                {
                                    "position": "93",
                                    "acid": "M"
                                },
                                {
                                    "position": "94",
                                    "acid": "C"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "G"
                                },
                                {
                                    "position": "98",
                                    "acid": "R"
                                },
                                {
                                    "position": "99",
                                    "acid": "C"
                                },
                                {
                                    "position": "100",
                                    "acid": "P"
                                },
                                {
                                    "position": "101",
                                    "acid": "D"
                                },
                                {
                                    "position": "102",
                                    "acid": "I"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "K"
                                },
                                {
                                    "position": "106",
                                    "acid": "V"
                                },
                                {
                                    "position": "107",
                                    "acid": "Q"
                                },
                                {
                                    "position": "108",
                                    "acid": "T"
                                },
                                {
                                    "position": "109",
                                    "acid": "G"
                                },
                                {
                                    "position": "110",
                                    "acid": "D"
                                },
                                {
                                    "position": "111",
                                    "acid": "G"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "N"
                                },
                                {
                                    "position": "114",
                                    "acid": "N"
                                },
                                {
                                    "position": "115",
                                    "acid": "D"
                                },
                                {
                                    "position": "116",
                                    "acid": "V"
                                },
                                {
                                    "position": "117",
                                    "acid": "D"
                                },
                                {
                                    "position": "118",
                                    "acid": "T"
                                },
                                {
                                    "position": "119",
                                    "acid": "K"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "D"
                                },
                                {
                                    "position": "122",
                                    "acid": "G"
                                },
                                {
                                    "position": "123",
                                    "acid": "T"
                                },
                                {
                                    "position": "124",
                                    "acid": "T"
                                },
                                {
                                    "position": "125",
                                    "acid": "Q"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "21",
                                            "ion_display_position": "81",
                                            "spec_id": "207",
                                            "peak_id": "15",
                                            "peak_charge": "7"
                                        }
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "73",
                                            "spec_id": "207",
                                            "peak_id": "11",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "72",
                                            "spec_id": "207",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "68",
                                            "spec_id": "207",
                                            "peak_id": "16",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "63",
                                            "spec_id": "207",
                                            "peak_id": "7",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "93",
                                            "ion_display_position": "9",
                                            "spec_id": "207",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "94",
                                        "right_pos": "95",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "99",
                                        "right_pos": "100",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                },
                {
                    "prsm_id": "174",
                    "p_value": "2.80e-05",
                    "e_value": "2.80e-05",
                    "fdr": "0",
                    "matched_fragment_number": "5",
                    "matched_peak_number": "5",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "ecoli_2_ms2.msalign",
                            "ms1_ids": "133",
                            "ms1_scans": "384",
                            "ids": "251",
                            "scans": "386",
                            "precursor_mono_mass": "10573.6331",
                            "precursor_charge": "10",
                            "precursor_mz": "1058.3706",
                            "feature_inte": "5.7215e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "14",
                        "sequence_name": "sp|P0AAV6|YBGS_ECOLI",
                        "sequence_description": "Uncharacterized protein YbgS OS=Escherichia coli (strain K12) OX=83333 GN=ybgS PE=3 SV=1",
                        "proteoform_mass": "10572.6465",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "126",
                            "first_residue_position": "24",
                            "last_residue_position": "125",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "K"
                                },
                                {
                                    "position": "2",
                                    "acid": "M"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "A"
                                },
                                {
                                    "position": "7",
                                    "acid": "T"
                                },
                                {
                                    "position": "8",
                                    "acid": "L"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "L"
                                },
                                {
                                    "position": "11",
                                    "acid": "T"
                                },
                                {
                                    "position": "12",
                                    "acid": "A"
                                },
                                {
                                    "position": "13",
                                    "acid": "T"
                                },
                                {
                                    "position": "14",
                                    "acid": "L"
                                },
                                {
                                    "position": "15",
                                    "acid": "S"
                                },
                                {
                                    "position": "16",
                                    "acid": "L"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "S"
                                },
                                {
                                    "position": "19",
                                    "acid": "G"
                                },
                                {
                                    "position": "20",
                                    "acid": "A"
                                },
                                {
                                    "position": "21",
                                    "acid": "A"
                                },
                                {
                                    "position": "22",
                                    "acid": "L"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "A"
                                },
                                {
                                    "position": "25",
                                    "acid": "D"
                                },
                                {
                                    "position": "26",
                                    "acid": "S"
                                },
                                {
                                    "position": "27",
                                    "acid": "G"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "Q"
                                },
                                {
                                    "position": "30",
                                    "acid": "T"
                                },
                                {
                                    "position": "31",
                                    "acid": "N"
                                },
                                {
                                    "position": "32",
                                    "acid": "N"
                                },
                                {
                                    "position": "33",
                                    "acid": "G"
                                },
                                {
                                    "position": "34",
                                    "acid": "Q"
                                },
                                {
                                    "position": "35",
                                    "acid": "A"
                                },
                                {
                                    "position": "36",
                                    "acid": "N"
                                },
                                {
                                    "position": "37",
                                    "acid": "A"
                                },
                                {
                                    "position": "38",
                                    "acid": "A"
                                },
                                {
                                    "position": "39",
                                    "acid": "A"
                                },
                                {
                                    "position": "40",
                                    "acid": "D"
                                },
                                {
                                    "position": "41",
                                    "acid": "A"
                                },
                                {
                                    "position": "42",
                                    "acid": "G"
                                },
                                {
                                    "position": "43",
                                    "acid": "Q"
                                },
                                {
                                    "position": "44",
                                    "acid": "V"
                                },
                                {
                                    "position": "45",
                                    "acid": "A"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "D"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "R"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "N"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "P"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "N"
                                },
                                {
                                    "position": "57",
                                    "acid": "V"
                                },
                                {
                                    "position": "58",
                                    "acid": "D"
                                },
                                {
                                    "position": "59",
                                    "acid": "N"
                                },
                                {
                                    "position": "60",
                                    "acid": "N"
                                },
                                {
                                    "position": "61",
                                    "acid": "G"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "N"
                                },
                                {
                                    "position": "64",
                                    "acid": "T"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "S"
                                },
                                {
                                    "position": "67",
                                    "acid": "G"
                                },
                                {
                                    "position": "68",
                                    "acid": "G"
                                },
                                {
                                    "position": "69",
                                    "acid": "T"
                                },
                                {
                                    "position": "70",
                                    "acid": "M"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "H"
                                },
                                {
                                    "position": "73",
                                    "acid": "S"
                                },
                                {
                                    "position": "74",
                                    "acid": "D"
                                },
                                {
                                    "position": "75",
                                    "acid": "G"
                                },
                                {
                                    "position": "76",
                                    "acid": "S"
                                },
                                {
                                    "position": "77",
                                    "acid": "S"
                                },
                                {
                                    "position": "78",
                                    "acid": "M"
                                },
                                {
                                    "position": "79",
                                    "acid": "N"
                                },
                                {
                                    "position": "80",
                                    "acid": "N"
                                },
                                {
                                    "position": "81",
                                    "acid": "D"
                                },
                                {
                                    "position": "82",
                                    "acid": "G"
                                },
                                {
                                    "position": "83",
                                    "acid": "M"
                                },
                                {
                                    "position": "84",
                                    "acid": "T"
                                },
                                {
                                    "position": "85",
                                    "acid": "K"
                                },
                                {
                                    "position": "86",
                                    "acid": "D"
                                },
                                {
                                    "position": "87",
                                    "acid": "E"
                                },
                                {
                                    "position": "88",
                                    "acid": "E"
                                },
                                {
                                    "position": "89",
                                    "acid": "H"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                },
                                {
                                    "position": "91",
                                    "acid": "N"
                                },
                                {
                                    "position": "92",
                                    "acid": "T"
                                },
                                {
                                    "position": "93",
                                    "acid": "M"
                                },
                                {
                                    "position": "94",
                                    "acid": "C"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "G"
                                },
                                {
                                    "position": "98",
                                    "acid": "R"
                                },
                                {
                                    "position": "99",
                                    "acid": "C"
                                },
                                {
                                    "position": "100",
                                    "acid": "P"
                                },
                                {
                                    "position": "101",
                                    "acid": "D"
                                },
                                {
                                    "position": "102",
                                    "acid": "I"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "K"
                                },
                                {
                                    "position": "106",
                                    "acid": "V"
                                },
                                {
                                    "position": "107",
                                    "acid": "Q"
                                },
                                {
                                    "position": "108",
                                    "acid": "T"
                                },
                                {
                                    "position": "109",
                                    "acid": "G"
                                },
                                {
                                    "position": "110",
                                    "acid": "D"
                                },
                                {
                                    "position": "111",
                                    "acid": "G"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "N"
                                },
                                {
                                    "position": "114",
                                    "acid": "N"
                                },
                                {
                                    "position": "115",
                                    "acid": "D"
                                },
                                {
                                    "position": "116",
                                    "acid": "V"
                                },
                                {
                                    "position": "117",
                                    "acid": "D"
                                },
                                {
                                    "position": "118",
                                    "acid": "T"
                                },
                                {
                                    "position": "119",
                                    "acid": "K"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "D"
                                },
                                {
                                    "position": "122",
                                    "acid": "G"
                                },
                                {
                                    "position": "123",
                                    "acid": "T"
                                },
                                {
                                    "position": "124",
                                    "acid": "T"
                                },
                                {
                                    "position": "125",
                                    "acid": "Q"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "251",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "63",
                                            "spec_id": "251",
                                            "peak_id": "6",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "92",
                                            "ion_display_position": "10",
                                            "spec_id": "251",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "93",
                                            "ion_display_position": "9",
                                            "spec_id": "251",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "94",
                                            "ion_display_position": "8",
                                            "spec_id": "251",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "94",
                                        "right_pos": "95",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "99",
                                        "right_pos": "100",
                                        "anno": "C"
                                    }
                                ]
                            }
                        }
                    }
                }
            ]
        }
    }
}
