prsm_data =
{
    "prsm": {
        "prsm_id": "91",
        "p_value": "6.59e-07",
        "e_value": "6.59e-07",
        "fdr": "0",
        "matched_fragment_number": "10",
        "matched_peak_number": "12",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_1_ms2.msalign",
                "ms1_ids": "351",
                "ms1_scans": "461",
                "ids": "109",
                "scans": "462",
                "precursor_mono_mass": "9528.1756",
                "precursor_charge": "12",
                "precursor_mz": "795.0219",
                "feature_inte": "3.5453e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "109",
                        "peak_id": "0",
                        "monoisotopic_mass": "4778.6200",
                        "monoisotopic_mz": "797.4439",
                        "intensity": "41934.33",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0009",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "1",
                        "monoisotopic_mass": "4878.6948",
                        "monoisotopic_mz": "814.1231",
                        "intensity": "12975.28",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "2",
                        "monoisotopic_mass": "5117.8297",
                        "monoisotopic_mz": "853.9789",
                        "intensity": "15959.48",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5118.8320",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "42",
                                "mass_error": "0.0001",
                                "ppm": "0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "3",
                        "monoisotopic_mass": "4990.7765",
                        "monoisotopic_mz": "832.8034",
                        "intensity": "14875.88",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4990.7734",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "ion_sort_name": "Y00047",
                                "ion_left_position": "43",
                                "mass_error": "0.0031",
                                "ppm": "0.62"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "4",
                        "monoisotopic_mass": "1429.8293",
                        "monoisotopic_mz": "715.9219",
                        "intensity": "12478.55",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0000",
                                "ppm": "-0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "5",
                        "monoisotopic_mass": "5100.8178",
                        "monoisotopic_mz": "729.6955",
                        "intensity": "11776.20",
                        "charge": "7"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "6",
                        "monoisotopic_mass": "4327.2828",
                        "monoisotopic_mz": "1082.8280",
                        "intensity": "4135.31",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "7",
                        "monoisotopic_mass": "1856.0521",
                        "monoisotopic_mz": "929.0334",
                        "intensity": "4053.46",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1856.0520",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "ion_sort_name": "Y00019",
                                "ion_left_position": "71",
                                "mass_error": "0.0001",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "8",
                        "monoisotopic_mass": "4760.6014",
                        "monoisotopic_mz": "794.4408",
                        "intensity": "8109.93",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "9",
                        "monoisotopic_mass": "4256.2456",
                        "monoisotopic_mz": "1065.0687",
                        "intensity": "7599.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "10",
                        "monoisotopic_mass": "3283.7706",
                        "monoisotopic_mz": "1095.5975",
                        "intensity": "3924.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "11",
                        "monoisotopic_mass": "3347.7834",
                        "monoisotopic_mz": "837.9531",
                        "intensity": "4645.11",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "12",
                        "monoisotopic_mass": "2921.5626",
                        "monoisotopic_mz": "731.3979",
                        "intensity": "3843.25",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "13",
                        "monoisotopic_mass": "2993.6021",
                        "monoisotopic_mz": "749.4078",
                        "intensity": "4643.54",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "14",
                        "monoisotopic_mass": "6333.4640",
                        "monoisotopic_mz": "905.7879",
                        "intensity": "4272.42",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6332.4510",
                                "ion_position": "30",
                                "ion_display_position": "60",
                                "ion_sort_name": "Y00060",
                                "ion_left_position": "30",
                                "mass_error": "0.0107",
                                "ppm": "1.69"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "15",
                        "monoisotopic_mass": "5102.8063",
                        "monoisotopic_mz": "851.4750",
                        "intensity": "4701.06",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "16",
                        "monoisotopic_mass": "1784.0135",
                        "monoisotopic_mz": "893.0141",
                        "intensity": "2227.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "17",
                        "monoisotopic_mass": "2210.3133",
                        "monoisotopic_mz": "737.7784",
                        "intensity": "3830.56",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2210.3151",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "ion_sort_name": "Y00022",
                                "ion_left_position": "68",
                                "mass_error": "-0.0018",
                                "ppm": "-0.80"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "18",
                        "monoisotopic_mass": "2429.8390",
                        "monoisotopic_mz": "810.9536",
                        "intensity": "4729.55",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "19",
                        "monoisotopic_mass": "4238.2319",
                        "monoisotopic_mz": "1060.5653",
                        "intensity": "4012.25",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "20",
                        "monoisotopic_mass": "783.4311",
                        "monoisotopic_mz": "784.4384",
                        "intensity": "2573.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "21",
                        "monoisotopic_mass": "4971.7537",
                        "monoisotopic_mz": "829.6329",
                        "intensity": "3105.00",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "22",
                        "monoisotopic_mass": "1642.9377",
                        "monoisotopic_mz": "822.4761",
                        "intensity": "1963.26",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1642.9407",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "ion_sort_name": "Y00016",
                                "ion_left_position": "74",
                                "mass_error": "-0.0030",
                                "ppm": "-1.80"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "23",
                        "monoisotopic_mass": "1429.8309",
                        "monoisotopic_mz": "1430.8381",
                        "intensity": "1854.23",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "0.0015",
                                "ppm": "1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "24",
                        "monoisotopic_mass": "2287.2669",
                        "monoisotopic_mz": "763.4296",
                        "intensity": "2178.80",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "25",
                        "monoisotopic_mass": "5616.9646",
                        "monoisotopic_mz": "703.1278",
                        "intensity": "1864.64",
                        "charge": "8"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "26",
                        "monoisotopic_mass": "1454.2777",
                        "monoisotopic_mz": "728.1461",
                        "intensity": "1619.81",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "27",
                        "monoisotopic_mass": "6028.2608",
                        "monoisotopic_mz": "862.1874",
                        "intensity": "1310.06",
                        "charge": "7"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "28",
                        "monoisotopic_mass": "2360.2974",
                        "monoisotopic_mz": "787.7731",
                        "intensity": "6217.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "29",
                        "monoisotopic_mass": "3447.8587",
                        "monoisotopic_mz": "862.9720",
                        "intensity": "3934.91",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "30",
                        "monoisotopic_mass": "3559.9285",
                        "monoisotopic_mz": "890.9894",
                        "intensity": "965.66",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "31",
                        "monoisotopic_mass": "951.2124",
                        "monoisotopic_mz": "952.2197",
                        "intensity": "1084.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "32",
                        "monoisotopic_mass": "4798.6401",
                        "monoisotopic_mz": "800.7806",
                        "intensity": "3069.76",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "33",
                        "monoisotopic_mass": "4321.3285",
                        "monoisotopic_mz": "865.2730",
                        "intensity": "1770.42",
                        "charge": "5"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "34",
                        "monoisotopic_mass": "3428.9653",
                        "monoisotopic_mz": "858.2486",
                        "intensity": "3364.60",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "35",
                        "monoisotopic_mass": "5906.8605",
                        "monoisotopic_mz": "844.8445",
                        "intensity": "1206.76",
                        "charge": "7"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "36",
                        "monoisotopic_mass": "9420.6665",
                        "monoisotopic_mz": "857.4315",
                        "intensity": "1153.64",
                        "charge": "11"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "37",
                        "monoisotopic_mass": "1624.8663",
                        "monoisotopic_mz": "813.4404",
                        "intensity": "2293.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "38",
                        "monoisotopic_mass": "819.2895",
                        "monoisotopic_mz": "820.2968",
                        "intensity": "1951.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "39",
                        "monoisotopic_mass": "3266.7604",
                        "monoisotopic_mz": "1089.9274",
                        "intensity": "1487.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "40",
                        "monoisotopic_mass": "6304.7597",
                        "monoisotopic_mz": "789.1022",
                        "intensity": "2277.31",
                        "charge": "8"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "41",
                        "monoisotopic_mass": "6046.2833",
                        "monoisotopic_mz": "864.7620",
                        "intensity": "955.43",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6047.2821",
                                "ion_position": "33",
                                "ion_display_position": "57",
                                "ion_sort_name": "Y00057",
                                "ion_left_position": "33",
                                "mass_error": "0.0035",
                                "ppm": "0.58"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "42",
                        "monoisotopic_mass": "5819.1074",
                        "monoisotopic_mz": "728.3957",
                        "intensity": "992.43",
                        "charge": "8"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "43",
                        "monoisotopic_mass": "832.6306",
                        "monoisotopic_mz": "833.6379",
                        "intensity": "875.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "44",
                        "monoisotopic_mass": "6259.3851",
                        "monoisotopic_mz": "895.2052",
                        "intensity": "2224.69",
                        "charge": "7"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "45",
                        "monoisotopic_mass": "8184.1887",
                        "monoisotopic_mz": "910.3616",
                        "intensity": "1651.11",
                        "charge": "9"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "46",
                        "monoisotopic_mass": "3196.7344",
                        "monoisotopic_mz": "800.1909",
                        "intensity": "2178.70",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3196.7377",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "-0.0034",
                                "ppm": "-1.05"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "47",
                        "monoisotopic_mass": "4648.3465",
                        "monoisotopic_mz": "930.6766",
                        "intensity": "1224.06",
                        "charge": "5"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "48",
                        "monoisotopic_mass": "4947.4237",
                        "monoisotopic_mz": "825.5779",
                        "intensity": "1834.83",
                        "charge": "6"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "49",
                        "monoisotopic_mass": "3265.7615",
                        "monoisotopic_mz": "817.4476",
                        "intensity": "2061.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "50",
                        "monoisotopic_mass": "879.4701",
                        "monoisotopic_mz": "880.4774",
                        "intensity": "1095.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "51",
                        "monoisotopic_mass": "8978.6612",
                        "monoisotopic_mz": "817.2492",
                        "intensity": "1052.16",
                        "charge": "11"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "52",
                        "monoisotopic_mass": "3930.5946",
                        "monoisotopic_mz": "787.1262",
                        "intensity": "1655.57",
                        "charge": "5"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "53",
                        "monoisotopic_mass": "2779.1081",
                        "monoisotopic_mz": "927.3766",
                        "intensity": "2029.00",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "54",
                        "monoisotopic_mass": "7857.4182",
                        "monoisotopic_mz": "874.0537",
                        "intensity": "2357.88",
                        "charge": "9"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "55",
                        "monoisotopic_mass": "991.4332",
                        "monoisotopic_mz": "992.4405",
                        "intensity": "1026.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "56",
                        "monoisotopic_mass": "5846.9059",
                        "monoisotopic_mz": "731.8705",
                        "intensity": "1807.64",
                        "charge": "8"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "57",
                        "monoisotopic_mass": "1047.5666",
                        "monoisotopic_mz": "1048.5739",
                        "intensity": "1314.62",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "58",
                        "monoisotopic_mass": "8708.8947",
                        "monoisotopic_mz": "792.7250",
                        "intensity": "3384.41",
                        "charge": "11"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "59",
                        "monoisotopic_mass": "2711.4891",
                        "monoisotopic_mz": "904.8370",
                        "intensity": "1743.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "60",
                        "monoisotopic_mass": "3282.7645",
                        "monoisotopic_mz": "821.6984",
                        "intensity": "3506.31",
                        "charge": "4"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "61",
                        "monoisotopic_mass": "6246.9852",
                        "monoisotopic_mz": "893.4337",
                        "intensity": "2550.28",
                        "charge": "7"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "62",
                        "monoisotopic_mass": "6926.7005",
                        "monoisotopic_mz": "866.8448",
                        "intensity": "813.34",
                        "charge": "8"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "63",
                        "monoisotopic_mass": "1429.8294",
                        "monoisotopic_mz": "477.6171",
                        "intensity": "1688.27",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "0.0000",
                                "ppm": "0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "64",
                        "monoisotopic_mass": "2569.3044",
                        "monoisotopic_mz": "857.4421",
                        "intensity": "3110.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "65",
                        "monoisotopic_mass": "2600.7883",
                        "monoisotopic_mz": "867.9367",
                        "intensity": "1954.35",
                        "charge": "3"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "66",
                        "monoisotopic_mass": "1326.7112",
                        "monoisotopic_mz": "664.3629",
                        "intensity": "633.19",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "67",
                        "monoisotopic_mass": "1262.7417",
                        "monoisotopic_mz": "632.3781",
                        "intensity": "812.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "68",
                        "monoisotopic_mass": "915.3577",
                        "monoisotopic_mz": "916.3650",
                        "intensity": "1439.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "69",
                        "monoisotopic_mass": "1394.1660",
                        "monoisotopic_mz": "698.0903",
                        "intensity": "3538.20",
                        "charge": "2"
                    },
                    {
                        "spec_id": "109",
                        "peak_id": "70",
                        "monoisotopic_mass": "702.6351",
                        "monoisotopic_mz": "703.6424",
                        "intensity": "467.55",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "0",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9529.1887",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "30",
                                    "ion_display_position": "30",
                                    "spec_id": "109",
                                    "peak_id": "46",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "30",
                                    "ion_display_position": "60",
                                    "spec_id": "109",
                                    "peak_id": "14",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "33",
                                "ion_display_position": "57",
                                "spec_id": "109",
                                "peak_id": "41",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "spec_id": "109",
                                "peak_id": "2",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "spec_id": "109",
                                "peak_id": "3",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "109",
                                "peak_id": "0",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "spec_id": "109",
                                "peak_id": "17",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "spec_id": "109",
                                "peak_id": "7",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "spec_id": "109",
                                "peak_id": "22",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "109",
                                    "peak_id": "4",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "109",
                                    "peak_id": "63",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "109",
                                    "peak_id": "23",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
