prsm_data =
{
    "prsm": {
        "prsm_id": "11",
        "p_value": "2.45e-11",
        "e_value": "2.45e-11",
        "fdr": "0",
        "matched_fragment_number": "17",
        "matched_peak_number": "20",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_1_ms2.msalign",
                "ms1_ids": "24",
                "ms1_scans": "38",
                "ids": "13",
                "scans": "39",
                "precursor_mono_mass": "9545.1693",
                "precursor_charge": "12",
                "precursor_mz": "796.4380",
                "feature_inte": "3.0136e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "13",
                        "peak_id": "0",
                        "monoisotopic_mass": "4778.6219",
                        "monoisotopic_mz": "797.4443",
                        "intensity": "43906.21",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "0.0010",
                                "ppm": "0.20"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "1",
                        "monoisotopic_mass": "4877.6855",
                        "monoisotopic_mz": "813.9549",
                        "intensity": "20386.85",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4877.6893",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "ion_sort_name": "Y00046",
                                "ion_left_position": "44",
                                "mass_error": "-0.0038",
                                "ppm": "-0.78"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "2",
                        "monoisotopic_mass": "4990.7700",
                        "monoisotopic_mz": "832.8023",
                        "intensity": "18746.48",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4990.7734",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "ion_sort_name": "Y00047",
                                "ion_left_position": "43",
                                "mass_error": "-0.0034",
                                "ppm": "-0.69"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "3",
                        "monoisotopic_mass": "3347.7874",
                        "monoisotopic_mz": "837.9541",
                        "intensity": "10968.44",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "4",
                        "monoisotopic_mass": "1429.8285",
                        "monoisotopic_mz": "715.9215",
                        "intensity": "14219.47",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0009",
                                "ppm": "-0.61"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "5",
                        "monoisotopic_mass": "6332.4485",
                        "monoisotopic_mz": "905.6428",
                        "intensity": "6982.81",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6332.4510",
                                "ion_position": "30",
                                "ion_display_position": "60",
                                "ion_sort_name": "Y00060",
                                "ion_left_position": "30",
                                "mass_error": "-0.0025",
                                "ppm": "-0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "6",
                        "monoisotopic_mass": "1856.0520",
                        "monoisotopic_mz": "929.0333",
                        "intensity": "8234.27",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1856.0520",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "ion_sort_name": "Y00019",
                                "ion_left_position": "71",
                                "mass_error": "0.0000",
                                "ppm": "0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "7",
                        "monoisotopic_mass": "4327.2778",
                        "monoisotopic_mz": "1082.8267",
                        "intensity": "8123.12",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "15.9955851271",
                                "theoretical_mass": "4327.2839",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "-0.0061",
                                "ppm": "-1.41"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "8",
                        "monoisotopic_mass": "5100.8080",
                        "monoisotopic_mz": "729.6941",
                        "intensity": "9844.50",
                        "charge": "7"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "9",
                        "monoisotopic_mass": "5118.8281",
                        "monoisotopic_mz": "854.1453",
                        "intensity": "14891.56",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5118.8320",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "42",
                                "mass_error": "-0.0039",
                                "ppm": "-0.76"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "10",
                        "monoisotopic_mass": "1785.0146",
                        "monoisotopic_mz": "893.5146",
                        "intensity": "5273.40",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1785.0149",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "ion_sort_name": "Y00018",
                                "ion_left_position": "72",
                                "mass_error": "-0.0004",
                                "ppm": "-0.20"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "11",
                        "monoisotopic_mass": "4760.6021",
                        "monoisotopic_mz": "794.4410",
                        "intensity": "7417.28",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "12",
                        "monoisotopic_mass": "3283.7706",
                        "monoisotopic_mz": "1095.5975",
                        "intensity": "5480.59",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "15.9955851271",
                                "theoretical_mass": "3283.7704",
                                "ion_position": "31",
                                "ion_display_position": "31",
                                "ion_sort_name": "B00031",
                                "ion_left_position": "31",
                                "mass_error": "0.0001",
                                "ppm": "0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "13",
                        "monoisotopic_mass": "4699.5745",
                        "monoisotopic_mz": "784.2697",
                        "intensity": "7522.82",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "14",
                        "monoisotopic_mass": "4256.2474",
                        "monoisotopic_mz": "1065.0691",
                        "intensity": "7902.29",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "15.9955851271",
                                "theoretical_mass": "4256.2468",
                                "ion_position": "40",
                                "ion_display_position": "40",
                                "ion_sort_name": "B00040",
                                "ion_left_position": "40",
                                "mass_error": "0.0006",
                                "ppm": "0.15"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "15",
                        "monoisotopic_mass": "5100.8031",
                        "monoisotopic_mz": "851.1411",
                        "intensity": "8426.89",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "16",
                        "monoisotopic_mass": "3447.8545",
                        "monoisotopic_mz": "862.9709",
                        "intensity": "5208.04",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "17",
                        "monoisotopic_mass": "3194.7218",
                        "monoisotopic_mz": "799.6877",
                        "intensity": "3879.62",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "18",
                        "monoisotopic_mass": "6146.3268",
                        "monoisotopic_mz": "879.0540",
                        "intensity": "7173.29",
                        "charge": "7"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "19",
                        "monoisotopic_mass": "1642.9400",
                        "monoisotopic_mz": "822.4773",
                        "intensity": "4222.84",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1642.9407",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "ion_sort_name": "Y00016",
                                "ion_left_position": "74",
                                "mass_error": "-0.0006",
                                "ppm": "-0.39"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "20",
                        "monoisotopic_mass": "2993.6001",
                        "monoisotopic_mz": "749.4073",
                        "intensity": "5076.38",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "21",
                        "monoisotopic_mass": "3559.9430",
                        "monoisotopic_mz": "890.9930",
                        "intensity": "4307.80",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "22",
                        "monoisotopic_mass": "2922.5659",
                        "monoisotopic_mz": "731.6488",
                        "intensity": "3763.19",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "23",
                        "monoisotopic_mass": "4858.6725",
                        "monoisotopic_mz": "810.7860",
                        "intensity": "3662.56",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "24",
                        "monoisotopic_mass": "1713.9806",
                        "monoisotopic_mz": "857.9976",
                        "intensity": "3593.67",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1713.9778",
                                "ion_position": "73",
                                "ion_display_position": "17",
                                "ion_sort_name": "Y00017",
                                "ion_left_position": "73",
                                "mass_error": "0.0028",
                                "ppm": "1.62"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "25",
                        "monoisotopic_mass": "1429.8293",
                        "monoisotopic_mz": "1430.8365",
                        "intensity": "2594.50",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0001",
                                "ppm": "-0.05"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "26",
                        "monoisotopic_mass": "2210.3152",
                        "monoisotopic_mz": "737.7790",
                        "intensity": "2882.25",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2210.3151",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "ion_sort_name": "Y00022",
                                "ion_left_position": "68",
                                "mass_error": "0.0001",
                                "ppm": "0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "27",
                        "monoisotopic_mass": "3064.6460",
                        "monoisotopic_mz": "767.1688",
                        "intensity": "3746.29",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "28",
                        "monoisotopic_mass": "4238.2339",
                        "monoisotopic_mz": "1060.5657",
                        "intensity": "1172.46",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "29",
                        "monoisotopic_mass": "3396.8526",
                        "monoisotopic_mz": "1133.2915",
                        "intensity": "3146.62",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "15.9955851271",
                                "theoretical_mass": "3396.8545",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "ion_sort_name": "B00032",
                                "ion_left_position": "32",
                                "mass_error": "-0.0019",
                                "ppm": "-0.57"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "30",
                        "monoisotopic_mass": "3092.6787",
                        "monoisotopic_mz": "774.1770",
                        "intensity": "2853.90",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "31",
                        "monoisotopic_mass": "2361.2975",
                        "monoisotopic_mz": "788.1064",
                        "intensity": "2984.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "32",
                        "monoisotopic_mass": "4797.6461",
                        "monoisotopic_mz": "800.6150",
                        "intensity": "2728.31",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "33",
                        "monoisotopic_mass": "2950.5173",
                        "monoisotopic_mz": "984.5131",
                        "intensity": "2802.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "34",
                        "monoisotopic_mass": "2809.4825",
                        "monoisotopic_mz": "937.5015",
                        "intensity": "2596.70",
                        "charge": "3"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "35",
                        "monoisotopic_mass": "3011.6008",
                        "monoisotopic_mz": "1004.8742",
                        "intensity": "2558.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "36",
                        "monoisotopic_mass": "4291.2942",
                        "monoisotopic_mz": "859.2661",
                        "intensity": "1022.83",
                        "charge": "5"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "37",
                        "monoisotopic_mass": "2810.4891",
                        "monoisotopic_mz": "703.6296",
                        "intensity": "3057.48",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "38",
                        "monoisotopic_mass": "2436.3365",
                        "monoisotopic_mz": "813.1194",
                        "intensity": "2241.59",
                        "charge": "3"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "39",
                        "monoisotopic_mass": "2908.5500",
                        "monoisotopic_mz": "728.1448",
                        "intensity": "1927.05",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "40",
                        "monoisotopic_mass": "6261.4163",
                        "monoisotopic_mz": "895.4953",
                        "intensity": "3811.62",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6261.4139",
                                "ion_position": "31",
                                "ion_display_position": "59",
                                "ion_sort_name": "Y00059",
                                "ion_left_position": "31",
                                "mass_error": "0.0024",
                                "ppm": "0.38"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "41",
                        "monoisotopic_mass": "813.7353",
                        "monoisotopic_mz": "814.7426",
                        "intensity": "1106.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "42",
                        "monoisotopic_mass": "3249.7268",
                        "monoisotopic_mz": "813.4390",
                        "intensity": "4561.74",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "43",
                        "monoisotopic_mass": "726.6376",
                        "monoisotopic_mz": "727.6449",
                        "intensity": "1160.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "44",
                        "monoisotopic_mass": "1015.6029",
                        "monoisotopic_mz": "1016.6102",
                        "intensity": "1105.21",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1015.6026",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "80",
                                "mass_error": "0.0003",
                                "ppm": "0.32"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "45",
                        "monoisotopic_mass": "4972.7490",
                        "monoisotopic_mz": "829.7988",
                        "intensity": "2750.40",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "46",
                        "monoisotopic_mass": "843.6522",
                        "monoisotopic_mz": "844.6595",
                        "intensity": "1175.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "47",
                        "monoisotopic_mass": "1283.7245",
                        "monoisotopic_mz": "1284.7318",
                        "intensity": "790.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "48",
                        "monoisotopic_mass": "1089.2515",
                        "monoisotopic_mz": "1090.2588",
                        "intensity": "1021.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "49",
                        "monoisotopic_mass": "4877.6852",
                        "monoisotopic_mz": "697.8194",
                        "intensity": "5543.40",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4877.6893",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "ion_sort_name": "Y00046",
                                "ion_left_position": "44",
                                "mass_error": "-0.0041",
                                "ppm": "-0.84"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "50",
                        "monoisotopic_mass": "4312.2860",
                        "monoisotopic_mz": "1079.0788",
                        "intensity": "3211.72",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "51",
                        "monoisotopic_mass": "4743.5835",
                        "monoisotopic_mz": "791.6045",
                        "intensity": "1287.58",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "52",
                        "monoisotopic_mass": "3010.5971",
                        "monoisotopic_mz": "753.6565",
                        "intensity": "2619.67",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "53",
                        "monoisotopic_mass": "751.6586",
                        "monoisotopic_mz": "752.6659",
                        "intensity": "1403.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "54",
                        "monoisotopic_mass": "1472.8110",
                        "monoisotopic_mz": "737.4128",
                        "intensity": "813.29",
                        "charge": "2"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "55",
                        "monoisotopic_mass": "4341.9801",
                        "monoisotopic_mz": "869.4033",
                        "intensity": "1894.12",
                        "charge": "5"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "56",
                        "monoisotopic_mass": "5215.0507",
                        "monoisotopic_mz": "870.1824",
                        "intensity": "1014.49",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "57",
                        "monoisotopic_mass": "1429.8278",
                        "monoisotopic_mz": "477.6165",
                        "intensity": "1582.49",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0015",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "58",
                        "monoisotopic_mass": "5999.1393",
                        "monoisotopic_mz": "1000.8638",
                        "intensity": "3136.73",
                        "charge": "6"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "59",
                        "monoisotopic_mass": "3284.7753",
                        "monoisotopic_mz": "822.2011",
                        "intensity": "2778.88",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "60",
                        "monoisotopic_mass": "1834.9861",
                        "monoisotopic_mz": "918.5003",
                        "intensity": "1467.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "61",
                        "monoisotopic_mass": "832.1325",
                        "monoisotopic_mz": "833.1397",
                        "intensity": "2511.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "62",
                        "monoisotopic_mass": "8231.7463",
                        "monoisotopic_mz": "915.6458",
                        "intensity": "3204.05",
                        "charge": "9"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "63",
                        "monoisotopic_mass": "8627.0656",
                        "monoisotopic_mz": "863.7138",
                        "intensity": "2737.04",
                        "charge": "10"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "64",
                        "monoisotopic_mass": "972.1614",
                        "monoisotopic_mz": "973.1687",
                        "intensity": "1059.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "65",
                        "monoisotopic_mass": "3957.6376",
                        "monoisotopic_mz": "792.5348",
                        "intensity": "2312.35",
                        "charge": "5"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "66",
                        "monoisotopic_mass": "3175.6559",
                        "monoisotopic_mz": "794.9213",
                        "intensity": "5322.18",
                        "charge": "4"
                    },
                    {
                        "spec_id": "13",
                        "peak_id": "67",
                        "monoisotopic_mass": "7457.9493",
                        "monoisotopic_mz": "829.6683",
                        "intensity": "2738.20",
                        "charge": "9"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "1",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9545.1843",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "30",
                                "ion_display_position": "60",
                                "spec_id": "13",
                                "peak_id": "5",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "31",
                                    "ion_display_position": "31",
                                    "spec_id": "13",
                                    "peak_id": "12",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "31",
                                    "ion_display_position": "59",
                                    "spec_id": "13",
                                    "peak_id": "40",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "spec_id": "13",
                                "peak_id": "29",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "40",
                                "ion_display_position": "40",
                                "spec_id": "13",
                                "peak_id": "14",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "13",
                                "peak_id": "7",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "spec_id": "13",
                                "peak_id": "9",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "spec_id": "13",
                                "peak_id": "2",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "44",
                                    "ion_display_position": "46",
                                    "spec_id": "13",
                                    "peak_id": "49",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "44",
                                    "ion_display_position": "46",
                                    "spec_id": "13",
                                    "peak_id": "1",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "13",
                                "peak_id": "0",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "spec_id": "13",
                                "peak_id": "26",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "spec_id": "13",
                                "peak_id": "6",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "spec_id": "13",
                                "peak_id": "10",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "73",
                                "ion_display_position": "17",
                                "spec_id": "13",
                                "peak_id": "24",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "spec_id": "13",
                                "peak_id": "19",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "13",
                                    "peak_id": "57",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "13",
                                    "peak_id": "4",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "13",
                                    "peak_id": "25",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "spec_id": "13",
                                "peak_id": "44",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "0",
                    "right_position": "30",
                    "anno": "15.9956",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
