prsm_data =
{
    "prsm": {
        "prsm_id": "102",
        "p_value": "1.33e-05",
        "e_value": "1.33e-05",
        "fdr": "0",
        "matched_fragment_number": "12",
        "matched_peak_number": "14",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_1_ms2.msalign",
                "ms1_ids": "382",
                "ms1_scans": "504",
                "ids": "121",
                "scans": "505",
                "precursor_mono_mass": "9544.1746",
                "precursor_charge": "12",
                "precursor_mz": "796.3552",
                "feature_inte": "3.0136e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "121",
                        "peak_id": "0",
                        "monoisotopic_mass": "4778.6200",
                        "monoisotopic_mz": "797.4439",
                        "intensity": "40926.00",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0009",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "1",
                        "monoisotopic_mass": "4990.7736",
                        "monoisotopic_mz": "832.8029",
                        "intensity": "18010.20",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4990.7734",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "ion_sort_name": "Y00047",
                                "ion_left_position": "43",
                                "mass_error": "0.0002",
                                "ppm": "0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "2",
                        "monoisotopic_mass": "4877.6899",
                        "monoisotopic_mz": "813.9556",
                        "intensity": "23198.43",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4877.6893",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "ion_sort_name": "Y00046",
                                "ion_left_position": "44",
                                "mass_error": "0.0006",
                                "ppm": "0.12"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "3",
                        "monoisotopic_mass": "1429.8292",
                        "monoisotopic_mz": "715.9219",
                        "intensity": "11002.68",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0001",
                                "ppm": "-0.09"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "4",
                        "monoisotopic_mass": "3348.7850",
                        "monoisotopic_mz": "838.2035",
                        "intensity": "8088.94",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "5",
                        "monoisotopic_mass": "4699.5767",
                        "monoisotopic_mz": "784.2701",
                        "intensity": "9722.46",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "6",
                        "monoisotopic_mass": "2809.4844",
                        "monoisotopic_mz": "703.3784",
                        "intensity": "4522.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "7",
                        "monoisotopic_mass": "5118.8295",
                        "monoisotopic_mz": "854.1455",
                        "intensity": "7935.03",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5118.8320",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "42",
                                "mass_error": "-0.0025",
                                "ppm": "-0.49"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "8",
                        "monoisotopic_mass": "4256.2490",
                        "monoisotopic_mz": "1065.0695",
                        "intensity": "6307.51",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "9",
                        "monoisotopic_mass": "5099.8154",
                        "monoisotopic_mz": "729.5523",
                        "intensity": "5084.95",
                        "charge": "7"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "10",
                        "monoisotopic_mass": "1968.1352",
                        "monoisotopic_mz": "985.0749",
                        "intensity": "3996.67",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "11",
                        "monoisotopic_mass": "4327.2831",
                        "monoisotopic_mz": "1082.8280",
                        "intensity": "4319.77",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "12",
                        "monoisotopic_mass": "4238.2388",
                        "monoisotopic_mz": "1060.5670",
                        "intensity": "3558.29",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "13",
                        "monoisotopic_mass": "892.5072",
                        "monoisotopic_mz": "893.5145",
                        "intensity": "4126.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "14",
                        "monoisotopic_mass": "6147.3214",
                        "monoisotopic_mz": "879.1961",
                        "intensity": "7120.54",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6148.3298",
                                "ion_position": "32",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "32",
                                "mass_error": "-0.0060",
                                "ppm": "-0.98"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "15",
                        "monoisotopic_mass": "2903.5491",
                        "monoisotopic_mz": "726.8946",
                        "intensity": "3431.61",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "16",
                        "monoisotopic_mass": "4760.5962",
                        "monoisotopic_mz": "794.4400",
                        "intensity": "4087.54",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "17",
                        "monoisotopic_mass": "1856.0544",
                        "monoisotopic_mz": "929.0345",
                        "intensity": "4883.75",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1856.0520",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "ion_sort_name": "Y00019",
                                "ion_left_position": "71",
                                "mass_error": "0.0023",
                                "ppm": "1.26"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "18",
                        "monoisotopic_mass": "3211.7273",
                        "monoisotopic_mz": "1071.5830",
                        "intensity": "3259.36",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "14.9909551271",
                                "theoretical_mass": "3211.7287",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "-0.0013",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "19",
                        "monoisotopic_mass": "3134.6744",
                        "monoisotopic_mz": "784.6759",
                        "intensity": "3065.08",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "20",
                        "monoisotopic_mass": "2210.3152",
                        "monoisotopic_mz": "737.7790",
                        "intensity": "2812.90",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2210.3151",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "ion_sort_name": "Y00022",
                                "ion_left_position": "68",
                                "mass_error": "0.0001",
                                "ppm": "0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "21",
                        "monoisotopic_mass": "3560.9441",
                        "monoisotopic_mz": "891.2433",
                        "intensity": "2585.38",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "22",
                        "monoisotopic_mass": "6818.2201",
                        "monoisotopic_mz": "853.2848",
                        "intensity": "1283.35",
                        "charge": "8"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "23",
                        "monoisotopic_mass": "3205.7586",
                        "monoisotopic_mz": "802.4469",
                        "intensity": "3067.67",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "24",
                        "monoisotopic_mass": "3283.7643",
                        "monoisotopic_mz": "1095.5954",
                        "intensity": "4369.83",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "25",
                        "monoisotopic_mass": "3248.7197",
                        "monoisotopic_mz": "813.1872",
                        "intensity": "1842.26",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "26",
                        "monoisotopic_mass": "3332.7657",
                        "monoisotopic_mz": "834.1987",
                        "intensity": "2099.23",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "27",
                        "monoisotopic_mass": "5617.9683",
                        "monoisotopic_mz": "937.3353",
                        "intensity": "1165.68",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "28",
                        "monoisotopic_mass": "1713.9767",
                        "monoisotopic_mz": "857.9956",
                        "intensity": "3486.74",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1713.9778",
                                "ion_position": "73",
                                "ion_display_position": "17",
                                "ion_sort_name": "Y00017",
                                "ion_left_position": "73",
                                "mass_error": "-0.0011",
                                "ppm": "-0.66"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "29",
                        "monoisotopic_mass": "4880.6858",
                        "monoisotopic_mz": "698.2481",
                        "intensity": "996.00",
                        "charge": "7"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "30",
                        "monoisotopic_mass": "800.1087",
                        "monoisotopic_mz": "801.1160",
                        "intensity": "1311.71",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "31",
                        "monoisotopic_mass": "3266.7710",
                        "monoisotopic_mz": "1089.9310",
                        "intensity": "2430.27",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "32",
                        "monoisotopic_mass": "848.9626",
                        "monoisotopic_mz": "849.9698",
                        "intensity": "1156.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "33",
                        "monoisotopic_mass": "866.4674",
                        "monoisotopic_mz": "867.4747",
                        "intensity": "1274.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "34",
                        "monoisotopic_mass": "930.4312",
                        "monoisotopic_mz": "931.4385",
                        "intensity": "1095.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "35",
                        "monoisotopic_mass": "2993.5996",
                        "monoisotopic_mz": "749.4072",
                        "intensity": "3376.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "36",
                        "monoisotopic_mass": "6261.4150",
                        "monoisotopic_mz": "895.4951",
                        "intensity": "2849.56",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6261.4139",
                                "ion_position": "31",
                                "ion_display_position": "59",
                                "ion_sort_name": "Y00059",
                                "ion_left_position": "31",
                                "mass_error": "0.0011",
                                "ppm": "0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "37",
                        "monoisotopic_mass": "1429.8278",
                        "monoisotopic_mz": "1430.8351",
                        "intensity": "2296.84",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0015",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "38",
                        "monoisotopic_mass": "2922.5718",
                        "monoisotopic_mz": "731.6502",
                        "intensity": "2088.34",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "39",
                        "monoisotopic_mass": "814.2872",
                        "monoisotopic_mz": "815.2944",
                        "intensity": "949.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "40",
                        "monoisotopic_mass": "5937.1313",
                        "monoisotopic_mz": "990.5292",
                        "intensity": "787.03",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "41",
                        "monoisotopic_mass": "4573.5262",
                        "monoisotopic_mz": "763.2616",
                        "intensity": "1787.71",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "42",
                        "monoisotopic_mass": "5843.9498",
                        "monoisotopic_mz": "835.8573",
                        "intensity": "690.42",
                        "charge": "7"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "43",
                        "monoisotopic_mass": "4351.3633",
                        "monoisotopic_mz": "871.2799",
                        "intensity": "1123.61",
                        "charge": "5"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "44",
                        "monoisotopic_mass": "4309.2667",
                        "monoisotopic_mz": "1078.3239",
                        "intensity": "1280.05",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "45",
                        "monoisotopic_mass": "5100.8126",
                        "monoisotopic_mz": "851.1427",
                        "intensity": "6525.14",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "46",
                        "monoisotopic_mass": "764.9504",
                        "monoisotopic_mz": "765.9576",
                        "intensity": "1066.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "47",
                        "monoisotopic_mass": "5906.0363",
                        "monoisotopic_mz": "985.3467",
                        "intensity": "1308.92",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "48",
                        "monoisotopic_mass": "5352.8844",
                        "monoisotopic_mz": "893.1547",
                        "intensity": "2197.73",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "49",
                        "monoisotopic_mass": "9145.8884",
                        "monoisotopic_mz": "763.1646",
                        "intensity": "1096.12",
                        "charge": "12"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "50",
                        "monoisotopic_mass": "6313.4009",
                        "monoisotopic_mz": "902.9217",
                        "intensity": "2242.67",
                        "charge": "7"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "51",
                        "monoisotopic_mass": "1547.3416",
                        "monoisotopic_mz": "774.6781",
                        "intensity": "2425.66",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "52",
                        "monoisotopic_mass": "4744.5906",
                        "monoisotopic_mz": "791.7724",
                        "intensity": "1686.24",
                        "charge": "6"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "53",
                        "monoisotopic_mass": "744.1480",
                        "monoisotopic_mz": "745.1553",
                        "intensity": "1162.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "54",
                        "monoisotopic_mass": "6892.7226",
                        "monoisotopic_mz": "862.5976",
                        "intensity": "726.59",
                        "charge": "8"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "55",
                        "monoisotopic_mass": "1429.8284",
                        "monoisotopic_mz": "477.6168",
                        "intensity": "2297.47",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0009",
                                "ppm": "-0.62"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "56",
                        "monoisotopic_mass": "4082.6716",
                        "monoisotopic_mz": "817.5416",
                        "intensity": "1919.08",
                        "charge": "5"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "57",
                        "monoisotopic_mass": "3065.6391",
                        "monoisotopic_mz": "767.4171",
                        "intensity": "3127.68",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "58",
                        "monoisotopic_mass": "729.6546",
                        "monoisotopic_mz": "730.6619",
                        "intensity": "1102.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "59",
                        "monoisotopic_mass": "2667.0787",
                        "monoisotopic_mz": "890.0335",
                        "intensity": "1994.07",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "60",
                        "monoisotopic_mass": "1132.2861",
                        "monoisotopic_mz": "1133.2933",
                        "intensity": "608.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "61",
                        "monoisotopic_mass": "3009.5967",
                        "monoisotopic_mz": "753.4064",
                        "intensity": "1840.52",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "62",
                        "monoisotopic_mass": "2591.5700",
                        "monoisotopic_mz": "864.8640",
                        "intensity": "587.73",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "63",
                        "monoisotopic_mass": "834.4216",
                        "monoisotopic_mz": "835.4288",
                        "intensity": "1027.94",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "64",
                        "monoisotopic_mass": "2910.5646",
                        "monoisotopic_mz": "971.1955",
                        "intensity": "1636.36",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "65",
                        "monoisotopic_mass": "1740.9466",
                        "monoisotopic_mz": "871.4806",
                        "intensity": "1308.25",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "66",
                        "monoisotopic_mass": "2324.7700",
                        "monoisotopic_mz": "775.9306",
                        "intensity": "1996.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "67",
                        "monoisotopic_mass": "2449.9807",
                        "monoisotopic_mz": "817.6675",
                        "intensity": "790.78",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "68",
                        "monoisotopic_mass": "1043.5130",
                        "monoisotopic_mz": "1044.5203",
                        "intensity": "804.53",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "69",
                        "monoisotopic_mass": "1015.6051",
                        "monoisotopic_mz": "1016.6124",
                        "intensity": "1426.42",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1015.6026",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "80",
                                "mass_error": "0.0025",
                                "ppm": "2.42"
                            }
                        }
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "70",
                        "monoisotopic_mass": "3162.7119",
                        "monoisotopic_mz": "791.6853",
                        "intensity": "905.60",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "71",
                        "monoisotopic_mass": "6033.2784",
                        "monoisotopic_mz": "862.9042",
                        "intensity": "4061.32",
                        "charge": "7"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "72",
                        "monoisotopic_mass": "1500.8351",
                        "monoisotopic_mz": "751.4248",
                        "intensity": "1311.85",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "73",
                        "monoisotopic_mass": "1310.8556",
                        "monoisotopic_mz": "656.4351",
                        "intensity": "526.79",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "74",
                        "monoisotopic_mass": "2537.1003",
                        "monoisotopic_mz": "846.7074",
                        "intensity": "979.10",
                        "charge": "3"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "75",
                        "monoisotopic_mass": "1411.8199",
                        "monoisotopic_mz": "706.9172",
                        "intensity": "1236.49",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "76",
                        "monoisotopic_mass": "3940.1656",
                        "monoisotopic_mz": "789.0404",
                        "intensity": "2665.81",
                        "charge": "5"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "77",
                        "monoisotopic_mass": "1088.5849",
                        "monoisotopic_mz": "1089.5922",
                        "intensity": "424.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "78",
                        "monoisotopic_mass": "3451.0651",
                        "monoisotopic_mz": "863.7735",
                        "intensity": "1060.40",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "79",
                        "monoisotopic_mass": "1395.6180",
                        "monoisotopic_mz": "698.8163",
                        "intensity": "508.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "80",
                        "monoisotopic_mass": "1446.2578",
                        "monoisotopic_mz": "724.1362",
                        "intensity": "517.62",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "81",
                        "monoisotopic_mass": "6847.5530",
                        "monoisotopic_mz": "856.9514",
                        "intensity": "5029.56",
                        "charge": "8"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "82",
                        "monoisotopic_mass": "4166.9708",
                        "monoisotopic_mz": "1042.7500",
                        "intensity": "1036.54",
                        "charge": "4"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "83",
                        "monoisotopic_mass": "946.8423",
                        "monoisotopic_mz": "947.8495",
                        "intensity": "936.01",
                        "charge": "1"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "84",
                        "monoisotopic_mass": "1462.2412",
                        "monoisotopic_mz": "732.1279",
                        "intensity": "622.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "121",
                        "peak_id": "85",
                        "monoisotopic_mass": "7949.2087",
                        "monoisotopic_mz": "884.2527",
                        "intensity": "1198.38",
                        "charge": "9"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "1",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9544.1796",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "spec_id": "121",
                                "peak_id": "18",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "31",
                                "ion_display_position": "59",
                                "spec_id": "121",
                                "peak_id": "36",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "32",
                                "ion_display_position": "58",
                                "spec_id": "121",
                                "peak_id": "14",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "spec_id": "121",
                                "peak_id": "7",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "spec_id": "121",
                                "peak_id": "1",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "spec_id": "121",
                                "peak_id": "2",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "121",
                                "peak_id": "0",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "spec_id": "121",
                                "peak_id": "20",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "spec_id": "121",
                                "peak_id": "17",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "73",
                                "ion_display_position": "17",
                                "spec_id": "121",
                                "peak_id": "28",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "121",
                                    "peak_id": "37",
                                    "peak_charge": "1"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "121",
                                    "peak_id": "55",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "121",
                                    "peak_id": "3",
                                    "peak_charge": "2"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "spec_id": "121",
                                "peak_id": "69",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "0",
                    "right_position": "30",
                    "anno": "14.9910",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
