prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "1",
        "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
        "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
        "proteoform_id": "3",
        "prsm_number": "43",
        "prsm": [
            {
                "prsm_id": "127",
                "p_value": "1.76e-08",
                "e_value": "1.76e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "451",
                        "ms1_scans": "600",
                        "ids": "149",
                        "scans": "602",
                        "precursor_mono_mass": "9218.9874",
                        "precursor_charge": "12",
                        "precursor_mz": "769.2562",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "149",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5815",
                                "monoisotopic_mz": "784.2709",
                                "intensity": "42788.62",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0028",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6481",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "20774.97",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7317",
                                "monoisotopic_mz": "819.6292",
                                "intensity": "15887.96",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0006",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "3",
                                "monoisotopic_mass": "4681.5529",
                                "monoisotopic_mz": "781.2661",
                                "intensity": "10537.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5248",
                                "monoisotopic_mz": "762.2614",
                                "intensity": "8151.52",
                                "charge": "6"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "5",
                                "monoisotopic_mass": "4138.1513",
                                "monoisotopic_mz": "1035.5451",
                                "intensity": "4225.78",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0067",
                                        "ppm": "-1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "6",
                                "monoisotopic_mass": "4154.1548",
                                "monoisotopic_mz": "1039.5460",
                                "intensity": "7289.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "7",
                                "monoisotopic_mass": "4642.5562",
                                "monoisotopic_mz": "774.7666",
                                "intensity": "7645.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "8",
                                "monoisotopic_mass": "1472.8104",
                                "monoisotopic_mz": "737.4125",
                                "intensity": "5313.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "9",
                                "monoisotopic_mass": "4982.7723",
                                "monoisotopic_mz": "831.4693",
                                "intensity": "4011.54",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0040",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7688",
                                "monoisotopic_mz": "807.6995",
                                "intensity": "3498.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "11",
                                "monoisotopic_mass": "4665.5444",
                                "monoisotopic_mz": "778.5980",
                                "intensity": "3963.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "12",
                                "monoisotopic_mass": "2247.2440",
                                "monoisotopic_mz": "750.0886",
                                "intensity": "2353.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "13",
                                "monoisotopic_mass": "2488.8575",
                                "monoisotopic_mz": "830.6264",
                                "intensity": "2757.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "14",
                                "monoisotopic_mass": "768.3274",
                                "monoisotopic_mz": "769.3347",
                                "intensity": "1172.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "15",
                                "monoisotopic_mass": "4617.9663",
                                "monoisotopic_mz": "770.6683",
                                "intensity": "977.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "16",
                                "monoisotopic_mass": "6312.3879",
                                "monoisotopic_mz": "902.7770",
                                "intensity": "1106.04",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6313.3935",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "17",
                                "monoisotopic_mass": "936.5050",
                                "monoisotopic_mz": "937.5123",
                                "intensity": "895.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "18",
                                "monoisotopic_mass": "826.6321",
                                "monoisotopic_mz": "827.6394",
                                "intensity": "1079.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "19",
                                "monoisotopic_mass": "3080.9747",
                                "monoisotopic_mz": "771.2510",
                                "intensity": "1425.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "20",
                                "monoisotopic_mass": "3063.6560",
                                "monoisotopic_mz": "1022.2259",
                                "intensity": "1127.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "21",
                                "monoisotopic_mass": "797.4369",
                                "monoisotopic_mz": "798.4442",
                                "intensity": "2253.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "22",
                                "monoisotopic_mass": "2274.2488",
                                "monoisotopic_mz": "759.0902",
                                "intensity": "795.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "23",
                                "monoisotopic_mass": "4592.4783",
                                "monoisotopic_mz": "766.4203",
                                "intensity": "1733.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "24",
                                "monoisotopic_mass": "1498.8241",
                                "monoisotopic_mz": "750.4193",
                                "intensity": "2077.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "25",
                                "monoisotopic_mass": "6420.4635",
                                "monoisotopic_mz": "803.5652",
                                "intensity": "1019.12",
                                "charge": "8"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "26",
                                "monoisotopic_mass": "7694.2578",
                                "monoisotopic_mz": "770.4331",
                                "intensity": "1282.13",
                                "charge": "10"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "27",
                                "monoisotopic_mass": "2793.5154",
                                "monoisotopic_mz": "932.1791",
                                "intensity": "2529.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "28",
                                "monoisotopic_mass": "974.4197",
                                "monoisotopic_mz": "975.4270",
                                "intensity": "1651.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "29",
                                "monoisotopic_mass": "781.4285",
                                "monoisotopic_mz": "782.4358",
                                "intensity": "1269.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "30",
                                "monoisotopic_mass": "5818.1827",
                                "monoisotopic_mz": "832.1762",
                                "intensity": "717.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "31",
                                "monoisotopic_mass": "3981.7900",
                                "monoisotopic_mz": "797.3653",
                                "intensity": "929.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "32",
                                "monoisotopic_mass": "2417.8181",
                                "monoisotopic_mz": "806.9466",
                                "intensity": "705.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "33",
                                "monoisotopic_mass": "8101.8538",
                                "monoisotopic_mz": "737.5394",
                                "intensity": "1744.52",
                                "charge": "11"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "34",
                                "monoisotopic_mass": "2308.7372",
                                "monoisotopic_mz": "770.5864",
                                "intensity": "4506.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "35",
                                "monoisotopic_mass": "1451.7579",
                                "monoisotopic_mz": "726.8862",
                                "intensity": "592.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "36",
                                "monoisotopic_mass": "9203.1587",
                                "monoisotopic_mz": "837.6581",
                                "intensity": "1809.66",
                                "charge": "11"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "37",
                                "monoisotopic_mass": "1020.8852",
                                "monoisotopic_mz": "1021.8925",
                                "intensity": "672.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "38",
                                "monoisotopic_mass": "4168.6950",
                                "monoisotopic_mz": "834.7463",
                                "intensity": "1945.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "39",
                                "monoisotopic_mass": "917.2353",
                                "monoisotopic_mz": "918.2426",
                                "intensity": "809.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "40",
                                "monoisotopic_mass": "3324.5930",
                                "monoisotopic_mz": "832.1555",
                                "intensity": "795.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "41",
                                "monoisotopic_mass": "4107.0318",
                                "monoisotopic_mz": "822.4136",
                                "intensity": "1974.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "149",
                                "peak_id": "42",
                                "monoisotopic_mass": "886.4599",
                                "monoisotopic_mz": "887.4671",
                                "intensity": "1035.84",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "149",
                                        "peak_id": "27",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "spec_id": "149",
                                        "peak_id": "16",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "149",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "149",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "149",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "149",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "149",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "149",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "149",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "1.46e-06",
                "e_value": "1.46e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "163",
                        "ms1_scans": "209",
                        "ids": "46",
                        "scans": "211",
                        "precursor_mono_mass": "9218.9816",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1597",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "46",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5793",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "23381.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6448",
                                "monoisotopic_mz": "800.7814",
                                "intensity": "11761.74",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "2",
                                "monoisotopic_mass": "4495.4881",
                                "monoisotopic_mz": "750.2553",
                                "intensity": "12190.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5839",
                                "monoisotopic_mz": "672.3764",
                                "intensity": "5462.50",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0052",
                                        "ppm": "1.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "4",
                                "monoisotopic_mass": "4642.5599",
                                "monoisotopic_mz": "774.7673",
                                "intensity": "6943.51",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0026",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "5",
                                "monoisotopic_mass": "4682.5556",
                                "monoisotopic_mz": "781.4332",
                                "intensity": "5817.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8093",
                                "monoisotopic_mz": "737.4119",
                                "intensity": "5737.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "7",
                                "monoisotopic_mass": "4567.5288",
                                "monoisotopic_mz": "762.2621",
                                "intensity": "5134.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "8",
                                "monoisotopic_mass": "4642.5492",
                                "monoisotopic_mz": "664.2286",
                                "intensity": "2720.92",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0081",
                                        "ppm": "-1.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "9",
                                "monoisotopic_mass": "4665.5901",
                                "monoisotopic_mz": "778.6056",
                                "intensity": "3888.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "10",
                                "monoisotopic_mass": "2793.5028",
                                "monoisotopic_mz": "699.3830",
                                "intensity": "2461.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0143",
                                        "ppm": "-5.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "11",
                                "monoisotopic_mass": "4797.6420",
                                "monoisotopic_mz": "686.3847",
                                "intensity": "5793.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "12",
                                "monoisotopic_mass": "2792.5131",
                                "monoisotopic_mz": "931.8450",
                                "intensity": "3402.07",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "13",
                                "monoisotopic_mass": "2809.5109",
                                "monoisotopic_mz": "937.5109",
                                "intensity": "2442.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "14",
                                "monoisotopic_mass": "6545.4519",
                                "monoisotopic_mz": "728.2797",
                                "intensity": "1465.87",
                                "charge": "9"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "15",
                                "monoisotopic_mass": "4910.7202",
                                "monoisotopic_mz": "819.4606",
                                "intensity": "2835.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "16",
                                "monoisotopic_mass": "2679.4182",
                                "monoisotopic_mz": "670.8618",
                                "intensity": "995.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "17",
                                "monoisotopic_mass": "1404.7578",
                                "monoisotopic_mz": "703.3862",
                                "intensity": "1839.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "18",
                                "monoisotopic_mass": "4509.5067",
                                "monoisotopic_mz": "752.5917",
                                "intensity": "1116.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "19",
                                "monoisotopic_mass": "5483.9963",
                                "monoisotopic_mz": "784.4353",
                                "intensity": "1161.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "20",
                                "monoisotopic_mass": "4504.9003",
                                "monoisotopic_mz": "644.5645",
                                "intensity": "1475.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "21",
                                "monoisotopic_mass": "2182.8223",
                                "monoisotopic_mz": "728.6147",
                                "intensity": "1701.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "22",
                                "monoisotopic_mass": "5240.7203",
                                "monoisotopic_mz": "749.6816",
                                "intensity": "1423.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "23",
                                "monoisotopic_mass": "2974.6280",
                                "monoisotopic_mz": "744.6643",
                                "intensity": "1008.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "24",
                                "monoisotopic_mass": "643.2815",
                                "monoisotopic_mz": "644.2888",
                                "intensity": "897.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "25",
                                "monoisotopic_mass": "703.3044",
                                "monoisotopic_mz": "704.3117",
                                "intensity": "1746.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "26",
                                "monoisotopic_mass": "2680.4329",
                                "monoisotopic_mz": "894.4849",
                                "intensity": "767.46",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "27",
                                "monoisotopic_mass": "1455.1457",
                                "monoisotopic_mz": "728.5801",
                                "intensity": "773.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "28",
                                "monoisotopic_mass": "5822.1965",
                                "monoisotopic_mz": "728.7818",
                                "intensity": "1052.68",
                                "charge": "8"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "29",
                                "monoisotopic_mass": "5791.9933",
                                "monoisotopic_mz": "644.5621",
                                "intensity": "806.19",
                                "charge": "9"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "30",
                                "monoisotopic_mass": "3000.3341",
                                "monoisotopic_mz": "751.0908",
                                "intensity": "1473.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "31",
                                "monoisotopic_mass": "744.3287",
                                "monoisotopic_mz": "745.3359",
                                "intensity": "1681.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "32",
                                "monoisotopic_mass": "6581.4550",
                                "monoisotopic_mz": "732.2801",
                                "intensity": "1004.81",
                                "charge": "9"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "33",
                                "monoisotopic_mass": "717.3781",
                                "monoisotopic_mz": "718.3854",
                                "intensity": "1238.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "34",
                                "monoisotopic_mass": "1472.8102",
                                "monoisotopic_mz": "491.9440",
                                "intensity": "450.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0002",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "35",
                                "monoisotopic_mass": "8476.1336",
                                "monoisotopic_mz": "771.5649",
                                "intensity": "924.33",
                                "charge": "11"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "36",
                                "monoisotopic_mass": "7079.4500",
                                "monoisotopic_mz": "644.5936",
                                "intensity": "735.17",
                                "charge": "11"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "37",
                                "monoisotopic_mass": "670.3780",
                                "monoisotopic_mz": "671.3853",
                                "intensity": "1371.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "38",
                                "monoisotopic_mass": "1360.6987",
                                "monoisotopic_mz": "681.3566",
                                "intensity": "509.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "39",
                                "monoisotopic_mass": "1034.5373",
                                "monoisotopic_mz": "1035.5446",
                                "intensity": "1313.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "40",
                                "monoisotopic_mass": "4798.6491",
                                "monoisotopic_mz": "600.8384",
                                "intensity": "673.84",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0020",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "41",
                                "monoisotopic_mass": "784.8697",
                                "monoisotopic_mz": "785.8770",
                                "intensity": "1086.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "42",
                                "monoisotopic_mass": "6243.3324",
                                "monoisotopic_mz": "781.4238",
                                "intensity": "1670.73",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6242.3564",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0263",
                                        "ppm": "-4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "43",
                                "monoisotopic_mass": "837.4485",
                                "monoisotopic_mz": "838.4557",
                                "intensity": "626.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "46",
                                "peak_id": "44",
                                "monoisotopic_mass": "756.7378",
                                "monoisotopic_mz": "757.7451",
                                "intensity": "2199.96",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "46",
                                        "peak_id": "26",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "46",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "spec_id": "46",
                                        "peak_id": "42",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "46",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "46",
                                            "peak_id": "40",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "46",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "46",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "46",
                                            "peak_id": "8",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "46",
                                            "peak_id": "4",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "46",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "46",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "46",
                                            "peak_id": "34",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "166",
                "p_value": "3.27e-06",
                "e_value": "3.27e-06",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "793",
                        "ms1_scans": "986",
                        "ids": "193",
                        "scans": "988",
                        "precursor_mono_mass": "9218.9831",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1598",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "193",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5749",
                                "monoisotopic_mz": "784.2698",
                                "intensity": "30098.26",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "1",
                                "monoisotopic_mass": "4567.5258",
                                "monoisotopic_mz": "762.2616",
                                "intensity": "12689.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "2",
                                "monoisotopic_mass": "4495.4881",
                                "monoisotopic_mz": "750.2553",
                                "intensity": "13142.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5762",
                                "monoisotopic_mz": "672.3753",
                                "intensity": "10219.69",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "4",
                                "monoisotopic_mass": "4798.6481",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "14519.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "5",
                                "monoisotopic_mass": "4797.6441",
                                "monoisotopic_mz": "686.3850",
                                "intensity": "8248.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8103",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "5699.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0003",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "7",
                                "monoisotopic_mass": "4642.5558",
                                "monoisotopic_mz": "774.7666",
                                "intensity": "6629.98",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "8",
                                "monoisotopic_mass": "1340.7557",
                                "monoisotopic_mz": "671.3851",
                                "intensity": "2456.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "9",
                                "monoisotopic_mass": "2809.5129",
                                "monoisotopic_mz": "937.5116",
                                "intensity": "3315.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "10",
                                "monoisotopic_mass": "2793.5117",
                                "monoisotopic_mz": "932.1778",
                                "intensity": "3415.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0054",
                                        "ppm": "-1.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "11",
                                "monoisotopic_mass": "974.4202",
                                "monoisotopic_mz": "975.4274",
                                "intensity": "2736.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "12",
                                "monoisotopic_mass": "4153.1426",
                                "monoisotopic_mz": "1039.2929",
                                "intensity": "3272.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "13",
                                "monoisotopic_mass": "2341.2754",
                                "monoisotopic_mz": "781.4324",
                                "intensity": "3074.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "14",
                                "monoisotopic_mass": "3003.2842",
                                "monoisotopic_mz": "751.8283",
                                "intensity": "2092.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "15",
                                "monoisotopic_mass": "4477.4669",
                                "monoisotopic_mz": "747.2518",
                                "intensity": "2654.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "16",
                                "monoisotopic_mass": "4666.5855",
                                "monoisotopic_mz": "778.7715",
                                "intensity": "4001.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "17",
                                "monoisotopic_mass": "4363.4371",
                                "monoisotopic_mz": "728.2468",
                                "intensity": "8157.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "18",
                                "monoisotopic_mass": "2791.4995",
                                "monoisotopic_mz": "698.8822",
                                "intensity": "924.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "19",
                                "monoisotopic_mass": "712.0346",
                                "monoisotopic_mz": "713.0419",
                                "intensity": "793.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "20",
                                "monoisotopic_mass": "780.2618",
                                "monoisotopic_mz": "781.2691",
                                "intensity": "867.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "21",
                                "monoisotopic_mass": "830.9629",
                                "monoisotopic_mz": "831.9702",
                                "intensity": "1273.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "22",
                                "monoisotopic_mass": "3081.6676",
                                "monoisotopic_mz": "771.4242",
                                "intensity": "2527.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "23",
                                "monoisotopic_mass": "1372.9048",
                                "monoisotopic_mz": "687.4597",
                                "intensity": "312.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "24",
                                "monoisotopic_mass": "2526.2506",
                                "monoisotopic_mz": "843.0908",
                                "intensity": "1028.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "25",
                                "monoisotopic_mass": "3234.8083",
                                "monoisotopic_mz": "809.7094",
                                "intensity": "894.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "26",
                                "monoisotopic_mass": "936.5032",
                                "monoisotopic_mz": "937.5105",
                                "intensity": "557.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "27",
                                "monoisotopic_mass": "1414.8691",
                                "monoisotopic_mz": "708.4418",
                                "intensity": "1023.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "28",
                                "monoisotopic_mass": "1021.2177",
                                "monoisotopic_mz": "1022.2250",
                                "intensity": "1652.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "29",
                                "monoisotopic_mass": "8214.8924",
                                "monoisotopic_mz": "747.8157",
                                "intensity": "1017.08",
                                "charge": "11"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "30",
                                "monoisotopic_mass": "2810.5146",
                                "monoisotopic_mz": "703.6359",
                                "intensity": "2968.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "31",
                                "monoisotopic_mass": "1455.4793",
                                "monoisotopic_mz": "728.7469",
                                "intensity": "1918.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "32",
                                "monoisotopic_mass": "913.9068",
                                "monoisotopic_mz": "914.9141",
                                "intensity": "649.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "33",
                                "monoisotopic_mass": "2255.7513",
                                "monoisotopic_mz": "752.9244",
                                "intensity": "1213.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "34",
                                "monoisotopic_mass": "1428.5064",
                                "monoisotopic_mz": "715.2605",
                                "intensity": "603.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "35",
                                "monoisotopic_mass": "797.7818",
                                "monoisotopic_mz": "798.7890",
                                "intensity": "1082.61",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "193",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "193",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "193",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "193",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "193",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "193",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "193",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "95",
                "p_value": "8.74e-06",
                "e_value": "8.74e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "356",
                        "ms1_scans": "469",
                        "ids": "113",
                        "scans": "471",
                        "precursor_mono_mass": "9218.9742",
                        "precursor_charge": "12",
                        "precursor_mz": "769.2551",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "113",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5760",
                                "monoisotopic_mz": "784.2699",
                                "intensity": "32415.40",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6456",
                                "monoisotopic_mz": "800.7815",
                                "intensity": "18685.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7312",
                                "monoisotopic_mz": "819.4625",
                                "intensity": "12491.68",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0004265213",
                                        "theoretical_mass": "4910.7308",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0005",
                                        "ppm": "0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "3",
                                "monoisotopic_mass": "4642.5584",
                                "monoisotopic_mz": "774.7670",
                                "intensity": "10530.65",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0011",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "4",
                                "monoisotopic_mass": "4682.5512",
                                "monoisotopic_mz": "781.4325",
                                "intensity": "12438.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8108",
                                "monoisotopic_mz": "737.4127",
                                "intensity": "4560.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0008",
                                        "ppm": "0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "6",
                                "monoisotopic_mass": "2793.5097",
                                "monoisotopic_mz": "932.1772",
                                "intensity": "3937.25",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0074",
                                        "ppm": "-2.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "7",
                                "monoisotopic_mass": "4495.4797",
                                "monoisotopic_mz": "750.2539",
                                "intensity": "5046.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0091",
                                        "ppm": "-2.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "8",
                                "monoisotopic_mass": "3226.7682",
                                "monoisotopic_mz": "807.6993",
                                "intensity": "3714.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "9",
                                "monoisotopic_mass": "4154.1532",
                                "monoisotopic_mz": "1039.5456",
                                "intensity": "6433.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "10",
                                "monoisotopic_mass": "4981.7633",
                                "monoisotopic_mz": "831.3012",
                                "intensity": "5934.83",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0004265213",
                                        "theoretical_mass": "4981.7679",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "11",
                                "monoisotopic_mass": "3078.9773",
                                "monoisotopic_mz": "770.7516",
                                "intensity": "1929.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "12",
                                "monoisotopic_mass": "2809.5117",
                                "monoisotopic_mz": "703.3852",
                                "intensity": "2792.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "13",
                                "monoisotopic_mass": "3000.6489",
                                "monoisotopic_mz": "751.1695",
                                "intensity": "2132.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "14",
                                "monoisotopic_mass": "3061.6533",
                                "monoisotopic_mz": "1021.5584",
                                "intensity": "3114.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "15",
                                "monoisotopic_mass": "770.4166",
                                "monoisotopic_mz": "771.4238",
                                "intensity": "1476.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "16",
                                "monoisotopic_mass": "4624.5361",
                                "monoisotopic_mz": "771.7633",
                                "intensity": "1941.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "17",
                                "monoisotopic_mass": "1456.7864",
                                "monoisotopic_mz": "729.4005",
                                "intensity": "710.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "18",
                                "monoisotopic_mass": "974.4194",
                                "monoisotopic_mz": "975.4266",
                                "intensity": "1663.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "19",
                                "monoisotopic_mass": "9202.9837",
                                "monoisotopic_mz": "767.9226",
                                "intensity": "1784.84",
                                "charge": "12"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "20",
                                "monoisotopic_mass": "3142.7524",
                                "monoisotopic_mz": "786.6954",
                                "intensity": "1924.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "21",
                                "monoisotopic_mass": "1536.8341",
                                "monoisotopic_mz": "769.4243",
                                "intensity": "1946.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "22",
                                "monoisotopic_mass": "740.8948",
                                "monoisotopic_mz": "741.9020",
                                "intensity": "933.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "23",
                                "monoisotopic_mass": "879.2940",
                                "monoisotopic_mz": "880.3013",
                                "intensity": "973.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "24",
                                "monoisotopic_mass": "784.4347",
                                "monoisotopic_mz": "785.4420",
                                "intensity": "1965.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "25",
                                "monoisotopic_mass": "892.4816",
                                "monoisotopic_mz": "893.4889",
                                "intensity": "1476.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "26",
                                "monoisotopic_mass": "4895.7049",
                                "monoisotopic_mz": "816.9581",
                                "intensity": "3922.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "27",
                                "monoisotopic_mass": "9106.9564",
                                "monoisotopic_mz": "828.9124",
                                "intensity": "2180.34",
                                "charge": "11"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "28",
                                "monoisotopic_mass": "848.3857",
                                "monoisotopic_mz": "849.3929",
                                "intensity": "966.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "29",
                                "monoisotopic_mass": "8461.8151",
                                "monoisotopic_mz": "847.1888",
                                "intensity": "797.48",
                                "charge": "10"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "30",
                                "monoisotopic_mass": "936.8367",
                                "monoisotopic_mz": "937.8439",
                                "intensity": "675.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "31",
                                "monoisotopic_mass": "1429.7549",
                                "monoisotopic_mz": "715.8847",
                                "intensity": "708.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "32",
                                "monoisotopic_mass": "865.5850",
                                "monoisotopic_mz": "866.5923",
                                "intensity": "746.04",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.9942",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "113",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "113",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "113",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "113",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "113",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "113",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "113",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "113",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "43",
                            "right_position": "44",
                            "anno": "-1.0004",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "70",
                "p_value": "1.05e-05",
                "e_value": "1.05e-05",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "274",
                        "ms1_scans": "360",
                        "ids": "85",
                        "scans": "361",
                        "precursor_mono_mass": "9218.9776",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1594",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "85",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5782",
                                "monoisotopic_mz": "784.2703",
                                "intensity": "22548.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4863",
                                "monoisotopic_mz": "750.2550",
                                "intensity": "5873.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0026",
                                        "ppm": "-0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5805",
                                "monoisotopic_mz": "672.3759",
                                "intensity": "8210.32",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0018",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5240",
                                "monoisotopic_mz": "762.2613",
                                "intensity": "8967.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "4",
                                "monoisotopic_mass": "4681.5540",
                                "monoisotopic_mz": "781.2663",
                                "intensity": "7861.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "5",
                                "monoisotopic_mass": "4798.6372",
                                "monoisotopic_mz": "800.7801",
                                "intensity": "5110.79",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0100",
                                        "ppm": "-2.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "6",
                                "monoisotopic_mass": "4798.6567",
                                "monoisotopic_mz": "686.5297",
                                "intensity": "2580.44",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0096",
                                        "ppm": "1.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "7",
                                "monoisotopic_mass": "4364.4365",
                                "monoisotopic_mz": "728.4134",
                                "intensity": "4251.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "8",
                                "monoisotopic_mass": "1472.8087",
                                "monoisotopic_mz": "737.4116",
                                "intensity": "2816.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "9",
                                "monoisotopic_mass": "2321.2769",
                                "monoisotopic_mz": "774.7662",
                                "intensity": "3127.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "10",
                                "monoisotopic_mass": "683.3788",
                                "monoisotopic_mz": "684.3860",
                                "intensity": "1000.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "11",
                                "monoisotopic_mass": "710.1695",
                                "monoisotopic_mz": "711.1768",
                                "intensity": "1803.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "12",
                                "monoisotopic_mass": "1372.7591",
                                "monoisotopic_mz": "687.3868",
                                "intensity": "781.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "13",
                                "monoisotopic_mass": "4182.1440",
                                "monoisotopic_mz": "698.0313",
                                "intensity": "1852.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "14",
                                "monoisotopic_mass": "1394.7433",
                                "monoisotopic_mz": "698.3789",
                                "intensity": "615.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "15",
                                "monoisotopic_mass": "726.3959",
                                "monoisotopic_mz": "727.4032",
                                "intensity": "927.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "16",
                                "monoisotopic_mass": "1451.5810",
                                "monoisotopic_mz": "726.7978",
                                "intensity": "622.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "17",
                                "monoisotopic_mass": "765.1783",
                                "monoisotopic_mz": "766.1856",
                                "intensity": "904.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "18",
                                "monoisotopic_mass": "913.8302",
                                "monoisotopic_mz": "914.8375",
                                "intensity": "963.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "19",
                                "monoisotopic_mass": "6056.0192",
                                "monoisotopic_mz": "758.0097",
                                "intensity": "1012.61",
                                "charge": "8"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "20",
                                "monoisotopic_mass": "1340.7546",
                                "monoisotopic_mz": "671.3846",
                                "intensity": "1221.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "21",
                                "monoisotopic_mass": "2793.5042",
                                "monoisotopic_mz": "932.1754",
                                "intensity": "2189.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0129",
                                        "ppm": "-4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "22",
                                "monoisotopic_mass": "1308.8537",
                                "monoisotopic_mz": "655.4341",
                                "intensity": "1218.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "23",
                                "monoisotopic_mass": "4640.5406",
                                "monoisotopic_mz": "663.9417",
                                "intensity": "2031.56",
                                "charge": "7"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "24",
                                "monoisotopic_mass": "4626.5224",
                                "monoisotopic_mz": "772.0943",
                                "intensity": "1835.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "25",
                                "monoisotopic_mass": "2995.6360",
                                "monoisotopic_mz": "749.9163",
                                "intensity": "1624.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "85",
                                "peak_id": "26",
                                "monoisotopic_mass": "746.9112",
                                "monoisotopic_mz": "747.9184",
                                "intensity": "875.07",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "85",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "85",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "85",
                                            "peak_id": "6",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "85",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "85",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "85",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "85",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "78",
                "p_value": "1.08e-05",
                "e_value": "1.08e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "299",
                        "ms1_scans": "393",
                        "ids": "94",
                        "scans": "395",
                        "precursor_mono_mass": "9219.9828",
                        "precursor_charge": "12",
                        "precursor_mz": "769.3392",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "94",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5767",
                                "monoisotopic_mz": "784.2701",
                                "intensity": "37576.68",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6438",
                                "monoisotopic_mz": "800.7812",
                                "intensity": "21411.23",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7258",
                                "monoisotopic_mz": "819.4616",
                                "intensity": "12273.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "3",
                                "monoisotopic_mass": "4682.5501",
                                "monoisotopic_mz": "781.4323",
                                "intensity": "8613.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5218",
                                "monoisotopic_mz": "762.2609",
                                "intensity": "9392.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "5",
                                "monoisotopic_mass": "4982.7624",
                                "monoisotopic_mz": "831.4677",
                                "intensity": "7783.39",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0059",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "6",
                                "monoisotopic_mass": "4154.1488",
                                "monoisotopic_mz": "1039.5445",
                                "intensity": "4677.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "7",
                                "monoisotopic_mass": "1547.5174",
                                "monoisotopic_mz": "774.7660",
                                "intensity": "3924.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "8",
                                "monoisotopic_mass": "2391.3127",
                                "monoisotopic_mz": "798.1115",
                                "intensity": "2955.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "9",
                                "monoisotopic_mass": "9215.9322",
                                "monoisotopic_mz": "769.0016",
                                "intensity": "3852.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7656",
                                "monoisotopic_mz": "807.6987",
                                "intensity": "4854.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "11",
                                "monoisotopic_mass": "1472.8078",
                                "monoisotopic_mz": "737.4112",
                                "intensity": "4719.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0022",
                                        "ppm": "-1.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "12",
                                "monoisotopic_mass": "3095.3652",
                                "monoisotopic_mz": "774.8486",
                                "intensity": "4050.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "13",
                                "monoisotopic_mass": "2808.5082",
                                "monoisotopic_mz": "937.1767",
                                "intensity": "4015.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "14",
                                "monoisotopic_mass": "3077.9746",
                                "monoisotopic_mz": "770.5009",
                                "intensity": "1885.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "15",
                                "monoisotopic_mass": "4666.5899",
                                "monoisotopic_mz": "778.7723",
                                "intensity": "2407.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "16",
                                "monoisotopic_mass": "6998.3806",
                                "monoisotopic_mz": "778.6051",
                                "intensity": "1110.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "17",
                                "monoisotopic_mass": "685.0726",
                                "monoisotopic_mz": "686.0799",
                                "intensity": "3714.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "18",
                                "monoisotopic_mass": "974.4184",
                                "monoisotopic_mz": "975.4257",
                                "intensity": "1380.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "19",
                                "monoisotopic_mass": "4799.6454",
                                "monoisotopic_mz": "686.6709",
                                "intensity": "669.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "20",
                                "monoisotopic_mass": "806.3424",
                                "monoisotopic_mz": "807.3497",
                                "intensity": "1341.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "21",
                                "monoisotopic_mass": "6581.4457",
                                "monoisotopic_mz": "732.2790",
                                "intensity": "977.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "22",
                                "monoisotopic_mass": "1535.4962",
                                "monoisotopic_mz": "768.7554",
                                "intensity": "1339.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "23",
                                "monoisotopic_mass": "4138.1484",
                                "monoisotopic_mz": "1035.5444",
                                "intensity": "3022.26",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0096",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "24",
                                "monoisotopic_mass": "2281.4617",
                                "monoisotopic_mz": "761.4945",
                                "intensity": "853.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "25",
                                "monoisotopic_mass": "7649.8703",
                                "monoisotopic_mz": "765.9943",
                                "intensity": "1115.88",
                                "charge": "10"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "26",
                                "monoisotopic_mass": "6056.2300",
                                "monoisotopic_mz": "866.1830",
                                "intensity": "3697.81",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6056.2560",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0260",
                                        "ppm": "-4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "27",
                                "monoisotopic_mass": "7470.1178",
                                "monoisotopic_mz": "748.0191",
                                "intensity": "2066.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "28",
                                "monoisotopic_mass": "1021.2190",
                                "monoisotopic_mz": "1022.2263",
                                "intensity": "1304.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "29",
                                "monoisotopic_mass": "6494.5889",
                                "monoisotopic_mz": "812.8309",
                                "intensity": "1952.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "30",
                                "monoisotopic_mass": "6158.1710",
                                "monoisotopic_mz": "770.7787",
                                "intensity": "1217.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "31",
                                "monoisotopic_mass": "702.6258",
                                "monoisotopic_mz": "703.6331",
                                "intensity": "1001.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "32",
                                "monoisotopic_mass": "828.4228",
                                "monoisotopic_mz": "829.4301",
                                "intensity": "1966.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "33",
                                "monoisotopic_mass": "1456.4858",
                                "monoisotopic_mz": "729.2502",
                                "intensity": "490.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "34",
                                "monoisotopic_mass": "5929.1636",
                                "monoisotopic_mz": "848.0307",
                                "intensity": "805.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "35",
                                "monoisotopic_mass": "6275.7081",
                                "monoisotopic_mz": "785.4708",
                                "intensity": "996.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "36",
                                "monoisotopic_mass": "2571.3480",
                                "monoisotopic_mz": "858.1233",
                                "intensity": "843.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "37",
                                "monoisotopic_mass": "1340.7562",
                                "monoisotopic_mz": "671.3854",
                                "intensity": "490.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "38",
                                "monoisotopic_mass": "8423.0981",
                                "monoisotopic_mz": "936.9071",
                                "intensity": "967.65",
                                "charge": "9"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "39",
                                "monoisotopic_mass": "3254.0743",
                                "monoisotopic_mz": "814.5258",
                                "intensity": "1245.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "40",
                                "monoisotopic_mass": "7278.0371",
                                "monoisotopic_mz": "809.6781",
                                "intensity": "718.67",
                                "charge": "9"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "41",
                                "monoisotopic_mass": "5386.1006",
                                "monoisotopic_mz": "770.4502",
                                "intensity": "626.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "42",
                                "monoisotopic_mass": "2998.6140",
                                "monoisotopic_mz": "1000.5453",
                                "intensity": "1035.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "43",
                                "monoisotopic_mass": "2793.5094",
                                "monoisotopic_mz": "932.1771",
                                "intensity": "3371.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0077",
                                        "ppm": "-2.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "44",
                                "monoisotopic_mass": "1390.2517",
                                "monoisotopic_mz": "696.1331",
                                "intensity": "560.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "45",
                                "monoisotopic_mass": "1409.2539",
                                "monoisotopic_mz": "705.6342",
                                "intensity": "653.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "46",
                                "monoisotopic_mass": "903.0577",
                                "monoisotopic_mz": "904.0650",
                                "intensity": "708.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "94",
                                "peak_id": "47",
                                "monoisotopic_mass": "1496.3507",
                                "monoisotopic_mz": "749.1826",
                                "intensity": "2153.94",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "94",
                                        "peak_id": "43",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "94",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "94",
                                        "peak_id": "23",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "94",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "94",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "94",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "94",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "129",
                "p_value": "1.56e-05",
                "e_value": "1.56e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "460",
                        "ms1_scans": "613",
                        "ids": "152",
                        "scans": "614",
                        "precursor_mono_mass": "9218.9779",
                        "precursor_charge": "12",
                        "precursor_mz": "769.2554",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "152",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5796",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "40432.96",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0009",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "1",
                                "monoisotopic_mass": "4797.6440",
                                "monoisotopic_mz": "800.6146",
                                "intensity": "20346.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7365",
                                "monoisotopic_mz": "819.6300",
                                "intensity": "13342.05",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0053",
                                        "ppm": "1.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "3",
                                "monoisotopic_mass": "4682.5754",
                                "monoisotopic_mz": "781.4365",
                                "intensity": "5878.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "4",
                                "monoisotopic_mass": "4566.5315",
                                "monoisotopic_mz": "762.0959",
                                "intensity": "6570.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "5",
                                "monoisotopic_mass": "4666.5950",
                                "monoisotopic_mz": "778.7731",
                                "intensity": "4108.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8115",
                                "monoisotopic_mz": "737.4130",
                                "intensity": "3879.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0015",
                                        "ppm": "1.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "7",
                                "monoisotopic_mass": "2491.3838",
                                "monoisotopic_mz": "831.4685",
                                "intensity": "4100.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "8",
                                "monoisotopic_mass": "4642.5628",
                                "monoisotopic_mz": "774.7677",
                                "intensity": "9152.97",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0055",
                                        "ppm": "1.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "9",
                                "monoisotopic_mass": "4138.1465",
                                "monoisotopic_mz": "1035.5439",
                                "intensity": "4185.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0115",
                                        "ppm": "-2.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "10",
                                "monoisotopic_mass": "2923.5968",
                                "monoisotopic_mz": "975.5396",
                                "intensity": "2101.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "11",
                                "monoisotopic_mass": "4154.1534",
                                "monoisotopic_mz": "1039.5456",
                                "intensity": "4516.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "12",
                                "monoisotopic_mass": "2793.5107",
                                "monoisotopic_mz": "932.1775",
                                "intensity": "4092.48",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0064",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "13",
                                "monoisotopic_mass": "4602.9802",
                                "monoisotopic_mz": "768.1706",
                                "intensity": "3407.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "14",
                                "monoisotopic_mass": "2247.2443",
                                "monoisotopic_mz": "750.0887",
                                "intensity": "1869.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "15",
                                "monoisotopic_mass": "7334.9499",
                                "monoisotopic_mz": "917.8760",
                                "intensity": "2390.02",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7335.9808",
                                        "ion_position": "18",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "Y00072",
                                        "ion_left_position": "18",
                                        "mass_error": "-0.0286",
                                        "ppm": "-3.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "16",
                                "monoisotopic_mass": "767.0796",
                                "monoisotopic_mz": "768.0869",
                                "intensity": "1890.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "17",
                                "monoisotopic_mass": "8378.7651",
                                "monoisotopic_mz": "762.7132",
                                "intensity": "1036.40",
                                "charge": "11"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "18",
                                "monoisotopic_mass": "3263.7973",
                                "monoisotopic_mz": "816.9566",
                                "intensity": "2224.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "19",
                                "monoisotopic_mass": "9104.9154",
                                "monoisotopic_mz": "828.7269",
                                "intensity": "1161.34",
                                "charge": "11"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "20",
                                "monoisotopic_mass": "4616.9613",
                                "monoisotopic_mz": "770.5008",
                                "intensity": "1057.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "21",
                                "monoisotopic_mass": "974.4191",
                                "monoisotopic_mz": "975.4264",
                                "intensity": "1636.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "22",
                                "monoisotopic_mass": "870.4684",
                                "monoisotopic_mz": "871.4756",
                                "intensity": "1268.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "23",
                                "monoisotopic_mass": "930.1624",
                                "monoisotopic_mz": "931.1697",
                                "intensity": "1262.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "24",
                                "monoisotopic_mass": "5823.1733",
                                "monoisotopic_mz": "832.8892",
                                "intensity": "875.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "25",
                                "monoisotopic_mass": "8033.1346",
                                "monoisotopic_mz": "731.2922",
                                "intensity": "1126.10",
                                "charge": "11"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "26",
                                "monoisotopic_mass": "3062.6566",
                                "monoisotopic_mz": "1021.8928",
                                "intensity": "2024.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "27",
                                "monoisotopic_mass": "687.5134",
                                "monoisotopic_mz": "688.5207",
                                "intensity": "1270.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "28",
                                "monoisotopic_mass": "7918.3871",
                                "monoisotopic_mz": "880.8281",
                                "intensity": "1109.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "29",
                                "monoisotopic_mass": "7637.2580",
                                "monoisotopic_mz": "849.5915",
                                "intensity": "882.30",
                                "charge": "9"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "30",
                                "monoisotopic_mass": "8258.6587",
                                "monoisotopic_mz": "826.8731",
                                "intensity": "961.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "31",
                                "monoisotopic_mass": "3078.6467",
                                "monoisotopic_mz": "770.6690",
                                "intensity": "2314.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "32",
                                "monoisotopic_mass": "2809.5135",
                                "monoisotopic_mz": "937.5118",
                                "intensity": "1941.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "33",
                                "monoisotopic_mass": "1660.9236",
                                "monoisotopic_mz": "831.4691",
                                "intensity": "1778.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "34",
                                "monoisotopic_mass": "1532.8325",
                                "monoisotopic_mz": "767.4235",
                                "intensity": "1242.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "35",
                                "monoisotopic_mass": "1340.7022",
                                "monoisotopic_mz": "671.3584",
                                "intensity": "543.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "36",
                                "monoisotopic_mass": "1499.1667",
                                "monoisotopic_mz": "750.5906",
                                "intensity": "2974.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "37",
                                "monoisotopic_mass": "5106.5896",
                                "monoisotopic_mz": "852.1055",
                                "intensity": "1424.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "38",
                                "monoisotopic_mass": "2304.2387",
                                "monoisotopic_mz": "769.0868",
                                "intensity": "3800.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "39",
                                "monoisotopic_mass": "848.2399",
                                "monoisotopic_mz": "849.2472",
                                "intensity": "583.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "40",
                                "monoisotopic_mass": "4348.7033",
                                "monoisotopic_mz": "870.7479",
                                "intensity": "839.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "41",
                                "monoisotopic_mass": "1397.2488",
                                "monoisotopic_mz": "699.6317",
                                "intensity": "766.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "42",
                                "monoisotopic_mass": "780.8330",
                                "monoisotopic_mz": "781.8402",
                                "intensity": "747.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "152",
                                "peak_id": "43",
                                "monoisotopic_mass": "957.1939",
                                "monoisotopic_mz": "958.2012",
                                "intensity": "915.87",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "18",
                                        "ion_display_position": "72",
                                        "spec_id": "152",
                                        "peak_id": "15",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "152",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "152",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "152",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "152",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "152",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "152",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "98",
                "p_value": "1.85e-05",
                "e_value": "1.85e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "371",
                        "ms1_scans": "488",
                        "ids": "116",
                        "scans": "489",
                        "precursor_mono_mass": "9217.9651",
                        "precursor_charge": "13",
                        "precursor_mz": "710.0815",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "116",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5782",
                                "monoisotopic_mz": "784.2703",
                                "intensity": "24462.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6426",
                                "monoisotopic_mz": "800.7810",
                                "intensity": "10235.07",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0045",
                                        "ppm": "-0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "2",
                                "monoisotopic_mass": "4495.4848",
                                "monoisotopic_mz": "750.2547",
                                "intensity": "12081.80",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0040",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5236",
                                "monoisotopic_mz": "762.2612",
                                "intensity": "14499.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8122",
                                "monoisotopic_mz": "737.4134",
                                "intensity": "5269.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0022",
                                        "ppm": "1.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "5",
                                "monoisotopic_mass": "4699.5715",
                                "monoisotopic_mz": "672.3746",
                                "intensity": "10069.54",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0072",
                                        "ppm": "-1.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "6",
                                "monoisotopic_mass": "4642.5584",
                                "monoisotopic_mz": "774.7670",
                                "intensity": "5766.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0011",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "7",
                                "monoisotopic_mass": "4682.5585",
                                "monoisotopic_mz": "781.4337",
                                "intensity": "4548.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "8",
                                "monoisotopic_mass": "4154.1435",
                                "monoisotopic_mz": "1039.5432",
                                "intensity": "4209.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "9",
                                "monoisotopic_mass": "974.4194",
                                "monoisotopic_mz": "975.4266",
                                "intensity": "1988.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "10",
                                "monoisotopic_mass": "2791.5067",
                                "monoisotopic_mz": "931.5095",
                                "intensity": "2274.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0095265213",
                                        "theoretical_mass": "2791.5076",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "11",
                                "monoisotopic_mass": "806.9424",
                                "monoisotopic_mz": "807.9497",
                                "intensity": "1802.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "12",
                                "monoisotopic_mass": "2809.5153",
                                "monoisotopic_mz": "937.5124",
                                "intensity": "3159.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "13",
                                "monoisotopic_mass": "4136.1402",
                                "monoisotopic_mz": "1035.0423",
                                "intensity": "1143.84",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0095265213",
                                        "theoretical_mass": "4136.1485",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0082",
                                        "ppm": "-1.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "14",
                                "monoisotopic_mass": "4985.7774",
                                "monoisotopic_mz": "831.9702",
                                "intensity": "2393.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "15",
                                "monoisotopic_mass": "2446.8526",
                                "monoisotopic_mz": "816.6248",
                                "intensity": "831.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "16",
                                "monoisotopic_mass": "1499.8338",
                                "monoisotopic_mz": "750.9242",
                                "intensity": "2829.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "17",
                                "monoisotopic_mass": "2975.3082",
                                "monoisotopic_mz": "744.8343",
                                "intensity": "1515.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "18",
                                "monoisotopic_mass": "8367.6691",
                                "monoisotopic_mz": "761.7045",
                                "intensity": "2297.06",
                                "charge": "11"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "19",
                                "monoisotopic_mass": "544.2123",
                                "monoisotopic_mz": "545.2196",
                                "intensity": "944.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "20",
                                "monoisotopic_mass": "731.1541",
                                "monoisotopic_mz": "732.1614",
                                "intensity": "1071.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "21",
                                "monoisotopic_mass": "4510.5002",
                                "monoisotopic_mz": "752.7573",
                                "intensity": "1701.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "22",
                                "monoisotopic_mass": "640.3542",
                                "monoisotopic_mz": "641.3614",
                                "intensity": "801.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "23",
                                "monoisotopic_mass": "1404.7562",
                                "monoisotopic_mz": "703.3854",
                                "intensity": "565.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "24",
                                "monoisotopic_mass": "9060.9421",
                                "monoisotopic_mz": "756.0858",
                                "intensity": "846.85",
                                "charge": "12"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "25",
                                "monoisotopic_mass": "830.6279",
                                "monoisotopic_mz": "831.6352",
                                "intensity": "1926.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "26",
                                "monoisotopic_mass": "1637.5775",
                                "monoisotopic_mz": "819.7960",
                                "intensity": "1449.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "27",
                                "monoisotopic_mass": "1285.5716",
                                "monoisotopic_mz": "643.7931",
                                "intensity": "658.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "28",
                                "monoisotopic_mass": "2762.4759",
                                "monoisotopic_mz": "921.8326",
                                "intensity": "777.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "29",
                                "monoisotopic_mass": "1340.7563",
                                "monoisotopic_mz": "671.3854",
                                "intensity": "2870.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "30",
                                "monoisotopic_mass": "4229.2570",
                                "monoisotopic_mz": "705.8834",
                                "intensity": "1976.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "31",
                                "monoisotopic_mass": "1445.8152",
                                "monoisotopic_mz": "723.9149",
                                "intensity": "558.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "32",
                                "monoisotopic_mass": "1423.9347",
                                "monoisotopic_mz": "712.9746",
                                "intensity": "1012.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "33",
                                "monoisotopic_mass": "699.6865",
                                "monoisotopic_mz": "700.6938",
                                "intensity": "976.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "34",
                                "monoisotopic_mass": "3279.7225",
                                "monoisotopic_mz": "820.9379",
                                "intensity": "1045.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "35",
                                "monoisotopic_mass": "1372.7588",
                                "monoisotopic_mz": "687.3867",
                                "intensity": "444.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "36",
                                "monoisotopic_mass": "771.7571",
                                "monoisotopic_mz": "772.7643",
                                "intensity": "551.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "37",
                                "monoisotopic_mass": "3718.7297",
                                "monoisotopic_mz": "744.7532",
                                "intensity": "551.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "116",
                                "peak_id": "38",
                                "monoisotopic_mass": "785.9269",
                                "monoisotopic_mz": "786.9342",
                                "intensity": "757.90",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9217.9851",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "116",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "116",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "116",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "116",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "116",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "116",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "116",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "116",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "28",
                            "anno": "-2.0095",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "114",
                "p_value": "2.14e-05",
                "e_value": "2.14e-05",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "413",
                        "ms1_scans": "547",
                        "ids": "134",
                        "scans": "549",
                        "precursor_mono_mass": "9218.9784",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1595",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "134",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5826",
                                "monoisotopic_mz": "784.2710",
                                "intensity": "28296.54",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0039",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4925",
                                "monoisotopic_mz": "750.2560",
                                "intensity": "10782.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0037",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6470",
                                "monoisotopic_mz": "800.7818",
                                "intensity": "7458.98",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5233",
                                "monoisotopic_mz": "762.2612",
                                "intensity": "8966.08",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "4",
                                "monoisotopic_mass": "4700.5871",
                                "monoisotopic_mz": "672.5197",
                                "intensity": "8278.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "5",
                                "monoisotopic_mass": "4682.5622",
                                "monoisotopic_mz": "781.4343",
                                "intensity": "5132.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "6",
                                "monoisotopic_mass": "2320.7801",
                                "monoisotopic_mz": "774.6006",
                                "intensity": "4576.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "7",
                                "monoisotopic_mass": "1472.8102",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "6167.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0002",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "8",
                                "monoisotopic_mass": "1455.7834",
                                "monoisotopic_mz": "728.8990",
                                "intensity": "1886.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "9",
                                "monoisotopic_mass": "8865.6691",
                                "monoisotopic_mz": "739.8130",
                                "intensity": "1702.13",
                                "charge": "12"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "10",
                                "monoisotopic_mass": "4509.5041",
                                "monoisotopic_mz": "752.5913",
                                "intensity": "1190.01",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "11",
                                "monoisotopic_mass": "4138.1710",
                                "monoisotopic_mz": "1035.5500",
                                "intensity": "892.68",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0130",
                                        "ppm": "3.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "12",
                                "monoisotopic_mass": "2808.5098",
                                "monoisotopic_mz": "937.1772",
                                "intensity": "1948.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "13",
                                "monoisotopic_mass": "974.4186",
                                "monoisotopic_mz": "975.4258",
                                "intensity": "1631.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "14",
                                "monoisotopic_mass": "1389.1379",
                                "monoisotopic_mz": "695.5762",
                                "intensity": "653.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "15",
                                "monoisotopic_mass": "2924.9802",
                                "monoisotopic_mz": "732.2523",
                                "intensity": "2480.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "16",
                                "monoisotopic_mass": "724.9049",
                                "monoisotopic_mz": "725.9122",
                                "intensity": "844.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "17",
                                "monoisotopic_mass": "753.4007",
                                "monoisotopic_mz": "754.4080",
                                "intensity": "766.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "18",
                                "monoisotopic_mass": "1339.2075",
                                "monoisotopic_mz": "670.6110",
                                "intensity": "1277.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "19",
                                "monoisotopic_mass": "670.3782",
                                "monoisotopic_mz": "671.3854",
                                "intensity": "1574.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "20",
                                "monoisotopic_mass": "1493.1568",
                                "monoisotopic_mz": "747.5857",
                                "intensity": "1686.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "21",
                                "monoisotopic_mass": "1416.7638",
                                "monoisotopic_mz": "709.3892",
                                "intensity": "902.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "22",
                                "monoisotopic_mass": "4907.9825",
                                "monoisotopic_mz": "702.1476",
                                "intensity": "2270.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "23",
                                "monoisotopic_mass": "930.8343",
                                "monoisotopic_mz": "931.8416",
                                "intensity": "1849.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "24",
                                "monoisotopic_mass": "5656.9292",
                                "monoisotopic_mz": "708.1234",
                                "intensity": "1221.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "25",
                                "monoisotopic_mass": "8441.8722",
                                "monoisotopic_mz": "704.4966",
                                "intensity": "1945.37",
                                "charge": "12"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "26",
                                "monoisotopic_mass": "4338.2718",
                                "monoisotopic_mz": "724.0526",
                                "intensity": "1864.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "27",
                                "monoisotopic_mass": "807.6937",
                                "monoisotopic_mz": "808.7010",
                                "intensity": "805.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "134",
                                "peak_id": "28",
                                "monoisotopic_mass": "707.3639",
                                "monoisotopic_mz": "708.3712",
                                "intensity": "454.84",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "134",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "134",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "134",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "134",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "134",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "12",
                "p_value": "3.54e-05",
                "e_value": "3.54e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "26",
                        "ms1_scans": "41",
                        "ids": "14",
                        "scans": "42",
                        "precursor_mono_mass": "9217.9708",
                        "precursor_charge": "12",
                        "precursor_mz": "769.1715",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "14",
                                "peak_id": "0",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "21358.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0006",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "45577.95",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7306",
                                "monoisotopic_mz": "819.6290",
                                "intensity": "13689.90",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "3",
                                "monoisotopic_mass": "4642.5610",
                                "monoisotopic_mz": "774.7674",
                                "intensity": "11665.60",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0037",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "4",
                                "monoisotopic_mass": "4681.5569",
                                "monoisotopic_mz": "781.2668",
                                "intensity": "9585.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "5",
                                "monoisotopic_mass": "4567.5313",
                                "monoisotopic_mz": "762.2625",
                                "intensity": "9090.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "6",
                                "monoisotopic_mass": "4154.1523",
                                "monoisotopic_mz": "1039.5454",
                                "intensity": "4076.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "7",
                                "monoisotopic_mass": "4665.5817",
                                "monoisotopic_mz": "778.6042",
                                "intensity": "4281.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "8",
                                "monoisotopic_mass": "4495.4848",
                                "monoisotopic_mz": "750.2548",
                                "intensity": "3228.74",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0040",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "9",
                                "monoisotopic_mass": "1472.8097",
                                "monoisotopic_mz": "737.4121",
                                "intensity": "5494.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "10",
                                "monoisotopic_mass": "6057.2593",
                                "monoisotopic_mz": "866.3300",
                                "intensity": "8236.09",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6056.2560",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0009",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "11",
                                "monoisotopic_mass": "4782.6308",
                                "monoisotopic_mz": "798.1124",
                                "intensity": "2264.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "12",
                                "monoisotopic_mass": "4980.7584",
                                "monoisotopic_mz": "831.1337",
                                "intensity": "1947.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "13",
                                "monoisotopic_mass": "4135.1431",
                                "monoisotopic_mz": "1034.7930",
                                "intensity": "1349.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "14",
                                "monoisotopic_mass": "1523.3231",
                                "monoisotopic_mz": "762.6688",
                                "intensity": "2315.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "15",
                                "monoisotopic_mass": "3068.6509",
                                "monoisotopic_mz": "768.1700",
                                "intensity": "2333.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "16",
                                "monoisotopic_mass": "1593.8960",
                                "monoisotopic_mz": "797.9553",
                                "intensity": "2518.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "17",
                                "monoisotopic_mass": "2311.7645",
                                "monoisotopic_mz": "771.5954",
                                "intensity": "2022.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "18",
                                "monoisotopic_mass": "5846.1769",
                                "monoisotopic_mz": "731.7794",
                                "intensity": "1021.36",
                                "charge": "8"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "19",
                                "monoisotopic_mass": "6548.4446",
                                "monoisotopic_mz": "728.6122",
                                "intensity": "749.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "20",
                                "monoisotopic_mass": "815.9496",
                                "monoisotopic_mz": "816.9568",
                                "intensity": "1115.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "21",
                                "monoisotopic_mass": "9001.8824",
                                "monoisotopic_mz": "819.3602",
                                "intensity": "738.28",
                                "charge": "11"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "22",
                                "monoisotopic_mass": "769.6630",
                                "monoisotopic_mz": "770.6702",
                                "intensity": "896.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "23",
                                "monoisotopic_mass": "1774.5966",
                                "monoisotopic_mz": "888.3056",
                                "intensity": "1702.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "24",
                                "monoisotopic_mass": "750.4011",
                                "monoisotopic_mz": "751.4083",
                                "intensity": "1547.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "25",
                                "monoisotopic_mass": "853.3187",
                                "monoisotopic_mz": "854.3259",
                                "intensity": "938.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "26",
                                "monoisotopic_mass": "6141.9420",
                                "monoisotopic_mz": "768.7500",
                                "intensity": "1000.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "27",
                                "monoisotopic_mass": "865.3215",
                                "monoisotopic_mz": "866.3287",
                                "intensity": "2506.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "28",
                                "monoisotopic_mass": "1455.7823",
                                "monoisotopic_mz": "728.8984",
                                "intensity": "703.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "29",
                                "monoisotopic_mass": "3226.7631",
                                "monoisotopic_mz": "807.6980",
                                "intensity": "3000.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "30",
                                "monoisotopic_mass": "4608.4613",
                                "monoisotopic_mz": "769.0842",
                                "intensity": "6188.08",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "31",
                                "monoisotopic_mass": "670.3779",
                                "monoisotopic_mz": "671.3851",
                                "intensity": "974.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "32",
                                "monoisotopic_mass": "974.4205",
                                "monoisotopic_mz": "975.4277",
                                "intensity": "1930.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "33",
                                "monoisotopic_mass": "789.2686",
                                "monoisotopic_mz": "790.2759",
                                "intensity": "967.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "34",
                                "monoisotopic_mass": "4834.2580",
                                "monoisotopic_mz": "806.7169",
                                "intensity": "1134.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "35",
                                "monoisotopic_mass": "2488.1193",
                                "monoisotopic_mz": "830.3804",
                                "intensity": "1675.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "36",
                                "monoisotopic_mass": "6242.3504",
                                "monoisotopic_mz": "892.7716",
                                "intensity": "2761.08",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6242.3564",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0060",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "37",
                                "monoisotopic_mass": "889.1863",
                                "monoisotopic_mz": "890.1935",
                                "intensity": "1319.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "38",
                                "monoisotopic_mass": "2416.6852",
                                "monoisotopic_mz": "806.5690",
                                "intensity": "648.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "39",
                                "monoisotopic_mass": "736.3873",
                                "monoisotopic_mz": "737.3946",
                                "intensity": "766.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "40",
                                "monoisotopic_mass": "1850.5898",
                                "monoisotopic_mz": "926.3022",
                                "intensity": "1210.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "41",
                                "monoisotopic_mass": "1442.4618",
                                "monoisotopic_mz": "722.2382",
                                "intensity": "649.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "42",
                                "monoisotopic_mass": "931.5021",
                                "monoisotopic_mz": "932.5094",
                                "intensity": "1515.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "43",
                                "monoisotopic_mass": "831.9635",
                                "monoisotopic_mz": "832.9707",
                                "intensity": "1195.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "44",
                                "monoisotopic_mass": "5771.3671",
                                "monoisotopic_mz": "825.4883",
                                "intensity": "1075.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "45",
                                "monoisotopic_mass": "703.7910",
                                "monoisotopic_mz": "704.7983",
                                "intensity": "1082.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "46",
                                "monoisotopic_mass": "957.9071",
                                "monoisotopic_mz": "958.9143",
                                "intensity": "723.84",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.2458",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "spec_id": "14",
                                        "peak_id": "36",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "14",
                                        "peak_id": "10",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "14",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "14",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "14",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "14",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "14",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "14",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "30",
                            "anno": "-1.7488",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "164",
                "p_value": "3.63e-05",
                "e_value": "3.63e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "791",
                        "ms1_scans": "981",
                        "ids": "190",
                        "scans": "983",
                        "precursor_mono_mass": "9217.9754",
                        "precursor_charge": "13",
                        "precursor_mz": "710.0823",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "190",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5771",
                                "monoisotopic_mz": "784.2701",
                                "intensity": "23041.03",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6511",
                                "monoisotopic_mz": "800.7825",
                                "intensity": "12993.08",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0039",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5346",
                                "monoisotopic_mz": "762.2631",
                                "intensity": "6833.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "3",
                                "monoisotopic_mass": "1472.8089",
                                "monoisotopic_mz": "737.4117",
                                "intensity": "4655.02",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "4",
                                "monoisotopic_mass": "4699.5757",
                                "monoisotopic_mz": "672.3752",
                                "intensity": "11051.77",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "5",
                                "monoisotopic_mass": "2247.7456",
                                "monoisotopic_mz": "750.2558",
                                "intensity": "2838.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "6",
                                "monoisotopic_mass": "4982.7579",
                                "monoisotopic_mz": "831.4669",
                                "intensity": "4892.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0104",
                                        "ppm": "-2.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "7",
                                "monoisotopic_mass": "2456.8659",
                                "monoisotopic_mz": "819.9626",
                                "intensity": "2993.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "8",
                                "monoisotopic_mass": "4363.4309",
                                "monoisotopic_mz": "728.2458",
                                "intensity": "3469.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "9",
                                "monoisotopic_mass": "2791.4979",
                                "monoisotopic_mz": "931.5066",
                                "intensity": "2510.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0142165213",
                                        "theoretical_mass": "2791.5029",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0050",
                                        "ppm": "-1.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "10",
                                "monoisotopic_mass": "1499.4998",
                                "monoisotopic_mz": "750.7572",
                                "intensity": "5372.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "11",
                                "monoisotopic_mass": "3061.6489",
                                "monoisotopic_mz": "1021.5569",
                                "intensity": "1107.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "12",
                                "monoisotopic_mass": "4643.5592",
                                "monoisotopic_mz": "774.9338",
                                "intensity": "1155.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "13",
                                "monoisotopic_mass": "2998.3290",
                                "monoisotopic_mz": "750.5895",
                                "intensity": "3239.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "14",
                                "monoisotopic_mass": "3061.6528",
                                "monoisotopic_mz": "766.4205",
                                "intensity": "1090.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "15",
                                "monoisotopic_mass": "2231.9855",
                                "monoisotopic_mz": "745.0024",
                                "intensity": "1396.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "16",
                                "monoisotopic_mass": "974.4187",
                                "monoisotopic_mz": "975.4260",
                                "intensity": "1214.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "17",
                                "monoisotopic_mass": "1340.7549",
                                "monoisotopic_mz": "671.3847",
                                "intensity": "1709.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "18",
                                "monoisotopic_mass": "2975.6256",
                                "monoisotopic_mz": "744.9137",
                                "intensity": "1607.57",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0142165213",
                                        "theoretical_mass": "2975.6241",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0015",
                                        "ppm": "0.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "19",
                                "monoisotopic_mass": "2808.5077",
                                "monoisotopic_mz": "937.1765",
                                "intensity": "2154.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "20",
                                "monoisotopic_mass": "3505.7834",
                                "monoisotopic_mz": "702.1640",
                                "intensity": "728.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "21",
                                "monoisotopic_mass": "7692.3765",
                                "monoisotopic_mz": "700.3142",
                                "intensity": "1039.20",
                                "charge": "11"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "22",
                                "monoisotopic_mass": "4137.1475",
                                "monoisotopic_mz": "1035.2941",
                                "intensity": "5038.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "23",
                                "monoisotopic_mass": "1455.7839",
                                "monoisotopic_mz": "728.8992",
                                "intensity": "435.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "24",
                                "monoisotopic_mass": "4683.5643",
                                "monoisotopic_mz": "670.0879",
                                "intensity": "1012.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "25",
                                "monoisotopic_mass": "5901.9006",
                                "monoisotopic_mz": "844.1359",
                                "intensity": "957.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "26",
                                "monoisotopic_mass": "1296.2533",
                                "monoisotopic_mz": "649.1339",
                                "intensity": "458.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "27",
                                "monoisotopic_mass": "2680.4382",
                                "monoisotopic_mz": "894.4867",
                                "intensity": "785.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0052",
                                        "ppm": "1.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "28",
                                "monoisotopic_mass": "1381.7523",
                                "monoisotopic_mz": "691.8834",
                                "intensity": "690.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "29",
                                "monoisotopic_mass": "3123.3874",
                                "monoisotopic_mz": "781.8541",
                                "intensity": "1178.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "30",
                                "monoisotopic_mass": "642.3547",
                                "monoisotopic_mz": "643.3620",
                                "intensity": "1318.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "31",
                                "monoisotopic_mass": "780.4239",
                                "monoisotopic_mz": "781.4312",
                                "intensity": "727.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "32",
                                "monoisotopic_mass": "800.6089",
                                "monoisotopic_mz": "801.6162",
                                "intensity": "435.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "33",
                                "monoisotopic_mass": "831.4610",
                                "monoisotopic_mz": "832.4683",
                                "intensity": "887.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "34",
                                "monoisotopic_mass": "1359.8049",
                                "monoisotopic_mz": "680.9097",
                                "intensity": "1508.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "35",
                                "monoisotopic_mass": "2887.4951",
                                "monoisotopic_mz": "722.8811",
                                "intensity": "1157.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "36",
                                "monoisotopic_mass": "2280.1792",
                                "monoisotopic_mz": "761.0670",
                                "intensity": "703.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "37",
                                "monoisotopic_mass": "1417.7942",
                                "monoisotopic_mz": "709.9044",
                                "intensity": "1355.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "38",
                                "monoisotopic_mass": "4640.5274",
                                "monoisotopic_mz": "663.9398",
                                "intensity": "1784.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "39",
                                "monoisotopic_mass": "2068.8647",
                                "monoisotopic_mz": "690.6288",
                                "intensity": "815.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "40",
                                "monoisotopic_mass": "4094.1722",
                                "monoisotopic_mz": "819.8417",
                                "intensity": "534.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "41",
                                "monoisotopic_mass": "3136.0635",
                                "monoisotopic_mz": "785.0231",
                                "intensity": "2211.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "42",
                                "monoisotopic_mass": "1436.1544",
                                "monoisotopic_mz": "719.0845",
                                "intensity": "440.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "43",
                                "monoisotopic_mass": "698.7266",
                                "monoisotopic_mz": "699.7339",
                                "intensity": "661.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "44",
                                "monoisotopic_mass": "756.1558",
                                "monoisotopic_mz": "757.1631",
                                "intensity": "782.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "190",
                                "peak_id": "45",
                                "monoisotopic_mass": "686.2160",
                                "monoisotopic_mz": "687.2232",
                                "intensity": "783.09",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9217.9805",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "190",
                                        "peak_id": "27",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "190",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "190",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "190",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "190",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "190",
                                            "peak_id": "4",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "190",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "190",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "27",
                            "right_position": "28",
                            "anno": "-2.0142",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "140",
                "p_value": "4.34e-05",
                "e_value": "4.34e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "489",
                        "ms1_scans": "653",
                        "ids": "163",
                        "scans": "654",
                        "precursor_mono_mass": "9218.9838",
                        "precursor_charge": "12",
                        "precursor_mz": "769.2559",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "163",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "45143.31",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6466",
                                "monoisotopic_mz": "800.7817",
                                "intensity": "19804.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7329",
                                "monoisotopic_mz": "819.6294",
                                "intensity": "14189.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0017",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5273",
                                "monoisotopic_mz": "762.2618",
                                "intensity": "7698.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "4",
                                "monoisotopic_mass": "4641.5642",
                                "monoisotopic_mz": "774.6013",
                                "intensity": "6865.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "5",
                                "monoisotopic_mass": "4982.7660",
                                "monoisotopic_mz": "831.4683",
                                "intensity": "5913.17",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "6",
                                "monoisotopic_mass": "4154.1577",
                                "monoisotopic_mz": "1039.5467",
                                "intensity": "6809.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "7",
                                "monoisotopic_mass": "1472.8108",
                                "monoisotopic_mz": "737.4127",
                                "intensity": "5211.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0008",
                                        "ppm": "0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "8",
                                "monoisotopic_mass": "4494.4880",
                                "monoisotopic_mz": "750.0886",
                                "intensity": "4716.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "9",
                                "monoisotopic_mass": "4682.5589",
                                "monoisotopic_mz": "781.4338",
                                "intensity": "4845.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "10",
                                "monoisotopic_mass": "3850.0586",
                                "monoisotopic_mz": "771.0190",
                                "intensity": "3370.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "11",
                                "monoisotopic_mass": "9180.8931",
                                "monoisotopic_mz": "766.0817",
                                "intensity": "2799.49",
                                "charge": "12"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "12",
                                "monoisotopic_mass": "974.4196",
                                "monoisotopic_mz": "975.4269",
                                "intensity": "1835.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "13",
                                "monoisotopic_mass": "4136.1510",
                                "monoisotopic_mz": "1035.0450",
                                "intensity": "4189.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "14",
                                "monoisotopic_mass": "4780.6214",
                                "monoisotopic_mz": "797.7775",
                                "intensity": "3222.31",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-9.5089652131e-01",
                                        "theoretical_mass": "4780.5764",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "0.0449",
                                        "ppm": "9.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "15",
                                "monoisotopic_mass": "2809.5062",
                                "monoisotopic_mz": "937.5093",
                                "intensity": "3069.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "16",
                                "monoisotopic_mass": "1535.9896",
                                "monoisotopic_mz": "769.0021",
                                "intensity": "1339.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "17",
                                "monoisotopic_mass": "3062.6565",
                                "monoisotopic_mz": "766.6714",
                                "intensity": "2542.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "18",
                                "monoisotopic_mass": "764.4104",
                                "monoisotopic_mz": "765.4177",
                                "intensity": "1487.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "19",
                                "monoisotopic_mass": "4608.4920",
                                "monoisotopic_mz": "769.0893",
                                "intensity": "948.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "20",
                                "monoisotopic_mass": "3144.7549",
                                "monoisotopic_mz": "787.1960",
                                "intensity": "1882.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "21",
                                "monoisotopic_mass": "6495.6620",
                                "monoisotopic_mz": "812.9650",
                                "intensity": "1198.15",
                                "charge": "8"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "22",
                                "monoisotopic_mass": "3325.8366",
                                "monoisotopic_mz": "832.4664",
                                "intensity": "3326.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "23",
                                "monoisotopic_mass": "865.6094",
                                "monoisotopic_mz": "866.6166",
                                "intensity": "1412.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "24",
                                "monoisotopic_mass": "6418.5000",
                                "monoisotopic_mz": "803.3198",
                                "intensity": "1047.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "25",
                                "monoisotopic_mass": "1405.7550",
                                "monoisotopic_mz": "703.8848",
                                "intensity": "584.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "26",
                                "monoisotopic_mass": "1439.8262",
                                "monoisotopic_mz": "720.9204",
                                "intensity": "539.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-9.5089652131e-01",
                                        "theoretical_mass": "1439.8250",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0012",
                                        "ppm": "0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "27",
                                "monoisotopic_mass": "879.6191",
                                "monoisotopic_mz": "880.6264",
                                "intensity": "1160.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "28",
                                "monoisotopic_mass": "815.9520",
                                "monoisotopic_mz": "816.9593",
                                "intensity": "1670.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "29",
                                "monoisotopic_mass": "6147.9848",
                                "monoisotopic_mz": "769.5054",
                                "intensity": "1840.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "30",
                                "monoisotopic_mass": "2793.5198",
                                "monoisotopic_mz": "932.1805",
                                "intensity": "1167.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "31",
                                "monoisotopic_mass": "4117.9713",
                                "monoisotopic_mz": "824.6015",
                                "intensity": "849.01",
                                "charge": "5"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "32",
                                "monoisotopic_mass": "1135.6757",
                                "monoisotopic_mz": "1136.6830",
                                "intensity": "603.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "33",
                                "monoisotopic_mass": "2909.5991",
                                "monoisotopic_mz": "728.4071",
                                "intensity": "957.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "34",
                                "monoisotopic_mass": "9083.9225",
                                "monoisotopic_mz": "826.8184",
                                "intensity": "1033.88",
                                "charge": "11"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "35",
                                "monoisotopic_mass": "8400.9127",
                                "monoisotopic_mz": "934.4420",
                                "intensity": "2101.60",
                                "charge": "9"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "36",
                                "monoisotopic_mass": "930.5013",
                                "monoisotopic_mz": "931.5085",
                                "intensity": "1487.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "37",
                                "monoisotopic_mass": "3226.7672",
                                "monoisotopic_mz": "807.6991",
                                "intensity": "2386.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "38",
                                "monoisotopic_mass": "1021.5539",
                                "monoisotopic_mz": "1022.5612",
                                "intensity": "624.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "39",
                                "monoisotopic_mass": "8972.9053",
                                "monoisotopic_mz": "816.7259",
                                "intensity": "1880.12",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.5089652131e-01",
                                        "theoretical_mass": "8973.9604",
                                        "ion_position": "2",
                                        "ion_display_position": "88",
                                        "ion_sort_name": "Y00088",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0527",
                                        "ppm": "-5.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "163",
                                "peak_id": "40",
                                "monoisotopic_mass": "714.3031",
                                "monoisotopic_mz": "715.3103",
                                "intensity": "734.52",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.0438",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "88",
                                        "spec_id": "163",
                                        "peak_id": "39",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "163",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "163",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "163",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "163",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "163",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "163",
                                        "peak_id": "14",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "163",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "2",
                            "right_position": "14",
                            "anno": "-0.9509",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "83",
                "p_value": "5.30e-05",
                "e_value": "5.30e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "315",
                        "ms1_scans": "415",
                        "ids": "100",
                        "scans": "417",
                        "precursor_mono_mass": "9217.9659",
                        "precursor_charge": "13",
                        "precursor_mz": "710.0816",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "100",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5778",
                                "monoisotopic_mz": "784.2702",
                                "intensity": "27839.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4841",
                                "monoisotopic_mz": "750.2546",
                                "intensity": "6567.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0047",
                                        "ppm": "-1.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "2",
                                "monoisotopic_mass": "4797.6395",
                                "monoisotopic_mz": "800.6139",
                                "intensity": "11753.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "3",
                                "monoisotopic_mass": "4642.5592",
                                "monoisotopic_mz": "774.7671",
                                "intensity": "5023.40",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0019",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8089",
                                "monoisotopic_mz": "737.4117",
                                "intensity": "3813.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "5",
                                "monoisotopic_mass": "4682.5585",
                                "monoisotopic_mz": "781.4337",
                                "intensity": "6899.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5752",
                                "monoisotopic_mz": "669.9466",
                                "intensity": "3623.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "7",
                                "monoisotopic_mass": "4698.5726",
                                "monoisotopic_mz": "672.2319",
                                "intensity": "10123.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "8",
                                "monoisotopic_mass": "2283.2592",
                                "monoisotopic_mz": "762.0937",
                                "intensity": "5119.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "9",
                                "monoisotopic_mass": "4155.1513",
                                "monoisotopic_mz": "1039.7951",
                                "intensity": "3068.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "10",
                                "monoisotopic_mass": "4478.4699",
                                "monoisotopic_mz": "747.4189",
                                "intensity": "5257.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "11",
                                "monoisotopic_mass": "3226.7641",
                                "monoisotopic_mz": "807.6983",
                                "intensity": "3586.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "12",
                                "monoisotopic_mass": "4798.6469",
                                "monoisotopic_mz": "686.5283",
                                "intensity": "7047.23",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "13",
                                "monoisotopic_mass": "2455.8615",
                                "monoisotopic_mz": "819.6278",
                                "intensity": "4468.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "14",
                                "monoisotopic_mass": "4666.5925",
                                "monoisotopic_mz": "778.7727",
                                "intensity": "5557.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "15",
                                "monoisotopic_mass": "2809.5116",
                                "monoisotopic_mz": "937.5112",
                                "intensity": "3735.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "16",
                                "monoisotopic_mass": "4982.7653",
                                "monoisotopic_mz": "831.4682",
                                "intensity": "2625.64",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "17",
                                "monoisotopic_mass": "698.1256",
                                "monoisotopic_mz": "699.1329",
                                "intensity": "1250.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "18",
                                "monoisotopic_mass": "1340.7541",
                                "monoisotopic_mz": "671.3843",
                                "intensity": "2632.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "19",
                                "monoisotopic_mass": "670.8791",
                                "monoisotopic_mz": "671.8864",
                                "intensity": "476.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "20",
                                "monoisotopic_mass": "2118.4980",
                                "monoisotopic_mz": "707.1733",
                                "intensity": "1928.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "21",
                                "monoisotopic_mass": "974.4189",
                                "monoisotopic_mz": "975.4261",
                                "intensity": "1397.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "22",
                                "monoisotopic_mass": "2793.5064",
                                "monoisotopic_mz": "932.1761",
                                "intensity": "2339.42",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0107",
                                        "ppm": "-3.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "23",
                                "monoisotopic_mass": "5521.9128",
                                "monoisotopic_mz": "789.8520",
                                "intensity": "656.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "24",
                                "monoisotopic_mass": "3044.6792",
                                "monoisotopic_mz": "762.1771",
                                "intensity": "2997.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "25",
                                "monoisotopic_mass": "4643.5659",
                                "monoisotopic_mz": "664.3738",
                                "intensity": "3627.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "26",
                                "monoisotopic_mass": "727.4043",
                                "monoisotopic_mz": "728.4116",
                                "intensity": "1090.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "27",
                                "monoisotopic_mass": "1404.7555",
                                "monoisotopic_mz": "703.3850",
                                "intensity": "582.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "28",
                                "monoisotopic_mass": "6541.4254",
                                "monoisotopic_mz": "727.8323",
                                "intensity": "1022.81",
                                "charge": "9"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "29",
                                "monoisotopic_mass": "1455.7818",
                                "monoisotopic_mz": "728.8982",
                                "intensity": "1004.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "30",
                                "monoisotopic_mass": "754.9625",
                                "monoisotopic_mz": "755.9698",
                                "intensity": "883.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "31",
                                "monoisotopic_mass": "1417.5233",
                                "monoisotopic_mz": "709.7689",
                                "intensity": "1023.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "32",
                                "monoisotopic_mass": "1489.8184",
                                "monoisotopic_mz": "745.9165",
                                "intensity": "544.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "33",
                                "monoisotopic_mass": "2679.4258",
                                "monoisotopic_mz": "670.8637",
                                "intensity": "1073.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "34",
                                "monoisotopic_mass": "3142.7449",
                                "monoisotopic_mz": "786.6935",
                                "intensity": "1852.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "35",
                                "monoisotopic_mass": "4047.9643",
                                "monoisotopic_mz": "579.2879",
                                "intensity": "721.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "36",
                                "monoisotopic_mass": "5302.7668",
                                "monoisotopic_mz": "663.8531",
                                "intensity": "792.49",
                                "charge": "8"
                            },
                            {
                                "spec_id": "100",
                                "peak_id": "37",
                                "monoisotopic_mass": "711.9712",
                                "monoisotopic_mz": "712.9785",
                                "intensity": "1124.67",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.2409",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "100",
                                        "peak_id": "22",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "100",
                                        "peak_id": "16",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "100",
                                        "peak_id": "12",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "100",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "100",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "100",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "100",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "28",
                            "right_position": "42",
                            "anno": "-1.7537",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "9",
                "p_value": "8.24e-05",
                "e_value": "8.24e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "18",
                        "ms1_scans": "28",
                        "ids": "10",
                        "scans": "30",
                        "precursor_mono_mass": "9217.9715",
                        "precursor_charge": "13",
                        "precursor_mz": "710.0820",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "10",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5774",
                                "monoisotopic_mz": "784.2702",
                                "intensity": "32868.46",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5792",
                                "monoisotopic_mz": "672.3757",
                                "intensity": "10097.50",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0005",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "2",
                                "monoisotopic_mass": "4797.6403",
                                "monoisotopic_mz": "800.6140",
                                "intensity": "13855.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "3",
                                "monoisotopic_mass": "4495.4823",
                                "monoisotopic_mz": "750.2543",
                                "intensity": "11081.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0066",
                                        "ppm": "-1.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5302",
                                "monoisotopic_mz": "762.2623",
                                "intensity": "9790.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8093",
                                "monoisotopic_mz": "737.4119",
                                "intensity": "6331.80",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5552",
                                "monoisotopic_mz": "781.4331",
                                "intensity": "8168.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "7",
                                "monoisotopic_mass": "2904.5865",
                                "monoisotopic_mz": "727.1539",
                                "intensity": "2968.74",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0131865213",
                                        "theoretical_mass": "2904.5880",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "8",
                                "monoisotopic_mass": "4781.6098",
                                "monoisotopic_mz": "797.9422",
                                "intensity": "3149.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "9",
                                "monoisotopic_mass": "2793.5060",
                                "monoisotopic_mz": "932.1760",
                                "intensity": "3864.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0111",
                                        "ppm": "-3.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "10",
                                "monoisotopic_mass": "2680.4274",
                                "monoisotopic_mz": "894.4831",
                                "intensity": "2146.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0056",
                                        "ppm": "-2.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "11",
                                "monoisotopic_mass": "2810.5105",
                                "monoisotopic_mz": "937.8441",
                                "intensity": "2118.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "12",
                                "monoisotopic_mass": "2792.4999",
                                "monoisotopic_mz": "699.1322",
                                "intensity": "1865.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "13",
                                "monoisotopic_mass": "974.4189",
                                "monoisotopic_mz": "975.4261",
                                "intensity": "2827.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "14",
                                "monoisotopic_mass": "6549.4483",
                                "monoisotopic_mz": "728.7238",
                                "intensity": "933.98",
                                "charge": "9"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "15",
                                "monoisotopic_mass": "1454.8106",
                                "monoisotopic_mz": "728.4126",
                                "intensity": "1947.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "16",
                                "monoisotopic_mass": "2905.5769",
                                "monoisotopic_mz": "969.5329",
                                "intensity": "1851.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "17",
                                "monoisotopic_mass": "1341.7597",
                                "monoisotopic_mz": "671.8871",
                                "intensity": "2651.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "18",
                                "monoisotopic_mass": "4942.1959",
                                "monoisotopic_mz": "707.0353",
                                "intensity": "1142.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "19",
                                "monoisotopic_mass": "5617.9934",
                                "monoisotopic_mz": "703.2564",
                                "intensity": "1152.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "20",
                                "monoisotopic_mass": "1637.5758",
                                "monoisotopic_mz": "819.7952",
                                "intensity": "2706.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "21",
                                "monoisotopic_mass": "3062.6562",
                                "monoisotopic_mz": "766.6713",
                                "intensity": "2038.02",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-2.0131865213",
                                        "theoretical_mass": "3062.6571",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "22",
                                "monoisotopic_mass": "806.9429",
                                "monoisotopic_mz": "807.9502",
                                "intensity": "3148.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "23",
                                "monoisotopic_mass": "710.9675",
                                "monoisotopic_mz": "711.9748",
                                "intensity": "922.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "24",
                                "monoisotopic_mass": "3762.1022",
                                "monoisotopic_mz": "753.4277",
                                "intensity": "832.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "25",
                                "monoisotopic_mass": "773.9274",
                                "monoisotopic_mz": "774.9347",
                                "intensity": "2075.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "26",
                                "monoisotopic_mass": "785.9388",
                                "monoisotopic_mz": "786.9461",
                                "intensity": "1276.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "27",
                                "monoisotopic_mass": "1384.7193",
                                "monoisotopic_mz": "693.3669",
                                "intensity": "516.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "28",
                                "monoisotopic_mass": "2097.4216",
                                "monoisotopic_mz": "700.1478",
                                "intensity": "896.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "29",
                                "monoisotopic_mass": "1472.8110",
                                "monoisotopic_mz": "491.9443",
                                "intensity": "496.98",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0010",
                                        "ppm": "0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "30",
                                "monoisotopic_mass": "744.3298",
                                "monoisotopic_mz": "745.3370",
                                "intensity": "1625.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "31",
                                "monoisotopic_mass": "1034.5345",
                                "monoisotopic_mz": "1035.5417",
                                "intensity": "1051.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "32",
                                "monoisotopic_mass": "1422.9370",
                                "monoisotopic_mz": "712.4758",
                                "intensity": "472.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "33",
                                "monoisotopic_mass": "2128.3106",
                                "monoisotopic_mz": "710.4441",
                                "intensity": "1869.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "34",
                                "monoisotopic_mass": "3322.5111",
                                "monoisotopic_mz": "831.6350",
                                "intensity": "3001.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "35",
                                "monoisotopic_mass": "2307.8468",
                                "monoisotopic_mz": "770.2895",
                                "intensity": "1007.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "36",
                                "monoisotopic_mass": "1366.1833",
                                "monoisotopic_mz": "684.0989",
                                "intensity": "1132.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "37",
                                "monoisotopic_mass": "7797.7345",
                                "monoisotopic_mz": "709.8922",
                                "intensity": "947.66",
                                "charge": "11"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "38",
                                "monoisotopic_mass": "2742.7983",
                                "monoisotopic_mz": "686.7069",
                                "intensity": "2291.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "39",
                                "monoisotopic_mass": "5163.2692",
                                "monoisotopic_mz": "738.6172",
                                "intensity": "2115.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "40",
                                "monoisotopic_mass": "820.2912",
                                "monoisotopic_mz": "821.2985",
                                "intensity": "378.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "41",
                                "monoisotopic_mass": "2681.5104",
                                "monoisotopic_mz": "671.3849",
                                "intensity": "981.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "42",
                                "monoisotopic_mass": "1167.6186",
                                "monoisotopic_mz": "584.8166",
                                "intensity": "585.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "43",
                                "monoisotopic_mass": "7738.1040",
                                "monoisotopic_mz": "704.4713",
                                "intensity": "1213.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "44",
                                "monoisotopic_mass": "1199.1271",
                                "monoisotopic_mz": "600.5708",
                                "intensity": "547.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "45",
                                "monoisotopic_mass": "759.0791",
                                "monoisotopic_mz": "760.0864",
                                "intensity": "741.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "46",
                                "monoisotopic_mass": "1020.2004",
                                "monoisotopic_mz": "1021.2077",
                                "intensity": "707.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "47",
                                "monoisotopic_mass": "669.3652",
                                "monoisotopic_mz": "670.3725",
                                "intensity": "500.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "48",
                                "monoisotopic_mass": "842.9757",
                                "monoisotopic_mz": "843.9830",
                                "intensity": "916.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "10",
                                "peak_id": "49",
                                "monoisotopic_mass": "4257.7226",
                                "monoisotopic_mz": "710.6277",
                                "intensity": "1398.72",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9217.9815",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "10",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "10",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "10",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "10",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "10",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "10",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "10",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "10",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "10",
                                            "peak_id": "29",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "28",
                            "right_position": "29",
                            "anno": "-2.0132",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "135",
                "p_value": "9.16e-05",
                "e_value": "9.16e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "472",
                        "ms1_scans": "631",
                        "ids": "158",
                        "scans": "632",
                        "precursor_mono_mass": "9218.9752",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1592",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "158",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5800",
                                "monoisotopic_mz": "784.2706",
                                "intensity": "29401.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "1",
                                "monoisotopic_mass": "4567.5266",
                                "monoisotopic_mz": "762.2617",
                                "intensity": "12834.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5830",
                                "monoisotopic_mz": "672.3763",
                                "intensity": "10220.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "3",
                                "monoisotopic_mass": "4797.6517",
                                "monoisotopic_mz": "800.6159",
                                "intensity": "7436.46",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "4797.6477",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0040",
                                        "ppm": "0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "4",
                                "monoisotopic_mass": "4494.4906",
                                "monoisotopic_mz": "750.0890",
                                "intensity": "7857.02",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "4494.4894",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0012",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5598",
                                "monoisotopic_mz": "781.2672",
                                "intensity": "6452.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8114",
                                "monoisotopic_mz": "737.4130",
                                "intensity": "6526.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0014",
                                        "ppm": "0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "7",
                                "monoisotopic_mass": "4641.5517",
                                "monoisotopic_mz": "774.5992",
                                "intensity": "6763.37",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "4641.5578",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0061",
                                        "ppm": "-1.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "8",
                                "monoisotopic_mass": "4642.5607",
                                "monoisotopic_mz": "664.2302",
                                "intensity": "6553.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "9",
                                "monoisotopic_mass": "4666.5994",
                                "monoisotopic_mz": "778.7738",
                                "intensity": "4989.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "10",
                                "monoisotopic_mass": "1340.7568",
                                "monoisotopic_mz": "671.3857",
                                "intensity": "3343.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "11",
                                "monoisotopic_mass": "4362.4296",
                                "monoisotopic_mz": "728.0789",
                                "intensity": "5748.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "12",
                                "monoisotopic_mass": "974.4193",
                                "monoisotopic_mz": "975.4266",
                                "intensity": "2158.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "13",
                                "monoisotopic_mass": "4155.1649",
                                "monoisotopic_mz": "1039.7985",
                                "intensity": "2161.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "14",
                                "monoisotopic_mass": "2696.4267",
                                "monoisotopic_mz": "675.1139",
                                "intensity": "2397.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "15",
                                "monoisotopic_mass": "2194.4888",
                                "monoisotopic_mz": "732.5035",
                                "intensity": "916.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "16",
                                "monoisotopic_mass": "2791.5071",
                                "monoisotopic_mz": "931.5096",
                                "intensity": "2723.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "17",
                                "monoisotopic_mass": "4511.5076",
                                "monoisotopic_mz": "752.9252",
                                "intensity": "2633.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "18",
                                "monoisotopic_mass": "2993.6296",
                                "monoisotopic_mz": "749.4147",
                                "intensity": "1860.81",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "2993.6620",
                                        "ion_position": "61",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0324",
                                        "ppm": "-10.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "19",
                                "monoisotopic_mass": "2998.6056",
                                "monoisotopic_mz": "1000.5425",
                                "intensity": "993.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "20",
                                "monoisotopic_mass": "2808.5062",
                                "monoisotopic_mz": "937.1760",
                                "intensity": "2295.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "21",
                                "monoisotopic_mass": "797.4395",
                                "monoisotopic_mz": "798.4468",
                                "intensity": "868.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "22",
                                "monoisotopic_mass": "1492.8205",
                                "monoisotopic_mz": "747.4175",
                                "intensity": "704.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "23",
                                "monoisotopic_mass": "690.1254",
                                "monoisotopic_mz": "691.1326",
                                "intensity": "817.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "24",
                                "monoisotopic_mass": "3871.1360",
                                "monoisotopic_mz": "775.2345",
                                "intensity": "738.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "25",
                                "monoisotopic_mass": "936.8388",
                                "monoisotopic_mz": "937.8461",
                                "intensity": "560.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "26",
                                "monoisotopic_mass": "1398.7297",
                                "monoisotopic_mz": "700.3721",
                                "intensity": "657.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "27",
                                "monoisotopic_mass": "710.8314",
                                "monoisotopic_mz": "711.8387",
                                "intensity": "970.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "28",
                                "monoisotopic_mass": "4138.1397",
                                "monoisotopic_mz": "1035.5422",
                                "intensity": "747.55",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0183",
                                        "ppm": "-4.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "29",
                                "monoisotopic_mass": "5993.9028",
                                "monoisotopic_mz": "750.2451",
                                "intensity": "1864.78",
                                "charge": "8"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "30",
                                "monoisotopic_mass": "4962.8285",
                                "monoisotopic_mz": "709.9828",
                                "intensity": "978.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "31",
                                "monoisotopic_mass": "1453.2932",
                                "monoisotopic_mz": "727.6539",
                                "intensity": "603.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "32",
                                "monoisotopic_mass": "2837.0635",
                                "monoisotopic_mz": "710.2731",
                                "intensity": "1502.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "33",
                                "monoisotopic_mass": "4683.5806",
                                "monoisotopic_mz": "670.0902",
                                "intensity": "1579.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "34",
                                "monoisotopic_mass": "1594.2128",
                                "monoisotopic_mz": "798.1137",
                                "intensity": "1178.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "35",
                                "monoisotopic_mass": "1428.6363",
                                "monoisotopic_mz": "715.3254",
                                "intensity": "1060.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "36",
                                "monoisotopic_mass": "2878.6474",
                                "monoisotopic_mz": "720.6691",
                                "intensity": "840.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "37",
                                "monoisotopic_mass": "5080.7714",
                                "monoisotopic_mz": "726.8318",
                                "intensity": "2419.85",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "5080.8373",
                                        "ion_position": "41",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0659",
                                        "ppm": "-12.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "38",
                                "monoisotopic_mass": "4090.1130",
                                "monoisotopic_mz": "819.0299",
                                "intensity": "1354.95",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "39",
                                "monoisotopic_mass": "1175.9005",
                                "monoisotopic_mz": "588.9575",
                                "intensity": "514.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "40",
                                "monoisotopic_mass": "1014.2294",
                                "monoisotopic_mz": "1015.2367",
                                "intensity": "738.39",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "3",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.9952",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "158",
                                            "peak_id": "28",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "49",
                                            "spec_id": "158",
                                            "peak_id": "37",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "158",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "158",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "158",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "29",
                                        "spec_id": "158",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "158",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "61",
                            "right_position": "76",
                            "anno": "-0.9995",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "35",
                "p_value": "1.01e-04",
                "e_value": "1.01e-04",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "139",
                        "ms1_scans": "179",
                        "ids": "40",
                        "scans": "181",
                        "precursor_mono_mass": "9218.9760",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1593",
                        "feature_inte": "2.6167e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "40",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5793",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "31722.66",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4951",
                                "monoisotopic_mz": "750.2565",
                                "intensity": "8362.60",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0062",
                                        "ppm": "1.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "2",
                                "monoisotopic_mass": "4568.5267",
                                "monoisotopic_mz": "762.4284",
                                "intensity": "10842.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5839",
                                "monoisotopic_mz": "672.3764",
                                "intensity": "11515.28",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "th