prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "0",
        "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
        "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
        "proteoform_id": "1",
        "prsm_number": "28",
        "prsm": [
            {
                "prsm_id": "160",
                "p_value": "1.87e-11",
                "e_value": "1.87e-11",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "775",
                        "ms1_scans": "961",
                        "ids": "186",
                        "scans": "963",
                        "precursor_mono_mass": "9544.1812",
                        "precursor_charge": "12",
                        "precursor_mz": "796.3557",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "186",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6182",
                                "monoisotopic_mz": "797.4436",
                                "intensity": "45254.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "1",
                                "monoisotopic_mass": "4990.7732",
                                "monoisotopic_mz": "832.8028",
                                "intensity": "17626.50",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "2",
                                "monoisotopic_mass": "4877.6855",
                                "monoisotopic_mz": "813.9549",
                                "intensity": "20445.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "3",
                                "monoisotopic_mass": "5118.8291",
                                "monoisotopic_mz": "854.1455",
                                "intensity": "8396.99",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "4",
                                "monoisotopic_mass": "3348.7906",
                                "monoisotopic_mz": "838.2049",
                                "intensity": "13140.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "5",
                                "monoisotopic_mass": "1429.8294",
                                "monoisotopic_mz": "715.9220",
                                "intensity": "12943.36",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0001",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "6",
                                "monoisotopic_mass": "1785.0139",
                                "monoisotopic_mz": "893.5142",
                                "intensity": "3948.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "7",
                                "monoisotopic_mass": "1969.1358",
                                "monoisotopic_mz": "985.5752",
                                "intensity": "4430.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "8",
                                "monoisotopic_mass": "4256.2396",
                                "monoisotopic_mz": "1065.0672",
                                "intensity": "8101.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "9",
                                "monoisotopic_mass": "4760.6032",
                                "monoisotopic_mz": "794.4411",
                                "intensity": "8420.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "10",
                                "monoisotopic_mass": "1856.0552",
                                "monoisotopic_mz": "929.0349",
                                "intensity": "4595.19",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0032",
                                        "ppm": "1.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "11",
                                "monoisotopic_mass": "3021.6399",
                                "monoisotopic_mz": "756.4172",
                                "intensity": "3206.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "12",
                                "monoisotopic_mass": "3284.7721",
                                "monoisotopic_mz": "1095.9313",
                                "intensity": "2901.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "13",
                                "monoisotopic_mass": "2350.2933",
                                "monoisotopic_mz": "784.4384",
                                "intensity": "3666.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "14",
                                "monoisotopic_mass": "5100.8148",
                                "monoisotopic_mz": "851.1431",
                                "intensity": "7600.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "15",
                                "monoisotopic_mass": "2119.6227",
                                "monoisotopic_mz": "1060.8186",
                                "intensity": "4260.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "16",
                                "monoisotopic_mass": "4310.2807",
                                "monoisotopic_mz": "1078.5775",
                                "intensity": "3077.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "17",
                                "monoisotopic_mass": "2303.9864",
                                "monoisotopic_mz": "769.0027",
                                "intensity": "2416.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "18",
                                "monoisotopic_mass": "2993.5991",
                                "monoisotopic_mz": "749.4071",
                                "intensity": "3391.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "19",
                                "monoisotopic_mass": "3264.7591",
                                "monoisotopic_mz": "1089.2603",
                                "intensity": "2186.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "20",
                                "monoisotopic_mass": "4877.6886",
                                "monoisotopic_mz": "697.8199",
                                "intensity": "4042.79",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "21",
                                "monoisotopic_mass": "2210.3126",
                                "monoisotopic_mz": "737.7781",
                                "intensity": "3124.05",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0025",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "22",
                                "monoisotopic_mass": "728.9755",
                                "monoisotopic_mz": "729.9827",
                                "intensity": "1966.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "23",
                                "monoisotopic_mass": "1642.9393",
                                "monoisotopic_mz": "822.4769",
                                "intensity": "3610.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "24",
                                "monoisotopic_mass": "4326.2794",
                                "monoisotopic_mz": "1082.5771",
                                "intensity": "4834.12",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-26.9830198729",
                                        "theoretical_mass": "4326.3159",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0365",
                                        "ppm": "-8.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "25",
                                "monoisotopic_mass": "2737.1227",
                                "monoisotopic_mz": "913.3815",
                                "intensity": "2178.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "26",
                                "monoisotopic_mass": "3331.7662",
                                "monoisotopic_mz": "833.9488",
                                "intensity": "1103.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "27",
                                "monoisotopic_mass": "3396.8547",
                                "monoisotopic_mz": "1133.2922",
                                "intensity": "2415.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "28",
                                "monoisotopic_mass": "3282.7695",
                                "monoisotopic_mz": "821.6997",
                                "intensity": "1526.88",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-26.9830198729",
                                        "theoretical_mass": "3282.8024",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0329",
                                        "ppm": "-10.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "29",
                                "monoisotopic_mass": "772.6689",
                                "monoisotopic_mz": "773.6761",
                                "intensity": "1253.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "30",
                                "monoisotopic_mass": "1405.2439",
                                "monoisotopic_mz": "703.6292",
                                "intensity": "2726.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "31",
                                "monoisotopic_mass": "816.4417",
                                "monoisotopic_mz": "817.4490",
                                "intensity": "1175.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "32",
                                "monoisotopic_mass": "3065.6414",
                                "monoisotopic_mz": "767.4176",
                                "intensity": "1597.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "33",
                                "monoisotopic_mass": "1070.9095",
                                "monoisotopic_mz": "1071.9167",
                                "intensity": "1251.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "34",
                                "monoisotopic_mass": "850.1612",
                                "monoisotopic_mz": "851.1685",
                                "intensity": "1060.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "35",
                                "monoisotopic_mass": "2923.5676",
                                "monoisotopic_mz": "731.8992",
                                "intensity": "3149.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "36",
                                "monoisotopic_mass": "3447.8592",
                                "monoisotopic_mz": "862.9721",
                                "intensity": "4495.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "37",
                                "monoisotopic_mass": "7665.7718",
                                "monoisotopic_mz": "767.5845",
                                "intensity": "1224.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "38",
                                "monoisotopic_mass": "910.1466",
                                "monoisotopic_mz": "911.1539",
                                "intensity": "1001.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "39",
                                "monoisotopic_mass": "876.6608",
                                "monoisotopic_mz": "877.6680",
                                "intensity": "1163.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "40",
                                "monoisotopic_mass": "1015.6015",
                                "monoisotopic_mz": "1016.6088",
                                "intensity": "935.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "41",
                                "monoisotopic_mass": "2711.4903",
                                "monoisotopic_mz": "904.8374",
                                "intensity": "1031.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "42",
                                "monoisotopic_mass": "1051.3088",
                                "monoisotopic_mz": "1052.3160",
                                "intensity": "972.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "43",
                                "monoisotopic_mass": "1429.8298",
                                "monoisotopic_mz": "1430.8370",
                                "intensity": "623.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "44",
                                "monoisotopic_mass": "9405.1650",
                                "monoisotopic_mz": "784.7710",
                                "intensity": "1244.22",
                                "charge": "12"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "45",
                                "monoisotopic_mass": "3967.0030",
                                "monoisotopic_mz": "794.4079",
                                "intensity": "1365.78",
                                "charge": "5"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "46",
                                "monoisotopic_mass": "1705.2625",
                                "monoisotopic_mz": "853.6386",
                                "intensity": "1481.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "47",
                                "monoisotopic_mass": "6383.4817",
                                "monoisotopic_mz": "912.9332",
                                "intensity": "2860.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "48",
                                "monoisotopic_mass": "5588.5054",
                                "monoisotopic_mz": "799.3652",
                                "intensity": "793.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "49",
                                "monoisotopic_mass": "4793.5487",
                                "monoisotopic_mz": "799.9321",
                                "intensity": "1022.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "50",
                                "monoisotopic_mass": "3132.3048",
                                "monoisotopic_mz": "784.0835",
                                "intensity": "5146.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "51",
                                "monoisotopic_mass": "8345.5727",
                                "monoisotopic_mz": "928.2931",
                                "intensity": "901.02",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-26.9830198729",
                                        "theoretical_mass": "8346.5735",
                                        "ion_position": "10",
                                        "ion_display_position": "80",
                                        "ion_sort_name": "Y00080",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0016",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "52",
                                "monoisotopic_mass": "793.7694",
                                "monoisotopic_mz": "794.7767",
                                "intensity": "1014.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "53",
                                "monoisotopic_mass": "3460.8657",
                                "monoisotopic_mz": "866.2237",
                                "intensity": "1460.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "54",
                                "monoisotopic_mass": "7912.6162",
                                "monoisotopic_mz": "792.2689",
                                "intensity": "1215.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "55",
                                "monoisotopic_mass": "696.3804",
                                "monoisotopic_mz": "697.3877",
                                "intensity": "638.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "186",
                                "peak_id": "56",
                                "monoisotopic_mass": "2187.1580",
                                "monoisotopic_mz": "730.0599",
                                "intensity": "2878.54",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9544.2162",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "80",
                                        "spec_id": "186",
                                        "peak_id": "51",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "186",
                                        "peak_id": "28",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "186",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "186",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "186",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "186",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "186",
                                            "peak_id": "20",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "186",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "186",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "186",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "186",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "186",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "186",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "186",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "186",
                                            "peak_id": "43",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "186",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "10",
                            "right_position": "31",
                            "anno": "-26.9830",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "11",
                "p_value": "2.45e-11",
                "e_value": "2.45e-11",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "24",
                        "ms1_scans": "38",
                        "ids": "13",
                        "scans": "39",
                        "precursor_mono_mass": "9545.1693",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4380",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "13",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6219",
                                "monoisotopic_mz": "797.4443",
                                "intensity": "43906.21",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0010",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6855",
                                "monoisotopic_mz": "813.9549",
                                "intensity": "20386.85",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7700",
                                "monoisotopic_mz": "832.8023",
                                "intensity": "18746.48",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "3",
                                "monoisotopic_mass": "3347.7874",
                                "monoisotopic_mz": "837.9541",
                                "intensity": "10968.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8285",
                                "monoisotopic_mz": "715.9215",
                                "intensity": "14219.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "5",
                                "monoisotopic_mass": "6332.4485",
                                "monoisotopic_mz": "905.6428",
                                "intensity": "6982.81",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6332.4510",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "6",
                                "monoisotopic_mass": "1856.0520",
                                "monoisotopic_mz": "929.0333",
                                "intensity": "8234.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0000",
                                        "ppm": "0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "7",
                                "monoisotopic_mass": "4327.2778",
                                "monoisotopic_mz": "1082.8267",
                                "intensity": "8123.12",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9955851271",
                                        "theoretical_mass": "4327.2839",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0061",
                                        "ppm": "-1.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "8",
                                "monoisotopic_mass": "5100.8080",
                                "monoisotopic_mz": "729.6941",
                                "intensity": "9844.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "9",
                                "monoisotopic_mass": "5118.8281",
                                "monoisotopic_mz": "854.1453",
                                "intensity": "14891.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0039",
                                        "ppm": "-0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "10",
                                "monoisotopic_mass": "1785.0146",
                                "monoisotopic_mz": "893.5146",
                                "intensity": "5273.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "11",
                                "monoisotopic_mass": "4760.6021",
                                "monoisotopic_mz": "794.4410",
                                "intensity": "7417.28",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "12",
                                "monoisotopic_mass": "3283.7706",
                                "monoisotopic_mz": "1095.5975",
                                "intensity": "5480.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9955851271",
                                        "theoretical_mass": "3283.7704",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0001",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "13",
                                "monoisotopic_mass": "4699.5745",
                                "monoisotopic_mz": "784.2697",
                                "intensity": "7522.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "14",
                                "monoisotopic_mass": "4256.2474",
                                "monoisotopic_mz": "1065.0691",
                                "intensity": "7902.29",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9955851271",
                                        "theoretical_mass": "4256.2468",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0006",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "15",
                                "monoisotopic_mass": "5100.8031",
                                "monoisotopic_mz": "851.1411",
                                "intensity": "8426.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "16",
                                "monoisotopic_mass": "3447.8545",
                                "monoisotopic_mz": "862.9709",
                                "intensity": "5208.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "17",
                                "monoisotopic_mass": "3194.7218",
                                "monoisotopic_mz": "799.6877",
                                "intensity": "3879.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "18",
                                "monoisotopic_mass": "6146.3268",
                                "monoisotopic_mz": "879.0540",
                                "intensity": "7173.29",
                                "charge": "7"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "19",
                                "monoisotopic_mass": "1642.9400",
                                "monoisotopic_mz": "822.4773",
                                "intensity": "4222.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "20",
                                "monoisotopic_mass": "2993.6001",
                                "monoisotopic_mz": "749.4073",
                                "intensity": "5076.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "21",
                                "monoisotopic_mass": "3559.9430",
                                "monoisotopic_mz": "890.9930",
                                "intensity": "4307.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "22",
                                "monoisotopic_mass": "2922.5659",
                                "monoisotopic_mz": "731.6488",
                                "intensity": "3763.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "23",
                                "monoisotopic_mass": "4858.6725",
                                "monoisotopic_mz": "810.7860",
                                "intensity": "3662.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "24",
                                "monoisotopic_mass": "1713.9806",
                                "monoisotopic_mz": "857.9976",
                                "intensity": "3593.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "0.0028",
                                        "ppm": "1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "25",
                                "monoisotopic_mass": "1429.8293",
                                "monoisotopic_mz": "1430.8365",
                                "intensity": "2594.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "26",
                                "monoisotopic_mass": "2210.3152",
                                "monoisotopic_mz": "737.7790",
                                "intensity": "2882.25",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0001",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "27",
                                "monoisotopic_mass": "3064.6460",
                                "monoisotopic_mz": "767.1688",
                                "intensity": "3746.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "28",
                                "monoisotopic_mass": "4238.2339",
                                "monoisotopic_mz": "1060.5657",
                                "intensity": "1172.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "29",
                                "monoisotopic_mass": "3396.8526",
                                "monoisotopic_mz": "1133.2915",
                                "intensity": "3146.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9955851271",
                                        "theoretical_mass": "3396.8545",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "30",
                                "monoisotopic_mass": "3092.6787",
                                "monoisotopic_mz": "774.1770",
                                "intensity": "2853.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "31",
                                "monoisotopic_mass": "2361.2975",
                                "monoisotopic_mz": "788.1064",
                                "intensity": "2984.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "32",
                                "monoisotopic_mass": "4797.6461",
                                "monoisotopic_mz": "800.6150",
                                "intensity": "2728.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "33",
                                "monoisotopic_mass": "2950.5173",
                                "monoisotopic_mz": "984.5131",
                                "intensity": "2802.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "34",
                                "monoisotopic_mass": "2809.4825",
                                "monoisotopic_mz": "937.5015",
                                "intensity": "2596.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "35",
                                "monoisotopic_mass": "3011.6008",
                                "monoisotopic_mz": "1004.8742",
                                "intensity": "2558.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "36",
                                "monoisotopic_mass": "4291.2942",
                                "monoisotopic_mz": "859.2661",
                                "intensity": "1022.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "37",
                                "monoisotopic_mass": "2810.4891",
                                "monoisotopic_mz": "703.6296",
                                "intensity": "3057.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "38",
                                "monoisotopic_mass": "2436.3365",
                                "monoisotopic_mz": "813.1194",
                                "intensity": "2241.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "39",
                                "monoisotopic_mass": "2908.5500",
                                "monoisotopic_mz": "728.1448",
                                "intensity": "1927.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "40",
                                "monoisotopic_mass": "6261.4163",
                                "monoisotopic_mz": "895.4953",
                                "intensity": "3811.62",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6261.4139",
                                        "ion_position": "31",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0024",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "41",
                                "monoisotopic_mass": "813.7353",
                                "monoisotopic_mz": "814.7426",
                                "intensity": "1106.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "42",
                                "monoisotopic_mass": "3249.7268",
                                "monoisotopic_mz": "813.4390",
                                "intensity": "4561.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "43",
                                "monoisotopic_mass": "726.6376",
                                "monoisotopic_mz": "727.6449",
                                "intensity": "1160.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "44",
                                "monoisotopic_mass": "1015.6029",
                                "monoisotopic_mz": "1016.6102",
                                "intensity": "1105.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0003",
                                        "ppm": "0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "45",
                                "monoisotopic_mass": "4972.7490",
                                "monoisotopic_mz": "829.7988",
                                "intensity": "2750.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "46",
                                "monoisotopic_mass": "843.6522",
                                "monoisotopic_mz": "844.6595",
                                "intensity": "1175.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "47",
                                "monoisotopic_mass": "1283.7245",
                                "monoisotopic_mz": "1284.7318",
                                "intensity": "790.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "48",
                                "monoisotopic_mass": "1089.2515",
                                "monoisotopic_mz": "1090.2588",
                                "intensity": "1021.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "49",
                                "monoisotopic_mass": "4877.6852",
                                "monoisotopic_mz": "697.8194",
                                "intensity": "5543.40",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0041",
                                        "ppm": "-0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "50",
                                "monoisotopic_mass": "4312.2860",
                                "monoisotopic_mz": "1079.0788",
                                "intensity": "3211.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "51",
                                "monoisotopic_mass": "4743.5835",
                                "monoisotopic_mz": "791.6045",
                                "intensity": "1287.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "52",
                                "monoisotopic_mass": "3010.5971",
                                "monoisotopic_mz": "753.6565",
                                "intensity": "2619.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "53",
                                "monoisotopic_mass": "751.6586",
                                "monoisotopic_mz": "752.6659",
                                "intensity": "1403.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "54",
                                "monoisotopic_mass": "1472.8110",
                                "monoisotopic_mz": "737.4128",
                                "intensity": "813.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "55",
                                "monoisotopic_mass": "4341.9801",
                                "monoisotopic_mz": "869.4033",
                                "intensity": "1894.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "56",
                                "monoisotopic_mass": "5215.0507",
                                "monoisotopic_mz": "870.1824",
                                "intensity": "1014.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "57",
                                "monoisotopic_mass": "1429.8278",
                                "monoisotopic_mz": "477.6165",
                                "intensity": "1582.49",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "58",
                                "monoisotopic_mass": "5999.1393",
                                "monoisotopic_mz": "1000.8638",
                                "intensity": "3136.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "59",
                                "monoisotopic_mass": "3284.7753",
                                "monoisotopic_mz": "822.2011",
                                "intensity": "2778.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "60",
                                "monoisotopic_mass": "1834.9861",
                                "monoisotopic_mz": "918.5003",
                                "intensity": "1467.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "61",
                                "monoisotopic_mass": "832.1325",
                                "monoisotopic_mz": "833.1397",
                                "intensity": "2511.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "62",
                                "monoisotopic_mass": "8231.7463",
                                "monoisotopic_mz": "915.6458",
                                "intensity": "3204.05",
                                "charge": "9"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "63",
                                "monoisotopic_mass": "8627.0656",
                                "monoisotopic_mz": "863.7138",
                                "intensity": "2737.04",
                                "charge": "10"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "64",
                                "monoisotopic_mass": "972.1614",
                                "monoisotopic_mz": "973.1687",
                                "intensity": "1059.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "65",
                                "monoisotopic_mass": "3957.6376",
                                "monoisotopic_mz": "792.5348",
                                "intensity": "2312.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "66",
                                "monoisotopic_mass": "3175.6559",
                                "monoisotopic_mz": "794.9213",
                                "intensity": "5322.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "13",
                                "peak_id": "67",
                                "monoisotopic_mass": "7457.9493",
                                "monoisotopic_mz": "829.6683",
                                "intensity": "2738.20",
                                "charge": "9"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.1843",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "spec_id": "13",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "13",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "59",
                                            "spec_id": "13",
                                            "peak_id": "40",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "13",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "13",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "13",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "13",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "13",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "13",
                                            "peak_id": "49",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "13",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "13",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "13",
                                        "peak_id": "26",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "13",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "13",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "13",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "13",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "13",
                                            "peak_id": "57",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "13",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "13",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "13",
                                        "peak_id": "44",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "30",
                            "anno": "15.9956",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "71",
                "p_value": "4.85e-10",
                "e_value": "4.85e-10",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "274",
                        "ms1_scans": "360",
                        "ids": "86",
                        "scans": "362",
                        "precursor_mono_mass": "9544.1768",
                        "precursor_charge": "12",
                        "precursor_mz": "796.3553",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "86",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6204",
                                "monoisotopic_mz": "797.4440",
                                "intensity": "36899.62",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6837",
                                "monoisotopic_mz": "813.9546",
                                "intensity": "17045.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0057",
                                        "ppm": "-1.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7677",
                                "monoisotopic_mz": "832.8019",
                                "intensity": "12140.10",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0057",
                                        "ppm": "-1.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8286",
                                "monoisotopic_mz": "715.9216",
                                "intensity": "8284.02",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "4",
                                "monoisotopic_mass": "5118.8295",
                                "monoisotopic_mz": "854.1455",
                                "intensity": "9680.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "5",
                                "monoisotopic_mass": "5100.8118",
                                "monoisotopic_mz": "729.6947",
                                "intensity": "8949.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "6",
                                "monoisotopic_mass": "4698.5751",
                                "monoisotopic_mz": "784.1031",
                                "intensity": "4571.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "7",
                                "monoisotopic_mass": "4761.6066",
                                "monoisotopic_mz": "794.6084",
                                "intensity": "5876.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "8",
                                "monoisotopic_mass": "1856.0513",
                                "monoisotopic_mz": "929.0329",
                                "intensity": "3325.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "9",
                                "monoisotopic_mass": "4256.2465",
                                "monoisotopic_mz": "1065.0689",
                                "intensity": "4811.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "10",
                                "monoisotopic_mass": "1713.9752",
                                "monoisotopic_mz": "857.9949",
                                "intensity": "1949.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0026",
                                        "ppm": "-1.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "11",
                                "monoisotopic_mass": "2808.4813",
                                "monoisotopic_mz": "703.1276",
                                "intensity": "2866.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "12",
                                "monoisotopic_mass": "1785.0139",
                                "monoisotopic_mz": "893.5142",
                                "intensity": "2220.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "13",
                                "monoisotopic_mass": "2360.7981",
                                "monoisotopic_mz": "787.9400",
                                "intensity": "5135.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "14",
                                "monoisotopic_mass": "6261.4175",
                                "monoisotopic_mz": "895.4955",
                                "intensity": "4414.79",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6261.4139",
                                        "ion_position": "31",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0036",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "15",
                                "monoisotopic_mass": "812.9490",
                                "monoisotopic_mz": "813.9562",
                                "intensity": "2306.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "16",
                                "monoisotopic_mass": "1969.1331",
                                "monoisotopic_mz": "985.5738",
                                "intensity": "2135.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0030",
                                        "ppm": "-1.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "17",
                                "monoisotopic_mass": "3265.7573",
                                "monoisotopic_mz": "817.4466",
                                "intensity": "2521.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "18",
                                "monoisotopic_mass": "6148.3169",
                                "monoisotopic_mz": "879.3383",
                                "intensity": "5803.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0129",
                                        "ppm": "-2.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "19",
                                "monoisotopic_mass": "6326.4253",
                                "monoisotopic_mz": "791.8104",
                                "intensity": "1186.02",
                                "charge": "8"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "20",
                                "monoisotopic_mass": "3283.7665",
                                "monoisotopic_mz": "1095.5961",
                                "intensity": "3019.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "21",
                                "monoisotopic_mass": "3266.7619",
                                "monoisotopic_mz": "1089.9279",
                                "intensity": "1981.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "22",
                                "monoisotopic_mass": "3135.6765",
                                "monoisotopic_mz": "784.9264",
                                "intensity": "2725.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "23",
                                "monoisotopic_mass": "905.0643",
                                "monoisotopic_mz": "906.0715",
                                "intensity": "1076.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "24",
                                "monoisotopic_mass": "3857.0603",
                                "monoisotopic_mz": "965.2724",
                                "intensity": "1059.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "25",
                                "monoisotopic_mass": "5073.3344",
                                "monoisotopic_mz": "846.5630",
                                "intensity": "1130.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "26",
                                "monoisotopic_mass": "7143.8575",
                                "monoisotopic_mz": "794.7692",
                                "intensity": "699.28",
                                "charge": "9"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "27",
                                "monoisotopic_mass": "767.4962",
                                "monoisotopic_mz": "768.5035",
                                "intensity": "1158.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "28",
                                "monoisotopic_mass": "2992.6029",
                                "monoisotopic_mz": "749.1580",
                                "intensity": "2271.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "29",
                                "monoisotopic_mass": "5581.4110",
                                "monoisotopic_mz": "798.3517",
                                "intensity": "889.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "30",
                                "monoisotopic_mass": "4973.7646",
                                "monoisotopic_mz": "829.9680",
                                "intensity": "2373.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "31",
                                "monoisotopic_mass": "1642.9385",
                                "monoisotopic_mz": "822.4765",
                                "intensity": "2436.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0022",
                                        "ppm": "-1.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "32",
                                "monoisotopic_mass": "3063.6283",
                                "monoisotopic_mz": "766.9144",
                                "intensity": "3476.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "33",
                                "monoisotopic_mass": "3021.6389",
                                "monoisotopic_mz": "756.4170",
                                "intensity": "2043.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "34",
                                "monoisotopic_mass": "1114.5491",
                                "monoisotopic_mz": "1115.5564",
                                "intensity": "674.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "35",
                                "monoisotopic_mass": "9533.1374",
                                "monoisotopic_mz": "795.4354",
                                "intensity": "1294.31",
                                "charge": "12"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "36",
                                "monoisotopic_mass": "5917.2195",
                                "monoisotopic_mz": "846.3244",
                                "intensity": "1295.06",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5918.2395",
                                        "ion_position": "34",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0177",
                                        "ppm": "-2.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "37",
                                "monoisotopic_mass": "6403.4858",
                                "monoisotopic_mz": "915.7910",
                                "intensity": "3209.12",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6403.4881",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "38",
                                "monoisotopic_mass": "3734.2589",
                                "monoisotopic_mz": "747.8591",
                                "intensity": "952.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "39",
                                "monoisotopic_mass": "4780.6312",
                                "monoisotopic_mz": "957.1335",
                                "intensity": "711.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "40",
                                "monoisotopic_mass": "1070.9103",
                                "monoisotopic_mz": "1071.9176",
                                "intensity": "647.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "41",
                                "monoisotopic_mass": "746.3976",
                                "monoisotopic_mz": "747.4048",
                                "intensity": "1310.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "42",
                                "monoisotopic_mass": "8740.9332",
                                "monoisotopic_mz": "795.6376",
                                "intensity": "2371.24",
                                "charge": "11"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "43",
                                "monoisotopic_mass": "1494.3742",
                                "monoisotopic_mz": "748.1944",
                                "intensity": "2414.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "44",
                                "monoisotopic_mass": "955.9245",
                                "monoisotopic_mz": "956.9318",
                                "intensity": "2110.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "45",
                                "monoisotopic_mass": "827.8208",
                                "monoisotopic_mz": "828.8281",
                                "intensity": "1087.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "46",
                                "monoisotopic_mass": "8722.3641",
                                "monoisotopic_mz": "793.9495",
                                "intensity": "666.84",
                                "charge": "11"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "47",
                                "monoisotopic_mass": "3148.7151",
                                "monoisotopic_mz": "788.1860",
                                "intensity": "2696.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "48",
                                "monoisotopic_mass": "876.2718",
                                "monoisotopic_mz": "877.2791",
                                "intensity": "1058.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "49",
                                "monoisotopic_mass": "2210.3177",
                                "monoisotopic_mz": "737.7798",
                                "intensity": "2111.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0026",
                                        "ppm": "1.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "50",
                                "monoisotopic_mass": "793.2888",
                                "monoisotopic_mz": "794.2961",
                                "intensity": "1393.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "51",
                                "monoisotopic_mass": "8621.8574",
                                "monoisotopic_mz": "784.8125",
                                "intensity": "552.21",
                                "charge": "11"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "52",
                                "monoisotopic_mass": "4309.2636",
                                "monoisotopic_mz": "1078.3232",
                                "intensity": "2544.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "53",
                                "monoisotopic_mass": "3480.4727",
                                "monoisotopic_mz": "871.1255",
                                "intensity": "1551.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "54",
                                "monoisotopic_mass": "5256.6994",
                                "monoisotopic_mz": "877.1238",
                                "intensity": "2201.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "55",
                                "monoisotopic_mass": "5974.2564",
                                "monoisotopic_mz": "747.7893",
                                "intensity": "2582.87",
                                "charge": "8"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "56",
                                "monoisotopic_mass": "6288.4708",
                                "monoisotopic_mz": "787.0661",
                                "intensity": "1153.09",
                                "charge": "8"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "57",
                                "monoisotopic_mass": "4453.7844",
                                "monoisotopic_mz": "891.7642",
                                "intensity": "1877.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "58",
                                "monoisotopic_mass": "4251.6908",
                                "monoisotopic_mz": "851.3454",
                                "intensity": "1648.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "59",
                                "monoisotopic_mass": "2089.1053",
                                "monoisotopic_mz": "1045.5600",
                                "intensity": "1015.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "60",
                                "monoisotopic_mass": "857.3374",
                                "monoisotopic_mz": "858.3447",
                                "intensity": "597.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "61",
                                "monoisotopic_mass": "3288.8409",
                                "monoisotopic_mz": "823.2175",
                                "intensity": "1182.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "62",
                                "monoisotopic_mass": "2572.1006",
                                "monoisotopic_mz": "858.3741",
                                "intensity": "1710.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "86",
                                "peak_id": "63",
                                "monoisotopic_mass": "4638.6458",
                                "monoisotopic_mz": "774.1149",
                                "intensity": "1880.64",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9544.4618",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "spec_id": "86",
                                        "peak_id": "37",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "59",
                                        "spec_id": "86",
                                        "peak_id": "14",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "86",
                                        "peak_id": "18",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "56",
                                        "spec_id": "86",
                                        "peak_id": "36",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "86",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "86",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "86",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "86",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "86",
                                        "peak_id": "49",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "86",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "86",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "86",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "86",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "86",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "86",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "29",
                            "anno": "15.2732",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "85",
                "p_value": "6.50e-10",
                "e_value": "6.50e-10",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "327",
                        "ms1_scans": "430",
                        "ids": "102",
                        "scans": "431",
                        "precursor_mono_mass": "9545.1678",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4379",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "102",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6197",
                                "monoisotopic_mz": "797.4439",
                                "intensity": "40346.22",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6914",
                                "monoisotopic_mz": "813.9558",
                                "intensity": "20374.08",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0020",
                                        "ppm": "0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7695",
                                "monoisotopic_mz": "832.8022",
                                "intensity": "16422.38",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0039",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "3",
                                "monoisotopic_mass": "5100.8063",
                                "monoisotopic_mz": "729.6939",
                                "intensity": "7581.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8282",
                                "monoisotopic_mz": "715.9214",
                                "intensity": "11652.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "5",
                                "monoisotopic_mass": "4327.2827",
                                "monoisotopic_mz": "1082.8279",
                                "intensity": "4727.10",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9941151271",
                                        "theoretical_mass": "4327.2824",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0002",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "6",
                                "monoisotopic_mass": "5118.8295",
                                "monoisotopic_mz": "854.1455",
                                "intensity": "9304.90",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "7",
                                "monoisotopic_mass": "3348.7843",
                                "monoisotopic_mz": "838.2033",
                                "intensity": "5596.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "8",
                                "monoisotopic_mass": "4256.2466",
                                "monoisotopic_mz": "1065.0689",
                                "intensity": "5744.57",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9941151271",
                                        "theoretical_mass": "4256.2453",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0013",
                                        "ppm": "0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "9",
                                "monoisotopic_mass": "4698.5883",
                                "monoisotopic_mz": "784.1053",
                                "intensity": "6296.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "10",
                                "monoisotopic_mass": "1856.0497",
                                "monoisotopic_mz": "929.0321",
                                "intensity": "5218.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0023",
                                        "ppm": "-1.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "11",
                                "monoisotopic_mass": "1785.0164",
                                "monoisotopic_mz": "893.5155",
                                "intensity": "4071.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0015",
                                        "ppm": "0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "12",
                                "monoisotopic_mass": "4720.5965",
                                "monoisotopic_mz": "787.7734",
                                "intensity": "8108.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "13",
                                "monoisotopic_mass": "1969.1349",
                                "monoisotopic_mz": "985.5747",
                                "intensity": "3894.18",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "14",
                                "monoisotopic_mass": "3283.7720",
                                "monoisotopic_mz": "1095.5980",
                                "intensity": "5114.43",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9941151271",
                                        "theoretical_mass": "3283.7689",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0031",
                                        "ppm": "0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "15",
                                "monoisotopic_mass": "2808.4825",
                                "monoisotopic_mz": "703.1279",
                                "intensity": "3102.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "16",
                                "monoisotopic_mass": "2993.6020",
                                "monoisotopic_mz": "749.4078",
                                "intensity": "3421.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "17",
                                "monoisotopic_mass": "3064.6408",
                                "monoisotopic_mz": "767.1675",
                                "intensity": "3843.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "18",
                                "monoisotopic_mass": "2210.3157",
                                "monoisotopic_mz": "737.7792",
                                "intensity": "3240.05",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0006",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "19",
                                "monoisotopic_mass": "3282.7742",
                                "monoisotopic_mz": "821.7008",
                                "intensity": "2269.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "20",
                                "monoisotopic_mass": "4239.2368",
                                "monoisotopic_mz": "1060.8165",
                                "intensity": "1880.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "21",
                                "monoisotopic_mass": "2922.5640",
                                "monoisotopic_mz": "731.6483",
                                "intensity": "4094.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "22",
                                "monoisotopic_mass": "1003.5320",
                                "monoisotopic_mz": "1004.5393",
                                "intensity": "1887.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "23",
                                "monoisotopic_mass": "3021.6369",
                                "monoisotopic_mz": "756.4165",
                                "intensity": "3016.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "24",
                                "monoisotopic_mass": "3265.7536",
                                "monoisotopic_mz": "817.4457",
                                "intensity": "2319.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "25",
                                "monoisotopic_mass": "3212.7304",
                                "monoisotopic_mz": "1071.9174",
                                "intensity": "1920.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9941151271",
                                        "theoretical_mass": "3212.7318",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "26",
                                "monoisotopic_mass": "6515.5672",
                                "monoisotopic_mz": "931.8026",
                                "intensity": "2364.41",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6516.5722",
                                        "ion_position": "28",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "Y00062",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0026",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "27",
                                "monoisotopic_mass": "3381.8551",
                                "monoisotopic_mz": "1128.2923",
                                "intensity": "1043.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "28",
                                "monoisotopic_mass": "789.7614",
                                "monoisotopic_mz": "790.7687",
                                "intensity": "1014.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "29",
                                "monoisotopic_mass": "856.4356",
                                "monoisotopic_mz": "857.4429",
                                "intensity": "1355.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "30",
                                "monoisotopic_mass": "3135.6777",
                                "monoisotopic_mz": "784.9267",
                                "intensity": "2272.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "31",
                                "monoisotopic_mass": "1568.5320",
                                "monoisotopic_mz": "785.2733",
                                "intensity": "1877.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "32",
                                "monoisotopic_mass": "6263.4179",
                                "monoisotopic_mz": "895.7813",
                                "intensity": "1809.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "33",
                                "monoisotopic_mass": "5554.5398",
                                "monoisotopic_mz": "794.5130",
                                "intensity": "3803.48",
                                "charge": "7"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "34",
                                "monoisotopic_mass": "1452.7783",
                                "monoisotopic_mz": "727.3964",
                                "intensity": "744.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "35",
                                "monoisotopic_mass": "1283.7231",
                                "monoisotopic_mz": "1284.7303",
                                "intensity": "724.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "36",
                                "monoisotopic_mass": "4876.6816",
                                "monoisotopic_mz": "697.6761",
                                "intensity": "3833.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "37",
                                "monoisotopic_mass": "3079.6636",
                                "monoisotopic_mz": "770.9232",
                                "intensity": "2608.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "38",
                                "monoisotopic_mass": "1586.2097",
                                "monoisotopic_mz": "794.1121",
                                "intensity": "2773.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "39",
                                "monoisotopic_mass": "3249.7426",
                                "monoisotopic_mz": "813.4429",
                                "intensity": "4773.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "40",
                                "monoisotopic_mass": "4743.6019",
                                "monoisotopic_mz": "791.6076",
                                "intensity": "1968.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "41",
                                "monoisotopic_mass": "915.2137",
                                "monoisotopic_mz": "916.2209",
                                "intensity": "1364.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "42",
                                "monoisotopic_mass": "2000.3678",
                                "monoisotopic_mz": "1001.1912",
                                "intensity": "2013.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "43",
                                "monoisotopic_mass": "1429.8277",
                                "monoisotopic_mz": "1430.8350",
                                "intensity": "1357.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0017",
                                        "ppm": "-1.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "44",
                                "monoisotopic_mass": "1488.2954",
                                "monoisotopic_mz": "745.1550",
                                "intensity": "606.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "45",
                                "monoisotopic_mass": "2635.7167",
                                "monoisotopic_mz": "879.5795",
                                "intensity": "1565.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "46",
                                "monoisotopic_mass": "7678.2515",
                                "monoisotopic_mz": "854.1463",
                                "intensity": "982.99",
                                "charge": "9"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "47",
                                "monoisotopic_mass": "1283.7231",
                                "monoisotopic_mz": "642.8688",
                                "intensity": "1282.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "48",
                                "monoisotopic_mass": "3631.8082",
                                "monoisotopic_mz": "727.3689",
                                "intensity": "1014.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "49",
                                "monoisotopic_mass": "9215.3853",
                                "monoisotopic_mz": "838.7696",
                                "intensity": "1957.37",
                                "charge": "11"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "50",
                                "monoisotopic_mass": "1393.1610",
                                "monoisotopic_mz": "697.5878",
                                "intensity": "493.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "102",
                                "peak_id": "51",
                                "monoisotopic_mass": "2544.4015",
                                "monoisotopic_mz": "849.1411",
                                "intensity": "1348.43",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.1828",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "62",
                                        "spec_id": "102",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "102",
                                        "peak_id": "25",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "102",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "102",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "102",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "102",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "102",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "102",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "102",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "102",
                                        "peak_id": "18",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "102",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "102",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "102",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "102",
                                            "peak_id": "43",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "102",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "28",
                            "anno": "15.9941",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "116",
                "p_value": "1.53e-09",
                "e_value": "1.53e-09",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "426",
                        "ms1_scans": "564",
                        "ids": "137",
                        "scans": "565",
                        "precursor_mono_mass": "9545.1795",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4389",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "137",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6208",
                                "monoisotopic_mz": "797.4441",
                                "intensity": "40630.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "1",
                                "monoisotopic_mass": "4876.6916",
                                "monoisotopic_mz": "813.7892",
                                "intensity": "20000.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7765",
                                "monoisotopic_mz": "832.8034",
                                "intensity": "15565.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0031",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "3",
                                "monoisotopic_mass": "5117.8308",
                                "monoisotopic_mz": "853.9791",
                                "intensity": "10780.52",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0012",
                                        "ppm": "0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "715.9217",
                                "intensity": "8143.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "5",
                                "monoisotopic_mass": "4256.2441",
                                "monoisotopic_mz": "1065.0683",
                                "intensity": "4819.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-25.9997298729",
                                        "theoretical_mass": "4256.2621",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0179",
                                        "ppm": "-4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "6",
                                "monoisotopic_mass": "5099.8163",
                                "monoisotopic_mz": "729.5525",
                                "intensity": "6860.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "7",
                                "monoisotopic_mass": "4760.6028",
                                "monoisotopic_mz": "794.4411",
                                "intensity": "5193.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "8",
                                "monoisotopic_mass": "1856.0514",
                                "monoisotopic_mz": "929.0330",
                                "intensity": "3917.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "9",
                                "monoisotopic_mass": "4720.6002",
                                "monoisotopic_mz": "787.7740",
                                "intensity": "6085.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "10",
                                "monoisotopic_mass": "1566.8611",
                                "monoisotopic_mz": "784.4378",
                                "intensity": "3948.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "11",
                                "monoisotopic_mass": "4239.2440",
                                "monoisotopic_mz": "1060.8183",
                                "intensity": "4016.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "12",
                                "monoisotopic_mass": "1969.1353",
                                "monoisotopic_mz": "985.5749",
                                "intensity": "2918.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "13",
                                "monoisotopic_mass": "3021.6416",
                                "monoisotopic_mz": "756.4177",
                                "intensity": "3487.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "14",
                                "monoisotopic_mass": "3022.6451",
                                "monoisotopic_mz": "1008.5557",
                                "intensity": "2139.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "15",
                                "monoisotopic_mass": "2210.3157",
                                "monoisotopic_mz": "737.7792",
                                "intensity": "3351.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0006",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "16",
                                "monoisotopic_mass": "1454.7795",
                                "monoisotopic_mz": "728.3970",
                                "intensity": "1946.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "17",
                                "monoisotopic_mass": "3064.6386",
                                "monoisotopic_mz": "767.1669",
                                "intensity": "2310.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "18",
                                "monoisotopic_mass": "3447.8631",
                                "monoisotopic_mz": "862.9731",
                                "intensity": "4013.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "19",
                                "monoisotopic_mass": "3266.7646",
                                "monoisotopic_mz": "817.6984",
                                "intensity": "2252.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "20",
                                "monoisotopic_mass": "4798.6404",
                                "monoisotopic_mz": "800.7807",
                                "intensity": "3299.21",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "21",
                                "monoisotopic_mass": "856.9885",
                                "monoisotopic_mz": "857.9958",
                                "intensity": "1786.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "22",
                                "monoisotopic_mass": "3560.9473",
                                "monoisotopic_mz": "891.2441",
                                "intensity": "1291.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "23",
                                "monoisotopic_mass": "3283.7764",
                                "monoisotopic_mz": "1095.5994",
                                "intensity": "1033.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-25.9997298729",
                                        "theoretical_mass": "3283.7857",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0092",
                                        "ppm": "-2.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "24",
                                "monoisotopic_mass": "3196.7319",
                                "monoisotopic_mz": "800.1903",
                                "intensity": "927.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "25",
                                "monoisotopic_mass": "1642.9387",
                                "monoisotopic_mz": "822.4766",
                                "intensity": "3033.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0020",
                                        "ppm": "-1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "26",
                                "monoisotopic_mass": "761.5898",
                                "monoisotopic_mz": "762.5970",
                                "intensity": "1016.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "27",
                                "monoisotopic_mass": "1094.9231",
                                "monoisotopic_mz": "1095.9304",
                                "intensity": "1466.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "28",
                                "monoisotopic_mass": "4493.4241",
                                "monoisotopic_mz": "749.9113",
                                "intensity": "1066.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "29",
                                "monoisotopic_mass": "3347.7929",
                                "monoisotopic_mz": "837.9555",
                                "intensity": "2296.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "30",
                                "monoisotopic_mass": "2595.9124",
                                "monoisotopic_mz": "866.3114",
                                "intensity": "887.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "31",
                                "monoisotopic_mass": "4235.1571",
                                "monoisotopic_mz": "848.0387",
                                "intensity": "1019.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "32",
                                "monoisotopic_mass": "9523.1596",
                                "monoisotopic_mz": "794.6039",
                                "intensity": "3018.44",
                                "charge": "12"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "33",
                                "monoisotopic_mass": "6919.7742",
                                "monoisotopic_mz": "865.9791",
                                "intensity": "1155.83",
                                "charge": "8",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-25.9997298729",
                                            "theoretical_mass": "6919.6777",
                                            "ion_position": "64",
                                            "ion_display_position": "64",
                                            "ion_sort_name": "B00064",
                                            "ion_left_position": "64",
                                            "mass_error": "0.0965",
                                            "ppm": "13.94"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "-25.9997298729",
                                            "theoretical_mass": "6920.7788",
                                            "ion_position": "24",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "24",
                                            "mass_error": "-0.0023",
                                            "ppm": "-0.33"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "34",
                                "monoisotopic_mass": "887.4719",
                                "monoisotopic_mz": "888.4791",
                                "intensity": "1323.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "35",
                                "monoisotopic_mass": "956.1254",
                                "monoisotopic_mz": "957.1327",
                                "intensity": "657.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "36",
                                "monoisotopic_mass": "1701.2750",
                                "monoisotopic_mz": "851.6448",
                                "intensity": "3416.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "37",
                                "monoisotopic_mass": "1492.1218",
                                "monoisotopic_mz": "747.0682",
                                "intensity": "534.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "38",
                                "monoisotopic_mass": "2788.3012",
                                "monoisotopic_mz": "930.4410",
                                "intensity": "903.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "39",
                                "monoisotopic_mass": "5940.8497",
                                "monoisotopic_mz": "849.7001",
                                "intensity": "879.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "40",
                                "monoisotopic_mass": "970.5190",
                                "monoisotopic_mz": "971.5263",
                                "intensity": "1063.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "41",
                                "monoisotopic_mass": "827.9268",
                                "monoisotopic_mz": "828.9341",
                                "intensity": "948.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "42",
                                "monoisotopic_mass": "2313.3064",
                                "monoisotopic_mz": "772.1094",
                                "intensity": "893.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "43",
                                "monoisotopic_mass": "4311.2784",
                                "monoisotopic_mz": "1078.8269",
                                "intensity": "1759.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "44",
                                "monoisotopic_mass": "8683.5216",
                                "monoisotopic_mz": "790.4183",
                                "intensity": "815.51",
                                "charge": "11"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "45",
                                "monoisotopic_mass": "1077.8198",
                                "monoisotopic_mz": "1078.8270",
                                "intensity": "1146.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "46",
                                "monoisotopic_mass": "2920.5572",
                                "monoisotopic_mz": "731.1466",
                                "intensity": "1035.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "47",
                                "monoisotopic_mass": "6233.1616",
                                "monoisotopic_mz": "891.4589",
                                "intensity": "908.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "48",
                                "monoisotopic_mass": "5847.0617",
                                "monoisotopic_mz": "975.5176",
                                "intensity": "831.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "49",
                                "monoisotopic_mass": "1405.2455",
                                "monoisotopic_mz": "703.6300",
                                "intensity": "1057.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "50",
                                "monoisotopic_mass": "1472.8203",
                                "monoisotopic_mz": "737.4174",
                                "intensity": "1508.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "137",
                                "peak_id": "51",
                                "monoisotopic_mass": "1340.7223",
                                "monoisotopic_mz": "671.3684",
                                "intensity": "659.30",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.1995",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "24",
                                        "ion_display_position": "66",
                                        "spec_id": "137",
                                        "peak_id": "33",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "137",
                                        "peak_id": "23",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "137",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "137",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "137",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "137",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "spec_id": "137",
                                        "peak_id": "33",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "137",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "137",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "137",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "137",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "137",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "24",
                            "right_position": "31",
                            "anno": "-25.9997",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "4",
                "p_value": "2.37e-09",
                "e_value": "2.37e-09",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "4",
                        "ms1_scans": "9",
                        "ids": "4",
                        "scans": "10",
                        "precursor_mono_mass": "9545.1795",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4389",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "4",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6175",
                                "monoisotopic_mz": "797.4435",
                                "intensity": "52361.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "1",
                                "monoisotopic_mass": "4876.6847",
                                "monoisotopic_mz": "813.7881",
                                "intensity": "23364.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7718",
                                "monoisotopic_mz": "832.8026",
                                "intensity": "19239.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "3",
                                "monoisotopic_mass": "5118.8280",
                                "monoisotopic_mz": "854.1453",
                                "intensity": "15657.90",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0039",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "4",
                                "monoisotopic_mass": "3349.7877",
                                "monoisotopic_mz": "838.4542",
                                "intensity": "9939.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "5",
                                "monoisotopic_mass": "1429.8286",
                                "monoisotopic_mz": "715.9216",
                                "intensity": "14713.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "6",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "8486.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "7",
                                "monoisotopic_mass": "4326.2842",
                                "monoisotopic_mz": "1082.5783",
                                "intensity": "7649.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "8",
                                "monoisotopic_mass": "4778.6118",
                                "monoisotopic_mz": "956.7296",
                                "intensity": "4331.66",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0091",
                                        "ppm": "-1.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "9",
                                "monoisotopic_mass": "1856.0512",
                                "monoisotopic_mz": "929.0329",
                                "intensity": "5466.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "10",
                                "monoisotopic_mass": "2210.3162",
                                "monoisotopic_mz": "737.7794",
                                "intensity": "4786.05",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0011",
                                        "ppm": "0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "11",
                                "monoisotopic_mass": "4310.2611",
                                "monoisotopic_mz": "1078.5726",
                                "intensity": "5527.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "12",
                                "monoisotopic_mass": "3348.7907",
                                "monoisotopic_mz": "1117.2708",
                                "intensity": "2732.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "13",
                                "monoisotopic_mass": "1785.0143",
                                "monoisotopic_mz": "893.5144",
                                "intensity": "4470.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "14",
                                "monoisotopic_mass": "3283.7654",
                                "monoisotopic_mz": "821.9486",
                                "intensity": "3514.44",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9908351271",
                                        "theoretical_mass": "3283.7657",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "15",
                                "monoisotopic_mass": "3447.8612",
                                "monoisotopic_mz": "862.9726",
                                "intensity": "3316.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "16",
                                "monoisotopic_mass": "6147.3236",
                                "monoisotopic_mz": "879.1964",
                                "intensity": "4616.98",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0039",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "17",
                                "monoisotopic_mass": "3064.6367",
                                "monoisotopic_mz": "767.1665",
                                "intensity": "3302.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "18",
                                "monoisotopic_mass": "3560.9393",
                                "monoisotopic_mz": "891.2421",
                                "intensity": "4541.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "19",
                                "monoisotopic_mass": "1713.9739",
                                "monoisotopic_mz": "857.9942",
                                "intensity": "3417.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0039",
                                        "ppm": "-2.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "20",
                                "monoisotopic_mass": "2992.5967",
                                "monoisotopic_mz": "749.1564",
                                "intensity": "4687.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "21",
                                "monoisotopic_mass": "3282.7576",
                                "monoisotopic_mz": "1095.2598",
                                "intensity": "3268.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "22",
                                "monoisotopic_mass": "4760.6050",
                                "monoisotopic_mz": "794.4414",
                                "intensity": "3408.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "23",
                                "monoisotopic_mass": "4240.2461",
                                "monoisotopic_mz": "1061.0688",
                                "intensity": "4207.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "24",
                                "monoisotopic_mass": "5903.0371",
                                "monoisotopic_mz": "984.8468",
                                "intensity": "1513.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "25",
                                "monoisotopic_mass": "1969.1352",
                                "monoisotopic_mz": "985.5749",
                                "intensity": "3660.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "26",
                                "monoisotopic_mass": "4721.5962",
                                "monoisotopic_mz": "787.9400",
                                "intensity": "7969.42",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0032",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "27",
                                "monoisotopic_mass": "1624.3740",
                                "monoisotopic_mz": "813.1943",
                                "intensity": "2287.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "28",
                                "monoisotopic_mass": "5101.8175",
                                "monoisotopic_mz": "851.3102",
                                "intensity": "7020.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "29",
                                "monoisotopic_mass": "2975.5864",
                                "monoisotopic_mz": "744.9039",
                                "intensity": "3041.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "30",
                                "monoisotopic_mass": "3092.6760",
                                "monoisotopic_mz": "774.1763",
                                "intensity": "1424.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "31",
                                "monoisotopic_mass": "2286.2625",
                                "monoisotopic_mz": "763.0948",
                                "intensity": "1934.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "32",
                                "monoisotopic_mass": "4256.2343",
                                "monoisotopic_mz": "1065.0658",
                                "intensity": "6350.74",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9908351271",
                                        "theoretical_mass": "4256.2421",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0078",
                                        "ppm": "-1.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "33",
                                "monoisotopic_mass": "2922.5705",
                                "monoisotopic_mz": "731.6499",
                                "intensity": "3523.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "34",
                                "monoisotopic_mass": "4974.7596",
                                "monoisotopic_mz": "830.1339",
                                "intensity": "2545.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "35",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "1430.8357",
                                "intensity": "2793.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "36",
                                "monoisotopic_mass": "1698.9193",
                                "monoisotopic_mz": "850.4669",
                                "intensity": "1832.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "37",
                                "monoisotopic_mass": "989.0147",
                                "monoisotopic_mz": "990.0220",
                                "intensity": "1221.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "38",
                                "monoisotopic_mass": "769.6632",
                                "monoisotopic_mz": "770.6705",
                                "intensity": "1358.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "39",
                                "monoisotopic_mass": "752.6505",
                                "monoisotopic_mz": "753.6578",
                                "intensity": "1290.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "40",
                                "monoisotopic_mass": "818.9559",
                                "monoisotopic_mz": "819.9632",
                                "intensity": "1439.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "41",
                                "monoisotopic_mass": "838.7615",
                                "monoisotopic_mz": "839.7687",
                                "intensity": "1127.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "42",
                                "monoisotopic_mass": "1064.5624",
                                "monoisotopic_mz": "1065.5697",
                                "intensity": "3207.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "43",
                                "monoisotopic_mass": "5872.9522",
                                "monoisotopic_mz": "840.0004",
                                "intensity": "1210.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "44",
                                "monoisotopic_mass": "726.3895",
                                "monoisotopic_mz": "727.3967",
                                "intensity": "1522.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "45",
                                "monoisotopic_mass": "8922.6941",
                                "monoisotopic_mz": "893.2767",
                                "intensity": "902.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "46",
                                "monoisotopic_mass": "1088.9191",
                                "monoisotopic_mz": "1089.9264",
                                "intensity": "1369.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "47",
                                "monoisotopic_mass": "7829.0628",
                                "monoisotopic_mz": "870.9031",
                                "intensity": "1231.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "48",
                                "monoisotopic_mass": "1429.8273",
                                "monoisotopic_mz": "477.6164",
                                "intensity": "3321.65",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "49",
                                "monoisotopic_mass": "3195.7076",
                                "monoisotopic_mz": "799.9342",
                                "intensity": "2345.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "50",
                                "monoisotopic_mass": "870.7234",
                                "monoisotopic_mz": "871.7307",
                                "intensity": "1333.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "51",
                                "monoisotopic_mass": "1453.2812",
                                "monoisotopic_mz": "727.6479",
                                "intensity": "1931.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "52",
                                "monoisotopic_mass": "702.3697",
                                "monoisotopic_mz": "703.3770",
                                "intensity": "1244.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "53",
                                "monoisotopic_mass": "9162.8856",
                                "monoisotopic_mz": "833.9969",
                                "intensity": "966.82",
                                "charge": "11"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "54",
                                "monoisotopic_mass": "5218.7069",
                                "monoisotopic_mz": "870.7918",
                                "intensity": "917.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "55",
                                "monoisotopic_mass": "3269.7638",
                                "monoisotopic_mz": "1090.9285",
                                "intensity": "1068.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "56",
                                "monoisotopic_mass": "794.2686",
                                "monoisotopic_mz": "795.2759",
                                "intensity": "1389.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "57",
                                "monoisotopic_mass": "2992.5931",
                                "monoisotopic_mz": "998.5383",
                                "intensity": "2251.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "58",
                                "monoisotopic_mass": "9430.0189",
                                "monoisotopic_mz": "858.2817",
                                "intensity": "1900.38",
                                "charge": "11"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "59",
                                "monoisotopic_mass": "4619.4506",
                                "monoisotopic_mz": "924.8974",
                                "intensity": "1285.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "60",
                                "monoisotopic_mass": "4144.6422",
                                "monoisotopic_mz": "829.9357",
                                "intensity": "886.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "61",
                                "monoisotopic_mass": "1446.8596",
                                "monoisotopic_mz": "483.2938",
                                "intensity": "736.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "62",
                                "monoisotopic_mass": "5457.8177",
                                "monoisotopic_mz": "780.6955",
                                "intensity": "926.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "63",
                                "monoisotopic_mass": "4194.5156",
                                "monoisotopic_mz": "1049.6362",
                                "intensity": "933.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "64",
                                "monoisotopic_mass": "7827.6879",
                                "monoisotopic_mz": "783.7761",
                                "intensity": "2342.78",
                                "charge": "10"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "65",
                                "monoisotopic_mass": "3330.7662",
                                "monoisotopic_mz": "833.6988",
                                "intensity": "874.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "66",
                                "monoisotopic_mass": "6133.0091",
                                "monoisotopic_mz": "877.1514",
                                "intensity": "1166.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "67",
                                "monoisotopic_mass": "6468.4947",
                                "monoisotopic_mz": "809.5691",
                                "intensity": "3004.71",
                                "charge": "8"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "68",
                                "monoisotopic_mass": "5428.8460",
                                "monoisotopic_mz": "905.8149",
                                "intensity": "910.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "69",
                                "monoisotopic_mass": "1047.2304",
                                "monoisotopic_mz": "1048.2377",
                                "intensity": "1480.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "70",
                                "monoisotopic_mass": "2598.3940",
                                "monoisotopic_mz": "867.1386",
                                "intensity": "2426.19",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9908351271",
                                        "theoretical_mass": "2598.4010",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "-0.0070",
                                        "ppm": "-2.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "71",
                                "monoisotopic_mass": "6293.2870",
                                "monoisotopic_mz": "900.0483",
                                "intensity": "1213.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "72",
                                "monoisotopic_mass": "3948.8843",
                                "monoisotopic_mz": "790.7841",
                                "intensity": "872.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "73",
                                "monoisotopic_mass": "7789.8454",
                                "monoisotopic_mz": "866.5457",
                                "intensity": "1157.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "74",
                                "monoisotopic_mass": "3968.5989",
                                "monoisotopic_mz": "794.7271",
                                "intensity": "1143.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "75",
                                "monoisotopic_mass": "4860.6465",
                                "monoisotopic_mz": "811.1150",
                                "intensity": "3170.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "76",
                                "monoisotopic_mass": "1486.7983",
                                "monoisotopic_mz": "744.4064",
                                "intensity": "412.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "77",
                                "monoisotopic_mass": "1034.7874",
                                "monoisotopic_mz": "1035.7947",
                                "intensity": "640.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "78",
                                "monoisotopic_mass": "1642.9367",
                                "monoisotopic_mz": "822.4756",
                                "intensity": "1708.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0039",
                                        "ppm": "-2.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "79",
                                "monoisotopic_mass": "4107.7998",
                                "monoisotopic_mz": "822.5672",
                                "intensity": "1472.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "80",
                                "monoisotopic_mass": "7764.8263",
                                "monoisotopic_mz": "863.7658",
                                "intensity": "1265.72",
                                "charge": "9"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "81",
                                "monoisotopic_mass": "951.2088",
                                "monoisotopic_mz": "952.2161",
                                "intensity": "735.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "82",
                                "monoisotopic_mass": "968.5245",
                                "monoisotopic_mz": "969.5317",
                                "intensity": "741.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "83",
                                "monoisotopic_mass": "3715.9440",
                                "monoisotopic_mz": "929.9933",
                                "intensity": "1012.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "84",
                                "monoisotopic_mass": "1009.5413",
                                "monoisotopic_mz": "1010.5486",
                                "intensity": "875.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "85",
                                "monoisotopic_mass": "7028.5092",
                                "monoisotopic_mz": "879.5709",
                                "intensity": "1731.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "86",
                                "monoisotopic_mass": "2623.1178",
                                "monoisotopic_mz": "875.3799",
                                "intensity": "2282.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "87",
                                "monoisotopic_mass": "3980.2556",
                                "monoisotopic_mz": "797.0584",
                                "intensity": "16703.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "88",
                                "monoisotopic_mass": "3474.3877",
                                "monoisotopic_mz": "869.6042",
                                "intensity": "1541.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "4",
                                "peak_id": "89",
                                "monoisotopic_mass": "1996.7065",
                                "monoisotopic_mz": "999.3605",
                                "intensity": "1551.39",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.1795",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "4",
                                        "peak_id": "70",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "4",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "4",
                                        "peak_id": "16",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "4",
                                        "peak_id": "32",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "4",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "4",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "4",
                                            "peak_id": "8",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "4",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "4",
                                        "peak_id": "26",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "4",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "4",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "4",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "4",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "4",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "4",
                                        "peak_id": "78",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "4",
                                            "peak_id": "48",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "4",
                                            "peak_id": "35",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "4",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "24",
                            "anno": "15.9908",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "161",
                "p_value": "7.84e-09",
                "e_value": "7.84e-09",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "775",
                        "ms1_scans": "961",
                        "ids": "187",
                        "scans": "964",
                        "precursor_mono_mass": "9544.1743",
                        "precursor_charge": "13",
                        "precursor_mz": "735.1745",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "187",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6186",
                                "monoisotopic_mz": "797.4437",
                                "intensity": "20498.85",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "715.9217",
                                "intensity": "15794.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "2",
                                "monoisotopic_mass": "4877.6881",
                                "monoisotopic_mz": "813.9553",
                                "intensity": "12720.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8283",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "4779.26",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "4",
                                "monoisotopic_mass": "5117.8260",
                                "monoisotopic_mz": "853.9783",
                                "intensity": "4563.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "5",
                                "monoisotopic_mass": "3348.7889",
                                "monoisotopic_mz": "838.2045",
                                "intensity": "7030.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "6",
                                "monoisotopic_mass": "5100.8165",
                                "monoisotopic_mz": "729.6953",
                                "intensity": "5103.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "7",
                                "monoisotopic_mass": "4990.7721",
                                "monoisotopic_mz": "832.8026",
                                "intensity": "5252.89",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "8",
                                "monoisotopic_mass": "2810.4840",
                                "monoisotopic_mz": "703.6283",
                                "intensity": "2655.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "9",
                                "monoisotopic_mass": "4875.6874",
                                "monoisotopic_mz": "697.5340",
                                "intensity": "3923.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "10",
                                "monoisotopic_mass": "1642.9405",
                                "monoisotopic_mz": "822.4775",
                                "intensity": "2885.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "11",
                                "monoisotopic_mass": "4574.5274",
                                "monoisotopic_mz": "763.4285",
                                "intensity": "4420.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4574.5310",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "12",
                                "monoisotopic_mass": "6148.3473",
                                "monoisotopic_mz": "879.3426",
                                "intensity": "5677.10",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0175",
                                        "ppm": "2.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "13",
                                "monoisotopic_mass": "1855.0493",
                                "monoisotopic_mz": "928.5319",
                                "intensity": "2598.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "14",
                                "monoisotopic_mass": "2360.7989",
                                "monoisotopic_mz": "787.9402",
                                "intensity": "1506.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "15",
                                "monoisotopic_mass": "1332.7761",
                                "monoisotopic_mz": "667.3953",
                                "intensity": "2010.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "16",
                                "monoisotopic_mass": "2994.6003",
                                "monoisotopic_mz": "749.6574",
                                "intensity": "2862.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "17",
                                "monoisotopic_mass": "1453.7821",
                                "monoisotopic_mz": "727.8983",
                                "intensity": "2073.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "18",
                                "monoisotopic_mass": "3446.8597",
                                "monoisotopic_mz": "862.7222",
                                "intensity": "3561.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "19",
                                "monoisotopic_mass": "3135.6818",
                                "monoisotopic_mz": "784.9277",
                                "intensity": "953.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "20",
                                "monoisotopic_mass": "5269.9438",
                                "monoisotopic_mz": "879.3312",
                                "intensity": "674.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "21",
                                "monoisotopic_mass": "3249.7223",
                                "monoisotopic_mz": "813.4379",
                                "intensity": "5045.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "22",
                                "monoisotopic_mass": "683.0897",
                                "monoisotopic_mz": "684.0970",
                                "intensity": "2354.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "23",
                                "monoisotopic_mass": "1430.8299",
                                "monoisotopic_mz": "1431.8372",
                                "intensity": "720.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "24",
                                "monoisotopic_mass": "2975.5928",
                                "monoisotopic_mz": "744.9055",
                                "intensity": "1178.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "25",
                                "monoisotopic_mass": "1496.2961",
                                "monoisotopic_mz": "749.1553",
                                "intensity": "560.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "26",
                                "monoisotopic_mass": "1565.8390",
                                "monoisotopic_mz": "783.9268",
                                "intensity": "1592.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "27",
                                "monoisotopic_mass": "3429.8323",
                                "monoisotopic_mz": "858.4654",
                                "intensity": "1043.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "28",
                                "monoisotopic_mass": "1283.7227",
                                "monoisotopic_mz": "642.8687",
                                "intensity": "640.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "29",
                                "monoisotopic_mass": "3195.7190",
                                "monoisotopic_mz": "799.9370",
                                "intensity": "1765.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "30",
                                "monoisotopic_mass": "765.9046",
                                "monoisotopic_mz": "766.9119",
                                "intensity": "1279.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "31",
                                "monoisotopic_mass": "736.7718",
                                "monoisotopic_mz": "737.7791",
                                "intensity": "1485.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "32",
                                "monoisotopic_mass": "4862.6910",
                                "monoisotopic_mz": "811.4558",
                                "intensity": "1010.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "33",
                                "monoisotopic_mass": "1713.9792",
                                "monoisotopic_mz": "857.9969",
                                "intensity": "2323.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "0.0014",
                                        "ppm": "0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "34",
                                "monoisotopic_mass": "4278.6098",
                                "monoisotopic_mz": "714.1089",
                                "intensity": "793.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "35",
                                "monoisotopic_mass": "797.9433",
                                "monoisotopic_mz": "798.9506",
                                "intensity": "1089.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "36",
                                "monoisotopic_mass": "985.0684",
                                "monoisotopic_mz": "986.0756",
                                "intensity": "1963.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "37",
                                "monoisotopic_mass": "1283.7262",
                                "monoisotopic_mz": "1284.7335",
                                "intensity": "652.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "38",
                                "monoisotopic_mass": "1466.1003",
                                "monoisotopic_mz": "734.0574",
                                "intensity": "612.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "39",
                                "monoisotopic_mass": "1261.7380",
                                "monoisotopic_mz": "631.8763",
                                "intensity": "2580.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0014",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "40",
                                "monoisotopic_mass": "6102.0431",
                                "monoisotopic_mz": "763.7627",
                                "intensity": "1010.86",
                                "charge": "8"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "41",
                                "monoisotopic_mass": "893.0096",
                                "monoisotopic_mz": "894.0168",
                                "intensity": "1296.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "42",
                                "monoisotopic_mass": "1411.8194",
                                "monoisotopic_mz": "706.9170",
                                "intensity": "1468.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "43",
                                "monoisotopic_mass": "1089.2575",
                                "monoisotopic_mz": "1090.2648",
                                "intensity": "567.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "44",
                                "monoisotopic_mass": "2202.1692",
                                "monoisotopic_mz": "735.0637",
                                "intensity": "1434.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "45",
                                "monoisotopic_mass": "3555.8340",
                                "monoisotopic_mz": "889.9658",
                                "intensity": "831.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "46",
                                "monoisotopic_mass": "5506.7682",
                                "monoisotopic_mz": "787.6884",
                                "intensity": "1879.40",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "47",
                                "monoisotopic_mass": "5396.5373",
                                "monoisotopic_mz": "675.5744",
                                "intensity": "677.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "48",
                                "monoisotopic_mass": "4153.0165",
                                "monoisotopic_mz": "831.6106",
                                "intensity": "763.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "49",
                                "monoisotopic_mass": "721.6890",
                                "monoisotopic_mz": "722.6963",
                                "intensity": "799.23",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9544.4593",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "187",
                                        "peak_id": "12",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "187",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "187",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "187",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "187",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "187",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "187",
                                        "peak_id": "33",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "187",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "187",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "187",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "187",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "187",
                                        "peak_id": "39",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "32",
                            "anno": "15.2706",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "55",
                "p_value": "1.76e-08",
                "e_value": "1.76e-08",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "223",
                        "ms1_scans": "292",
                        "ids": "68",
                        "scans": "293",
                        "precursor_mono_mass": "9544.1711",
                        "precursor_charge": "13",
                        "precursor_mz": "735.1743",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "68",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6197",
                                "monoisotopic_mz": "797.4439",
                                "intensity": "18488.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8290",
                                "monoisotopic_mz": "715.9218",
                                "intensity": "15631.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6227",
                                "monoisotopic_mz": "683.6677",
                                "intensity": "7859.42",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0018",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "3",
                                "monoisotopic_mass": "4877.6863",
                                "monoisotopic_mz": "813.9550",
                                "intensity": "10327.91",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8282",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "6788.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "5",
                                "monoisotopic_mass": "5100.8212",
                                "monoisotopic_mz": "729.6960",
                                "intensity": "6598.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "6",
                                "monoisotopic_mass": "3348.7867",
                                "monoisotopic_mz": "838.2040",
                                "intensity": "8986.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "7",
                                "monoisotopic_mass": "4989.7530",
                                "monoisotopic_mz": "832.6328",
                                "intensity": "7297.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "8",
                                "monoisotopic_mass": "4762.6012",
                                "monoisotopic_mz": "794.7741",
                                "intensity": "4094.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "9",
                                "monoisotopic_mass": "1261.7391",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "1898.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "10",
                                "monoisotopic_mass": "1496.7982",
                                "monoisotopic_mz": "749.4064",
                                "intensity": "2502.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "11",
                                "monoisotopic_mass": "1332.7757",
                                "monoisotopic_mz": "667.3951",
                                "intensity": "1962.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "12",
                                "monoisotopic_mass": "3248.7208",
                                "monoisotopic_mz": "813.1875",
                                "intensity": "4788.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "13",
                                "monoisotopic_mass": "1856.0528",
                                "monoisotopic_mz": "929.0337",
                                "intensity": "2884.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0007",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "14",
                                "monoisotopic_mass": "892.5069",
                                "monoisotopic_mz": "893.5142",
                                "intensity": "2750.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "15",
                                "monoisotopic_mass": "3064.6416",
                                "monoisotopic_mz": "767.1677",
                                "intensity": "1227.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "16",
                                "monoisotopic_mass": "3284.7695",
                                "monoisotopic_mz": "822.1997",
                                "intensity": "2388.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "17",
                                "monoisotopic_mass": "3192.7022",
                                "monoisotopic_mz": "799.1828",
                                "intensity": "2828.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "18",
                                "monoisotopic_mass": "3011.6001",
                                "monoisotopic_mz": "753.9073",
                                "intensity": "2448.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "19",
                                "monoisotopic_mass": "1969.1369",
                                "monoisotopic_mz": "985.5757",
                                "intensity": "1002.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "0.0008",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "20",
                                "monoisotopic_mass": "500.2225",
                                "monoisotopic_mz": "501.2298",
                                "intensity": "1779.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "21",
                                "monoisotopic_mass": "4990.7695",
                                "monoisotopic_mz": "713.9744",
                                "intensity": "1028.89",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0039",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "22",
                                "monoisotopic_mass": "821.4685",
                                "monoisotopic_mz": "822.4758",
                                "intensity": "1059.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "23",
                                "monoisotopic_mass": "2551.9062",
                                "monoisotopic_mz": "851.6427",
                                "intensity": "775.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "24",
                                "monoisotopic_mass": "3662.9457",
                                "monoisotopic_mz": "916.7437",
                                "intensity": "789.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "25",
                                "monoisotopic_mass": "3462.8708",
                                "monoisotopic_mz": "866.7250",
                                "intensity": "833.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "26",
                                "monoisotopic_mass": "1114.6699",
                                "monoisotopic_mz": "558.3422",
                                "intensity": "1217.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "27",
                                "monoisotopic_mass": "626.3361",
                                "monoisotopic_mz": "627.3434",
                                "intensity": "850.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "28",
                                "monoisotopic_mass": "696.3796",
                                "monoisotopic_mz": "697.3868",
                                "intensity": "1096.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "29",
                                "monoisotopic_mass": "1116.9333",
                                "monoisotopic_mz": "1117.9406",
                                "intensity": "645.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "30",
                                "monoisotopic_mass": "3265.7654",
                                "monoisotopic_mz": "817.4486",
                                "intensity": "1358.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "31",
                                "monoisotopic_mass": "3332.7684",
                                "monoisotopic_mz": "834.1994",
                                "intensity": "2174.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "32",
                                "monoisotopic_mass": "1059.8088",
                                "monoisotopic_mz": "1060.8160",
                                "intensity": "626.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "33",
                                "monoisotopic_mass": "1403.7438",
                                "monoisotopic_mz": "702.8792",
                                "intensity": "713.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "34",
                                "monoisotopic_mass": "2993.5947",
                                "monoisotopic_mz": "599.7262",
                                "intensity": "1050.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "35",
                                "monoisotopic_mass": "3449.8606",
                                "monoisotopic_mz": "863.4724",
                                "intensity": "937.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "36",
                                "monoisotopic_mass": "930.4284",
                                "monoisotopic_mz": "931.4357",
                                "intensity": "1965.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "37",
                                "monoisotopic_mass": "1701.6093",
                                "monoisotopic_mz": "851.8119",
                                "intensity": "2684.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "38",
                                "monoisotopic_mass": "5778.1457",
                                "monoisotopic_mz": "723.2755",
                                "intensity": "1243.25",
                                "charge": "8"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "39",
                                "monoisotopic_mass": "803.6822",
                                "monoisotopic_mz": "804.6895",
                                "intensity": "891.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "40",
                                "monoisotopic_mass": "4256.2496",
                                "monoisotopic_mz": "1065.0697",
                                "intensity": "909.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "41",
                                "monoisotopic_mass": "743.4535",
                                "monoisotopic_mz": "744.4608",
                                "intensity": "1315.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "743.4542",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "42",
                                "monoisotopic_mass": "1015.6014",
                                "monoisotopic_mz": "508.8080",
                                "intensity": "1460.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "43",
                                "monoisotopic_mass": "2349.7527",
                                "monoisotopic_mz": "784.2582",
                                "intensity": "895.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "44",
                                "monoisotopic_mass": "1455.2796",
                                "monoisotopic_mz": "728.6471",
                                "intensity": "547.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "45",
                                "monoisotopic_mass": "8664.0425",
                                "monoisotopic_mz": "867.4115",
                                "intensity": "625.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "46",
                                "monoisotopic_mass": "1429.8316",
                                "monoisotopic_mz": "1430.8389",
                                "intensity": "1769.00",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0023",
                                        "ppm": "1.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "47",
                                "monoisotopic_mass": "1352.3348",
                                "monoisotopic_mz": "677.1747",
                                "intensity": "619.31",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9544.4561",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "68",
                                        "peak_id": "21",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "68",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "68",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "68",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "68",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "68",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "68",
                                            "peak_id": "4",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "68",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "68",
                                            "peak_id": "46",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "68",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "68",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "spec_id": "68",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "68",
                                        "peak_id": "42",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "spec_id": "68",
                                        "peak_id": "41",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "43",
                            "anno": "15.2675",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "8",
                "p_value": "2.75e-08",
                "e_value": "2.75e-08",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "18",
                        "ms1_scans": "28",
                        "ids": "9",
                        "scans": "29",
                        "precursor_mono_mass": "9545.1772",
                        "precursor_charge": "13",
                        "precursor_mz": "735.2517",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "9",
                                "peak_id": "0",
                                "monoisotopic_mass": "4876.6897",
                                "monoisotopic_mz": "813.7889",
                                "intensity": "13675.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "1",
                                "monoisotopic_mass": "4777.6184",
                                "monoisotopic_mz": "797.2770",
                                "intensity": "22689.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "2",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "715.9217",
                                "intensity": "20078.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "3",
                                "monoisotopic_mass": "4778.6197",
                                "monoisotopic_mz": "683.6672",
                                "intensity": "9142.62",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "4",
                                "monoisotopic_mass": "4876.6876",
                                "monoisotopic_mz": "697.6769",
                                "intensity": "8451.33",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "5",
                                "monoisotopic_mass": "3348.7896",
                                "monoisotopic_mz": "838.2047",
                                "intensity": "10478.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "6",
                                "monoisotopic_mass": "5100.8101",
                                "monoisotopic_mz": "729.6944",
                                "intensity": "9651.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "7",
                                "monoisotopic_mass": "3249.7248",
                                "monoisotopic_mz": "813.4385",
                                "intensity": "6576.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "8",
                                "monoisotopic_mass": "1856.0540",
                                "monoisotopic_mz": "929.0343",
                                "intensity": "4314.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0020",
                                        "ppm": "1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "9",
                                "monoisotopic_mass": "1785.0121",
                                "monoisotopic_mz": "893.5133",
                                "intensity": "3259.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0028",
                                        "ppm": "-1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "10",
                                "monoisotopic_mass": "1642.9409",
                                "monoisotopic_mz": "822.4777",
                                "intensity": "3507.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0002",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "11",
                                "monoisotopic_mass": "2495.3876",
                                "monoisotopic_mz": "832.8032",
                                "intensity": "5322.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "12",
                                "monoisotopic_mass": "1429.8287",
                                "monoisotopic_mz": "477.6169",
                                "intensity": "10082.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "13",
                                "monoisotopic_mass": "1261.7391",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "3834.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "14",
                                "monoisotopic_mass": "1497.3027",
                                "monoisotopic_mz": "749.6586",
                                "intensity": "3711.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "15",
                                "monoisotopic_mass": "5117.8242",
                                "monoisotopic_mz": "853.9780",
                                "intensity": "3471.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0054",
                                        "ppm": "-1.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "16",
                                "monoisotopic_mass": "3670.9922",
                                "monoisotopic_mz": "735.2057",
                                "intensity": "2903.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "17",
                                "monoisotopic_mass": "2209.3133",
                                "monoisotopic_mz": "737.4451",
                                "intensity": "2086.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "18",
                                "monoisotopic_mass": "4760.5955",
                                "monoisotopic_mz": "681.0923",
                                "intensity": "1210.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "19",
                                "monoisotopic_mass": "4721.5878",
                                "monoisotopic_mz": "787.9386",
                                "intensity": "4115.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0116",
                                        "ppm": "-2.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "20",
                                "monoisotopic_mass": "4780.6243",
                                "monoisotopic_mz": "957.1321",
                                "intensity": "1820.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "21",
                                "monoisotopic_mass": "2430.8390",
                                "monoisotopic_mz": "811.2869",
                                "intensity": "2041.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "22",
                                "monoisotopic_mass": "3349.7900",
                                "monoisotopic_mz": "670.9653",
                                "intensity": "2604.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "23",
                                "monoisotopic_mass": "4991.7748",
                                "monoisotopic_mz": "714.1180",
                                "intensity": "4943.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "24",
                                "monoisotopic_mass": "507.8009",
                                "monoisotopic_mz": "508.8082",
                                "intensity": "1161.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "25",
                                "monoisotopic_mass": "1714.9811",
                                "monoisotopic_mz": "858.4978",
                                "intensity": "2810.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "26",
                                "monoisotopic_mass": "1446.7778",
                                "monoisotopic_mz": "724.3962",
                                "intensity": "1730.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "27",
                                "monoisotopic_mass": "1429.8293",
                                "monoisotopic_mz": "1430.8365",
                                "intensity": "1841.91",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "28",
                                "monoisotopic_mass": "859.3918",
                                "monoisotopic_mz": "860.3991",
                                "intensity": "1571.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "29",
                                "monoisotopic_mass": "6032.2812",
                                "monoisotopic_mz": "862.7617",
                                "intensity": "724.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "30",
                                "monoisotopic_mass": "2287.2670",
                                "monoisotopic_mz": "763.4296",
                                "intensity": "2421.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "31",
                                "monoisotopic_mass": "1461.7854",
                                "monoisotopic_mz": "731.9000",
                                "intensity": "1570.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "32",
                                "monoisotopic_mass": "3135.6750",
                                "monoisotopic_mz": "784.9260",
                                "intensity": "2700.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "33",
                                "monoisotopic_mass": "2809.4822",
                                "monoisotopic_mz": "703.3778",
                                "intensity": "3158.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "34",
                                "monoisotopic_mass": "1607.3663",
                                "monoisotopic_mz": "804.6904",
                                "intensity": "2479.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "35",
                                "monoisotopic_mass": "3670.9705",
                                "monoisotopic_mz": "918.7499",
                                "intensity": "983.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "36",
                                "monoisotopic_mass": "666.3881",
                                "monoisotopic_mz": "667.3953",
                                "intensity": "939.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "37",
                                "monoisotopic_mass": "4649.5138",
                                "monoisotopic_mz": "775.9262",
                                "intensity": "1032.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "38",
                                "monoisotopic_mass": "4701.5800",
                                "monoisotopic_mz": "672.6616",
                                "intensity": "2188.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "39",
                                "monoisotopic_mass": "790.4324",
                                "monoisotopic_mz": "791.4397",
                                "intensity": "1264.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "40",
                                "monoisotopic_mass": "743.4540",
                                "monoisotopic_mz": "744.4612",
                                "intensity": "1602.23",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "743.4542",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "41",
                                "monoisotopic_mass": "4257.2344",
                                "monoisotopic_mz": "1065.3159",
                                "intensity": "1064.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "42",
                                "monoisotopic_mass": "1082.5732",
                                "monoisotopic_mz": "1083.5804",
                                "intensity": "1503.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "43",
                                "monoisotopic_mass": "1015.6010",
                                "monoisotopic_mz": "1016.6083",
                                "intensity": "2269.61",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "44",
                                "monoisotopic_mass": "2908.5544",
                                "monoisotopic_mz": "728.1459",
                                "intensity": "1988.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "45",
                                "monoisotopic_mass": "4720.6022",
                                "monoisotopic_mz": "675.3790",
                                "intensity": "1433.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "46",
                                "monoisotopic_mass": "7820.7486",
                                "monoisotopic_mz": "783.0821",
                                "intensity": "1138.48",
                                "charge": "10"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "47",
                                "monoisotopic_mass": "5995.9892",
                                "monoisotopic_mz": "857.5772",
                                "intensity": "969.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "48",
                                "monoisotopic_mass": "6997.7745",
                                "monoisotopic_mz": "700.7847",
                                "intensity": "785.21",
                                "charge": "10"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "49",
                                "monoisotopic_mass": "3216.7355",
                                "monoisotopic_mz": "805.1911",
                                "intensity": "833.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "50",
                                "monoisotopic_mass": "3380.2186",
                                "monoisotopic_mz": "846.0619",
                                "intensity": "921.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "51",
                                "monoisotopic_mass": "3937.2236",
                                "monoisotopic_mz": "788.4520",
                                "intensity": "649.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "52",
                                "monoisotopic_mass": "3559.9517",
                                "monoisotopic_mz": "890.9952",
                                "intensity": "771.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "53",
                                "monoisotopic_mass": "1114.6706",
                                "monoisotopic_mz": "558.3426",
                                "intensity": "1407.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "54",
                                "monoisotopic_mass": "8615.4122",
                                "monoisotopic_mz": "784.2266",
                                "intensity": "3464.73",
                                "charge": "11"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "55",
                                "monoisotopic_mass": "1043.5135",
                                "monoisotopic_mz": "1044.5208",
                                "intensity": "1522.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "56",
                                "monoisotopic_mass": "906.6100",
                                "monoisotopic_mz": "907.6172",
                                "intensity": "668.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "57",
                                "monoisotopic_mass": "1064.3107",
                                "monoisotopic_mz": "1065.3180",
                                "intensity": "1103.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "58",
                                "monoisotopic_mass": "1379.9452",
                                "monoisotopic_mz": "690.9799",
                                "intensity": "1671.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "59",
                                "monoisotopic_mass": "4579.3768",
                                "monoisotopic_mz": "764.2367",
                                "intensity": "776.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "60",
                                "monoisotopic_mass": "1283.7236",
                                "monoisotopic_mz": "642.8691",
                                "intensity": "1140.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "61",
                                "monoisotopic_mass": "3190.7468",
                                "monoisotopic_mz": "798.6940",
                                "intensity": "3187.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "62",
                                "monoisotopic_mass": "1568.3633",
                                "monoisotopic_mz": "785.1889",
                                "intensity": "1493.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "63",
                                "monoisotopic_mass": "5992.3205",
                                "monoisotopic_mz": "750.0473",
                                "intensity": "1912.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "64",
                                "monoisotopic_mass": "5847.3008",
                                "monoisotopic_mz": "731.9199",
                                "intensity": "2054.71",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "16.0935651271",
                                        "theoretical_mass": "5847.3011",
                                        "ion_position": "35",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "65",
                                "monoisotopic_mass": "683.3729",
                                "monoisotopic_mz": "684.3802",
                                "intensity": "625.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "66",
                                "monoisotopic_mass": "726.2582",
                                "monoisotopic_mz": "727.2655",
                                "intensity": "947.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "67",
                                "monoisotopic_mass": "833.7010",
                                "monoisotopic_mz": "834.7083",
                                "intensity": "1067.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "9",
                                "peak_id": "68",
                                "monoisotopic_mass": "702.6107",
                                "monoisotopic_mz": "703.6179",
                                "intensity": "747.76",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.2822",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "55",
                                        "spec_id": "9",
                                        "peak_id": "64",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "9",
                                        "peak_id": "15",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "9",
                                        "peak_id": "3",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "9",
                                        "peak_id": "19",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "9",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "9",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "9",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "9",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "9",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "9",
                                            "peak_id": "27",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "9",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "spec_id": "9",
                                        "peak_id": "53",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "9",
                                        "peak_id": "43",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "spec_id": "9",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "35",
                            "right_position": "42",
                            "anno": "16.0936",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "109",
                "p_value": "4.15e-08",
                "e_value": "4.15e-08",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "400",
                        "ms1_scans": "530",
                        "ids": "129",
                        "scans": "531",
                        "precursor_mono_mass": "9545.1751",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4385",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "129",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6215",
                                "monoisotopic_mz": "797.4442",
                                "intensity": "34362.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6896",
                                "monoisotopic_mz": "813.9555",
                                "intensity": "19864.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0002",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7659",
                                "monoisotopic_mz": "832.8016",
                                "intensity": "11776.34",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0075",
                                        "ppm": "-1.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "3",
                                "monoisotopic_mass": "5118.8207",
                                "monoisotopic_mz": "854.1441",
                                "intensity": "13260.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0113",
                                        "ppm": "-2.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "4",
                                "monoisotopic_mass": "4760.6087",
                                "monoisotopic_mz": "794.4421",
                                "intensity": "5827.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "5",
                                "monoisotopic_mass": "1429.8290",
                                "monoisotopic_mz": "715.9218",
                                "intensity": "9575.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "6",
                                "monoisotopic_mass": "6147.3282",
                                "monoisotopic_mz": "879.1970",
                                "intensity": "6793.45",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0008",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "7",
                                "monoisotopic_mass": "6403.4875",
                                "monoisotopic_mz": "915.7912",
                                "intensity": "8496.46",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6403.4881",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "8",
                                "monoisotopic_mass": "2209.3135",
                                "monoisotopic_mz": "737.4451",
                                "intensity": "3690.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "9",
                                "monoisotopic_mass": "4700.5853",
                                "monoisotopic_mz": "784.4382",
                                "intensity": "7354.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "10",
                                "monoisotopic_mass": "1785.0141",
                                "monoisotopic_mz": "893.5143",
                                "intensity": "3183.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "11",
                                "monoisotopic_mass": "4721.5988",
                                "monoisotopic_mz": "787.9404",
                                "intensity": "4637.15",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "12",
                                "monoisotopic_mass": "1855.0487",
                                "monoisotopic_mz": "928.5316",
                                "intensity": "3267.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "13",
                                "monoisotopic_mass": "3022.6416",
                                "monoisotopic_mz": "756.6677",
                                "intensity": "2579.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "14",
                                "monoisotopic_mass": "1429.8275",
                                "monoisotopic_mz": "477.6165",
                                "intensity": "2100.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "15",
                                "monoisotopic_mass": "6314.4302",
                                "monoisotopic_mz": "903.0687",
                                "intensity": "2266.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "16",
                                "monoisotopic_mass": "3348.7782",
                                "monoisotopic_mz": "838.2018",
                                "intensity": "6321.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "17",
                                "monoisotopic_mass": "2550.9039",
                                "monoisotopic_mz": "851.3086",
                                "intensity": "3762.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "18",
                                "monoisotopic_mass": "2993.6024",
                                "monoisotopic_mz": "749.4079",
                                "intensity": "4667.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "19",
                                "monoisotopic_mass": "1598.8703",
                                "monoisotopic_mz": "800.4424",
                                "intensity": "1878.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "20",
                                "monoisotopic_mass": "4310.2920",
                                "monoisotopic_mz": "1078.5803",
                                "intensity": "3449.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "21",
                                "monoisotopic_mass": "1969.1349",
                                "monoisotopic_mz": "985.5747",
                                "intensity": "2897.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "22",
                                "monoisotopic_mass": "4256.2460",
                                "monoisotopic_mz": "1065.0688",
                                "intensity": "7869.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "23",
                                "monoisotopic_mass": "3447.8596",
                                "monoisotopic_mz": "862.9722",
                                "intensity": "3383.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "24",
                                "monoisotopic_mass": "4326.2788",
                                "monoisotopic_mz": "1082.5770",
                                "intensity": "2264.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "25",
                                "monoisotopic_mass": "7143.8113",
                                "monoisotopic_mz": "794.7641",
                                "intensity": "778.33",
                                "charge": "9"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "26",
                                "monoisotopic_mass": "864.4680",
                                "monoisotopic_mz": "865.4753",
                                "intensity": "1323.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "27",
                                "monoisotopic_mass": "743.4534",
                                "monoisotopic_mz": "744.4607",
                                "intensity": "950.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "743.4542",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0008",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "28",
                                "monoisotopic_mass": "8399.0856",
                                "monoisotopic_mz": "934.2390",
                                "intensity": "1498.10",
                                "charge": "9"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "29",
                                "monoisotopic_mass": "3458.8659",
                                "monoisotopic_mz": "865.7237",
                                "intensity": "2871.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "30",
                                "monoisotopic_mass": "3265.7619",
                                "monoisotopic_mz": "817.4478",
                                "intensity": "6516.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "31",
                                "monoisotopic_mass": "3250.7265",
                                "monoisotopic_mz": "813.6889",
                                "intensity": "989.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "32",
                                "monoisotopic_mass": "6339.4986",
                                "monoisotopic_mz": "793.4446",
                                "intensity": "1233.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "33",
                                "monoisotopic_mass": "6263.3478",
                                "monoisotopic_mz": "783.9257",
                                "intensity": "1092.92",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "34",
                                "monoisotopic_mass": "2922.5674",
                                "monoisotopic_mz": "731.6491",
                                "intensity": "1771.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "35",
                                "monoisotopic_mass": "4105.4283",
                                "monoisotopic_mz": "822.0929",
                                "intensity": "2509.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "36",
                                "monoisotopic_mass": "2583.3770",
                                "monoisotopic_mz": "862.1329",
                                "intensity": "998.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "37",
                                "monoisotopic_mass": "2300.7333",
                                "monoisotopic_mz": "767.9184",
                                "intensity": "1036.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "38",
                                "monoisotopic_mass": "760.4011",
                                "monoisotopic_mz": "761.4084",
                                "intensity": "1137.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "39",
                                "monoisotopic_mass": "997.8504",
                                "monoisotopic_mz": "998.8577",
                                "intensity": "997.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "40",
                                "monoisotopic_mass": "4393.3872",
                                "monoisotopic_mz": "879.6847",
                                "intensity": "1887.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "41",
                                "monoisotopic_mass": "6472.4530",
                                "monoisotopic_mz": "810.0639",
                                "intensity": "887.63",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "42",
                                "monoisotopic_mass": "9530.5785",
                                "monoisotopic_mz": "867.4235",
                                "intensity": "1006.79",
                                "charge": "11"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "43",
                                "monoisotopic_mass": "914.9268",
                                "monoisotopic_mz": "915.9341",
                                "intensity": "880.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "44",
                                "monoisotopic_mass": "6261.4086",
                                "monoisotopic_mz": "895.4942",
                                "intensity": "3463.83",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6261.4139",
                                        "ion_position": "31",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0053",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "45",
                                "monoisotopic_mass": "1458.8071",
                                "monoisotopic_mz": "730.4108",
                                "intensity": "1201.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "46",
                                "monoisotopic_mass": "4944.9398",
                                "monoisotopic_mz": "989.9952",
                                "intensity": "2219.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "47",
                                "monoisotopic_mass": "794.4057",
                                "monoisotopic_mz": "795.4130",
                                "intensity": "1645.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "48",
                                "monoisotopic_mass": "1429.8294",
                                "monoisotopic_mz": "1430.8367",
                                "intensity": "701.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0001",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "49",
                                "monoisotopic_mass": "5702.0178",
                                "monoisotopic_mz": "713.7595",
                                "intensity": "888.01",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "50",
                                "monoisotopic_mass": "6095.3839",
                                "monoisotopic_mz": "762.9303",
                                "intensity": "1565.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "51",
                                "monoisotopic_mass": "5427.3600",
                                "monoisotopic_mz": "905.5673",
                                "intensity": "3151.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "52",
                                "monoisotopic_mass": "1411.8187",
                                "monoisotopic_mz": "706.9166",
                                "intensity": "752.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "53",
                                "monoisotopic_mass": "4278.0796",
                                "monoisotopic_mz": "856.6232",
                                "intensity": "1047.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "54",
                                "monoisotopic_mass": "956.2832",
                                "monoisotopic_mz": "957.2905",
                                "intensity": "745.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "55",
                                "monoisotopic_mass": "773.9990",
                                "monoisotopic_mz": "775.0063",
                                "intensity": "1043.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "56",
                                "monoisotopic_mass": "1041.5584",
                                "monoisotopic_mz": "1042.5657",
                                "intensity": "874.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "57",
                                "monoisotopic_mass": "2635.5900",
                                "monoisotopic_mz": "879.5373",
                                "intensity": "1432.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "58",
                                "monoisotopic_mass": "809.6909",
                                "monoisotopic_mz": "810.6982",
                                "intensity": "824.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "59",
                                "monoisotopic_mass": "730.8965",
                                "monoisotopic_mz": "731.9038",
                                "intensity": "599.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "60",
                                "monoisotopic_mass": "1394.1631",
                                "monoisotopic_mz": "698.0888",
                                "intensity": "808.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "61",
                                "monoisotopic_mass": "840.0264",
                                "monoisotopic_mz": "841.0337",
                                "intensity": "853.14",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.4601",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "spec_id": "129",
                                        "peak_id": "7",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "59",
                                        "spec_id": "129",
                                        "peak_id": "44",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "129",
                                        "peak_id": "6",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "129",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "129",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "129",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "129",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "129",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "129",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "129",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "129",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "129",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "129",
                                            "peak_id": "48",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "spec_id": "129",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "29",
                            "anno": "16.2714",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "137",
                "p_value": "4.53e-08",
                "e_value": "4.53e-08",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "477",
                        "ms1_scans": "638",
                        "ids": "160",
                        "scans": "639",
                        "precursor_mono_mass": "9545.1751",
                        "precursor_charge": "12",
                        "precursor_mz": "796.4385",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "160",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6226",
                                "monoisotopic_mz": "797.4444",
                                "intensity": "37820.71",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "1",
                                "monoisotopic_mass": "4990.7747",
                                "monoisotopic_mz": "832.8031",
                                "intensity": "14675.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0013",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "2",
                                "monoisotopic_mass": "4877.6848",
                                "monoisotopic_mz": "813.9547",
                                "intensity": "15263.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "3",
                                "monoisotopic_mass": "5118.8350",
                                "monoisotopic_mz": "854.1464",
                                "intensity": "10359.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0030",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8293",
                                "monoisotopic_mz": "715.9219",
                                "intensity": "10304.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "5",
                                "monoisotopic_mass": "5100.8105",
                                "monoisotopic_mz": "729.6945",
                                "intensity": "7066.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "6",
                                "monoisotopic_mass": "4698.5791",
                                "monoisotopic_mz": "784.1038",
                                "intensity": "6744.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "7",
                                "monoisotopic_mass": "6148.3422",
                                "monoisotopic_mz": "879.3419",
                                "intensity": "7219.15",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0124",
                                        "ppm": "2.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "8",
                                "monoisotopic_mass": "4327.2823",
                                "monoisotopic_mz": "1082.8278",
                                "intensity": "3713.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "9",
                                "monoisotopic_mass": "3266.7634",
                                "monoisotopic_mz": "817.6981",
                                "intensity": "3858.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "10",
                                "monoisotopic_mass": "4721.5966",
                                "monoisotopic_mz": "787.9400",
                                "intensity": "3577.85",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "11",
                                "monoisotopic_mass": "1856.0525",
                                "monoisotopic_mz": "929.0335",
                                "intensity": "2111.57",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0005",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "12",
                                "monoisotopic_mass": "928.0259",
                                "monoisotopic_mz": "929.0331",
                                "intensity": "3530.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "13",
                                "monoisotopic_mass": "3064.6399",
                                "monoisotopic_mz": "767.1672",
                                "intensity": "3966.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "14",
                                "monoisotopic_mass": "4778.6321",
                                "monoisotopic_mz": "956.7337",
                                "intensity": "2470.29",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0112",
                                        "ppm": "2.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "15",
                                "monoisotopic_mass": "3448.8655",
                                "monoisotopic_mz": "863.2237",
                                "intensity": "4602.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "16",
                                "monoisotopic_mass": "2210.3120",
                                "monoisotopic_mz": "737.7779",
                                "intensity": "2505.77",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0031",
                                        "ppm": "-1.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "17",
                                "monoisotopic_mass": "8702.6608",
                                "monoisotopic_mz": "792.1583",
                                "intensity": "1488.87",
                                "charge": "11"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "18",
                                "monoisotopic_mass": "784.2655",
                                "monoisotopic_mz": "785.2728",
                                "intensity": "2060.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "19",
                                "monoisotopic_mass": "1077.5678",
                                "monoisotopic_mz": "1078.5751",
                                "intensity": "2131.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "20",
                                "monoisotopic_mass": "1429.8276",
                                "monoisotopic_mz": "1430.8348",
                                "intensity": "2315.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "21",
                                "monoisotopic_mass": "4876.6841",
                                "monoisotopic_mz": "697.6764",
                                "intensity": "2755.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "22",
                                "monoisotopic_mass": "1785.0148",
                                "monoisotopic_mz": "893.5147",
                                "intensity": "2404.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "23",
                                "monoisotopic_mass": "7146.6661",
                                "monoisotopic_mz": "795.0813",
                                "intensity": "1617.41",
                                "charge": "9"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "24",
                                "monoisotopic_mass": "2809.4858",
                                "monoisotopic_mz": "703.3787",
                                "intensity": "2590.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "25",
                                "monoisotopic_mass": "3864.0819",
                                "monoisotopic_mz": "773.8237",
                                "intensity": "757.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "26",
                                "monoisotopic_mass": "2903.5610",
                                "monoisotopic_mz": "726.8975",
                                "intensity": "3060.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "27",
                                "monoisotopic_mass": "915.7856",
                                "monoisotopic_mz": "916.7928",
                                "intensity": "1349.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "28",
                                "monoisotopic_mass": "812.9455",
                                "monoisotopic_mz": "813.9528",
                                "intensity": "1348.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "29",
                                "monoisotopic_mass": "4238.2348",
                                "monoisotopic_mz": "1060.5660",
                                "intensity": "1975.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "30",
                                "monoisotopic_mass": "4762.6079",
                                "monoisotopic_mz": "794.7753",
                                "intensity": "2495.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "31",
                                "monoisotopic_mass": "3691.0215",
                                "monoisotopic_mz": "923.7627",
                                "intensity": "2764.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "32",
                                "monoisotopic_mass": "3091.6666",
                                "monoisotopic_mz": "773.9239",
                                "intensity": "1159.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "33",
                                "monoisotopic_mass": "5099.8125",
                                "monoisotopic_mz": "850.9760",
                                "intensity": "943.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "34",
                                "monoisotopic_mass": "3267.7577",
                                "monoisotopic_mz": "1090.2598",
                                "intensity": "2827.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.7748",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0172",
                                        "ppm": "-5.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "35",
                                "monoisotopic_mass": "2993.6003",
                                "monoisotopic_mz": "749.4074",
                                "intensity": "2725.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "36",
                                "monoisotopic_mass": "866.4702",
                                "monoisotopic_mz": "867.4775",
                                "intensity": "1224.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "37",
                                "monoisotopic_mass": "1642.9385",
                                "monoisotopic_mz": "822.4765",
                                "intensity": "1343.71",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0022",
                                        "ppm": "-1.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "38",
                                "monoisotopic_mass": "5547.1583",
                                "monoisotopic_mz": "793.4585",
                                "intensity": "2240.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "39",
                                "monoisotopic_mass": "4573.5320",
                                "monoisotopic_mz": "763.2626",
                                "intensity": "1231.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "40",
                                "monoisotopic_mass": "3162.7107",
                                "monoisotopic_mz": "791.6849",
                                "intensity": "1423.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "41",
                                "monoisotopic_mass": "6087.0097",
                                "monoisotopic_mz": "870.5801",
                                "intensity": "892.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "42",
                                "monoisotopic_mass": "1461.2866",
                                "monoisotopic_mz": "731.6506",
                                "intensity": "675.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "43",
                                "monoisotopic_mass": "3567.8047",
                                "monoisotopic_mz": "892.9585",
                                "intensity": "884.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "44",
                                "monoisotopic_mass": "9220.8173",
                                "monoisotopic_mz": "769.4087",
                                "intensity": "1227.82",
                                "charge": "12"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "45",
                                "monoisotopic_mass": "3960.5710",
                                "monoisotopic_mz": "793.1215",
                                "intensity": "1047.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "46",
                                "monoisotopic_mass": "4974.7475",
                                "monoisotopic_mz": "830.1319",
                                "intensity": "2289.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "47",
                                "monoisotopic_mass": "9278.5915",
                                "monoisotopic_mz": "774.2232",
                                "intensity": "1269.92",
                                "charge": "12"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "48",
                                "monoisotopic_mass": "1157.5560",
                                "monoisotopic_mz": "1158.5632",
                                "intensity": "712.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "49",
                                "monoisotopic_mass": "5894.0466",
                                "monoisotopic_mz": "843.0139",
                                "intensity": "2200.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "50",
                                "monoisotopic_mass": "6866.7284",
                                "monoisotopic_mz": "981.9685",
                                "intensity": "2337.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "51",
                                "monoisotopic_mass": "3176.5189",
                                "monoisotopic_mz": "795.1370",
                                "intensity": "1309.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "52",
                                "monoisotopic_mass": "9429.7088",
                                "monoisotopic_mz": "858.2535",
                                "intensity": "1233.63",
                                "charge": "11"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "53",
                                "monoisotopic_mass": "3135.7255",
                                "monoisotopic_mz": "784.9386",
                                "intensity": "2873.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "54",
                                "monoisotopic_mass": "974.1941",
                                "monoisotopic_mz": "975.2014",
                                "intensity": "1212.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "55",
                                "monoisotopic_mass": "1313.1021",
                                "monoisotopic_mz": "657.5584",
                                "intensity": "2084.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "56",
                                "monoisotopic_mass": "9455.1851",
                                "monoisotopic_mz": "788.9394",
                                "intensity": "2413.89",
                                "charge": "12"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "57",
                                "monoisotopic_mass": "1430.8318",
                                "monoisotopic_mz": "477.9512",
                                "intensity": "880.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "58",
                                "monoisotopic_mass": "1486.9105",
                                "monoisotopic_mz": "744.4625",
                                "intensity": "1949.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "59",
                                "monoisotopic_mass": "1060.8062",
                                "monoisotopic_mz": "1061.8135",
                                "intensity": "1249.67",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.4601",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "160",
                                        "peak_id": "34",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "160",
                                        "peak_id": "7",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "160",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "160",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "160",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "160",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "160",
                                            "peak_id": "14",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "160",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "160",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "160",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "160",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "160",
                                        "peak_id": "37",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "160",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "160",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "31",
                            "right_position": "32",
                            "anno": "16.2714",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "153",
                "p_value": "2.04e-07",
                "e_value": "2.04e-07",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "526",
                        "ms1_scans": "705",
                        "ids": "179",
                        "scans": "707",
                        "precursor_mono_mass": "9545.1717",
                        "precursor_charge": "13",
                        "precursor_mz": "735.2513",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "179",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6244",
                                "monoisotopic_mz": "797.4447",
                                "intensity": "18429.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0035",
                                        "ppm": "0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8296",
                                "monoisotopic_mz": "715.9221",
                                "intensity": "14533.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0002",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "2",
                                "monoisotopic_mass": "3348.7905",
                                "monoisotopic_mz": "838.2049",
                                "intensity": "5839.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "6525.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "4",
                                "monoisotopic_mass": "4877.6910",
                                "monoisotopic_mz": "813.9558",
                                "intensity": "7765.29",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0017",
                                        "ppm": "0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "5",
                                "monoisotopic_mass": "1856.0525",
                                "monoisotopic_mz": "929.0335",
                                "intensity": "3130.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0005",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "6",
                                "monoisotopic_mass": "4991.7899",
                                "monoisotopic_mz": "832.9723",
                                "intensity": "6524.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "7",
                                "monoisotopic_mass": "4875.6788",
                                "monoisotopic_mz": "697.5328",
                                "intensity": "3337.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "8",
                                "monoisotopic_mass": "3264.7523",
                                "monoisotopic_mz": "817.1953",
                                "intensity": "3644.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "9",
                                "monoisotopic_mass": "856.9892",
                                "monoisotopic_mz": "857.9965",
                                "intensity": "1819.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "10",
                                "monoisotopic_mass": "2922.5715",
                                "monoisotopic_mz": "731.6502",
                                "intensity": "3217.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "11",
                                "monoisotopic_mass": "930.4294",
                                "monoisotopic_mz": "931.4367",
                                "intensity": "1774.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "12",
                                "monoisotopic_mass": "3063.6413",
                                "monoisotopic_mz": "766.9176",
                                "intensity": "1666.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "13",
                                "monoisotopic_mass": "3007.7431",
                                "monoisotopic_mz": "752.9431",
                                "intensity": "1887.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "14",
                                "monoisotopic_mass": "4256.2505",
                                "monoisotopic_mz": "1065.0699",
                                "intensity": "1135.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "15",
                                "monoisotopic_mass": "2210.3140",
                                "monoisotopic_mz": "737.7786",
                                "intensity": "2491.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "16",
                                "monoisotopic_mass": "4763.6084",
                                "monoisotopic_mz": "681.5228",
                                "intensity": "1108.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "17",
                                "monoisotopic_mass": "5100.8208",
                                "monoisotopic_mz": "729.6960",
                                "intensity": "5402.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "18",
                                "monoisotopic_mass": "6131.2959",
                                "monoisotopic_mz": "876.9067",
                                "intensity": "1274.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "19",
                                "monoisotopic_mass": "1785.0142",
                                "monoisotopic_mz": "893.5144",
                                "intensity": "2311.36",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "20",
                                "monoisotopic_mass": "666.3877",
                                "monoisotopic_mz": "667.3950",
                                "intensity": "1153.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "21",
                                "monoisotopic_mass": "3348.7931",
                                "monoisotopic_mz": "670.7659",
                                "intensity": "888.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "22",
                                "monoisotopic_mass": "1261.7383",
                                "monoisotopic_mz": "631.8764",
                                "intensity": "1926.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "23",
                                "monoisotopic_mass": "2808.4842",
                                "monoisotopic_mz": "703.1283",
                                "intensity": "2407.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "24",
                                "monoisotopic_mass": "4721.5974",
                                "monoisotopic_mz": "787.9402",
                                "intensity": "2156.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "25",
                                "monoisotopic_mass": "734.3985",
                                "monoisotopic_mz": "735.4058",
                                "intensity": "1020.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "26",
                                "monoisotopic_mass": "1969.1332",
                                "monoisotopic_mz": "985.5739",
                                "intensity": "1955.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0029",
                                        "ppm": "-1.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "27",
                                "monoisotopic_mass": "820.1905",
                                "monoisotopic_mz": "821.1978",
                                "intensity": "942.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "28",
                                "monoisotopic_mass": "1529.8999",
                                "monoisotopic_mz": "765.9572",
                                "intensity": "1367.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "29",
                                "monoisotopic_mass": "2447.2734",
                                "monoisotopic_mz": "816.7651",
                                "intensity": "762.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "30",
                                "monoisotopic_mass": "1489.8001",
                                "monoisotopic_mz": "745.9073",
                                "intensity": "568.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "31",
                                "monoisotopic_mass": "3476.9856",
                                "monoisotopic_mz": "870.2537",
                                "intensity": "806.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "32",
                                "monoisotopic_mass": "1015.6021",
                                "monoisotopic_mz": "1016.6094",
                                "intensity": "633.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "33",
                                "monoisotopic_mass": "3134.6762",
                                "monoisotopic_mz": "784.6763",
                                "intensity": "1756.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "34",
                                "monoisotopic_mass": "1163.2193",
                                "monoisotopic_mz": "582.6169",
                                "intensity": "1030.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "35",
                                "monoisotopic_mass": "3020.6248",
                                "monoisotopic_mz": "756.1635",
                                "intensity": "1043.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "36",
                                "monoisotopic_mass": "3174.7071",
                                "monoisotopic_mz": "794.6841",
                                "intensity": "2388.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "37",
                                "monoisotopic_mass": "2992.5839",
                                "monoisotopic_mz": "749.1532",
                                "intensity": "2096.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "38",
                                "monoisotopic_mass": "4576.5343",
                                "monoisotopic_mz": "763.7630",
                                "intensity": "1358.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "39",
                                "monoisotopic_mass": "1065.5790",
                                "monoisotopic_mz": "1066.5863",
                                "intensity": "551.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "40",
                                "monoisotopic_mass": "3997.4338",
                                "monoisotopic_mz": "800.4940",
                                "intensity": "875.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "41",
                                "monoisotopic_mass": "1411.8170",
                                "monoisotopic_mz": "706.9158",
                                "intensity": "980.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "42",
                                "monoisotopic_mass": "1445.5395",
                                "monoisotopic_mz": "723.7770",
                                "intensity": "635.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "43",
                                "monoisotopic_mass": "1459.5898",
                                "monoisotopic_mz": "730.8022",
                                "intensity": "584.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "44",
                                "monoisotopic_mass": "2258.2573",
                                "monoisotopic_mz": "753.7597",
                                "intensity": "764.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "45",
                                "monoisotopic_mass": "2351.2951",
                                "monoisotopic_mz": "784.7723",
                                "intensity": "1294.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "46",
                                "monoisotopic_mass": "1095.5942",
                                "monoisotopic_mz": "1096.6015",
                                "intensity": "802.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "47",
                                "monoisotopic_mass": "762.9253",
                                "monoisotopic_mz": "763.9326",
                                "intensity": "411.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "179",
                                "peak_id": "48",
                                "monoisotopic_mass": "790.4349",
                                "monoisotopic_mz": "791.4422",
                                "intensity": "733.33",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "0",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9545.4567",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "179",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "179",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "179",
                                        "peak_id": "24",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "179",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "179",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "179",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "179",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "179",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "179",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "179",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "179",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "16.2680",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "122",
                "p_value": "2.19e-07",
                "e_value": "2.19e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "433",
                        "ms1_scans": "577",
                        "ids": "143",
                        "scans": "578",
                        "precursor_mono_mass": "9544.1727",
                        "precursor_charge": "13",
                        "precursor_mz": "735.1744",
                        "feature_inte": "3.0136e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "143",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6233",
                                "monoisotopic_mz": "797.4445",
                                "intensity": "18560.63",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0024",
                                        "ppm": "0.51"
                                    }