prsm_data =
{
    "prsm": {
        "prsm_id": "8",
        "p_value": "2.75e-08",
        "e_value": "2.75e-08",
        "fdr": "0",
        "matched_fragment_number": "12",
        "matched_peak_number": "14",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_1_ms2.msalign",
                "ms1_ids": "18",
                "ms1_scans": "28",
                "ids": "9",
                "scans": "29",
                "precursor_mono_mass": "9545.1772",
                "precursor_charge": "13",
                "precursor_mz": "735.2517",
                "feature_inte": "3.0136e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "9",
                        "peak_id": "0",
                        "monoisotopic_mass": "4876.6897",
                        "monoisotopic_mz": "813.7889",
                        "intensity": "13675.67",
                        "charge": "6"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "1",
                        "monoisotopic_mass": "4777.6184",
                        "monoisotopic_mz": "797.2770",
                        "intensity": "22689.16",
                        "charge": "6"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "2",
                        "monoisotopic_mass": "1429.8288",
                        "monoisotopic_mz": "715.9217",
                        "intensity": "20078.75",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0005",
                                "ppm": "-0.35"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "3",
                        "monoisotopic_mass": "4778.6197",
                        "monoisotopic_mz": "683.6672",
                        "intensity": "9142.62",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0012",
                                "ppm": "-0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "4",
                        "monoisotopic_mass": "4876.6876",
                        "monoisotopic_mz": "697.6769",
                        "intensity": "8451.33",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "5",
                        "monoisotopic_mass": "3348.7896",
                        "monoisotopic_mz": "838.2047",
                        "intensity": "10478.29",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "6",
                        "monoisotopic_mass": "5100.8101",
                        "monoisotopic_mz": "729.6944",
                        "intensity": "9651.85",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "7",
                        "monoisotopic_mass": "3249.7248",
                        "monoisotopic_mz": "813.4385",
                        "intensity": "6576.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "8",
                        "monoisotopic_mass": "1856.0540",
                        "monoisotopic_mz": "929.0343",
                        "intensity": "4314.95",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1856.0520",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "ion_sort_name": "Y00019",
                                "ion_left_position": "71",
                                "mass_error": "0.0020",
                                "ppm": "1.06"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "9",
                        "monoisotopic_mass": "1785.0121",
                        "monoisotopic_mz": "893.5133",
                        "intensity": "3259.92",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1785.0149",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "ion_sort_name": "Y00018",
                                "ion_left_position": "72",
                                "mass_error": "-0.0028",
                                "ppm": "-1.57"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "10",
                        "monoisotopic_mass": "1642.9409",
                        "monoisotopic_mz": "822.4777",
                        "intensity": "3507.30",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1642.9407",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "ion_sort_name": "Y00016",
                                "ion_left_position": "74",
                                "mass_error": "0.0002",
                                "ppm": "0.13"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "11",
                        "monoisotopic_mass": "2495.3876",
                        "monoisotopic_mz": "832.8032",
                        "intensity": "5322.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "12",
                        "monoisotopic_mass": "1429.8287",
                        "monoisotopic_mz": "477.6169",
                        "intensity": "10082.71",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0006",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "13",
                        "monoisotopic_mass": "1261.7391",
                        "monoisotopic_mz": "631.8768",
                        "intensity": "3834.35",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1261.7395",
                                "ion_position": "78",
                                "ion_display_position": "12",
                                "ion_sort_name": "Y00012",
                                "ion_left_position": "78",
                                "mass_error": "-0.0003",
                                "ppm": "-0.28"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "14",
                        "monoisotopic_mass": "1497.3027",
                        "monoisotopic_mz": "749.6586",
                        "intensity": "3711.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "15",
                        "monoisotopic_mass": "5117.8242",
                        "monoisotopic_mz": "853.9780",
                        "intensity": "3471.28",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5118.8320",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "42",
                                "mass_error": "-0.0054",
                                "ppm": "-1.05"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "16",
                        "monoisotopic_mass": "3670.9922",
                        "monoisotopic_mz": "735.2057",
                        "intensity": "2903.71",
                        "charge": "5"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "17",
                        "monoisotopic_mass": "2209.3133",
                        "monoisotopic_mz": "737.4451",
                        "intensity": "2086.47",
                        "charge": "3"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "18",
                        "monoisotopic_mass": "4760.5955",
                        "monoisotopic_mz": "681.0923",
                        "intensity": "1210.42",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "19",
                        "monoisotopic_mass": "4721.5878",
                        "monoisotopic_mz": "787.9386",
                        "intensity": "4115.77",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4721.5994",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "ion_sort_name": "Y00044",
                                "ion_left_position": "46",
                                "mass_error": "-0.0116",
                                "ppm": "-2.46"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "20",
                        "monoisotopic_mass": "4780.6243",
                        "monoisotopic_mz": "957.1321",
                        "intensity": "1820.27",
                        "charge": "5"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "21",
                        "monoisotopic_mass": "2430.8390",
                        "monoisotopic_mz": "811.2869",
                        "intensity": "2041.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "22",
                        "monoisotopic_mass": "3349.7900",
                        "monoisotopic_mz": "670.9653",
                        "intensity": "2604.24",
                        "charge": "5"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "23",
                        "monoisotopic_mass": "4991.7748",
                        "monoisotopic_mz": "714.1180",
                        "intensity": "4943.36",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "24",
                        "monoisotopic_mass": "507.8009",
                        "monoisotopic_mz": "508.8082",
                        "intensity": "1161.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "25",
                        "monoisotopic_mass": "1714.9811",
                        "monoisotopic_mz": "858.4978",
                        "intensity": "2810.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "26",
                        "monoisotopic_mass": "1446.7778",
                        "monoisotopic_mz": "724.3962",
                        "intensity": "1730.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "27",
                        "monoisotopic_mass": "1429.8293",
                        "monoisotopic_mz": "1430.8365",
                        "intensity": "1841.91",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0001",
                                "ppm": "-0.05"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "28",
                        "monoisotopic_mass": "859.3918",
                        "monoisotopic_mz": "860.3991",
                        "intensity": "1571.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "29",
                        "monoisotopic_mass": "6032.2812",
                        "monoisotopic_mz": "862.7617",
                        "intensity": "724.17",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "30",
                        "monoisotopic_mass": "2287.2670",
                        "monoisotopic_mz": "763.4296",
                        "intensity": "2421.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "31",
                        "monoisotopic_mass": "1461.7854",
                        "monoisotopic_mz": "731.9000",
                        "intensity": "1570.75",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "32",
                        "monoisotopic_mass": "3135.6750",
                        "monoisotopic_mz": "784.9260",
                        "intensity": "2700.09",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "33",
                        "monoisotopic_mass": "2809.4822",
                        "monoisotopic_mz": "703.3778",
                        "intensity": "3158.46",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "34",
                        "monoisotopic_mass": "1607.3663",
                        "monoisotopic_mz": "804.6904",
                        "intensity": "2479.24",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "35",
                        "monoisotopic_mass": "3670.9705",
                        "monoisotopic_mz": "918.7499",
                        "intensity": "983.41",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "36",
                        "monoisotopic_mass": "666.3881",
                        "monoisotopic_mz": "667.3953",
                        "intensity": "939.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "37",
                        "monoisotopic_mass": "4649.5138",
                        "monoisotopic_mz": "775.9262",
                        "intensity": "1032.63",
                        "charge": "6"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "38",
                        "monoisotopic_mass": "4701.5800",
                        "monoisotopic_mz": "672.6616",
                        "intensity": "2188.68",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "39",
                        "monoisotopic_mass": "790.4324",
                        "monoisotopic_mz": "791.4397",
                        "intensity": "1264.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "40",
                        "monoisotopic_mass": "743.4540",
                        "monoisotopic_mz": "744.4612",
                        "intensity": "1602.23",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "743.4542",
                                "ion_position": "83",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "83",
                                "mass_error": "-0.0002",
                                "ppm": "-0.28"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "41",
                        "monoisotopic_mass": "4257.2344",
                        "monoisotopic_mz": "1065.3159",
                        "intensity": "1064.82",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "42",
                        "monoisotopic_mass": "1082.5732",
                        "monoisotopic_mz": "1083.5804",
                        "intensity": "1503.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "43",
                        "monoisotopic_mass": "1015.6010",
                        "monoisotopic_mz": "1016.6083",
                        "intensity": "2269.61",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1015.6026",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "80",
                                "mass_error": "-0.0016",
                                "ppm": "-1.60"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "44",
                        "monoisotopic_mass": "2908.5544",
                        "monoisotopic_mz": "728.1459",
                        "intensity": "1988.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "45",
                        "monoisotopic_mass": "4720.6022",
                        "monoisotopic_mz": "675.3790",
                        "intensity": "1433.09",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "46",
                        "monoisotopic_mass": "7820.7486",
                        "monoisotopic_mz": "783.0821",
                        "intensity": "1138.48",
                        "charge": "10"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "47",
                        "monoisotopic_mass": "5995.9892",
                        "monoisotopic_mz": "857.5772",
                        "intensity": "969.76",
                        "charge": "7"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "48",
                        "monoisotopic_mass": "6997.7745",
                        "monoisotopic_mz": "700.7847",
                        "intensity": "785.21",
                        "charge": "10"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "49",
                        "monoisotopic_mass": "3216.7355",
                        "monoisotopic_mz": "805.1911",
                        "intensity": "833.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "50",
                        "monoisotopic_mass": "3380.2186",
                        "monoisotopic_mz": "846.0619",
                        "intensity": "921.80",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "51",
                        "monoisotopic_mass": "3937.2236",
                        "monoisotopic_mz": "788.4520",
                        "intensity": "649.32",
                        "charge": "5"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "52",
                        "monoisotopic_mass": "3559.9517",
                        "monoisotopic_mz": "890.9952",
                        "intensity": "771.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "53",
                        "monoisotopic_mass": "1114.6706",
                        "monoisotopic_mz": "558.3426",
                        "intensity": "1407.49",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1114.6710",
                                "ion_position": "79",
                                "ion_display_position": "11",
                                "ion_sort_name": "Y00011",
                                "ion_left_position": "79",
                                "mass_error": "-0.0004",
                                "ppm": "-0.37"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "54",
                        "monoisotopic_mass": "8615.4122",
                        "monoisotopic_mz": "784.2266",
                        "intensity": "3464.73",
                        "charge": "11"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "55",
                        "monoisotopic_mass": "1043.5135",
                        "monoisotopic_mz": "1044.5208",
                        "intensity": "1522.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "56",
                        "monoisotopic_mass": "906.6100",
                        "monoisotopic_mz": "907.6172",
                        "intensity": "668.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "57",
                        "monoisotopic_mass": "1064.3107",
                        "monoisotopic_mz": "1065.3180",
                        "intensity": "1103.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "58",
                        "monoisotopic_mass": "1379.9452",
                        "monoisotopic_mz": "690.9799",
                        "intensity": "1671.13",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "59",
                        "monoisotopic_mass": "4579.3768",
                        "monoisotopic_mz": "764.2367",
                        "intensity": "776.30",
                        "charge": "6"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "60",
                        "monoisotopic_mass": "1283.7236",
                        "monoisotopic_mz": "642.8691",
                        "intensity": "1140.46",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "61",
                        "monoisotopic_mass": "3190.7468",
                        "monoisotopic_mz": "798.6940",
                        "intensity": "3187.30",
                        "charge": "4"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "62",
                        "monoisotopic_mass": "1568.3633",
                        "monoisotopic_mz": "785.1889",
                        "intensity": "1493.23",
                        "charge": "2"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "63",
                        "monoisotopic_mass": "5992.3205",
                        "monoisotopic_mz": "750.0473",
                        "intensity": "1912.05",
                        "charge": "8"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "64",
                        "monoisotopic_mass": "5847.3008",
                        "monoisotopic_mz": "731.9199",
                        "intensity": "2054.71",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "16.0935651271",
                                "theoretical_mass": "5847.3011",
                                "ion_position": "35",
                                "ion_display_position": "55",
                                "ion_sort_name": "Y00055",
                                "ion_left_position": "35",
                                "mass_error": "-0.0003",
                                "ppm": "-0.05"
                            }
                        }
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "65",
                        "monoisotopic_mass": "683.3729",
                        "monoisotopic_mz": "684.3802",
                        "intensity": "625.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "66",
                        "monoisotopic_mass": "726.2582",
                        "monoisotopic_mz": "727.2655",
                        "intensity": "947.10",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "67",
                        "monoisotopic_mass": "833.7010",
                        "monoisotopic_mz": "834.7083",
                        "intensity": "1067.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "9",
                        "peak_id": "68",
                        "monoisotopic_mass": "702.6107",
                        "monoisotopic_mz": "703.6179",
                        "intensity": "747.76",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "1",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9545.2822",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "35",
                                "ion_display_position": "55",
                                "spec_id": "9",
                                "peak_id": "64",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "spec_id": "9",
                                "peak_id": "15",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "9",
                                "peak_id": "3",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "spec_id": "9",
                                "peak_id": "19",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "spec_id": "9",
                                "peak_id": "8",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "spec_id": "9",
                                "peak_id": "9",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "spec_id": "9",
                                "peak_id": "10",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "9",
                                    "peak_id": "12",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "9",
                                    "peak_id": "2",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "9",
                                    "peak_id": "27",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "78",
                                "ion_display_position": "12",
                                "spec_id": "9",
                                "peak_id": "13",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "11",
                                "spec_id": "9",
                                "peak_id": "53",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "10",
                                "spec_id": "9",
                                "peak_id": "43",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "83",
                                "ion_display_position": "7",
                                "spec_id": "9",
                                "peak_id": "40",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "35",
                    "right_position": "42",
                    "anno": "16.0936",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
