prsm_data =
{
    "prsm": {
        "prsm_id": "144",
        "p_value": "3.51e-06",
        "e_value": "3.51e-06",
        "fdr": "0",
        "matched_fragment_number": "11",
        "matched_peak_number": "13",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_1_ms2.msalign",
                "ms1_ids": "500",
                "ms1_scans": "669",
                "ids": "168",
                "scans": "670",
                "precursor_mono_mass": "9545.1773",
                "precursor_charge": "12",
                "precursor_mz": "796.4387",
                "feature_inte": "3.0136e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "168",
                        "peak_id": "0",
                        "monoisotopic_mass": "4778.6226",
                        "monoisotopic_mz": "797.4444",
                        "intensity": "44605.48",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "0.0017",
                                "ppm": "0.36"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "1",
                        "monoisotopic_mass": "4876.6890",
                        "monoisotopic_mz": "813.7888",
                        "intensity": "24844.08",
                        "charge": "6"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "2",
                        "monoisotopic_mass": "4989.7734",
                        "monoisotopic_mz": "832.6362",
                        "intensity": "14522.37",
                        "charge": "6"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "3",
                        "monoisotopic_mass": "1429.8294",
                        "monoisotopic_mz": "715.9220",
                        "intensity": "12034.78",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "0.0001",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "4",
                        "monoisotopic_mass": "4254.2403",
                        "monoisotopic_mz": "1064.5674",
                        "intensity": "7192.79",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "5",
                        "monoisotopic_mass": "5102.8140",
                        "monoisotopic_mz": "851.4763",
                        "intensity": "4870.98",
                        "charge": "6"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "6",
                        "monoisotopic_mass": "1856.0528",
                        "monoisotopic_mz": "929.0337",
                        "intensity": "5066.09",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1856.0520",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "ion_sort_name": "Y00019",
                                "ion_left_position": "71",
                                "mass_error": "0.0007",
                                "ppm": "0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "7",
                        "monoisotopic_mass": "4700.5724",
                        "monoisotopic_mz": "784.4360",
                        "intensity": "4292.02",
                        "charge": "6"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "8",
                        "monoisotopic_mass": "2163.6454",
                        "monoisotopic_mz": "1082.8300",
                        "intensity": "3406.19",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "9",
                        "monoisotopic_mass": "5100.8170",
                        "monoisotopic_mz": "729.6954",
                        "intensity": "5163.38",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "10",
                        "monoisotopic_mass": "3348.7952",
                        "monoisotopic_mz": "838.2061",
                        "intensity": "7531.74",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "11",
                        "monoisotopic_mass": "4239.2480",
                        "monoisotopic_mz": "1060.8193",
                        "intensity": "5158.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "12",
                        "monoisotopic_mass": "4762.6188",
                        "monoisotopic_mz": "794.7771",
                        "intensity": "9073.64",
                        "charge": "6"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "13",
                        "monoisotopic_mass": "1785.0132",
                        "monoisotopic_mz": "893.5139",
                        "intensity": "3228.35",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1785.0149",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "ion_sort_name": "Y00018",
                                "ion_left_position": "72",
                                "mass_error": "-0.0017",
                                "ppm": "-0.95"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "14",
                        "monoisotopic_mass": "1969.1377",
                        "monoisotopic_mz": "985.5761",
                        "intensity": "2751.73",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1969.1361",
                                "ion_position": "70",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "70",
                                "mass_error": "0.0016",
                                "ppm": "0.83"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "15",
                        "monoisotopic_mass": "5118.8057",
                        "monoisotopic_mz": "854.1416",
                        "intensity": "8411.50",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5118.8320",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "42",
                                "mass_error": "-0.0263",
                                "ppm": "-5.13"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "16",
                        "monoisotopic_mass": "3064.6460",
                        "monoisotopic_mz": "767.1688",
                        "intensity": "3157.61",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "17",
                        "monoisotopic_mass": "6148.3319",
                        "monoisotopic_mz": "879.3404",
                        "intensity": "3487.15",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6148.3298",
                                "ion_position": "32",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "32",
                                "mass_error": "0.0021",
                                "ppm": "0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "18",
                        "monoisotopic_mass": "3428.9592",
                        "monoisotopic_mz": "858.2471",
                        "intensity": "4301.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "19",
                        "monoisotopic_mass": "1461.7859",
                        "monoisotopic_mz": "731.9002",
                        "intensity": "2694.58",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "20",
                        "monoisotopic_mass": "1642.9404",
                        "monoisotopic_mz": "822.4775",
                        "intensity": "2031.08",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1642.9407",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "ion_sort_name": "Y00016",
                                "ion_left_position": "74",
                                "mass_error": "-0.0003",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "21",
                        "monoisotopic_mass": "1429.8305",
                        "monoisotopic_mz": "1430.8378",
                        "intensity": "2163.67",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "0.0012",
                                "ppm": "0.81"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "22",
                        "monoisotopic_mass": "2210.3159",
                        "monoisotopic_mz": "737.7792",
                        "intensity": "4514.96",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2210.3151",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "ion_sort_name": "Y00022",
                                "ion_left_position": "68",
                                "mass_error": "0.0008",
                                "ppm": "0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "23",
                        "monoisotopic_mass": "3194.7265",
                        "monoisotopic_mz": "799.6889",
                        "intensity": "1749.06",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "24",
                        "monoisotopic_mass": "6314.4084",
                        "monoisotopic_mz": "903.0656",
                        "intensity": "1159.06",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "25",
                        "monoisotopic_mass": "1094.5914",
                        "monoisotopic_mz": "1095.5986",
                        "intensity": "2275.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "26",
                        "monoisotopic_mass": "7998.2803",
                        "monoisotopic_mz": "889.7051",
                        "intensity": "1637.50",
                        "charge": "9"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "27",
                        "monoisotopic_mass": "3021.6386",
                        "monoisotopic_mz": "756.4169",
                        "intensity": "4007.14",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "28",
                        "monoisotopic_mass": "3102.2635",
                        "monoisotopic_mz": "776.5732",
                        "intensity": "2855.80",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "29",
                        "monoisotopic_mass": "4311.2894",
                        "monoisotopic_mz": "1078.8296",
                        "intensity": "2565.01",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "30",
                        "monoisotopic_mass": "3213.7371",
                        "monoisotopic_mz": "1072.2530",
                        "intensity": "1998.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "31",
                        "monoisotopic_mass": "4876.6888",
                        "monoisotopic_mz": "697.6771",
                        "intensity": "2438.45",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "32",
                        "monoisotopic_mass": "3477.8897",
                        "monoisotopic_mz": "870.4797",
                        "intensity": "840.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "33",
                        "monoisotopic_mass": "853.8075",
                        "monoisotopic_mz": "854.8148",
                        "intensity": "4358.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "34",
                        "monoisotopic_mass": "2429.3393",
                        "monoisotopic_mz": "810.7870",
                        "intensity": "3626.64",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "35",
                        "monoisotopic_mass": "772.1659",
                        "monoisotopic_mz": "773.1732",
                        "intensity": "1036.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "36",
                        "monoisotopic_mass": "4778.6287",
                        "monoisotopic_mz": "683.6685",
                        "intensity": "1095.97",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "0.0078",
                                "ppm": "1.62"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "37",
                        "monoisotopic_mass": "3248.7414",
                        "monoisotopic_mz": "813.1926",
                        "intensity": "974.19",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "38",
                        "monoisotopic_mass": "2809.4880",
                        "monoisotopic_mz": "703.3793",
                        "intensity": "2353.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "39",
                        "monoisotopic_mass": "1736.9420",
                        "monoisotopic_mz": "869.4783",
                        "intensity": "1336.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "40",
                        "monoisotopic_mass": "4350.3901",
                        "monoisotopic_mz": "871.0853",
                        "intensity": "946.48",
                        "charge": "5"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "41",
                        "monoisotopic_mass": "4721.6062",
                        "monoisotopic_mz": "787.9416",
                        "intensity": "4548.43",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4721.5994",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "ion_sort_name": "Y00044",
                                "ion_left_position": "46",
                                "mass_error": "0.0067",
                                "ppm": "1.42"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "42",
                        "monoisotopic_mass": "6432.4205",
                        "monoisotopic_mz": "805.0598",
                        "intensity": "1091.57",
                        "charge": "8"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "43",
                        "monoisotopic_mass": "6514.5730",
                        "monoisotopic_mz": "931.6606",
                        "intensity": "1295.90",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "44",
                        "monoisotopic_mass": "6534.5496",
                        "monoisotopic_mz": "817.8260",
                        "intensity": "3853.84",
                        "charge": "8"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "45",
                        "monoisotopic_mass": "817.4438",
                        "monoisotopic_mz": "818.4511",
                        "intensity": "1120.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "46",
                        "monoisotopic_mass": "803.6858",
                        "monoisotopic_mz": "804.6931",
                        "intensity": "1129.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "47",
                        "monoisotopic_mass": "9500.8610",
                        "monoisotopic_mz": "792.7457",
                        "intensity": "1426.30",
                        "charge": "12"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "48",
                        "monoisotopic_mass": "7457.1070",
                        "monoisotopic_mz": "829.5747",
                        "intensity": "1083.20",
                        "charge": "9"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "49",
                        "monoisotopic_mass": "2448.0009",
                        "monoisotopic_mz": "817.0076",
                        "intensity": "942.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "50",
                        "monoisotopic_mass": "2793.1885",
                        "monoisotopic_mz": "932.0701",
                        "intensity": "1252.47",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "51",
                        "monoisotopic_mass": "3942.5632",
                        "monoisotopic_mz": "789.5199",
                        "intensity": "846.00",
                        "charge": "5"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "52",
                        "monoisotopic_mass": "941.6403",
                        "monoisotopic_mz": "942.6475",
                        "intensity": "1571.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "53",
                        "monoisotopic_mass": "2669.7064",
                        "monoisotopic_mz": "890.9094",
                        "intensity": "1666.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "54",
                        "monoisotopic_mass": "5980.4417",
                        "monoisotopic_mz": "855.3561",
                        "intensity": "1029.43",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "16.2736351271",
                                "theoretical_mass": "5981.4723",
                                "ion_position": "56",
                                "ion_display_position": "56",
                                "ion_sort_name": "B00056",
                                "ion_left_position": "56",
                                "mass_error": "-0.0283",
                                "ppm": "-4.73"
                            }
                        }
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "55",
                        "monoisotopic_mass": "7954.8449",
                        "monoisotopic_mz": "796.4918",
                        "intensity": "2897.05",
                        "charge": "10"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "56",
                        "monoisotopic_mass": "1496.8009",
                        "monoisotopic_mz": "749.4077",
                        "intensity": "655.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "57",
                        "monoisotopic_mass": "6213.9402",
                        "monoisotopic_mz": "888.7130",
                        "intensity": "2113.63",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "58",
                        "monoisotopic_mass": "2865.5476",
                        "monoisotopic_mz": "717.3942",
                        "intensity": "967.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "59",
                        "monoisotopic_mass": "3231.1381",
                        "monoisotopic_mz": "808.7918",
                        "intensity": "1769.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "60",
                        "monoisotopic_mass": "8907.3785",
                        "monoisotopic_mz": "891.7451",
                        "intensity": "766.96",
                        "charge": "10"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "61",
                        "monoisotopic_mass": "3284.7837",
                        "monoisotopic_mz": "822.2032",
                        "intensity": "2161.07",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "62",
                        "monoisotopic_mass": "2841.4169",
                        "monoisotopic_mz": "948.1462",
                        "intensity": "935.84",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "63",
                        "monoisotopic_mass": "7786.4677",
                        "monoisotopic_mz": "866.1704",
                        "intensity": "1027.81",
                        "charge": "9"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "64",
                        "monoisotopic_mass": "9529.8599",
                        "monoisotopic_mz": "953.9933",
                        "intensity": "1205.88",
                        "charge": "10"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "65",
                        "monoisotopic_mass": "3396.8408",
                        "monoisotopic_mz": "850.2175",
                        "intensity": "1206.55",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "66",
                        "monoisotopic_mass": "1430.8332",
                        "monoisotopic_mz": "477.9517",
                        "intensity": "587.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "67",
                        "monoisotopic_mass": "1047.5577",
                        "monoisotopic_mz": "1048.5649",
                        "intensity": "695.43",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "68",
                        "monoisotopic_mass": "4513.2229",
                        "monoisotopic_mz": "903.6519",
                        "intensity": "1186.47",
                        "charge": "5"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "69",
                        "monoisotopic_mass": "3568.7937",
                        "monoisotopic_mz": "893.2057",
                        "intensity": "1681.41",
                        "charge": "4"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "70",
                        "monoisotopic_mass": "4081.6957",
                        "monoisotopic_mz": "817.3464",
                        "intensity": "1156.69",
                        "charge": "5"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "71",
                        "monoisotopic_mass": "1446.2474",
                        "monoisotopic_mz": "724.1310",
                        "intensity": "569.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "72",
                        "monoisotopic_mass": "7981.7994",
                        "monoisotopic_mz": "799.1872",
                        "intensity": "917.19",
                        "charge": "10"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "73",
                        "monoisotopic_mass": "6103.1156",
                        "monoisotopic_mz": "872.8809",
                        "intensity": "1902.26",
                        "charge": "7"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "74",
                        "monoisotopic_mass": "750.4061",
                        "monoisotopic_mz": "751.4134",
                        "intensity": "863.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "75",
                        "monoisotopic_mass": "1949.7188",
                        "monoisotopic_mz": "975.8667",
                        "intensity": "1288.59",
                        "charge": "2"
                    },
                    {
                        "spec_id": "168",
                        "peak_id": "76",
                        "monoisotopic_mass": "4288.0369",
                        "monoisotopic_mz": "858.6147",
                        "intensity": "1444.90",
                        "charge": "5"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "1",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9545.4623",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "32",
                                "ion_display_position": "58",
                                "spec_id": "168",
                                "peak_id": "17",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "42",
                                "ion_display_position": "48",
                                "spec_id": "168",
                                "peak_id": "15",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "168",
                                    "peak_id": "0",
                                    "peak_charge": "6"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "168",
                                    "peak_id": "36",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "spec_id": "168",
                                "peak_id": "41",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "56",
                                "ion_display_position": "56",
                                "spec_id": "168",
                                "peak_id": "54",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "68",
                                "ion_display_position": "22",
                                "spec_id": "168",
                                "peak_id": "22",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "70",
                                "ion_display_position": "20",
                                "spec_id": "168",
                                "peak_id": "14",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "19",
                                "spec_id": "168",
                                "peak_id": "6",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "72",
                                "ion_display_position": "18",
                                "spec_id": "168",
                                "peak_id": "13",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "16",
                                "spec_id": "168",
                                "peak_id": "20",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "168",
                                    "peak_id": "3",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "168",
                                    "peak_id": "21",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "0",
                    "right_position": "32",
                    "anno": "16.2736",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
