prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "1",
        "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
        "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
        "proteoform_id": "4",
        "prsm_number": "16",
        "prsm": [
            {
                "prsm_id": "118",
                "p_value": "5.92e-07",
                "e_value": "5.92e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "428",
                        "ms1_scans": "567",
                        "ids": "139",
                        "scans": "569",
                        "precursor_mono_mass": "9235.9862",
                        "precursor_charge": "12",
                        "precursor_mz": "770.6728",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "139",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5804",
                                "monoisotopic_mz": "784.2707",
                                "intensity": "42982.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6459",
                                "monoisotopic_mz": "800.7816",
                                "intensity": "17779.37",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7232",
                                "monoisotopic_mz": "819.4611",
                                "intensity": "7510.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5203",
                                "monoisotopic_mz": "762.2607",
                                "intensity": "8985.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "4",
                                "monoisotopic_mass": "4682.5531",
                                "monoisotopic_mz": "781.4328",
                                "intensity": "7809.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8104",
                                "monoisotopic_mz": "737.4125",
                                "intensity": "6572.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "6",
                                "monoisotopic_mass": "4495.4892",
                                "monoisotopic_mz": "750.2555",
                                "intensity": "5539.24",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0004",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "7",
                                "monoisotopic_mass": "4781.6318",
                                "monoisotopic_mz": "797.9459",
                                "intensity": "4445.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "8",
                                "monoisotopic_mass": "4154.1470",
                                "monoisotopic_mz": "1039.5440",
                                "intensity": "6107.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-26.0140315213",
                                        "theoretical_mass": "4154.1545",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0075",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "9",
                                "monoisotopic_mass": "2809.5097",
                                "monoisotopic_mz": "937.5105",
                                "intensity": "2446.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-26.0140315213",
                                        "theoretical_mass": "2809.5136",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0040",
                                        "ppm": "-1.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "10",
                                "monoisotopic_mass": "2320.7775",
                                "monoisotopic_mz": "774.5998",
                                "intensity": "5464.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "11",
                                "monoisotopic_mass": "2333.7925",
                                "monoisotopic_mz": "778.9381",
                                "intensity": "1960.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "12",
                                "monoisotopic_mass": "4797.6373",
                                "monoisotopic_mz": "686.3840",
                                "intensity": "3239.56",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "13",
                                "monoisotopic_mass": "9216.9506",
                                "monoisotopic_mz": "769.0865",
                                "intensity": "3757.90",
                                "charge": "12"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "14",
                                "monoisotopic_mass": "2809.5147",
                                "monoisotopic_mz": "703.3860",
                                "intensity": "1255.15",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-26.0140315213",
                                        "theoretical_mass": "2809.5136",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0011",
                                        "ppm": "0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "15",
                                "monoisotopic_mass": "3226.7555",
                                "monoisotopic_mz": "807.6962",
                                "intensity": "2676.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "16",
                                "monoisotopic_mass": "1034.2867",
                                "monoisotopic_mz": "1035.2939",
                                "intensity": "1144.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "17",
                                "monoisotopic_mass": "6620.1586",
                                "monoisotopic_mz": "828.5271",
                                "intensity": "2508.35",
                                "charge": "8"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "18",
                                "monoisotopic_mass": "1340.7534",
                                "monoisotopic_mz": "671.3840",
                                "intensity": "1665.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "19",
                                "monoisotopic_mass": "5544.7631",
                                "monoisotopic_mz": "793.1163",
                                "intensity": "766.67",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "20",
                                "monoisotopic_mass": "767.1629",
                                "monoisotopic_mz": "768.1702",
                                "intensity": "1087.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "21",
                                "monoisotopic_mass": "1402.5918",
                                "monoisotopic_mz": "702.3032",
                                "intensity": "1359.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "22",
                                "monoisotopic_mass": "4131.1302",
                                "monoisotopic_mz": "827.2333",
                                "intensity": "1640.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "23",
                                "monoisotopic_mass": "857.4224",
                                "monoisotopic_mz": "858.4297",
                                "intensity": "949.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "24",
                                "monoisotopic_mass": "2792.5079",
                                "monoisotopic_mz": "931.8432",
                                "intensity": "1540.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "25",
                                "monoisotopic_mass": "3111.7235",
                                "monoisotopic_mz": "778.9382",
                                "intensity": "1631.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "26",
                                "monoisotopic_mass": "2481.8834",
                                "monoisotopic_mz": "828.3017",
                                "intensity": "1788.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "27",
                                "monoisotopic_mass": "974.4200",
                                "monoisotopic_mz": "975.4272",
                                "intensity": "1638.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "28",
                                "monoisotopic_mass": "5338.4144",
                                "monoisotopic_mz": "763.6379",
                                "intensity": "890.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "29",
                                "monoisotopic_mass": "5430.6957",
                                "monoisotopic_mz": "776.8210",
                                "intensity": "903.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "30",
                                "monoisotopic_mass": "6241.2998",
                                "monoisotopic_mz": "892.6215",
                                "intensity": "2111.83",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-26.0140315213",
                                            "theoretical_mass": "6241.3297",
                                            "ion_position": "61",
                                            "ion_display_position": "61",
                                            "ion_sort_name": "B00061",
                                            "ion_left_position": "61",
                                            "mass_error": "-0.0299",
                                            "ppm": "-4.80"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6242.3564",
                                            "ion_position": "30",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "Y00060",
                                            "ion_left_position": "30",
                                            "mass_error": "-0.0543",
                                            "ppm": "-8.69"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "31",
                                "monoisotopic_mass": "2959.9294",
                                "monoisotopic_mz": "740.9896",
                                "intensity": "1171.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "32",
                                "monoisotopic_mass": "5391.3481",
                                "monoisotopic_mz": "771.1999",
                                "intensity": "2746.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "33",
                                "monoisotopic_mass": "2552.6559",
                                "monoisotopic_mz": "851.8926",
                                "intensity": "1766.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "34",
                                "monoisotopic_mass": "1488.8070",
                                "monoisotopic_mz": "745.4108",
                                "intensity": "593.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "35",
                                "monoisotopic_mass": "999.5445",
                                "monoisotopic_mz": "1000.5518",
                                "intensity": "700.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "36",
                                "monoisotopic_mass": "4273.9781",
                                "monoisotopic_mz": "855.8029",
                                "intensity": "855.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "37",
                                "monoisotopic_mass": "802.4407",
                                "monoisotopic_mz": "803.4480",
                                "intensity": "2170.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "38",
                                "monoisotopic_mass": "3842.3232",
                                "monoisotopic_mz": "769.4719",
                                "intensity": "1334.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "39",
                                "monoisotopic_mass": "2068.0776",
                                "monoisotopic_mz": "1035.0461",
                                "intensity": "1721.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2068.0987",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0211",
                                        "ppm": "-10.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "40",
                                "monoisotopic_mass": "931.5031",
                                "monoisotopic_mz": "932.5103",
                                "intensity": "476.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "41",
                                "monoisotopic_mass": "7076.5053",
                                "monoisotopic_mz": "885.5704",
                                "intensity": "811.68",
                                "charge": "8"
                            },
                            {
                                "spec_id": "139",
                                "peak_id": "42",
                                "monoisotopic_mass": "874.6335",
                                "monoisotopic_mz": "875.6408",
                                "intensity": "674.61",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.9912",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "139",
                                        "peak_id": "39",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "139",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "139",
                                            "peak_id": "14",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "60",
                                        "spec_id": "139",
                                        "peak_id": "30",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "139",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "139",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "139",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "139",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "spec_id": "139",
                                        "peak_id": "30",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "139",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "20",
                            "right_position": "28",
                            "anno": "-26.0140",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "155",
                "p_value": "1.74e-06",
                "e_value": "1.74e-06",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "532",
                        "ms1_scans": "714",
                        "ids": "181",
                        "scans": "715",
                        "precursor_mono_mass": "9235.9855",
                        "precursor_charge": "12",
                        "precursor_mz": "770.6727",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "181",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5796",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "40454.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0009",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6488",
                                "monoisotopic_mz": "800.7821",
                                "intensity": "20607.21",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0017",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7256",
                                "monoisotopic_mz": "819.6282",
                                "intensity": "12411.12",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5287",
                                "monoisotopic_mz": "762.2621",
                                "intensity": "8299.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "4",
                                "monoisotopic_mass": "4981.7593",
                                "monoisotopic_mz": "831.3005",
                                "intensity": "5243.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5580",
                                "monoisotopic_mz": "774.7669",
                                "intensity": "10207.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0008",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8115",
                                "monoisotopic_mz": "737.4130",
                                "intensity": "5457.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0015",
                                        "ppm": "1.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "7",
                                "monoisotopic_mass": "4682.5545",
                                "monoisotopic_mz": "781.4330",
                                "intensity": "10669.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "8",
                                "monoisotopic_mass": "4494.4869",
                                "monoisotopic_mz": "750.0884",
                                "intensity": "4996.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "9",
                                "monoisotopic_mass": "4780.6803",
                                "monoisotopic_mz": "797.7873",
                                "intensity": "3195.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7668",
                                "monoisotopic_mz": "807.6990",
                                "intensity": "4338.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "11",
                                "monoisotopic_mass": "2792.5163",
                                "monoisotopic_mz": "931.8461",
                                "intensity": "3518.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "12",
                                "monoisotopic_mass": "4154.1544",
                                "monoisotopic_mz": "1039.5459",
                                "intensity": "3829.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "4154.1538",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0006",
                                        "ppm": "0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "13",
                                "monoisotopic_mass": "2809.5119",
                                "monoisotopic_mz": "937.5112",
                                "intensity": "3842.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "2809.5129",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "14",
                                "monoisotopic_mass": "3061.6521",
                                "monoisotopic_mz": "1021.5580",
                                "intensity": "2717.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "15",
                                "monoisotopic_mass": "6059.2635",
                                "monoisotopic_mz": "866.6163",
                                "intensity": "2788.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "16",
                                "monoisotopic_mass": "1039.0394",
                                "monoisotopic_mz": "1040.0466",
                                "intensity": "1936.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "17",
                                "monoisotopic_mass": "3134.4762",
                                "monoisotopic_mz": "784.6263",
                                "intensity": "1765.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "18",
                                "monoisotopic_mass": "2679.4216",
                                "monoisotopic_mz": "670.8627",
                                "intensity": "1161.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "19",
                                "monoisotopic_mass": "8249.3302",
                                "monoisotopic_mz": "917.5995",
                                "intensity": "1130.74",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "8250.4348",
                                        "ion_position": "80",
                                        "ion_display_position": "80",
                                        "ion_sort_name": "B00080",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.1023",
                                        "ppm": "-12.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "20",
                                "monoisotopic_mass": "3528.8858",
                                "monoisotopic_mz": "883.2287",
                                "intensity": "928.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "21",
                                "monoisotopic_mass": "2922.5913",
                                "monoisotopic_mz": "731.6551",
                                "intensity": "2247.98",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "2922.5970",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0057",
                                        "ppm": "-1.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "22",
                                "monoisotopic_mass": "865.4666",
                                "monoisotopic_mz": "866.4739",
                                "intensity": "2723.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "23",
                                "monoisotopic_mass": "3062.6577",
                                "monoisotopic_mz": "766.6717",
                                "intensity": "2590.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "24",
                                "monoisotopic_mass": "2809.5141",
                                "monoisotopic_mz": "703.3858",
                                "intensity": "1226.40",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "2809.5129",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0012",
                                        "ppm": "0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "25",
                                "monoisotopic_mass": "1455.7831",
                                "monoisotopic_mz": "728.8988",
                                "intensity": "1125.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "26",
                                "monoisotopic_mass": "880.4711",
                                "monoisotopic_mz": "881.4783",
                                "intensity": "1013.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "27",
                                "monoisotopic_mass": "9098.9333",
                                "monoisotopic_mz": "828.1830",
                                "intensity": "1046.57",
                                "charge": "11"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "28",
                                "monoisotopic_mass": "4464.3746",
                                "monoisotopic_mz": "893.8822",
                                "intensity": "1280.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "29",
                                "monoisotopic_mass": "9218.5351",
                                "monoisotopic_mz": "769.2185",
                                "intensity": "1032.12",
                                "charge": "12"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "30",
                                "monoisotopic_mass": "974.4181",
                                "monoisotopic_mz": "975.4254",
                                "intensity": "1296.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "31",
                                "monoisotopic_mass": "4314.2881",
                                "monoisotopic_mz": "863.8649",
                                "intensity": "1183.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "32",
                                "monoisotopic_mass": "4965.0487",
                                "monoisotopic_mz": "828.5154",
                                "intensity": "1119.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "33",
                                "monoisotopic_mass": "896.1273",
                                "monoisotopic_mz": "897.1346",
                                "intensity": "730.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "34",
                                "monoisotopic_mass": "3769.8643",
                                "monoisotopic_mz": "754.9801",
                                "intensity": "1615.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "35",
                                "monoisotopic_mass": "4894.6938",
                                "monoisotopic_mz": "816.7896",
                                "intensity": "2116.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "36",
                                "monoisotopic_mass": "8275.7495",
                                "monoisotopic_mz": "828.5822",
                                "intensity": "1104.17",
                                "charge": "10"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "37",
                                "monoisotopic_mass": "1489.8234",
                                "monoisotopic_mz": "745.9190",
                                "intensity": "755.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "181",
                                "peak_id": "38",
                                "monoisotopic_mass": "2298.4951",
                                "monoisotopic_mz": "767.1723",
                                "intensity": "1143.60",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.9905",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "181",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "181",
                                            "peak_id": "24",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "181",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "181",
                                        "peak_id": "12",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "181",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "181",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "181",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "181",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "181",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "80",
                                        "ion_display_position": "80",
                                        "spec_id": "181",
                                        "peak_id": "19",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "28",
                            "anno": "15.9958",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "48",
                "p_value": "2.92e-05",
                "e_value": "2.92e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "189",
                        "ms1_scans": "247",
                        "ids": "57",
                        "scans": "248",
                        "precursor_mono_mass": "9235.9855",
                        "precursor_charge": "12",
                        "precursor_mz": "770.6727",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "57",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "45370.09",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6507",
                                "monoisotopic_mz": "800.7824",
                                "intensity": "19696.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0036",
                                        "ppm": "0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7303",
                                "monoisotopic_mz": "819.6290",
                                "intensity": "10273.89",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "3",
                                "monoisotopic_mass": "4981.7663",
                                "monoisotopic_mz": "831.3017",
                                "intensity": "7962.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5302",
                                "monoisotopic_mz": "762.2623",
                                "intensity": "8560.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5453",
                                "monoisotopic_mz": "774.7648",
                                "intensity": "5709.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0120",
                                        "ppm": "-2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "6",
                                "monoisotopic_mass": "4154.1528",
                                "monoisotopic_mz": "1039.5455",
                                "intensity": "6509.60",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "4154.1538",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "7",
                                "monoisotopic_mass": "1560.8536",
                                "monoisotopic_mz": "781.4341",
                                "intensity": "5104.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "8",
                                "monoisotopic_mass": "4781.6164",
                                "monoisotopic_mz": "797.9433",
                                "intensity": "4880.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "9",
                                "monoisotopic_mass": "1472.8098",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "6051.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "10",
                                "monoisotopic_mass": "4666.5913",
                                "monoisotopic_mz": "778.7725",
                                "intensity": "4097.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "11",
                                "monoisotopic_mass": "2809.5082",
                                "monoisotopic_mz": "937.5100",
                                "intensity": "3394.36",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9957934787",
                                        "theoretical_mass": "2809.5129",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0047",
                                        "ppm": "-1.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "12",
                                "monoisotopic_mass": "2069.5789",
                                "monoisotopic_mz": "1035.7967",
                                "intensity": "4994.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "13",
                                "monoisotopic_mass": "4609.9917",
                                "monoisotopic_mz": "769.3392",
                                "intensity": "3521.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "14",
                                "monoisotopic_mass": "2793.5101",
                                "monoisotopic_mz": "932.1773",
                                "intensity": "2439.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "15",
                                "monoisotopic_mass": "6582.4132",
                                "monoisotopic_mz": "732.3865",
                                "intensity": "1083.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "16",
                                "monoisotopic_mass": "3263.7766",
                                "monoisotopic_mz": "816.9514",
                                "intensity": "3011.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "17",
                                "monoisotopic_mass": "3061.6460",
                                "monoisotopic_mz": "1021.5560",
                                "intensity": "1973.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "18",
                                "monoisotopic_mass": "5825.1382",
                                "monoisotopic_mz": "833.1699",
                                "intensity": "2837.87",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5826.1657",
                                        "ion_position": "34",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0252",
                                        "ppm": "-4.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "19",
                                "monoisotopic_mass": "744.3286",
                                "monoisotopic_mz": "745.3359",
                                "intensity": "1173.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "20",
                                "monoisotopic_mass": "2627.3937",
                                "monoisotopic_mz": "876.8052",
                                "intensity": "787.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "21",
                                "monoisotopic_mass": "6911.8804",
                                "monoisotopic_mz": "692.1953",
                                "intensity": "1002.15",
                                "charge": "10"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "22",
                                "monoisotopic_mass": "686.0944",
                                "monoisotopic_mz": "687.1017",
                                "intensity": "794.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "23",
                                "monoisotopic_mass": "5529.9053",
                                "monoisotopic_mz": "692.2454",
                                "intensity": "694.76",
                                "charge": "8"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "24",
                                "monoisotopic_mass": "3846.9168",
                                "monoisotopic_mz": "770.3906",
                                "intensity": "1977.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "25",
                                "monoisotopic_mass": "8051.3935",
                                "monoisotopic_mz": "895.6066",
                                "intensity": "1010.00",
                                "charge": "9"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "26",
                                "monoisotopic_mass": "3076.9698",
                                "monoisotopic_mz": "770.2497",
                                "intensity": "3779.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "27",
                                "monoisotopic_mass": "7809.4246",
                                "monoisotopic_mz": "868.7211",
                                "intensity": "1253.46",
                                "charge": "9"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "28",
                                "monoisotopic_mass": "3226.7562",
                                "monoisotopic_mz": "807.6963",
                                "intensity": "1178.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "29",
                                "monoisotopic_mass": "1313.9688",
                                "monoisotopic_mz": "657.9917",
                                "intensity": "560.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "30",
                                "monoisotopic_mass": "5639.8908",
                                "monoisotopic_mz": "940.9891",
                                "intensity": "2205.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "31",
                                "monoisotopic_mass": "4624.5397",
                                "monoisotopic_mz": "771.7639",
                                "intensity": "2543.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "32",
                                "monoisotopic_mass": "5955.2013",
                                "monoisotopic_mz": "851.7503",
                                "intensity": "2082.04",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5955.2083",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0070",
                                        "ppm": "-1.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "33",
                                "monoisotopic_mass": "9120.9130",
                                "monoisotopic_mz": "913.0986",
                                "intensity": "738.42",
                                "charge": "10"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "34",
                                "monoisotopic_mass": "968.5256",
                                "monoisotopic_mz": "969.5328",
                                "intensity": "1251.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "35",
                                "monoisotopic_mass": "1397.7446",
                                "monoisotopic_mz": "699.8796",
                                "intensity": "555.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "36",
                                "monoisotopic_mass": "1455.7827",
                                "monoisotopic_mz": "728.8986",
                                "intensity": "2103.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "37",
                                "monoisotopic_mass": "1340.7553",
                                "monoisotopic_mz": "671.3849",
                                "intensity": "1172.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "38",
                                "monoisotopic_mass": "4138.6227",
                                "monoisotopic_mz": "828.7318",
                                "intensity": "2226.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "39",
                                "monoisotopic_mass": "786.4391",
                                "monoisotopic_mz": "787.4463",
                                "intensity": "876.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "40",
                                "monoisotopic_mass": "908.5361",
                                "monoisotopic_mz": "909.5433",
                                "intensity": "566.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "41",
                                "monoisotopic_mass": "1372.7610",
                                "monoisotopic_mz": "687.3878",
                                "intensity": "593.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "42",
                                "monoisotopic_mass": "671.8822",
                                "monoisotopic_mz": "672.8895",
                                "intensity": "865.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "43",
                                "monoisotopic_mass": "1859.6918",
                                "monoisotopic_mz": "930.8532",
                                "intensity": "993.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "44",
                                "monoisotopic_mass": "997.5329",
                                "monoisotopic_mz": "998.5402",
                                "intensity": "769.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "45",
                                "monoisotopic_mass": "850.0439",
                                "monoisotopic_mz": "851.0512",
                                "intensity": "996.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "57",
                                "peak_id": "46",
                                "monoisotopic_mass": "892.4978",
                                "monoisotopic_mz": "893.5051",
                                "intensity": "1298.44",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.9905",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "57",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "spec_id": "57",
                                        "peak_id": "32",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "56",
                                        "spec_id": "57",
                                        "peak_id": "18",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "57",
                                        "peak_id": "6",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "57",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "57",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "57",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "57",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "57",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "28",
                            "anno": "15.9958",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "168",
                "p_value": "3.20e-05",
                "e_value": "3.20e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "800",
                        "ms1_scans": "995",
                        "ids": "195",
                        "scans": "997",
                        "precursor_mono_mass": "9234.9872",
                        "precursor_charge": "12",
                        "precursor_mz": "770.5895",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "195",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5793",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "40730.83",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6496",
                                "monoisotopic_mz": "800.7822",
                                "intensity": "19422.12",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0025",
                                        "ppm": "0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5225",
                                "monoisotopic_mz": "762.2610",
                                "intensity": "10552.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "3",
                                "monoisotopic_mass": "4982.7690",
                                "monoisotopic_mz": "831.4688",
                                "intensity": "7744.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0007",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "4",
                                "monoisotopic_mass": "4642.5617",
                                "monoisotopic_mz": "774.7676",
                                "intensity": "8813.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0045",
                                        "ppm": "0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5496",
                                "monoisotopic_mz": "781.2655",
                                "intensity": "9394.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "6",
                                "monoisotopic_mass": "4911.7336",
                                "monoisotopic_mz": "819.6295",
                                "intensity": "12184.38",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0024",
                                        "ppm": "0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "7",
                                "monoisotopic_mass": "4780.6243",
                                "monoisotopic_mz": "797.7780",
                                "intensity": "5888.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "8",
                                "monoisotopic_mass": "1472.8095",
                                "monoisotopic_mz": "737.4120",
                                "intensity": "4038.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "9",
                                "monoisotopic_mass": "4153.1441",
                                "monoisotopic_mz": "1039.2933",
                                "intensity": "3919.05",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.0075034787",
                                        "theoretical_mass": "4153.1655",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0214",
                                        "ppm": "-5.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "10",
                                "monoisotopic_mass": "4666.5921",
                                "monoisotopic_mz": "778.7726",
                                "intensity": "4748.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "11",
                                "monoisotopic_mass": "4137.1519",
                                "monoisotopic_mz": "1035.2952",
                                "intensity": "4260.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "12",
                                "monoisotopic_mass": "2809.5126",
                                "monoisotopic_mz": "937.5115",
                                "intensity": "2595.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "13",
                                "monoisotopic_mass": "2793.5099",
                                "monoisotopic_mz": "932.1772",
                                "intensity": "3407.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "14",
                                "monoisotopic_mass": "4363.4338",
                                "monoisotopic_mz": "728.2462",
                                "intensity": "1650.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "15",
                                "monoisotopic_mass": "8336.5994",
                                "monoisotopic_mz": "758.8800",
                                "intensity": "1968.02",
                                "charge": "11"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "16",
                                "monoisotopic_mass": "2679.4165",
                                "monoisotopic_mz": "670.8614",
                                "intensity": "941.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "17",
                                "monoisotopic_mass": "4508.4849",
                                "monoisotopic_mz": "752.4214",
                                "intensity": "1088.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "18",
                                "monoisotopic_mass": "4620.8721",
                                "monoisotopic_mz": "771.1526",
                                "intensity": "2605.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "19",
                                "monoisotopic_mass": "3228.7768",
                                "monoisotopic_mz": "808.2015",
                                "intensity": "1652.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "20",
                                "monoisotopic_mass": "643.2808",
                                "monoisotopic_mz": "644.2881",
                                "intensity": "1040.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "21",
                                "monoisotopic_mass": "5582.0356",
                                "monoisotopic_mz": "931.3465",
                                "intensity": "1021.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "22",
                                "monoisotopic_mass": "4085.1541",
                                "monoisotopic_mz": "818.0381",
                                "intensity": "814.53",
                                "charge": "5"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "23",
                                "monoisotopic_mass": "3078.6405",
                                "monoisotopic_mz": "770.6674",
                                "intensity": "1074.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "24",
                                "monoisotopic_mass": "815.9521",
                                "monoisotopic_mz": "816.9593",
                                "intensity": "1081.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "25",
                                "monoisotopic_mass": "1021.2187",
                                "monoisotopic_mz": "1022.2260",
                                "intensity": "611.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "26",
                                "monoisotopic_mass": "870.1346",
                                "monoisotopic_mz": "871.1419",
                                "intensity": "1871.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "27",
                                "monoisotopic_mass": "974.4199",
                                "monoisotopic_mz": "975.4272",
                                "intensity": "1809.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "28",
                                "monoisotopic_mass": "2696.4277",
                                "monoisotopic_mz": "675.1142",
                                "intensity": "2368.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "29",
                                "monoisotopic_mass": "1455.7852",
                                "monoisotopic_mz": "728.8999",
                                "intensity": "1401.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.0075034787",
                                        "theoretical_mass": "1455.7834",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0019",
                                        "ppm": "1.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "30",
                                "monoisotopic_mass": "8639.6136",
                                "monoisotopic_mz": "786.4267",
                                "intensity": "651.89",
                                "charge": "11"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "31",
                                "monoisotopic_mass": "1499.1671",
                                "monoisotopic_mz": "750.5908",
                                "intensity": "1730.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "32",
                                "monoisotopic_mass": "4798.6538",
                                "monoisotopic_mz": "686.5292",
                                "intensity": "2011.71",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0066",
                                        "ppm": "1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "33",
                                "monoisotopic_mass": "6064.7675",
                                "monoisotopic_mz": "759.1032",
                                "intensity": "632.34",
                                "charge": "8"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "34",
                                "monoisotopic_mass": "940.7184",
                                "monoisotopic_mz": "941.7257",
                                "intensity": "719.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "35",
                                "monoisotopic_mass": "1405.2538",
                                "monoisotopic_mz": "703.6342",
                                "intensity": "2341.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "36",
                                "monoisotopic_mass": "901.6011",
                                "monoisotopic_mz": "902.6084",
                                "intensity": "568.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "37",
                                "monoisotopic_mass": "3930.1976",
                                "monoisotopic_mz": "787.0468",
                                "intensity": "2125.88",
                                "charge": "5"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "38",
                                "monoisotopic_mass": "3305.1950",
                                "monoisotopic_mz": "827.3060",
                                "intensity": "1876.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "195",
                                "peak_id": "39",
                                "monoisotopic_mass": "1314.1990",
                                "monoisotopic_mz": "658.1068",
                                "intensity": "884.60",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.0022",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "195",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "195",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "195",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "195",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "195",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "195",
                                            "peak_id": "32",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "195",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "195",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "195",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "14",
                            "anno": "15.0075",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "142",
                "p_value": "2.34e-04",
                "e_value": "2.34e-04",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "493",
                        "ms1_scans": "660",
                        "ids": "166",
                        "scans": "661",
                        "precursor_mono_mass": "9234.9784",
                        "precursor_charge": "12",
                        "precursor_mz": "770.5888",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "166",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "41175.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6511",
                                "monoisotopic_mz": "800.7825",
                                "intensity": "18268.55",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0039",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7309",
                                "monoisotopic_mz": "819.4624",
                                "intensity": "9717.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "3",
                                "monoisotopic_mass": "4682.5644",
                                "monoisotopic_mz": "781.4347",
                                "intensity": "8538.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "4",
                                "monoisotopic_mass": "4982.7738",
                                "monoisotopic_mz": "831.4696",
                                "intensity": "7715.41",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0054",
                                        "ppm": "1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "5",
                                "monoisotopic_mass": "4495.4914",
                                "monoisotopic_mz": "750.2558",
                                "intensity": "4927.27",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0026",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "6",
                                "monoisotopic_mass": "4153.1401",
                                "monoisotopic_mz": "1039.2923",
                                "intensity": "3098.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "7",
                                "monoisotopic_mass": "4608.4671",
                                "monoisotopic_mz": "769.0851",
                                "intensity": "2965.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "8",
                                "monoisotopic_mass": "4137.1514",
                                "monoisotopic_mz": "1035.2951",
                                "intensity": "3758.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "9",
                                "monoisotopic_mass": "784.2667",
                                "monoisotopic_mz": "785.2740",
                                "intensity": "1791.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "10",
                                "monoisotopic_mass": "2283.7624",
                                "monoisotopic_mz": "762.2614",
                                "intensity": "8241.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "11",
                                "monoisotopic_mass": "3079.6610",
                                "monoisotopic_mz": "770.9225",
                                "intensity": "873.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "12",
                                "monoisotopic_mass": "2296.4780",
                                "monoisotopic_mz": "766.4999",
                                "intensity": "2765.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "13",
                                "monoisotopic_mass": "736.4050",
                                "monoisotopic_mz": "737.4123",
                                "intensity": "4010.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "14",
                                "monoisotopic_mass": "4715.6394",
                                "monoisotopic_mz": "786.9472",
                                "intensity": "2580.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "15",
                                "monoisotopic_mass": "3068.6465",
                                "monoisotopic_mz": "768.1689",
                                "intensity": "2017.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "16",
                                "monoisotopic_mass": "936.8373",
                                "monoisotopic_mz": "937.8446",
                                "intensity": "1013.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "17",
                                "monoisotopic_mass": "7783.2437",
                                "monoisotopic_mz": "865.8121",
                                "intensity": "1118.01",
                                "charge": "9"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "18",
                                "monoisotopic_mass": "7663.3295",
                                "monoisotopic_mz": "767.3402",
                                "intensity": "1748.08",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.2137134787",
                                        "theoretical_mass": "7663.3300",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "19",
                                "monoisotopic_mass": "7447.1503",
                                "monoisotopic_mz": "931.9011",
                                "intensity": "2379.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "20",
                                "monoisotopic_mass": "1488.8121",
                                "monoisotopic_mz": "745.4133",
                                "intensity": "717.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "21",
                                "monoisotopic_mass": "2793.5221",
                                "monoisotopic_mz": "932.1813",
                                "intensity": "2081.79",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0051",
                                        "ppm": "1.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "22",
                                "monoisotopic_mass": "836.1283",
                                "monoisotopic_mz": "837.1356",
                                "intensity": "1083.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "23",
                                "monoisotopic_mass": "3044.6819",
                                "monoisotopic_mz": "762.1777",
                                "intensity": "1909.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "24",
                                "monoisotopic_mass": "4893.6325",
                                "monoisotopic_mz": "816.6127",
                                "intensity": "2897.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "25",
                                "monoisotopic_mass": "4640.5611",
                                "monoisotopic_mz": "774.4341",
                                "intensity": "2364.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "26",
                                "monoisotopic_mass": "865.3209",
                                "monoisotopic_mz": "866.3282",
                                "intensity": "1303.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "27",
                                "monoisotopic_mass": "9212.4857",
                                "monoisotopic_mz": "838.5060",
                                "intensity": "1084.04",
                                "charge": "11"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "28",
                                "monoisotopic_mass": "4667.5893",
                                "monoisotopic_mz": "778.9388",
                                "intensity": "5199.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "29",
                                "monoisotopic_mass": "974.4206",
                                "monoisotopic_mz": "975.4279",
                                "intensity": "598.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "30",
                                "monoisotopic_mass": "6854.9613",
                                "monoisotopic_mz": "762.6696",
                                "intensity": "2198.56",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "15.2137134787",
                                        "theoretical_mass": "6853.9235",
                                        "ion_position": "24",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0354",
                                        "ppm": "5.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "31",
                                "monoisotopic_mass": "3097.0438",
                                "monoisotopic_mz": "775.2682",
                                "intensity": "834.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "32",
                                "monoisotopic_mass": "1442.7602",
                                "monoisotopic_mz": "722.3874",
                                "intensity": "578.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "33",
                                "monoisotopic_mass": "4284.0202",
                                "monoisotopic_mz": "715.0106",
                                "intensity": "1065.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "34",
                                "monoisotopic_mass": "5365.8949",
                                "monoisotopic_mz": "767.5637",
                                "intensity": "3001.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "35",
                                "monoisotopic_mass": "3850.3123",
                                "monoisotopic_mz": "771.0697",
                                "intensity": "1376.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "36",
                                "monoisotopic_mass": "4956.6743",
                                "monoisotopic_mz": "827.1197",
                                "intensity": "1436.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "37",
                                "monoisotopic_mass": "1458.3218",
                                "monoisotopic_mz": "730.1682",
                                "intensity": "498.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "38",
                                "monoisotopic_mass": "1599.5320",
                                "monoisotopic_mz": "800.7733",
                                "intensity": "2383.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "39",
                                "monoisotopic_mass": "6371.6928",
                                "monoisotopic_mz": "797.4689",
                                "intensity": "2054.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "166",
                                "peak_id": "40",
                                "monoisotopic_mass": "7764.9856",
                                "monoisotopic_mz": "777.5058",
                                "intensity": "1080.74",
                                "charge": "10"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.2084",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "24",
                                        "ion_display_position": "66",
                                        "spec_id": "166",
                                        "peak_id": "30",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "166",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "166",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "166",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "166",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "166",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "spec_id": "166",
                                        "peak_id": "18",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "28",
                            "right_position": "42",
                            "anno": "15.2137",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "5",
                "p_value": "4.67e-04",
                "e_value": "4.68e-04",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "7",
                        "ms1_scans": "13",
                        "ids": "5",
                        "scans": "14",
                        "precursor_mono_mass": "9234.9736",
                        "precursor_charge": "14",
                        "precursor_mz": "660.6482",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "5",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5782",
                                "monoisotopic_mz": "784.2703",
                                "intensity": "18220.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4885",
                                "monoisotopic_mz": "750.2554",
                                "intensity": "8838.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "2",
                                "monoisotopic_mass": "1472.8103",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "3635.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0003",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "3",
                                "monoisotopic_mass": "4363.4316",
                                "monoisotopic_mz": "728.2459",
                                "intensity": "3641.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "4",
                                "monoisotopic_mass": "2400.3246",
                                "monoisotopic_mz": "801.1155",
                                "intensity": "3794.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5584",
                                "monoisotopic_mz": "774.7670",
                                "intensity": "3966.15",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0011",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "6",
                                "monoisotopic_mass": "2640.4394",
                                "monoisotopic_mz": "661.1171",
                                "intensity": "3423.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "7",
                                "monoisotopic_mass": "1340.7559",
                                "monoisotopic_mz": "671.3853",
                                "intensity": "2651.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "8",
                                "monoisotopic_mass": "4798.6238",
                                "monoisotopic_mz": "686.5250",
                                "intensity": "2774.73",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0233",
                                        "ppm": "-4.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "9",
                                "monoisotopic_mass": "2284.7638",
                                "monoisotopic_mz": "762.5952",
                                "intensity": "3397.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "10",
                                "monoisotopic_mass": "2792.5061",
                                "monoisotopic_mz": "931.8426",
                                "intensity": "2846.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "11",
                                "monoisotopic_mass": "4681.5516",
                                "monoisotopic_mz": "669.8004",
                                "intensity": "1910.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "12",
                                "monoisotopic_mass": "2791.4957",
                                "monoisotopic_mz": "698.8812",
                                "intensity": "1075.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "13",
                                "monoisotopic_mass": "667.9314",
                                "monoisotopic_mz": "668.9387",
                                "intensity": "1209.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "14",
                                "monoisotopic_mass": "4642.5308",
                                "monoisotopic_mz": "664.2260",
                                "intensity": "3300.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0265",
                                        "ppm": "-5.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "15",
                                "monoisotopic_mass": "3044.6836",
                                "monoisotopic_mz": "762.1782",
                                "intensity": "1789.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "16",
                                "monoisotopic_mass": "1376.3454",
                                "monoisotopic_mz": "689.1800",
                                "intensity": "450.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "17",
                                "monoisotopic_mass": "4681.5599",
                                "monoisotopic_mz": "781.2673",
                                "intensity": "2749.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "18",
                                "monoisotopic_mass": "1200.1634",
                                "monoisotopic_mz": "601.0890",
                                "intensity": "629.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "19",
                                "monoisotopic_mass": "4568.4958",
                                "monoisotopic_mz": "653.6495",
                                "intensity": "914.84",
                                "charge": "7"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "20",
                                "monoisotopic_mass": "1429.2709",
                                "monoisotopic_mz": "715.6427",
                                "intensity": "437.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "21",
                                "monoisotopic_mass": "1492.8265",
                                "monoisotopic_mz": "747.4205",
                                "intensity": "474.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "22",
                                "monoisotopic_mass": "4495.4897",
                                "monoisotopic_mz": "643.2201",
                                "intensity": "1745.02",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0009",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "23",
                                "monoisotopic_mass": "2173.2130",
                                "monoisotopic_mz": "725.4116",
                                "intensity": "916.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "24",
                                "monoisotopic_mass": "1257.4266",
                                "monoisotopic_mz": "629.7206",
                                "intensity": "935.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "5",
                                "peak_id": "25",
                                "monoisotopic_mass": "854.4497",
                                "monoisotopic_mz": "855.4570",
                                "intensity": "574.83",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.2486",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "5",
                                        "peak_id": "8",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "5",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "5",
                                            "peak_id": "14",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "5",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "43",
                                            "spec_id": "5",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "43",
                                            "spec_id": "5",
                                            "peak_id": "22",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "5",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "15.2539",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "120",
                "p_value": "1.49e-03",
                "e_value": "1.49e-03",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "431",
                        "ms1_scans": "572",
                        "ids": "141",
                        "scans": "574",
                        "precursor_mono_mass": "9235.9885",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4679",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "141",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5826",
                                "monoisotopic_mz": "784.2710",
                                "intensity": "19122.65",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0039",
                                        "ppm": "0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6503",
                                "monoisotopic_mz": "800.7823",
                                "intensity": "13082.52",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0032",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5792",
                                "monoisotopic_mz": "672.3757",
                                "intensity": "9237.54",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0005",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "3",
                                "monoisotopic_mass": "4495.4921",
                                "monoisotopic_mz": "750.2560",
                                "intensity": "8566.69",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0033",
                                        "ppm": "0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8104",
                                "monoisotopic_mz": "737.4125",
                                "intensity": "5512.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "5",
                                "monoisotopic_mass": "4683.5576",
                                "monoisotopic_mz": "781.6002",
                                "intensity": "6262.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "6",
                                "monoisotopic_mass": "2284.2618",
                                "monoisotopic_mz": "762.4279",
                                "intensity": "2222.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "7",
                                "monoisotopic_mass": "4641.5525",
                                "monoisotopic_mz": "774.5994",
                                "intensity": "4296.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "8",
                                "monoisotopic_mass": "2792.5140",
                                "monoisotopic_mz": "931.8453",
                                "intensity": "4444.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "9",
                                "monoisotopic_mass": "3226.7680",
                                "monoisotopic_mz": "807.6993",
                                "intensity": "2738.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "10",
                                "monoisotopic_mass": "4643.5570",
                                "monoisotopic_mz": "664.3726",
                                "intensity": "2822.77",
                                "charge": "7"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "11",
                                "monoisotopic_mass": "4154.1470",
                                "monoisotopic_mz": "1039.5440",
                                "intensity": "2783.12",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9938334787",
                                        "theoretical_mass": "4154.1518",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0049",
                                        "ppm": "-1.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "12",
                                "monoisotopic_mass": "4477.4698",
                                "monoisotopic_mz": "747.2522",
                                "intensity": "2397.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "13",
                                "monoisotopic_mass": "4363.4393",
                                "monoisotopic_mz": "728.2472",
                                "intensity": "2697.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "14",
                                "monoisotopic_mass": "2810.5127",
                                "monoisotopic_mz": "937.8448",
                                "intensity": "1737.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "15",
                                "monoisotopic_mass": "4667.5981",
                                "monoisotopic_mz": "778.9403",
                                "intensity": "1991.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "16",
                                "monoisotopic_mass": "670.3787",
                                "monoisotopic_mz": "671.3860",
                                "intensity": "1045.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "17",
                                "monoisotopic_mass": "702.6294",
                                "monoisotopic_mz": "703.6367",
                                "intensity": "747.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "18",
                                "monoisotopic_mass": "1472.8083",
                                "monoisotopic_mz": "491.9434",
                                "intensity": "580.48",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0017",
                                        "ppm": "-1.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "19",
                                "monoisotopic_mass": "4510.5039",
                                "monoisotopic_mz": "752.7579",
                                "intensity": "1724.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "20",
                                "monoisotopic_mass": "3045.6825",
                                "monoisotopic_mz": "762.4279",
                                "intensity": "2468.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "21",
                                "monoisotopic_mass": "6266.1596",
                                "monoisotopic_mz": "784.2772",
                                "intensity": "1366.55",
                                "charge": "8"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "22",
                                "monoisotopic_mass": "802.4404",
                                "monoisotopic_mz": "803.4477",
                                "intensity": "863.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "23",
                                "monoisotopic_mass": "7790.3975",
                                "monoisotopic_mz": "709.2252",
                                "intensity": "1758.16",
                                "charge": "11"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "24",
                                "monoisotopic_mass": "9165.0816",
                                "monoisotopic_mz": "764.7641",
                                "intensity": "770.55",
                                "charge": "12"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "25",
                                "monoisotopic_mass": "2696.4290",
                                "monoisotopic_mz": "899.8169",
                                "intensity": "2309.73",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.9938334787",
                                        "theoretical_mass": "2696.4269",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0022",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "26",
                                "monoisotopic_mass": "9141.9331",
                                "monoisotopic_mz": "704.2329",
                                "intensity": "2316.27",
                                "charge": "13"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "27",
                                "monoisotopic_mass": "1304.2623",
                                "monoisotopic_mz": "653.1384",
                                "intensity": "628.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "28",
                                "monoisotopic_mass": "2918.3198",
                                "monoisotopic_mz": "730.5872",
                                "intensity": "918.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "141",
                                "peak_id": "29",
                                "monoisotopic_mass": "726.5966",
                                "monoisotopic_mz": "727.6038",
                                "intensity": "966.38",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.9885",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "141",
                                        "peak_id": "25",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "141",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "141",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "141",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "141",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "141",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "141",
                                            "peak_id": "18",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "141",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "27",
                            "anno": "15.9938",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "162",
                "p_value": "1.77e-03",
                "e_value": "1.77e-03",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "778",
                        "ms1_scans": "967",
                        "ids": "188",
                        "scans": "968",
                        "precursor_mono_mass": "9234.9798",
                        "precursor_charge": "12",
                        "precursor_mz": "770.5889",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "188",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5782",
                                "monoisotopic_mz": "784.2703",
                                "intensity": "42528.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "1",
                                "monoisotopic_mass": "4911.7296",
                                "monoisotopic_mz": "819.6289",
                                "intensity": "13629.73",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6466",
                                "monoisotopic_mz": "800.7817",
                                "intensity": "19924.71",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "3",
                                "monoisotopic_mass": "4981.7608",
                                "monoisotopic_mz": "831.3007",
                                "intensity": "4522.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "4",
                                "monoisotopic_mass": "4681.5580",
                                "monoisotopic_mz": "781.2669",
                                "intensity": "7304.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5558",
                                "monoisotopic_mz": "774.7666",
                                "intensity": "9301.96",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8112",
                                "monoisotopic_mz": "737.4129",
                                "intensity": "5313.74",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0013",
                                        "ppm": "0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "7",
                                "monoisotopic_mass": "4138.1504",
                                "monoisotopic_mz": "1035.5449",
                                "intensity": "4439.11",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "8",
                                "monoisotopic_mass": "4154.1509",
                                "monoisotopic_mz": "1039.5450",
                                "intensity": "5531.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "9",
                                "monoisotopic_mass": "3225.7657",
                                "monoisotopic_mz": "807.4487",
                                "intensity": "3764.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "10",
                                "monoisotopic_mass": "9216.9088",
                                "monoisotopic_mz": "769.0830",
                                "intensity": "2029.34",
                                "charge": "12"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "11",
                                "monoisotopic_mass": "2809.5089",
                                "monoisotopic_mz": "937.5103",
                                "intensity": "3332.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "12",
                                "monoisotopic_mass": "2334.2984",
                                "monoisotopic_mz": "779.1068",
                                "intensity": "2615.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "13",
                                "monoisotopic_mass": "2793.5123",
                                "monoisotopic_mz": "932.1780",
                                "intensity": "2495.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0048",
                                        "ppm": "-1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "14",
                                "monoisotopic_mass": "2247.7452",
                                "monoisotopic_mz": "750.2557",
                                "intensity": "2329.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "15",
                                "monoisotopic_mass": "1730.9314",
                                "monoisotopic_mz": "866.4730",
                                "intensity": "2918.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "16",
                                "monoisotopic_mass": "6313.3805",
                                "monoisotopic_mz": "902.9188",
                                "intensity": "2746.40",
                                "charge": "7"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "17",
                                "monoisotopic_mass": "4598.4691",
                                "monoisotopic_mz": "767.4188",
                                "intensity": "2360.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "18",
                                "monoisotopic_mass": "2492.3805",
                                "monoisotopic_mz": "831.8008",
                                "intensity": "2356.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "19",
                                "monoisotopic_mass": "1522.5058",
                                "monoisotopic_mz": "762.2602",
                                "intensity": "4668.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "20",
                                "monoisotopic_mass": "2193.4835",
                                "monoisotopic_mz": "732.1685",
                                "intensity": "2336.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "21",
                                "monoisotopic_mass": "3060.9409",
                                "monoisotopic_mz": "766.2425",
                                "intensity": "1570.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "22",
                                "monoisotopic_mass": "3080.6364",
                                "monoisotopic_mz": "771.1664",
                                "intensity": "1739.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "23",
                                "monoisotopic_mass": "6020.7861",
                                "monoisotopic_mz": "861.1196",
                                "intensity": "1188.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "24",
                                "monoisotopic_mass": "851.5704",
                                "monoisotopic_mz": "852.5777",
                                "intensity": "1001.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "25",
                                "monoisotopic_mass": "8339.3206",
                                "monoisotopic_mz": "759.1273",
                                "intensity": "775.25",
                                "charge": "11"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "26",
                                "monoisotopic_mass": "893.4712",
                                "monoisotopic_mz": "894.4785",
                                "intensity": "1160.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "27",
                                "monoisotopic_mass": "3305.0924",
                                "monoisotopic_mz": "827.2804",
                                "intensity": "1178.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "28",
                                "monoisotopic_mass": "3047.6964",
                                "monoisotopic_mz": "762.9314",
                                "intensity": "2486.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "29",
                                "monoisotopic_mass": "2922.5980",
                                "monoisotopic_mz": "731.6568",
                                "intensity": "923.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "30",
                                "monoisotopic_mass": "1027.2217",
                                "monoisotopic_mz": "1028.2290",
                                "intensity": "632.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "31",
                                "monoisotopic_mass": "4798.6397",
                                "monoisotopic_mz": "686.5272",
                                "intensity": "1950.36",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0075",
                                        "ppm": "-1.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "32",
                                "monoisotopic_mass": "797.4378",
                                "monoisotopic_mz": "798.4451",
                                "intensity": "1390.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "33",
                                "monoisotopic_mass": "5939.0390",
                                "monoisotopic_mz": "849.4414",
                                "intensity": "1163.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "34",
                                "monoisotopic_mass": "872.3821",
                                "monoisotopic_mz": "873.3893",
                                "intensity": "1309.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "35",
                                "monoisotopic_mass": "6118.2955",
                                "monoisotopic_mz": "765.7942",
                                "intensity": "1137.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "36",
                                "monoisotopic_mass": "5387.9904",
                                "monoisotopic_mz": "770.7202",
                                "intensity": "2561.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "37",
                                "monoisotopic_mass": "974.4181",
                                "monoisotopic_mz": "975.4254",
                                "intensity": "2204.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "38",
                                "monoisotopic_mass": "1419.7570",
                                "monoisotopic_mz": "710.8858",
                                "intensity": "607.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "39",
                                "monoisotopic_mass": "815.9429",
                                "monoisotopic_mz": "816.9502",
                                "intensity": "862.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "40",
                                "monoisotopic_mass": "5027.1230",
                                "monoisotopic_mz": "838.8611",
                                "intensity": "971.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "41",
                                "monoisotopic_mass": "930.8345",
                                "monoisotopic_mz": "931.8418",
                                "intensity": "553.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "42",
                                "monoisotopic_mass": "712.6265",
                                "monoisotopic_mz": "713.6338",
                                "intensity": "859.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "43",
                                "monoisotopic_mass": "1499.4992",
                                "monoisotopic_mz": "750.7569",
                                "intensity": "3609.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "44",
                                "monoisotopic_mass": "5841.9931",
                                "monoisotopic_mz": "835.5777",
                                "intensity": "1102.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "45",
                                "monoisotopic_mass": "1327.5918",
                                "monoisotopic_mz": "664.8032",
                                "intensity": "509.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "46",
                                "monoisotopic_mass": "1340.7563",
                                "monoisotopic_mz": "671.3854",
                                "intensity": "802.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "47",
                                "monoisotopic_mass": "5835.5671",
                                "monoisotopic_mz": "730.4532",
                                "intensity": "1222.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "48",
                                "monoisotopic_mass": "699.8786",
                                "monoisotopic_mz": "700.8858",
                                "intensity": "2168.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "49",
                                "monoisotopic_mass": "764.7458",
                                "monoisotopic_mz": "765.7531",
                                "intensity": "817.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "50",
                                "monoisotopic_mass": "729.9777",
                                "monoisotopic_mz": "730.9850",
                                "intensity": "1775.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "51",
                                "monoisotopic_mass": "749.9113",
                                "monoisotopic_mz": "750.9185",
                                "intensity": "541.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "188",
                                "peak_id": "52",
                                "monoisotopic_mass": "669.3678",
                                "monoisotopic_mz": "670.3751",
                                "intensity": "385.04",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.2549",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "188",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "188",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "188",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "188",
                                            "peak_id": "31",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "188",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "188",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "188",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "188",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "41",
                            "right_position": "43",
                            "anno": "15.2602",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "158",
                "p_value": "2.58e-03",
                "e_value": "2.58e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "773",
                        "ms1_scans": "956",
                        "ids": "184",
                        "scans": "959",
                        "precursor_mono_mass": "9235.9821",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4674",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "184",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5793",
                                "monoisotopic_mz": "784.2705",
                                "intensity": "25180.68",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6481",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "12081.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5251",
                                "monoisotopic_mz": "762.2615",
                                "intensity": "12219.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "3",
                                "monoisotopic_mass": "4494.4862",
                                "monoisotopic_mz": "750.0883",
                                "intensity": "10919.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "4",
                                "monoisotopic_mass": "4699.5741",
                                "monoisotopic_mz": "672.3750",
                                "intensity": "9207.44",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8093",
                                "monoisotopic_mz": "737.4119",
                                "intensity": "5201.86",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "6",
                                "monoisotopic_mass": "4797.6441",
                                "monoisotopic_mz": "686.3850",
                                "intensity": "6687.72",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "16.1174834787",
                                        "theoretical_mass": "4797.6448",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "7",
                                "monoisotopic_mass": "2809.5093",
                                "monoisotopic_mz": "937.5104",
                                "intensity": "2698.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "8",
                                "monoisotopic_mass": "4911.7083",
                                "monoisotopic_mz": "819.6253",
                                "intensity": "1146.98",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0229",
                                        "ppm": "-4.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "9",
                                "monoisotopic_mass": "2425.8533",
                                "monoisotopic_mz": "809.6251",
                                "intensity": "1905.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "10",
                                "monoisotopic_mass": "3227.7636",
                                "monoisotopic_mz": "807.9482",
                                "intensity": "1466.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "11",
                                "monoisotopic_mass": "2909.5592",
                                "monoisotopic_mz": "728.3971",
                                "intensity": "1756.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "12",
                                "monoisotopic_mass": "4665.5916",
                                "monoisotopic_mz": "778.6059",
                                "intensity": "2649.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "13",
                                "monoisotopic_mass": "1661.9253",
                                "monoisotopic_mz": "831.9699",
                                "intensity": "2222.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "14",
                                "monoisotopic_mass": "2341.2720",
                                "monoisotopic_mz": "781.4313",
                                "intensity": "4676.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "15",
                                "monoisotopic_mass": "723.5419",
                                "monoisotopic_mz": "724.5491",
                                "intensity": "937.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "16",
                                "monoisotopic_mass": "4922.4311",
                                "monoisotopic_mz": "704.2117",
                                "intensity": "726.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "17",
                                "monoisotopic_mass": "698.1269",
                                "monoisotopic_mz": "699.1342",
                                "intensity": "737.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "18",
                                "monoisotopic_mass": "930.8342",
                                "monoisotopic_mz": "931.8414",
                                "intensity": "1403.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "19",
                                "monoisotopic_mass": "669.3670",
                                "monoisotopic_mz": "670.3743",
                                "intensity": "902.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "20",
                                "monoisotopic_mass": "1421.0667",
                                "monoisotopic_mz": "711.5407",
                                "intensity": "1251.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "21",
                                "monoisotopic_mass": "3094.7038",
                                "monoisotopic_mz": "774.6832",
                                "intensity": "2791.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "22",
                                "monoisotopic_mass": "2183.1549",
                                "monoisotopic_mz": "728.7256",
                                "intensity": "3057.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "23",
                                "monoisotopic_mass": "1593.8929",
                                "monoisotopic_mz": "797.9537",
                                "intensity": "989.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "24",
                                "monoisotopic_mass": "2682.4369",
                                "monoisotopic_mz": "671.6165",
                                "intensity": "605.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "25",
                                "monoisotopic_mass": "893.4755",
                                "monoisotopic_mz": "894.4827",
                                "intensity": "877.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "26",
                                "monoisotopic_mass": "2816.5267",
                                "monoisotopic_mz": "705.1389",
                                "intensity": "1515.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "27",
                                "monoisotopic_mass": "3208.7546",
                                "monoisotopic_mz": "803.1959",
                                "intensity": "1791.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "28",
                                "monoisotopic_mass": "1323.2080",
                                "monoisotopic_mz": "662.6113",
                                "intensity": "567.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "29",
                                "monoisotopic_mass": "1034.7886",
                                "monoisotopic_mz": "1035.7959",
                                "intensity": "1111.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "30",
                                "monoisotopic_mass": "1280.1394",
                                "monoisotopic_mz": "641.0770",
                                "intensity": "598.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "31",
                                "monoisotopic_mass": "4646.5772",
                                "monoisotopic_mz": "775.4368",
                                "intensity": "2565.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "184",
                                "peak_id": "32",
                                "monoisotopic_mass": "776.9645",
                                "monoisotopic_mz": "777.9718",
                                "intensity": "774.15",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.1122",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "184",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "184",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "184",
                                            "peak_id": "4",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "184",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "184",
                                        "peak_id": "6",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "184",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "43",
                            "anno": "16.1175",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "104",
                "p_value": "2.67e-03",
                "e_value": "2.67e-03",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "390",
                        "ms1_scans": "514",
                        "ids": "123",
                        "scans": "515",
                        "precursor_mono_mass": "9234.9813",
                        "precursor_charge": "12",
                        "precursor_mz": "770.5891",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "123",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "37662.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "1",
                                "monoisotopic_mass": "4797.6450",
                                "monoisotopic_mz": "800.6148",
                                "intensity": "18466.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "2",
                                "monoisotopic_mass": "4911.7317",
                                "monoisotopic_mz": "819.6292",
                                "intensity": "13540.59",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0006",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "3",
                                "monoisotopic_mass": "2341.7766",
                                "monoisotopic_mz": "781.5995",
                                "intensity": "7267.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "4",
                                "monoisotopic_mass": "4154.1513",
                                "monoisotopic_mz": "1039.5451",
                                "intensity": "6461.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5599",
                                "monoisotopic_mz": "774.7673",
                                "intensity": "8941.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0026",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "6",
                                "monoisotopic_mass": "4568.5223",
                                "monoisotopic_mz": "762.4277",
                                "intensity": "5817.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "7",
                                "monoisotopic_mass": "4137.1470",
                                "monoisotopic_mz": "1035.2940",
                                "intensity": "3475.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "8",
                                "monoisotopic_mass": "4666.5947",
                                "monoisotopic_mz": "778.7731",
                                "intensity": "5679.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "9",
                                "monoisotopic_mass": "2809.5091",
                                "monoisotopic_mz": "937.5103",
                                "intensity": "3327.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "10",
                                "monoisotopic_mass": "2247.2405",
                                "monoisotopic_mz": "750.0874",
                                "intensity": "2488.07",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "11",
                                "monoisotopic_mass": "768.7496",
                                "monoisotopic_mz": "769.7569",
                                "intensity": "3152.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "12",
                                "monoisotopic_mass": "1472.8105",
                                "monoisotopic_mz": "737.4125",
                                "intensity": "3967.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0005",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "13",
                                "monoisotopic_mass": "1537.3348",
                                "monoisotopic_mz": "769.6747",
                                "intensity": "1920.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "14",
                                "monoisotopic_mass": "1455.7828",
                                "monoisotopic_mz": "728.8987",
                                "intensity": "1917.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "15",
                                "monoisotopic_mass": "9089.9092",
                                "monoisotopic_mz": "827.3627",
                                "intensity": "2186.78",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "9088.9542",
                                        "ion_position": "1",
                                        "ion_display_position": "89",
                                        "ion_sort_name": "Y00089",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0474",
                                        "ppm": "-5.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "16",
                                "monoisotopic_mass": "2311.2489",
                                "monoisotopic_mz": "771.4236",
                                "intensity": "1159.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "17",
                                "monoisotopic_mass": "3852.0729",
                                "monoisotopic_mz": "771.4219",
                                "intensity": "3430.91",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "18",
                                "monoisotopic_mass": "2792.5012",
                                "monoisotopic_mz": "931.8410",
                                "intensity": "2548.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "19",
                                "monoisotopic_mass": "1340.7553",
                                "monoisotopic_mz": "671.3849",
                                "intensity": "1790.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "20",
                                "monoisotopic_mass": "3208.7580",
                                "monoisotopic_mz": "803.1968",
                                "intensity": "1444.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "21",
                                "monoisotopic_mass": "864.7499",
                                "monoisotopic_mz": "865.7571",
                                "intensity": "1071.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "22",
                                "monoisotopic_mass": "2518.8449",
                                "monoisotopic_mz": "840.6222",
                                "intensity": "914.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "23",
                                "monoisotopic_mass": "4959.7453",
                                "monoisotopic_mz": "827.6315",
                                "intensity": "833.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "24",
                                "monoisotopic_mass": "4780.6760",
                                "monoisotopic_mz": "797.7866",
                                "intensity": "6271.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "25",
                                "monoisotopic_mass": "914.1582",
                                "monoisotopic_mz": "915.1655",
                                "intensity": "876.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "26",
                                "monoisotopic_mass": "4698.5807",
                                "monoisotopic_mz": "672.2331",
                                "intensity": "1788.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "27",
                                "monoisotopic_mass": "1499.1677",
                                "monoisotopic_mz": "750.5911",
                                "intensity": "3076.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "28",
                                "monoisotopic_mass": "5792.8427",
                                "monoisotopic_mz": "828.5562",
                                "intensity": "830.94",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "29",
                                "monoisotopic_mass": "8460.3393",
                                "monoisotopic_mz": "770.1290",
                                "intensity": "1939.60",
                                "charge": "11"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "30",
                                "monoisotopic_mass": "974.4186",
                                "monoisotopic_mz": "975.4258",
                                "intensity": "1351.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "31",
                                "monoisotopic_mass": "6055.2559",
                                "monoisotopic_mz": "866.0438",
                                "intensity": "2792.91",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6056.2560",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0023",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "32",
                                "monoisotopic_mass": "7090.3209",
                                "monoisotopic_mz": "788.8207",
                                "intensity": "756.82",
                                "charge": "9"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "33",
                                "monoisotopic_mass": "3982.1582",
                                "monoisotopic_mz": "797.4389",
                                "intensity": "783.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "34",
                                "monoisotopic_mass": "841.6057",
                                "monoisotopic_mz": "842.6129",
                                "intensity": "708.41",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.2563",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "89",
                                        "spec_id": "123",
                                        "peak_id": "15",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "123",
                                        "peak_id": "31",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "123",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "123",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "123",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "123",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "1",
                            "anno": "15.2616",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "151",
                "p_value": "2.85e-03",
                "e_value": "2.86e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "524",
                        "ms1_scans": "701",
                        "ids": "177",
                        "scans": "703",
                        "precursor_mono_mass": "9234.9768",
                        "precursor_charge": "13",
                        "precursor_mz": "711.3901",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "177",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "25351.96",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4907",
                                "monoisotopic_mz": "750.2557",
                                "intensity": "9351.32",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0018",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6503",
                                "monoisotopic_mz": "800.7823",
                                "intensity": "11183.46",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0032",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5258",
                                "monoisotopic_mz": "762.2616",
                                "intensity": "8102.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "4",
                                "monoisotopic_mass": "4699.5749",
                                "monoisotopic_mz": "672.3751",
                                "intensity": "6594.16",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8099",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "5776.09",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "6",
                                "monoisotopic_mass": "4909.7329",
                                "monoisotopic_mz": "819.2961",
                                "intensity": "3985.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "7",
                                "monoisotopic_mass": "2792.5050",
                                "monoisotopic_mz": "931.8423",
                                "intensity": "3311.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "8",
                                "monoisotopic_mass": "1340.7559",
                                "monoisotopic_mz": "671.3853",
                                "intensity": "2879.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "9",
                                "monoisotopic_mass": "2321.7815",
                                "monoisotopic_mz": "774.9344",
                                "intensity": "3729.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7715",
                                "monoisotopic_mz": "807.7002",
                                "intensity": "2836.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "11",
                                "monoisotopic_mass": "1455.7815",
                                "monoisotopic_mz": "728.8980",
                                "intensity": "2651.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "15.0071734787",
                                        "theoretical_mass": "1455.7831",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "12",
                                "monoisotopic_mass": "974.4184",
                                "monoisotopic_mz": "975.4257",
                                "intensity": "1643.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "13",
                                "monoisotopic_mass": "4780.6723",
                                "monoisotopic_mz": "797.7860",
                                "intensity": "1222.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "14",
                                "monoisotopic_mass": "2791.4990",
                                "monoisotopic_mz": "698.8820",
                                "intensity": "2307.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "15",
                                "monoisotopic_mass": "6548.4511",
                                "monoisotopic_mz": "728.6130",
                                "intensity": "1107.01",
                                "charge": "9"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "16",
                                "monoisotopic_mass": "4682.5618",
                                "monoisotopic_mz": "781.4342",
                                "intensity": "3603.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "17",
                                "monoisotopic_mass": "2679.4216",
                                "monoisotopic_mz": "670.8627",
                                "intensity": "870.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "18",
                                "monoisotopic_mass": "706.9191",
                                "monoisotopic_mz": "707.9264",
                                "intensity": "1113.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "19",
                                "monoisotopic_mass": "1493.5000",
                                "monoisotopic_mz": "747.7573",
                                "intensity": "1216.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "20",
                                "monoisotopic_mass": "686.2369",
                                "monoisotopic_mz": "687.2442",
                                "intensity": "1590.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "21",
                                "monoisotopic_mass": "1402.7442",
                                "monoisotopic_mz": "702.3794",
                                "intensity": "511.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "22",
                                "monoisotopic_mass": "4509.5118",
                                "monoisotopic_mz": "752.5926",
                                "intensity": "807.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "23",
                                "monoisotopic_mass": "1034.7839",
                                "monoisotopic_mz": "1035.7911",
                                "intensity": "614.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "24",
                                "monoisotopic_mass": "7535.7773",
                                "monoisotopic_mz": "754.5850",
                                "intensity": "1167.20",
                                "charge": "10"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "25",
                                "monoisotopic_mass": "1438.8054",
                                "monoisotopic_mz": "720.4100",
                                "intensity": "549.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "177",
                                "peak_id": "26",
                                "monoisotopic_mass": "1015.5374",
                                "monoisotopic_mz": "1016.5447",
                                "intensity": "812.48",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9235.0018",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "177",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "177",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "177",
                                            "peak_id": "4",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "177",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "177",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "177",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "14",
                            "anno": "15.0072",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "58",
                "p_value": "3.52e-03",
                "e_value": "3.53e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "229",
                        "ms1_scans": "301",
                        "ids": "71",
                        "scans": "302",
                        "precursor_mono_mass": "9235.9837",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4676",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "71",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5745",
                                "monoisotopic_mz": "784.2697",
                                "intensity": "19385.96",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0042",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5813",
                                "monoisotopic_mz": "672.3760",
                                "intensity": "13126.31",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0026",
                                        "ppm": "0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6456",
                                "monoisotopic_mz": "800.7815",
                                "intensity": "9879.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "3",
                                "monoisotopic_mass": "4495.4900",
                                "monoisotopic_mz": "750.2556",
                                "intensity": "8154.19",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0011",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5222",
                                "monoisotopic_mz": "762.2610",
                                "intensity": "6058.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "5",
                                "monoisotopic_mass": "4911.7310",
                                "monoisotopic_mz": "819.6291",
                                "intensity": "6166.40",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5622",
                                "monoisotopic_mz": "781.4343",
                                "intensity": "7185.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "7",
                                "monoisotopic_mass": "736.4049",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "3178.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "8",
                                "monoisotopic_mass": "2321.7773",
                                "monoisotopic_mz": "774.9330",
                                "intensity": "1945.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "9",
                                "monoisotopic_mass": "4140.1631",
                                "monoisotopic_mz": "1036.0480",
                                "intensity": "831.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "10",
                                "monoisotopic_mass": "2793.5170",
                                "monoisotopic_mz": "932.1796",
                                "intensity": "945.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "11",
                                "monoisotopic_mass": "4799.6445",
                                "monoisotopic_mz": "686.6708",
                                "intensity": "1294.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "12",
                                "monoisotopic_mass": "2069.0758",
                                "monoisotopic_mz": "1035.5452",
                                "intensity": "1307.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "13",
                                "monoisotopic_mass": "6554.4808",
                                "monoisotopic_mz": "729.2829",
                                "intensity": "963.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "14",
                                "monoisotopic_mass": "752.2518",
                                "monoisotopic_mz": "753.2591",
                                "intensity": "1012.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "15",
                                "monoisotopic_mass": "709.9004",
                                "monoisotopic_mz": "710.9077",
                                "intensity": "949.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "16",
                                "monoisotopic_mass": "7175.1131",
                                "monoisotopic_mz": "653.2903",
                                "intensity": "813.54",
                                "charge": "11"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "17",
                                "monoisotopic_mass": "3095.7094",
                                "monoisotopic_mz": "774.9346",
                                "intensity": "1108.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "18",
                                "monoisotopic_mass": "831.9592",
                                "monoisotopic_mz": "832.9664",
                                "intensity": "1735.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "19",
                                "monoisotopic_mass": "1286.1472",
                                "monoisotopic_mz": "644.0809",
                                "intensity": "610.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "20",
                                "monoisotopic_mass": "660.9358",
                                "monoisotopic_mz": "661.9431",
                                "intensity": "887.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "21",
                                "monoisotopic_mass": "974.4197",
                                "monoisotopic_mz": "975.4270",
                                "intensity": "1837.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "22",
                                "monoisotopic_mass": "1493.1598",
                                "monoisotopic_mz": "747.5872",
                                "intensity": "695.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "23",
                                "monoisotopic_mass": "4983.7669",
                                "monoisotopic_mz": "831.6351",
                                "intensity": "2195.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "24",
                                "monoisotopic_mass": "5456.2536",
                                "monoisotopic_mz": "780.4721",
                                "intensity": "610.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "25",
                                "monoisotopic_mass": "778.6007",
                                "monoisotopic_mz": "779.6080",
                                "intensity": "1105.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "26",
                                "monoisotopic_mass": "2112.7587",
                                "monoisotopic_mz": "705.2602",
                                "intensity": "901.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "27",
                                "monoisotopic_mass": "1439.8242",
                                "monoisotopic_mz": "720.9194",
                                "intensity": "598.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "28",
                                "monoisotopic_mass": "7875.6698",
                                "monoisotopic_mz": "788.5743",
                                "intensity": "1109.73",
                                "charge": "10"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "29",
                                "monoisotopic_mass": "1454.8143",
                                "monoisotopic_mz": "728.4144",
                                "intensity": "2418.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "30",
                                "monoisotopic_mass": "1402.3210",
                                "monoisotopic_mz": "702.1678",
                                "intensity": "498.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "71",
                                "peak_id": "31",
                                "monoisotopic_mass": "695.5537",
                                "monoisotopic_mz": "696.5610",
                                "intensity": "1074.56",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.2587",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "71",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "71",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "71",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "71",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "71",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "71",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "28",
                            "right_position": "43",
                            "anno": "16.2641",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "167",
                "p_value": "3.73e-03",
                "e_value": "3.73e-03",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "800",
                        "ms1_scans": "995",
                        "ids": "194",
                        "scans": "996",
                        "precursor_mono_mass": "9234.9872",
                        "precursor_charge": "12",
                        "precursor_mz": "770.5895",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "194",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5789",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "37420.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6485",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "16779.66",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0014",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7291",
                                "monoisotopic_mz": "819.4621",
                                "intensity": "10035.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5332",
                                "monoisotopic_mz": "762.2628",
                                "intensity": "8693.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "4",
                                "monoisotopic_mass": "4641.5557",
                                "monoisotopic_mz": "774.5999",
                                "intensity": "6021.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5507",
                                "monoisotopic_mz": "781.2657",
                                "intensity": "9648.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "6",
                                "monoisotopic_mass": "2300.7355",
                                "monoisotopic_mz": "767.9191",
                                "intensity": "2565.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "7",
                                "monoisotopic_mass": "4154.1465",
                                "monoisotopic_mz": "1039.5439",
                                "intensity": "2881.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "8",
                                "monoisotopic_mass": "6054.2420",
                                "monoisotopic_mz": "865.8990",
                                "intensity": "3846.60",
                                "charge": "7"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "9",
                                "monoisotopic_mass": "4137.1538",
                                "monoisotopic_mz": "1035.2957",
                                "intensity": "3533.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "10",
                                "monoisotopic_mass": "1472.8100",
                                "monoisotopic_mz": "737.4123",
                                "intensity": "2860.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0000",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "11",
                                "monoisotopic_mass": "2809.5146",
                                "monoisotopic_mz": "937.5121",
                                "intensity": "2412.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "12",
                                "monoisotopic_mass": "2652.4755",
                                "monoisotopic_mz": "885.1658",
                                "intensity": "1196.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "13",
                                "monoisotopic_mass": "766.0760",
                                "monoisotopic_mz": "767.0833",
                                "intensity": "1071.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "14",
                                "monoisotopic_mass": "2906.5906",
                                "monoisotopic_mz": "727.6549",
                                "intensity": "1703.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "15",
                                "monoisotopic_mass": "6548.4609",
                                "monoisotopic_mz": "819.5649",
                                "intensity": "1290.60",
                                "charge": "8"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "16",
                                "monoisotopic_mass": "7206.5358",
                                "monoisotopic_mz": "801.7335",
                                "intensity": "1287.36",
                                "charge": "9"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "17",
                                "monoisotopic_mass": "6312.3640",
                                "monoisotopic_mz": "902.7736",
                                "intensity": "1137.07",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6313.3935",
                                        "ion_position": "29",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0272",
                                        "ppm": "-4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "18",
                                "monoisotopic_mass": "4154.1372",
                                "monoisotopic_mz": "831.8347",
                                "intensity": "794.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "19",
                                "monoisotopic_mass": "2473.5153",
                                "monoisotopic_mz": "825.5124",
                                "intensity": "939.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "20",
                                "monoisotopic_mass": "2921.5924",
                                "monoisotopic_mz": "731.4054",
                                "intensity": "1830.83",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.9925034787",
                                        "theoretical_mass": "2921.5937",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "21",
                                "monoisotopic_mass": "1498.8307",
                                "monoisotopic_mz": "750.4226",
                                "intensity": "2566.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "22",
                                "monoisotopic_mass": "4601.9515",
                                "monoisotopic_mz": "767.9992",
                                "intensity": "2385.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "23",
                                "monoisotopic_mass": "783.6340",
                                "monoisotopic_mz": "784.6413",
                                "intensity": "1177.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "24",
                                "monoisotopic_mass": "815.6365",
                                "monoisotopic_mz": "816.6437",
                                "intensity": "987.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "25",
                                "monoisotopic_mass": "3280.7827",
                                "monoisotopic_mz": "821.2030",
                                "intensity": "1893.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "26",
                                "monoisotopic_mass": "7446.5953",
                                "monoisotopic_mz": "828.4067",
                                "intensity": "1105.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "27",
                                "monoisotopic_mass": "1531.8237",
                                "monoisotopic_mz": "766.9191",
                                "intensity": "1686.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "28",
                                "monoisotopic_mass": "1613.8857",
                                "monoisotopic_mz": "807.9501",
                                "intensity": "1522.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "29",
                                "monoisotopic_mass": "1656.0222",
                                "monoisotopic_mz": "829.0184",
                                "intensity": "2429.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "30",
                                "monoisotopic_mass": "974.4181",
                                "monoisotopic_mz": "975.4254",
                                "intensity": "1677.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "31",
                                "monoisotopic_mass": "851.4604",
                                "monoisotopic_mz": "852.4677",
                                "intensity": "1539.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "32",
                                "monoisotopic_mass": "715.1705",
                                "monoisotopic_mz": "716.1778",
                                "intensity": "935.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "33",
                                "monoisotopic_mass": "1341.7574",
                                "monoisotopic_mz": "671.8860",
                                "intensity": "717.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "34",
                                "monoisotopic_mass": "3831.0248",
                                "monoisotopic_mz": "767.2122",
                                "intensity": "1495.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "35",
                                "monoisotopic_mass": "6023.2727",
                                "monoisotopic_mz": "861.4748",
                                "intensity": "2274.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "36",
                                "monoisotopic_mass": "4036.7271",
                                "monoisotopic_mz": "808.3527",
                                "intensity": "1189.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "37",
                                "monoisotopic_mass": "986.9208",
                                "monoisotopic_mz": "987.9280",
                                "intensity": "590.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "38",
                                "monoisotopic_mass": "752.3177",
                                "monoisotopic_mz": "753.3249",
                                "intensity": "616.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "39",
                                "monoisotopic_mass": "6882.1567",
                                "monoisotopic_mz": "861.2769",
                                "intensity": "1483.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "40",
                                "monoisotopic_mass": "949.8762",
                                "monoisotopic_mz": "950.8835",
                                "intensity": "553.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "41",
                                "monoisotopic_mass": "703.9256",
                                "monoisotopic_mz": "704.9328",
                                "intensity": "759.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "42",
                                "monoisotopic_mass": "883.4800",
                                "monoisotopic_mz": "884.4872",
                                "intensity": "464.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "194",
                                "peak_id": "43",
                                "monoisotopic_mass": "829.4198",
                                "monoisotopic_mz": "830.4271",
                                "intensity": "558.27",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.9925034787",
                                        "theoretical_mass": "829.4296",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "-0.0098",
                                        "ppm": "-11.84"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9234.9872",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "194",
                                        "peak_id": "43",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "194",
                                            "peak_id": "20",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "61",
                                            "spec_id": "194",
                                            "peak_id": "17",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "194",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "194",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "194",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "7",
                            "anno": "14.9925",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "88",
                "p_value": "5.37e-03",
                "e_value": "5.38e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "337",
                        "ms1_scans": "444",
                        "ids": "106",
                        "scans": "445",
                        "precursor_mono_mass": "9235.9829",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4675",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "106",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5756",
                                "monoisotopic_mz": "784.2699",
                                "intensity": "16604.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6558",
                                "monoisotopic_mz": "800.7832",
                                "intensity": "9801.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0087",
                                        "ppm": "1.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5295",
                                "monoisotopic_mz": "762.2622",
                                "intensity": "8018.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "3",
                                "monoisotopic_mass": "4699.5745",
                                "monoisotopic_mz": "672.3751",
                                "intensity": "6987.01",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0042",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "4",
                                "monoisotopic_mass": "4495.4885",
                                "monoisotopic_mz": "750.2554",
                                "intensity": "6092.58",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "5",
                                "monoisotopic_mass": "2793.5159",
                                "monoisotopic_mz": "932.1793",
                                "intensity": "3581.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "6",
                                "monoisotopic_mass": "2341.2762",
                                "monoisotopic_mz": "781.4327",
                                "intensity": "4240.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "7",
                                "monoisotopic_mass": "783.2627",
                                "monoisotopic_mz": "784.2700",
                                "intensity": "2409.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "8",
                                "monoisotopic_mass": "1340.7517",
                                "monoisotopic_mz": "671.3831",
                                "intensity": "2538.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "9",
                                "monoisotopic_mass": "3226.7666",
                                "monoisotopic_mz": "807.6989",
                                "intensity": "4358.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "10",
                                "monoisotopic_mass": "4797.6347",
                                "monoisotopic_mz": "686.3837",
                                "intensity": "3264.88",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "16.1082834787",
                                        "theoretical_mass": "4797.6356",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "11",
                                "monoisotopic_mass": "2454.8643",
                                "monoisotopic_mz": "819.2954",
                                "intensity": "2491.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "12",
                                "monoisotopic_mass": "4509.4964",
                                "monoisotopic_mz": "752.5900",
                                "intensity": "2621.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "13",
                                "monoisotopic_mass": "2679.4171",
                                "monoisotopic_mz": "894.1463",
                                "intensity": "934.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "14",
                                "monoisotopic_mass": "4642.5588",
                                "monoisotopic_mz": "774.7671",
                                "intensity": "1800.17",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0016",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "15",
                                "monoisotopic_mass": "795.4150",
                                "monoisotopic_mz": "796.4222",
                                "intensity": "1108.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "16",
                                "monoisotopic_mass": "706.8341",
                                "monoisotopic_mz": "707.8414",
                                "intensity": "958.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "17",
                                "monoisotopic_mass": "2809.5129",
                                "monoisotopic_mz": "937.5116",
                                "intensity": "1744.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "18",
                                "monoisotopic_mass": "4654.5236",
                                "monoisotopic_mz": "776.7612",
                                "intensity": "1080.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "19",
                                "monoisotopic_mass": "4494.4814",
                                "monoisotopic_mz": "643.0761",
                                "intensity": "1634.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "20",
                                "monoisotopic_mass": "1456.7846",
                                "monoisotopic_mz": "729.3996",
                                "intensity": "728.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "21",
                                "monoisotopic_mass": "2695.4239",
                                "monoisotopic_mz": "899.4819",
                                "intensity": "925.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "22",
                                "monoisotopic_mass": "6078.1538",
                                "monoisotopic_mz": "676.3577",
                                "intensity": "2861.96",
                                "charge": "9"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "23",
                                "monoisotopic_mass": "4250.0289",
                                "monoisotopic_mz": "709.3454",
                                "intensity": "1937.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "24",
                                "monoisotopic_mass": "1406.0676",
                                "monoisotopic_mz": "704.0411",
                                "intensity": "967.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "25",
                                "monoisotopic_mass": "6752.4416",
                                "monoisotopic_mz": "676.2514",
                                "intensity": "2105.59",
                                "charge": "10"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "26",
                                "monoisotopic_mass": "2111.2531",
                                "monoisotopic_mz": "704.7583",
                                "intensity": "1151.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "27",
                                "monoisotopic_mass": "661.7467",
                                "monoisotopic_mz": "662.7540",
                                "intensity": "689.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "28",
                                "monoisotopic_mass": "675.6101",
                                "monoisotopic_mz": "676.6174",
                                "intensity": "903.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "29",
                                "monoisotopic_mass": "5894.1178",
                                "monoisotopic_mz": "655.9092",
                                "intensity": "1452.68",
                                "charge": "9"
                            },
                            {
                                "spec_id": "106",
                                "peak_id": "30",
                                "monoisotopic_mass": "1428.5963",
                                "monoisotopic_mz": "715.3054",
                                "intensity": "796.43",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.1030",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "106",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "106",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "106",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "106",
                                        "peak_id": "14",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "106",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "106",
                                        "peak_id": "10",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "16.1083",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "128",
                "p_value": "7.53e-03",
                "e_value": "7.56e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "454",
                        "ms1_scans": "606",
                        "ids": "151",
                        "scans": "607",
                        "precursor_mono_mass": "9235.9829",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4675",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "151",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5797",
                                "monoisotopic_mz": "784.2706",
                                "intensity": "23001.74",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0010",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6503",
                                "monoisotopic_mz": "800.7823",
                                "intensity": "14962.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0032",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5800",
                                "monoisotopic_mz": "672.3759",
                                "intensity": "9609.36",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0013",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5262",
                                "monoisotopic_mz": "762.2616",
                                "intensity": "16132.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "4",
                                "monoisotopic_mass": "4495.4896",
                                "monoisotopic_mz": "750.2555",
                                "intensity": "8663.06",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0007",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5536",
                                "monoisotopic_mz": "781.2662",
                                "intensity": "6898.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "6",
                                "monoisotopic_mass": "4642.5588",
                                "monoisotopic_mz": "774.7671",
                                "intensity": "6966.92",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0016",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "7",
                                "monoisotopic_mass": "1472.8098",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "5143.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "8",
                                "monoisotopic_mass": "4363.4349",
                                "monoisotopic_mz": "728.2464",
                                "intensity": "7715.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "9",
                                "monoisotopic_mass": "4477.4636",
                                "monoisotopic_mz": "747.2512",
                                "intensity": "4256.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7678",
                                "monoisotopic_mz": "807.6992",
                                "intensity": "4648.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "11",
                                "monoisotopic_mass": "2809.5122",
                                "monoisotopic_mz": "937.5113",
                                "intensity": "3482.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "12",
                                "monoisotopic_mass": "2792.5121",
                                "monoisotopic_mz": "931.8446",
                                "intensity": "3421.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "13",
                                "monoisotopic_mass": "4666.5679",
                                "monoisotopic_mz": "778.7686",
                                "intensity": "5457.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "14",
                                "monoisotopic_mass": "642.6430",
                                "monoisotopic_mz": "643.6503",
                                "intensity": "1286.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "15",
                                "monoisotopic_mass": "783.4287",
                                "monoisotopic_mz": "784.4360",
                                "intensity": "3202.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "16",
                                "monoisotopic_mass": "4910.7261",
                                "monoisotopic_mz": "819.4616",
                                "intensity": "3712.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "17",
                                "monoisotopic_mass": "4328.2698",
                                "monoisotopic_mz": "722.3856",
                                "intensity": "891.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "18",
                                "monoisotopic_mass": "6798.5547",
                                "monoisotopic_mz": "756.4022",
                                "intensity": "754.97",
                                "charge": "9"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "19",
                                "monoisotopic_mass": "4136.1412",
                                "monoisotopic_mz": "1035.0426",
                                "intensity": "1813.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "20",
                                "monoisotopic_mass": "2119.9052",
                                "monoisotopic_mz": "707.6423",
                                "intensity": "939.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "21",
                                "monoisotopic_mass": "671.3684",
                                "monoisotopic_mz": "672.3757",
                                "intensity": "1212.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "22",
                                "monoisotopic_mass": "1368.4718",
                                "monoisotopic_mz": "685.2432",
                                "intensity": "489.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "23",
                                "monoisotopic_mass": "5673.2814",
                                "monoisotopic_mz": "710.1674",
                                "intensity": "794.98",
                                "charge": "8"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "24",
                                "monoisotopic_mass": "1472.8093",
                                "monoisotopic_mz": "491.9437",
                                "intensity": "495.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "25",
                                "monoisotopic_mass": "974.4200",
                                "monoisotopic_mz": "975.4272",
                                "intensity": "1965.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "26",
                                "monoisotopic_mass": "1434.1966",
                                "monoisotopic_mz": "718.1056",
                                "intensity": "560.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "27",
                                "monoisotopic_mass": "4780.6741",
                                "monoisotopic_mz": "797.7863",
                                "intensity": "3579.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "28",
                                "monoisotopic_mass": "1396.2492",
                                "monoisotopic_mz": "699.1319",
                                "intensity": "2633.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "29",
                                "monoisotopic_mass": "4092.3903",
                                "monoisotopic_mz": "819.4853",
                                "intensity": "612.91",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "30",
                                "monoisotopic_mass": "707.9949",
                                "monoisotopic_mz": "709.0021",
                                "intensity": "987.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "31",
                                "monoisotopic_mass": "1160.5184",
                                "monoisotopic_mz": "1161.5256",
                                "intensity": "711.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "32",
                                "monoisotopic_mass": "1313.5793",
                                "monoisotopic_mz": "657.7969",
                                "intensity": "506.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "33",
                                "monoisotopic_mass": "1326.7315",
                                "monoisotopic_mz": "664.3730",
                                "intensity": "633.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "34",
                                "monoisotopic_mass": "1340.7572",
                                "monoisotopic_mz": "671.3859",
                                "intensity": "1060.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "35",
                                "monoisotopic_mass": "4624.5442",
                                "monoisotopic_mz": "661.6564",
                                "intensity": "1921.70",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.2580",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "151",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "151",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "151",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "151",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "151",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "151",
                                            "peak_id": "24",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "151",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "16.2633",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "30",
                "p_value": "0.01",
                "e_value": "0.01",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_1_ms2.msalign",
                        "ms1_ids": "113",
                        "ms1_scans": "149",
                        "ids": "35",
                        "scans": "150",
                        "precursor_mono_mass": "9235.9837",
                        "precursor_charge": "13",
                        "precursor_mz": "711.4676",
                        "feature_inte": "2.2444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "35",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5767",
                                "monoisotopic_mz": "784.2701",
                                "intensity": "29506.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6423",
                                "monoisotopic_mz": "800.7810",
                                "intensity": "9006.27",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0048",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "2",
                                "monoisotopic_mass": "4912.7249",
                                "monoisotopic_mz": "819.7948",
                                "intensity": "4740.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "3",
                                "monoisotopic_mass": "4698.5739",
                                "monoisotopic_mz": "672.2321",
                                "intensity": "11080.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "4",
                                "monoisotopic_mass": "4798.6439",
                                "monoisotopic_mz": "686.5278",
                                "intensity": "7037.45",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0032",
                                        "ppm": "-0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5415",
                                "monoisotopic_mz": "781.2642",
                                "intensity": "3668.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "6",
                                "monoisotopic_mass": "1547.8532",
                                "monoisotopic_mz": "774.9339",
                                "intensity": "4652.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "7",
                                "monoisotopic_mass": "4138.1406",
                                "monoisotopic_mz": "1035.5424",
                                "intensity": "2788.78",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0174",
                                        "ppm": "-4.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "8",
                                "monoisotopic_mass": "2697.4242",
                                "monoisotopic_mz": "675.3633",
                                "intensity": "2043.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "9",
                                "monoisotopic_mass": "2810.5109",
                                "monoisotopic_mz": "937.8442",
                                "intensity": "2363.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "10",
                                "monoisotopic_mass": "2332.2687",
                                "monoisotopic_mz": "778.4302",
                                "intensity": "877.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "11",
                                "monoisotopic_mass": "2792.5105",
                                "monoisotopic_mz": "931.8441",
                                "intensity": "2071.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "12",
                                "monoisotopic_mass": "3208.7601",
                                "monoisotopic_mz": "803.1973",
                                "intensity": "1147.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "13",
                                "monoisotopic_mass": "8558.6887",
                                "monoisotopic_mz": "779.0699",
                                "intensity": "694.85",
                                "charge": "11"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "14",
                                "monoisotopic_mass": "5824.1598",
                                "monoisotopic_mz": "833.0301",
                                "intensity": "1074.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "15",
                                "monoisotopic_mass": "1310.6217",
                                "monoisotopic_mz": "656.3181",
                                "intensity": "4959.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "16",
                                "monoisotopic_mass": "7987.1259",
                                "monoisotopic_mz": "727.1096",
                                "intensity": "1287.24",
                                "charge": "11"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "17",
                                "monoisotopic_mass": "1237.1195",
                                "monoisotopic_mz": "619.5670",
                                "intensity": "538.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "18",
                                "monoisotopic_mass": "1340.7550",
                                "monoisotopic_mz": "671.3848",
                                "intensity": "1420.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "19",
                                "monoisotopic_mass": "974.4189",
                                "monoisotopic_mz": "975.4262",
                                "intensity": "1839.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "20",
                                "monoisotopic_mass": "3044.6419",
                                "monoisotopic_mz": "762.1678",
                                "intensity": "3342.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "21",
                                "monoisotopic_mass": "1499.8330",
                                "monoisotopic_mz": "750.9238",
                                "intensity": "3972.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "22",
                                "monoisotopic_mass": "4920.9861",
                                "monoisotopic_mz": "704.0053",
                                "intensity": "2763.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "23",
                                "monoisotopic_mass": "9133.8514",
                                "monoisotopic_mz": "703.6112",
                                "intensity": "887.22",
                                "charge": "13"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "24",
                                "monoisotopic_mass": "770.5399",
                                "monoisotopic_mz": "771.5472",
                                "intensity": "932.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "25",
                                "monoisotopic_mass": "4438.4618",
                                "monoisotopic_mz": "740.7509",
                                "intensity": "2139.95",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4438.4674",
                                        "ion_position": "48",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "Y00042",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "26",
                                "monoisotopic_mass": "752.2507",
                                "monoisotopic_mz": "753.2579",
                                "intensity": "931.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "27",
                                "monoisotopic_mass": "884.7865",
                                "monoisotopic_mz": "885.7938",
                                "intensity": "587.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "28",
                                "monoisotopic_mass": "2182.2184",
                                "monoisotopic_mz": "728.4134",
                                "intensity": "3032.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "29",
                                "monoisotopic_mass": "1440.7680",
                                "monoisotopic_mz": "721.3913",
                                "intensity": "1008.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1440.7759",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0078",
                                        "ppm": "-5.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "30",
                                "monoisotopic_mass": "799.9432",
                                "monoisotopic_mz": "800.9505",
                                "intensity": "744.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "31",
                                "monoisotopic_mass": "2798.4346",
                                "monoisotopic_mz": "700.6159",
                                "intensity": "1503.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "32",
                                "monoisotopic_mass": "3143.8095",
                                "monoisotopic_mz": "786.9597",
                                "intensity": "1723.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "33",
                                "monoisotopic_mass": "1480.9198",
                                "monoisotopic_mz": "741.4672",
                                "intensity": "1354.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "34",
                                "monoisotopic_mass": "697.8748",
                                "monoisotopic_mz": "698.8820",
                                "intensity": "766.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "35",
                                "monoisotopic_mass": "1420.7818",
                                "monoisotopic_mz": "711.3982",
                                "intensity": "594.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "35",
                                "peak_id": "36",
                                "monoisotopic_mass": "709.9145",
                                "monoisotopic_mz": "710.9218",
                                "intensity": "889.66",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9236.2587",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
            