prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "19",
        "sequence_name": "sp|Q05598|CBIQ_SALTY",
        "sequence_description": "Cobalt transport protein CbiQ OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=cbiQ PE=1 SV=2",
        "proteoform_id": "22",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "35",
            "p_value": "0.04",
            "e_value": "2.72e-03",
            "fdr": "0.05",
            "matched_fragment_number": "4",
            "matched_peak_number": "5",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                    "ms1_ids": "648",
                    "ms1_scans": "1281",
                    "ids": "632",
                    "scans": "1282",
                    "precursor_mono_mass": "9514.0977",
                    "precursor_charge": "16",
                    "precursor_mz": "595.6384",
                    "feature_inte": "1.5043e+10"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "632",
                            "peak_id": "0",
                            "monoisotopic_mass": "1429.8161",
                            "monoisotopic_mz": "477.6126",
                            "intensity": "3095486.92",
                            "charge": "3"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "1",
                            "monoisotopic_mass": "5100.7678",
                            "monoisotopic_mz": "638.6033",
                            "intensity": "830214.39",
                            "charge": "8"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "2",
                            "monoisotopic_mass": "7985.1843",
                            "monoisotopic_mz": "666.4393",
                            "intensity": "897693.15",
                            "charge": "12",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "15.9807810719",
                                    "theoretical_mass": "7986.1890",
                                    "ion_position": "13",
                                    "ion_display_position": "67",
                                    "ion_sort_name": "Y00067",
                                    "ion_left_position": "13",
                                    "mass_error": "-0.0024",
                                    "ppm": "-0.30"
                                }
                            }
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "3",
                            "monoisotopic_mass": "4990.7263",
                            "monoisotopic_mz": "624.8481",
                            "intensity": "576300.95",
                            "charge": "8"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "4",
                            "monoisotopic_mass": "1429.8166",
                            "monoisotopic_mz": "715.9156",
                            "intensity": "832580.53",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "5",
                            "monoisotopic_mass": "8084.2542",
                            "monoisotopic_mz": "622.8730",
                            "intensity": "469007.85",
                            "charge": "13"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "6",
                            "monoisotopic_mass": "7968.1869",
                            "monoisotopic_mz": "665.0229",
                            "intensity": "450006.81",
                            "charge": "12"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "7",
                            "monoisotopic_mass": "2980.5591",
                            "monoisotopic_mz": "746.1470",
                            "intensity": "405683.78",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "8",
                            "monoisotopic_mass": "3461.8436",
                            "monoisotopic_mz": "693.3760",
                            "intensity": "477729.11",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "9",
                            "monoisotopic_mass": "7986.1887",
                            "monoisotopic_mz": "727.0244",
                            "intensity": "393441.59",
                            "charge": "11",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "15.9807810719",
                                    "theoretical_mass": "7986.1890",
                                    "ion_position": "13",
                                    "ion_display_position": "67",
                                    "ion_sort_name": "Y00067",
                                    "ion_left_position": "13",
                                    "mass_error": "-0.0003",
                                    "ppm": "-0.04"
                                }
                            }
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "10",
                            "monoisotopic_mass": "5118.7815",
                            "monoisotopic_mz": "640.8550",
                            "intensity": "482277.50",
                            "charge": "8"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "11",
                            "monoisotopic_mass": "6403.4274",
                            "monoisotopic_mz": "641.3500",
                            "intensity": "735591.33",
                            "charge": "10"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "12",
                            "monoisotopic_mass": "3571.8709",
                            "monoisotopic_mz": "715.3815",
                            "intensity": "512250.44",
                            "charge": "5",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3571.8684",
                                    "ion_position": "50",
                                    "ion_display_position": "30",
                                    "ion_sort_name": "Y00030",
                                    "ion_left_position": "50",
                                    "mass_error": "0.0025",
                                    "ppm": "0.71"
                                }
                            }
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "13",
                            "monoisotopic_mass": "6261.3449",
                            "monoisotopic_mz": "696.7123",
                            "intensity": "333673.34",
                            "charge": "9"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "14",
                            "monoisotopic_mass": "4778.5791",
                            "monoisotopic_mz": "683.6614",
                            "intensity": "419759.07",
                            "charge": "7"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "15",
                            "monoisotopic_mass": "4618.3881",
                            "monoisotopic_mz": "770.7386",
                            "intensity": "324722.72",
                            "charge": "6"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "16",
                            "monoisotopic_mass": "3589.9015",
                            "monoisotopic_mz": "718.9876",
                            "intensity": "276324.94",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "17",
                            "monoisotopic_mass": "1429.8170",
                            "monoisotopic_mz": "358.4615",
                            "intensity": "348988.64",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "18",
                            "monoisotopic_mass": "3253.7290",
                            "monoisotopic_mz": "814.4395",
                            "intensity": "258484.55",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "19",
                            "monoisotopic_mass": "4874.5438",
                            "monoisotopic_mz": "813.4312",
                            "intensity": "321652.99",
                            "charge": "6",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "4874.5438",
                                    "ion_position": "38",
                                    "ion_display_position": "42",
                                    "ion_sort_name": "Y00042",
                                    "ion_left_position": "38",
                                    "mass_error": "-0.0000",
                                    "ppm": "-0.01"
                                }
                            }
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "20",
                            "monoisotopic_mass": "6148.2666",
                            "monoisotopic_mz": "684.1480",
                            "intensity": "356975.08",
                            "charge": "9"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "21",
                            "monoisotopic_mass": "6333.3938",
                            "monoisotopic_mz": "634.3467",
                            "intensity": "225723.76",
                            "charge": "10"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "22",
                            "monoisotopic_mass": "2998.5725",
                            "monoisotopic_mz": "750.6504",
                            "intensity": "263860.43",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "23",
                            "monoisotopic_mass": "3671.9498",
                            "monoisotopic_mz": "735.3972",
                            "intensity": "269449.71",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "24",
                            "monoisotopic_mass": "3093.6433",
                            "monoisotopic_mz": "619.7359",
                            "intensity": "185289.38",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "25",
                            "monoisotopic_mass": "2962.5464",
                            "monoisotopic_mz": "741.6439",
                            "intensity": "200787.07",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "26",
                            "monoisotopic_mass": "1261.7275",
                            "monoisotopic_mz": "631.8710",
                            "intensity": "292972.66",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "27",
                            "monoisotopic_mass": "3111.6560",
                            "monoisotopic_mz": "778.9213",
                            "intensity": "151216.27",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "28",
                            "monoisotopic_mass": "7949.1696",
                            "monoisotopic_mz": "663.4381",
                            "intensity": "189476.25",
                            "charge": "12"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "29",
                            "monoisotopic_mass": "3348.7605",
                            "monoisotopic_mz": "670.7594",
                            "intensity": "338353.84",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "30",
                            "monoisotopic_mass": "4731.4700",
                            "monoisotopic_mz": "789.5856",
                            "intensity": "228150.58",
                            "charge": "6"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "31",
                            "monoisotopic_mass": "3249.6913",
                            "monoisotopic_mz": "650.9455",
                            "intensity": "311951.08",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "32",
                            "monoisotopic_mass": "3182.6933",
                            "monoisotopic_mz": "796.6806",
                            "intensity": "152414.65",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "33",
                            "monoisotopic_mass": "3182.6796",
                            "monoisotopic_mz": "637.5432",
                            "intensity": "226525.32",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "34",
                            "monoisotopic_mass": "3217.7109",
                            "monoisotopic_mz": "805.4350",
                            "intensity": "153846.62",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "35",
                            "monoisotopic_mass": "4989.6992",
                            "monoisotopic_mz": "555.4183",
                            "intensity": "299372.74",
                            "charge": "9"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "36",
                            "monoisotopic_mass": "7852.1181",
                            "monoisotopic_mz": "714.8362",
                            "intensity": "181113.56",
                            "charge": "11"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "37",
                            "monoisotopic_mass": "6260.3534",
                            "monoisotopic_mz": "627.0426",
                            "intensity": "161366.26",
                            "charge": "10"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "38",
                            "monoisotopic_mass": "1332.7658",
                            "monoisotopic_mz": "667.3902",
                            "intensity": "156426.10",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "39",
                            "monoisotopic_mass": "4990.7276",
                            "monoisotopic_mz": "713.9684",
                            "intensity": "163056.59",
                            "charge": "7"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "40",
                            "monoisotopic_mass": "4873.5516",
                            "monoisotopic_mz": "697.2289",
                            "intensity": "173746.86",
                            "charge": "7"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "41",
                            "monoisotopic_mass": "8085.2723",
                            "monoisotopic_mz": "674.7800",
                            "intensity": "168403.38",
                            "charge": "12"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "42",
                            "monoisotopic_mass": "4225.1851",
                            "monoisotopic_mz": "846.0443",
                            "intensity": "97094.39",
                            "charge": "5"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "43",
                            "monoisotopic_mass": "3670.9626",
                            "monoisotopic_mz": "612.8344",
                            "intensity": "96746.35",
                            "charge": "6"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "44",
                            "monoisotopic_mass": "4803.5037",
                            "monoisotopic_mz": "801.5912",
                            "intensity": "152482.55",
                            "charge": "6"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "45",
                            "monoisotopic_mass": "2377.9708",
                            "monoisotopic_mz": "199.1715",
                            "intensity": "59604.69",
                            "charge": "12"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "46",
                            "monoisotopic_mass": "3235.7261",
                            "monoisotopic_mz": "809.9388",
                            "intensity": "91180.12",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "47",
                            "monoisotopic_mass": "650.3412",
                            "monoisotopic_mz": "651.3485",
                            "intensity": "44536.86",
                            "charge": "1"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "48",
                            "monoisotopic_mass": "3366.8140",
                            "monoisotopic_mz": "842.7108",
                            "intensity": "95829.09",
                            "charge": "4"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "49",
                            "monoisotopic_mass": "1114.6595",
                            "monoisotopic_mz": "558.3370",
                            "intensity": "77035.21",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "50",
                            "monoisotopic_mass": "1190.9657",
                            "monoisotopic_mz": "596.4901",
                            "intensity": "62039.39",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "51",
                            "monoisotopic_mass": "3966.5835",
                            "monoisotopic_mz": "662.1045",
                            "intensity": "88464.35",
                            "charge": "6"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "52",
                            "monoisotopic_mass": "1981.4094",
                            "monoisotopic_mz": "199.1482",
                            "intensity": "60928.75",
                            "charge": "10"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "53",
                            "monoisotopic_mass": "2148.6296",
                            "monoisotopic_mz": "717.2171",
                            "intensity": "69301.17",
                            "charge": "3"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "54",
                            "monoisotopic_mass": "1015.5917",
                            "monoisotopic_mz": "508.8031",
                            "intensity": "66853.31",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "55",
                            "monoisotopic_mass": "1411.8064",
                            "monoisotopic_mz": "471.6094",
                            "intensity": "62008.97",
                            "charge": "3"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "56",
                            "monoisotopic_mass": "1490.2857",
                            "monoisotopic_mz": "497.7692",
                            "intensity": "45735.55",
                            "charge": "3"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "57",
                            "monoisotopic_mass": "1303.4986",
                            "monoisotopic_mz": "652.7566",
                            "intensity": "54935.04",
                            "charge": "2"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "58",
                            "monoisotopic_mass": "3330.7072",
                            "monoisotopic_mz": "667.1487",
                            "intensity": "113953.54",
                            "charge": "5",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3330.7257",
                                    "ion_position": "53",
                                    "ion_display_position": "27",
                                    "ion_sort_name": "Y00027",
                                    "ion_left_position": "53",
                                    "mass_error": "-0.0186",
                                    "ppm": "-5.58"
                                }
                            }
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "59",
                            "monoisotopic_mass": "1784.2675",
                            "monoisotopic_mz": "199.2592",
                            "intensity": "84567.44",
                            "charge": "9"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "60",
                            "monoisotopic_mass": "664.2675",
                            "monoisotopic_mz": "665.2747",
                            "intensity": "57583.21",
                            "charge": "1"
                        },
                        {
                            "spec_id": "632",
                            "peak_id": "61",
                            "monoisotopic_mass": "1347.5287",
                            "monoisotopic_mz": "674.7716",
                            "intensity": "52807.28",
                            "charge": "2"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "19",
                "proteoform_id": "22",
                "sequence_name": "sp|Q05598|CBIQ_SALTY",
                "sequence_description": "Cobalt transport protein CbiQ OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=cbiQ PE=1 SV=2",
                "proteoform_mass": "9514.1026",
                "n_acetylation": "0",
                "unexpected_shift_number": "0",
                "annotation": {
                    "protein_length": "225",
                    "first_residue_position": "145",
                    "last_residue_position": "224",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "T"
                        },
                        {
                            "position": "2",
                            "acid": "G"
                        },
                        {
                            "position": "3",
                            "acid": "L"
                        },
                        {
                            "position": "4",
                            "acid": "D"
                        },
                        {
                            "position": "5",
                            "acid": "R"
                        },
                        {
                            "position": "6",
                            "acid": "L"
                        },
                        {
                            "position": "7",
                            "acid": "S"
                        },
                        {
                            "position": "8",
                            "acid": "Y"
                        },
                        {
                            "position": "9",
                            "acid": "Q"
                        },
                        {
                            "position": "10",
                            "acid": "S"
                        },
                        {
                            "position": "11",
                            "acid": "R"
                        },
                        {
                            "position": "12",
                            "acid": "W"
                        },
                        {
                            "position": "13",
                            "acid": "A"
                        },
                        {
                            "position": "14",
                            "acid": "H"
                        },
                        {
                            "position": "15",
                            "acid": "V"
                        },
                        {
                            "position": "16",
                            "acid": "A"
                        },
                        {
                            "position": "17",
                            "acid": "P"
                        },
                        {
                            "position": "18",
                            "acid": "Q"
                        },
                        {
                            "position": "19",
                            "acid": "R"
                        },
                        {
                            "position": "20",
                            "acid": "K"
                        },
                        {
                            "position": "21",
                            "acid": "F"
                        },
                        {
                            "position": "22",
                            "acid": "L"
                        },
                        {
                            "position": "23",
                            "acid": "L"
                        },
                        {
                            "position": "24",
                            "acid": "W"
                        },
                        {
                            "position": "25",
                            "acid": "L"
                        },
                        {
                            "position": "26",
                            "acid": "A"
                        },
                        {
                            "position": "27",
                            "acid": "M"
                        },
                        {
                            "position": "28",
                            "acid": "M"
                        },
                        {
                            "position": "29",
                            "acid": "I"
                        },
                        {
                            "position": "30",
                            "acid": "L"
                        },
                        {
                            "position": "31",
                            "acid": "A"
                        },
                        {
                            "position": "32",
                            "acid": "F"
                        },
                        {
                            "position": "33",
                            "acid": "V"
                        },
                        {
                            "position": "34",
                            "acid": "L"
                        },
                        {
                            "position": "35",
                            "acid": "P"
                        },
                        {
                            "position": "36",
                            "acid": "P"
                        },
                        {
                            "position": "37",
                            "acid": "V"
                        },
                        {
                            "position": "38",
                            "acid": "G"
                        },
                        {
                            "position": "39",
                            "acid": "Q"
                        },
                        {
                            "position": "40",
                            "acid": "G"
                        },
                        {
                            "position": "41",
                            "acid": "I"
                        },
                        {
                            "position": "42",
                            "acid": "E"
                        },
                        {
                            "position": "43",
                            "acid": "L"
                        },
                        {
                            "position": "44",
                            "acid": "L"
                        },
                        {
                            "position": "45",
                            "acid": "I"
                        },
                        {
                            "position": "46",
                            "acid": "I"
                        },
                        {
                            "position": "47",
                            "acid": "A"
                        },
                        {
                            "position": "48",
                            "acid": "G"
                        },
                        {
                            "position": "49",
                            "acid": "L"
                        },
                        {
                            "position": "50",
                            "acid": "S"
                        },
                        {
                            "position": "51",
                            "acid": "C"
                        },
                        {
                            "position": "52",
                            "acid": "W"
                        },
                        {
                            "position": "53",
                            "acid": "L"
                        },
                        {
                            "position": "54",
                            "acid": "L"
                        },
                        {
                            "position": "55",
                            "acid": "R"
                        },
                        {
                            "position": "56",
                            "acid": "I"
                        },
                        {
                            "position": "57",
                            "acid": "S"
                        },
                        {
                            "position": "58",
                            "acid": "L"
                        },
                        {
                            "position": "59",
                            "acid": "W"
                        },
                        {
                            "position": "60",
                            "acid": "R"
                        },
                        {
                            "position": "61",
                            "acid": "W"
                        },
                        {
                            "position": "62",
                            "acid": "C"
                        },
                        {
                            "position": "63",
                            "acid": "R"
                        },
                        {
                            "position": "64",
                            "acid": "W"
                        },
                        {
                            "position": "65",
                            "acid": "M"
                        },
                        {
                            "position": "66",
                            "acid": "A"
                        },
                        {
                            "position": "67",
                            "acid": "I"
                        },
                        {
                            "position": "68",
                            "acid": "P"
                        },
                        {
                            "position": "69",
                            "acid": "F"
                        },
                        {
                            "position": "70",
                            "acid": "G"
                        },
                        {
                            "position": "71",
                            "acid": "F"
                        },
                        {
                            "position": "72",
                            "acid": "L"
                        },
                        {
                            "position": "73",
                            "acid": "L"
                        },
                        {
                            "position": "74",
                            "acid": "V"
                        },
                        {
                            "position": "75",
                            "acid": "G"
                        },
                        {
                            "position": "76",
                            "acid": "V"
                        },
                        {
                            "position": "77",
                            "acid": "I"
                        },
                        {
                            "position": "78",
                            "acid": "T"
                        },
                        {
                            "position": "79",
                            "acid": "I"
                        },
                        {
                            "position": "80",
                            "acid": "I"
                        },
                        {
                            "position": "81",
                            "acid": "F"
                        },
                        {
                            "position": "82",
                            "acid": "S"
                        },
                        {
                            "position": "83",
                            "acid": "I"
                        },
                        {
                            "position": "84",
                            "acid": "S"
                        },
                        {
                            "position": "85",
                            "acid": "R"
                        },
                        {
                            "position": "86",
                            "acid": "E"
                        },
                        {
                            "position": "87",
                            "acid": "P"
                        },
                        {
                            "position": "88",
                            "acid": "Q"
                        },
                        {
                            "position": "89",
                            "acid": "M"
                        },
                        {
                            "position": "90",
                            "acid": "L"
                        },
                        {
                            "position": "91",
                            "acid": "L"
                        },
                        {
                            "position": "92",
                            "acid": "A"
                        },
                        {
                            "position": "93",
                            "acid": "G"
                        },
                        {
                            "position": "94",
                            "acid": "I"
                        },
                        {
                            "position": "95",
                            "acid": "S"
                        },
                        {
                            "position": "96",
                            "acid": "V"
                        },
                        {
                            "position": "97",
                            "acid": "G"
                        },
                        {
                            "position": "98",
                            "acid": "P"
                        },
                        {
                            "position": "99",
                            "acid": "Y"
                        },
                        {
                            "position": "100",
                            "acid": "W"
                        },
                        {
                            "position": "101",
                            "acid": "I"
                        },
                        {
                            "position": "102",
                            "acid": "G"
                        },
                        {
                            "position": "103",
                            "acid": "I"
                        },
                        {
                            "position": "104",
                            "acid": "T"
                        },
                        {
                            "position": "105",
                            "acid": "R"
                        },
                        {
                            "position": "106",
                            "acid": "A"
                        },
                        {
                            "position": "107",
                            "acid": "G"
                        },
                        {
                            "position": "108",
                            "acid": "V"
                        },
                        {
                            "position": "109",
                            "acid": "V"
                        },
                        {
                            "position": "110",
                            "acid": "T"
                        },
                        {
                            "position": "111",
                            "acid": "A"
                        },
                        {
                            "position": "112",
                            "acid": "N"
                        },
                        {
                            "position": "113",
                            "acid": "E"
                        },
                        {
                            "position": "114",
                            "acid": "T"
                        },
                        {
                            "position": "115",
                            "acid": "F"
                        },
                        {
                            "position": "116",
                            "acid": "W"
                        },
                        {
                            "position": "117",
                            "acid": "R"
                        },
                        {
                            "position": "118",
                            "acid": "S"
                        },
                        {
                            "position": "119",
                            "acid": "L"
                        },
                        {
                            "position": "120",
                            "acid": "T"
                        },
                        {
                            "position": "121",
                            "acid": "A"
                        },
                        {
                            "position": "122",
                            "acid": "L"
                        },
                        {
                            "position": "123",
                            "acid": "S"
                        },
                        {
                            "position": "124",
                            "acid": "A"
                        },
                        {
                            "position": "125",
                            "acid": "T"
                        },
                        {
                            "position": "126",
                            "acid": "L"
                        },
                        {
                            "position": "127",
                            "acid": "W"
                        },
                        {
                            "position": "128",
                            "acid": "L"
                        },
                        {
                            "position": "129",
                            "acid": "V"
                        },
                        {
                            "position": "130",
                            "acid": "M"
                        },
                        {
                            "position": "131",
                            "acid": "N"
                        },
                        {
                            "position": "132",
                            "acid": "L"
                        },
                        {
                            "position": "133",
                            "acid": "P"
                        },
                        {
                            "position": "134",
                            "acid": "F"
                        },
                        {
                            "position": "135",
                            "acid": "P"
                        },
                        {
                            "position": "136",
                            "acid": "Q"
                        },
                        {
                            "position": "137",
                            "acid": "L"
                        },
                        {
                            "position": "138",
                            "acid": "I"
                        },
                        {
                            "position": "139",
                            "acid": "S"
                        },
                        {
                            "position": "140",
                            "acid": "L"
                        },
                        {
                            "position": "141",
                            "acid": "L"
                        },
                        {
                            "position": "142",
                            "acid": "K"
                        },
                        {
                            "position": "143",
                            "acid": "R"
                        },
                        {
                            "position": "144",
                            "acid": "A"
                        },
                        {
                            "position": "145",
                            "acid": "H"
                        },
                        {
                            "position": "146",
                            "acid": "I"
                        },
                        {
                            "position": "147",
                            "acid": "P"
                        },
                        {
                            "position": "148",
                            "acid": "R"
                        },
                        {
                            "position": "149",
                            "acid": "L"
                        },
                        {
                            "position": "150",
                            "acid": "L"
                        },
                        {
                            "position": "151",
                            "acid": "T"
                        },
                        {
                            "position": "152",
                            "acid": "E"
                        },
                        {
                            "position": "153",
                            "acid": "Q"
                        },
                        {
                            "position": "154",
                            "acid": "I"
                        },
                        {
                            "position": "155",
                            "acid": "L"
                        },
                        {
                            "position": "156",
                            "acid": "L"
                        },
                        {
                            "position": "157",
                            "acid": "T"
                        },
                        {
                            "position": "158",
                            "acid": "W"
                        },
                        {
                            "position": "159",
                            "acid": "R"
                        },
                        {
                            "position": "160",
                            "acid": "F"
                        },
                        {
                            "position": "161",
                            "acid": "L"
                        },
                        {
                            "position": "162",
                            "acid": "F"
                        },
                        {
                            "position": "163",
                            "acid": "I"
                        },
                        {
                            "position": "164",
                            "acid": "L"
                        },
                        {
                            "position": "165",
                            "acid": "L"
                        },
                        {
                            "position": "166",
                            "acid": "D"
                        },
                        {
                            "position": "167",
                            "acid": "E"
                        },
                        {
                            "position": "168",
                            "acid": "A"
                        },
                        {
                            "position": "169",
                            "acid": "V"
                        },
                        {
                            "position": "170",
                            "acid": "A"
                        },
                        {
                            "position": "171",
                            "acid": "I"
                        },
                        {
                            "position": "172",
                            "acid": "R"
                        },
                        {
                            "position": "173",
                            "acid": "R"
                        },
                        {
                            "position": "174",
                            "acid": "A"
                        },
                        {
                            "position": "175",
                            "acid": "Q"
                        },
                        {
                            "position": "176",
                            "acid": "T"
                        },
                        {
                            "position": "177",
                            "acid": "L"
                        },
                        {
                            "position": "178",
                            "acid": "R"
                        },
                        {
                            "position": "179",
                            "acid": "F"
                        },
                        {
                            "position": "180",
                            "acid": "G"
                        },
                        {
                            "position": "181",
                            "acid": "Y"
                        },
                        {
                            "position": "182",
                            "acid": "C"
                        },
                        {
                            "position": "183",
                            "acid": "S"
                        },
                        {
                            "position": "184",
                            "acid": "L"
                        },
                        {
                            "position": "185",
                            "acid": "P"
                        },
                        {
                            "position": "186",
                            "acid": "N"
                        },
                        {
                            "position": "187",
                            "acid": "G"
                        },
                        {
                            "position": "188",
                            "acid": "Y"
                        },
                        {
                            "position": "189",
                            "acid": "R"
                        },
                        {
                            "position": "190",
                            "acid": "S"
                        },
                        {
                            "position": "191",
                            "acid": "L"
                        },
                        {
                            "position": "192",
                            "acid": "A"
                        },
                        {
                            "position": "193",
                            "acid": "M"
                        },
                        {
                            "position": "194",
                            "acid": "L"
                        },
                        {
                            "position": "195",
                            "acid": "A"
                        },
                        {
                            "position": "196",
                            "acid": "G"
                        },
                        {
                            "position": "197",
                            "acid": "L"
                        },
                        {
                            "position": "198",
                            "acid": "L"
                        },
                        {
                            "position": "199",
                            "acid": "F"
                        },
                        {
                            "position": "200",
                            "acid": "T"
                        },
                        {
                            "position": "201",
                            "acid": "R"
                        },
                        {
                            "position": "202",
                            "acid": "V"
                        },
                        {
                            "position": "203",
                            "acid": "L"
                        },
                        {
                            "position": "204",
                            "acid": "M"
                        },
                        {
                            "position": "205",
                            "acid": "R"
                        },
                        {
                            "position": "206",
                            "acid": "Y"
                        },
                        {
                            "position": "207",
                            "acid": "Q"
                        },
                        {
                            "position": "208",
                            "acid": "Q"
                        },
                        {
                            "position": "209",
                            "acid": "M"
                        },
                        {
                            "position": "210",
                            "acid": "T"
                        },
                        {
                            "position": "211",
                            "acid": "T"
                        },
                        {
                            "position": "212",
                            "acid": "T"
                        },
                        {
                            "position": "213",
                            "acid": "L"
                        },
                        {
                            "position": "214",
                            "acid": "D"
                        },
                        {
                            "position": "215",
                            "acid": "I"
                        },
                        {
                            "position": "216",
                            "acid": "K"
                        },
                        {
                            "position": "217",
                            "acid": "L"
                        },
                        {
                            "position": "218",
                            "acid": "Y"
                        },
                        {
                            "position": "219",
                            "acid": "Q"
                        },
                        {
                            "position": "220",
                            "acid": "G"
                        },
                        {
                            "position": "221",
                            "acid": "D"
                        },
                        {
                            "position": "222",
                            "acid": "F"
                        },
                        {
                            "position": "223",
                            "acid": "H"
                        },
                        {
                            "position": "224",
                            "acid": "L"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "140",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "141",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "142",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "143",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "144",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "145",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "146",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "147",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "148",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "149",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "150",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "151",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "152",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "153",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "154",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "155",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "156",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "157",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "158",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "67",
                                        "spec_id": "632",
                                        "peak_id": "2",
                                        "peak_charge": "12"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "67",
                                        "spec_id": "632",
                                        "peak_id": "9",
                                        "peak_charge": "11"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "159",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "160",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "161",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "162",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "163",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "164",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "165",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "166",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "167",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "168",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "169",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "170",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "171",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "172",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "173",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "174",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "175",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "176",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "177",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "178",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "179",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "180",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "181",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "182",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "183",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "38",
                                    "ion_display_position": "42",
                                    "spec_id": "632",
                                    "peak_id": "19",
                                    "peak_charge": "6"
                                }
                            }
                        },
                        {
                            "position": "184",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "185",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "186",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "187",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "188",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "189",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "190",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "191",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "192",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "193",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "194",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "195",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "50",
                                    "ion_display_position": "30",
                                    "spec_id": "632",
                                    "peak_id": "12",
                                    "peak_charge": "5"
                                }
                            }
                        },
                        {
                            "position": "196",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "197",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "198",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "53",
                                    "ion_display_position": "27",
                                    "spec_id": "632",
                                    "peak_id": "58",
                                    "peak_charge": "5"
                                }
                            }
                        },
                        {
                            "position": "199",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "200",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "201",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "202",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "203",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "204",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "205",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "206",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "207",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "208",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "209",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "210",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "211",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "212",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "213",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "214",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "215",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "216",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "217",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "218",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "219",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "220",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "221",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "222",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "223",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "224",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "225",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": [
                        {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "182",
                                "right_pos": "183",
                                "anno": "C"
                            }
                        },
                        {
                            "ptm_type": "Variable",
                            "ptm": {
                                "abbreviation": "Oxidation",
                                "unimod": "35",
                                "mono_mass": "15.9949150000"
                            },
                            "occurence": {
                                "left_pos": "158",
                                "right_pos": "183",
                                "anno": null
                            }
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "158",
                        "right_position": "183",
                        "anno": "Oxidation",
                        "shift_type": "variable ptm"
                    }
                }
            }
        }
    }
}
