prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "5",
        "sequence_name": "sp|P68684|RS21_SALTY",
        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
        "proteoform_id": "5",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "19",
                "p_value": "2.07e-07",
                "e_value": "2.07e-09",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "389",
                        "ms1_scans": "763",
                        "ids": "373",
                        "scans": "764",
                        "precursor_mono_mass": "8420.7175",
                        "precursor_charge": "15",
                        "precursor_mz": "562.3884",
                        "feature_inte": "4.6235e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "373",
                                "peak_id": "0",
                                "monoisotopic_mass": "7356.0425",
                                "monoisotopic_mz": "614.0108",
                                "intensity": "128517.37",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1097",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0672",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "1",
                                "monoisotopic_mass": "6995.8925",
                                "monoisotopic_mz": "583.9983",
                                "intensity": "77396.21",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0667",
                                        "ppm": "-9.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "2",
                                "monoisotopic_mass": "4340.3903",
                                "monoisotopic_mz": "621.0630",
                                "intensity": "50869.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "3",
                                "monoisotopic_mass": "7339.0141",
                                "monoisotopic_mz": "612.5918",
                                "intensity": "33788.05",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "4",
                                "monoisotopic_mass": "7313.0407",
                                "monoisotopic_mz": "610.4273",
                                "intensity": "19955.26",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "5",
                                "monoisotopic_mass": "4358.3902",
                                "monoisotopic_mz": "623.6344",
                                "intensity": "16176.06",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0523",
                                        "ppm": "-12.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "6",
                                "monoisotopic_mass": "4062.2267",
                                "monoisotopic_mz": "508.7856",
                                "intensity": "24326.37",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4062.2650",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0383",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "7",
                                "monoisotopic_mass": "7259.9965",
                                "monoisotopic_mz": "606.0070",
                                "intensity": "25966.66",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0628",
                                        "ppm": "-8.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "8",
                                "monoisotopic_mass": "4925.7785",
                                "monoisotopic_mz": "616.7296",
                                "intensity": "16838.18",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0357",
                                        "ppm": "-7.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "9",
                                "monoisotopic_mass": "1423.7319",
                                "monoisotopic_mz": "712.8732",
                                "intensity": "17087.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0141",
                                        "ppm": "-9.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "10",
                                "monoisotopic_mass": "2638.4984",
                                "monoisotopic_mz": "440.7570",
                                "intensity": "13445.71",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "11",
                                "monoisotopic_mass": "2638.4915",
                                "monoisotopic_mz": "528.7056",
                                "intensity": "13469.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "12",
                                "monoisotopic_mass": "4295.3662",
                                "monoisotopic_mz": "614.6310",
                                "intensity": "10053.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "13",
                                "monoisotopic_mass": "4340.3966",
                                "monoisotopic_mz": "724.4067",
                                "intensity": "13785.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "14",
                                "monoisotopic_mass": "726.5666",
                                "monoisotopic_mz": "727.5739",
                                "intensity": "6625.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "15",
                                "monoisotopic_mass": "1981.3372",
                                "monoisotopic_mz": "199.1410",
                                "intensity": "21630.96",
                                "charge": "10"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "16",
                                "monoisotopic_mass": "3490.4438",
                                "monoisotopic_mz": "582.7479",
                                "intensity": "10222.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "17",
                                "monoisotopic_mass": "1498.8194",
                                "monoisotopic_mz": "500.6137",
                                "intensity": "5991.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "18",
                                "monoisotopic_mass": "1064.5896",
                                "monoisotopic_mz": "355.8705",
                                "intensity": "6236.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0082",
                                        "ppm": "-7.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "19",
                                "monoisotopic_mass": "2377.8834",
                                "monoisotopic_mz": "199.1642",
                                "intensity": "12675.92",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "20",
                                "monoisotopic_mass": "7703.7572",
                                "monoisotopic_mz": "593.6040",
                                "intensity": "20604.82",
                                "charge": "13"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "21",
                                "monoisotopic_mass": "2575.9163",
                                "monoisotopic_mz": "199.1547",
                                "intensity": "12561.83",
                                "charge": "13"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "22",
                                "monoisotopic_mass": "791.2460",
                                "monoisotopic_mz": "198.8188",
                                "intensity": "6082.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "23",
                                "monoisotopic_mass": "1454.1360",
                                "monoisotopic_mz": "728.0753",
                                "intensity": "3341.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "24",
                                "monoisotopic_mass": "1206.3592",
                                "monoisotopic_mz": "604.1869",
                                "intensity": "5772.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "25",
                                "monoisotopic_mass": "1220.9417",
                                "monoisotopic_mz": "611.4782",
                                "intensity": "4129.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "26",
                                "monoisotopic_mass": "2460.3670",
                                "monoisotopic_mz": "616.0990",
                                "intensity": "5000.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "27",
                                "monoisotopic_mass": "1423.7320",
                                "monoisotopic_mz": "475.5846",
                                "intensity": "4743.56",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0140",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "28",
                                "monoisotopic_mass": "1161.6416",
                                "monoisotopic_mz": "581.8281",
                                "intensity": "4004.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0090",
                                        "ppm": "-7.75"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "373",
                                            "peak_id": "18",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "373",
                                            "peak_id": "0",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "373",
                                            "peak_id": "28",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "373",
                                            "peak_id": "7",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "373",
                                            "peak_id": "9",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "373",
                                            "peak_id": "27",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "373",
                                            "peak_id": "1",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "373",
                                        "peak_id": "8",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "373",
                                            "peak_id": "6",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "373",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "17",
                "p_value": "1.02e-06",
                "e_value": "1.02e-08",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "357",
                        "ms1_scans": "699",
                        "ids": "341",
                        "scans": "700",
                        "precursor_mono_mass": "8420.6789",
                        "precursor_charge": "16",
                        "precursor_mz": "527.2997",
                        "feature_inte": "4.6235e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "341",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.9072",
                                "monoisotopic_mz": "539.2309",
                                "intensity": "41316.07",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0543",
                                        "ppm": "-7.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "1",
                                "monoisotopic_mass": "7356.0451",
                                "monoisotopic_mz": "566.8569",
                                "intensity": "76628.32",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1097",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0646",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "2",
                                "monoisotopic_mass": "4924.7661",
                                "monoisotopic_mz": "548.2035",
                                "intensity": "21009.06",
                                "charge": "9"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "3",
                                "monoisotopic_mass": "4925.7621",
                                "monoisotopic_mz": "493.5835",
                                "intensity": "32443.19",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0522",
                                        "ppm": "-10.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "4",
                                "monoisotopic_mass": "4340.3843",
                                "monoisotopic_mz": "621.0622",
                                "intensity": "16068.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "5",
                                "monoisotopic_mass": "4340.3912",
                                "monoisotopic_mz": "543.5562",
                                "intensity": "16820.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "6",
                                "monoisotopic_mass": "2637.4966",
                                "monoisotopic_mz": "440.5900",
                                "intensity": "6955.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "7",
                                "monoisotopic_mass": "6979.8671",
                                "monoisotopic_mz": "537.9201",
                                "intensity": "6937.26",
                                "charge": "13"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "8",
                                "monoisotopic_mass": "7312.0024",
                                "monoisotopic_mz": "563.4690",
                                "intensity": "7791.29",
                                "charge": "13"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "9",
                                "monoisotopic_mass": "1064.5903",
                                "monoisotopic_mz": "355.8707",
                                "intensity": "4425.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0076",
                                        "ppm": "-7.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "10",
                                "monoisotopic_mass": "4907.7554",
                                "monoisotopic_mz": "491.7828",
                                "intensity": "2936.59",
                                "charge": "10"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "11",
                                "monoisotopic_mass": "4881.7542",
                                "monoisotopic_mz": "543.4244",
                                "intensity": "2799.16",
                                "charge": "9"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "12",
                                "monoisotopic_mass": "2638.4972",
                                "monoisotopic_mz": "528.7067",
                                "intensity": "2197.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "13",
                                "monoisotopic_mass": "1199.4950",
                                "monoisotopic_mz": "600.7548",
                                "intensity": "2474.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "14",
                                "monoisotopic_mass": "564.8484",
                                "monoisotopic_mz": "565.8557",
                                "intensity": "3095.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "15",
                                "monoisotopic_mass": "2753.5140",
                                "monoisotopic_mz": "551.7101",
                                "intensity": "2156.43",
                                "charge": "5"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "16",
                                "monoisotopic_mass": "7111.8861",
                                "monoisotopic_mz": "593.6645",
                                "intensity": "5738.84",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7111.9885",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.1023",
                                        "ppm": "-14.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "17",
                                "monoisotopic_mass": "1423.7342",
                                "monoisotopic_mz": "475.5854",
                                "intensity": "7901.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0117",
                                        "ppm": "-8.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "18",
                                "monoisotopic_mass": "1166.8188",
                                "monoisotopic_mz": "584.4167",
                                "intensity": "1816.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "19",
                                "monoisotopic_mass": "2179.4881",
                                "monoisotopic_mz": "199.1426",
                                "intensity": "1795.19",
                                "charge": "11"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "20",
                                "monoisotopic_mass": "4322.3631",
                                "monoisotopic_mz": "618.4877",
                                "intensity": "2097.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "21",
                                "monoisotopic_mass": "1238.7027",
                                "monoisotopic_mz": "620.3586",
                                "intensity": "2700.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "22",
                                "monoisotopic_mass": "1423.7325",
                                "monoisotopic_mz": "712.8735",
                                "intensity": "3420.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0134",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "23",
                                "monoisotopic_mass": "1064.5853",
                                "monoisotopic_mz": "533.2999",
                                "intensity": "1411.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0125",
                                        "ppm": "-11.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "24",
                                "monoisotopic_mass": "4361.2239",
                                "monoisotopic_mz": "546.1603",
                                "intensity": "4104.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "25",
                                "monoisotopic_mass": "1036.5954",
                                "monoisotopic_mz": "346.5391",
                                "intensity": "4590.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "26",
                                "monoisotopic_mass": "6135.1742",
                                "monoisotopic_mz": "614.5247",
                                "intensity": "3605.70",
                                "charge": "10"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "27",
                                "monoisotopic_mass": "1161.6407",
                                "monoisotopic_mz": "388.2209",
                                "intensity": "2240.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0099",
                                        "ppm": "-8.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "28",
                                "monoisotopic_mass": "5455.5094",
                                "monoisotopic_mz": "546.5582",
                                "intensity": "3035.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "29",
                                "monoisotopic_mass": "1298.2344",
                                "monoisotopic_mz": "433.7521",
                                "intensity": "1857.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "30",
                                "monoisotopic_mass": "2377.7996",
                                "monoisotopic_mz": "199.1572",
                                "intensity": "5735.87",
                                "charge": "12"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "31",
                                "monoisotopic_mass": "1784.1013",
                                "monoisotopic_mz": "199.2408",
                                "intensity": "4117.54",
                                "charge": "9"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "32",
                                "monoisotopic_mass": "1263.6724",
                                "monoisotopic_mz": "422.2314",
                                "intensity": "1442.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "341",
                                "peak_id": "33",
                                "monoisotopic_mass": "6408.9268",
                                "monoisotopic_mz": "583.6370",
                                "intensity": "4229.10",
                                "charge": "11"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "341",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "341",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "341",
                                            "peak_id": "1",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "341",
                                        "peak_id": "27",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "spec_id": "341",
                                        "peak_id": "16",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "341",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "341",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "341",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "341",
                                        "peak_id": "3",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "16",
                "p_value": "1.02e-06",
                "e_value": "1.02e-08",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "356",
                        "ms1_scans": "697",
                        "ids": "340",
                        "scans": "698",
                        "precursor_mono_mass": "8420.6427",
                        "precursor_charge": "14",
                        "precursor_mz": "602.4818",
                        "feature_inte": "4.6235e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "340",
                                "peak_id": "0",
                                "monoisotopic_mass": "4925.7680",
                                "monoisotopic_mz": "548.3148",
                                "intensity": "44723.06",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0462",
                                        "ppm": "-9.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "1",
                                "monoisotopic_mass": "1423.7328",
                                "monoisotopic_mz": "712.8737",
                                "intensity": "32469.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0132",
                                        "ppm": "-9.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "2",
                                "monoisotopic_mass": "4340.3894",
                                "monoisotopic_mz": "621.0629",
                                "intensity": "31289.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "3",
                                "monoisotopic_mass": "2638.4950",
                                "monoisotopic_mz": "528.7063",
                                "intensity": "31735.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "4",
                                "monoisotopic_mass": "3494.8563",
                                "monoisotopic_mz": "699.9785",
                                "intensity": "22127.30",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3494.8933",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0370",
                                        "ppm": "-10.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "5",
                                "monoisotopic_mass": "4925.7678",
                                "monoisotopic_mz": "616.7283",
                                "intensity": "16839.39",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0464",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "6",
                                "monoisotopic_mass": "6996.8888",
                                "monoisotopic_mz": "637.0881",
                                "intensity": "14064.01",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0727",
                                        "ppm": "-10.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "7",
                                "monoisotopic_mass": "2071.1286",
                                "monoisotopic_mz": "691.3835",
                                "intensity": "15365.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "8",
                                "monoisotopic_mass": "4881.7483",
                                "monoisotopic_mz": "611.2258",
                                "intensity": "8422.17",
                                "charge": "8"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "9",
                                "monoisotopic_mass": "4340.3852",
                                "monoisotopic_mz": "724.4048",
                                "intensity": "15840.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "10",
                                "monoisotopic_mass": "4358.4039",
                                "monoisotopic_mz": "727.4079",
                                "intensity": "11338.86",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0386",
                                        "ppm": "-8.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "11",
                                "monoisotopic_mass": "4881.7436",
                                "monoisotopic_mz": "543.4232",
                                "intensity": "8546.06",
                                "charge": "9"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "12",
                                "monoisotopic_mass": "8224.5022",
                                "monoisotopic_mz": "633.6613",
                                "intensity": "17455.88",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8224.5863",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0841",
                                        "ppm": "-10.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "13",
                                "monoisotopic_mass": "4907.7378",
                                "monoisotopic_mz": "546.3115",
                                "intensity": "8783.90",
                                "charge": "9"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "14",
                                "monoisotopic_mass": "3866.1033",
                                "monoisotopic_mz": "645.3578",
                                "intensity": "10796.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "15",
                                "monoisotopic_mass": "4358.4000",
                                "monoisotopic_mz": "623.6359",
                                "intensity": "11255.98",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0425",
                                        "ppm": "-9.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "16",
                                "monoisotopic_mass": "7983.3327",
                                "monoisotopic_mz": "666.2850",
                                "intensity": "9136.30",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7983.4073",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0746",
                                        "ppm": "-9.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "17",
                                "monoisotopic_mass": "4296.3673",
                                "monoisotopic_mz": "614.7740",
                                "intensity": "6035.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "18",
                                "monoisotopic_mass": "2596.4739",
                                "monoisotopic_mz": "520.3020",
                                "intensity": "5992.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "19",
                                "monoisotopic_mass": "7355.0309",
                                "monoisotopic_mz": "669.6464",
                                "intensity": "11510.58",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1097",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0764",
                                        "ppm": "-10.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "20",
                                "monoisotopic_mass": "4297.3653",
                                "monoisotopic_mz": "717.2348",
                                "intensity": "5342.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "21",
                                "monoisotopic_mass": "4907.7294",
                                "monoisotopic_mz": "614.4734",
                                "intensity": "9362.92",
                                "charge": "8"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "22",
                                "monoisotopic_mass": "8256.5620",
                                "monoisotopic_mz": "636.1274",
                                "intensity": "5879.55",
                                "charge": "13"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "23",
                                "monoisotopic_mass": "3298.7414",
                                "monoisotopic_mz": "825.6926",
                                "intensity": "5611.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "24",
                                "monoisotopic_mass": "6979.8766",
                                "monoisotopic_mz": "635.5415",
                                "intensity": "7718.75",
                                "charge": "11"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "25",
                                "monoisotopic_mass": "4323.3693",
                                "monoisotopic_mz": "618.6315",
                                "intensity": "5817.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "26",
                                "monoisotopic_mass": "4322.3537",
                                "monoisotopic_mz": "721.3996",
                                "intensity": "4331.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "27",
                                "monoisotopic_mass": "3754.0109",
                                "monoisotopic_mz": "626.6758",
                                "intensity": "3717.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "28",
                                "monoisotopic_mass": "7966.3027",
                                "monoisotopic_mz": "664.8658",
                                "intensity": "4053.73",
                                "charge": "12"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "29",
                                "monoisotopic_mass": "4056.2165",
                                "monoisotopic_mz": "677.0434",
                                "intensity": "4626.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "30",
                                "monoisotopic_mass": "6306.3638",
                                "monoisotopic_mz": "631.6437",
                                "intensity": "3993.34",
                                "charge": "10"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "31",
                                "monoisotopic_mass": "6952.8828",
                                "monoisotopic_mz": "633.0875",
                                "intensity": "7286.01",
                                "charge": "11"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "32",
                                "monoisotopic_mass": "3735.9856",
                                "monoisotopic_mz": "623.6715",
                                "intensity": "3179.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "33",
                                "monoisotopic_mass": "879.8311",
                                "monoisotopic_mz": "440.9229",
                                "intensity": "2706.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "34",
                                "monoisotopic_mass": "868.4683",
                                "monoisotopic_mz": "869.4755",
                                "intensity": "1980.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "35",
                                "monoisotopic_mass": "4082.2918",
                                "monoisotopic_mz": "681.3892",
                                "intensity": "3328.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4082.3315",
                                        "ion_position": "36",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0397",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "36",
                                "monoisotopic_mass": "567.3667",
                                "monoisotopic_mz": "284.6906",
                                "intensity": "2916.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "37",
                                "monoisotopic_mass": "1227.6128",
                                "monoisotopic_mz": "1228.6201",
                                "intensity": "1788.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "38",
                                "monoisotopic_mass": "1981.1245",
                                "monoisotopic_mz": "661.3821",
                                "intensity": "2662.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "39",
                                "monoisotopic_mass": "1981.3149",
                                "monoisotopic_mz": "199.1388",
                                "intensity": "4941.05",
                                "charge": "10"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "40",
                                "monoisotopic_mass": "3185.6663",
                                "monoisotopic_mz": "797.4239",
                                "intensity": "2048.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "41",
                                "monoisotopic_mass": "3920.2384",
                                "monoisotopic_mz": "654.3803",
                                "intensity": "1569.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "42",
                                "monoisotopic_mass": "8032.3305",
                                "monoisotopic_mz": "670.3682",
                                "intensity": "2723.77",
                                "charge": "12"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "43",
                                "monoisotopic_mass": "1064.5885",
                                "monoisotopic_mz": "533.3015",
                                "intensity": "1765.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0094",
                                        "ppm": "-8.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "44",
                                "monoisotopic_mass": "1114.5280",
                                "monoisotopic_mz": "1115.5353",
                                "intensity": "1927.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "45",
                                "monoisotopic_mass": "3849.0785",
                                "monoisotopic_mz": "642.5204",
                                "intensity": "1841.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "46",
                                "monoisotopic_mass": "2621.4685",
                                "monoisotopic_mz": "525.3010",
                                "intensity": "3403.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "47",
                                "monoisotopic_mass": "1346.7235",
                                "monoisotopic_mz": "674.3690",
                                "intensity": "1123.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "48",
                                "monoisotopic_mass": "646.3683",
                                "monoisotopic_mz": "647.3756",
                                "intensity": "1654.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "49",
                                "monoisotopic_mass": "2012.8408",
                                "monoisotopic_mz": "671.9542",
                                "intensity": "2305.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "50",
                                "monoisotopic_mass": "1243.0614",
                                "monoisotopic_mz": "622.5380",
                                "intensity": "1430.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "51",
                                "monoisotopic_mass": "4403.3655",
                                "monoisotopic_mz": "630.0595",
                                "intensity": "2341.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "52",
                                "monoisotopic_mass": "2071.1265",
                                "monoisotopic_mz": "518.7889",
                                "intensity": "2203.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "53",
                                "monoisotopic_mass": "1402.7428",
                                "monoisotopic_mz": "468.5882",
                                "intensity": "938.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "54",
                                "monoisotopic_mass": "5385.5684",
                                "monoisotopic_mz": "674.2033",
                                "intensity": "2168.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "55",
                                "monoisotopic_mass": "986.4371",
                                "monoisotopic_mz": "987.4444",
                                "intensity": "2114.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "56",
                                "monoisotopic_mass": "4421.1058",
                                "monoisotopic_mz": "632.5938",
                                "intensity": "2883.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "57",
                                "monoisotopic_mass": "1387.3982",
                                "monoisotopic_mz": "199.2070",
                                "intensity": "932.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "58",
                                "monoisotopic_mass": "8095.4572",
                                "monoisotopic_mz": "675.6287",
                                "intensity": "2943.12",
                                "charge": "12"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "59",
                                "monoisotopic_mass": "1784.1248",
                                "monoisotopic_mz": "199.2434",
                                "intensity": "1155.04",
                                "charge": "9"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "60",
                                "monoisotopic_mass": "1399.7885",
                                "monoisotopic_mz": "700.9016",
                                "intensity": "979.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "61",
                                "monoisotopic_mass": "8004.5271",
                                "monoisotopic_mz": "668.0512",
                                "intensity": "3333.23",
                                "charge": "12"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "62",
                                "monoisotopic_mass": "5592.5615",
                                "monoisotopic_mz": "622.4030",
                                "intensity": "4339.69",
                                "charge": "9"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "63",
                                "monoisotopic_mass": "7870.8156",
                                "monoisotopic_mz": "716.5360",
                                "intensity": "1536.99",
                                "charge": "11"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "64",
                                "monoisotopic_mass": "1305.7341",
                                "monoisotopic_mz": "653.8743",
                                "intensity": "771.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "65",
                                "monoisotopic_mass": "5698.1637",
                                "monoisotopic_mz": "634.1366",
                                "intensity": "1796.48",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5698.1019",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0618",
                                        "ppm": "10.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "66",
                                "monoisotopic_mass": "4605.6112",
                                "monoisotopic_mz": "658.9517",
                                "intensity": "2893.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "67",
                                "monoisotopic_mass": "2810.4610",
                                "monoisotopic_mz": "703.6225",
                                "intensity": "1571.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "68",
                                "monoisotopic_mass": "5325.9844",
                                "monoisotopic_mz": "666.7553",
                                "intensity": "1087.15",
                                "charge": "8"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "69",
                                "monoisotopic_mass": "1135.7789",
                                "monoisotopic_mz": "568.8967",
                                "intensity": "1046.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "70",
                                "monoisotopic_mass": "4258.0057",
                                "monoisotopic_mz": "609.2938",
                                "intensity": "2299.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "340",
                                "peak_id": "71",
                                "monoisotopic_mass": "672.4487",
                                "monoisotopic_mz": "673.4559",
                                "intensity": "1156.11",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "spec_id": "340",
                                        "peak_id": "12",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "spec_id": "340",
                                        "peak_id": "16",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "340",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "340",
                                            "peak_id": "19",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "340",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "340",
                                            "peak_id": "6",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "340",
                                            "peak_id": "4",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "340",
                                            "peak_id": "5",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "340",
                                            "peak_id": "0",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "340",
                                            "peak_id": "15",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "340",
                                            "peak_id": "10",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "34",
                                        "spec_id": "340",
                                        "peak_id": "35",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "340",
                                        "peak_id": "65",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "20",
                "p_value": "1.61e-06",
                "e_value": "1.61e-08",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "395",
                        "ms1_scans": "775",
                        "ids": "379",
                        "scans": "776",
                        "precursor_mono_mass": "8420.6164",
                        "precursor_charge": "16",
                        "precursor_mz": "527.2958",
                        "feature_inte": "4.6235e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "379",
                                "peak_id": "0",
                                "monoisotopic_mass": "7356.0334",
                                "monoisotopic_mz": "566.8560",
                                "intensity": "124951.89",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1097",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0763",
                                        "ppm": "-10.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "1",
                                "monoisotopic_mass": "6996.8977",
                                "monoisotopic_mz": "539.2302",
                                "intensity": "64948.40",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0639",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "2",
                                "monoisotopic_mass": "4924.7628",
                                "monoisotopic_mz": "493.4836",
                                "intensity": "38863.80",
                                "charge": "10"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "3",
                                "monoisotopic_mass": "4925.7620",
                                "monoisotopic_mz": "548.3142",
                                "intensity": "37157.52",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0523",
                                        "ppm": "-10.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "4",
                                "monoisotopic_mass": "4340.3860",
                                "monoisotopic_mz": "621.0624",
                                "intensity": "25726.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "5",
                                "monoisotopic_mass": "4340.3957",
                                "monoisotopic_mz": "543.5567",
                                "intensity": "22500.66",
                                "charge": "8"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "6",
                                "monoisotopic_mass": "7258.9884",
                                "monoisotopic_mz": "559.3910",
                                "intensity": "20052.25",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0685",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "7",
                                "monoisotopic_mass": "7258.9755",
                                "monoisotopic_mz": "605.9219",
                                "intensity": "11563.72",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0814",
                                        "ppm": "-11.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "8",
                                "monoisotopic_mass": "7339.0249",
                                "monoisotopic_mz": "565.5477",
                                "intensity": "21945.78",
                                "charge": "13"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "9",
                                "monoisotopic_mass": "6980.8887",
                                "monoisotopic_mz": "537.9987",
                                "intensity": "11407.26",
                                "charge": "13"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "10",
                                "monoisotopic_mass": "1981.3593",
                                "monoisotopic_mz": "199.1432",
                                "intensity": "10236.52",
                                "charge": "10"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "11",
                                "monoisotopic_mass": "3493.8664",
                                "monoisotopic_mz": "583.3183",
                                "intensity": "6600.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "12",
                                "monoisotopic_mass": "564.8479",
                                "monoisotopic_mz": "565.8552",
                                "intensity": "6989.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "13",
                                "monoisotopic_mass": "4908.7513",
                                "monoisotopic_mz": "546.4241",
                                "intensity": "12432.92",
                                "charge": "9"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "14",
                                "monoisotopic_mass": "3660.0882",
                                "monoisotopic_mz": "458.5183",
                                "intensity": "6637.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "15",
                                "monoisotopic_mass": "3662.0875",
                                "monoisotopic_mz": "611.3552",
                                "intensity": "6194.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0431",
                                        "ppm": "-11.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "16",
                                "monoisotopic_mass": "1423.7351",
                                "monoisotopic_mz": "475.5856",
                                "intensity": "10522.36",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0109",
                                        "ppm": "-7.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "17",
                                "monoisotopic_mass": "1064.5880",
                                "monoisotopic_mz": "355.8699",
                                "intensity": "7295.18",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0099",
                                        "ppm": "-9.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "18",
                                "monoisotopic_mass": "2377.9266",
                                "monoisotopic_mz": "199.1678",
                                "intensity": "6205.51",
                                "charge": "12"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "19",
                                "monoisotopic_mass": "7580.2477",
                                "monoisotopic_mz": "584.1032",
                                "intensity": "8457.27",
                                "charge": "13"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "20",
                                "monoisotopic_mass": "879.4969",
                                "monoisotopic_mz": "440.7557",
                                "intensity": "4970.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "21",
                                "monoisotopic_mass": "1423.7329",
                                "monoisotopic_mz": "712.8737",
                                "intensity": "3519.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0131",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "22",
                                "monoisotopic_mass": "6509.0884",
                                "monoisotopic_mz": "543.4313",
                                "intensity": "11903.55",
                                "charge": "12"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "23",
                                "monoisotopic_mass": "1319.7496",
                                "monoisotopic_mz": "440.9238",
                                "intensity": "6968.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "24",
                                "monoisotopic_mass": "8079.7540",
                                "monoisotopic_mz": "539.6575",
                                "intensity": "7039.54",
                                "charge": "15"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "25",
                                "monoisotopic_mass": "1228.3930",
                                "monoisotopic_mz": "615.2038",
                                "intensity": "3531.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "26",
                                "monoisotopic_mass": "985.1550",
                                "monoisotopic_mz": "493.5848",
                                "intensity": "7127.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "27",
                                "monoisotopic_mass": "2189.4446",
                                "monoisotopic_mz": "548.3684",
                                "intensity": "14499.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "28",
                                "monoisotopic_mass": "1206.3461",
                                "monoisotopic_mz": "604.1803",
                                "intensity": "2912.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "379",
                                "peak_id": "29",
                                "monoisotopic_mass": "547.7641",
                                "monoisotopic_mz": "548.7713",
                                "intensity": "2547.88",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "379",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "379",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "379",
                                            "peak_id": "7",
                                            "peak_charge": "12"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "379",
                                            "peak_id": "6",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "379",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "379",
                                            "peak_id": "16",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "379",
                                            "peak_id": "1",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "379",
                                        "peak_id": "3",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "spec_id": "379",
                                        "peak_id": "15",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "18",
                "p_value": "0.01",
                "e_value": "6.90e-04",
                "fdr": "0.03",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "384",
                        "ms1_scans": "753",
                        "ids": "368",
                        "scans": "754",
                        "precursor_mono_mass": "8419.6912",
                        "precursor_charge": "15",
                        "precursor_mz": "562.3200",
                        "feature_inte": "4.6235e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "368",
                                "peak_id": "0",
                                "monoisotopic_mass": "7356.0440",
                                "monoisotopic_mz": "614.0109",
                                "intensity": "391170.11",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "1",
                                "monoisotopic_mass": "6996.9007",
                                "monoisotopic_mz": "584.0823",
                                "intensity": "202780.54",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "2",
                                "monoisotopic_mass": "4340.3929",
                                "monoisotopic_mz": "621.0634",
                                "intensity": "153362.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "3",
                                "monoisotopic_mass": "7339.0163",
                                "monoisotopic_mz": "612.5920",
                                "intensity": "83776.88",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "4",
                                "monoisotopic_mass": "7312.0039",
                                "monoisotopic_mz": "610.3409",
                                "intensity": "70564.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "5",
                                "monoisotopic_mass": "4925.7721",
                                "monoisotopic_mz": "616.7288",
                                "intensity": "95823.01",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0421",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "6",
                                "monoisotopic_mass": "7111.9268",
                                "monoisotopic_mz": "593.6678",
                                "intensity": "66570.84",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "7",
                                "monoisotopic_mass": "4062.2285",
                                "monoisotopic_mz": "508.7858",
                                "intensity": "77991.81",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "8",
                                "monoisotopic_mass": "1423.7340",
                                "monoisotopic_mz": "712.8743",
                                "intensity": "51157.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "9",
                                "monoisotopic_mass": "8224.5103",
                                "monoisotopic_mz": "588.4723",
                                "intensity": "45292.34",
                                "charge": "14"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "10",
                                "monoisotopic_mass": "7258.9897",
                                "monoisotopic_mz": "605.9231",
                                "intensity": "58925.93",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "11",
                                "monoisotopic_mass": "3662.0993",
                                "monoisotopic_mz": "611.3572",
                                "intensity": "35798.64",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "38",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0313",
                                        "ppm": "-8.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "12",
                                "monoisotopic_mass": "4357.3968",
                                "monoisotopic_mz": "623.4925",
                                "intensity": "47409.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "13",
                                "monoisotopic_mass": "4340.3889",
                                "monoisotopic_mz": "724.4054",
                                "intensity": "59932.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "14",
                                "monoisotopic_mass": "2638.4992",
                                "monoisotopic_mz": "440.7571",
                                "intensity": "32780.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "15",
                                "monoisotopic_mass": "4358.4024",
                                "monoisotopic_mz": "727.4077",
                                "intensity": "48933.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0401",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "16",
                                "monoisotopic_mass": "2997.6388",
                                "monoisotopic_mz": "500.6137",
                                "intensity": "35099.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "17",
                                "monoisotopic_mass": "6996.9050",
                                "monoisotopic_mz": "637.0895",
                                "intensity": "26362.48",
                                "charge": "11"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "18",
                                "monoisotopic_mass": "2638.4956",
                                "monoisotopic_mz": "528.7064",
                                "intensity": "33685.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "19",
                                "monoisotopic_mass": "4907.7351",
                                "monoisotopic_mz": "614.4742",
                                "intensity": "26341.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "20",
                                "monoisotopic_mass": "4322.3746",
                                "monoisotopic_mz": "618.4894",
                                "intensity": "33197.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "21",
                                "monoisotopic_mass": "4296.3665",
                                "monoisotopic_mz": "614.7739",
                                "intensity": "32833.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "22",
                                "monoisotopic_mass": "3644.0806",
                                "monoisotopic_mz": "608.3540",
                                "intensity": "19497.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "23",
                                "monoisotopic_mass": "2071.1269",
                                "monoisotopic_mz": "691.3829",
                                "intensity": "21627.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "24",
                                "monoisotopic_mass": "4924.7667",
                                "monoisotopic_mz": "493.4840",
                                "intensity": "20576.07",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "25",
                                "monoisotopic_mass": "4063.2452",
                                "monoisotopic_mz": "581.4709",
                                "intensity": "14837.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "26",
                                "monoisotopic_mass": "2900.5888",
                                "monoisotopic_mz": "581.1250",
                                "intensity": "23326.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "27",
                                "monoisotopic_mass": "8323.5989",
                                "monoisotopic_mz": "595.5501",
                                "intensity": "34054.69",
                                "charge": "14"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "28",
                                "monoisotopic_mass": "3490.4478",
                                "monoisotopic_mz": "582.7486",
                                "intensity": "23323.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "29",
                                "monoisotopic_mass": "3596.9888",
                                "monoisotopic_mz": "600.5054",
                                "intensity": "12148.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "30",
                                "monoisotopic_mass": "2596.4766",
                                "monoisotopic_mz": "520.3026",
                                "intensity": "13581.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "31",
                                "monoisotopic_mass": "5993.7616",
                                "monoisotopic_mz": "600.3834",
                                "intensity": "14786.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "32",
                                "monoisotopic_mass": "2998.6513",
                                "monoisotopic_mz": "600.7375",
                                "intensity": "14204.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "33",
                                "monoisotopic_mass": "1064.5913",
                                "monoisotopic_mz": "355.8710",
                                "intensity": "15688.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "34",
                                "monoisotopic_mass": "3618.0844",
                                "monoisotopic_mz": "604.0213",
                                "intensity": "22016.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "35",
                                "monoisotopic_mass": "1423.7334",
                                "monoisotopic_mz": "475.5851",
                                "intensity": "18857.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "36",
                                "monoisotopic_mass": "1263.6738",
                                "monoisotopic_mz": "422.2319",
                                "intensity": "16352.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "37",
                                "monoisotopic_mass": "1830.2513",
                                "monoisotopic_mz": "611.0911",
                                "intensity": "10822.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "38",
                                "monoisotopic_mass": "1161.6422",
                                "monoisotopic_mz": "388.2213",
                                "intensity": "13825.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "39",
                                "monoisotopic_mass": "5238.9246",
                                "monoisotopic_mz": "583.1100",
                                "intensity": "17038.48",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5238.9780",
                                        "ion_position": "26",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0534",
                                        "ppm": "-10.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "40",
                                "monoisotopic_mass": "7904.2542",
                                "monoisotopic_mz": "609.0268",
                                "intensity": "19832.13",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "41",
                                "monoisotopic_mass": "1036.5950",
                                "monoisotopic_mz": "346.5389",
                                "intensity": "13213.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "42",
                                "monoisotopic_mass": "4297.3584",
                                "monoisotopic_mz": "717.2337",
                                "intensity": "15715.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "43",
                                "monoisotopic_mass": "7512.0449",
                                "monoisotopic_mz": "578.8569",
                                "intensity": "7737.52",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "44",
                                "monoisotopic_mass": "2327.2965",
                                "monoisotopic_mz": "582.8314",
                                "intensity": "10049.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "45",
                                "monoisotopic_mass": "1738.9641",
                                "monoisotopic_mz": "580.6620",
                                "intensity": "7722.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "46",
                                "monoisotopic_mass": "1982.1225",
                                "monoisotopic_mz": "661.7148",
                                "intensity": "10775.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1982.1399",
                                        "ion_position": "53",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0174",
                                        "ppm": "-8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "47",
                                "monoisotopic_mass": "7259.9898",
                                "monoisotopic_mz": "661.0064",
                                "intensity": "46581.61",
                                "charge": "11"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "48",
                                "monoisotopic_mass": "1843.0558",
                                "monoisotopic_mz": "461.7712",
                                "intensity": "10307.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "49",
                                "monoisotopic_mass": "567.3678",
                                "monoisotopic_mz": "284.6912",
                                "intensity": "15008.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "50",
                                "monoisotopic_mass": "3723.3337",
                                "monoisotopic_mz": "621.5629",
                                "intensity": "5765.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "51",
                                "monoisotopic_mass": "2071.1350",
                                "monoisotopic_mz": "518.7910",
                                "intensity": "9119.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "52",
                                "monoisotopic_mass": "4858.5585",
                                "monoisotopic_mz": "608.3271",
                                "intensity": "15145.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "53",
                                "monoisotopic_mass": "3747.1763",
                                "monoisotopic_mz": "625.5367",
                                "intensity": "7554.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "54",
                                "monoisotopic_mass": "2574.9883",
                                "monoisotopic_mz": "199.0833",
                                "intensity": "8400.62",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "55",
                                "monoisotopic_mass": "1982.1293",
                                "monoisotopic_mz": "496.5396",
                                "intensity": "8694.99",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1982.1399",
                                        "ion_position": "53",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0105",
                                        "ppm": "-5.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "56",
                                "monoisotopic_mass": "2806.5509",
                                "monoisotopic_mz": "562.3175",
                                "intensity": "13151.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "57",
                                "monoisotopic_mass": "4271.1785",
                                "monoisotopic_mz": "611.1756",
                                "intensity": "11056.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "58",
                                "monoisotopic_mass": "755.3877",
                                "monoisotopic_mz": "756.3950",
                                "intensity": "8394.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "59",
                                "monoisotopic_mass": "2301.9460",
                                "monoisotopic_mz": "576.4938",
                                "intensity": "5959.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "60",
                                "monoisotopic_mass": "3037.9861",
                                "monoisotopic_mz": "608.6045",
                                "intensity": "13372.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "61",
                                "monoisotopic_mass": "1210.3339",
                                "monoisotopic_mz": "606.1742",
                                "intensity": "10298.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "62",
                                "monoisotopic_mass": "6466.9622",
                                "monoisotopic_mz": "647.7035",
                                "intensity": "8267.10",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "63",
                                "monoisotopic_mass": "7214.8880",
                                "monoisotopic_mz": "656.9062",
                                "intensity": "20282.19",
                                "charge": "11"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "64",
                                "monoisotopic_mass": "3791.1897",
                                "monoisotopic_mz": "632.8722",
                                "intensity": "9453.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "65",
                                "monoisotopic_mass": "1306.4225",
                                "monoisotopic_mz": "654.2185",
                                "intensity": "4580.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "66",
                                "monoisotopic_mass": "1277.7024",
                                "monoisotopic_mz": "639.8585",
                                "intensity": "4541.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "67",
                                "monoisotopic_mass": "5303.6882",
                                "monoisotopic_mz": "663.9683",
                                "intensity": "5855.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "68",
                                "monoisotopic_mass": "1291.3928",
                                "monoisotopic_mz": "646.7037",
                                "intensity": "4145.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "69",
                                "monoisotopic_mass": "865.4893",
                                "monoisotopic_mz": "433.7519",
                                "intensity": "5217.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "70",
                                "monoisotopic_mass": "699.3731",
                                "monoisotopic_mz": "700.3804",
                                "intensity": "6862.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "71",
                                "monoisotopic_mass": "2773.3258",
                                "monoisotopic_mz": "199.1020",
                                "intensity": "10976.88",
                                "charge": "14"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "72",
                                "monoisotopic_mass": "4967.8122",
                                "monoisotopic_mz": "621.9838",
                                "intensity": "5693.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "73",
                                "monoisotopic_mass": "6056.0022",
                                "monoisotopic_mz": "606.6075",
                                "intensity": "7306.22",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "74",
                                "monoisotopic_mass": "1876.1281",
                                "monoisotopic_mz": "1877.1353",
                                "intensity": "29626.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "75",
                                "monoisotopic_mass": "3951.4282",
                                "monoisotopic_mz": "659.5786",
                                "intensity": "6428.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "76",
                                "monoisotopic_mass": "7299.8496",
                                "monoisotopic_mz": "562.5342",
                                "intensity": "14145.66",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "77",
                                "monoisotopic_mass": "2581.1073",
                                "monoisotopic_mz": "646.2841",
                                "intensity": "7667.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "78",
                                "monoisotopic_mass": "3696.0188",
                                "monoisotopic_mz": "617.0104",
                                "intensity": "7857.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "79",
                                "monoisotopic_mass": "622.6235",
                                "monoisotopic_mz": "623.6308",
                                "intensity": "6172.81",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8419.9411",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "2",
                        "last_residue_position": "70",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "26",
                                        "ion_display_position": "43",
                                        "spec_id": "368",
                                        "peak_id": "39",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "40",
                                        "spec_id": "368",
                                        "peak_id": "5",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "36",
                                        "spec_id": "368",
                                        "peak_id": "15",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "38",
                                        "ion_display_position": "31",
                                        "spec_id": "368",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "53",
                                            "ion_display_position": "16",
                                            "spec_id": "368",
                                            "peak_id": "46",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "53",
                                            "ion_display_position": "16",
                                            "spec_id": "368",
                                            "peak_id": "55",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": [
                            {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "22",
                                    "right_pos": "23",
                                    "anno": "C"
                                }
                            },
                            {
                                "ptm_type": "Variable",
                                "ptm": {
                                    "abbreviation": "Phospho",
                                    "unimod": "21",
                                    "mono_mass": "79.9663310000"
                                },
                                "occurence": {
                                    "left_pos": "2",
                                    "right_pos": "28",
                                    "anno": null
                                }
                            },
                            {
                                "ptm_type": "Variable",
                                "ptm": {
                                    "abbreviation": "Oxidation",
                                    "unimod": "35",
                                    "mono_mass": "15.9949150000"
                                },
                                "occurence": {
                                    "left_pos": "2",
                                    "right_pos": "28",
                                    "anno": null
                                }
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "2",
                            "right_position": "28",
                            "anno": "Phospho;Oxidation",
                            "shift_type": "variable ptm"
                        }
                    }
                }
            }
        ]
    }
}
