prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "2",
        "sequence_name": "sp|P66191|RL31_SALTY",
        "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
        "proteoform_id": "23",
        "prsm_number": "2",
        "prsm": [
            {
                "prsm_id": "47",
                "p_value": "2.20e-09",
                "e_value": "2.20e-09",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "326",
                        "ms1_scans": "637",
                        "ids": "310",
                        "scans": "638",
                        "precursor_mono_mass": "8092.9185",
                        "precursor_charge": "15",
                        "precursor_mz": "540.5352",
                        "feature_inte": "1.5912e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "310",
                                "peak_id": "0",
                                "monoisotopic_mass": "6512.0826",
                                "monoisotopic_mz": "593.0148",
                                "intensity": "21891.30",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9371442885",
                                        "theoretical_mass": "6511.0798",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0005",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "1",
                                "monoisotopic_mass": "6411.0337",
                                "monoisotopic_mz": "583.8285",
                                "intensity": "22267.43",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9371442885",
                                        "theoretical_mass": "6410.0321",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "2",
                                "monoisotopic_mass": "7688.6739",
                                "monoisotopic_mz": "592.4437",
                                "intensity": "19984.88",
                                "charge": "13"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "3",
                                "monoisotopic_mass": "6890.2711",
                                "monoisotopic_mz": "575.1965",
                                "intensity": "21199.28",
                                "charge": "12"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "4",
                                "monoisotopic_mass": "3309.7567",
                                "monoisotopic_mz": "552.6334",
                                "intensity": "14345.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0281",
                                        "ppm": "-8.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "5",
                                "monoisotopic_mass": "3309.7539",
                                "monoisotopic_mz": "473.8293",
                                "intensity": "13455.04",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0308",
                                        "ppm": "-9.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "6",
                                "monoisotopic_mass": "6583.1187",
                                "monoisotopic_mz": "599.4726",
                                "intensity": "11329.32",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9371442885",
                                        "theoretical_mass": "6582.1169",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "7",
                                "monoisotopic_mass": "6667.1406",
                                "monoisotopic_mz": "607.1110",
                                "intensity": "8000.36",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "8",
                                "monoisotopic_mass": "6251.0033",
                                "monoisotopic_mz": "569.2803",
                                "intensity": "10028.81",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9371442885",
                                        "theoretical_mass": "6250.0015",
                                        "ion_position": "16",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "9",
                                "monoisotopic_mass": "1296.6539",
                                "monoisotopic_mz": "649.3342",
                                "intensity": "9376.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0110",
                                        "ppm": "-8.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "10",
                                "monoisotopic_mass": "2034.0879",
                                "monoisotopic_mz": "509.5292",
                                "intensity": "15910.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "11",
                                "monoisotopic_mass": "6873.2162",
                                "monoisotopic_mz": "573.7753",
                                "intensity": "9996.44",
                                "charge": "12"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "12",
                                "monoisotopic_mass": "6888.2720",
                                "monoisotopic_mz": "627.2138",
                                "intensity": "3041.92",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "13",
                                "monoisotopic_mass": "1409.7359",
                                "monoisotopic_mz": "705.8752",
                                "intensity": "2891.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1409.7489",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0130",
                                        "ppm": "-9.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "14",
                                "monoisotopic_mass": "1492.7725",
                                "monoisotopic_mz": "498.5981",
                                "intensity": "4420.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "15",
                                "monoisotopic_mass": "694.3891",
                                "monoisotopic_mz": "348.2018",
                                "intensity": "5015.03",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "694.3949",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0057",
                                        "ppm": "-8.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "16",
                                "monoisotopic_mass": "905.4834",
                                "monoisotopic_mz": "453.7490",
                                "intensity": "2251.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "905.4905",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0071",
                                        "ppm": "-7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "17",
                                "monoisotopic_mass": "4051.0546",
                                "monoisotopic_mz": "579.7294",
                                "intensity": "3370.93",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4051.0898",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "Y00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0352",
                                        "ppm": "-8.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "18",
                                "monoisotopic_mass": "6565.1328",
                                "monoisotopic_mz": "597.8375",
                                "intensity": "4637.48",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "19",
                                "monoisotopic_mass": "6127.7293",
                                "monoisotopic_mz": "558.0736",
                                "intensity": "7030.60",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "20",
                                "monoisotopic_mass": "4586.5954",
                                "monoisotopic_mz": "574.3317",
                                "intensity": "2125.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "21",
                                "monoisotopic_mass": "7659.6510",
                                "monoisotopic_mz": "548.1252",
                                "intensity": "1658.52",
                                "charge": "14"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "22",
                                "monoisotopic_mass": "1145.7115",
                                "monoisotopic_mz": "573.8630",
                                "intensity": "1280.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "23",
                                "monoisotopic_mass": "1167.6148",
                                "monoisotopic_mz": "584.8147",
                                "intensity": "1340.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1167.6223",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0074",
                                        "ppm": "-6.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "24",
                                "monoisotopic_mass": "1274.6671",
                                "monoisotopic_mz": "638.3408",
                                "intensity": "1402.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "25",
                                "monoisotopic_mass": "2179.7080",
                                "monoisotopic_mz": "199.1626",
                                "intensity": "1785.07",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "26",
                                "monoisotopic_mass": "4766.1159",
                                "monoisotopic_mz": "596.7718",
                                "intensity": "2430.45",
                                "charge": "8"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "27",
                                "monoisotopic_mass": "2287.4070",
                                "monoisotopic_mz": "572.8590",
                                "intensity": "1341.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "28",
                                "monoisotopic_mass": "2774.0361",
                                "monoisotopic_mz": "199.1527",
                                "intensity": "1396.34",
                                "charge": "14"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "29",
                                "monoisotopic_mass": "2833.9812",
                                "monoisotopic_mz": "567.8035",
                                "intensity": "1659.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "30",
                                "monoisotopic_mass": "6232.5515",
                                "monoisotopic_mz": "567.6029",
                                "intensity": "2362.28",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "31",
                                "monoisotopic_mass": "1410.7362",
                                "monoisotopic_mz": "471.2527",
                                "intensity": "916.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "32",
                                "monoisotopic_mass": "4033.0128",
                                "monoisotopic_mz": "577.1520",
                                "intensity": "1412.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "33",
                                "monoisotopic_mass": "2918.5553",
                                "monoisotopic_mz": "584.7183",
                                "intensity": "1895.82",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2918.5951",
                                        "ion_position": "44",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "Y00026",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0398",
                                        "ppm": "-13.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "34",
                                "monoisotopic_mass": "4856.1730",
                                "monoisotopic_mz": "608.0289",
                                "intensity": "1752.49",
                                "charge": "8"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "35",
                                "monoisotopic_mass": "3124.5654",
                                "monoisotopic_mz": "625.9204",
                                "intensity": "2233.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "36",
                                "monoisotopic_mass": "593.4243",
                                "monoisotopic_mz": "198.8154",
                                "intensity": "1859.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "37",
                                "monoisotopic_mass": "1492.7728",
                                "monoisotopic_mz": "747.3937",
                                "intensity": "2517.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "38",
                                "monoisotopic_mass": "1126.7009",
                                "monoisotopic_mz": "564.3577",
                                "intensity": "1037.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "39",
                                "monoisotopic_mass": "7802.2481",
                                "monoisotopic_mz": "651.1946",
                                "intensity": "2991.05",
                                "charge": "12"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "40",
                                "monoisotopic_mass": "6283.7931",
                                "monoisotopic_mz": "572.2612",
                                "intensity": "3038.72",
                                "charge": "11"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "41",
                                "monoisotopic_mass": "3022.1613",
                                "monoisotopic_mz": "605.4395",
                                "intensity": "2969.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "42",
                                "monoisotopic_mass": "1139.6142",
                                "monoisotopic_mz": "380.8787",
                                "intensity": "2084.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "310",
                                "peak_id": "43",
                                "monoisotopic_mass": "591.4426",
                                "monoisotopic_mz": "592.4499",
                                "intensity": "1389.07",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "23",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "8092.9135",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "310",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "310",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "310",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "310",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "310",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "spec_id": "310",
                                        "peak_id": "6",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "spec_id": "310",
                                        "peak_id": "0",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "310",
                                        "peak_id": "1",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "54",
                                        "spec_id": "310",
                                        "peak_id": "8",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "310",
                                        "peak_id": "17",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "29",
                                            "spec_id": "310",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "29",
                                            "spec_id": "310",
                                            "peak_id": "4",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "26",
                                        "spec_id": "310",
                                        "peak_id": "33",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "16",
                            "right_position": "35",
                            "anno": "150.9371",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "46",
                "p_value": "4.16e-07",
                "e_value": "4.16e-07",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "323",
                        "ms1_scans": "631",
                        "ids": "307",
                        "scans": "632",
                        "precursor_mono_mass": "8093.8790",
                        "precursor_charge": "14",
                        "precursor_mz": "579.1415",
                        "feature_inte": "1.5912e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "307",
                                "peak_id": "0",
                                "monoisotopic_mass": "2035.0893",
                                "monoisotopic_mz": "509.7796",
                                "intensity": "222700.20",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1076",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0182",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "1",
                                "monoisotopic_mass": "6512.0813",
                                "monoisotopic_mz": "593.0147",
                                "intensity": "153464.44",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6512.0803",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0009",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "2",
                                "monoisotopic_mass": "6583.1113",
                                "monoisotopic_mz": "599.4719",
                                "intensity": "187362.15",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6583.1174",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0061",
                                        "ppm": "-0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "3",
                                "monoisotopic_mass": "6891.2576",
                                "monoisotopic_mz": "627.4852",
                                "intensity": "107805.42",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "4",
                                "monoisotopic_mass": "6512.0774",
                                "monoisotopic_mz": "652.2150",
                                "intensity": "133813.33",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6512.0803",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "5",
                                "monoisotopic_mass": "6684.1630",
                                "monoisotopic_mz": "608.6585",
                                "intensity": "112944.65",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6684.1651",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "6",
                                "monoisotopic_mass": "1296.6534",
                                "monoisotopic_mz": "649.3340",
                                "intensity": "85460.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0115",
                                        "ppm": "-8.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "7",
                                "monoisotopic_mass": "1068.5443",
                                "monoisotopic_mz": "535.2794",
                                "intensity": "91242.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0096",
                                        "ppm": "-8.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "8",
                                "monoisotopic_mass": "6583.1199",
                                "monoisotopic_mz": "659.3193",
                                "intensity": "65260.58",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6583.1174",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0025",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "9",
                                "monoisotopic_mass": "6666.1551",
                                "monoisotopic_mz": "607.0214",
                                "intensity": "59116.28",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "10",
                                "monoisotopic_mass": "6412.0271",
                                "monoisotopic_mz": "642.2100",
                                "intensity": "57925.20",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6411.0326",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0079",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "11",
                                "monoisotopic_mass": "7381.4971",
                                "monoisotopic_mz": "616.1320",
                                "intensity": "42502.87",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "12",
                                "monoisotopic_mass": "6797.2373",
                                "monoisotopic_mz": "618.9379",
                                "intensity": "47888.02",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6797.2492",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0119",
                                        "ppm": "-1.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "13",
                                "monoisotopic_mass": "1409.7362",
                                "monoisotopic_mz": "705.8754",
                                "intensity": "55439.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1409.7489",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0128",
                                        "ppm": "-9.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "14",
                                "monoisotopic_mass": "6351.3490",
                                "monoisotopic_mz": "636.1422",
                                "intensity": "58396.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "15",
                                "monoisotopic_mass": "6666.1462",
                                "monoisotopic_mz": "667.6219",
                                "intensity": "49349.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "16",
                                "monoisotopic_mass": "6565.1115",
                                "monoisotopic_mz": "657.5184",
                                "intensity": "39298.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "17",
                                "monoisotopic_mass": "7688.6802",
                                "monoisotopic_mz": "641.7306",
                                "intensity": "40005.22",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "18",
                                "monoisotopic_mass": "3065.6346",
                                "monoisotopic_mz": "614.1342",
                                "intensity": "46795.08",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3065.6636",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0289",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "19",
                                "monoisotopic_mass": "6566.1171",
                                "monoisotopic_mz": "597.9270",
                                "intensity": "36513.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "20",
                                "monoisotopic_mass": "4393.2056",
                                "monoisotopic_mz": "628.6081",
                                "intensity": "40767.91",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4393.2437",
                                        "ion_position": "32",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0381",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "21",
                                "monoisotopic_mass": "1563.8096",
                                "monoisotopic_mz": "522.2772",
                                "intensity": "27076.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "22",
                                "monoisotopic_mass": "1274.6642",
                                "monoisotopic_mz": "638.3394",
                                "intensity": "32920.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "23",
                                "monoisotopic_mass": "2035.0894",
                                "monoisotopic_mz": "679.3704",
                                "intensity": "19208.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1076",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0181",
                                        "ppm": "-8.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "24",
                                "monoisotopic_mass": "1510.7826",
                                "monoisotopic_mz": "504.6015",
                                "intensity": "32966.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1510.7966",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0140",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "25",
                                "monoisotopic_mass": "3308.7515",
                                "monoisotopic_mz": "662.7576",
                                "intensity": "18730.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "26",
                                "monoisotopic_mass": "6874.2486",
                                "monoisotopic_mz": "625.9390",
                                "intensity": "36842.93",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "27",
                                "monoisotopic_mass": "7867.8708",
                                "monoisotopic_mz": "606.2281",
                                "intensity": "18542.10",
                                "charge": "13"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "28",
                                "monoisotopic_mass": "1492.7743",
                                "monoisotopic_mz": "747.3944",
                                "intensity": "14612.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "29",
                                "monoisotopic_mass": "1492.7714",
                                "monoisotopic_mz": "498.5977",
                                "intensity": "22854.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "30",
                                "monoisotopic_mass": "6496.0693",
                                "monoisotopic_mz": "591.5590",
                                "intensity": "17084.36",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "31",
                                "monoisotopic_mass": "6955.7600",
                                "monoisotopic_mz": "696.5833",
                                "intensity": "20745.26",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "32",
                                "monoisotopic_mass": "6925.2915",
                                "monoisotopic_mz": "630.5792",
                                "intensity": "19667.80",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9376642885",
                                        "theoretical_mass": "6926.2918",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0021",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "33",
                                "monoisotopic_mass": "6647.1194",
                                "monoisotopic_mz": "665.7192",
                                "intensity": "22564.23",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "34",
                                "monoisotopic_mass": "6465.4290",
                                "monoisotopic_mz": "647.5502",
                                "intensity": "17949.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "35",
                                "monoisotopic_mass": "6910.2666",
                                "monoisotopic_mz": "629.2133",
                                "intensity": "10527.12",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "36",
                                "monoisotopic_mass": "694.3900",
                                "monoisotopic_mz": "348.2023",
                                "intensity": "17028.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "694.3949",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0049",
                                        "ppm": "-7.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "37",
                                "monoisotopic_mass": "6101.0080",
                                "monoisotopic_mz": "611.1081",
                                "intensity": "13682.08",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "38",
                                "monoisotopic_mass": "3005.4843",
                                "monoisotopic_mz": "602.1041",
                                "intensity": "11047.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "39",
                                "monoisotopic_mass": "6492.0492",
                                "monoisotopic_mz": "650.2122",
                                "intensity": "17900.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "40",
                                "monoisotopic_mass": "6781.2126",
                                "monoisotopic_mz": "617.4811",
                                "intensity": "7973.85",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "41",
                                "monoisotopic_mass": "1952.3137",
                                "monoisotopic_mz": "651.7785",
                                "intensity": "8625.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "42",
                                "monoisotopic_mass": "7365.4618",
                                "monoisotopic_mz": "614.7958",
                                "intensity": "22240.28",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "43",
                                "monoisotopic_mass": "2179.5388",
                                "monoisotopic_mz": "199.1472",
                                "intensity": "9450.38",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "44",
                                "monoisotopic_mass": "606.7435",
                                "monoisotopic_mz": "607.7507",
                                "intensity": "11641.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "45",
                                "monoisotopic_mass": "905.4831",
                                "monoisotopic_mz": "453.7488",
                                "intensity": "8192.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "905.4905",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0074",
                                        "ppm": "-8.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "46",
                                "monoisotopic_mass": "3570.7838",
                                "monoisotopic_mz": "596.1379",
                                "intensity": "7321.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "47",
                                "monoisotopic_mass": "6231.6760",
                                "monoisotopic_mz": "624.1749",
                                "intensity": "9205.17",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "48",
                                "monoisotopic_mass": "1296.6552",
                                "monoisotopic_mz": "433.2257",
                                "intensity": "6953.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0097",
                                        "ppm": "-7.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "49",
                                "monoisotopic_mass": "5847.0839",
                                "monoisotopic_mz": "650.6833",
                                "intensity": "10460.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "50",
                                "monoisotopic_mass": "7646.9457",
                                "monoisotopic_mz": "638.2528",
                                "intensity": "5933.68",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "51",
                                "monoisotopic_mass": "6353.3570",
                                "monoisotopic_mz": "530.4537",
                                "intensity": "11706.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "52",
                                "monoisotopic_mass": "7456.5184",
                                "monoisotopic_mz": "678.8726",
                                "intensity": "9247.44",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "53",
                                "monoisotopic_mass": "1219.8512",
                                "monoisotopic_mz": "610.9329",
                                "intensity": "4795.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "54",
                                "monoisotopic_mass": "1782.9721",
                                "monoisotopic_mz": "199.1153",
                                "intensity": "8292.94",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "55",
                                "monoisotopic_mass": "6464.3974",
                                "monoisotopic_mz": "588.6798",
                                "intensity": "16378.08",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "56",
                                "monoisotopic_mass": "5392.4210",
                                "monoisotopic_mz": "600.1652",
                                "intensity": "5850.56",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "57",
                                "monoisotopic_mass": "7763.0299",
                                "monoisotopic_mz": "706.7373",
                                "intensity": "18287.21",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "58",
                                "monoisotopic_mass": "1050.5346",
                                "monoisotopic_mz": "526.2746",
                                "intensity": "5720.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "59",
                                "monoisotopic_mass": "1122.5933",
                                "monoisotopic_mz": "375.2050",
                                "intensity": "5613.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "60",
                                "monoisotopic_mass": "3633.0536",
                                "monoisotopic_mz": "606.5162",
                                "intensity": "6240.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "61",
                                "monoisotopic_mass": "7624.9654",
                                "monoisotopic_mz": "636.4211",
                                "intensity": "15498.63",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "62",
                                "monoisotopic_mass": "1232.7755",
                                "monoisotopic_mz": "617.3950",
                                "intensity": "4738.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "63",
                                "monoisotopic_mass": "3540.3015",
                                "monoisotopic_mz": "591.0575",
                                "intensity": "6904.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "64",
                                "monoisotopic_mass": "5048.3543",
                                "monoisotopic_mz": "632.0516",
                                "intensity": "19854.91",
                                "charge": "8"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "23",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "8093.9140",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "307",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "307",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "307",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "spec_id": "307",
                                        "peak_id": "32",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "307",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "307",
                                            "peak_id": "48",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "307",
                                            "peak_id": "12",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "307",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "307",
                                            "peak_id": "5",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "307",
                                            "peak_id": "24",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "307",
                                            "peak_id": "2",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "307",
                                            "peak_id": "8",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "307",
                                            "peak_id": "4",
                                            "peak_charge": "10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "307",
                                            "peak_id": "1",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "307",
                                        "peak_id": "10",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "38",
                                        "spec_id": "307",
                                        "peak_id": "20",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "spec_id": "307",
                                        "peak_id": "18",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "307",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "307",
                                            "peak_id": "23",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "15",
                            "right_position": "32",
                            "anno": "151.9377",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
