prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "3",
        "sequence_name": "sp|P0A7P2|RL33_SALTY",
        "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
        "proteoform_id": "10",
        "prsm_number": "9",
        "prsm": [
            {
                "prsm_id": "22",
                "p_value": "2.69e-12",
                "e_value": "2.69e-12",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "220",
                        "ms1_scans": "425",
                        "ids": "204",
                        "scans": "426",
                        "precursor_mono_mass": "6250.5342",
                        "precursor_charge": "12",
                        "precursor_mz": "521.8851",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "204",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6248",
                                "monoisotopic_mz": "595.4604",
                                "intensity": "3476899.93",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0457",
                                        "ppm": "-9.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6140",
                                "monoisotopic_mz": "593.2090",
                                "intensity": "1605139.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4725",
                                "monoisotopic_mz": "556.4413",
                                "intensity": "1271895.71",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "4443.5009",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0285",
                                        "ppm": "-6.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0656",
                                "monoisotopic_mz": "603.3625",
                                "intensity": "1145088.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0176",
                                        "ppm": "-9.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "4",
                                "monoisotopic_mass": "1807.0665",
                                "monoisotopic_mz": "452.7739",
                                "intensity": "1234739.15",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0167",
                                        "ppm": "-9.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "5",
                                "monoisotopic_mass": "1423.8747",
                                "monoisotopic_mz": "475.6322",
                                "intensity": "808704.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "1423.8766",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0019",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "6",
                                "monoisotopic_mass": "4718.6058",
                                "monoisotopic_mz": "590.8330",
                                "intensity": "622069.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "7",
                                "monoisotopic_mass": "2948.5573",
                                "monoisotopic_mz": "590.7187",
                                "intensity": "531608.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "8",
                                "monoisotopic_mass": "4698.5961",
                                "monoisotopic_mz": "588.3318",
                                "intensity": "417123.23",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4698.6490",
                                        "ion_position": "15",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0530",
                                        "ppm": "-11.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "9",
                                "monoisotopic_mass": "1405.8636",
                                "monoisotopic_mz": "469.6285",
                                "intensity": "546278.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "10",
                                "monoisotopic_mass": "4808.6516",
                                "monoisotopic_mz": "602.0887",
                                "intensity": "389056.42",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "11",
                                "monoisotopic_mass": "4426.4695",
                                "monoisotopic_mz": "554.3160",
                                "intensity": "478427.79",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "12",
                                "monoisotopic_mass": "1789.0558",
                                "monoisotopic_mz": "448.2712",
                                "intensity": "382867.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "13",
                                "monoisotopic_mass": "1789.0561",
                                "monoisotopic_mz": "597.3593",
                                "intensity": "393267.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "14",
                                "monoisotopic_mass": "4825.6498",
                                "monoisotopic_mz": "604.2135",
                                "intensity": "236542.07",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "15",
                                "monoisotopic_mass": "2929.5389",
                                "monoisotopic_mz": "586.9151",
                                "intensity": "219324.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "16",
                                "monoisotopic_mass": "4596.5629",
                                "monoisotopic_mz": "657.6591",
                                "intensity": "165718.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "17",
                                "monoisotopic_mass": "4791.6442",
                                "monoisotopic_mz": "599.9628",
                                "intensity": "247856.09",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "18",
                                "monoisotopic_mass": "1249.8118",
                                "monoisotopic_mz": "417.6112",
                                "intensity": "249412.18",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "1249.8125",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "19",
                                "monoisotopic_mass": "4390.4371",
                                "monoisotopic_mz": "549.8119",
                                "intensity": "170389.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "20",
                                "monoisotopic_mass": "2438.4322",
                                "monoisotopic_mz": "488.6937",
                                "intensity": "144079.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0204",
                                        "ppm": "-8.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "21",
                                "monoisotopic_mass": "878.5150",
                                "monoisotopic_mz": "440.2648",
                                "intensity": "106146.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "47",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0075",
                                        "ppm": "-8.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "22",
                                "monoisotopic_mass": "5792.2122",
                                "monoisotopic_mz": "580.2285",
                                "intensity": "179126.70",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "5792.2625",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0502",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "23",
                                "monoisotopic_mass": "5113.8830",
                                "monoisotopic_mz": "569.2165",
                                "intensity": "138745.09",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "5113.8448",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0382",
                                        "ppm": "7.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "24",
                                "monoisotopic_mass": "4737.6012",
                                "monoisotopic_mz": "677.8074",
                                "intensity": "181353.10",
                                "charge": "7"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "25",
                                "monoisotopic_mass": "4407.4572",
                                "monoisotopic_mz": "551.9394",
                                "intensity": "67845.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "26",
                                "monoisotopic_mass": "587.3590",
                                "monoisotopic_mz": "588.3663",
                                "intensity": "86651.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "49",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0053",
                                        "ppm": "-9.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "27",
                                "monoisotopic_mass": "1164.7605",
                                "monoisotopic_mz": "583.3875",
                                "intensity": "77718.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "28",
                                "monoisotopic_mass": "593.4004",
                                "monoisotopic_mz": "198.8074",
                                "intensity": "75868.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "29",
                                "monoisotopic_mass": "1982.2093",
                                "monoisotopic_mz": "199.2282",
                                "intensity": "123987.52",
                                "charge": "10"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "30",
                                "monoisotopic_mass": "1090.6651",
                                "monoisotopic_mz": "364.5623",
                                "intensity": "65076.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1090.6751",
                                        "ion_position": "45",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0099",
                                        "ppm": "-9.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "31",
                                "monoisotopic_mass": "1336.8429",
                                "monoisotopic_mz": "446.6216",
                                "intensity": "99213.60",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0047542847",
                                        "theoretical_mass": "1336.8446",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "32",
                                "monoisotopic_mass": "1308.8502",
                                "monoisotopic_mz": "328.2198",
                                "intensity": "62929.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "33",
                                "monoisotopic_mass": "973.5874",
                                "monoisotopic_mz": "487.8010",
                                "intensity": "58491.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "34",
                                "monoisotopic_mass": "1387.8544",
                                "monoisotopic_mz": "463.6254",
                                "intensity": "56464.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "35",
                                "monoisotopic_mass": "815.4706",
                                "monoisotopic_mz": "408.7426",
                                "intensity": "65390.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "36",
                                "monoisotopic_mass": "1466.2776",
                                "monoisotopic_mz": "734.1461",
                                "intensity": "65485.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "37",
                                "monoisotopic_mass": "1395.7444",
                                "monoisotopic_mz": "698.8795",
                                "intensity": "44655.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "38",
                                "monoisotopic_mass": "1466.9164",
                                "monoisotopic_mz": "367.7364",
                                "intensity": "57774.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "39",
                                "monoisotopic_mass": "2912.5594",
                                "monoisotopic_mz": "583.5191",
                                "intensity": "129619.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "40",
                                "monoisotopic_mass": "1338.8132",
                                "monoisotopic_mz": "670.4139",
                                "intensity": "49813.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "41",
                                "monoisotopic_mass": "1091.6135",
                                "monoisotopic_mz": "546.8140",
                                "intensity": "60264.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "42",
                                "monoisotopic_mass": "1371.7893",
                                "monoisotopic_mz": "458.2704",
                                "intensity": "45460.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "43",
                                "monoisotopic_mass": "1149.6395",
                                "monoisotopic_mz": "575.8270",
                                "intensity": "68465.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "44",
                                "monoisotopic_mass": "1135.8921",
                                "monoisotopic_mz": "568.9533",
                                "intensity": "46843.00",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5841",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "1",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "spec_id": "204",
                                        "peak_id": "23",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "204",
                                        "peak_id": "18",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "204",
                                        "peak_id": "31",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "204",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "spec_id": "204",
                                        "peak_id": "0",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "39",
                                        "spec_id": "204",
                                        "peak_id": "8",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "spec_id": "204",
                                        "peak_id": "20",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "204",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "204",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "204",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "9",
                                        "spec_id": "204",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "7",
                                        "spec_id": "204",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "49",
                                        "ion_display_position": "5",
                                        "spec_id": "204",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "204",
                                        "peak_id": "22",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "11",
                            "right_position": "12",
                            "anno": "14.0048",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "29",
                "p_value": "4.76e-12",
                "e_value": "4.76e-12",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "266",
                        "ms1_scans": "517",
                        "ids": "250",
                        "scans": "518",
                        "precursor_mono_mass": "6250.5305",
                        "precursor_charge": "12",
                        "precursor_mz": "521.8848",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "250",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6253",
                                "monoisotopic_mz": "595.4604",
                                "intensity": "558823.84",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0452",
                                        "ppm": "-9.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6126",
                                "monoisotopic_mz": "593.2088",
                                "intensity": "236009.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4720",
                                "monoisotopic_mz": "556.4413",
                                "intensity": "178587.64",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "4443.5023",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0303",
                                        "ppm": "-6.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0660",
                                "monoisotopic_mz": "603.3626",
                                "intensity": "178833.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0173",
                                        "ppm": "-9.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "4",
                                "monoisotopic_mass": "4719.6028",
                                "monoisotopic_mz": "590.9576",
                                "intensity": "99751.03",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "5",
                                "monoisotopic_mass": "1807.0669",
                                "monoisotopic_mz": "452.7740",
                                "intensity": "165975.66",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0164",
                                        "ppm": "-9.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "6",
                                "monoisotopic_mass": "1423.8742",
                                "monoisotopic_mz": "475.6320",
                                "intensity": "120889.54",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1423.8779",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0037",
                                        "ppm": "-2.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "7",
                                "monoisotopic_mass": "4425.4622",
                                "monoisotopic_mz": "554.1901",
                                "intensity": "91088.16",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "8",
                                "monoisotopic_mass": "4699.6043",
                                "monoisotopic_mz": "588.4578",
                                "intensity": "75772.74",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "9",
                                "monoisotopic_mass": "2948.5600",
                                "monoisotopic_mz": "590.7193",
                                "intensity": "88722.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "10",
                                "monoisotopic_mass": "1405.8636",
                                "monoisotopic_mz": "469.6285",
                                "intensity": "68584.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "11",
                                "monoisotopic_mass": "1789.0557",
                                "monoisotopic_mz": "597.3592",
                                "intensity": "68083.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "12",
                                "monoisotopic_mass": "1789.0584",
                                "monoisotopic_mz": "448.2719",
                                "intensity": "53156.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "13",
                                "monoisotopic_mass": "4807.6488",
                                "monoisotopic_mz": "601.9634",
                                "intensity": "56285.89",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "14",
                                "monoisotopic_mass": "4737.6148",
                                "monoisotopic_mz": "677.8094",
                                "intensity": "33267.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "15",
                                "monoisotopic_mass": "2930.5489",
                                "monoisotopic_mz": "587.1170",
                                "intensity": "47786.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "16",
                                "monoisotopic_mass": "4790.6389",
                                "monoisotopic_mz": "599.8371",
                                "intensity": "28155.20",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "17",
                                "monoisotopic_mass": "4596.5493",
                                "monoisotopic_mz": "657.6572",
                                "intensity": "29041.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "18",
                                "monoisotopic_mass": "1249.8124",
                                "monoisotopic_mz": "417.6114",
                                "intensity": "33779.95",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1249.8139",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0014",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "19",
                                "monoisotopic_mass": "4389.4318",
                                "monoisotopic_mz": "549.6863",
                                "intensity": "19746.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "20",
                                "monoisotopic_mass": "2930.5610",
                                "monoisotopic_mz": "733.6475",
                                "intensity": "20444.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "21",
                                "monoisotopic_mass": "2912.5410",
                                "monoisotopic_mz": "583.5155",
                                "intensity": "16092.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "22",
                                "monoisotopic_mass": "3001.5862",
                                "monoisotopic_mz": "601.3245",
                                "intensity": "16428.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "23",
                                "monoisotopic_mass": "1336.8446",
                                "monoisotopic_mz": "446.6221",
                                "intensity": "23407.14",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1336.8459",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "24",
                                "monoisotopic_mass": "5112.8587",
                                "monoisotopic_mz": "569.1027",
                                "intensity": "20525.90",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "5113.8462",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0149",
                                        "ppm": "2.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "25",
                                "monoisotopic_mass": "4826.6677",
                                "monoisotopic_mz": "604.3407",
                                "intensity": "32891.16",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "13",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0399",
                                        "ppm": "-8.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "26",
                                "monoisotopic_mass": "4680.5917",
                                "monoisotopic_mz": "586.0812",
                                "intensity": "25538.55",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "27",
                                "monoisotopic_mass": "4755.6241",
                                "monoisotopic_mz": "680.3821",
                                "intensity": "15220.25",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0464",
                                        "ppm": "-9.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "28",
                                "monoisotopic_mass": "587.3587",
                                "monoisotopic_mz": "588.3660",
                                "intensity": "14895.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "49",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0055",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "29",
                                "monoisotopic_mass": "2438.4297",
                                "monoisotopic_mz": "488.6932",
                                "intensity": "18855.96",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0229",
                                        "ppm": "-9.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "30",
                                "monoisotopic_mass": "1678.9682",
                                "monoisotopic_mz": "560.6633",
                                "intensity": "11915.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "31",
                                "monoisotopic_mass": "1210.7307",
                                "monoisotopic_mz": "606.3726",
                                "intensity": "12976.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "32",
                                "monoisotopic_mass": "4425.4501",
                                "monoisotopic_mz": "633.2144",
                                "intensity": "13528.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "33",
                                "monoisotopic_mass": "4407.4459",
                                "monoisotopic_mz": "551.9380",
                                "intensity": "15540.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "34",
                                "monoisotopic_mass": "4597.5633",
                                "monoisotopic_mz": "575.7027",
                                "intensity": "15424.31",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4597.6013",
                                        "ion_position": "16",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0381",
                                        "ppm": "-8.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "35",
                                "monoisotopic_mass": "2947.5579",
                                "monoisotopic_mz": "737.8968",
                                "intensity": "13262.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "36",
                                "monoisotopic_mass": "4755.6286",
                                "monoisotopic_mz": "529.4105",
                                "intensity": "21356.14",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0419",
                                        "ppm": "-8.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "37",
                                "monoisotopic_mass": "4627.5417",
                                "monoisotopic_mz": "662.0847",
                                "intensity": "11128.37",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "38",
                                "monoisotopic_mass": "4443.4734",
                                "monoisotopic_mz": "635.7892",
                                "intensity": "12318.71",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "4443.5023",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0289",
                                        "ppm": "-6.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "39",
                                "monoisotopic_mass": "2596.4170",
                                "monoisotopic_mz": "650.1115",
                                "intensity": "10104.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "40",
                                "monoisotopic_mass": "1610.9472",
                                "monoisotopic_mz": "537.9897",
                                "intensity": "18997.04",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "41",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0149",
                                        "ppm": "-9.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "41",
                                "monoisotopic_mass": "5793.2193",
                                "monoisotopic_mz": "580.3292",
                                "intensity": "19695.39",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "5792.2638",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0468",
                                        "ppm": "-8.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "42",
                                "monoisotopic_mass": "2449.3481",
                                "monoisotopic_mz": "613.3443",
                                "intensity": "9304.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "43",
                                "monoisotopic_mass": "1249.8135",
                                "monoisotopic_mz": "625.9140",
                                "intensity": "9204.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1249.8139",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "44",
                                "monoisotopic_mass": "3813.1101",
                                "monoisotopic_mz": "545.7373",
                                "intensity": "8580.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "45",
                                "monoisotopic_mass": "1476.9008",
                                "monoisotopic_mz": "370.2325",
                                "intensity": "8779.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "46",
                                "monoisotopic_mass": "1338.8211",
                                "monoisotopic_mz": "670.4178",
                                "intensity": "9078.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "47",
                                "monoisotopic_mass": "2885.6027",
                                "monoisotopic_mz": "578.1278",
                                "intensity": "11423.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "48",
                                "monoisotopic_mass": "3018.5971",
                                "monoisotopic_mz": "604.7267",
                                "intensity": "10782.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "49",
                                "monoisotopic_mass": "4719.6047",
                                "monoisotopic_mz": "675.2365",
                                "intensity": "15983.26",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "50",
                                "monoisotopic_mass": "878.5149",
                                "monoisotopic_mz": "440.2647",
                                "intensity": "12426.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "47",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0077",
                                        "ppm": "-8.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "51",
                                "monoisotopic_mass": "1318.8316",
                                "monoisotopic_mz": "440.6178",
                                "intensity": "7986.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "52",
                                "monoisotopic_mass": "1281.7650",
                                "monoisotopic_mz": "641.8898",
                                "intensity": "5787.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "53",
                                "monoisotopic_mass": "815.4699",
                                "monoisotopic_mz": "408.7422",
                                "intensity": "6669.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "54",
                                "monoisotopic_mass": "1308.8525",
                                "monoisotopic_mz": "328.2204",
                                "intensity": "5465.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "55",
                                "monoisotopic_mass": "4092.3348",
                                "monoisotopic_mz": "683.0631",
                                "intensity": "11805.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "56",
                                "monoisotopic_mass": "1387.8533",
                                "monoisotopic_mz": "463.6250",
                                "intensity": "10966.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "57",
                                "monoisotopic_mass": "5414.5088",
                                "monoisotopic_mz": "602.6194",
                                "intensity": "13242.50",
                                "charge": "9"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "58",
                                "monoisotopic_mass": "3891.2569",
                                "monoisotopic_mz": "556.9011",
                                "intensity": "23843.58",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3891.2939",
                                        "ion_position": "22",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "Y00032",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0370",
                                        "ppm": "-9.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "59",
                                "monoisotopic_mass": "5747.0215",
                                "monoisotopic_mz": "575.7094",
                                "intensity": "9976.52",
                                "charge": "10"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "60",
                                "monoisotopic_mass": "3875.5201",
                                "monoisotopic_mz": "554.6530",
                                "intensity": "11253.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "250",
                                "peak_id": "61",
                                "monoisotopic_mass": "631.3619",
                                "monoisotopic_mz": "632.3691",
                                "intensity": "4946.85",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5855",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "1",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "spec_id": "250",
                                        "peak_id": "24",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "250",
                                            "peak_id": "18",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "250",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "250",
                                        "peak_id": "23",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "250",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "41",
                                            "spec_id": "250",
                                            "peak_id": "25",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "40",
                                            "spec_id": "250",
                                            "peak_id": "27",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "40",
                                            "spec_id": "250",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "40",
                                            "spec_id": "250",
                                            "peak_id": "36",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "38",
                                        "spec_id": "250",
                                        "peak_id": "34",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "22",
                                        "ion_display_position": "32",
                                        "spec_id": "250",
                                        "peak_id": "58",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "spec_id": "250",
                                        "peak_id": "29",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "250",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "250",
                                            "peak_id": "5",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "250",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "250",
                                            "peak_id": "38",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "13",
                                        "spec_id": "250",
                                        "peak_id": "40",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "7",
                                        "spec_id": "250",
                                        "peak_id": "50",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "49",
                                        "ion_display_position": "5",
                                        "spec_id": "250",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "250",
                                        "peak_id": "41",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "11",
                            "right_position": "12",
                            "anno": "14.0061",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "32",
                "p_value": "6.36e-12",
                "e_value": "6.36e-12",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "22",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "278",
                        "ms1_scans": "541",
                        "ids": "262",
                        "scans": "542",
                        "precursor_mono_mass": "6250.5212",
                        "precursor_charge": "11",
                        "precursor_mz": "569.2365",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "262",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4678",
                                "monoisotopic_mz": "635.7884",
                                "intensity": "427508.89",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "4443.4980",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0302",
                                        "ppm": "-6.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "1",
                                "monoisotopic_mass": "1807.0662",
                                "monoisotopic_mz": "603.3627",
                                "intensity": "414742.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0171",
                                        "ppm": "-9.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "2",
                                "monoisotopic_mass": "1807.0666",
                                "monoisotopic_mz": "452.7739",
                                "intensity": "170990.44",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0166",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "3",
                                "monoisotopic_mass": "1789.0563",
                                "monoisotopic_mz": "597.3594",
                                "intensity": "143840.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "4",
                                "monoisotopic_mass": "2948.5571",
                                "monoisotopic_mz": "738.1466",
                                "intensity": "78557.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "5",
                                "monoisotopic_mass": "4426.4532",
                                "monoisotopic_mz": "633.3577",
                                "intensity": "66666.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "6",
                                "monoisotopic_mass": "5159.8698",
                                "monoisotopic_mz": "645.9910",
                                "intensity": "39768.97",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "5159.9062",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0364",
                                        "ppm": "-7.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "7",
                                "monoisotopic_mass": "4755.6249",
                                "monoisotopic_mz": "680.3823",
                                "intensity": "78205.36",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0456",
                                        "ppm": "-9.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "8",
                                "monoisotopic_mass": "4737.6122",
                                "monoisotopic_mz": "677.8090",
                                "intensity": "59468.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "9",
                                "monoisotopic_mass": "2596.4121",
                                "monoisotopic_mz": "650.1103",
                                "intensity": "45675.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "10",
                                "monoisotopic_mass": "3019.5959",
                                "monoisotopic_mz": "755.9063",
                                "intensity": "51098.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "11",
                                "monoisotopic_mass": "4230.3236",
                                "monoisotopic_mz": "605.3392",
                                "intensity": "48008.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "12",
                                "monoisotopic_mass": "1660.9607",
                                "monoisotopic_mz": "831.4876",
                                "intensity": "32679.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "13",
                                "monoisotopic_mass": "4443.4664",
                                "monoisotopic_mz": "741.5850",
                                "intensity": "37093.84",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "4443.4980",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0316",
                                        "ppm": "-7.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "14",
                                "monoisotopic_mass": "4358.4338",
                                "monoisotopic_mz": "623.6407",
                                "intensity": "53191.90",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "15",
                                "monoisotopic_mass": "4230.3081",
                                "monoisotopic_mz": "706.0586",
                                "intensity": "34045.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "16",
                                "monoisotopic_mass": "2449.3441",
                                "monoisotopic_mz": "817.4553",
                                "intensity": "37467.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "17",
                                "monoisotopic_mass": "1789.0561",
                                "monoisotopic_mz": "448.2713",
                                "intensity": "76038.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "18",
                                "monoisotopic_mass": "1249.8125",
                                "monoisotopic_mz": "417.6114",
                                "intensity": "51026.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1249.8096",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0029",
                                        "ppm": "2.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "19",
                                "monoisotopic_mass": "3106.6225",
                                "monoisotopic_mz": "777.6629",
                                "intensity": "28285.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "20",
                                "monoisotopic_mass": "4825.6616",
                                "monoisotopic_mz": "690.3875",
                                "intensity": "33634.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "21",
                                "monoisotopic_mass": "3192.6536",
                                "monoisotopic_mz": "799.1707",
                                "intensity": "30637.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "22",
                                "monoisotopic_mass": "2596.4078",
                                "monoisotopic_mz": "866.4766",
                                "intensity": "21746.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "23",
                                "monoisotopic_mass": "5792.2123",
                                "monoisotopic_mz": "644.5864",
                                "intensity": "48851.75",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "5792.2596",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0473",
                                        "ppm": "-8.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "24",
                                "monoisotopic_mass": "815.4695",
                                "monoisotopic_mz": "408.7420",
                                "intensity": "38439.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "25",
                                "monoisotopic_mass": "4341.3935",
                                "monoisotopic_mz": "621.2063",
                                "intensity": "36196.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "26",
                                "monoisotopic_mass": "6122.4475",
                                "monoisotopic_mz": "613.2520",
                                "intensity": "36528.26",
                                "charge": "10"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "27",
                                "monoisotopic_mass": "3813.1052",
                                "monoisotopic_mz": "636.5248",
                                "intensity": "67612.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "28",
                                "monoisotopic_mass": "716.4020",
                                "monoisotopic_mz": "717.4092",
                                "intensity": "31157.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "29",
                                "monoisotopic_mass": "2286.2836",
                                "monoisotopic_mz": "763.1018",
                                "intensity": "26531.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "30",
                                "monoisotopic_mass": "1610.9480",
                                "monoisotopic_mz": "537.9899",
                                "intensity": "25835.73",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0141",
                                        "ppm": "-8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "31",
                                "monoisotopic_mass": "1423.8728",
                                "monoisotopic_mz": "475.6316",
                                "intensity": "24828.16",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1423.8737",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "32",
                                "monoisotopic_mass": "928.5525",
                                "monoisotopic_mz": "465.2835",
                                "intensity": "28985.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "33",
                                "monoisotopic_mass": "1494.9121",
                                "monoisotopic_mz": "499.3113",
                                "intensity": "17758.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1494.9108",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0013",
                                        "ppm": "0.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "34",
                                "monoisotopic_mass": "6166.4656",
                                "monoisotopic_mz": "617.6538",
                                "intensity": "37812.96",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6165.5423",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0791",
                                        "ppm": "-12.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "35",
                                "monoisotopic_mass": "2929.5477",
                                "monoisotopic_mz": "733.3942",
                                "intensity": "23429.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "36",
                                "monoisotopic_mass": "4406.4391",
                                "monoisotopic_mz": "630.4986",
                                "intensity": "15935.14",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "37",
                                "monoisotopic_mass": "3193.6522",
                                "monoisotopic_mz": "639.7377",
                                "intensity": "17456.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "38",
                                "monoisotopic_mass": "1037.6618",
                                "monoisotopic_mz": "519.8382",
                                "intensity": "33326.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1037.6571",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0047",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "39",
                                "monoisotopic_mass": "1164.7594",
                                "monoisotopic_mz": "583.3870",
                                "intensity": "23428.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "40",
                                "monoisotopic_mass": "1846.0533",
                                "monoisotopic_mz": "616.3584",
                                "intensity": "22741.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "41",
                                "monoisotopic_mass": "1819.0698",
                                "monoisotopic_mz": "607.3639",
                                "intensity": "19401.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "42",
                                "monoisotopic_mass": "4808.6453",
                                "monoisotopic_mz": "687.9566",
                                "intensity": "25394.90",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "43",
                                "monoisotopic_mass": "991.5984",
                                "monoisotopic_mz": "496.8065",
                                "intensity": "26263.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0083",
                                        "ppm": "-8.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "44",
                                "monoisotopic_mass": "4322.3708",
                                "monoisotopic_mz": "618.4888",
                                "intensity": "18117.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "45",
                                "monoisotopic_mass": "3000.5860",
                                "monoisotopic_mz": "751.1538",
                                "intensity": "21661.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "46",
                                "monoisotopic_mass": "2449.3305",
                                "monoisotopic_mz": "613.3399",
                                "intensity": "23392.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "47",
                                "monoisotopic_mass": "716.4017",
                                "monoisotopic_mz": "359.2081",
                                "intensity": "14232.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "48",
                                "monoisotopic_mass": "1336.8442",
                                "monoisotopic_mz": "446.6220",
                                "intensity": "13033.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1336.8416",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0026",
                                        "ppm": "1.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "49",
                                "monoisotopic_mass": "4212.3224",
                                "monoisotopic_mz": "602.7676",
                                "intensity": "17367.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "50",
                                "monoisotopic_mass": "1709.9962",
                                "monoisotopic_mz": "856.0054",
                                "intensity": "14269.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1710.0014",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "-0.0052",
                                        "ppm": "-3.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "51",
                                "monoisotopic_mass": "3186.8816",
                                "monoisotopic_mz": "532.1542",
                                "intensity": "17410.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "52",
                                "monoisotopic_mass": "1249.8130",
                                "monoisotopic_mz": "625.9138",
                                "intensity": "14711.80",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1249.8096",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0033",
                                        "ppm": "2.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "53",
                                "monoisotopic_mass": "3848.1494",
                                "monoisotopic_mz": "642.3655",
                                "intensity": "15068.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "54",
                                "monoisotopic_mass": "878.5144",
                                "monoisotopic_mz": "879.5217",
                                "intensity": "21083.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0082",
                                        "ppm": "-9.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "55",
                                "monoisotopic_mass": "2179.6441",
                                "monoisotopic_mz": "199.1567",
                                "intensity": "9879.26",
                                "charge": "11"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "56",
                                "monoisotopic_mass": "1061.9564",
                                "monoisotopic_mz": "531.9855",
                                "intensity": "14871.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "57",
                                "monoisotopic_mass": "6019.3613",
                                "monoisotopic_mz": "602.9434",
                                "intensity": "17048.30",
                                "charge": "10"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "58",
                                "monoisotopic_mass": "1981.2463",
                                "monoisotopic_mz": "199.1319",
                                "intensity": "11425.06",
                                "charge": "10"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "59",
                                "monoisotopic_mass": "928.5511",
                                "monoisotopic_mz": "929.5583",
                                "intensity": "10586.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "60",
                                "monoisotopic_mass": "991.5970",
                                "monoisotopic_mz": "992.6042",
                                "intensity": "12524.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0097",
                                        "ppm": "-9.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "61",
                                "monoisotopic_mass": "2565.9505",
                                "monoisotopic_mz": "642.4949",
                                "intensity": "16335.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "62",
                                "monoisotopic_mass": "4395.4970",
                                "monoisotopic_mz": "733.5901",
                                "intensity": "8673.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "63",
                                "monoisotopic_mass": "2733.4702",
                                "monoisotopic_mz": "684.3748",
                                "intensity": "12416.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "64",
                                "monoisotopic_mass": "1264.7002",
                                "monoisotopic_mz": "633.3574",
                                "intensity": "13265.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "65",
                                "monoisotopic_mass": "3797.0966",
                                "monoisotopic_mz": "633.8567",
                                "intensity": "13627.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "66",
                                "monoisotopic_mass": "3087.6109",
                                "monoisotopic_mz": "772.9100",
                                "intensity": "14313.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "67",
                                "monoisotopic_mass": "1037.6641",
                                "monoisotopic_mz": "346.8953",
                                "intensity": "7966.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "1037.6571",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0070",
                                        "ppm": "6.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "68",
                                "monoisotopic_mass": "458.3177",
                                "monoisotopic_mz": "459.3249",
                                "intensity": "12766.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "458.3217",
                                        "ion_position": "51",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0040",
                                        "ppm": "-8.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "69",
                                "monoisotopic_mass": "3019.6918",
                                "monoisotopic_mz": "604.9456",
                                "intensity": "7995.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "70",
                                "monoisotopic_mass": "3709.1273",
                                "monoisotopic_mz": "619.1952",
                                "intensity": "19553.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "71",
                                "monoisotopic_mass": "1330.7357",
                                "monoisotopic_mz": "666.3751",
                                "intensity": "12935.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "72",
                                "monoisotopic_mass": "909.5675",
                                "monoisotopic_mz": "910.5748",
                                "intensity": "7517.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0386508038",
                                        "theoretical_mass": "909.5622",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0054",
                                        "ppm": "5.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "73",
                                "monoisotopic_mass": "1405.8577",
                                "monoisotopic_mz": "469.6265",
                                "intensity": "6012.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "74",
                                "monoisotopic_mass": "2050.1284",
                                "monoisotopic_mz": "684.3834",
                                "intensity": "10204.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "75",
                                "monoisotopic_mass": "1221.8187",
                                "monoisotopic_mz": "408.2802",
                                "intensity": "6162.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "76",
                                "monoisotopic_mass": "1219.7075",
                                "monoisotopic_mz": "610.8610",
                                "intensity": "12505.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "77",
                                "monoisotopic_mass": "674.3722",
                                "monoisotopic_mz": "675.3795",
                                "intensity": "7473.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "78",
                                "monoisotopic_mass": "5825.9479",
                                "monoisotopic_mz": "729.2508",
                                "intensity": "13656.38",
                                "charge": "8"
                            },
                            {
                                "spec_id": "262",
                                "peak_id": "79",
                                "monoisotopic_mass": "4982.7635",
                                "monoisotopic_mz": "623.8527",
                                "intensity": "18651.71",
                                "charge": "8"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5812",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "spec_id": "262",
                                        "peak_id": "34",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "262",
                                        "peak_id": "72",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "262",
                                            "peak_id": "38",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "262",
                                            "peak_id": "67",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "262",
                                            "peak_id": "18",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "262",
                                            "peak_id": "52",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "262",
                                        "peak_id": "48",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "262",
                                        "peak_id": "31",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "262",
                                            "peak_id": "33",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "spec_id": "262",
                                            "peak_id": "7",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "262",
                                        "peak_id": "50",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "262",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "262",
                                            "peak_id": "2",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "262",
                                            "peak_id": "13",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "262",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "262",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "262",
                                        "peak_id": "6",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "262",
                                            "peak_id": "60",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "262",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "262",
                                        "peak_id": "54",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "51",
                                            "ion_display_position": "4",
                                            "spec_id": "262",
                                            "peak_id": "68",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "262",
                                            "peak_id": "23",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "2",
                            "anno": "-117.0387",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "26",
                "p_value": "1.61e-11",
                "e_value": "1.61e-11",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "248",
                        "ms1_scans": "481",
                        "ids": "232",
                        "scans": "482",
                        "precursor_mono_mass": "6250.5447",
                        "precursor_charge": "11",
                        "precursor_mz": "569.2386",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "232",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4687",
                                "monoisotopic_mz": "635.7885",
                                "intensity": "571022.30",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "4443.5015",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0328",
                                        "ppm": "-7.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "1",
                                "monoisotopic_mass": "1807.0675",
                                "monoisotopic_mz": "603.3631",
                                "intensity": "515787.65",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0158",
                                        "ppm": "-8.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "2",
                                "monoisotopic_mass": "1789.0574",
                                "monoisotopic_mz": "597.3597",
                                "intensity": "236624.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0671",
                                "monoisotopic_mz": "452.7741",
                                "intensity": "217505.47",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0161",
                                        "ppm": "-8.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "4",
                                "monoisotopic_mass": "2948.5591",
                                "monoisotopic_mz": "738.1470",
                                "intensity": "118887.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "5",
                                "monoisotopic_mass": "4755.6198",
                                "monoisotopic_mz": "680.3815",
                                "intensity": "102209.83",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0507",
                                        "ppm": "-10.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "6",
                                "monoisotopic_mass": "4426.4583",
                                "monoisotopic_mz": "633.3585",
                                "intensity": "88362.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "7",
                                "monoisotopic_mass": "4357.4169",
                                "monoisotopic_mz": "623.4954",
                                "intensity": "79188.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "8",
                                "monoisotopic_mass": "1789.0576",
                                "monoisotopic_mz": "448.2717",
                                "intensity": "106126.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "9",
                                "monoisotopic_mass": "2596.4177",
                                "monoisotopic_mz": "650.1117",
                                "intensity": "66270.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "10",
                                "monoisotopic_mass": "4737.6054",
                                "monoisotopic_mz": "677.8080",
                                "intensity": "58740.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "11",
                                "monoisotopic_mass": "4230.3201",
                                "monoisotopic_mz": "706.0606",
                                "intensity": "38539.45",
                                "charge": "6"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "12",
                                "monoisotopic_mass": "5159.8767",
                                "monoisotopic_mz": "645.9919",
                                "intensity": "42351.29",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "5159.9097",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0330",
                                        "ppm": "-6.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "13",
                                "monoisotopic_mass": "2930.5503",
                                "monoisotopic_mz": "733.6448",
                                "intensity": "49137.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "14",
                                "monoisotopic_mass": "991.5977",
                                "monoisotopic_mz": "496.8061",
                                "intensity": "44158.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0090",
                                        "ppm": "-9.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "15",
                                "monoisotopic_mass": "2286.2834",
                                "monoisotopic_mz": "763.1017",
                                "intensity": "44715.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "16",
                                "monoisotopic_mass": "5792.2194",
                                "monoisotopic_mz": "644.5872",
                                "intensity": "45920.79",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "5792.2631",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0436",
                                        "ppm": "-7.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "17",
                                "monoisotopic_mass": "2449.3481",
                                "monoisotopic_mz": "817.4567",
                                "intensity": "49978.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "18",
                                "monoisotopic_mass": "4230.3283",
                                "monoisotopic_mz": "605.3399",
                                "intensity": "69439.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "19",
                                "monoisotopic_mass": "4341.4055",
                                "monoisotopic_mz": "621.2081",
                                "intensity": "38747.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "20",
                                "monoisotopic_mass": "6121.4636",
                                "monoisotopic_mz": "613.1536",
                                "intensity": "77895.09",
                                "charge": "10"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "21",
                                "monoisotopic_mass": "3019.6006",
                                "monoisotopic_mz": "755.9074",
                                "intensity": "63465.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "22",
                                "monoisotopic_mass": "1249.8123",
                                "monoisotopic_mz": "417.6114",
                                "intensity": "46753.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1249.8131",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "23",
                                "monoisotopic_mass": "1660.9637",
                                "monoisotopic_mz": "831.4891",
                                "intensity": "49483.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "24",
                                "monoisotopic_mass": "815.4700",
                                "monoisotopic_mz": "408.7423",
                                "intensity": "57569.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "25",
                                "monoisotopic_mass": "3813.1158",
                                "monoisotopic_mz": "636.5266",
                                "intensity": "58581.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "26",
                                "monoisotopic_mass": "3074.2223",
                                "monoisotopic_mz": "615.8517",
                                "intensity": "36847.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "27",
                                "monoisotopic_mass": "1846.0522",
                                "monoisotopic_mz": "462.5203",
                                "intensity": "40479.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "28",
                                "monoisotopic_mass": "4827.6727",
                                "monoisotopic_mz": "690.6748",
                                "intensity": "33218.10",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "29",
                                "monoisotopic_mass": "2596.4089",
                                "monoisotopic_mz": "866.4769",
                                "intensity": "33091.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "30",
                                "monoisotopic_mass": "2438.4297",
                                "monoisotopic_mz": "488.6932",
                                "intensity": "23956.82",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0229",
                                        "ppm": "-9.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "31",
                                "monoisotopic_mass": "1610.9492",
                                "monoisotopic_mz": "537.9904",
                                "intensity": "24410.60",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0128",
                                        "ppm": "-7.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "32",
                                "monoisotopic_mass": "716.4030",
                                "monoisotopic_mz": "717.4103",
                                "intensity": "36946.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "33",
                                "monoisotopic_mass": "5775.2344",
                                "monoisotopic_mz": "642.7000",
                                "intensity": "35173.74",
                                "charge": "9"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "34",
                                "monoisotopic_mass": "3002.5868",
                                "monoisotopic_mz": "751.6540",
                                "intensity": "34249.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "35",
                                "monoisotopic_mass": "928.5526",
                                "monoisotopic_mz": "465.2836",
                                "intensity": "22055.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "36",
                                "monoisotopic_mass": "3193.6630",
                                "monoisotopic_mz": "799.4230",
                                "intensity": "31841.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "37",
                                "monoisotopic_mass": "1037.6617",
                                "monoisotopic_mz": "519.8381",
                                "intensity": "42791.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1037.6606",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0011",
                                        "ppm": "1.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "38",
                                "monoisotopic_mass": "4323.3928",
                                "monoisotopic_mz": "618.6348",
                                "intensity": "39308.99",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "39",
                                "monoisotopic_mass": "4443.4755",
                                "monoisotopic_mz": "741.5865",
                                "intensity": "31266.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "4443.5015",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0260",
                                        "ppm": "-5.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "40",
                                "monoisotopic_mass": "1164.7577",
                                "monoisotopic_mz": "583.3861",
                                "intensity": "26944.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "41",
                                "monoisotopic_mass": "4809.6386",
                                "monoisotopic_mz": "688.0985",
                                "intensity": "23306.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "42",
                                "monoisotopic_mass": "2439.4407",
                                "monoisotopic_mz": "610.8674",
                                "intensity": "22410.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "43",
                                "monoisotopic_mass": "4358.4182",
                                "monoisotopic_mz": "727.4103",
                                "intensity": "37302.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "44",
                                "monoisotopic_mass": "1423.8762",
                                "monoisotopic_mz": "475.6327",
                                "intensity": "17774.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1423.8772",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "45",
                                "monoisotopic_mass": "1330.7375",
                                "monoisotopic_mz": "666.3760",
                                "intensity": "23699.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "46",
                                "monoisotopic_mass": "2179.6352",
                                "monoisotopic_mz": "199.1559",
                                "intensity": "17786.35",
                                "charge": "11"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "47",
                                "monoisotopic_mass": "991.5993",
                                "monoisotopic_mz": "992.6066",
                                "intensity": "16279.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0074",
                                        "ppm": "-7.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "48",
                                "monoisotopic_mass": "1249.8144",
                                "monoisotopic_mz": "625.9145",
                                "intensity": "19156.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1249.8131",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0013",
                                        "ppm": "1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "49",
                                "monoisotopic_mass": "1150.7455",
                                "monoisotopic_mz": "576.3800",
                                "intensity": "17067.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1150.7447",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0008",
                                        "ppm": "0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "50",
                                "monoisotopic_mass": "3174.6446",
                                "monoisotopic_mz": "794.6684",
                                "intensity": "23025.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "51",
                                "monoisotopic_mass": "878.5156",
                                "monoisotopic_mz": "879.5229",
                                "intensity": "27019.15",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0070",
                                        "ppm": "-7.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "52",
                                "monoisotopic_mass": "688.4081",
                                "monoisotopic_mz": "345.2113",
                                "intensity": "14564.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "53",
                                "monoisotopic_mass": "3106.6140",
                                "monoisotopic_mz": "777.6608",
                                "intensity": "33477.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "54",
                                "monoisotopic_mass": "1336.8427",
                                "monoisotopic_mz": "446.6215",
                                "intensity": "19291.19",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1336.8451",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0024",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "55",
                                "monoisotopic_mass": "973.5841",
                                "monoisotopic_mz": "487.7993",
                                "intensity": "13808.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "56",
                                "monoisotopic_mass": "1386.9087",
                                "monoisotopic_mz": "199.1371",
                                "intensity": "9950.27",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "57",
                                "monoisotopic_mass": "1395.7409",
                                "monoisotopic_mz": "698.8777",
                                "intensity": "12996.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "58",
                                "monoisotopic_mass": "4491.1481",
                                "monoisotopic_mz": "642.5999",
                                "intensity": "27373.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "59",
                                "monoisotopic_mass": "1225.1731",
                                "monoisotopic_mz": "613.5938",
                                "intensity": "19482.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "60",
                                "monoisotopic_mass": "1494.9078",
                                "monoisotopic_mz": "499.3099",
                                "intensity": "13975.40",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0351508038",
                                        "theoretical_mass": "1494.9143",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0065",
                                        "ppm": "-4.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "61",
                                "monoisotopic_mass": "1856.0533",
                                "monoisotopic_mz": "619.6917",
                                "intensity": "20883.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "62",
                                "monoisotopic_mass": "2460.7910",
                                "monoisotopic_mz": "616.2050",
                                "intensity": "45896.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "63",
                                "monoisotopic_mass": "680.1018",
                                "monoisotopic_mz": "681.1090",
                                "intensity": "9378.55",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5847",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "232",
                                        "peak_id": "37",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "232",
                                        "peak_id": "49",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "232",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "232",
                                            "peak_id": "48",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "232",
                                        "peak_id": "54",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "232",
                                        "peak_id": "44",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "232",
                                            "peak_id": "60",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "spec_id": "232",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "spec_id": "232",
                                        "peak_id": "30",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "232",
                                            "peak_id": "3",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "232",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "232",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "232",
                                            "peak_id": "39",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "232",
                                        "peak_id": "31",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "232",
                                        "peak_id": "12",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "232",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "232",
                                            "peak_id": "47",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "232",
                                        "peak_id": "51",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "232",
                                        "peak_id": "16",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "10",
                            "anno": "-117.0352",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "34",
                "p_value": "6.71e-11",
                "e_value": "6.71e-11",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "281",
                        "ms1_scans": "547",
                        "ids": "265",
                        "scans": "548",
                        "precursor_mono_mass": "6250.5400",
                        "precursor_charge": "12",
                        "precursor_mz": "521.8856",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "265",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6243",
                                "monoisotopic_mz": "595.4603",
                                "intensity": "392678.46",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0462",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "1",
                                "monoisotopic_mass": "4443.4720",
                                "monoisotopic_mz": "556.4413",
                                "intensity": "127598.32",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "4443.5018",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0298",
                                        "ppm": "-6.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "2",
                                "monoisotopic_mass": "4737.6175",
                                "monoisotopic_mz": "593.2095",
                                "intensity": "169118.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0677",
                                "monoisotopic_mz": "452.7742",
                                "intensity": "114644.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0155",
                                        "ppm": "-8.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "4",
                                "monoisotopic_mass": "1807.0665",
                                "monoisotopic_mz": "603.3628",
                                "intensity": "137495.57",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0167",
                                        "ppm": "-9.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "5",
                                "monoisotopic_mass": "4719.5979",
                                "monoisotopic_mz": "590.9570",
                                "intensity": "69140.20",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "6",
                                "monoisotopic_mass": "4425.4642",
                                "monoisotopic_mz": "554.1903",
                                "intensity": "47966.85",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "7",
                                "monoisotopic_mass": "1423.8751",
                                "monoisotopic_mz": "475.6323",
                                "intensity": "89057.47",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "1423.8774",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0024",
                                        "ppm": "-1.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "8",
                                "monoisotopic_mass": "4698.5955",
                                "monoisotopic_mz": "588.3317",
                                "intensity": "45140.82",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4698.6490",
                                        "ion_position": "16",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0535",
                                        "ppm": "-11.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "9",
                                "monoisotopic_mass": "2948.5606",
                                "monoisotopic_mz": "590.7194",
                                "intensity": "69127.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "10",
                                "monoisotopic_mass": "1405.8642",
                                "monoisotopic_mz": "469.6287",
                                "intensity": "47632.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "11",
                                "monoisotopic_mass": "4808.6467",
                                "monoisotopic_mz": "602.0881",
                                "intensity": "42880.52",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "12",
                                "monoisotopic_mass": "1789.0568",
                                "monoisotopic_mz": "597.3596",
                                "intensity": "43763.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "13",
                                "monoisotopic_mass": "1789.0566",
                                "monoisotopic_mz": "448.2714",
                                "intensity": "39182.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "14",
                                "monoisotopic_mass": "5792.2237",
                                "monoisotopic_mz": "580.2296",
                                "intensity": "21821.51",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "5792.2633",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0397",
                                        "ppm": "-6.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "15",
                                "monoisotopic_mass": "4826.6594",
                                "monoisotopic_mz": "604.3397",
                                "intensity": "25652.15",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0482",
                                        "ppm": "-9.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "16",
                                "monoisotopic_mass": "2929.5493",
                                "monoisotopic_mz": "586.9171",
                                "intensity": "30993.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "17",
                                "monoisotopic_mass": "4680.5857",
                                "monoisotopic_mz": "586.0805",
                                "intensity": "16632.57",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "18",
                                "monoisotopic_mass": "5773.2025",
                                "monoisotopic_mz": "578.3275",
                                "intensity": "15965.15",
                                "charge": "10"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "19",
                                "monoisotopic_mass": "5112.8635",
                                "monoisotopic_mz": "569.1032",
                                "intensity": "14390.27",
                                "charge": "9"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "20",
                                "monoisotopic_mass": "1336.8448",
                                "monoisotopic_mz": "446.6222",
                                "intensity": "17846.79",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "1336.8454",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "21",
                                "monoisotopic_mass": "4790.6481",
                                "monoisotopic_mz": "599.8383",
                                "intensity": "17068.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "22",
                                "monoisotopic_mass": "1249.8130",
                                "monoisotopic_mz": "417.6116",
                                "intensity": "19875.92",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "1249.8134",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "23",
                                "monoisotopic_mass": "4737.6033",
                                "monoisotopic_mz": "677.8077",
                                "intensity": "21185.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "24",
                                "monoisotopic_mass": "4389.4391",
                                "monoisotopic_mz": "549.6872",
                                "intensity": "10161.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "25",
                                "monoisotopic_mass": "4597.5567",
                                "monoisotopic_mz": "657.8011",
                                "intensity": "15536.10",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4597.6013",
                                        "ion_position": "17",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0446",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "26",
                                "monoisotopic_mass": "4407.4455",
                                "monoisotopic_mz": "551.9380",
                                "intensity": "14222.03",
                                "charge": "8"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "27",
                                "monoisotopic_mass": "2911.5347",
                                "monoisotopic_mz": "583.3142",
                                "intensity": "13051.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "28",
                                "monoisotopic_mass": "2438.4296",
                                "monoisotopic_mz": "488.6932",
                                "intensity": "17650.24",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0230",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "29",
                                "monoisotopic_mass": "878.5149",
                                "monoisotopic_mz": "440.2647",
                                "intensity": "11179.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0077",
                                        "ppm": "-8.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "30",
                                "monoisotopic_mass": "2931.5552",
                                "monoisotopic_mz": "733.8961",
                                "intensity": "11336.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "31",
                                "monoisotopic_mass": "5130.8944",
                                "monoisotopic_mz": "571.1067",
                                "intensity": "13633.80",
                                "charge": "9"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "32",
                                "monoisotopic_mass": "2948.5627",
                                "monoisotopic_mz": "738.1480",
                                "intensity": "14732.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "33",
                                "monoisotopic_mass": "4093.3536",
                                "monoisotopic_mz": "683.2329",
                                "intensity": "10379.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0356",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "34",
                                "monoisotopic_mass": "1210.7330",
                                "monoisotopic_mz": "606.3738",
                                "intensity": "12028.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "35",
                                "monoisotopic_mass": "4424.4562",
                                "monoisotopic_mz": "633.0725",
                                "intensity": "10402.73",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "36",
                                "monoisotopic_mass": "3000.5917",
                                "monoisotopic_mz": "601.1256",
                                "intensity": "7948.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "37",
                                "monoisotopic_mass": "4719.6017",
                                "monoisotopic_mz": "675.2361",
                                "intensity": "10733.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "38",
                                "monoisotopic_mass": "4389.4304",
                                "monoisotopic_mz": "488.7218",
                                "intensity": "5299.25",
                                "charge": "9"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "39",
                                "monoisotopic_mass": "1476.9030",
                                "monoisotopic_mz": "370.2330",
                                "intensity": "12072.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "40",
                                "monoisotopic_mass": "2596.4136",
                                "monoisotopic_mz": "650.1107",
                                "intensity": "7203.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "41",
                                "monoisotopic_mass": "1430.8980",
                                "monoisotopic_mz": "358.7318",
                                "intensity": "8293.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "42",
                                "monoisotopic_mass": "3991.2913",
                                "monoisotopic_mz": "666.2225",
                                "intensity": "8279.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "43",
                                "monoisotopic_mass": "1318.8320",
                                "monoisotopic_mz": "440.6179",
                                "intensity": "9403.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "44",
                                "monoisotopic_mass": "973.5883",
                                "monoisotopic_mz": "487.8015",
                                "intensity": "6124.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "45",
                                "monoisotopic_mass": "1338.8211",
                                "monoisotopic_mz": "670.4178",
                                "intensity": "7753.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "46",
                                "monoisotopic_mass": "2290.7705",
                                "monoisotopic_mz": "573.6999",
                                "intensity": "5779.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "47",
                                "monoisotopic_mass": "1164.7611",
                                "monoisotopic_mz": "583.3878",
                                "intensity": "8340.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "48",
                                "monoisotopic_mass": "1091.6129",
                                "monoisotopic_mz": "546.8137",
                                "intensity": "5173.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "49",
                                "monoisotopic_mass": "1981.2867",
                                "monoisotopic_mz": "199.1359",
                                "intensity": "6053.35",
                                "charge": "10"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "50",
                                "monoisotopic_mass": "1150.7442",
                                "monoisotopic_mz": "576.3794",
                                "intensity": "3960.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "1150.7450",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "51",
                                "monoisotopic_mass": "1611.9529",
                                "monoisotopic_mz": "538.3249",
                                "intensity": "8318.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "52",
                                "monoisotopic_mass": "5865.1096",
                                "monoisotopic_mz": "587.5182",
                                "intensity": "5324.09",
                                "charge": "10"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "53",
                                "monoisotopic_mass": "3811.0961",
                                "monoisotopic_mz": "545.4496",
                                "intensity": "10323.90",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "54",
                                "monoisotopic_mass": "1387.8521",
                                "monoisotopic_mz": "463.6246",
                                "intensity": "3949.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "55",
                                "monoisotopic_mass": "1221.8212",
                                "monoisotopic_mz": "408.2810",
                                "intensity": "4021.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "56",
                                "monoisotopic_mass": "1108.1164",
                                "monoisotopic_mz": "555.0655",
                                "intensity": "5070.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "57",
                                "monoisotopic_mass": "5472.0004",
                                "monoisotopic_mz": "548.2073",
                                "intensity": "4569.57",
                                "charge": "10"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "58",
                                "monoisotopic_mass": "3795.0914",
                                "monoisotopic_mz": "543.1632",
                                "intensity": "6462.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "59",
                                "monoisotopic_mass": "1458.8925",
                                "monoisotopic_mz": "365.7304",
                                "intensity": "4273.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "60",
                                "monoisotopic_mass": "1376.8161",
                                "monoisotopic_mz": "345.2113",
                                "intensity": "4878.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "61",
                                "monoisotopic_mass": "5280.5229",
                                "monoisotopic_mz": "587.7320",
                                "intensity": "4893.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "62",
                                "monoisotopic_mass": "1387.4079",
                                "monoisotopic_mz": "199.2084",
                                "intensity": "3718.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "63",
                                "monoisotopic_mass": "1249.8130",
                                "monoisotopic_mz": "625.9138",
                                "intensity": "7317.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0348708038",
                                        "theoretical_mass": "1249.8134",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "64",
                                "monoisotopic_mass": "1062.9629",
                                "monoisotopic_mz": "532.4887",
                                "intensity": "5929.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "265",
                                "peak_id": "65",
                                "monoisotopic_mass": "4114.5169",
                                "monoisotopic_mz": "588.7954",
                                "intensity": "23723.41",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5850",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "265",
                                        "peak_id": "50",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "265",
                                            "peak_id": "63",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "265",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "265",
                                        "peak_id": "20",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "265",
                                            "peak_id": "7",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "41",
                                            "spec_id": "265",
                                            "peak_id": "15",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "spec_id": "265",
                                        "peak_id": "0",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "39",
                                        "spec_id": "265",
                                        "peak_id": "8",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "38",
                                        "spec_id": "265",
                                        "peak_id": "25",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "spec_id": "265",
                                        "peak_id": "33",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "spec_id": "265",
                                        "peak_id": "28",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "265",
                                            "peak_id": "4",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "265",
                                            "peak_id": "3",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "265",
                                            "peak_id": "1",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "265",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "265",
                                        "peak_id": "14",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "11",
                            "anno": "-117.0349",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "27",
                "p_value": "1.29e-10",
                "e_value": "1.29e-10",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "251",
                        "ms1_scans": "487",
                        "ids": "235",
                        "scans": "488",
                        "precursor_mono_mass": "6250.5386",
                        "precursor_charge": "12",
                        "precursor_mz": "521.8855",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "235",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6253",
                                "monoisotopic_mz": "595.4604",
                                "intensity": "702738.66",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0452",
                                        "ppm": "-9.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6150",
                                "monoisotopic_mz": "593.2092",
                                "intensity": "352606.82",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4705",
                                "monoisotopic_mz": "556.4411",
                                "intensity": "261256.73",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "4443.5003",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0298",
                                        "ppm": "-6.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0664",
                                "monoisotopic_mz": "603.3627",
                                "intensity": "227156.01",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0169",
                                        "ppm": "-9.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "4",
                                "monoisotopic_mass": "1807.0675",
                                "monoisotopic_mz": "452.7742",
                                "intensity": "217548.19",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0157",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "5",
                                "monoisotopic_mass": "4425.4608",
                                "monoisotopic_mz": "554.1899",
                                "intensity": "106415.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "6",
                                "monoisotopic_mass": "4719.6057",
                                "monoisotopic_mz": "590.9580",
                                "intensity": "121180.31",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "7",
                                "monoisotopic_mass": "1423.8750",
                                "monoisotopic_mz": "475.6323",
                                "intensity": "166167.12",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "1423.8760",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "8",
                                "monoisotopic_mass": "4699.6004",
                                "monoisotopic_mz": "588.4573",
                                "intensity": "94783.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "9",
                                "monoisotopic_mass": "2948.5606",
                                "monoisotopic_mz": "590.7194",
                                "intensity": "124379.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "10",
                                "monoisotopic_mass": "1789.0568",
                                "monoisotopic_mz": "448.2715",
                                "intensity": "81005.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "11",
                                "monoisotopic_mass": "1789.0561",
                                "monoisotopic_mz": "597.3593",
                                "intensity": "75711.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "12",
                                "monoisotopic_mass": "4808.6541",
                                "monoisotopic_mz": "602.0890",
                                "intensity": "77072.42",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "13",
                                "monoisotopic_mass": "1405.8639",
                                "monoisotopic_mz": "469.6286",
                                "intensity": "92359.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "14",
                                "monoisotopic_mass": "2929.5462",
                                "monoisotopic_mz": "586.9165",
                                "intensity": "52059.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "15",
                                "monoisotopic_mass": "5791.2226",
                                "monoisotopic_mz": "580.1295",
                                "intensity": "37977.87",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "5792.2619",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0370",
                                        "ppm": "-6.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "16",
                                "monoisotopic_mass": "5159.8745",
                                "monoisotopic_mz": "574.3267",
                                "intensity": "44388.60",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "5159.9085",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0340",
                                        "ppm": "-6.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "17",
                                "monoisotopic_mass": "5130.8730",
                                "monoisotopic_mz": "571.1043",
                                "intensity": "35911.19",
                                "charge": "9"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "18",
                                "monoisotopic_mass": "4826.6624",
                                "monoisotopic_mz": "604.3401",
                                "intensity": "40852.02",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0452",
                                        "ppm": "-9.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "19",
                                "monoisotopic_mass": "4790.6390",
                                "monoisotopic_mz": "599.8372",
                                "intensity": "33313.11",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "20",
                                "monoisotopic_mass": "4680.5828",
                                "monoisotopic_mz": "586.0801",
                                "intensity": "43108.06",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "21",
                                "monoisotopic_mass": "1336.8438",
                                "monoisotopic_mz": "446.6219",
                                "intensity": "30420.04",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "1336.8440",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "22",
                                "monoisotopic_mass": "4597.5447",
                                "monoisotopic_mz": "657.7994",
                                "intensity": "51631.66",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4597.6013",
                                        "ion_position": "17",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0566",
                                        "ppm": "-12.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "23",
                                "monoisotopic_mass": "4755.6202",
                                "monoisotopic_mz": "680.3816",
                                "intensity": "27686.64",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0502",
                                        "ppm": "-10.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "24",
                                "monoisotopic_mass": "4596.5565",
                                "monoisotopic_mz": "575.5768",
                                "intensity": "34313.84",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "25",
                                "monoisotopic_mass": "4756.6377",
                                "monoisotopic_mz": "529.5226",
                                "intensity": "21776.85",
                                "charge": "9"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "26",
                                "monoisotopic_mass": "4737.6123",
                                "monoisotopic_mz": "677.8090",
                                "intensity": "35235.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "27",
                                "monoisotopic_mass": "1249.8128",
                                "monoisotopic_mz": "417.6115",
                                "intensity": "34299.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "1249.8119",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0009",
                                        "ppm": "0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "28",
                                "monoisotopic_mass": "2948.5593",
                                "monoisotopic_mz": "738.1471",
                                "intensity": "19523.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "29",
                                "monoisotopic_mass": "2930.5486",
                                "monoisotopic_mz": "733.6444",
                                "intensity": "25458.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "30",
                                "monoisotopic_mass": "2437.4257",
                                "monoisotopic_mz": "488.4924",
                                "intensity": "26613.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "31",
                                "monoisotopic_mass": "1610.9476",
                                "monoisotopic_mz": "537.9898",
                                "intensity": "26675.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0145",
                                        "ppm": "-9.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "32",
                                "monoisotopic_mass": "1678.9735",
                                "monoisotopic_mz": "560.6651",
                                "intensity": "16968.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "33",
                                "monoisotopic_mass": "5773.1925",
                                "monoisotopic_mz": "578.3265",
                                "intensity": "25158.36",
                                "charge": "10"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "34",
                                "monoisotopic_mass": "1318.8327",
                                "monoisotopic_mz": "440.6182",
                                "intensity": "19086.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "35",
                                "monoisotopic_mass": "4389.4342",
                                "monoisotopic_mz": "549.6865",
                                "intensity": "24250.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "36",
                                "monoisotopic_mass": "2271.2742",
                                "monoisotopic_mz": "568.8258",
                                "intensity": "19940.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "37",
                                "monoisotopic_mass": "587.3589",
                                "monoisotopic_mz": "588.3661",
                                "intensity": "16033.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0054",
                                        "ppm": "-9.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "38",
                                "monoisotopic_mass": "2913.5465",
                                "monoisotopic_mz": "583.7166",
                                "intensity": "18568.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "39",
                                "monoisotopic_mass": "4076.3076",
                                "monoisotopic_mz": "680.3919",
                                "intensity": "13812.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "40",
                                "monoisotopic_mass": "1476.9016",
                                "monoisotopic_mz": "370.2327",
                                "intensity": "15019.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "41",
                                "monoisotopic_mass": "1249.8116",
                                "monoisotopic_mz": "625.9131",
                                "intensity": "10279.80",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "1249.8119",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "42",
                                "monoisotopic_mass": "469.2899",
                                "monoisotopic_mz": "470.2972",
                                "intensity": "6502.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "43",
                                "monoisotopic_mass": "2179.6063",
                                "monoisotopic_mz": "199.1533",
                                "intensity": "10862.16",
                                "charge": "11"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "44",
                                "monoisotopic_mass": "928.5510",
                                "monoisotopic_mz": "465.2828",
                                "intensity": "10463.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "45",
                                "monoisotopic_mass": "878.5152",
                                "monoisotopic_mz": "440.2649",
                                "intensity": "12734.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0074",
                                        "ppm": "-8.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "46",
                                "monoisotopic_mass": "716.4015",
                                "monoisotopic_mz": "717.4088",
                                "intensity": "10960.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "47",
                                "monoisotopic_mass": "815.4700",
                                "monoisotopic_mz": "408.7423",
                                "intensity": "12810.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "48",
                                "monoisotopic_mass": "4579.5662",
                                "monoisotopic_mz": "655.2310",
                                "intensity": "20829.01",
                                "charge": "7"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "49",
                                "monoisotopic_mass": "4718.5993",
                                "monoisotopic_mz": "675.0929",
                                "intensity": "25991.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "50",
                                "monoisotopic_mass": "3001.5779",
                                "monoisotopic_mz": "601.3229",
                                "intensity": "25766.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "51",
                                "monoisotopic_mass": "688.4082",
                                "monoisotopic_mz": "345.2114",
                                "intensity": "8638.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "52",
                                "monoisotopic_mass": "1210.7330",
                                "monoisotopic_mz": "606.3738",
                                "intensity": "17671.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "53",
                                "monoisotopic_mass": "1494.9124",
                                "monoisotopic_mz": "374.7354",
                                "intensity": "7150.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0363308038",
                                        "theoretical_mass": "1494.9131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "54",
                                "monoisotopic_mass": "4407.4556",
                                "monoisotopic_mz": "551.9392",
                                "intensity": "20458.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "55",
                                "monoisotopic_mass": "2438.4268",
                                "monoisotopic_mz": "610.6140",
                                "intensity": "8932.76",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0258",
                                        "ppm": "-10.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "56",
                                "monoisotopic_mass": "1281.7633",
                                "monoisotopic_mz": "641.8889",
                                "intensity": "8252.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "57",
                                "monoisotopic_mass": "2285.2889",
                                "monoisotopic_mz": "762.7702",
                                "intensity": "13260.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "58",
                                "monoisotopic_mass": "2378.4498",
                                "monoisotopic_mz": "199.2114",
                                "intensity": "5555.67",
                                "charge": "12"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "59",
                                "monoisotopic_mass": "1784.0033",
                                "monoisotopic_mz": "199.2299",
                                "intensity": "13027.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "60",
                                "monoisotopic_mass": "1225.1742",
                                "monoisotopic_mz": "613.5944",
                                "intensity": "7023.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "61",
                                "monoisotopic_mass": "1338.8200",
                                "monoisotopic_mz": "670.4173",
                                "intensity": "15122.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "62",
                                "monoisotopic_mass": "1386.8752",
                                "monoisotopic_mz": "199.1323",
                                "intensity": "5548.34",
                                "charge": "7"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "63",
                                "monoisotopic_mass": "1101.3720",
                                "monoisotopic_mz": "551.6933",
                                "intensity": "9649.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "64",
                                "monoisotopic_mass": "973.5877",
                                "monoisotopic_mz": "487.8011",
                                "intensity": "12272.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "65",
                                "monoisotopic_mass": "3428.9291",
                                "monoisotopic_mz": "572.4955",
                                "intensity": "15029.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "66",
                                "monoisotopic_mass": "1221.8155",
                                "monoisotopic_mz": "408.2791",
                                "intensity": "6067.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "67",
                                "monoisotopic_mass": "3139.6316",
                                "monoisotopic_mz": "628.9336",
                                "intensity": "11432.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "68",
                                "monoisotopic_mass": "3610.2167",
                                "monoisotopic_mz": "602.7101",
                                "intensity": "11883.21",
                                "charge": "6"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "69",
                                "monoisotopic_mass": "1430.8989",
                                "monoisotopic_mz": "358.7320",
                                "intensity": "12870.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "70",
                                "monoisotopic_mass": "1144.1500",
                                "monoisotopic_mz": "573.0823",
                                "intensity": "6261.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "71",
                                "monoisotopic_mass": "2794.5795",
                                "monoisotopic_mz": "559.9232",
                                "intensity": "8635.87",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5836",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "235",
                                            "peak_id": "41",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "235",
                                            "peak_id": "27",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "235",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "235",
                                            "peak_id": "7",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "41",
                                            "spec_id": "235",
                                            "peak_id": "18",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "235",
                                            "peak_id": "53",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "spec_id": "235",
                                            "peak_id": "23",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "spec_id": "235",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "38",
                                        "spec_id": "235",
                                        "peak_id": "22",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "spec_id": "235",
                                        "peak_id": "55",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "235",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "235",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "235",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "235",
                                        "peak_id": "31",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "235",
                                        "peak_id": "16",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "235",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "spec_id": "235",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "235",
                                        "peak_id": "15",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "12",
                            "anno": "-117.0363",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "25",
                "p_value": "4.90e-09",
                "e_value": "4.90e-09",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "236",
                        "ms1_scans": "457",
                        "ids": "220",
                        "scans": "458",
                        "precursor_mono_mass": "6250.5305",
                        "precursor_charge": "12",
                        "precursor_mz": "521.8848",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "220",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6238",
                                "monoisotopic_mz": "595.4603",
                                "intensity": "1003584.06",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0467",
                                        "ppm": "-9.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6121",
                                "monoisotopic_mz": "593.2088",
                                "intensity": "493254.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4735",
                                "monoisotopic_mz": "556.4415",
                                "intensity": "312090.50",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "4443.5023",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0288",
                                        "ppm": "-6.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0665",
                                "monoisotopic_mz": "603.3628",
                                "intensity": "334125.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0167",
                                        "ppm": "-9.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "4",
                                "monoisotopic_mass": "1807.0674",
                                "monoisotopic_mz": "452.7741",
                                "intensity": "300462.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "39",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0159",
                                        "ppm": "-8.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "5",
                                "monoisotopic_mass": "4719.6077",
                                "monoisotopic_mz": "590.9582",
                                "intensity": "155773.60",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "6",
                                "monoisotopic_mass": "1423.8743",
                                "monoisotopic_mz": "475.6320",
                                "intensity": "250554.41",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1423.8779",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0036",
                                        "ppm": "-2.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "7",
                                "monoisotopic_mass": "4425.4622",
                                "monoisotopic_mz": "554.1901",
                                "intensity": "170615.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "8",
                                "monoisotopic_mass": "1405.8642",
                                "monoisotopic_mz": "469.6287",
                                "intensity": "134459.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "9",
                                "monoisotopic_mass": "2948.5597",
                                "monoisotopic_mz": "590.7192",
                                "intensity": "176275.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "10",
                                "monoisotopic_mass": "4699.5999",
                                "monoisotopic_mz": "588.4573",
                                "intensity": "107671.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "11",
                                "monoisotopic_mass": "1789.0568",
                                "monoisotopic_mz": "448.2715",
                                "intensity": "104569.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "12",
                                "monoisotopic_mass": "1788.0539",
                                "monoisotopic_mz": "597.0253",
                                "intensity": "120144.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "13",
                                "monoisotopic_mass": "4808.6418",
                                "monoisotopic_mz": "602.0875",
                                "intensity": "152369.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "14",
                                "monoisotopic_mass": "4826.6619",
                                "monoisotopic_mz": "604.3400",
                                "intensity": "64329.32",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "13",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0457",
                                        "ppm": "-9.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "15",
                                "monoisotopic_mass": "4755.6407",
                                "monoisotopic_mz": "680.3845",
                                "intensity": "34404.70",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "14",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0298",
                                        "ppm": "-6.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "16",
                                "monoisotopic_mass": "4407.4601",
                                "monoisotopic_mz": "551.9398",
                                "intensity": "44829.82",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "17",
                                "monoisotopic_mass": "2895.6094",
                                "monoisotopic_mz": "580.1292",
                                "intensity": "42779.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "18",
                                "monoisotopic_mass": "4790.6463",
                                "monoisotopic_mz": "599.8381",
                                "intensity": "43744.98",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "19",
                                "monoisotopic_mass": "2439.4296",
                                "monoisotopic_mz": "488.8932",
                                "intensity": "22950.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "20",
                                "monoisotopic_mass": "5776.2130",
                                "monoisotopic_mz": "578.6286",
                                "intensity": "25850.33",
                                "charge": "10"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "21",
                                "monoisotopic_mass": "1476.9006",
                                "monoisotopic_mz": "370.2324",
                                "intensity": "26865.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "22",
                                "monoisotopic_mass": "1249.8117",
                                "monoisotopic_mz": "417.6112",
                                "intensity": "60211.07",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1249.8139",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0022",
                                        "ppm": "-1.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "23",
                                "monoisotopic_mass": "2930.5414",
                                "monoisotopic_mz": "587.1156",
                                "intensity": "61310.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "24",
                                "monoisotopic_mass": "2438.4316",
                                "monoisotopic_mz": "610.6152",
                                "intensity": "22389.81",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0210",
                                        "ppm": "-8.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "25",
                                "monoisotopic_mass": "1210.7306",
                                "monoisotopic_mz": "606.3726",
                                "intensity": "25894.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "26",
                                "monoisotopic_mass": "1610.9469",
                                "monoisotopic_mz": "537.9896",
                                "intensity": "37600.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "41",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0152",
                                        "ppm": "-9.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "27",
                                "monoisotopic_mass": "2948.5590",
                                "monoisotopic_mz": "738.1470",
                                "intensity": "30846.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "28",
                                "monoisotopic_mass": "2930.5503",
                                "monoisotopic_mz": "733.6448",
                                "intensity": "42353.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "29",
                                "monoisotopic_mass": "2340.7952",
                                "monoisotopic_mz": "586.2061",
                                "intensity": "19163.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "30",
                                "monoisotopic_mass": "1336.8457",
                                "monoisotopic_mz": "446.6225",
                                "intensity": "34638.98",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "1336.8459",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "31",
                                "monoisotopic_mass": "2913.5526",
                                "monoisotopic_mz": "583.7178",
                                "intensity": "27822.43",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "32",
                                "monoisotopic_mass": "5113.8656",
                                "monoisotopic_mz": "569.2146",
                                "intensity": "31325.51",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "5113.8462",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0194",
                                        "ppm": "3.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "33",
                                "monoisotopic_mass": "1164.7578",
                                "monoisotopic_mz": "583.3862",
                                "intensity": "18099.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "34",
                                "monoisotopic_mass": "5159.8766",
                                "monoisotopic_mz": "574.3269",
                                "intensity": "21880.74",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "14.0060942847",
                                        "theoretical_mass": "5159.9105",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0339",
                                        "ppm": "-6.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "35",
                                "monoisotopic_mass": "4424.4754",
                                "monoisotopic_mz": "633.0752",
                                "intensity": "25771.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "36",
                                "monoisotopic_mass": "2180.4428",
                                "monoisotopic_mz": "199.2294",
                                "intensity": "21130.99",
                                "charge": "11"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "37",
                                "monoisotopic_mass": "4627.5268",
                                "monoisotopic_mz": "662.0825",
                                "intensity": "23570.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "38",
                                "monoisotopic_mass": "1149.6403",
                                "monoisotopic_mz": "575.8275",
                                "intensity": "16612.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "39",
                                "monoisotopic_mass": "548.8047",
                                "monoisotopic_mz": "549.8119",
                                "intensity": "18109.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "40",
                                "monoisotopic_mass": "1783.9240",
                                "monoisotopic_mz": "199.2211",
                                "intensity": "23657.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "41",
                                "monoisotopic_mass": "5278.5336",
                                "monoisotopic_mz": "587.5110",
                                "intensity": "30860.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "42",
                                "monoisotopic_mass": "1061.9587",
                                "monoisotopic_mz": "531.9866",
                                "intensity": "15763.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "43",
                                "monoisotopic_mass": "1298.2064",
                                "monoisotopic_mz": "650.1105",
                                "intensity": "15878.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "44",
                                "monoisotopic_mass": "1463.1431",
                                "monoisotopic_mz": "488.7216",
                                "intensity": "15589.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "45",
                                "monoisotopic_mass": "973.5856",
                                "monoisotopic_mz": "487.8001",
                                "intensity": "19887.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "46",
                                "monoisotopic_mass": "4226.8884",
                                "monoisotopic_mz": "529.3683",
                                "intensity": "35138.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "47",
                                "monoisotopic_mass": "1458.8930",
                                "monoisotopic_mz": "365.7305",
                                "intensity": "13321.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "48",
                                "monoisotopic_mass": "1281.7651",
                                "monoisotopic_mz": "641.8898",
                                "intensity": "13724.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "49",
                                "monoisotopic_mass": "1224.4220",
                                "monoisotopic_mz": "613.2183",
                                "intensity": "11040.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "50",
                                "monoisotopic_mass": "4024.4893",
                                "monoisotopic_mz": "575.9343",
                                "intensity": "41346.37",
                                "charge": "7"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "51",
                                "monoisotopic_mass": "1317.7746",
                                "monoisotopic_mz": "440.2655",
                                "intensity": "21976.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "52",
                                "monoisotopic_mass": "1387.4813",
                                "monoisotopic_mz": "199.2189",
                                "intensity": "21548.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "53",
                                "monoisotopic_mass": "624.9048",
                                "monoisotopic_mz": "625.9120",
                                "intensity": "20064.98",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5855",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "1",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "44",
                                        "spec_id": "220",
                                        "peak_id": "32",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "220",
                                        "peak_id": "22",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "220",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "220",
                                            "peak_id": "6",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "41",
                                            "spec_id": "220",
                                            "peak_id": "14",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "40",
                                            "spec_id": "220",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "40",
                                            "spec_id": "220",
                                            "peak_id": "15",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "20",
                                        "spec_id": "220",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "220",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "15",
                                            "spec_id": "220",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "220",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "13",
                                        "spec_id": "220",
                                        "peak_id": "26",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "220",
                                        "peak_id": "34",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "11",
                            "right_position": "12",
                            "anno": "14.0061",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "24",
                "p_value": "1.39e-07",
                "e_value": "1.39e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "232",
                        "ms1_scans": "449",
                        "ids": "216",
                        "scans": "450",
                        "precursor_mono_mass": "6250.5521",
                        "precursor_charge": "11",
                        "precursor_mz": "569.2393",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "216",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4678",
                                "monoisotopic_mz": "635.7884",
                                "intensity": "896684.57",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0327708038",
                                        "theoretical_mass": "4443.5039",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0360",
                                        "ppm": "-8.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "1",
                                "monoisotopic_mass": "1807.0673",
                                "monoisotopic_mz": "603.3630",
                                "intensity": "904007.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0160",
                                        "ppm": "-8.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "2",
                                "monoisotopic_mass": "1789.0561",
                                "monoisotopic_mz": "597.3593",
                                "intensity": "375290.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0669",
                                "monoisotopic_mz": "452.7740",
                                "intensity": "398571.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0164",
                                        "ppm": "-9.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "4",
                                "monoisotopic_mass": "4230.3287",
                                "monoisotopic_mz": "605.3400",
                                "intensity": "144997.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "5",
                                "monoisotopic_mass": "1789.0580",
                                "monoisotopic_mz": "448.2718",
                                "intensity": "172187.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "6",
                                "monoisotopic_mass": "2948.5544",
                                "monoisotopic_mz": "738.1459",
                                "intensity": "182995.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "7",
                                "monoisotopic_mass": "1249.8135",
                                "monoisotopic_mz": "417.6118",
                                "intensity": "110653.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0327708038",
                                        "theoretical_mass": "1249.8155",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0020",
                                        "ppm": "-1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "8",
                                "monoisotopic_mass": "4736.6031",
                                "monoisotopic_mz": "677.6649",
                                "intensity": "179561.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "9",
                                "monoisotopic_mass": "4426.4643",
                                "monoisotopic_mz": "633.3593",
                                "intensity": "96905.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "10",
                                "monoisotopic_mass": "4358.4261",
                                "monoisotopic_mz": "623.6396",
                                "intensity": "173231.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "11",
                                "monoisotopic_mass": "4755.6317",
                                "monoisotopic_mz": "680.3832",
                                "intensity": "196314.65",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0387",
                                        "ppm": "-8.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "12",
                                "monoisotopic_mass": "3193.6592",
                                "monoisotopic_mz": "799.4221",
                                "intensity": "92377.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "13",
                                "monoisotopic_mass": "3019.5915",
                                "monoisotopic_mz": "755.9052",
                                "intensity": "119391.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "14",
                                "monoisotopic_mass": "815.4700",
                                "monoisotopic_mz": "408.7423",
                                "intensity": "97261.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "15",
                                "monoisotopic_mass": "2286.2839",
                                "monoisotopic_mz": "763.1019",
                                "intensity": "62418.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "16",
                                "monoisotopic_mass": "4230.3289",
                                "monoisotopic_mz": "706.0621",
                                "intensity": "93525.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "17",
                                "monoisotopic_mass": "716.4017",
                                "monoisotopic_mz": "717.4090",
                                "intensity": "61669.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "18",
                                "monoisotopic_mass": "2597.4172",
                                "monoisotopic_mz": "650.3616",
                                "intensity": "49104.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "19",
                                "monoisotopic_mass": "1037.6628",
                                "monoisotopic_mz": "519.8387",
                                "intensity": "62664.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0327708038",
                                        "theoretical_mass": "1037.6630",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "20",
                                "monoisotopic_mass": "6124.4674",
                                "monoisotopic_mz": "613.4540",
                                "intensity": "69074.44",
                                "charge": "10"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "21",
                                "monoisotopic_mass": "2179.5848",
                                "monoisotopic_mz": "199.1514",
                                "intensity": "102411.84",
                                "charge": "11"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "22",
                                "monoisotopic_mass": "2472.3338",
                                "monoisotopic_mz": "619.0907",
                                "intensity": "38014.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "23",
                                "monoisotopic_mass": "1660.9682",
                                "monoisotopic_mz": "831.4914",
                                "intensity": "83979.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "24",
                                "monoisotopic_mass": "1336.8465",
                                "monoisotopic_mz": "446.6228",
                                "intensity": "43834.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0327708038",
                                        "theoretical_mass": "1336.8475",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "25",
                                "monoisotopic_mass": "1236.1656",
                                "monoisotopic_mz": "619.0901",
                                "intensity": "35098.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "26",
                                "monoisotopic_mass": "1847.0566",
                                "monoisotopic_mz": "616.6928",
                                "intensity": "45675.33",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0327708038",
                                        "theoretical_mass": "1847.0662",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0096",
                                        "ppm": "-5.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "27",
                                "monoisotopic_mass": "991.5976",
                                "monoisotopic_mz": "496.8061",
                                "intensity": "64593.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0091",
                                        "ppm": "-9.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "28",
                                "monoisotopic_mass": "1453.1417",
                                "monoisotopic_mz": "727.5781",
                                "intensity": "48285.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "29",
                                "monoisotopic_mass": "4341.3969",
                                "monoisotopic_mz": "621.2068",
                                "intensity": "108377.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "30",
                                "monoisotopic_mass": "1330.7438",
                                "monoisotopic_mz": "666.3792",
                                "intensity": "39904.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "31",
                                "monoisotopic_mass": "1784.0641",
                                "monoisotopic_mz": "199.2366",
                                "intensity": "50986.28",
                                "charge": "9"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "32",
                                "monoisotopic_mass": "3000.5782",
                                "monoisotopic_mz": "751.1518",
                                "intensity": "44292.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "33",
                                "monoisotopic_mass": "928.5520",
                                "monoisotopic_mz": "465.2833",
                                "intensity": "59013.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "34",
                                "monoisotopic_mass": "1290.2144",
                                "monoisotopic_mz": "646.1145",
                                "intensity": "27700.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "35",
                                "monoisotopic_mass": "1164.7637",
                                "monoisotopic_mz": "583.3891",
                                "intensity": "30807.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "36",
                                "monoisotopic_mass": "1465.7763",
                                "monoisotopic_mz": "733.8954",
                                "intensity": "31138.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "37",
                                "monoisotopic_mass": "1495.9150",
                                "monoisotopic_mz": "499.6456",
                                "intensity": "29226.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "216",
                                "peak_id": "38",
                                "monoisotopic_mass": "632.3660",
                                "monoisotopic_mz": "633.3733",
                                "intensity": "50093.18",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5871",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "216",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "216",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "216",
                                        "peak_id": "24",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "spec_id": "216",
                                        "peak_id": "11",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "216",
                                        "peak_id": "26",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "216",
                                            "peak_id": "3",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "216",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "216",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "216",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "10",
                            "anno": "-117.0328",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "28",
                "p_value": "2.52e-06",
                "e_value": "2.52e-06",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "263",
                        "ms1_scans": "511",
                        "ids": "247",
                        "scans": "512",
                        "precursor_mono_mass": "6250.5306",
                        "precursor_charge": "11",
                        "precursor_mz": "569.2373",
                        "feature_inte": "3.6357e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "247",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4666",
                                "monoisotopic_mz": "635.7882",
                                "intensity": "762504.55",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0342508038",
                                        "theoretical_mass": "4443.5024",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0358",
                                        "ppm": "-8.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "1",
                                "monoisotopic_mass": "1807.0662",
                                "monoisotopic_mz": "603.3627",
                                "intensity": "679037.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0171",
                                        "ppm": "-9.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "2",
                                "monoisotopic_mass": "1789.0554",
                                "monoisotopic_mz": "597.3591",
                                "intensity": "278864.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0665",
                                "monoisotopic_mz": "452.7739",
                                "intensity": "308773.59",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0167",
                                        "ppm": "-9.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "4",
                                "monoisotopic_mass": "2948.5591",
                                "monoisotopic_mz": "738.1470",
                                "intensity": "126118.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "5",
                                "monoisotopic_mass": "4755.6223",
                                "monoisotopic_mz": "680.3819",
                                "intensity": "157030.92",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4755.6705",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0481",
                                        "ppm": "-10.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "6",
                                "monoisotopic_mass": "1788.0548",
                                "monoisotopic_mz": "448.0210",
                                "intensity": "137903.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "7",
                                "monoisotopic_mass": "4230.3253",
                                "monoisotopic_mz": "605.3395",
                                "intensity": "142774.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "8",
                                "monoisotopic_mass": "4341.4029",
                                "monoisotopic_mz": "621.2077",
                                "intensity": "61037.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "9",
                                "monoisotopic_mass": "3019.6052",
                                "monoisotopic_mz": "755.9086",
                                "intensity": "66935.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "10",
                                "monoisotopic_mass": "1249.8132",
                                "monoisotopic_mz": "417.6117",
                                "intensity": "76456.93",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0342508038",
                                        "theoretical_mass": "1249.8140",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "11",
                                "monoisotopic_mass": "4230.3212",
                                "monoisotopic_mz": "706.0608",
                                "intensity": "68195.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "12",
                                "monoisotopic_mass": "4828.6806",
                                "monoisotopic_mz": "690.8188",
                                "intensity": "55188.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "13",
                                "monoisotopic_mass": "1610.9449",
                                "monoisotopic_mz": "537.9889",
                                "intensity": "43585.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0172",
                                        "ppm": "-10.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "14",
                                "monoisotopic_mass": "2450.3483",
                                "monoisotopic_mz": "817.7900",
                                "intensity": "87232.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "15",
                                "monoisotopic_mass": "815.4694",
                                "monoisotopic_mz": "408.7420",
                                "intensity": "57994.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "16",
                                "monoisotopic_mass": "5132.8685",
                                "monoisotopic_mz": "642.6158",
                                "intensity": "84906.84",
                                "charge": "8"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "17",
                                "monoisotopic_mass": "4428.4480",
                                "monoisotopic_mz": "633.6427",
                                "intensity": "74450.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "18",
                                "monoisotopic_mass": "1981.3246",
                                "monoisotopic_mz": "199.1397",
                                "intensity": "109321.62",
                                "charge": "10"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "19",
                                "monoisotopic_mass": "2595.4093",
                                "monoisotopic_mz": "649.8596",
                                "intensity": "63130.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "20",
                                "monoisotopic_mass": "4211.3026",
                                "monoisotopic_mz": "602.6219",
                                "intensity": "33722.84",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "21",
                                "monoisotopic_mass": "3193.6610",
                                "monoisotopic_mz": "799.4225",
                                "intensity": "45161.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "22",
                                "monoisotopic_mass": "991.5987",
                                "monoisotopic_mz": "496.8066",
                                "intensity": "35026.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0079",
                                        "ppm": "-7.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "23",
                                "monoisotopic_mass": "615.6862",
                                "monoisotopic_mz": "616.6935",
                                "intensity": "32628.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "24",
                                "monoisotopic_mass": "6120.4461",
                                "monoisotopic_mz": "613.0519",
                                "intensity": "47183.45",
                                "charge": "10"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "25",
                                "monoisotopic_mass": "2930.5539",
                                "monoisotopic_mz": "733.6458",
                                "intensity": "56638.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "26",
                                "monoisotopic_mass": "1164.7611",
                                "monoisotopic_mz": "583.3878",
                                "intensity": "46038.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "27",
                                "monoisotopic_mass": "1290.2202",
                                "monoisotopic_mz": "646.1174",
                                "intensity": "25731.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "28",
                                "monoisotopic_mass": "6148.4103",
                                "monoisotopic_mz": "615.8483",
                                "intensity": "48503.91",
                                "charge": "10"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "29",
                                "monoisotopic_mass": "1037.6634",
                                "monoisotopic_mz": "519.8390",
                                "intensity": "77937.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0342508038",
                                        "theoretical_mass": "1037.6615",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0019",
                                        "ppm": "1.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "30",
                                "monoisotopic_mass": "1225.4880",
                                "monoisotopic_mz": "613.7513",
                                "intensity": "26755.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "31",
                                "monoisotopic_mass": "1387.9465",
                                "monoisotopic_mz": "199.2853",
                                "intensity": "12604.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "32",
                                "monoisotopic_mass": "878.5146",
                                "monoisotopic_mz": "879.5218",
                                "intensity": "22023.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0080",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "33",
                                "monoisotopic_mass": "2286.2916",
                                "monoisotopic_mz": "763.1045",
                                "intensity": "46806.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "34",
                                "monoisotopic_mass": "4513.6289",
                                "monoisotopic_mz": "645.8114",
                                "intensity": "46513.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "35",
                                "monoisotopic_mass": "2439.4458",
                                "monoisotopic_mz": "610.8687",
                                "intensity": "35573.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "36",
                                "monoisotopic_mass": "1336.8383",
                                "monoisotopic_mz": "446.6201",
                                "intensity": "26442.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0342508038",
                                        "theoretical_mass": "1336.8460",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0077",
                                        "ppm": "-5.76"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5856",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "247",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "247",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "247",
                                        "peak_id": "36",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "spec_id": "247",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "247",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "247",
                                            "peak_id": "3",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "247",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "247",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "247",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "247",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "10",
                            "anno": "-117.0343",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
