prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "25",
        "sequence_name": "sp|P66131|RL27_SALTY",
        "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
        "proteoform_id": "41",
        "prsm_number": "4",
        "prsm": [
            {
                "prsm_id": "44",
                "p_value": "3.28e-05",
                "e_value": "3.28e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "322",
                        "ms1_scans": "629",
                        "ids": "306",
                        "scans": "630",
                        "precursor_mono_mass": "9044.9064",
                        "precursor_charge": "16",
                        "precursor_mz": "566.3139",
                        "feature_inte": "5.2487e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "306",
                                "peak_id": "0",
                                "monoisotopic_mass": "8727.6523",
                                "monoisotopic_mz": "624.4110",
                                "intensity": "81353.55",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8727.7403",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0880",
                                        "ppm": "-10.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "1",
                                "monoisotopic_mass": "8826.7290",
                                "monoisotopic_mz": "589.4559",
                                "intensity": "46518.23",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8826.8087",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0797",
                                        "ppm": "-9.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "2",
                                "monoisotopic_mass": "8826.7067",
                                "monoisotopic_mz": "631.4863",
                                "intensity": "52926.47",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8826.8087",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.1020",
                                        "ppm": "-11.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "3",
                                "monoisotopic_mass": "8798.6905",
                                "monoisotopic_mz": "629.4852",
                                "intensity": "64608.06",
                                "charge": "14"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "4",
                                "monoisotopic_mass": "8898.7591",
                                "monoisotopic_mz": "594.2579",
                                "intensity": "40297.60",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8897.8458",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0891",
                                        "ppm": "-10.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "5",
                                "monoisotopic_mass": "8869.7671",
                                "monoisotopic_mz": "592.3251",
                                "intensity": "23814.22",
                                "charge": "15"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "6",
                                "monoisotopic_mass": "8709.6242",
                                "monoisotopic_mz": "623.1233",
                                "intensity": "22798.99",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8708.7080",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0861",
                                        "ppm": "-9.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "7",
                                "monoisotopic_mass": "8782.6893",
                                "monoisotopic_mz": "628.3422",
                                "intensity": "21749.95",
                                "charge": "14"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "8",
                                "monoisotopic_mass": "5664.0279",
                                "monoisotopic_mz": "709.0108",
                                "intensity": "17851.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "9",
                                "monoisotopic_mass": "3021.5811",
                                "monoisotopic_mz": "504.6041",
                                "intensity": "25951.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0271",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "10",
                                "monoisotopic_mass": "5778.1119",
                                "monoisotopic_mz": "723.2713",
                                "intensity": "11194.72",
                                "charge": "8"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "11",
                                "monoisotopic_mass": "8798.7121",
                                "monoisotopic_mz": "587.5881",
                                "intensity": "29258.16",
                                "charge": "15"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "12",
                                "monoisotopic_mass": "8780.7046",
                                "monoisotopic_mz": "586.3876",
                                "intensity": "19098.78",
                                "charge": "15"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "13",
                                "monoisotopic_mass": "2035.0876",
                                "monoisotopic_mz": "509.7792",
                                "intensity": "15637.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "14",
                                "monoisotopic_mass": "3021.5788",
                                "monoisotopic_mz": "605.3230",
                                "intensity": "15717.11",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0293",
                                        "ppm": "-9.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "15",
                                "monoisotopic_mass": "3120.6494",
                                "monoisotopic_mz": "521.1155",
                                "intensity": "8961.33",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3120.6765",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0272",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "16",
                                "monoisotopic_mass": "5707.0729",
                                "monoisotopic_mz": "714.3914",
                                "intensity": "8565.55",
                                "charge": "8"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "17",
                                "monoisotopic_mass": "1255.0966",
                                "monoisotopic_mz": "628.5556",
                                "intensity": "6050.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "18",
                                "monoisotopic_mass": "8077.9972",
                                "monoisotopic_mz": "622.3917",
                                "intensity": "7096.50",
                                "charge": "13"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "19",
                                "monoisotopic_mass": "2797.4957",
                                "monoisotopic_mz": "700.3812",
                                "intensity": "10573.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "20",
                                "monoisotopic_mass": "1981.3593",
                                "monoisotopic_mz": "199.1432",
                                "intensity": "5324.79",
                                "charge": "10"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "21",
                                "monoisotopic_mass": "1068.5437",
                                "monoisotopic_mz": "535.2791",
                                "intensity": "4712.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "22",
                                "monoisotopic_mass": "5925.1577",
                                "monoisotopic_mz": "659.3581",
                                "intensity": "5912.24",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5924.2225",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0671",
                                        "ppm": "-11.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "23",
                                "monoisotopic_mass": "6655.4565",
                                "monoisotopic_mz": "606.0488",
                                "intensity": "7533.48",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6655.5144",
                                        "ion_position": "63",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "B00063",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0579",
                                        "ppm": "-8.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "24",
                                "monoisotopic_mass": "7849.5354",
                                "monoisotopic_mz": "604.8177",
                                "intensity": "3493.92",
                                "charge": "13"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "25",
                                "monoisotopic_mass": "7709.2066",
                                "monoisotopic_mz": "594.0232",
                                "intensity": "5228.80",
                                "charge": "13"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "26",
                                "monoisotopic_mass": "1835.9562",
                                "monoisotopic_mz": "612.9927",
                                "intensity": "4159.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "27",
                                "monoisotopic_mass": "620.5430",
                                "monoisotopic_mz": "621.5502",
                                "intensity": "2974.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "28",
                                "monoisotopic_mass": "3091.6447",
                                "monoisotopic_mz": "516.2814",
                                "intensity": "4309.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "29",
                                "monoisotopic_mass": "2367.7317",
                                "monoisotopic_mz": "592.9402",
                                "intensity": "2660.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "30",
                                "monoisotopic_mass": "4487.5268",
                                "monoisotopic_mz": "642.0825",
                                "intensity": "5611.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "31",
                                "monoisotopic_mass": "2348.7991",
                                "monoisotopic_mz": "588.2070",
                                "intensity": "3732.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "32",
                                "monoisotopic_mass": "7515.2852",
                                "monoisotopic_mz": "627.2810",
                                "intensity": "5758.91",
                                "charge": "12"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "33",
                                "monoisotopic_mass": "1399.5046",
                                "monoisotopic_mz": "700.7596",
                                "intensity": "2394.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "306",
                                "peak_id": "34",
                                "monoisotopic_mass": "1185.6421",
                                "monoisotopic_mz": "593.8283",
                                "intensity": "1714.96",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "25",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9044.8990",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "spec_id": "306",
                                        "peak_id": "6",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "306",
                                            "peak_id": "14",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "306",
                                            "peak_id": "9",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "306",
                                            "peak_id": "15",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "54",
                                            "spec_id": "306",
                                            "peak_id": "22",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "63",
                                        "ion_display_position": "63",
                                        "spec_id": "306",
                                        "peak_id": "23",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "spec_id": "306",
                                        "peak_id": "0",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "306",
                                            "peak_id": "2",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "306",
                                            "peak_id": "1",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "spec_id": "306",
                                        "peak_id": "4",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "5.67e-04",
                "e_value": "5.67e-04",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "298",
                        "ms1_scans": "581",
                        "ids": "282",
                        "scans": "582",
                        "precursor_mono_mass": "9043.7999",
                        "precursor_charge": "16",
                        "precursor_mz": "566.2448",
                        "feature_inte": "5.2487e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "282",
                                "peak_id": "0",
                                "monoisotopic_mass": "8727.6532",
                                "monoisotopic_mz": "624.4111",
                                "intensity": "723587.06",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8726.6862",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0354",
                                        "ppm": "-4.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "1",
                                "monoisotopic_mass": "8826.7118",
                                "monoisotopic_mz": "631.4867",
                                "intensity": "610009.65",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8825.7546",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0452",
                                        "ppm": "-5.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "2",
                                "monoisotopic_mass": "8798.6939",
                                "monoisotopic_mz": "629.4854",
                                "intensity": "524068.48",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8799.7568",
                                        "ion_position": "2",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "Y00083",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0605",
                                        "ppm": "-6.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "3",
                                "monoisotopic_mass": "8897.7601",
                                "monoisotopic_mz": "594.1913",
                                "intensity": "407683.75",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8896.7918",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "ion_sort_name": "B00084",
                                        "ion_left_position": "84",
                                        "mass_error": "-0.0340",
                                        "ppm": "-3.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "4",
                                "monoisotopic_mass": "8826.7272",
                                "monoisotopic_mz": "589.4558",
                                "intensity": "438120.84",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8825.7546",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0298",
                                        "ppm": "-3.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "5",
                                "monoisotopic_mass": "8710.6505",
                                "monoisotopic_mz": "623.1966",
                                "intensity": "233282.92",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "6",
                                "monoisotopic_mass": "8798.7277",
                                "monoisotopic_mz": "587.5891",
                                "intensity": "206732.61",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8799.7568",
                                        "ion_position": "2",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "Y00083",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0268",
                                        "ppm": "-3.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "7",
                                "monoisotopic_mass": "8869.7661",
                                "monoisotopic_mz": "592.3250",
                                "intensity": "228834.71",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8870.7939",
                                        "ion_position": "1",
                                        "ion_display_position": "84",
                                        "ion_sort_name": "Y00084",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0254",
                                        "ppm": "-2.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "8",
                                "monoisotopic_mass": "8780.6752",
                                "monoisotopic_mz": "628.1984",
                                "intensity": "237170.52",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "9",
                                "monoisotopic_mass": "5777.1143",
                                "monoisotopic_mz": "723.1466",
                                "intensity": "150731.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "10",
                                "monoisotopic_mass": "3021.5803",
                                "monoisotopic_mz": "504.6040",
                                "intensity": "241819.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "11",
                                "monoisotopic_mass": "8769.6771",
                                "monoisotopic_mz": "627.4128",
                                "intensity": "152495.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "12",
                                "monoisotopic_mass": "8685.6156",
                                "monoisotopic_mz": "621.4084",
                                "intensity": "102969.96",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "13",
                                "monoisotopic_mass": "3021.5788",
                                "monoisotopic_mz": "605.3230",
                                "intensity": "178422.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "14",
                                "monoisotopic_mass": "5706.0807",
                                "monoisotopic_mz": "714.2674",
                                "intensity": "98922.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "15",
                                "monoisotopic_mass": "5127.7400",
                                "monoisotopic_mz": "641.9748",
                                "intensity": "147260.26",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "5126.7351",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0025",
                                        "ppm": "0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "16",
                                "monoisotopic_mass": "5592.9947",
                                "monoisotopic_mz": "700.1316",
                                "intensity": "140192.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "17",
                                "monoisotopic_mass": "8810.7098",
                                "monoisotopic_mz": "630.3437",
                                "intensity": "77014.24",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "18",
                                "monoisotopic_mass": "5664.0310",
                                "monoisotopic_mz": "709.0111",
                                "intensity": "120216.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "19",
                                "monoisotopic_mass": "8781.7226",
                                "monoisotopic_mz": "586.4555",
                                "intensity": "76187.35",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "20",
                                "monoisotopic_mass": "5924.1581",
                                "monoisotopic_mz": "659.2471",
                                "intensity": "73707.27",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5924.2225",
                                        "ion_position": "31",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0644",
                                        "ppm": "-10.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "21",
                                "monoisotopic_mass": "8727.6516",
                                "monoisotopic_mz": "672.3651",
                                "intensity": "85169.56",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "8726.6862",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0369",
                                        "ppm": "-4.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "22",
                                "monoisotopic_mass": "8809.7343",
                                "monoisotopic_mz": "588.3229",
                                "intensity": "89590.05",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "23",
                                "monoisotopic_mass": "3119.6437",
                                "monoisotopic_mz": "520.9479",
                                "intensity": "70006.60",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "3119.6225",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0212",
                                        "ppm": "6.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "24",
                                "monoisotopic_mass": "5811.0729",
                                "monoisotopic_mz": "646.6820",
                                "intensity": "54274.25",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5811.1384",
                                        "ion_position": "32",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0655",
                                        "ppm": "-11.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "25",
                                "monoisotopic_mass": "8699.6687",
                                "monoisotopic_mz": "580.9852",
                                "intensity": "64783.02",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "26",
                                "monoisotopic_mass": "6655.4619",
                                "monoisotopic_mz": "606.0493",
                                "intensity": "89381.89",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "6654.4604",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "27",
                                "monoisotopic_mass": "8880.7719",
                                "monoisotopic_mz": "593.0587",
                                "intensity": "69180.63",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "28",
                                "monoisotopic_mass": "8851.7606",
                                "monoisotopic_mz": "591.1247",
                                "intensity": "53724.35",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "29",
                                "monoisotopic_mass": "8739.6639",
                                "monoisotopic_mz": "625.2690",
                                "intensity": "47540.86",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "30",
                                "monoisotopic_mass": "5777.1220",
                                "monoisotopic_mz": "642.9097",
                                "intensity": "44661.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "31",
                                "monoisotopic_mass": "2497.9167",
                                "monoisotopic_mz": "625.4865",
                                "intensity": "28095.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "32",
                                "monoisotopic_mass": "8653.6277",
                                "monoisotopic_mz": "619.1235",
                                "intensity": "38752.02",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "33",
                                "monoisotopic_mass": "5226.8340",
                                "monoisotopic_mz": "581.7666",
                                "intensity": "27693.27",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "5225.8035",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "0.0281",
                                        "ppm": "5.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "34",
                                "monoisotopic_mass": "2908.8860",
                                "monoisotopic_mz": "582.7845",
                                "intensity": "29932.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "35",
                                "monoisotopic_mass": "1257.9603",
                                "monoisotopic_mz": "629.9874",
                                "intensity": "48442.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "36",
                                "monoisotopic_mass": "7955.1921",
                                "monoisotopic_mz": "612.9451",
                                "intensity": "64397.48",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "37",
                                "monoisotopic_mass": "3092.6503",
                                "monoisotopic_mz": "442.8145",
                                "intensity": "23624.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "38",
                                "monoisotopic_mass": "4092.8538",
                                "monoisotopic_mz": "585.7007",
                                "intensity": "47183.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "39",
                                "monoisotopic_mass": "8624.6031",
                                "monoisotopic_mz": "617.0504",
                                "intensity": "28164.19",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "40",
                                "monoisotopic_mass": "8684.5899",
                                "monoisotopic_mz": "669.0527",
                                "intensity": "48496.45",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "41",
                                "monoisotopic_mass": "3599.9130",
                                "monoisotopic_mz": "600.9928",
                                "intensity": "23391.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "42",
                                "monoisotopic_mass": "4380.3399",
                                "monoisotopic_mz": "626.7701",
                                "intensity": "34997.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "43",
                                "monoisotopic_mass": "1981.3583",
                                "monoisotopic_mz": "199.1431",
                                "intensity": "12444.96",
                                "charge": "10"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "44",
                                "monoisotopic_mass": "5127.7562",
                                "monoisotopic_mz": "570.7580",
                                "intensity": "20571.58",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "5126.7351",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0187",
                                        "ppm": "3.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "45",
                                "monoisotopic_mass": "8596.5399",
                                "monoisotopic_mz": "615.0458",
                                "intensity": "30319.11",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "46",
                                "monoisotopic_mass": "5522.0051",
                                "monoisotopic_mz": "691.2579",
                                "intensity": "24463.89",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "47",
                                "monoisotopic_mass": "619.4722",
                                "monoisotopic_mz": "620.4795",
                                "intensity": "20064.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "48",
                                "monoisotopic_mass": "8169.7399",
                                "monoisotopic_mz": "584.5601",
                                "intensity": "38443.37",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "49",
                                "monoisotopic_mass": "4317.2951",
                                "monoisotopic_mz": "617.7637",
                                "intensity": "13970.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "50",
                                "monoisotopic_mass": "4783.5940",
                                "monoisotopic_mz": "598.9565",
                                "intensity": "28529.51",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "4783.5859",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0081",
                                        "ppm": "1.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "51",
                                "monoisotopic_mass": "2515.1987",
                                "monoisotopic_mz": "629.8070",
                                "intensity": "23654.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "52",
                                "monoisotopic_mass": "2992.5802",
                                "monoisotopic_mz": "499.7707",
                                "intensity": "14722.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "53",
                                "monoisotopic_mass": "3091.6543",
                                "monoisotopic_mz": "516.2830",
                                "intensity": "18324.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "54",
                                "monoisotopic_mass": "7863.7627",
                                "monoisotopic_mz": "656.3208",
                                "intensity": "11518.83",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "55",
                                "monoisotopic_mass": "5992.0947",
                                "monoisotopic_mz": "600.2167",
                                "intensity": "16970.30",
                                "charge": "10"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "56",
                                "monoisotopic_mass": "3818.0055",
                                "monoisotopic_mz": "637.3415",
                                "intensity": "9458.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.0414",
                                        "ion_position": "51",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0359",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "57",
                                "monoisotopic_mass": "8683.6631",
                                "monoisotopic_mz": "579.9182",
                                "intensity": "17040.22",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "58",
                                "monoisotopic_mass": "7938.7727",
                                "monoisotopic_mz": "611.6821",
                                "intensity": "16449.06",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "59",
                                "monoisotopic_mass": "6655.5245",
                                "monoisotopic_mz": "666.5597",
                                "intensity": "18253.02",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-174.1050950812",
                                        "theoretical_mass": "6654.4604",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0618",
                                        "ppm": "9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "60",
                                "monoisotopic_mass": "2377.9497",
                                "monoisotopic_mz": "199.1698",
                                "intensity": "11678.65",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "61",
                                "monoisotopic_mass": "7616.2543",
                                "monoisotopic_mz": "586.8730",
                                "intensity": "10608.96",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "62",
                                "monoisotopic_mass": "699.8771",
                                "monoisotopic_mz": "700.8843",
                                "intensity": "6836.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "63",
                                "monoisotopic_mass": "1161.8250",
                                "monoisotopic_mz": "581.9198",
                                "intensity": "10581.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "64",
                                "monoisotopic_mass": "991.0994",
                                "monoisotopic_mz": "199.2272",
                                "intensity": "8916.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "65",
                                "monoisotopic_mass": "1222.1391",
                                "monoisotopic_mz": "612.0768",
                                "intensity": "4822.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "66",
                                "monoisotopic_mass": "4959.5842",
                                "monoisotopic_mz": "620.9553",
                                "intensity": "8864.17",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "67",
                                "monoisotopic_mass": "7999.4426",
                                "monoisotopic_mz": "667.6275",
                                "intensity": "16866.83",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "68",
                                "monoisotopic_mass": "1350.6162",
                                "monoisotopic_mz": "676.3154",
                                "intensity": "5384.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "69",
                                "monoisotopic_mass": "1838.4832",
                                "monoisotopic_mz": "613.8350",
                                "intensity": "7194.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "70",
                                "monoisotopic_mass": "1893.2398",
                                "monoisotopic_mz": "632.0872",
                                "intensity": "11161.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "71",
                                "monoisotopic_mass": "1302.8813",
                                "monoisotopic_mz": "652.4479",
                                "intensity": "16737.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "72",
                                "monoisotopic_mass": "1482.8905",
                                "monoisotopic_mz": "495.3041",
                                "intensity": "11021.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "73",
                                "monoisotopic_mass": "1062.8991",
                                "monoisotopic_mz": "532.4568",
                                "intensity": "6915.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "74",
                                "monoisotopic_mass": "3805.1588",
                                "monoisotopic_mz": "635.2004",
                                "intensity": "11807.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "75",
                                "monoisotopic_mass": "722.1405",
                                "monoisotopic_mz": "723.1478",
                                "intensity": "9007.40",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "25",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9043.8449",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "84",
                                        "spec_id": "282",
                                        "peak_id": "7",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "83",
                                            "spec_id": "282",
                                            "peak_id": "2",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "83",
                                            "spec_id": "282",
                                            "peak_id": "6",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "282",
                                            "peak_id": "23",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "54",
                                            "spec_id": "282",
                                            "peak_id": "20",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "53",
                                        "spec_id": "282",
                                        "peak_id": "24",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "282",
                                        "peak_id": "50",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "50",
                                            "ion_display_position": "50",
                                            "spec_id": "282",
                                            "peak_id": "15",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "50",
                                            "ion_display_position": "50",
                                            "spec_id": "282",
                                            "peak_id": "44",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "51",
                                            "ion_display_position": "34",
                                            "spec_id": "282",
                                            "peak_id": "56",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "282",
                                            "peak_id": "33",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "64",
                                            "ion_display_position": "64",
                                            "spec_id": "282",
                                            "peak_id": "26",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "64",
                                            "ion_display_position": "64",
                                            "spec_id": "282",
                                            "peak_id": "59",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "282",
                                            "peak_id": "21",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "282",
                                            "peak_id": "0",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "83",
                                            "ion_display_position": "83",
                                            "spec_id": "282",
                                            "peak_id": "1",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "83",
                                            "ion_display_position": "83",
                                            "spec_id": "282",
                                            "peak_id": "4",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "spec_id": "282",
                                        "peak_id": "3",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": [
                            {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "52",
                                    "right_pos": "53",
                                    "anno": "C"
                                }
                            },
                            {
                                "ptm_type": "Protein variable",
                                "ptm": {
                                    "abbreviation": "Acetyl",
                                    "unimod": "1",
                                    "mono_mass": "42.0105650000"
                                },
                                "occurence": {
                                    "left_pos": "0",
                                    "right_pos": "1",
                                    "anno": "M"
                                }
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "2",
                            "right_position": "31",
                            "anno": "-174.1051",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "39",
                "p_value": "0.01",
                "e_value": "0.01",
                "fdr": "7.94e-03",
                "matched_fragment_number": "8",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "304",
                        "ms1_scans": "593",
                        "ids": "288",
                        "scans": "594",
                        "precursor_mono_mass": "9046.8182",
                        "precursor_charge": "17",
                        "precursor_mz": "533.1731",
                        "feature_inte": "5.2487e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "288",
                                "peak_id": "0",
                                "monoisotopic_mass": "5127.7434",
                                "monoisotopic_mz": "570.7565",
                                "intensity": "204728.98",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5127.7892",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0458",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "1",
                                "monoisotopic_mass": "8826.7181",
                                "monoisotopic_mz": "589.4551",
                                "intensity": "161836.48",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8826.8087",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0906",
                                        "ppm": "-10.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "2",
                                "monoisotopic_mass": "8727.6544",
                                "monoisotopic_mz": "582.8509",
                                "intensity": "147287.41",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8727.7403",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0859",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "3",
                                "monoisotopic_mass": "8770.6988",
                                "monoisotopic_mz": "585.7205",
                                "intensity": "121498.11",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "4",
                                "monoisotopic_mass": "8798.7130",
                                "monoisotopic_mz": "587.5881",
                                "intensity": "109917.89",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "5",
                                "monoisotopic_mass": "3021.5801",
                                "monoisotopic_mz": "605.3233",
                                "intensity": "163067.28",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0281",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "6",
                                "monoisotopic_mass": "8897.7652",
                                "monoisotopic_mz": "557.1176",
                                "intensity": "129569.44",
                                "charge": "16",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8897.8458",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0806",
                                        "ppm": "-9.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "7",
                                "monoisotopic_mass": "8727.6464",
                                "monoisotopic_mz": "624.4106",
                                "intensity": "90676.85",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8727.7403",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0939",
                                        "ppm": "-10.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "8",
                                "monoisotopic_mass": "3021.5802",
                                "monoisotopic_mz": "504.6040",
                                "intensity": "128249.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0280",
                                        "ppm": "-9.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "9",
                                "monoisotopic_mass": "5706.0757",
                                "monoisotopic_mz": "635.0157",
                                "intensity": "65197.17",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "10",
                                "monoisotopic_mass": "8868.7683",
                                "monoisotopic_mz": "555.3053",
                                "intensity": "80864.56",
                                "charge": "16"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "11",
                                "monoisotopic_mass": "8709.6406",
                                "monoisotopic_mz": "581.6500",
                                "intensity": "57516.83",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "1.9342450074",
                                        "theoretical_mass": "8710.6423",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "3",
                                        "mass_error": "0.0007",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "12",
                                "monoisotopic_mass": "5777.1227",
                                "monoisotopic_mz": "642.9098",
                                "intensity": "68137.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "13",
                                "monoisotopic_mass": "5592.9917",
                                "monoisotopic_mz": "622.4508",
                                "intensity": "55277.38",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "14",
                                "monoisotopic_mass": "8826.7408",
                                "monoisotopic_mz": "552.6786",
                                "intensity": "51736.45",
                                "charge": "16",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8826.8087",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0679",
                                        "ppm": "-7.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "15",
                                "monoisotopic_mass": "5493.9318",
                                "monoisotopic_mz": "687.7487",
                                "intensity": "32792.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "16",
                                "monoisotopic_mass": "5664.0322",
                                "monoisotopic_mz": "630.3442",
                                "intensity": "43407.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "17",
                                "monoisotopic_mass": "5593.0000",
                                "monoisotopic_mz": "700.1323",
                                "intensity": "29335.07",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "18",
                                "monoisotopic_mass": "5924.1641",
                                "monoisotopic_mz": "593.4237",
                                "intensity": "52547.51",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "19",
                                "monoisotopic_mass": "3818.0107",
                                "monoisotopic_mz": "546.4374",
                                "intensity": "42862.77",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "20",
                                "monoisotopic_mass": "5564.9587",
                                "monoisotopic_mz": "696.6271",
                                "intensity": "23744.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "21",
                                "monoisotopic_mass": "8683.5562",
                                "monoisotopic_mz": "621.2613",
                                "intensity": "19252.23",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "22",
                                "monoisotopic_mass": "2950.5452",
                                "monoisotopic_mz": "591.1163",
                                "intensity": "27400.53",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2950.5710",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0258",
                                        "ppm": "-8.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "23",
                                "monoisotopic_mass": "8196.7760",
                                "monoisotopic_mz": "586.4913",
                                "intensity": "54756.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "24",
                                "monoisotopic_mass": "5605.9933",
                                "monoisotopic_mz": "701.7564",
                                "intensity": "26789.11",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "25",
                                "monoisotopic_mass": "3670.9594",
                                "monoisotopic_mz": "612.8338",
                                "intensity": "18881.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "26",
                                "monoisotopic_mass": "3092.6529",
                                "monoisotopic_mz": "442.8148",
                                "intensity": "17494.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "27",
                                "monoisotopic_mass": "3120.6572",
                                "monoisotopic_mz": "625.1387",
                                "intensity": "31384.40",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3120.6765",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0194",
                                        "ppm": "-6.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "28",
                                "monoisotopic_mass": "8710.6189",
                                "monoisotopic_mz": "623.1943",
                                "intensity": "15906.18",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "1.9342450074",
                                        "theoretical_mass": "8710.6423",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0234",
                                        "ppm": "-2.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "29",
                                "monoisotopic_mass": "5688.0828",
                                "monoisotopic_mz": "633.0165",
                                "intensity": "13319.85",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "30",
                                "monoisotopic_mass": "5810.0899",
                                "monoisotopic_mz": "582.0163",
                                "intensity": "12881.51",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "31",
                                "monoisotopic_mass": "8754.6066",
                                "monoisotopic_mz": "584.6477",
                                "intensity": "17096.31",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "32",
                                "monoisotopic_mass": "3021.5756",
                                "monoisotopic_mz": "432.6609",
                                "intensity": "13026.89",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0326",
                                        "ppm": "-10.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "33",
                                "monoisotopic_mass": "5565.9993",
                                "monoisotopic_mz": "619.4516",
                                "intensity": "16907.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "34",
                                "monoisotopic_mass": "579.1754",
                                "monoisotopic_mz": "580.1827",
                                "intensity": "15249.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "35",
                                "monoisotopic_mass": "5906.1459",
                                "monoisotopic_mz": "591.6219",
                                "intensity": "10485.91",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "36",
                                "monoisotopic_mass": "1762.1506",
                                "monoisotopic_mz": "588.3908",
                                "intensity": "8713.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "37",
                                "monoisotopic_mass": "6350.3511",
                                "monoisotopic_mz": "578.3119",
                                "intensity": "18324.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "38",
                                "monoisotopic_mass": "3599.9072",
                                "monoisotopic_mz": "600.9918",
                                "intensity": "19487.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "39",
                                "monoisotopic_mass": "3003.5825",
                                "monoisotopic_mz": "601.7238",
                                "intensity": "13918.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "40",
                                "monoisotopic_mass": "2219.9382",
                                "monoisotopic_mz": "555.9918",
                                "intensity": "10186.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "41",
                                "monoisotopic_mass": "4334.3324",
                                "monoisotopic_mz": "620.1976",
                                "intensity": "7052.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "42",
                                "monoisotopic_mass": "4398.8655",
                                "monoisotopic_mz": "550.8655",
                                "intensity": "15261.73",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "43",
                                "monoisotopic_mass": "6653.5022",
                                "monoisotopic_mz": "605.8711",
                                "intensity": "43625.05",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "44",
                                "monoisotopic_mass": "7588.5669",
                                "monoisotopic_mz": "633.3879",
                                "intensity": "11198.84",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "45",
                                "monoisotopic_mass": "4111.1216",
                                "monoisotopic_mz": "588.3104",
                                "intensity": "18831.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "46",
                                "monoisotopic_mass": "2179.5080",
                                "monoisotopic_mz": "199.1444",
                                "intensity": "12820.37",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "47",
                                "monoisotopic_mass": "2377.6379",
                                "monoisotopic_mz": "199.1438",
                                "intensity": "6282.67",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "48",
                                "monoisotopic_mass": "5875.4566",
                                "monoisotopic_mz": "588.5529",
                                "intensity": "6794.77",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "49",
                                "monoisotopic_mass": "2949.5440",
                                "monoisotopic_mz": "492.5980",
                                "intensity": "15693.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "50",
                                "monoisotopic_mass": "7445.7689",
                                "monoisotopic_mz": "621.4880",
                                "intensity": "7773.95",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "51",
                                "monoisotopic_mass": "7433.2372",
                                "monoisotopic_mz": "620.4437",
                                "intensity": "5961.07",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "52",
                                "monoisotopic_mass": "553.3597",
                                "monoisotopic_mz": "554.3669",
                                "intensity": "8453.00",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "25",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9046.8332",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "81",
                                            "spec_id": "288",
                                            "peak_id": "28",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "81",
                                            "spec_id": "288",
                                            "peak_id": "11",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "288",
                                        "peak_id": "22",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "288",
                                            "peak_id": "32",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "288",
                                            "peak_id": "5",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "288",
                                            "peak_id": "8",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "288",
                                        "peak_id": "27",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "288",
                                        "peak_id": "0",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "288",
                                            "peak_id": "7",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "288",
                                            "peak_id": "2",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "288",
                                            "peak_id": "1",
                                            "peak_charge": "15"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "288",
                                            "peak_id": "14",
                                            "peak_charge": "16"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "spec_id": "288",
                                        "peak_id": "6",
                                        "peak_charge": "16"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "84",
                            "right_position": "85",
                            "anno": "1.9342",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "54",
                "p_value": "0.01",
                "e_value": "0.01",
                "fdr": "7.69e-03",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "346",
                        "ms1_scans": "677",
                        "ids": "330",
                        "scans": "678",
                        "precursor_mono_mass": "9044.8429",
                        "precursor_charge": "16",
                        "precursor_mz": "566.3100",
                        "feature_inte": "5.2487e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "330",
                                "peak_id": "0",
                                "monoisotopic_mass": "8727.6600",
                                "monoisotopic_mz": "624.4116",
                                "intensity": "17227.17",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-7.1074992637e-02",
                                        "theoretical_mass": "8727.6692",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0092",
                                        "ppm": "-1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "1",
                                "monoisotopic_mass": "8797.6839",
                                "monoisotopic_mz": "629.4133",
                                "intensity": "14127.16",
                                "charge": "14"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "2",
                                "monoisotopic_mass": "8826.7007",
                                "monoisotopic_mz": "589.4540",
                                "intensity": "10196.23",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-7.1074992637e-02",
                                        "theoretical_mass": "8826.7376",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0370",
                                        "ppm": "-4.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "3",
                                "monoisotopic_mass": "8826.7187",
                                "monoisotopic_mz": "631.4872",
                                "intensity": "11075.39",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-7.1074992637e-02",
                                        "theoretical_mass": "8826.7376",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0189",
                                        "ppm": "-2.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "4",
                                "monoisotopic_mass": "3021.5803",
                                "monoisotopic_mz": "504.6040",
                                "intensity": "7601.04",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0278",
                                        "ppm": "-9.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "5",
                                "monoisotopic_mass": "8709.6627",
                                "monoisotopic_mz": "623.1260",
                                "intensity": "7001.69",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-7.1074992637e-02",
                                        "theoretical_mass": "8708.6369",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "3",
                                        "mass_error": "0.0234",
                                        "ppm": "2.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "6",
                                "monoisotopic_mass": "8782.6748",
                                "monoisotopic_mz": "628.3412",
                                "intensity": "4223.04",
                                "charge": "14"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "7",
                                "monoisotopic_mass": "5592.9962",
                                "monoisotopic_mz": "700.1318",
                                "intensity": "3139.45",
                                "charge": "8"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "8",
                                "monoisotopic_mass": "1601.8526",
                                "monoisotopic_mz": "534.9581",
                                "intensity": "3206.85",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-7.1074992637e-02",
                                        "theoretical_mass": "1601.8543",
                                        "ion_position": "70",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0017",
                                        "ppm": "-1.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "9",
                                "monoisotopic_mass": "8799.7309",
                                "monoisotopic_mz": "587.6560",
                                "intensity": "4263.83",
                                "charge": "15"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "10",
                                "monoisotopic_mass": "2034.0866",
                                "monoisotopic_mz": "509.5289",
                                "intensity": "2880.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "11",
                                "monoisotopic_mass": "3020.5731",
                                "monoisotopic_mz": "605.1219",
                                "intensity": "5014.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "12",
                                "monoisotopic_mass": "1243.6640",
                                "monoisotopic_mz": "622.8393",
                                "intensity": "1462.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "13",
                                "monoisotopic_mass": "8867.7619",
                                "monoisotopic_mz": "592.1914",
                                "intensity": "1292.00",
                                "charge": "15"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "14",
                                "monoisotopic_mass": "1187.1692",
                                "monoisotopic_mz": "594.5919",
                                "intensity": "3776.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "15",
                                "monoisotopic_mass": "2966.2530",
                                "monoisotopic_mz": "594.2579",
                                "intensity": "4516.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "16",
                                "monoisotopic_mass": "592.4518",
                                "monoisotopic_mz": "593.4590",
                                "intensity": "1795.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "17",
                                "monoisotopic_mass": "4730.7425",
                                "monoisotopic_mz": "592.3501",
                                "intensity": "1609.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "18",
                                "monoisotopic_mass": "4746.0851",
                                "monoisotopic_mz": "594.2679",
                                "intensity": "2608.15",
                                "charge": "8"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "19",
                                "monoisotopic_mass": "1773.3517",
                                "monoisotopic_mz": "592.1245",
                                "intensity": "1460.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "20",
                                "monoisotopic_mass": "626.7629",
                                "monoisotopic_mz": "627.7701",
                                "intensity": "1552.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "21",
                                "monoisotopic_mass": "3171.2457",
                                "monoisotopic_mz": "199.2101",
                                "intensity": "2679.36",
                                "charge": "16"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "22",
                                "monoisotopic_mass": "4697.1346",
                                "monoisotopic_mz": "588.1491",
                                "intensity": "1912.85",
                                "charge": "8"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "23",
                                "monoisotopic_mass": "7967.8009",
                                "monoisotopic_mz": "532.1940",
                                "intensity": "3181.54",
                                "charge": "15"
                            },
                            {
                                "spec_id": "330",
                                "peak_id": "24",
                                "monoisotopic_mass": "1220.5289",
                                "monoisotopic_mz": "611.2717",
                                "intensity": "885.54",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "25",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9044.8279",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "spec_id": "330",
                                        "peak_id": "5",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "330",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "14",
                                        "spec_id": "330",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "spec_id": "330",
                                        "peak_id": "0",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "330",
                                            "peak_id": "2",
                                            "peak_charge": "15"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "330",
                                            "peak_id": "3",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "71",
                            "right_position": "82",
                            "anno": "-0.0711",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
