prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "3",
        "sequence_name": "sp|P0A7P2|RL33_SALTY",
        "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
        "proteoform_id": "63",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "21",
                "p_value": "4.28e-06",
                "e_value": "4.28e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "218",
                        "ms1_scans": "421",
                        "ids": "202",
                        "scans": "422",
                        "precursor_mono_mass": "6267.5219",
                        "precursor_charge": "12",
                        "precursor_mz": "523.3008",
                        "feature_inte": "2.9819e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "202",
                                "peak_id": "0",
                                "monoisotopic_mass": "4755.6233",
                                "monoisotopic_mz": "595.4602",
                                "intensity": "1140416.17",
                                "charge": "8",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-142.1135158038",
                                            "theoretical_mass": "4755.6233",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "ion_sort_name": "B00043",
                                            "ion_left_position": "43",
                                            "mass_error": "0.0000",
                                            "ppm": "0.00"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "4755.6705",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "ion_sort_name": "Y00040",
                                            "ion_left_position": "15",
                                            "mass_error": "-0.0472",
                                            "ppm": "-9.92"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6140",
                                "monoisotopic_mz": "593.2090",
                                "intensity": "554291.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4681",
                                "monoisotopic_mz": "556.4408",
                                "intensity": "468187.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "3",
                                "monoisotopic_mass": "1807.0660",
                                "monoisotopic_mz": "603.3626",
                                "intensity": "445653.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0173",
                                        "ppm": "-9.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "4",
                                "monoisotopic_mass": "1807.0670",
                                "monoisotopic_mz": "452.7740",
                                "intensity": "391819.48",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0162",
                                        "ppm": "-8.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "5",
                                "monoisotopic_mass": "1423.8746",
                                "monoisotopic_mz": "475.6321",
                                "intensity": "265761.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "6",
                                "monoisotopic_mass": "4425.4578",
                                "monoisotopic_mz": "554.1895",
                                "intensity": "211082.92",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "7",
                                "monoisotopic_mass": "2948.5594",
                                "monoisotopic_mz": "590.7192",
                                "intensity": "195542.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "8",
                                "monoisotopic_mass": "4698.5965",
                                "monoisotopic_mz": "588.3318",
                                "intensity": "129320.45",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4698.6490",
                                        "ion_position": "16",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0526",
                                        "ppm": "-11.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "9",
                                "monoisotopic_mass": "4719.6081",
                                "monoisotopic_mz": "590.9583",
                                "intensity": "218156.63",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "10",
                                "monoisotopic_mass": "1405.8641",
                                "monoisotopic_mz": "469.6286",
                                "intensity": "172190.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "11",
                                "monoisotopic_mass": "4808.6501",
                                "monoisotopic_mz": "602.0885",
                                "intensity": "139302.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "12",
                                "monoisotopic_mass": "1789.0538",
                                "monoisotopic_mz": "448.2707",
                                "intensity": "136827.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "13",
                                "monoisotopic_mass": "4406.4552",
                                "monoisotopic_mz": "551.8142",
                                "intensity": "63160.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "14",
                                "monoisotopic_mass": "4771.6159",
                                "monoisotopic_mz": "597.4593",
                                "intensity": "196636.76",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-142.1135158038",
                                        "theoretical_mass": "4771.6261",
                                        "ion_position": "13",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "Y00042",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0102",
                                        "ppm": "-2.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "15",
                                "monoisotopic_mass": "4596.5484",
                                "monoisotopic_mz": "657.6570",
                                "intensity": "56991.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "16",
                                "monoisotopic_mass": "2438.4288",
                                "monoisotopic_mz": "488.6930",
                                "intensity": "44758.49",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0238",
                                        "ppm": "-9.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "17",
                                "monoisotopic_mass": "5792.2151",
                                "monoisotopic_mz": "580.2288",
                                "intensity": "81894.35",
                                "charge": "10"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "18",
                                "monoisotopic_mass": "1249.8127",
                                "monoisotopic_mz": "417.6115",
                                "intensity": "85642.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "19",
                                "monoisotopic_mass": "1336.8438",
                                "monoisotopic_mz": "446.6219",
                                "intensity": "44635.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "20",
                                "monoisotopic_mass": "2930.5489",
                                "monoisotopic_mz": "587.1170",
                                "intensity": "92129.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "21",
                                "monoisotopic_mass": "3001.5871",
                                "monoisotopic_mz": "601.3247",
                                "intensity": "38757.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "22",
                                "monoisotopic_mass": "5112.8675",
                                "monoisotopic_mz": "569.1037",
                                "intensity": "59082.82",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "23",
                                "monoisotopic_mass": "5159.8807",
                                "monoisotopic_mz": "574.3274",
                                "intensity": "52955.93",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "24",
                                "monoisotopic_mass": "4596.5419",
                                "monoisotopic_mz": "575.5750",
                                "intensity": "57029.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "25",
                                "monoisotopic_mass": "596.3516",
                                "monoisotopic_mz": "597.3589",
                                "intensity": "73786.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "26",
                                "monoisotopic_mass": "1476.9019",
                                "monoisotopic_mz": "370.2328",
                                "intensity": "33068.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "27",
                                "monoisotopic_mass": "3812.1206",
                                "monoisotopic_mz": "545.5959",
                                "intensity": "41123.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "28",
                                "monoisotopic_mass": "2930.5510",
                                "monoisotopic_mz": "733.6450",
                                "intensity": "41534.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "29",
                                "monoisotopic_mass": "2912.5417",
                                "monoisotopic_mz": "583.5156",
                                "intensity": "33362.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "30",
                                "monoisotopic_mass": "4735.6084",
                                "monoisotopic_mz": "677.5228",
                                "intensity": "65582.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "31",
                                "monoisotopic_mass": "4755.6223",
                                "monoisotopic_mz": "529.4098",
                                "intensity": "30815.03",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-142.1135158038",
                                        "theoretical_mass": "4755.6233",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "32",
                                "monoisotopic_mass": "1610.9489",
                                "monoisotopic_mz": "537.9902",
                                "intensity": "39297.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9621",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0132",
                                        "ppm": "-8.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "33",
                                "monoisotopic_mass": "4092.3538",
                                "monoisotopic_mz": "683.0662",
                                "intensity": "31171.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "34",
                                "monoisotopic_mass": "2596.4253",
                                "monoisotopic_mz": "650.1136",
                                "intensity": "27492.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "35",
                                "monoisotopic_mass": "1430.8979",
                                "monoisotopic_mz": "358.7318",
                                "intensity": "24939.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "36",
                                "monoisotopic_mass": "1318.8326",
                                "monoisotopic_mz": "440.6181",
                                "intensity": "24389.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "37",
                                "monoisotopic_mass": "5131.8792",
                                "monoisotopic_mz": "571.2161",
                                "intensity": "34795.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "38",
                                "monoisotopic_mass": "4682.6091",
                                "monoisotopic_mz": "586.3334",
                                "intensity": "24465.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "39",
                                "monoisotopic_mass": "2947.5552",
                                "monoisotopic_mz": "737.8961",
                                "intensity": "27251.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "40",
                                "monoisotopic_mass": "4052.2590",
                                "monoisotopic_mz": "579.9014",
                                "intensity": "15134.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "41",
                                "monoisotopic_mass": "4791.6447",
                                "monoisotopic_mz": "599.9629",
                                "intensity": "85326.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "42",
                                "monoisotopic_mass": "879.5184",
                                "monoisotopic_mz": "440.7665",
                                "intensity": "20017.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "43",
                                "monoisotopic_mass": "1387.8551",
                                "monoisotopic_mz": "463.6256",
                                "intensity": "16977.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "44",
                                "monoisotopic_mass": "2178.3054",
                                "monoisotopic_mz": "199.0350",
                                "intensity": "26494.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "45",
                                "monoisotopic_mass": "1155.2415",
                                "monoisotopic_mz": "578.6281",
                                "intensity": "17297.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "46",
                                "monoisotopic_mass": "4093.3549",
                                "monoisotopic_mz": "585.7723",
                                "intensity": "32992.63",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0343",
                                        "ppm": "-8.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "47",
                                "monoisotopic_mass": "1249.8082",
                                "monoisotopic_mz": "625.9114",
                                "intensity": "19038.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "48",
                                "monoisotopic_mass": "2983.1006",
                                "monoisotopic_mz": "597.6274",
                                "intensity": "55732.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "49",
                                "monoisotopic_mass": "1308.8498",
                                "monoisotopic_mz": "328.2197",
                                "intensity": "21774.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "50",
                                "monoisotopic_mass": "1338.8210",
                                "monoisotopic_mz": "670.4178",
                                "intensity": "24690.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "51",
                                "monoisotopic_mass": "3794.0789",
                                "monoisotopic_mz": "543.0185",
                                "intensity": "36102.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "52",
                                "monoisotopic_mass": "1448.9089",
                                "monoisotopic_mz": "363.2345",
                                "intensity": "14035.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "53",
                                "monoisotopic_mass": "1102.6141",
                                "monoisotopic_mz": "552.3143",
                                "intensity": "22619.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "54",
                                "monoisotopic_mass": "4114.5241",
                                "monoisotopic_mz": "588.7964",
                                "intensity": "53091.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "55",
                                "monoisotopic_mass": "1475.4964",
                                "monoisotopic_mz": "492.8394",
                                "intensity": "11447.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "56",
                                "monoisotopic_mass": "1494.9108",
                                "monoisotopic_mz": "374.7350",
                                "intensity": "13376.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "57",
                                "monoisotopic_mass": "2377.6485",
                                "monoisotopic_mz": "199.1447",
                                "intensity": "82987.71",
                                "charge": "12"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "58",
                                "monoisotopic_mass": "5713.6249",
                                "monoisotopic_mz": "572.3698",
                                "intensity": "28410.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "59",
                                "monoisotopic_mass": "1371.7802",
                                "monoisotopic_mz": "458.2673",
                                "intensity": "13147.06",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "63",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6267.5169",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "42",
                                        "spec_id": "202",
                                        "peak_id": "14",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "spec_id": "202",
                                        "peak_id": "0",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "39",
                                        "spec_id": "202",
                                        "peak_id": "8",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "spec_id": "202",
                                        "peak_id": "46",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "spec_id": "202",
                                        "peak_id": "16",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "202",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "202",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "202",
                                        "peak_id": "32",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "202",
                                            "peak_id": "31",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "202",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "15",
                            "anno": "-142.1135",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "151",
                "p_value": "5.66e-05",
                "e_value": "5.66e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000203",
                        "ms1_scans": "402",
                        "ids": "1000198",
                        "scans": "403",
                        "precursor_mono_mass": "6266.5260",
                        "precursor_charge": "10",
                        "precursor_mz": "627.6599",
                        "feature_inte": "2.3840e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000198",
                                "peak_id": "0",
                                "monoisotopic_mass": "6036.3812",
                                "monoisotopic_mz": "671.7163",
                                "intensity": "98437.15",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6037.4474",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0638",
                                        "ppm": "-10.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "1",
                                "monoisotopic_mass": "1789.0552",
                                "monoisotopic_mz": "597.3590",
                                "intensity": "114647.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4717",
                                "monoisotopic_mz": "635.7889",
                                "intensity": "85502.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "3",
                                "monoisotopic_mass": "4825.6612",
                                "monoisotopic_mz": "690.3875",
                                "intensity": "70038.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "4",
                                "monoisotopic_mass": "6120.4253",
                                "monoisotopic_mz": "681.0545",
                                "intensity": "66139.17",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "5",
                                "monoisotopic_mass": "1660.9620",
                                "monoisotopic_mz": "831.4883",
                                "intensity": "93036.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "6",
                                "monoisotopic_mass": "2449.3428",
                                "monoisotopic_mz": "817.4549",
                                "intensity": "49043.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "7",
                                "monoisotopic_mass": "6164.4673",
                                "monoisotopic_mz": "685.9481",
                                "intensity": "45607.43",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6165.5423",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0726",
                                        "ppm": "-11.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "8",
                                "monoisotopic_mass": "4442.4699",
                                "monoisotopic_mz": "741.4189",
                                "intensity": "57190.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "9",
                                "monoisotopic_mass": "4458.4706",
                                "monoisotopic_mz": "637.9316",
                                "intensity": "32659.65",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "10",
                                "monoisotopic_mass": "1547.8806",
                                "monoisotopic_mz": "774.9476",
                                "intensity": "58170.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "11",
                                "monoisotopic_mass": "2286.2808",
                                "monoisotopic_mz": "763.1009",
                                "intensity": "35925.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "12",
                                "monoisotopic_mass": "4737.5927",
                                "monoisotopic_mz": "790.6061",
                                "intensity": "35733.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "13",
                                "monoisotopic_mass": "4824.6538",
                                "monoisotopic_mz": "805.1162",
                                "intensity": "38292.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "14",
                                "monoisotopic_mass": "6053.3853",
                                "monoisotopic_mz": "673.6056",
                                "intensity": "61935.66",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "15",
                                "monoisotopic_mass": "4753.6184",
                                "monoisotopic_mz": "793.2770",
                                "intensity": "35127.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "16",
                                "monoisotopic_mass": "4808.6705",
                                "monoisotopic_mz": "687.9602",
                                "intensity": "22515.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "17",
                                "monoisotopic_mass": "4403.4812",
                                "monoisotopic_mz": "734.9208",
                                "intensity": "34187.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4403.5210",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0398",
                                        "ppm": "-9.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "18",
                                "monoisotopic_mass": "1980.8697",
                                "monoisotopic_mz": "199.0942",
                                "intensity": "25087.80",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "19",
                                "monoisotopic_mass": "587.3589",
                                "monoisotopic_mz": "588.3662",
                                "intensity": "30044.67",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0054",
                                        "ppm": "-9.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "20",
                                "monoisotopic_mass": "1807.0657",
                                "monoisotopic_mz": "904.5401",
                                "intensity": "22055.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0833",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0176",
                                        "ppm": "-9.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "21",
                                "monoisotopic_mass": "2596.4166",
                                "monoisotopic_mz": "866.4795",
                                "intensity": "50247.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "22",
                                "monoisotopic_mass": "815.4694",
                                "monoisotopic_mz": "408.7420",
                                "intensity": "49048.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "23",
                                "monoisotopic_mass": "1660.9658",
                                "monoisotopic_mz": "554.6625",
                                "intensity": "19167.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "24",
                                "monoisotopic_mass": "878.5144",
                                "monoisotopic_mz": "879.5217",
                                "intensity": "28472.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0082",
                                        "ppm": "-9.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "25",
                                "monoisotopic_mass": "4255.4169",
                                "monoisotopic_mz": "710.2434",
                                "intensity": "26969.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "26",
                                "monoisotopic_mass": "4229.3226",
                                "monoisotopic_mz": "705.8944",
                                "intensity": "28521.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "27",
                                "monoisotopic_mass": "4999.7682",
                                "monoisotopic_mz": "715.2599",
                                "intensity": "25010.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "28",
                                "monoisotopic_mass": "1249.8127",
                                "monoisotopic_mz": "417.6115",
                                "intensity": "24716.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "29",
                                "monoisotopic_mass": "991.5985",
                                "monoisotopic_mz": "992.6058",
                                "intensity": "19887.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6067",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0082",
                                        "ppm": "-8.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "30",
                                "monoisotopic_mass": "4053.2825",
                                "monoisotopic_mz": "676.5544",
                                "intensity": "32780.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "31",
                                "monoisotopic_mass": "1037.6609",
                                "monoisotopic_mz": "519.8377",
                                "intensity": "24685.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "32",
                                "monoisotopic_mass": "1164.7607",
                                "monoisotopic_mz": "583.3876",
                                "intensity": "22125.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "33",
                                "monoisotopic_mass": "6148.4605",
                                "monoisotopic_mz": "684.1696",
                                "intensity": "18224.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "34",
                                "monoisotopic_mass": "1995.1063",
                                "monoisotopic_mz": "666.0427",
                                "intensity": "22799.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "35",
                                "monoisotopic_mass": "2947.5543",
                                "monoisotopic_mz": "983.5254",
                                "intensity": "21368.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "36",
                                "monoisotopic_mass": "3019.5980",
                                "monoisotopic_mz": "755.9068",
                                "intensity": "20292.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "37",
                                "monoisotopic_mass": "4341.3879",
                                "monoisotopic_mz": "724.5719",
                                "intensity": "14255.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "38",
                                "monoisotopic_mass": "715.4526",
                                "monoisotopic_mz": "716.4598",
                                "intensity": "13799.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "715.4593",
                                        "ion_position": "49",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0067",
                                        "ppm": "-9.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "39",
                                "monoisotopic_mass": "3993.2147",
                                "monoisotopic_mz": "666.5431",
                                "intensity": "24657.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "40",
                                "monoisotopic_mass": "2046.1752",
                                "monoisotopic_mz": "683.0657",
                                "intensity": "15907.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "41",
                                "monoisotopic_mass": "2068.1555",
                                "monoisotopic_mz": "690.3924",
                                "intensity": "17427.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "42",
                                "monoisotopic_mass": "928.5530",
                                "monoisotopic_mz": "465.2838",
                                "intensity": "19678.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "43",
                                "monoisotopic_mass": "928.5545",
                                "monoisotopic_mz": "929.5618",
                                "intensity": "19497.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "44",
                                "monoisotopic_mass": "1091.6123",
                                "monoisotopic_mz": "546.8134",
                                "intensity": "13512.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "45",
                                "monoisotopic_mass": "3686.4363",
                                "monoisotopic_mz": "738.2945",
                                "intensity": "12742.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "46",
                                "monoisotopic_mass": "1359.3220",
                                "monoisotopic_mz": "680.6683",
                                "intensity": "8698.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "47",
                                "monoisotopic_mass": "1642.9564",
                                "monoisotopic_mz": "822.4855",
                                "intensity": "36522.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "48",
                                "monoisotopic_mass": "1374.3262",
                                "monoisotopic_mz": "688.1704",
                                "intensity": "16014.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "49",
                                "monoisotopic_mass": "1316.8156",
                                "monoisotopic_mz": "439.9458",
                                "intensity": "9674.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "50",
                                "monoisotopic_mass": "4384.4455",
                                "monoisotopic_mz": "731.7482",
                                "intensity": "19592.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "51",
                                "monoisotopic_mass": "4357.4107",
                                "monoisotopic_mz": "727.2424",
                                "intensity": "26735.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "52",
                                "monoisotopic_mass": "3192.6644",
                                "monoisotopic_mz": "799.1734",
                                "intensity": "24767.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "53",
                                "monoisotopic_mass": "716.4015",
                                "monoisotopic_mz": "359.2080",
                                "intensity": "15054.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "54",
                                "monoisotopic_mass": "4714.1530",
                                "monoisotopic_mz": "674.4577",
                                "intensity": "21656.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "55",
                                "monoisotopic_mass": "2948.5596",
                                "monoisotopic_mz": "738.1472",
                                "intensity": "33820.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "56",
                                "monoisotopic_mass": "1429.1905",
                                "monoisotopic_mz": "715.6025",
                                "intensity": "12078.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "57",
                                "monoisotopic_mass": "682.6080",
                                "monoisotopic_mz": "683.6153",
                                "intensity": "9831.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "58",
                                "monoisotopic_mass": "732.4125",
                                "monoisotopic_mz": "733.4198",
                                "intensity": "20368.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "59",
                                "monoisotopic_mass": "1452.8369",
                                "monoisotopic_mz": "727.4257",
                                "intensity": "12887.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "60",
                                "monoisotopic_mass": "1678.9580",
                                "monoisotopic_mz": "840.4863",
                                "intensity": "23427.58",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "63",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6266.7110",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "spec_id": "1000198",
                                        "peak_id": "7",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "spec_id": "1000198",
                                        "peak_id": "0",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "spec_id": "1000198",
                                        "peak_id": "17",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "spec_id": "1000198",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "1000198",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000198",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "49",
                                        "ion_display_position": "6",
                                        "spec_id": "1000198",
                                        "peak_id": "38",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "spec_id": "1000198",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "2",
                            "anno": "-100.9089",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "162",
                "p_value": "7.25e-05",
                "e_value": "7.25e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000250",
                        "ms1_scans": "496",
                        "ids": "1000245",
                        "scans": "497",
                        "precursor_mono_mass": "6266.4192",
                        "precursor_charge": "10",
                        "precursor_mz": "627.6492",
                        "feature_inte": "9.1151e+04"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000245",
                                "peak_id": "0",
                                "monoisotopic_mass": "1789.0548",
                                "monoisotopic_mz": "597.3589",
                                "intensity": "167822.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "1",
                                "monoisotopic_mass": "6037.3892",
                                "monoisotopic_mz": "671.8283",
                                "intensity": "61056.28",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6037.4474",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0582",
                                        "ppm": "-9.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "2",
                                "monoisotopic_mass": "1660.9602",
                                "monoisotopic_mz": "831.4874",
                                "intensity": "42095.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "3",
                                "monoisotopic_mass": "6148.4624",
                                "monoisotopic_mz": "684.1698",
                                "intensity": "35348.24",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "4",
                                "monoisotopic_mass": "4403.4800",
                                "monoisotopic_mz": "734.9206",
                                "intensity": "27656.55",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4403.5210",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0409",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "5",
                                "monoisotopic_mass": "2595.4178",
                                "monoisotopic_mz": "866.1465",
                                "intensity": "24771.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "6",
                                "monoisotopic_mass": "1249.8129",
                                "monoisotopic_mz": "417.6116",
                                "intensity": "20754.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "7",
                                "monoisotopic_mass": "4826.6545",
                                "monoisotopic_mz": "805.4497",
                                "intensity": "20592.24",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0531",
                                        "ppm": "-11.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "8",
                                "monoisotopic_mass": "1547.8791",
                                "monoisotopic_mz": "774.9468",
                                "intensity": "21419.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "9",
                                "monoisotopic_mass": "2449.3423",
                                "monoisotopic_mz": "817.4547",
                                "intensity": "26903.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "10",
                                "monoisotopic_mass": "4358.4186",
                                "monoisotopic_mz": "727.4104",
                                "intensity": "31110.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "11",
                                "monoisotopic_mass": "4754.6295",
                                "monoisotopic_mz": "793.4455",
                                "intensity": "23876.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "12",
                                "monoisotopic_mass": "2285.2852",
                                "monoisotopic_mz": "762.7690",
                                "intensity": "17411.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "13",
                                "monoisotopic_mass": "6165.4877",
                                "monoisotopic_mz": "686.0615",
                                "intensity": "45968.68",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6165.5423",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0546",
                                        "ppm": "-8.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "14",
                                "monoisotopic_mass": "1164.7611",
                                "monoisotopic_mz": "583.3878",
                                "intensity": "19430.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "15",
                                "monoisotopic_mass": "2069.1626",
                                "monoisotopic_mz": "690.7281",
                                "intensity": "13759.26",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2069.1786",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0160",
                                        "ppm": "-7.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "16",
                                "monoisotopic_mass": "4229.3090",
                                "monoisotopic_mz": "705.8921",
                                "intensity": "19983.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "17",
                                "monoisotopic_mass": "1642.9488",
                                "monoisotopic_mz": "822.4817",
                                "intensity": "15502.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "18",
                                "monoisotopic_mass": "4738.5969",
                                "monoisotopic_mz": "790.7734",
                                "intensity": "19493.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "19",
                                "monoisotopic_mass": "878.5146",
                                "monoisotopic_mz": "879.5218",
                                "intensity": "16703.93",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0080",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "20",
                                "monoisotopic_mass": "4443.4712",
                                "monoisotopic_mz": "741.5858",
                                "intensity": "27624.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "21",
                                "monoisotopic_mass": "1709.9992",
                                "monoisotopic_mz": "856.0069",
                                "intensity": "20703.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "22",
                                "monoisotopic_mass": "2197.2533",
                                "monoisotopic_mz": "733.4250",
                                "intensity": "12894.14",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2197.2736",
                                        "ion_position": "37",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "37",
                                        "mass_error": "-0.0203",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "23",
                                "monoisotopic_mass": "928.5514",
                                "monoisotopic_mz": "465.2830",
                                "intensity": "13593.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "24",
                                "monoisotopic_mass": "2041.4811",
                                "monoisotopic_mz": "681.5010",
                                "intensity": "15404.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "25",
                                "monoisotopic_mass": "1037.6598",
                                "monoisotopic_mz": "519.8372",
                                "intensity": "13990.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "26",
                                "monoisotopic_mass": "5000.7008",
                                "monoisotopic_mz": "715.3931",
                                "intensity": "14892.73",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5000.7717",
                                        "ion_position": "12",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0708",
                                        "ppm": "-14.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "27",
                                "monoisotopic_mass": "6018.3679",
                                "monoisotopic_mz": "669.7148",
                                "intensity": "24236.35",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "28",
                                "monoisotopic_mass": "815.4705",
                                "monoisotopic_mz": "408.7425",
                                "intensity": "19080.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "29",
                                "monoisotopic_mass": "5158.8660",
                                "monoisotopic_mz": "737.9881",
                                "intensity": "22313.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "30",
                                "monoisotopic_mass": "6122.4303",
                                "monoisotopic_mz": "681.2773",
                                "intensity": "11657.65",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "31",
                                "monoisotopic_mass": "716.4027",
                                "monoisotopic_mz": "717.4100",
                                "intensity": "16000.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "32",
                                "monoisotopic_mass": "1980.9483",
                                "monoisotopic_mz": "199.1021",
                                "intensity": "15634.30",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "33",
                                "monoisotopic_mass": "1351.4306",
                                "monoisotopic_mz": "676.7226",
                                "intensity": "10888.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "34",
                                "monoisotopic_mass": "680.7169",
                                "monoisotopic_mz": "681.7242",
                                "intensity": "17009.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "35",
                                "monoisotopic_mass": "928.5511",
                                "monoisotopic_mz": "929.5583",
                                "intensity": "6768.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "36",
                                "monoisotopic_mass": "1150.7433",
                                "monoisotopic_mz": "576.3789",
                                "intensity": "9678.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "37",
                                "monoisotopic_mass": "990.9242",
                                "monoisotopic_mz": "199.1921",
                                "intensity": "6957.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "38",
                                "monoisotopic_mass": "5448.1602",
                                "monoisotopic_mz": "682.0273",
                                "intensity": "6468.96",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "39",
                                "monoisotopic_mass": "1474.2832",
                                "monoisotopic_mz": "738.1489",
                                "intensity": "7064.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000245",
                                "peak_id": "40",
                                "monoisotopic_mass": "569.3473",
                                "monoisotopic_mz": "570.3546",
                                "intensity": "9794.31",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "63",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6266.6042",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "spec_id": "1000245",
                                        "peak_id": "13",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "spec_id": "1000245",
                                        "peak_id": "1",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "12",
                                        "ion_display_position": "43",
                                        "spec_id": "1000245",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "spec_id": "1000245",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "spec_id": "1000245",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "18",
                                        "spec_id": "1000245",
                                        "peak_id": "22",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "spec_id": "1000245",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000245",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "2",
                            "anno": "-101.0157",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
